---
name: r.surf.random
description: Produces a raster surface map of uniform random deviates with defined range.
keywords: [ raster, surface, random ]
---

# r.surf.random

Produces a raster surface map of uniform random deviates with defined range.

=== "Command line"

    **r.surf.random**
    [**-i**]
    **output**=*name*
    [**min**=*float*]
    [**max**=*float*]
    [**seed**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.surf.random output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.surf.random***",
        **output**,
        **min**=*0*,
        **max**=*100*,
        **seed**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.surf.random", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_surf_random*(**output**,
        **min**=*0*,
        **max**=*100*,
        **seed**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_surf_random(output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **min**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum random value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **max**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum random value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed value for the random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;Using the same seed ensures identical results, while a randomly generated seed produces different outcomes in each run.  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create an integer raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **min** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum random value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **max** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum random value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed value for the random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;Using the same seed ensures identical results, while a randomly generated seed produces different outcomes in each run.  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create an integer raster map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **min** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum random value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **max** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum random value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed value for the random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;Using the same seed ensures identical results, while a randomly generated seed produces different outcomes in each run.  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create an integer raster map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

**r.surf.random** produces a raster map layer of uniform random deviates
whose range can be expressed by the user. It is essentially the same as
*r.surf.gauss*, but uses a linear random number generator instead. It
uses the random number generator drand48() or rand(), depending on the
user's platform.

## EXAMPLE

```sh
g.region -p n=228500 s=215000 w=630000 e=645000 res=10
r.surf.random out=random min=0 max=100

# check result
r.univar random
```

![r.random.surface example (min: 10; max: 100)](r_surf_random.jpg)  
*Figure: Random surface example (min: 10; max: 100)*

With the histogram tool the cell values versus count can be shown.

![r.random.surface example histogram (min: 10; max: 100)](r_surf_random_hist.png)  
*Figure: Histogram of random surface example (min: 10; max: 100)*

## SEE ALSO

*[r.random.surface](r.random.surface.md),
[r.surf.contour](r.surf.contour.md),
[r.surf.fractal](r.surf.fractal.md), [r.surf.gauss](r.surf.gauss.md),
[r.surf.idw](r.surf.idw.md), [v.surf.rst](v.surf.rst.md)*

## AUTHOR

Jo Wood  
Midlands Regional Research Laboratory (ASSIST)  
University of Leicester  
*October 1991*

## SOURCE CODE

Available at: [r.surf.random source code](https://github.com/OSGeo/grass/tree/main/raster/r.surf.random)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.surf.random))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
