---
name: r3.in.ascii
description: Converts a 3D ASCII raster text file into a (binary) 3D raster map.
keywords: [ raster3d, import, voxel, conversion, ASCII ]
---

# r3.in.ascii

Converts a 3D ASCII raster text file into a (binary) 3D raster map.

=== "Command line"

    **r3.in.ascii**
    **input**=*name*
    **output**=*name*
    [**null_value**=*string*]
    [**type**=*string*]
    [**precision**=*string*]
    [**compression**=*string*]
    [**tiledimension**=*XxYxZ*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.in.ascii input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.in.ascii***",
        **input**,
        **output**,
        **null_value**=*"\*"*,
        **type**=*"default"*,
        **precision**=*"default"*,
        **compression**=*"default"*,
        **tiledimension**=*"default"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.in.ascii", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_in_ascii*(**input**,
        **output**,
        **null_value**=*"\*"*,
        **type**=*"default"*,
        **precision**=*"default"*,
        **compression**=*"default"*,
        **tiledimension**=*"default"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_in_ascii(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    **null_value**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value data cell (use 'none' if no such value)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type used in the output raster3d map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, double, float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **precision**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of digits used as mantissa in the internal map storage, 0 -23 for float, 0 - 52 for double, max or default  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **compression**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The compression method used in the output raster3d map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, zip, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **tiledimension**=*XxYxZ*  
    &nbsp;&nbsp;&nbsp;&nbsp;The dimensions of the tiles used in the output raster3d map (XxYxZ or default: 16x16x8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value data cell (use 'none' if no such value)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type used in the output raster3d map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, double, float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **precision** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of digits used as mantissa in the internal map storage, 0 -23 for float, 0 - 52 for double, max or default  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **compression** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The compression method used in the output raster3d map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, zip, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **tiledimension** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The dimensions of the tiles used in the output raster3d map (XxYxZ or default: 16x16x8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *XxYxZ*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value data cell (use 'none' if no such value)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type used in the output raster3d map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, double, float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **precision** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of digits used as mantissa in the internal map storage, 0 -23 for float, 0 - 52 for double, max or default  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **compression** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The compression method used in the output raster3d map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *default, zip, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **tiledimension** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The dimensions of the tiles used in the output raster3d map (XxYxZ or default: 16x16x8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *XxYxZ*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *default*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r3.in.ascii* allows a user to create a (binary) GRASS 3D raster map
layer from a 3D ASCII raster input file.

The *tiledimension* parameter defines the dimension of the tiles used in
the output file. The format is: XxYxZ

The *nv* parameter specifies which value to convert to NULL-value. If
the specified value is *none*, no conversion is performed. Default is
*none*.

## NOTES

The data is automatically imported into the correct internal coordinate
system, that is visualized in the following picture, independently from
the specified ordering in the ASCII input file:

![The volume coordinate system and tile layout](raster3d_layout.png)  
*The volume coordinate system and tile layout of the imported voxel map*

### Format

The format of the 3D ASCII file:

```sh
version: "grass7"
order:   "nsbt" or "nstb" or "snbt" or "sntb"
north:   floating point
south:   floating point
east:    floating point
west:    floating point
top:     floating point
bottom:  floating point
rows:    integer
cols:    integer
levels:  integer
```

The version and order option have been introduced in GRASS 7 in June
2011. The version option is self explaining. The order option specifies
the row and depth order of the data in the input file. The supported
row/depth ordering is documented in the *r3.out.ascii* manual page. The
order of the data in the input file does not specify the data order in
the generated output 3D raster map which is in any case *north -\>
south, west -\> east, bottom -\> top* order. So dependent on the order
information the data is automatically imported into the correct internal
coordinate system.

The version and order options are not mandatory. In case no version and
order option is specified, the default GRASS 6 ASCII format is assumed.

This header is followed by the cell values in *floating point* format
organized in rows with constant *col* and *level* coordinate. The rows
are organized by constant *level* coordinate. Individual cell values are
separated by *space* or *CR*.

## EXAMPLES

4x3x2 sample. Note in case no specific ordering is specified in the
input file the upper-left (NW) corner of the bottom level comes first.
The according order option is: nsbt for north -\> south, bottom -\> top
ordering. This is identical with *r.in.ascii* for single level data. So
the y coordinate is 0 at the northern edge.

```sh
north: 3.0  
south: 0.0  
east: 4.0  
west: 0.0  
top: 2.0  
bottom: 0.0  
rows: 3  
cols: 4  
levels: 2  
x1,y1,z1 x2,y1,z1 x3,y1,z1 x4,y1,z1
x1,y2,z1 x2,y2,z1 x3,y2,z1 x4,y2,z1
x1,y3,z1 x2,y3,z1 x3,y3,z1 x4,y3,z1
x1,y1,z2 x2,y1,z2 x3,y1,z2 x4,y1,z2
x1,y2,z2 x2,y2,z2 x3,y2,z2 x4,y2,z2
x1,y3,z2 x2,y3,z2 x3,y3,z2 x4,y3,z2
```

Note that unit tests for *r3.in.ascii* are implemented in the
*test.r3.out.ascii.sh* script located in the *r3.out.ascii* directory.

Please also refer to the detailed examples in
[r3.out.ascii](r3.out.ascii.md).

## SEE ALSO

*[r.in.ascii](r.in.ascii.md), [r3.out.ascii](r3.out.ascii.md),
[v.to.rast3](v.to.rast3.md), [g.region](g.region.md)*

## AUTHORS

Roman Waupotitsch, Michael Shapiro, Helena Mitasova, Bill Brown, Lubos
Mitas, Jaro Hofierka, Sören Gebbert

## SOURCE CODE

Available at: [r3.in.ascii source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.in.ascii)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.in.ascii))  
Latest change: Tuesday Feb 18 17:20:26 2025 in commit [688e625](https://github.com/OSGeo/grass/commit/688e625e7db3be9a465ce99ba25f36d2ebdd5aeb)
