---
name: t.remove.py
description: Removes space time datasets from temporal database.
keywords: [ temporal, map management, remove, time ]
---

# t.remove.py

Removes space time datasets from temporal database.

=== "Command line"

    **t.remove.py**
    [**-rfd**]
    [**inputs**=*name* [,*name*,...]]
    [**type**=*string*]
    [**file**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.remove.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.remove.py***",
        **inputs**=*None*,
        **type**=*"strds"*,
        **file**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.remove.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_remove_py*(**inputs**=*None*,
        **type**=*"strds"*,
        **file**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_remove_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **inputs**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time datasets  
    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the space time dataset, default is strds  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds,  str3ds,  stvds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with dataset names, one per line  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove stds and unregister maps from temporal database  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force removal (required for actual deletion of files)  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove stds, unregister maps from temporal database and delete them from mapset  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **inputs** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the space time dataset, default is strds  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds,  str3ds,  stvds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with dataset names, one per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *f*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove stds and unregister maps from temporal database  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force removal (required for actual deletion of files)  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove stds, unregister maps from temporal database and delete them from mapset  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **inputs** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the space time dataset, default is strds  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds,  str3ds,  stvds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **file** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with dataset names, one per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *f*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove stds and unregister maps from temporal database  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force removal (required for actual deletion of files)  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove stds, unregister maps from temporal database and delete them from mapset  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The module *t.remove* removes space time datasets (STRDS, STR3DS, STVDS)
from the temporal database. In other words, by default it deletes the
relevant database entries. It can also unregister maps from temporal
database using the recursive mode **-r** (recursive).

Optionally, also the raster, 3D raster and vector maps of the space time
datasets can be removed from the current mapset using the **-d**
(delete) flag. All removals only work if **-f** (force) flag is used.

## EXAMPLE

In this example a space time raster dataset (STRDS) named
**precip_months_sum** will be created using a subset of the monthly
precipitation raster maps from the North Carolina climate sample data
set.  
In order to be able to show the case of recursive removal without
deleting the original sample data, we generate new data by means of
computing yearly precipitation sums. Eventually, all newly produced data
(STRDS and raster maps) are removed:

```sh
# Create new and empty STRDS
t.create output=precip_months_sum semantictype=mean \
  title="Monthly sum of precipitation" \
  description="Monthly sum of precipitation for the \
  North Carolina sample data"

# Register maps from sample dataset (selecting a subset with g.list)
t.register -i type=raster input=precip_months_sum \
  maps=$(g.list type=raster pattern="201*_precip" separator=comma) \
  start="2010-01-01" increment="1 months"

# Create some new data by aggregating with 1 years granularity
t.rast.aggregate input=precip_months_sum \
  output=precip_years_sum basename=precip_years_sum \
  granularity="1 years" method=sum

# Remove all newly produced data:

# a) the aggregated STRDS with 1 years granularity along with its raster maps
t.remove -df type=strds input=precip_years_sum

# b) the STRDS with 1 months granularity, but not the original sample data
t.remove -f type=strds input=precip_months_sum
```

## SEE ALSO

*[t.create](t.create.md), [t.info](t.info.md),
[t.register](t.register.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.remove source code](https://github.com/OSGeo/grass/tree/main/temporal/t.remove)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.remove))  
Latest change: Thursday Dec 18 07:11:47 2025 in commit [cf870a5](https://github.com/OSGeo/grass/commit/cf870a5e49fd2643a55de543467edf5c2e61d640)
