---
hide:
  - toc
---

# Topic: attribute table

| Tool | Description |
|--------|-------------|
| [db.columns](db.columns.md) | List all columns for a given table. |
| [db.connect](db.connect.md) | Prints/sets general DB connection for current mapset. |
| [db.copy](db.copy.md) | Copy a table. Either 'from_table' (optionally with 'where') can be used or 'select' option, but not 'from_table' and 'select' at the same time. |
| [db.createdb](db.createdb.md) | Creates an empty database. |
| [db.databases](db.databases.md) | Lists all databases for a given driver and location. |
| [db.dropcolumn](db.dropcolumn.md) | Drops a column from selected attribute table. |
| [db.dropdb](db.dropdb.md) | Removes an existing database. |
| [db.droptable](db.droptable.md) | Drops an attribute table. |
| [db.execute](db.execute.md) | Executes any SQL statement. For SELECT statements use 'db.select'. |
| [db.select](db.select.md) | Selects data from attribute table. Performs SQL query statement(s). |
| [db.tables](db.tables.md) | Lists all tables for a given database. |
| [db.test](db.test.md) | Test database driver, database must exist and set by db.connect. |
| [t.vect.db.select](t.vect.db.select.md) | Prints attributes of vector maps registered in a space time vector dataset. |
| [v.db.addcolumn](v.db.addcolumn.md) | Adds one or more columns to the attribute table connected to a given vector map. |
| [v.db.addtable](v.db.addtable.md) | Creates and connects a new attribute table to a given layer of an existing vector map. |
| [v.db.connect](v.db.connect.md) | Prints/sets DB connection for a vector map to attribute table. |
| [v.db.dropcolumn](v.db.dropcolumn.md) | Drops a column from the attribute table connected to a given vector map. |
| [v.db.droprow](v.db.droprow.md) | Removes a vector feature from a vector map through attribute selection. |
| [v.db.droptable](v.db.droptable.md) | Removes existing attribute table of a vector map. |
| [v.db.join](v.db.join.md) | Joins a database table to a vector map table. |
| [v.db.reconnect.all](v.db.reconnect.all.md) | Reconnects attribute tables for all vector maps from the current mapset to a new database. |
| [v.db.renamecolumn](v.db.renamecolumn.md) | Renames a column in the attribute table connected to a given vector map. |
| [v.db.select](v.db.select.md) | Prints vector map attributes. |
| [v.db.update](v.db.update.md) | Updates a column in the attribute table connected to a vector map. |
| [v.to.db](v.to.db.md) | Populates attribute values from vector features. |
| [v.vect.stats](v.vect.stats.md) | Count points in areas, calculate statistics from point attributes. |

*See also the corresponding keyword for additional references:*

<!-- topic_keyword { include: [attribute table] } -->
