---
name: v.in.region
description: Creates a vector polygon from the current region extent.
keywords: [ vector, geometry ]
---

# v.in.region

Creates a vector polygon from the current region extent.

=== "Command line"

    **v.in.region**
    [**-d**]
    **output**=*name*
    [**type**=*string*]
    [**cat**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.region output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.region***",
        **output**,
        **type**=*"area"*,
        **cat**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.region", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_region*(**output**,
        **type**=*"area"*,
        **cat**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_region(output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select type: line or area  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area*  
    **cat**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Densify lines using region resolution  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select type: line or area  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area*  
    **cat** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Densify lines using region resolution  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select type: line or area  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area*  
    **cat** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Densify lines using region resolution  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.region* creates a new vector map from current region extent.

If the output of *v.in.region* is to be used for raster reprojection,
the **-d** flag should be used after setting the region to the raster
map to be reprojected with *[r.proj](r.proj.md)*.

## EXAMPLE

The example is based on the North Carolina sample data. To create a
bounding box vector map based on a raster map, the computational region
is first set to the raster map. Then a vector bounding box is created
based on the actual computational region (in this case precisely
reflecting the pixel geometry of the raster map), resulting in a new
vector polygon:

```sh
g.region raster=soils_Kfactor -p
v.in.region output=soils_Kfactor_bbox
v.info map=soils_Kfactor_bbox
```

## SEE ALSO

*[g.region](g.region.md), [r.proj](r.proj.md), [v.info](v.info.md)*

## AUTHOR

Radim Blazek

## SOURCE CODE

Available at: [v.in.region source code](https://github.com/OSGeo/grass/tree/main/vector/v.in.region)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.in.region))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
