---
name: v.out.ascii
description: Exports a vector map to a GRASS ASCII vector representation. By default only features with category are exported. To export all features use 'layer=-1'.
keywords: [ vector, export, output, ASCII ]
---

# v.out.ascii

Exports a vector map to a GRASS ASCII vector representation.

By default only features with category are exported. To export all features use 'layer=-1'.

=== "Command line"

    **v.out.ascii**
    [**-ocr**]
    **input**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    [**output**=*name*]
    [**columns**=*name* [,*name*,...]]
    [**cats**=*range*]
    [**where**=*sql_query*]
    **format**=*string*
    [**separator**=*character*]
    [**precision**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.out.ascii input=name format=point
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.out.ascii***",
        **input**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid,area,face,kernel"*,
        **output**=*None*,
        **columns**=*None*,
        **cats**=*None*,
        **where**=*None*,
        **format**=*"point"*,
        **separator**=*"pipe"*,
        **precision**=*8*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.out.ascii", input="name", format="point")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_out_ascii*(**input**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid,area,face,kernel"*,
        **output**=*None*,
        **columns**=*None*,
        **cats**=*None*,
        **where**=*None*,
        **format**=*"point"*,
        **separator**=*"pipe"*,
        **precision**=*8*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_out_ascii(input="name", format="point")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area,face,kernel*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output ASCII file or ASCII vector name if '-o' is defined  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given or '-' then standard output  
    **columns**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) to be exported (point mode)  
    &nbsp;&nbsp;&nbsp;&nbsp;"\*" for all columns  
    **cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **format**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, standard, wkt*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point*  
    &nbsp;&nbsp;&nbsp;&nbsp;**point**: Simple point format (point per row)  
    &nbsp;&nbsp;&nbsp;&nbsp;**standard**: GRASS ASCII vector format  
    &nbsp;&nbsp;&nbsp;&nbsp;**wkt**: OGC well-known text  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator (points mode)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **precision**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits (floating point only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-32*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create old (version 4) ASCII file  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Include column names in output (points mode)  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only export points falling within current 3D region (points mode)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area,face,kernel*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output ASCII file or ASCII vector name if '-o' is defined  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given or '-' then standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) to be exported (point mode)  
    &nbsp;&nbsp;&nbsp;&nbsp;"\*" for all columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, standard, wkt*  
    &nbsp;&nbsp;&nbsp;&nbsp;**point**: Simple point format (point per row)  
    &nbsp;&nbsp;&nbsp;&nbsp;**standard**: GRASS ASCII vector format  
    &nbsp;&nbsp;&nbsp;&nbsp;**wkt**: OGC well-known text  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator (points mode)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits (floating point only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-32*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *c*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create old (version 4) ASCII file  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include column names in output (points mode)  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only export points falling within current 3D region (points mode)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area,face,kernel*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output ASCII file or ASCII vector name if '-o' is defined  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given or '-' then standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) to be exported (point mode)  
    &nbsp;&nbsp;&nbsp;&nbsp;"\*" for all columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, standard, wkt*  
    &nbsp;&nbsp;&nbsp;&nbsp;**point**: Simple point format (point per row)  
    &nbsp;&nbsp;&nbsp;&nbsp;**standard**: GRASS ASCII vector format  
    &nbsp;&nbsp;&nbsp;&nbsp;**wkt**: OGC well-known text  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator (points mode)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits (floating point only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-32*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *c*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create old (version 4) ASCII file  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include column names in output (points mode)  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only export points falling within current 3D region (points mode)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.out.ascii* converts a GRASS vector map in binary format to a GRASS
vector map in [ASCII format](vectorascii.md). Using flag **-o**
*v.out.ascii* output will be in old (version 4) ASCII format.

If the **output** parameter is not given then the data is sent to
standard output.

## NOTES

The *[v.in.ascii](v.in.ascii.md)* module performs the function of
*v.out.ascii* in reverse; i.e. it converts vector maps in ASCII format
to their binary format. These two companion modules are useful both for
importing and exporting vector maps between GRASS and other software,
and for transferring data between machines.

If old version is requested, the **output** files from *v.out.ascii* is
placed in the `$LOCATION/$MAPSET/dig_ascii/` and
`$LOCATION/$MAPSET/dig_att` directory.

If **layer \> 0** then only features with a category number will be
exported. Use *[v.category](v.category.md)* to add them if needed or
define **layer=-1** to export also features without category.

*v.out.ascii* in the old version mode (**-o**) does not copy the
`dig_cats` file associated with the binary vector **input** map to the
new **output** file name. The user must copy the `dig_cats` file to the
new **output** name if this is desired (e.g. using the UNIX *cp*
command).

It is possible to output the coordinates of vertices in a non-points
vector feature by first converting the vector feature to a points map
with *[v.to.points](v.to.points.md)* and then exporting with
*v.out.ascii* in **points** mode.

## EXAMPLES

### Standard mode

See [ASCII format](vectorascii.md) specification.

```sh
v.out.ascii input=quads format=standard

ORGANIZATION: US Army Const. Eng. Rsch. Lab
DIGIT DATE:   May 1987
DIGIT NAME:   grass
MAP NAME:     Quads
MAP DATE:     May 1987
MAP SCALE:    24000
OTHER INFO:
ZONE:         13
MAP THRESH:   18.288000
VERTI:
B  4
 599587.1820962 4914067.53414294
 589639.15126831 4913922.5687301
 589440.96838162 4927803.62500018
 599375.87959179 4927959.83330436
B  2
 599375.87959179 4927959.83330436
 599587.1820962 4914067.53414294
B  4
 599587.1820962 4914067.53414294
 609541.5508239 4914236.0597482
 609316.10665227 4928116.8490555
 599375.87959179 4927959.83330436
C  1 1
 594125.63    4921115.58
 1     1
C  1 1
 604433.84    4921087.1
 1     2
```

### Point mode

```sh
v.out.ascii input=quads format=point

594125.63|4921115.58|1
604433.84|4921087.1|2
```

Print also selected attributes:

```sh
v.out.ascii input=geodetic_pts format=point where="cat > 5 and cat <= 8" columns=GEOD_NAME

573638.06289275|271623.25042595|6|27 WC 6
574416.81289275|274116.65542595|7|27 WC 7
575301.31189275|275303.81342595|8|27 WC 8
```

To print all attributes type **columns=\***:

```sh
v.out.ascii input=geodetic_pts format=point where="cat > 5 and cat <= 8" columns=*
573638.06289275|271623.25042595|6|6|0.00000000|0.00000000|6|6|27 WC 6|573638.09200000|271623.24100000|0.00|0|1.00000000|1.00000000
574416.81289275|274116.65542595|7|7|0.00000000|0.00000000|7|7|27 WC 7|574416.84100000|274116.64900000|0.00|0|1.00000000|1.00000000
575301.31189275|275303.81342595|8|8|0.00000000|0.00000000|8|8|27 WC 8|575301.30600000|275303.82600000|0.00|0|1.00000000|1.00000000
```

### WKT mode

WKT is abbreviation for [Well-known
text](https://en.wikipedia.org/wiki/Well-known_text).

```sh
v.out.ascii input=quads format=wkt

POLYGON((599587.18209620 4914067.53414294, 589639.15126831 4913922.56873010,
         589440.96838162 4927803.62500018, 599375.87959179 4927959.83330436,
         599587.18209620 4914067.53414294))
POLYGON((599587.18209620 4914067.53414294, 599375.87959179 4927959.83330436,
         609316.10665227 4928116.84905550, 609541.55082390 4914236.05974820,
         599587.18209620 4914067.53414294))
```

## SEE ALSO

*[v.category](v.category.md), [v.in.ascii](v.in.ascii.md),
[v.to.points](v.to.points.md)*

[GRASS ASCII vector format](vectorascii.md) specification  
[GRASS SQL interface](sql.md)

## AUTHORS

Michael Higgins, U.S. Army Construction Engineering Research
Laboratory  
James Westervelt, U.S. Army Construction Engineering Research
Laboratory  
Radim Blazek, ITC-Irst, Trento, Italy  
Attribute selection added by Martin Landa, Czech Technical University in
Prague, Czech Republic (2008/12)

## SOURCE CODE

Available at: [v.out.ascii source code](https://github.com/OSGeo/grass/tree/main/vector/v.out.ascii)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.out.ascii))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
