---
title: g.gui.mapswipe
description: wxGUI Map Swipe
index: topic_GUI|GUI
---

## DESCRIPTION

The **Map Swipe** is a *[wxGUI](wxGUI.md)* component which allows the
user to interactively compare two raster maps of the same area by
revealing different parts of the raster maps. It is useful e.g. for
comparing raster maps from different time periods. Map Swipe can be
launched from the menu `File -> Map Swipe`.

Map Swipe allows you to:

- switch orientation of the swipe line (horizontal or vertical)
- zooming, panning
- automatically load maps when opening Map Swipe with two selected
  raster maps in Layer Manager
- compare 2 raster maps or load different combinations of raster and
  vector maps and set transparency (advanced mode)
- save display to graphics file
- display text labels with map names
- choose between 'swipe' mode (default) and 'mirror' mode (synchronized
  maps displayed side by side)
- change the appearance of cursor in 'mirror' mode (available in Map
  Swipe settings)

![Map swipe screenshot](mapswipe_tsunami.jpg)  
*Figure: Pre and post disaster images of the tsunami in Japan in 2011. The upper
MODIS image taken on February 26, 2011, shows the coastline under normal
conditions while the lower MODIS image on March 13, 2011, shows a clear
view of tsunami flooding along the coastline. Water, black and dark blue
in these false-color images, still covers the ground as much as five
kilometers (three miles) from the coast. Source: [Earth
Observatory/NASA](https://earthobservatory.nasa.gov/images/49634/tsunami-flooding-near-sendai-japan)*

## SEE ALSO

*[wxGUI](wxGUI.md), [wxGUI components](wxGUI.components.md)*

See also the user
[wiki](https://grasswiki.osgeo.org/wiki/WxGUI_Map_Swipe) page.

## AUTHOR

Anna Kratochvilova, [Czech Technical University in
Prague](https://www.cvut.cz), Czech Republic

## SOURCE CODE

Available at: [g.gui.mapswipe source code](https://github.com/OSGeo/grass/tree/main/gui/wxpython/mapswipe)
([history](https://github.com/OSGeo/grass/commits/main/gui/wxpython/mapswipe))  
Latest change: Wednesday Jan 28 08:16:26 2026 in commit [0a9db34](https://github.com/OSGeo/grass/commit/0a9db34657dc4900ba35d6476b890c13d118c669)
