---
name: d.rgb
description: Displays three user-specified raster maps as red, green, and blue overlays in the active graphics frame.
keywords: [ display, graphics, raster, RGB ]
---

# d.rgb

Displays three user-specified raster maps as red, green, and blue overlays in the active graphics frame.

=== "Command line"

    **d.rgb**
    [**-n**]
    **red**=*name*
    **green**=*name*
    **blue**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.rgb red=name green=name blue=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.rgb***",
        **red**,
        **green**,
        **blue**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.rgb", red="name", green="name", blue="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_rgb*(**red**,
        **green**,
        **blue**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_rgb(red="name", green="name", blue="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **red**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;red&gt;  
    **green**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;green&gt;  
    **blue**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;blue&gt;  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Make null cells opaque  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **red** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;red&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **green** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;green&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **blue** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;blue&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Make null cells opaque  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **red** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;red&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **green** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;green&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **blue** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be used for &lt;blue&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Make null cells opaque  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.rgb* displays three user-specified raster maps as red, green, and
blue overlays in the active graphics frame.

*RGB* stands for **red**, **green**, and **blue**. *d.rgb* visually
combines three raster maps to form a color image. For each map, the
corresponding component from the layer's color table is used (e.g. for
the red layer, the red component is used, and so on). In general, the
input raster maps should use a grey-scale color table.

## NOTES

*d.rgb* does not attempt to quantize the combined image into a fixed
number of colors. Nor does it have an option to generate a composite
layer (see *r.composite* for that). The image and raster maps will not
display properly if the graphics device does not have a reasonable
sampling of the RGB color-space.

If color quality of satellite image color composites seems to appear
poor, run *[i.colors.enhance](i.colors.enhance.md)* on the selected
satellite channels.

An alternative is the assignment of grey color tables to each band with
*[r.colors](r.colors.md)*:

```sh
r.info -r image.1

min=0
max=255

r.colors map=image.1 color=grey

r.colors map=image.2 rast=image.1
r.colors map=image.3 rast=image.1
```

To write out the color composite to a combined R/G/B raster maps, use
*[r.composite](r.composite.md)*.

## EXAMPLE

Visual color composite of a LANDSAT scene (North Carolina sample
dataset):

```sh
g.region raster=lsat7_2002_10 -p
d.rgb blue=lsat7_2002_10 green=lsat7_2002_20 red=lsat7_2002_30
```

![d.rgb example](d_rgb.png)  
*Figure: Visual color composite of a LANDSAT scene (North Carolina
sample dataset)*

## SEE ALSO

*[d.colortable](d.colortable.md), [d.his](d.his.md),
[r.blend](r.blend.md), [r.mapcalc](r.mapcalc.md),
[r.colors](r.colors.md), [r.composite](r.composite.md)*

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [d.rgb source code](https://github.com/OSGeo/grass/tree/main/display/d.rgb)
([history](https://github.com/OSGeo/grass/commits/main/display/d.rgb))  
Latest change: Thursday May 08 14:17:52 2025 in commit [3caa352](https://github.com/OSGeo/grass/commit/3caa352f78f86a51ca463a6f1ba7ffe3db9771df)
