---
name: i.gensig
description: Generates statistics for i.maxlik from raster map.
keywords: [ imagery, classification, supervised classification, Maximum Likelihood Classification, MLC, signatures ]
---

# i.gensig

Generates statistics for i.maxlik from raster map.

=== "Command line"

    **i.gensig**
    **trainingmap**=*name*
    **group**=*name*
    **subgroup**=*name*
    **signaturefile**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.gensig trainingmap=name group=name subgroup=name signaturefile=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.gensig***",
        **trainingmap**,
        **group**,
        **subgroup**,
        **signaturefile**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.gensig", trainingmap="name", group="name", subgroup="name", signaturefile="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_gensig*(**trainingmap**,
        **group**,
        **subgroup**,
        **signaturefile**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_gensig(trainingmap="name", group="name", subgroup="name", signaturefile="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **trainingmap**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ground truth training map  
    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **subgroup**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery subgroup  
    **signaturefile**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file containing result signatures  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **trainingmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ground truth training map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **subgroup** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery subgroup  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **signaturefile** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file containing result signatures  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, sigfile, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **trainingmap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ground truth training map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **subgroup** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery subgroup  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **signaturefile** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file containing result signatures  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, sigfile, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.gensig* is a non-interactive method for generating input into
*[i.maxlik](i.maxlik.md)*. It can be used as the first pass in the GRASS
two-pass classification process (instead of *[i.cluster](i.cluster.md)*
or *[g.gui.iclass](g.gui.iclass.md))*. It reads a raster map layer,
called the training map, which has some of the pixels or regions already
classified. *i.gensig* will then extract spectral signatures from an
image based on the classification of the pixels in the training map and
make these signatures available to *[i.maxlik](i.maxlik.md)*.

The user would then execute the GRASS program *[i.maxlik](i.maxlik.md)*
to actually create the final classified map.

This module generates signature files of type "sig". Use module
[i.signatures](i.signatures.md) to manage generated signature files.

All raster maps used to generate signature file can have semantic label
set. Use *[r.support](r.support.md)* to set semantic labels of each
member of the imagery group. Signatures generated for one scene are
suitable for classification of other scenes as long as they consist of
same raster bands (semantic labels match).

Input **trainingmap** map must be prepared by the user in advance
using vector or raster
digitizer. Of course other methods could be devised by the user for
creating this training map - *i.gensig* makes no assumption about the
origin of this map layer. It simply creates signatures for the classes
defined in the training map for the image to be classified (the image is
specified in other options - see below). The *[wxGUI vector
digitizer](wxGUI.vdigit.md)* can be used for interactively creating the
training map.

Input **group** is the name of the group that contains the band files which
comprise the image to be analyzed. The *[i.group](i.group.md)* command
is used to construct groups of raster layers which comprise an image.

Input **subgroup** names the subgroup within the group that selects a subset of
the bands to be analyzed. The *[i.group](i.group.md)* command is also used
to prepare this subgroup. The subgroup mechanism allows the user to
select a subset of all the band files that form an image.

Input **signaturefile** is the resultant signature file (containing the means and
covariance matrices) for each class in the training map that is
associated with the band files in the subgroup select.
Resultant signature file can be used with any other
imagery group as long as semantic labels match.

## NOTES

The structure of the SIG files generated by *i.gensig* is as follows
(ASCII file, used internally by *i.maxlik*):  
*Note: the line numbers are not present in the file but have been added
here for explanation only*:

SIG file "lsat7_2000_gensig":

```sh
 1 1
 2 #
 3 Semantic_label1
 4 #water
 5 4186
 6 67.9508 48.7346 37.8915 15.3129 13.8473 12.0855
 7 1.74334
 8 0.439504 2.07267
 9 0.662523 1.63501 4.21189
10 0.530339 2.40757 5.52857 22.433
11 0.561184 2.30762 5.18846 20.5364 20.4926
12 0.393218 1.2184 2.63628 9.61528 9.36025 5.85314
```

- Line 1: version number (currently always 1)
- Line 2: text label
- Line 3: Space separated list of semantic labels
- Line 4: text label of class
- Line 5: number of points in class
- Line 6: mean values per band of the class
- Line 7-12: (semi)-matrix of band-band covariance

## SEE ALSO

*[r.support](r.support.md), [g.gui.iclass](g.gui.iclass.md),
[i.group](i.group.md), [i.cca](i.cca.md), [i.maxlik](i.maxlik.md),
[i.smap](i.smap.md), [r.info](r.info.md), [r.univar](r.univar.md),
[wxGUI vector digitizer](wxGUI.vdigit.md)*

## AUTHORS

Michael Shapiro, U.S.Army Construction Engineering Research Laboratory  
Semantic label support: Maris Nartiss, University of Latvia

## SOURCE CODE

Available at: [i.gensig source code](https://github.com/OSGeo/grass/tree/main/imagery/i.gensig)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.gensig))  
Latest change: Monday Feb 09 18:47:00 2026 in commit [fe51d38](https://github.com/OSGeo/grass/commit/fe51d3824fc8d5aa0e1ced4d9110214dc0192676)
