---
name: i.his.rgb
description: Transforms raster maps from HIS (Hue-Intensity-Saturation) color space to RGB (Red-Green-Blue) color space.
keywords: [ imagery, color transformation, RGB, HIS, IHS ]
---

# i.his.rgb

Transforms raster maps from HIS (Hue-Intensity-Saturation) color space to RGB (Red-Green-Blue) color space.

=== "Command line"

    **i.his.rgb**
    **hue**=*name*
    **intensity**=*name*
    **saturation**=*name*
    **red**=*name*
    **green**=*name*
    **blue**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.his.rgb hue=name intensity=name saturation=name red=name green=name blue=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.his.rgb***",
        **hue**,
        **intensity**,
        **saturation**,
        **red**,
        **green**,
        **blue**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.his.rgb", hue="name", intensity="name", saturation="name", red="name", green="name", blue="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_his_rgb*(**hue**,
        **intensity**,
        **saturation**,
        **red**,
        **green**,
        **blue**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_his_rgb(hue="name", intensity="name", saturation="name", red="name", green="name", blue="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **hue**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (hue)  
    **intensity**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (intensity)  
    **saturation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (saturation)  
    **red**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (red)  
    **green**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (green)  
    **blue**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (blue)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **hue** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (hue)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **intensity** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (intensity)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **saturation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (saturation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **red** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (red)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **green** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (green)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **blue** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (blue)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **hue** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (hue)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **intensity** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (intensity)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **saturation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (saturation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **red** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (red)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **green** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (green)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **blue** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (blue)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.his.rgb* is an image processing program that processes three input
raster map layers as hue, intensity and saturation components and
produces three output raster map layers representing the red, green and
blue components of this data. The output raster map layers are created
by a standard hue-intensity-saturation (HIS) to red-green-blue (RGB)
color transformation. Each output raster map layer is given a linear
gray scale color table. The current geographic region and mask settings
are respected.

## NOTES

It is not possible to process three bands with *i.his.rgb* and then
exactly recover the original bands with *i.rgb.his*. This is due to loss
of precision because of integer computations and rounding. Tests have
shown that more than 70% of the original cell values will be reproduced
exactly after transformation in both directions and that 99% will be
within plus or minus 1. A few cell values may differ significantly from
their original values.

## SEE ALSO

*[i.rgb.his](i.rgb.his.md), [r.colors](r.colors.md)*

## AUTHOR

David Satnik, GIS Laboratory, Central Washington University

with acknowledgements to Ali Vali, Univ. of Texas Space Research Center,
for the core routine.

## SOURCE CODE

Available at: [i.his.rgb source code](https://github.com/OSGeo/grass/tree/main/imagery/i.his.rgb)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.his.rgb))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
