---
name: i.tasscap.py
description: Performs Tasseled Cap (Kauth Thomas) transformation.
keywords: [ imagery, transformation, Landsat, MODIS, Worldview, Sentinel, Tasseled Cap transformation ]
---

# i.tasscap.py

Performs Tasseled Cap (Kauth Thomas) transformation.

=== "Command line"

    **i.tasscap.py**
    **input**=*name* [,*name*,...]
    **output**=*basename*
    **sensor**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.tasscap.py input=name output=basename sensor=landsat4_tm
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.tasscap.py***",
        **input**,
        **output**,
        **sensor**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.tasscap.py", input="name", output="basename", sensor="landsat4_tm")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_tasscap_py*(**input**,
        **output**,
        **sensor**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_tasscap_py(input="name", output="basename", sensor="landsat4_tm")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;For Landsat4-7: bands 1, 2, 3, 4, 5, 7; for Landsat8: bands 2, 3, 4, 5, 6, 7; for MODIS: bands 1, 2, 3, 4, 5, 6, 7; for Sentinel-2: bands 1 to 12, 8A; for Worldview-2: bands 1, 2, 3, 4, 5, 6, 7, 8  
    **output**=*basename* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;basename for output raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    **sensor**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Satellite sensor  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *landsat4_tm, landsat5_tm, landsat7_etm, landsat8_oli, modis, sentinel2, worldview2*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;For Landsat4-7: bands 1, 2, 3, 4, 5, 7; for Landsat8: bands 2, 3, 4, 5, 6, 7; for MODIS: bands 1, 2, 3, 4, 5, 6, 7; for Sentinel-2: bands 1 to 12, 8A; for Worldview-2: bands 1, 2, 3, 4, 5, 6, 7, 8  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;basename for output raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **sensor** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Satellite sensor  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *landsat4_tm, landsat5_tm, landsat7_etm, landsat8_oli, modis, sentinel2, worldview2*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;For Landsat4-7: bands 1, 2, 3, 4, 5, 7; for Landsat8: bands 2, 3, 4, 5, 6, 7; for MODIS: bands 1, 2, 3, 4, 5, 6, 7; for Sentinel-2: bands 1 to 12, 8A; for Worldview-2: bands 1, 2, 3, 4, 5, 6, 7, 8  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;basename for output raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **sensor** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Satellite sensor  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *landsat4_tm, landsat5_tm, landsat7_etm, landsat8_oli, modis, sentinel2, worldview2*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.tasscap* calculates Tasseled Cap (Kauth Thomas, TC) transformation
for Landsat TM data (TM4, TM5, ETM7), MODIS and Sentinel-2 data. The
tasseled cap transformation is effectively a compression method to
reduce multiple spectral data into a few bands. The method was
originally developed for understanding important phenomena of crop
development in spectral space (Kauth and Thomas, 1976).

Tasseled cap coefficients for Landsat 7 ETM+ are at-satellite
reflectance values (C. Huang et al., 2001), the conversion can be
achieved with *i.landsat.toar*.

The following tasseled cap components are generated:

- tasscap.1: corresponds to brightness,
- tasscap.2: corresponds to greenness,
- tasscap.3: corresponds to wetness,
- tasscap.4: corresponds to atmospheric haze (only selected sensors:
  Landsat 5,7,8).

## EXAMPLE

Calculation of TC maps from North Carolina Landsat 7 ETM scene:

```sh
# See manual page of i.landsat.toar for pre-processing

g.region raster=lsat7_2002_toar.1 -p

i.tasscap sensor=landsat7_etm \
  input=lsat7_2002_toar.1,lsat7_2002_toar.2,lsat7_2002_toar.3,lsat7_2002_toar.4,lsat7_2002_toar.5,lsat7_2002_toar.7 \
  output=lsat7_2002_tasscap
```

Results:

![Brightness Tasseled Cap component 1](i_tasscap_brightness.jpg)  
*'Brightness' Tasseled Cap component 1*  

![Greenness Tasseled Cap component 2](i_tasscap_greenness.jpg)  
*'Greenness' Tasseled Cap component 2*  

![Wetness Tasseled Cap component 3](i_tasscap_wetness.jpg)  
*'Wetness' Tasseled Cap component 3*  

![Atmospheric haze Tasseled Cap component 4](i_tasscap_haze.jpg)  
*'Atmospheric haze' Tasseled Cap component 4*  

## REFERENCES

- LANDSAT-4/LANDSAT-5: TC-factor changed to CRIST et al. 1986, Proc.
  IGARSS 1986, p.1467
- Crist, E. P., 1985, A TM tasseled cap equivalent transformation for
  reflectance factor data, Remote Sensing of Environment, 17: 301-306.
- LANDSAT-7: TASSCAP factors cited from: DERIVATION OF A TASSELED CAP
  TRANSFORMATION BASED ON LANDSAT 7 AT-SATELLITE REFLECTANCE. Chengquan
  Huang, Bruce Wylie, Limin Yang, Collin Homer and Gregory Zylstra
  Raytheon ITSS, USGS EROS Data Center Sioux Falls, SD 57198, USA
  ([PDF](https://digitalcommons.unl.edu/usgsstaffpub/621/)). This is
  published as well in INT. J. OF RS, 2002, VOL 23, NO. 8, 1741-1748.
- MODIS Tasseled Cap coefficients - Ref: Lobser & Cohen (2007). MODIS
  tasseled cap: land cover characteristics expressed through transformed
  MODIS data. International Journal of Remote Sensing, Volume 28(22),
  Table 3
- Sentinel-2 Tasseled Cap coefficients - Ref: Nedkov, R. (2017).
  Orthogonal transformation of segmented images from the satellite
  Sentinel-2. Comptes rendus de l'Académie bulgare des sciences,
  70:687-692.
- Yarbrough, L., Navulur, R., 2014, Presentation of the Kauth-Thomas
  transform for WorldView-2 reflectance data. Remote Sensing Letters. 5.
  DOI: 10.1080/2150704X.2014.885148.

## SEE ALSO

*[i.albedo](i.albedo.md), [i.atcorr](i.atcorr.md),
[i.landsat.toar](i.landsat.toar.md), [i.vi](i.vi.md)*

## AUTHORS

Dr. Agustin Lobo, original script, 1997

Markus Neteler, ITC-irst, 2001

Converted to Python by Glynn Clements

Code improvements by Leonardo Perathoner

Sentinel-2 support by Veronica Andreo

Worldview-2 support by Markus Neteler

## SOURCE CODE

Available at: [i.tasscap source code](https://github.com/OSGeo/grass/tree/main/scripts/i.tasscap)
([history](https://github.com/OSGeo/grass/commits/main/scripts/i.tasscap))  
Latest change: Friday Jul 18 04:20:25 2025 in commit [9c6890b](https://github.com/OSGeo/grass/commit/9c6890b933da3aad24b438f24dab0599d49edc2a)
