---
name: r.out.pov
description: Converts a raster map layer into a height-field file for POV-Ray.
keywords: [ raster, export, output ]
---

# r.out.pov

Converts a raster map layer into a height-field file for POV-Ray.

=== "Command line"

    **r.out.pov**
    **input**=*name*
    **output**=*name*
    [**hftype**=*integer*]
    [**bias**=*float*]
    [**scale**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.out.pov input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.out.pov***",
        **input**,
        **output**,
        **hftype**=*None*,
        **bias**=*None*,
        **scale**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.out.pov", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_out_pov*(**input**,
        **output**,
        **hftype**=*None*,
        **bias**=*None*,
        **scale**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_out_pov(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output povray file (TGA height field file)  
    **hftype**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height-field type (0=actual heights 1=normalized)  
    **bias**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation bias  
    **scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical scaling factor  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output povray file (TGA height field file)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **hftype** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height-field type (0=actual heights 1=normalized)  
    **bias** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation bias  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical scaling factor  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output povray file (TGA height field file)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **hftype** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height-field type (0=actual heights 1=normalized)  
    **bias** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation bias  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical scaling factor  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.out.pov* converts a user-specified raster map layer (map==name) into
a height-field file for POVray (tga==name). The hftype==value option
(where value is either 0 or 1) specifies the height-field type. When the
user enters 0 the output will be actual heights. If entered 1 the
cell-values will be normalized. If hftype is 0 (actual heights) the
bias==value can be used to add or subtract a value from heights. Use
scale==value to scale your heights by value. The GRASS program r.out.pov
can be used to create height- field files for Persistence of Vision
(POV) raytracer. POV can use a height-field defined in Targa (.TGA)
image file format where the RGB pixel values are 24 bits (3 bytes). A 16
bit unsigned integer height-field value is assigned as follows: RED =
high byte, GREEN = low byte, BLUE = empty.

## EXAMPLE

An example Povray script file may look like this:

```sh
#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

#declare Scale = 7;

light_source { <40000, Scale*3000, 5000> color MainLight }

camera {
   location < 23000, Scale*2000, 0>
   angle  90
   look_at < 23000, Scale*1400, 5000>
}

height_field  {
   tga "dem.lr.tga"
   smooth
   water_level 0.11  // 726 / 6553.6 = 0.111
    texture {
      pigment {
          image_map { // image is always projected from -z, with front facing  +z, top to +Y
             ppm "map.lr.ppm"
             once
          }
          rotate x*90 // align map to height_field
      }
    }
   finish {
          ambient 0.2         // Very dark shadows
          diffuse 0.8         // Whiten the whites
          phong 0.2           // shiny
          phong_size 100.0    // with tight highlights
          specular 0.5
          roughness 0.05
   }
   scale < 14500, Scale*6553.6, 13000 >
   translate <18300, 0, 1100>
}
```

## AUTHOR

Klaus D. Meyer, GEUM.tec GbR, eMail: *<GEUM.tec@geum.de>*

## SOURCE CODE

Available at: [r.out.pov source code](https://github.com/OSGeo/grass/tree/main/raster/r.out.pov)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.out.pov))  
Latest change: Sunday Jul 27 05:53:30 2025 in commit [da40958](https://github.com/OSGeo/grass/commit/da409580ef15011f3bac379c76d41101c9e36347)
