---
name: r.region
description: Sets the boundary definitions for a raster map.
keywords: [ raster, metadata, geometry ]
---

# r.region

Sets the boundary definitions for a raster map.

=== "Command line"

    **r.region**
    [**-cda**]
    **map**=*name*
    [**region**=*name*]
    [**raster**=*name*]
    [**vector**=*name*]
    [**n**=*value*]
    [**s**=*value*]
    [**e**=*value*]
    [**w**=*value*]
    [**align**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.region map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.region***",
        **map**,
        **region**=*None*,
        **raster**=*None*,
        **vector**=*None*,
        **n**=*None*,
        **s**=*None*,
        **e**=*None*,
        **w**=*None*,
        **align**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.region", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_region*(**map**,
        **region**=*None*,
        **raster**=*None*,
        **vector**=*None*,
        **n**=*None*,
        **s**=*None*,
        **e**=*None*,
        **w**=*None*,
        **align**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_region(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to change  
    **region**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set region from named region  
    **raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set region to match this raster map  
    **vector**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Set region to match this vector map  
    **n**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for the northern edge  
    **s**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for the southern edge  
    **e**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for the eastern edge  
    **w**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for the western edge  
    **align**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to align to  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set from current region  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set from default region  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Auto-adjustment for lat/lon  
    &nbsp;&nbsp;&nbsp;&nbsp;Attempt to fix small precision errors in resolution and extents  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to change  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set region from named region  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region, *name*  
    **raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set region to match this raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **vector** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Set region to match this vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **n** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for the northern edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **s** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for the southern edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **e** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for the eastern edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **w** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for the western edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **align** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to align to  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *d*, *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set from current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set from default region  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Auto-adjustment for lat/lon  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Attempt to fix small precision errors in resolution and extents  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to change  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set region from named region  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region, *name*  
    **raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set region to match this raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **vector** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Set region to match this vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **n** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for the northern edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **s** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for the southern edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **e** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for the eastern edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **w** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for the western edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **align** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to align to  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *d*, *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set from current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set from default region  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Auto-adjustment for lat/lon  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Attempt to fix small precision errors in resolution and extents  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.region* program allows the user to manage the boundaries of a
raster map. These boundaries can be set by the user directly and/or set
from a region definition file (stored under the `windows` directory in
the user's current mapset), a raster or vector map, or a 3dview file.

The **align** parameter sets the current resolution equal to that of the
named raster map, and align the boundaries to a row and column edge in
the named map. Alignment only moves the existing boundaries outward to
the edges of the next nearest cell in the named raster map -- not to the
named map's edges. To perform the latter function, use the
**raster**=*name* option.

## NOTES

After all updates have been applied, the raster map's resolution
settings are recomputed from the boundaries and the number of rows and
columns in the raster map.

The n=*value* may also be specified as a function of its current value:
n=n+*value* increases the current northing, while n=n-*value* decreases
it. This is also true for s=*value*, e=*value*, and w=*value*.

## EXAMPLES

Assign absolute coordinates to map:

```sh
r.region map=mymap n=220750 s=220000 w=638300 e=639000
```

Shift map (using offset, here by +100 map units in the NS direction, -50
in the EW direction):

```sh
r.region map=mymap n=n+100 e=e-50 w=w-50 s=s+100
```

## SEE ALSO

*[r.support](r.support.md), [g.region](g.region.md),
[v.transform](v.transform.md)*

## AUTHOR

Glynn Clements  
Based upon *g.region*

## SOURCE CODE

Available at: [r.region source code](https://github.com/OSGeo/grass/tree/main/raster/r.region)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.region))  
Latest change: Monday Feb 24 16:07:55 2025 in commit [4ab71fd](https://github.com/OSGeo/grass/commit/4ab71fd34113b347c3c86c736cd82ca0f6be1d4b)
