---
name: r.series.interp
description: Interpolates raster maps located (temporal or spatial) in between input raster maps at specific sampling positions.
keywords: [ raster, series, interpolation ]
---

# r.series.interp

Interpolates raster maps located (temporal or spatial) in between input raster maps at specific sampling positions.

=== "Command line"

    **r.series.interp**
    [**input**=*name* [,*name*,...]]
    [**datapos**=*float* [,*float*,...]]
    [**infile**=*name*]
    [**output**=*name* [,*name*,...]]
    [**samplingpos**=*float* [,*float*,...]]
    [**outfile**=*name*]
    [**method**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.series.interp
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.series.interp***",
        **input**=*None*,
        **datapos**=*None*,
        **infile**=*None*,
        **output**=*None*,
        **samplingpos**=*None*,
        **outfile**=*None*,
        **method**=*"linear"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.series.interp")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_series_interp*(**input**=*None*,
        **datapos**=*None*,
        **infile**=*None*,
        **output**=*None*,
        **samplingpos**=*None*,
        **outfile**=*None*,
        **method**=*"linear"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_series_interp()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    **datapos**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Data point position for each input map  
    **infile**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one input raster map name and data point position per line, field separator between name and sample point is |  
    **output**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **samplingpos**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling point position for each output map  
    **outfile**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one output raster map name and sample point position per line, field separator between name and sample point is |  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolation method, currently only linear interpolation is supported  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *linear*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *linear*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **datapos** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data point position for each input map  
    **infile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one input raster map name and data point position per line, field separator between name and sample point is |  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **samplingpos** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling point position for each output map  
    **outfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one output raster map name and sample point position per line, field separator between name and sample point is |  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolation method, currently only linear interpolation is supported  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *linear*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *linear*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **datapos** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data point position for each input map  
    **infile** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one input raster map name and data point position per line, field separator between name and sample point is |  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **samplingpos** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling point position for each output map  
    **outfile** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one output raster map name and sample point position per line, field separator between name and sample point is |  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolation method, currently only linear interpolation is supported  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *linear*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *linear*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.series.interp* interpolates new raster maps located temporal or
spatial in between existing raster maps. The interpolation is performed
at specific sampling positions. The sampling position for each output
map must be specified, as well as the data position of the input maps.
The following interpolation methods are supported.

- linear: Linear interpolation. At least two input maps and data
  positions are required.

## EXAMPLES

Interpolate linear three new maps at 3 sampling positions in the
interval (0.0;1.0)  
First prepare the input maps:  

```sh
g.region s=0 n=80 w=0 e=120 b=0 t=50 res=10 res3=10 -p3

r.mapcalc expr="prec_1 = 100"
r.mapcalc expr="prec_5 = 500"
```

Interpolate

```sh
r.series.interp --v input=prec_1,prec_5 datapos=0.0,1.0 \
                  output=prec_2,prec_3,prec_4 samplingpos=0.25,0.5,0.75 \
                  method=linear
```

Interpolate using the file option. First prepare the input file:  

```sh
echo "prec_2|0.25
prec_3|0.5
prec_4|0.75" >> outfile.txt
```

Interpolate:

```sh
r.series.interp --v input=prec_1,prec_5 datapos=0.0,1.0 file=outfile.txt method=linear
```

The resulting maps will have the values 200, 300 and 400.

## SEE ALSO

*[g.region](g.region.md), [r.series](r.series.md),
[r.series.accumulate](r.series.accumulate.md)*

[Hints for large raster data
processing](https://grasswiki.osgeo.org/wiki/Large_raster_data_processing)

## AUTHOR

Sören Gebbert

## SOURCE CODE

Available at: [r.series.interp source code](https://github.com/OSGeo/grass/tree/main/raster/r.series.interp)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.series.interp))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
