---
name: r3.gradient
description: Computes gradient of a 3D raster map and outputs gradient components as three 3D raster maps.
keywords: [ raster3d, gradient, voxel ]
---

# r3.gradient

Computes gradient of a 3D raster map and outputs gradient components as three 3D raster maps.

=== "Command line"

    **r3.gradient**
    **input**=*name*
    **output**=*grad_x,grad_y,grad_z* [,*grad_x,grad_y,grad_z*,...]
    [**blocksize**=*size_x,size_y,size_z* [,*size_x,size_y,size_z*,...]]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.gradient input=name output=grad_x,grad_y,grad_z
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.gradient***",
        **input**,
        **output**,
        **blocksize**=*"30,30,20"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.gradient", input="name", output="grad_x,grad_y,grad_z")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_gradient*(**input**,
        **output**,
        **blocksize**=*"30,30,20"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_gradient(input="name", output="grad_x,grad_y,grad_z")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    **output**=*grad_x,grad_y,grad_z* [,*grad_x,grad_y,grad_z*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map(s)  
    **blocksize**=*size_x,size_y,size_z* [,*size_x,size_y,size_z*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of blocks  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30,30,20*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : list[tuple[str, str, str]] | tuple[str, str, str] | list[str] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *grad_x,grad_y,grad_z*  
    **blocksize** : list[tuple[str, str, str]] | tuple[str, str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of blocks  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *size_x,size_y,size_z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30,30,20*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : list[tuple[str, str, str]] | tuple[str, str, str] | list[str] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *grad_x,grad_y,grad_z*  
    **blocksize** : list[tuple[str, str, str]] | tuple[str, str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of blocks  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *size_x,size_y,size_z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30,30,20*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *r3.gradient* computes gradient from a 3D raster map. Results are
three 3D raster maps describing the x, y, z components of the computed
gradient field.

## EXAMPLES

```sh
# create a 3D raster
g.region s=0 n=100 w=0 e=100 b=0 t=100 -p
r3.mapcalc "test_gradient = sqrt(row()*row() +col()*col()+ depth()*depth())"

# compute gradient
r3.gradient input=test_gradient output=grad_x,grad_y,grad_z
```

## SEE ALSO

*[r3.flow](r3.flow.md), [r.flow](r.flow.md)*

## AUTHOR

Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/), developed during GSoC
2014.

## SOURCE CODE

Available at: [r3.gradient source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.gradient)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.gradient))  
Latest change: Monday Nov 03 07:16:48 2025 in commit [c967967](https://github.com/OSGeo/grass/commit/c96796774942e46bbababcd652d3986d4e295665)
