---
name: r3.mkdspf
description: Creates a display file from an existing 3D raster map according to specified threshold levels.
keywords: [ raster3d, display, voxel ]
---

# r3.mkdspf

Creates a display file from an existing 3D raster map according to specified threshold levels.

=== "Command line"

    **r3.mkdspf**
    [**-qf**]
    **input**=*string*
    **dspf**=*name*
    [**levels**=*float* [,*float*,...]]
    [**min**=*float*]
    [**max**=*float*]
    [**step**=*float*]
    [**tnum**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.mkdspf input=string dspf=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.mkdspf***",
        **input**,
        **dspf**,
        **levels**=*None*,
        **min**=*None*,
        **max**=*None*,
        **step**=*None*,
        **tnum**=*7*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.mkdspf", input="string", dspf="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_mkdspf*(**input**,
        **dspf**,
        **levels**=*None*,
        **min**=*None*,
        **max**=*None*,
        **step**=*None*,
        **tnum**=*7*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_mkdspf(input="string", dspf="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing 3D raster map  
    **dspf**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output display file  
    **levels**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List of thresholds for isosurfaces  
    **min**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum isosurface level  
    **max**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum isosurface level  
    **step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Positive increment between isosurface levels  
    **tnum**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of isosurface threshold levels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *7*  
    **-q**  
    &nbsp;&nbsp;&nbsp;&nbsp;Suppress progress report & min/max information  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use flat shading rather than gradient  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3d-raster  
    **dspf** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output display file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **levels** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of thresholds for isosurfaces  
    **min** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum isosurface level  
    **max** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum isosurface level  
    **step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Positive increment between isosurface levels  
    **tnum** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of isosurface threshold levels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *7*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *q*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress progress report & min/max information  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use flat shading rather than gradient  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3d-raster  
    **dspf** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output display file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **levels** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of thresholds for isosurfaces  
    **min** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum isosurface level  
    **max** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum isosurface level  
    **step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Positive increment between isosurface levels  
    **tnum** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of isosurface threshold levels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *7*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *q*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress progress report & min/max information  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use flat shading rather than gradient  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Creates a display file from an existing grid3 file according to
specified threshold levels. The display file is a display list of
polygons that represent isosurfaces of the data volume. If specific
*levels* are given, additional optional parameters are ignored. *Min* or
*max* may be used alone or together to specify a sub-range of the data.
The *step* parameter is given precedence over *tnum*.

### Flags

**-q**  
Suppress progress report & min/max information

**-f**  
Use flat shading rather than gradient

### Parameters

**grid3**  
Name of an existing 3D raster map

**dspf**  
Name of output display file

**levels**  
List of thresholds for isosurfaces

**min**  
Minimum isosurface level

**max**  
Maximum isosurface level

**step**  
Positive increment between isosurface levels

**tnum**  
Number of isosurface threshold levels

Default: 7

## NOTES

Currently the grid3 file must be in the user's mapset since the display
files being created are specific to particular grid3 files and are
contained in directories under them. We should create a mechanism where
users may make display files from others' grid3 files without having to
copy them to their mapset.

## EXAMPLES

With grid3 data (*phdata*) in the range 3-7, we only want to see
isosurface values for the range 4-6. Any of these commands will produce
the same results:  

```sh
r3.mkdspf phdata dspf=iso min=4.0 max=6.0 tnum=5
r3.mkdspf phdata dspf=iso levels=4.0,4.5,5.0,5.5,6.0
r3.mkdspf phdata dspf=iso min=4.0 max=6.0 step=0.5
```

## AUTHOR

Bill Brown, [bbrown@gis.uiuc.edu](mailto:brown@gis.uiuc.edu)

## SOURCE CODE

Available at: [r3.mkdspf source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.mkdspf)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.mkdspf))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
