---
name: t.create.py
description: Creates a space time dataset.
keywords: [ temporal, map management, create, time ]
---

# t.create.py

Creates a space time dataset.

=== "Command line"

    **t.create.py**
    **output**=*name*
    [**type**=*name*]
    [**temporaltype**=*name*]
    **semantictype**=*string*
    **title**=*string*
    **description**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.create.py output=name semantictype=mean title=string description=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.create.py***",
        **output**,
        **type**=*"strds"*,
        **temporaltype**=*"absolute"*,
        **semantictype**=*"mean"*,
        **title**,
        **description**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.create.py", output="name", semantictype="mean", title="string", description="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_create_py*(**output**,
        **type**=*"strds"*,
        **temporaltype**=*"absolute"*,
        **semantictype**=*"mean"*,
        **title**,
        **description**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_create_py(output="name", semantictype="mean", title="string", description="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time dataset  
    **type**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the output space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds, stvds, str3ds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **temporaltype**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal type of the space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *absolute, relative*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *absolute*  
    **semantictype**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Semantic type of the space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, max, sum, mean*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **title**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Title of the new space time dataset  
    **description**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the new space time dataset  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, stds, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the output space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds, stvds, str3ds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **temporaltype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal type of the space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *absolute, relative*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *absolute*  
    **semantictype** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Semantic type of the space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, max, sum, mean*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **title** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title of the new space time dataset  
    **description** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the new space time dataset  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, stds, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the output space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds, stvds, str3ds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **temporaltype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal type of the space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *absolute, relative*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *absolute*  
    **semantictype** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Semantic type of the space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, max, sum, mean*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **title** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title of the new space time dataset  
    **description** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the new space time dataset  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.create* is used to create space time datasets of type raster (STRDS),
3D raster (STR3DS) and vector (STVDS).

Space time datasets represent spatio-temporal fields in the temporal
GRASS framework. They are designed to collect any amount of time stamped
maps with time intervals and time instances. The temporal type of a
space time dataset can be absolute (means with a fixed date) or relative
(only sequential maps) and must be set during dataset creation along
with the name and the description.

Time stamped maps can registered in and unregistered from space time
datasets. The spatio-temporal extent as well as the metadata of a space
time dataset is derived from its registered maps. Hence the metadata is
dependent from the dataset type (raster, 3D raster, vector).

## EXAMPLE

### Absolute STRDS dataset

Create a raster space time datasets

```sh
t.create type=strds temporaltype=absolute \
         output=precipitation_monthly \
         title="Monthly precipitation" \
         description="Dataset with monthly precipitation"
```

### Relative STVDS dataset

Create a vector space time datasets

```sh
t.create type=stvds temporaltype=relative \
         output=precipitation_monthly_30y \
         title="Monthly precipitation 30 years" \
         description="Test dataset with monthly average \
         precipitation in the last 30 year"
```

## SEE ALSO

*[t.register](t.register.md), [t.remove](t.remove.md),
[t.info](t.info.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.create source code](https://github.com/OSGeo/grass/tree/main/temporal/t.create)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.create))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
