---
hide:
  - toc
---

# Topic: network

| Tool | Description |
|--------|-------------|
| [d.path](d.path.md) | Finds shortest path for selected starting and ending node. |
| [v.net.alloc](v.net.alloc.md) | Allocates subnets for nearest centers. Center node must be opened (costs >= 0). Costs of center node are used in calculation. |
| [v.net.allpairs](v.net.allpairs.md) | Computes the shortest path between all pairs of nodes in the network. |
| [v.net.bridge](v.net.bridge.md) | Computes bridges and articulation points in the network. |
| [v.net.centrality](v.net.centrality.md) | Computes degree, centrality, betweenness, closeness and eigenvector centrality measures in the network. |
| [v.net.components](v.net.components.md) | Computes strongly and weakly connected components in the network. |
| [v.net.connectivity](v.net.connectivity.md) | Computes vertex connectivity between two sets of nodes in the network. |
| [v.net.distance](v.net.distance.md) | Computes shortest distance via the network between the given sets of features. Finds the shortest paths from each 'from' point to the nearest 'to' feature and various information about this relation are uploaded to the attribute table. |
| [v.net.flow](v.net.flow.md) | Computes the maximum flow between two sets of nodes in the network. |
| [v.net.iso](v.net.iso.md) | Splits subnets for nearest centers by cost isolines. Splits net to bands between cost isolines (direction from center). Center node must be opened (costs >= 0). Costs of center node are used in calculation. |
| [v.net](v.net.md) | Performs network maintenance. |
| [v.net.path](v.net.path.md) | Finds shortest path on vector network. |
| [v.net.salesman](v.net.salesman.md) | Creates a cycle connecting given nodes (Traveling salesman problem). Note that TSP is NP-hard, heuristic algorithm is used by this module and created cycle may be sub optimal |
| [v.net.spanningtree](v.net.spanningtree.md) | Computes minimum spanning tree for the network. |
| [v.net.steiner](v.net.steiner.md) | Creates Steiner tree for the network and given terminals. Note that 'Minimum Steiner Tree' problem is NP-hard and heuristic algorithm is used in this module so the result may be sub optimal. |
| [v.net.timetable](v.net.timetable.md) | Finds shortest path using timetables. |
| [v.net.visibility](v.net.visibility.md) | Performs visibility graph construction. |

*See also the corresponding keyword for additional references:*

<!-- topic_keyword { include: [network] } -->
