---
name: v.db.renamecolumn.py
description: Renames a column in the attribute table connected to a given vector map.
keywords: [ vector, attribute table, database, rename ]
---

# v.db.renamecolumn.py

Renames a column in the attribute table connected to a given vector map.

=== "Command line"

    **v.db.renamecolumn.py**
    **map**=*name*
    [**layer**=*string*]
    **column**=*oldcol,newcol*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.db.renamecolumn.py map=name column=oldcol,newcol
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.db.renamecolumn.py***",
        **map**,
        **layer**=*"1"*,
        **column**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.db.renamecolumn.py", map="name", column="oldcol,newcol")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_db_renamecolumn_py*(**map**,
        **layer**=*"1"*,
        **column**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_db_renamecolumn_py(map="name", column="oldcol,newcol")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*oldcol,newcol* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Old and new name of the column (old,new)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : tuple[str, str] | list[str] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Old and new name of the column (old,new)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *oldcol,newcol*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : tuple[str, str] | list[str] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Old and new name of the column (old,new)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *oldcol,newcol*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.db.renamecolumn* renames a column in the attribute table connected to
a given vector map. It automatically checks the connection for the
specified layer.

## NOTES

If the map table is connected through the DBF or SQLite drivers, the
renaming is internally done by adding a new column with new name,
transferring the contents of the old column to the new column and
dropping the old column. This is needed as DBF or SQLite do not support
"ALTER TABLE" command to rename columns. Due to this the renamed column
is found as last column of the table, it's original position cannot be
maintained.

The SQLite driver will exit with an error if the column rename involves
only a change of case, i.e., upper-to-lowercase, or lower-to-uppercase.
The SQLite protocol considers "NAME" and "name" to be identical column
names. In cases like these, the user should rename the original column
to an intermediary name, then rename the intermediary to the final name.

## EXAMPLES

Renaming a column:  

```sh
g.copy vect=roadsmajor,myroads
v.info -c myroads
v.db.renamecolumn myroads column=ROAD_NAME,roadname
v.info -c myroads
```

## SEE ALSO

*[db.execute](db.execute.md), [v.db.addcolumn](v.db.addcolumn.md),
[v.db.addtable](v.db.addtable.md), [v.db.connect](v.db.connect.md),
[v.db.dropcolumn](v.db.dropcolumn.md),
[v.db.droptable](v.db.droptable.md), [v.db.select](v.db.select.md),
[v.db.update](v.db.update.md)*

*[GRASS SQL interface](sql.md)*

## AUTHOR

Markus Neteler

## SOURCE CODE

Available at: [v.db.renamecolumn source code](https://github.com/OSGeo/grass/tree/main/scripts/v.db.renamecolumn)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.db.renamecolumn))  
Latest change: Tuesday Jun 24 05:57:51 2025 in commit [801e552](https://github.com/OSGeo/grass/commit/801e552cdaf8ef40f8760dbbcc5a4a5b83b14d40)
