---
name: v.out.pov
description: Converts GRASS x,y,z points to POV-Ray x,z,y format.
keywords: [ vector, export, output ]
---

# v.out.pov

Converts GRASS x,y,z points to POV-Ray x,z,y format.

=== "Command line"

    **v.out.pov**
    **input**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    **output**=*name*
    [**size**=*string*]
    [**zmod**=*string*]
    [**objmod**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.out.pov input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.out.pov***",
        **input**,
        **layer**=*"-1"*,
        **type**=*"point,line,area,face"*,
        **output**,
        **size**=*"10"*,
        **zmod**=*None*,
        **objmod**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.out.pov", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_out_pov*(**input**,
        **layer**=*"-1"*,
        **type**=*"point,line,area,face"*,
        **output**,
        **size**=*"10"*,
        **zmod**=*None*,
        **objmod**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_out_pov(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area,face*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output POV file  
    **size**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radius of sphere for points and tube for lines  
    &nbsp;&nbsp;&nbsp;&nbsp;May be also variable, e.g. grass_r.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **zmod**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;This string is appended to each z coordinate. Examples: '\*10', '+1000', '\*10+100', '\*exaggeration'  
    **objmod**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Object modifier (OBJECT_MODIFIER in POV-Ray documentation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: "pigment { color red 0 green 1 blue 0 }"  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area,face*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output POV file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **size** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radius of sphere for points and tube for lines  
    &nbsp;&nbsp;&nbsp;&nbsp;May be also variable, e.g. grass_r.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **zmod** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;This string is appended to each z coordinate. Examples: '\*10', '+1000', '\*10+100', '\*exaggeration'  
    **objmod** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Object modifier (OBJECT_MODIFIER in POV-Ray documentation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: "pigment { color red 0 green 1 blue 0 }"  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area,face*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output POV file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **size** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radius of sphere for points and tube for lines  
    &nbsp;&nbsp;&nbsp;&nbsp;May be also variable, e.g. grass_r.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **zmod** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;This string is appended to each z coordinate. Examples: '\*10', '+1000', '\*10+100', '\*exaggeration'  
    **objmod** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Object modifier (OBJECT_MODIFIER in POV-Ray documentation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: "pigment { color red 0 green 1 blue 0 }"  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.out.pov* converts GRASS vector data to POV-Ray format
(<www.povray.com>)

## EXAMPLE

```sh
v.out.pov input=vector3d output=vector3d.pov objmod="pigment { color red 0 green 1 blue 0 }"
```

The generated file can be included in an existing .pov file with the
following statement:

```sh
#include "vector3d.pov"
```

## REFERENCES

[POV-Ray](http://www.povray.com)

## SEE ALSO

*[r.out.pov](r.out.pov.md)*

## AUTHOR

Radim Blazek, ITC-Irst, Trento, Italy

## SOURCE CODE

Available at: [v.out.pov source code](https://github.com/OSGeo/grass/tree/main/vector/v.out.pov)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.out.pov))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
