---
name: d.linegraph
description: Generates and displays simple line graphs in the active graphics monitor display frame.
keywords: [ display, cartography ]
---

# d.linegraph

Generates and displays simple line graphs in the active graphics monitor display frame.

=== "Command line"

    **d.linegraph**
    [**-xysl**]
    **x_file**=*string*
    **y_file**=*string* [,*string*,...]
    [**directory**=*string*]
    [**y_color**=*string* [,*string*,...]]
    [**color_table**=*style*]
    [**width**=*integer* [,*integer*,...]]
    [**title_color**=*string*]
    [**x_title**=*string*]
    [**y_title**=*string*]
    [**title**=*string*]
    [**y_range**=*min,max*]
    [**y_tics**=*float* [,*float*,...]]
    [**x_scale**=*float*]
    [**y_scale**=*float*]
    [**icon**=*string*]
    [**point_size**=*float*]
    [**secondary_color**=*name*]
    [**secondary_width**=*float* [,*float*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.linegraph x_file=string y_file=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.linegraph***",
        **x_file**,
        **y_file**,
        **directory**=*None*,
        **y_color**=*None*,
        **color_table**=*None*,
        **width**=*None*,
        **title_color**=*"black"*,
        **x_title**=*""*,
        **y_title**=*""*,
        **title**=*""*,
        **y_range**=*None*,
        **y_tics**=*None*,
        **x_scale**=*None*,
        **y_scale**=*None*,
        **icon**=*"basic/circle"*,
        **point_size**=*5*,
        **secondary_color**=*"black"*,
        **secondary_width**=*0.1*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.linegraph", x_file="string", y_file="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_linegraph*(**x_file**,
        **y_file**,
        **directory**=*None*,
        **y_color**=*None*,
        **color_table**=*None*,
        **width**=*None*,
        **title_color**=*"black"*,
        **x_title**=*""*,
        **y_title**=*""*,
        **title**=*""*,
        **y_range**=*None*,
        **y_tics**=*None*,
        **x_scale**=*None*,
        **y_scale**=*None*,
        **icon**=*"basic/circle"*,
        **point_size**=*5*,
        **secondary_color**=*"black"*,
        **secondary_width**=*0.1*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_linegraph(x_file="string", y_file="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **x_file**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of data file for X axis of graph  
    **y_file**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of data file(s) for Y axis of graph  
    **directory**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to files  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the directory where the input files are located  
    **y_color**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for Y data  
    **color_table**=*style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **width**=*integer* [,*integer*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of the lines  
    **title_color**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for axis, tics, numbers, and title  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **x_title**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for X data  
    **y_title**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for Y data  
    **title**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for Graph  
    **y_range**=*min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum and maximum value for Y axis (min,max)  
    **y_tics**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Tic values for the Y axis  
    **x_scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale for X values  
    **y_scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale for Y values  
    **icon**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Symbol for point  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic/circle*  
    **point_size**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **secondary_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for point symbol edge color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **secondary_width**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of point symbol lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **-x**  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale only X labels, not values  
    **-y**  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale only Y labels, not values  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw points  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not draw lines  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **x_file** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of data file for X axis of graph  
    **y_file** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of data file(s) for Y axis of graph  
    **directory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to files  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the directory where the input files are located  
    **y_color** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for Y data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: color  
    **color_table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, colortable, *style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **width** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of the lines  
    **title_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for axis, tics, numbers, and title  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **x_title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for X data  
    **y_title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for Y data  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for Graph  
    **y_range** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum and maximum value for Y axis (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **y_tics** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tic values for the Y axis  
    **x_scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale for X values  
    **y_scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale for Y values  
    **icon** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Symbol for point  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic/circle*  
    **point_size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **secondary_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for point symbol edge color  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **secondary_width** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of point symbol lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *x*, *y*, *s*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Scale only X labels, not values  
    &nbsp;&nbsp;&nbsp;&nbsp;**y**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Scale only Y labels, not values  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw points  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not draw lines  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **x_file** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of data file for X axis of graph  
    **y_file** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of data file(s) for Y axis of graph  
    **directory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to files  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the directory where the input files are located  
    **y_color** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for Y data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: color  
    **color_table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, colortable, *style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **width** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of the lines  
    **title_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for axis, tics, numbers, and title  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **x_title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for X data  
    **y_title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for Y data  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for Graph  
    **y_range** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum and maximum value for Y axis (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **y_tics** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tic values for the Y axis  
    **x_scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale for X values  
    **y_scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale for Y values  
    **icon** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Symbol for point  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic/circle*  
    **point_size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **secondary_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for point symbol edge color  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **secondary_width** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of point symbol lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *x*, *y*, *s*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Scale only X labels, not values  
    &nbsp;&nbsp;&nbsp;&nbsp;**y**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Scale only Y labels, not values  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw points  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not draw lines  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.linegraph* is a module to draw simple x,y line graphs (plots) based
on numerical data contained in separate files.

### Data format

The X and Y data files for the graph are essentially a column of numbers
in each file, with one input number per line. The program expects that
each X value will have a corresponding Y value, therefore the number of
lines in each data input file should be the same. Essentially, the X
data becomes the X axis reference to which the Y data is plotted as a
line. Therefore, the X data should be a monotonically increasing
progression of numbers (i.e. "1,2,3,..."; "0, 10, 100, 1000,...";
"...-5,-1,0,1,5..."). If multiple Y data files are used, the Y axis
scale will be based on the range of minimum and maximum values from all
Y files, then all Y data given will be graphed according to that Y
scale. Therefore, if multiple Y data inputs are used with dissimilar
units, the graph produced comparing the two will be deceptive.

### File inputs

If the **directory** option is provided, the paths to files can (and
should) be only relative paths to these files. While this is not
recommended for scripting, it can be advantageous when typing the paths
manually. For example when all files are stored in the directory
`/home/john/data`, the user can provide the following in the command
line:

```sh
d.linegraph directory=/home/john/data x_file=x.txt y_file=y1.txt,y2.txt
```

### Managing colors

The user can specify the **y_color** option, the **color_table** option
or just leave the defaults to influence the color of the plotted lines.

Colors specified by **y_color** option are used for drawing the lines in
the graph. If multiple Y data files are used, an equal number of colors
may be used to control the colors of the lines. Colors will be assigned
to Y data in respect to the sequence of instantiation on the command
line. It can be one of GRASS named colors or the RGB values from
0-255 separated by colons (RRR:GGG:BBB).

Alternatively, the user can use the **color_table** option to specify
one of the GRASS predefined color tables.

By default, a series of colors will be chosen by the module if none are
provided upon invocation. The order of default colors is red, green,
violet, blue, orange, gray, brown, magenta, white, and indigo. The user
is advised not to rely on the order of default colors but to either use
the **y_color** or the **color_table** option to obtain predictable and
reproducible results.

The color to be used for titles, axis lines, tics, and scale numbers is
determined by the **title_color** option. The user can provide one of
the GRASS named colors (such as gray, white, or black) or use the
GRASS colon-separated format for RGB (RRR:GGG:BBB).

### Titles, labels, and tics

The **title** option specifies the text for the title of the graph. It
will be centered over the top of graph. The **x_title** option is a text
to describe data for X axis. It will be centered beneath the graph.
Default is no text unless there is a need for a unit descriptor
determined by the *d.linegraph* module, then string such as "in
hundreds" is generated. The **y_title** option is a text to describe
data for Y axis. It will be centered beneath the X data description.
Similarly, to the **x_title** option, default is no text unless there is
a need for an auto-generated description. In the case of graphs with
multiple lines (multiple inputs for Y axis), user may wish to use more
specific text placement using the *[d.text](d.text.md)* or
*[v.label](v.label.md)* programs.

## NOTES

For historical reasons, the *d.linegraph* module accepts titles of more
than one word where the underscore character ("\_") is used to represent
spaces (" "). For example "Census_data_1990" would be printed over the
graph as "Census data 1990". The use of underscores is not necessary to
use as long as the parameter is quoted in the command line. In general,
use of underscores is not recommended and there is no need to use it at
all in the GUI or when using *d.linegraph* in Python scripts.

The way the program locates and labels tic marks is less than perfect:  

1) although distances between Y tics are proportional to the value, they
are not proportional on the X axis;  
2) decimal values between -1 and 1 can be printed on the X axis, but not
on Y. (With respect to the later, the input for Y values can all be
multiplied by a factor of 10 before graphing).

Depending on the user's needs, it might be easier or more appropriate to
use a 3rd party tool such as xgraph, gnuplot, Matplotlib in Python, or R
instead of *d.linegraph*. For a more general solution for plotting in
GRASS, the user is advised to use the *[d.graph](d.graph.md)*
module.

## EXAMPLE

The following can be executed in Bash to create the input data for this
example. The user can just create these files in a text editor, save
them and specify path to them.

```sh
cat > x.txt <<EOF
1
3
4
6
9
EOF
cat > y1.txt <<EOF
50
58
65
34
27
EOF
cat > y2.txt <<EOF
10
20
35
50
45
EOF
```

The next command sequence creates a file `plot.png` in the current
directory which is the drawing made by *d.linegraph*.

```sh
d.mon start=cairo output=plot.png width=400 height=400
d.linegraph x_file=x.txt y_file=y1.txt,y2.txt
d.mon stop=cairo
```

## SEE ALSO

*[d.frame](d.frame.md), [d.text](d.text.md), [v.label](v.label.md),
[d.graph](d.graph.md), [d.histogram](d.histogram.md)*

## AUTHOR

Chris Rewerts, Agricultural Engineering, Purdue University

## SOURCE CODE

Available at: [d.linegraph source code](https://github.com/OSGeo/grass/tree/main/display/d.linegraph)
([history](https://github.com/OSGeo/grass/commits/main/display/d.linegraph))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
