---
name: db.createdb
description: Creates an empty database.
keywords: [ database, attribute table, SQL ]
---

# db.createdb

Creates an empty database.

=== "Command line"

    **db.createdb**
    **driver**=*name*
    **database**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.createdb driver=sqlite database=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.createdb***",
        **driver**=*"sqlite"*,
        **database**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.createdb", driver="sqlite", database="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_createdb*(**driver**=*"sqlite"*,
        **database**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_createdb(driver="sqlite", database="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **driver**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **driver** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **driver** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.createdb* allows the user to create a new empty database through
different drivers. A working database connection needs to be
established, see *[db.login](db.login.md)*.

Currently only [SQLite](grass-sqlite.md) and [PostgreSQL](grass-pg.md)
database drivers are supported.

## EXAMPLES

### Create a new SQLite file-based database

Note that the standard GRASS SQLite database is by default generated
in the user's current mapset. This example shows an out-of-mapset
database file creation:

```sh
db.createdb driver=sqlite database=/opt/sqlite.db
```

### Create a new PostgreSQL database

Create a new PostgreSQL database (after the PostgreSQL connection got
established through the *pg* driver):

```sh
db.createdb driver=pg database=grassdb
```

Create a new PostgreSQL database (after the PostgreSQL connection got
established through the *odbc* driver):

```sh
db.createdb driver=odbc database=grassdb
```

## TODO

Support other database drivers, too.

## SEE ALSO

*[db.columns](db.columns.md), [db.connect](db.connect.md),
[db.describe](db.describe.md), [db.drivers](db.drivers.md),
[db.dropdb](db.dropdb.md), [db.droptable](db.droptable.md),
[db.execute](db.execute.md), [db.login](db.login.md),
[db.tables](db.tables.md)*

[GRASS SQL interface](sql.md)

## AUTHORS

Radim Blazek, ITC-Irst, Trento, Italy  
SQLite and PostgreSQL support by Martin Landa, Czech Technical
University in Prague, Czech Republic

## SOURCE CODE

Available at: [db.createdb source code](https://github.com/OSGeo/grass/tree/main/db/db.createdb)
([history](https://github.com/OSGeo/grass/commits/main/db/db.createdb))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
