---
name: db.droptable.py
description: Drops an attribute table.
keywords: [ database, attribute table ]
---

# db.droptable.py

Drops an attribute table.

=== "Command line"

    **db.droptable.py**
    [**-f**]
    [**driver**=*name*]
    [**database**=*name*]
    **table**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.droptable.py table=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.droptable.py***",
        **driver**=*None*,
        **database**=*None*,
        **table**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.droptable.py", table="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_droptable_py*(**driver**=*None*,
        **database**=*None*,
        **table**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_droptable_py(table="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given then default driver is used  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given then default database is used  
    **table**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of table to drop  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force removal (required for actual deletion of files)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given then default driver is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given then default database is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of table to drop  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force removal (required for actual deletion of files)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given then default driver is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given then default database is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of table to drop  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force removal (required for actual deletion of files)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.droptable* drops an attribute table. If the **-f** force flag is not
given then nothing is removed, instead a preview of the action to be
taken is printed.

## NOTES

*db.droptable* is a front-end to *[db.execute](db.execute.md)* to allow
easier usage. To some extent it is verified if the table is connected to
a vector map to avoid accidental table removal.

## EXAMPLES

### Removing an attribute table from default database

```sh
# show default database
db.connect -p

# show available tables
db.tables -p

# this will show what would happen
db.droptable table=sometable

# actually drop the table
db.droptable -f table=sometable
```

### Removing an attribute table from given database

*db.droptable* allows defining optionally **driver** and **database**
options different from default connection settings (`db.connect -p`).

```sh
# drop the table from SQLite database
db.droptable -f table=sometable driver=sqlite database=/opt/sqlite.db
```

## SEE ALSO

*[db.dropdb](db.dropdb.md), [db.dropcolumn](db.dropcolumn.md),
[db.execute](db.execute.md), [db.login](db.login.md),
[db.connect](db.connect.md), [db.tables](db.tables.md),
[db.describe](db.describe.md), [v.db.droptable](v.db.droptable.md),*

[GRASS SQL interface](sql.md)

## AUTHORS

Markus Neteler  
Driver and database options added by Martin Landa, Czech Technical
University in Prague, Czech Republic

## SOURCE CODE

Available at: [db.droptable source code](https://github.com/OSGeo/grass/tree/main/scripts/db.droptable)
([history](https://github.com/OSGeo/grass/commits/main/scripts/db.droptable))  
Latest change: Wednesday Mar 12 22:27:28 2025 in commit [0095480](https://github.com/OSGeo/grass/commit/0095480779ff07f10b76a859388850c52b9dccbd)
