---
name: i.fft
description: Fast Fourier Transform (FFT) for image processing.
keywords: [ imagery, transformation, Fast Fourier Transform ]
---

# i.fft

Fast Fourier Transform (FFT) for image processing.

=== "Command line"

    **i.fft**
    **input**=*name*
    **real**=*name*
    **imaginary**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.fft input=name real=name imaginary=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.fft***",
        **input**,
        **real**,
        **imaginary**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.fft", input="name", real="name", imaginary="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_fft*(**input**,
        **real**,
        **imaginary**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_fft(input="name", real="name", imaginary="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **real**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output real part arrays stored as raster map  
    **imaginary**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output imaginary part arrays stored as raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **real** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output real part arrays stored as raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **imaginary** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output imaginary part arrays stored as raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **real** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output real part arrays stored as raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **imaginary** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output imaginary part arrays stored as raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.fft* is an image processing program based on the FFT algorithm given
by Frigo et al. (1998), that processes a single input raster map layer
(**input**) and constructs the real and imaginary Fourier components in
frequency space.

## NOTES

The real and imaginary components are stored into the **real** and
**imaginary** raster map layers. In these raster map layers the low
frequency components are in the center and the high frequency components
are toward the edges. The **input** need not be square. A color table is
assigned to the resultant map layer.

The current geographic region and mask settings are respected when
reading the input file. The presence of nulls or a mask will make the
resulting fast Fourier transform invalid.

## EXAMPLE

North Carolina example:

```sh
g.region raster=lsat7_2002_70
i.fft input=lsat7_2002_70 real=lsat7_2002_70.real imaginary=lsat7_2002_70.imag

# set region to resulting FFT output map (due to new FFT coordinate space):
g.region raster=lsat7_2002_70.real -p
d.mon x0
d.rast lsat7_2002_70.real
d.rast lsat7_2002_70.imag
```

## REFERENCES

- M. Frigo and S. G. Johnson (1998): "FFTW: An Adaptive Software
  Architecture for the FFT". See [www.FFTW.org](https://fftw.org): FFTW
  is a C subroutine library for computing the Discrete Fourier Transform
  (DFT) in one or more dimensions, of both real and complex data, and of
  arbitrary input size.
- John A. Richards, 1986. Remote Sensing Digital Image Analysis,
  Springer-Verlag.
- Personal communication, between program author and Ali R. Vali, Space
  Research Center, [University of Texas](https://www.utexas.edu),
  Austin, 1990.

## SEE ALSO

*[i.cca](i.cca.md), [g.gui.iclass](g.gui.iclass.md),
[i.ifft](i.ifft.md), [i.pca](i.pca.md)*

## AUTHORS

David Satnik, GIS Laboratory, Central Washington University  
Glynn Clements (FFTW support)

## SOURCE CODE

Available at: [i.fft source code](https://github.com/OSGeo/grass/tree/main/imagery/i.fft)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.fft))  
Latest change: Friday Jan 02 21:25:59 2026 in commit [83362df](https://github.com/OSGeo/grass/commit/83362df5af36c1e7d95fad93dff0a57b4dfde476)
