---
hide:
  - toc
---

# Topic: hydrology

| Tool | Description |
|--------|-------------|
| [r.basins.fill](r.basins.fill.md) | Generates watershed subbasins raster map. |
| [r.carve](r.carve.md) | Generates stream channels. Takes vector stream data, transforms it to raster and subtracts depth from the output DEM. |
| [r.drain](r.drain.md) | Traces a flow through an elevation model or cost surface on a raster map. |
| [r.fill.dir](r.fill.dir.md) | Filters and generates a depressionless elevation map and a flow direction map from a given elevation raster map. |
| [r.flow](r.flow.md) | Constructs flowlines. Computes flowlines, flowpath lengths, and flowaccumulation (contributing areas) from a elevation raster map. |
| [r.lake](r.lake.md) | Fills lake at given point to given level. |
| [r.path](r.path.md) | Traces paths from starting points following input directions. |
| [r.sim.sediment](r.sim.sediment.md) | Sediment transport and erosion/deposition simulation using path sampling method (SIMWE). |
| [r.sim.water](r.sim.water.md) | Overland flow hydrologic simulation using path sampling method (SIMWE). |
| [r.solute.transport](r.solute.transport.md) | Numerical calculation program for transient, confined and unconfined solute transport in two dimensions |
| [r.stream.extract](r.stream.extract.md) | Performs stream network extraction. |
| [r.terraflow](r.terraflow.md) | Performs flow computation for massive grids. |
| [r.topidx](r.topidx.md) | Creates a topographic index (wetness index) raster map from an elevation raster map. |
| [r.topmodel](r.topmodel.md) | Simulates TOPMODEL which is a physically based hydrologic model. |
| [r.uslek](r.uslek.md) | Computes USLE Soil Erodibility Factor (K). |
| [r.usler](r.usler.md) | Computes USLE R factor, Rainfall erosivity index. |
| [r.water.outlet](r.water.outlet.md) | Creates watershed basins from a drainage direction map. |
| [r.watershed](r.watershed.md) | Calculates hydrological parameters and RUSLE factors. |
| [r3.flow](r3.flow.md) | Computes 3D flow lines and 3D flow accumulation. |

*See also the corresponding keyword for additional references:*

<!-- topic_keyword { include: [hydrology] } -->
