---
name: v.lidar.correction
description: Corrects the v.lidar.growing output. It is the last of the three algorithms for LIDAR filtering.
keywords: [ vector, LIDAR ]
---

# v.lidar.correction

Corrects the v.lidar.growing output. It is the last of the three algorithms for LIDAR filtering.

=== "Command line"

    **v.lidar.correction**
    [**-e**]
    **input**=*name*
    **output**=*name*
    **terrain**=*name*
    [**ew_step**=*float*]
    [**ns_step**=*float*]
    [**lambda_c**=*float*]
    [**tch**=*float*]
    [**tcl**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.lidar.correction input=name output=name terrain=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.lidar.correction***",
        **input**,
        **output**,
        **terrain**,
        **ew_step**=*None*,
        **ns_step**=*None*,
        **lambda_c**=*1*,
        **tch**=*2*,
        **tcl**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.lidar.correction", input="name", output="name", terrain="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_lidar_correction*(**input**,
        **output**,
        **terrain**,
        **ew_step**=*None*,
        **ns_step**=*None*,
        **lambda_c**=*1*,
        **tch**=*2*,
        **tcl**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_lidar_correction(input="name", output="name", terrain="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input observation vector map name (v.lidar.growing output)  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output classified vector map name  
    **terrain**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output only 'terrain' points vector map  
    **ew_step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the east-west direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 25 \* east-west resolution  
    **ns_step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the north-south direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 25 \* north-south resolution  
    **lambda_c**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization weight in reclassification evaluation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **tch**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;High threshold for object to terrain reclassification  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **tcl**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low threshold for terrain to object reclassification  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Estimate point density and distance and quit  
    &nbsp;&nbsp;&nbsp;&nbsp;Estimate point density and distance in map units for the input vector points within the current region extents and quit  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input observation vector map name (v.lidar.growing output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output classified vector map name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **terrain** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output only 'terrain' points vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **ew_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the east-west direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 25 \* east-west resolution  
    **ns_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the north-south direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 25 \* north-south resolution  
    **lambda_c** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization weight in reclassification evaluation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **tch** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;High threshold for object to terrain reclassification  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **tcl** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low threshold for terrain to object reclassification  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estimate point density and distance and quit  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estimate point density and distance in map units for the input vector points within the current region extents and quit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input observation vector map name (v.lidar.growing output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output classified vector map name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **terrain** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output only 'terrain' points vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **ew_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the east-west direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 25 \* east-west resolution  
    **ns_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the north-south direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 25 \* north-south resolution  
    **lambda_c** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization weight in reclassification evaluation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **tch** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;High threshold for object to terrain reclassification  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **tcl** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low threshold for terrain to object reclassification  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estimate point density and distance and quit  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estimate point density and distance in map units for the input vector points within the current region extents and quit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.lidar.correction* is the last of three steps to filter LiDAR data.
The filter aims to recognize and extract attached and detached object
(such as buildings, bridges, power lines, trees, etc.) in order to
create a Digital Terrain Model.  
  
The module, which could be iterated several times, makes a comparison
between the LiDAR observations and a bilinear spline interpolation with
a Tychonov regularization parameter performed on the TERRAIN SINGLE
PULSE points only. The gradient is minimized by the regularization
parameter. Analysis of the residuals between the observations and the
interpolated values results in four cases (the next classification is
referred to that of the v.lidar.growing output vector):  
  
**a)** Points classified as TERRAIN differing more than a threshold
value are interpreted and reclassified as OBJECT, for both single and
double pulse points.  
  
**b)** Points classified as OBJECT and closed enough to the interpolated
surface are interpreted and reclassified as TERRAIN, for both single and
double pulse points.

The length (in mapping units) of each spline step is defined by
**ew_step** for the east-west direction and **ns_step** for the
north-south direction.

## NOTES

The input should be the output of *v.lidar.growing* module or the output
of this *v.lidar.correction* itself. That means, this module could be
applied more times (although, two are usually enough) for a better
filter solution. The outputs are a vector map with a final point
classification as as TERRAIN SINGLE PULSE, TERRAIN DOUBLE PULSE, OBJECT
SINGLE PULSE or OBJECT DOUBLE PULSE; and an vector map with only the
points classified as TERRAIN SINGLE PULSE or TERRAIN DOUBLE PULSE. The
final result of the whole procedure (*v.lidar.edgedetection*,
*v.lidar.growing*, *v.lidar.correction*) will be a point classification
in four categories:  
  
TERRAIN SINGLE PULSE (cat = 1, layer = 2)  
TERRAIN DOUBLE PULSE (cat = 2, layer = 2)  
OBJECT SINGLE PULSE (cat = 3, layer = 2)  
OBJECT DOUBLE PULSE (cat = 4, layer = 2)

## EXAMPLES

### Basic correction procedure

```sh
v.lidar.correction input=growing output=correction out_terrain=only_terrain
```

### Second correction procedure

```sh
v.lidar.correction input=correction output=correction_bis terrain=only_terrain_bis
```

## REFERENCES

Antolin, R. et al., 2006. Digital terrain models determination by LiDAR
technology: Po basin experimentation. Bolletino di Geodesia e Scienze
Affini, anno LXV, n. 2, pp. 69-89.  
  
Brovelli M. A., Cannata M., Longoni U.M., 2004. LIDAR Data Filtering and
DTM Interpolation Within GRASS, Transactions in GIS, April 2004, vol. 8,
iss. 2, pp. 155-174(20), Blackwell Publishing Ltd.  
  
Brovelli M. A., Cannata M., 2004. Digital Terrain model reconstruction
in urban areas from airborne laser scanning data: the method and an
example for Pavia (Northern Italy). Computers and Geosciences 30 (2004)
pp.325-331  
  
Brovelli M. A. and Longoni U.M., 2003. Software per il filtraggio di
dati LIDAR, Rivista dell'Agenzia del Territorio, n. 3-2003, pp. 11-22
(ISSN 1593-2192).  
  
Brovelli M. A., Cannata M. and Longoni U.M., 2002. DTM LIDAR in area
urbana, Bollettino SIFET N.2, pp. 7-26.  
  
Performances of the filter can be seen in the [ISPRS WG III/3 Comparison
of Filters](https://www.itc.nl/isprs/wgIII-3/filtertest/) report by
Sithole, G. and Vosselman, G., 2003.

## SEE ALSO

*[v.lidar.edgedetection](v.lidar.edgedetection.md),
[v.lidar.growing](v.lidar.growing.md),
[v.surf.bspline](v.surf.bspline.md), [v.surf.rst](v.surf.rst.md),
[v.in.pdal](v.in.pdal.md), [v.in.ascii](v.in.ascii.md)*

## AUTHORS

Original version of program in GRASS 5.4:  
Maria Antonia Brovelli, Massimiliano Cannata, Ulisse Longoni and Mirko
Reguzzoni  
  
Update for GRASS 6.X:  
Roberto Antolin and Gonzalo Moreno

## SOURCE CODE

Available at: [v.lidar.correction source code](https://github.com/OSGeo/grass/tree/main/vector/v.lidar.correction)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.lidar.correction))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
