---
name: v.overlay
description: Overlays two vector maps offering clip, intersection, difference, symmetrical difference, union operators.
keywords: [ vector, geometry, spatial query, clip, difference, intersection, union ]
---

# v.overlay

Overlays two vector maps offering clip, intersection, difference, symmetrical difference, union operators.

=== "Command line"

    **v.overlay**
    [**-t**]
    **ainput**=*name*
    [**alayer**=*string*]
    [**atype**=*string* [,*string*,...]]
    **binput**=*name*
    [**blayer**=*string*]
    [**btype**=*string* [,*string*,...]]
    **operator**=*string*
    **output**=*name*
    [**olayer**=*string* [,*string*,...]]
    [**snap**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.overlay ainput=name binput=name operator=and output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.overlay***",
        **ainput**,
        **alayer**=*"1"*,
        **atype**=*"auto"*,
        **binput**,
        **blayer**=*"1"*,
        **btype**=*"area"*,
        **operator**,
        **output**,
        **olayer**=*"1,0,0"*,
        **snap**=*1e-8*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.overlay", ainput="name", binput="name", operator="and", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_overlay*(**ainput**,
        **alayer**=*"1"*,
        **atype**=*"auto"*,
        **binput**,
        **blayer**=*"1"*,
        **btype**=*"area"*,
        **operator**,
        **output**,
        **olayer**=*"1,0,0"*,
        **snap**=*1e-8*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_overlay(ainput="name", binput="name", operator="and", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **ainput**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map (A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **alayer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name (vector map A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **atype**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type (vector map A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, area, auto*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *auto*  
    **binput**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **blayer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name (vector map B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **btype**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type (vector map B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area*  
    **operator**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Operator defines features written to output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature is written to output if the result of operation 'ainput operator binput' is true. Input feature is considered to be true, if category of given layer is defined.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *and, or, not, xor*  
    &nbsp;&nbsp;&nbsp;&nbsp;**and**: also known as 'intersection' in GIS  
    &nbsp;&nbsp;&nbsp;&nbsp;**or**: also known as 'union' in GIS (only for atype=area)  
    &nbsp;&nbsp;&nbsp;&nbsp;**not**: also known as 'difference' (features from ainput not overlaid by features from binput)  
    &nbsp;&nbsp;&nbsp;&nbsp;**xor**: also known as 'symmetrical difference' (features from either ainput or binput but not those from ainput overlaid by binput (only for atype=area)  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **olayer**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Output layer for new category, ainput and binput  
    &nbsp;&nbsp;&nbsp;&nbsp;If 0 or not given, the category is not written  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1,0,0*  
    **snap**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Snapping threshold for boundaries  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable snapping with snap &lt;= 0  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1e-8*  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **ainput** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map (A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **alayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name (vector map A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **atype** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type (vector map A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, area, auto*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *auto*  
    **binput** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **blayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name (vector map B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **btype** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type (vector map B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area*  
    **operator** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operator defines features written to output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature is written to output if the result of operation 'ainput operator binput' is true. Input feature is considered to be true, if category of given layer is defined.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *and, or, not, xor*  
    &nbsp;&nbsp;&nbsp;&nbsp;**and**: also known as 'intersection' in GIS  
    &nbsp;&nbsp;&nbsp;&nbsp;**or**: also known as 'union' in GIS (only for atype=area)  
    &nbsp;&nbsp;&nbsp;&nbsp;**not**: also known as 'difference' (features from ainput not overlaid by features from binput)  
    &nbsp;&nbsp;&nbsp;&nbsp;**xor**: also known as 'symmetrical difference' (features from either ainput or binput but not those from ainput overlaid by binput (only for atype=area)  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **olayer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output layer for new category, ainput and binput  
    &nbsp;&nbsp;&nbsp;&nbsp;If 0 or not given, the category is not written  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1,0,0*  
    **snap** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Snapping threshold for boundaries  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable snapping with snap &lt;= 0  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1e-8*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **ainput** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map (A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **alayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name (vector map A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **atype** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type (vector map A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, area, auto*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *auto*  
    **binput** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **blayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name (vector map B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **btype** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type (vector map B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area*  
    **operator** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operator defines features written to output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature is written to output if the result of operation 'ainput operator binput' is true. Input feature is considered to be true, if category of given layer is defined.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *and, or, not, xor*  
    &nbsp;&nbsp;&nbsp;&nbsp;**and**: also known as 'intersection' in GIS  
    &nbsp;&nbsp;&nbsp;&nbsp;**or**: also known as 'union' in GIS (only for atype=area)  
    &nbsp;&nbsp;&nbsp;&nbsp;**not**: also known as 'difference' (features from ainput not overlaid by features from binput)  
    &nbsp;&nbsp;&nbsp;&nbsp;**xor**: also known as 'symmetrical difference' (features from either ainput or binput but not those from ainput overlaid by binput (only for atype=area)  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **olayer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output layer for new category, ainput and binput  
    &nbsp;&nbsp;&nbsp;&nbsp;If 0 or not given, the category is not written  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1,0,0*  
    **snap** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Snapping threshold for boundaries  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable snapping with snap &lt;= 0  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1e-8*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.overlay* allows the user to overlay two vector maps. Features in
**ainput** can be lines or areas and are cut with areas in **binput**.
Simple *clipping* can be performed with the **and** operator.

If areas in **ainput** are overlaid with areas in **binput**, it is
sometimes necessary to snap areas of **binput** to those of **ainput**,
otherwise areas can go missing or many sliver areas can be created.
Snapping is enabled by default and can be disabled by setting the
**snap** option to a negative value. Recommended values are between
0.00000001 and 0.0001. Using larger values for snapping can have
undesired side-effects, but may sometimes be necessary to get a clean
output (see example below). In general, it is recommended to start with
a small snapping threshold, gradually increasing the threshold until the
result is reasonably clean. Snapping modifies only boundaries in binput,
which are snapped to boundaries in ainput. Boundaries in **ainput** are
not modified.

## NOTES

Currently only areas in **ainput** are supported for the operators *or*
and *xor*! See also *[v.select](v.select.md)*. The operator defines what
kind of operation will be done. Features are written to output, if the
result of an operation **ainput** operator **binput** is true.

If the *first* number of the **olayer** option is greater than 0, then
the resulting output map has a merged attribute table in the given layer
number. The original column names have a prefix (*a\_* and *b\_*)
corresponding to **ainput** and **binput** map.

If the *second* number of the **olayer** option is greater than 0, then
the categories of **ainput** in layer **alayer** are transferred to the
output layer with the second number.

If the *third* number of the **olayer** option is greater than 0, then
the categories of **binput** in layer *blayer* are transferred to the
output layer with the third number.

If **atype**=auto is given than *v.overlay* determines feature type for
**ainput** from the first found feature.

## EXAMPLES

Preparation of example data (North Carolina sample dataset):

```sh
# Create an empty box for overlaying to ZIP code vector map
v.mkgrid map=box grid=1,1 position=coor coordinates=584037,201970 box=50000,50000

# set region to ZIP codes and box vector maps
g.region vector=zipcodes_wake,box -p res=100 -a
# enlarge region a bit for "white border" around map in monitor
g.region n=n+1000 s=s-1000 w=w-1000 e=e+1000 -p
d.mon wx0
```

### AND operator

Clipping example (no attribute table is generated here):

```sh
d.vect map=zipcodes_wake fill_color=0:128:0
d.vect map=box fill_color=85:130:176
v.overlay -t ainput=box binput=zipcodes_wake operator=and output=v_overlay_AND
d.vect map=v_overlay_AND
```

![v.overlay with AND operator](v_overlay_op_and.png)  
*Figure: v.overlay with AND operator (selected polygons in yellow
color)*

### OR operator

Union example of areas:

```sh
d.vect map=zipcodes_wake fill_color=0:128:0
d.vect map=box fill_color=85:130:176
v.overlay -t ainput=box binput=zipcodes_wake operator=or output=v_overlay_OR
d.vect map=v_overlay_OR
```

![v.overlay with OR operator](v_overlay_op_or.png)  
*Figure: v.overlay with OR operator (selected polygons in yellow color)*

### XOR operator

Symmetrical difference example:

```sh
d.vect map=zipcodes_wake fill_color=0:128:0
d.vect map=box fill_color=85:130:176
v.overlay -t ainput=box binput=zipcodes_wake operator=xor output=v_overlay_XOR
d.vect map=v_overlay_XOR
```

![v.overlay with XOR operator](v_overlay_op_xor.png)  
*Figure: v.overlay with XOR operator (selected polygons in yellow
color)*

### NOT operator

Difference example:

```sh
d.vect map=zipcodes_wake fill_color=0:128:0
d.vect map=box fill_color=85:130:176
v.overlay -t ainput=box binput=zipcodes_wake operator=not output=v_overlay_NOT
d.vect map=v_overlay_NOT
```

![v.overlay with NOT operator](v_overlay_op_not.png)  
*Figure: v.overlay with NOT operator (selected polygon in yellow color)*

### Overlay operations: AND, OR, NOT, XOR

ZIP code examples, based on North Carolina sample dataset:

```sh
# creation of simple dataset
v.extract input=zipcodes_wake output=poly1 where="cat = 42"
v.extract input=urbanarea output=poly2 where="cat = 55"

v.overlay ainput=poly1 binput=poly2 operator=and output=poly_1_2_and
v.overlay ainput=poly1 binput=poly2 operator=or  output=poly_1_2_or
v.overlay ainput=poly1 binput=poly2 operator=not output=poly_1_2_not
v.overlay ainput=poly1 binput=poly2 operator=xor output=poly_1_2_xor
```

![GRASS v.overlay: input polygons (1 and 2)](v_overlay_poly_1_2.png)  
*Figure: v.overlay operations: original input polygons*

![GRASS v.overlay results: AND, OR, NOT, XOR operations](v_overlay_poly_1_2_a_o_n_x.png)  
*Figure: v.overlay results of AND, OR, NOT, XOR operations*

### Polygons overlaid with polygons

```sh
v.overlay ainput=lake binput=province output=lakeXprovince operator=or
```

Polygon union of urban area and Census 2000 areas (North Carolina
dataset):

```sh
# input maps
d.vect urbanarea
d.vect census_wake2000

# union
v.overlay ain=census_wake2000 bin=urbanarea out=urban_census2000 operator=or

# show result, graphically zooming a subset
g.region n=230400 s=223800 w=655800 e=662400
d.erase
d.vect urban_census2000

# show merged attribute table
v.db.select urban_census2000 where="cat=108" -v
cat|108
a_cat|98
a_AREA|231001264
a_PERIMETE|67804.305
a_TRACT_|98
a_TRACT_ID|98
a_RINGS_OK|1
a_RINGS_NO|0
a_ID|98
a_FIPSSTCO|37183
a_TRT2000|054108
a_STFID|37183054108
a_TRACTID|541.08
a_TRACT|541.08
b_cat|55
b_OBJECTID|55
b_UA|73261
b_NAME|Raleigh
b_UA_TYPE|UA
```

![GRASS v.overlay: polygon to polygon union (input 1)](v_overlay_urbanarea.png)
![GRASS v.overlay: polygon to polygon union (input 2)](v_overlay_census_wake2000.png)
![GRASS v.overlay: polygon to polygon union (result)](v_overlay_urban_census2000.png)  
*Figure: v.overlay: Polygon union (right) of urban area (left) and
Census 2000 (middle) areas (North Carolina dataset)*

As can be seen by the resulting large number of centroids on boundaries,
the urban areas do not match exactly the Census 2000 areas. In this case
a clean result can be obtained by snapping with a threshold of 0.1 m.

### Lines overlaid with polygons

Using the North Carolina sample dataset, we clip the roads map to the
area of city of Raleigh, preserving road attributes in layer 1:

```sh
g.region vector=zipcodes_wake

# extract Raleigh city:
v.extract in=zipcodes_wake out=raleigh where="ZIPNAME = 'RALEIGH'"

# clip road network to city polygon:
v.overlay ainput=roadsmajor atype=line binput=raleigh out=roadsmajor_raleigh operator=and olayer=0,1,0
```

![GRASS v.overlay: Line to polygon clipping](v_overlay_area_lines.png)  
*Figure: v.overlay: Line to polygon clipping*

## SEE ALSO

*[v.clip](v.clip.md), [v.db.connect](v.db.connect.md),
[v.select](v.select.md), [g.copy](g.copy.md)*

## AUTHORS

Radim Blazek, ITC-Irst, Trento, Italy  
Markus Metz  
Speedup for large, complex input areas sponsored by
[mundialis](https://www.mundialis.de)

## SOURCE CODE

Available at: [v.overlay source code](https://github.com/OSGeo/grass/tree/main/vector/v.overlay)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.overlay))  
Latest change: Monday Feb 09 18:47:00 2026 in commit [fe51d38](https://github.com/OSGeo/grass/commit/fe51d3824fc8d5aa0e1ced4d9110214dc0192676)
