---
name: v.profile
description: Vector map profiling tool
keywords: [ vector, profile, transect ]
---

# v.profile

Vector map profiling tool

=== "Command line"

    **v.profile**
    [**-cz**]
    **input**=*name*
    [**type**=*string* [,*string*,...]]
    [**where**=*sql_query*]
    [**layer**=*string*]
    [**output**=*string*]
    [**separator**=*character*]
    [**dp**=*integer*]
    [**format**=*name*]
    **buffer**=*float*
    [**map_output**=*name*]
    [**coordinates**=*east,north* [,*east,north*,...]]
    [**profile_map**=*name*]
    [**profile_where**=*sql_query*]
    [**profile_layer**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.profile input=name buffer=10
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***v.profile***",
        **input**,
        **type**=*"point,line"*,
        **where**=*None*,
        **layer**=*"1"*,
        **output**=*"-"*,
        **separator**=*"pipe"*,
        **dp**=*2*,
        **format**=*"plain"*,
        **buffer**=*10*,
        **map_output**=*None*,
        **coordinates**=*None*,
        **profile_map**=*None*,
        **profile_where**=*None*,
        **profile_layer**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("v.profile", input="name", format="json", buffer=10)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_profile*(**input**,
        **type**=*"point,line"*,
        **where**=*None*,
        **layer**=*"1"*,
        **output**=*"-"*,
        **separator**=*"pipe"*,
        **dp**=*2*,
        **format**=*"plain"*,
        **buffer**=*10*,
        **map_output**=*None*,
        **coordinates**=*None*,
        **profile_map**=*None*,
        **profile_where**=*None*,
        **profile_layer**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_profile(input="name", format="json", buffer=10)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line*  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Use features only from specified layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to output text file or - for stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **dp**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-32*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **format**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text with pipe separator  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **buffer**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer (tolerance) for points in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;How far points can be from sampling line  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **map_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for profile line and buffer output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Profile line and buffer around it will be written  
    **coordinates**=*east,north* [,*east,north*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates for profiling line nodes  
    &nbsp;&nbsp;&nbsp;&nbsp;Specify profiling line vertices and nodes  
    **profile_map**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Profiling line map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map containing profiling line  
    **profile_where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions for input profile line map  
    &nbsp;&nbsp;&nbsp;&nbsp;Use to select only one line from profiling line map  
    **profile_layer**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Profiling line map layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not print column names  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not print 3D vector data (z values)  
    &nbsp;&nbsp;&nbsp;&nbsp;Only affects 3D vectors  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Use features only from specified layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to output text file or - for stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **dp** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-32*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text with pipe separator  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **buffer** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer (tolerance) for points in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;How far points can be from sampling line  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **map_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for profile line and buffer output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Profile line and buffer around it will be written  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates for profiling line nodes  
    &nbsp;&nbsp;&nbsp;&nbsp;Specify profiling line vertices and nodes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **profile_map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Profiling line map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map containing profiling line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **profile_where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions for input profile line map  
    &nbsp;&nbsp;&nbsp;&nbsp;Use to select only one line from profiling line map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **profile_layer** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Profiling line map layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not print column names  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not print 3D vector data (z values)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only affects 3D vectors  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Use features only from specified layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to output text file or - for stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **dp** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-32*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text with pipe separator  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **buffer** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer (tolerance) for points in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;How far points can be from sampling line  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **map_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for profile line and buffer output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Profile line and buffer around it will be written  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates for profiling line nodes  
    &nbsp;&nbsp;&nbsp;&nbsp;Specify profiling line vertices and nodes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **profile_map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Profiling line map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map containing profiling line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **profile_where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions for input profile line map  
    &nbsp;&nbsp;&nbsp;&nbsp;Use to select only one line from profiling line map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **profile_layer** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Profiling line map layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not print column names  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not print 3D vector data (z values)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only affects 3D vectors  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.profile* prints out distance and attributes of points/lines along a
profiling line. Distance is calculated from the first profiling line
coordinate pair or from the beginning of vector line.
The *buffer* (tolerance) parameter sets how far point can be located
from a profiling line and still be included in the output data set.  
The *output* map option can be used to visually check which points are
profiled. The *buffer* (tolerance) setting does not affect lines. Lines
are sampled at their crossing point with profiling line.

By default Z values are printed if input vector is a 3D map. It can be
disabled with the **-z** flag.  
The profiling line can be provided as N,E coordinate pairs or from an
input vector map. As a profiling line must be a single line, the user
should use the *profile_where* parameter to select a single line from a
profile input map if it contains multiple vector features.

## NOTES

Currently the module can profile only points and lines (including 3D
ones). Areas and other complex features are not supported. If in future
users can provide reasonable examples how area sampling should work and
why it is important, area (or any other feature type) sampling can be
added.

Due to bugs in GRASS native buffering algorithms, this module for now
depends on GEOS and will not function if GRASS is compiled without GEOS.
This restriction will be removed as soon as GRASS native buffer
generation is fixed.

## EXAMPLES

List all geonames along part of road NC-96 (NC Basic dataset). The
output will be stored in a file for later usage. We will use comma as
delimiter and three numbers after decimal separator for distance. Output
file will contain data for all points, that are within 500 m range to
profiling line.

```sh
v.profile input=geonames@PERMANENT output=/home/user/NC_96_geonames.csv\
  separator=comma dp=3 buffer=500 profile_map=roadsmajor@PERMANENT profile_where=cat=56

# Now lets see the output:
cat NC_96_geonames.csv
Number,Distance,cat,GEONAMEID,NAME,ASCIINAME,ALTERNATEN,FEATURECLA,FEATURECOD,COUNTRYCOD,CC2,ADMIN1,POPULATION,ELEVATION,GTOPO30,TIMEZONE,MODIFICATI,PPLKEY,SRC_ID,MAINT_ID
1,360.719,26881,4482019,"New Zebulon Elementary School","New Zebulon Elementary School","","S","SCH","US","","NC",0,106,91,"America/Iqaluit","2006-01-15 00:00:00",0,0,0
2,846.806,22026,4476596,"Little River, Township of","Little River, Township of","","A","ADMD","US","","NC",0,0,91,"America/Iqaluit","2006-01-15 00:00:00",0,0,0
3,2027.918,16681,4470608,"Hendricks Pond","Hendricks Pond","","H","RSV","US","","NC",0,0,91,"America/Iqaluit","2006-01-15 00:00:00",0,0,0
4,2027.918,16690,4470622,"Hendricks Dam","Hendricks Dam","","S","DAM","US","","NC",0,0,91,"America/Iqaluit","2006-01-15 00:00:00",0,0,0
5,2999.214,39338,4496159,"Union Chapel","Union Chapel","","","","US","","NC",0,0,96,"America/Iqaluit","2006-01-15 00:00:00",0,0,0
6,3784.992,43034,4500325,"Zebulon Airport","Zebulon Airport","","S","AIRP","US","","NC",0,108,98,"America/Iqaluit","2006-01-15 00:00:00",0,0,0
```

Create river valley crossection and provide river marker (Spearfish
dataset):

```sh
# Take elevation samples
r.profile input=elevation.dem@PERMANENT output=/home/user/elevation.profile \
  profile=600570.27364,4920613.41838,600348.034348,4920840.38617

# Now get distance to place where river marker should be set
v.profile input=streams@PERMANENT output=/home/user/river_profile.csv \
  east_north=600570.27364,4920613.41838,600348.034348,4920840.38617
```

### CSV Output

```sh
v.profile input=firestations@PERMANENT buffer=100 \
  profile_map=railroads@PERMANENT profile_where="cat=3202" \
  format=csv
```

The output looks as follows:

```text
Number,Distance,cat,ID,LABEL,LOCATION,CITY,MUN_COUNT,PUMPERS,PUMPER_TAN,TANKER,MINI_PUMPE,RESCUE_SER,AERIAL,BRUSH,OTHERS,WATER_RESC,MUNCOID,BLDGCODE,AGENCY,STATIONID,RECNO,CV_SID2,CVLAG
1,2750.44,60,42,"Morrisville #2","10632 Chapel Hill Rd","Morrisville","M",0,1,0,0,0,1,0,1,0,1,"298","FD","MF2A",62,"MF2A",1.4
2,5394.27,2,23,"Morrisville #1","100 Morrisville-Carpenter Rd","Morrisville","M",0,1,0,0,1,0,1,3,0,1,"241","FD","MF1A",2,"MF1A",1.4
```

**Note:** You can use different delimiters with the `separator=` option
(e.g., `separator=comma`, `separator=tab`, `separator=space`).

### JSON Output

```sh
v.profile input=firestations@PERMANENT buffer=100 \
  profile_map=railroads@PERMANENT profile_where="cat=3202" \
  format=json
```

The output looks as follows:

```json
[
    {
        "category": 60,
        "distance": 2750.4354923389592,
        "attributes": {
            "cat": 60,
            "ID": 42,
            "LABEL": "Morrisville #2",
            "LOCATION": "10632 Chapel Hill Rd",
            "CITY": "Morrisville",
            "MUN_COUNT": "M",
            "PUMPERS": 0,
            "PUMPER_TAN": 1,
            "TANKER": 0,
            "MINI_PUMPE": 0,
            "RESCUE_SER": 0,
            "AERIAL": 1,
            "BRUSH": 0,
            "OTHERS": 1,
            "WATER_RESC": 0,
            "MUNCOID": 1,
            "BLDGCODE": "298",
            "AGENCY": "FD",
            "STATIONID": "MF2A",
            "RECNO": 62,
            "CV_SID2": "MF2A",
            "CVLAG": 1.3999999999999999
        }
    },
    {
        "category": 2,
        "distance": 5394.2668921394143,
        "attributes": {
            "cat": 2,
            "ID": 23,
            "LABEL": "Morrisville #1",
            "LOCATION": "100 Morrisville-Carpenter Rd",
            "CITY": "Morrisville",
            "MUN_COUNT": "M",
            "PUMPERS": 0,
            "PUMPER_TAN": 1,
            "TANKER": 0,
            "MINI_PUMPE": 0,
            "RESCUE_SER": 1,
            "AERIAL": 0,
            "BRUSH": 1,
            "OTHERS": 3,
            "WATER_RESC": 0,
            "MUNCOID": 1,
            "BLDGCODE": "241",
            "AGENCY": "FD",
            "STATIONID": "MF1A",
            "RECNO": 2,
            "CV_SID2": "MF1A",
            "CVLAG": 1.3999999999999999
        }
    }
]
```

## BUGS

Strings are enclosed in double quotes ", still quotes within string are
not escaped.

Output does not contain Vector CAT values. Only way how to get CAT value
is from the attribute table.

If sampled feature (point, line) contains multiple attribute entries
(has multiple CAT values), only the first one is reported. If this is a
limitation in some practical use case, a feature request in GRASS
issue tracker should be opened.

## SEE ALSO

*[r.profile](r.profile.md), [Linear Referencing System](lrs.md)*

## AUTHOR

Maris Nartiss

## SOURCE CODE

Available at: [v.profile source code](https://github.com/OSGeo/grass/tree/main/vector/v.profile)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.profile))  
Latest change: Sunday Jan 25 10:11:34 2026 in commit [662eb21](https://github.com/OSGeo/grass/commit/662eb2196d98b7b68c137e7ec02380a16b8eea64)
