---
name: v.to.lines.py
description: Converts vector polygons or points to lines.
keywords: [ vector, geometry, area, line, point ]
---

# v.to.lines.py

Converts vector polygons or points to lines.

=== "Command line"

    **v.to.lines.py**
    **input**=*name*
    **output**=*name*
    [**method**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.to.lines.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.to.lines.py***",
        **input**,
        **output**,
        **method**=*"delaunay"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.to.lines.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_to_lines_py*(**input**,
        **output**,
        **method**=*"delaunay"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_to_lines_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method used for point interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *delaunay*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *delaunay*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method used for point interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *delaunay*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *delaunay*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method used for point interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *delaunay*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *delaunay*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.to.lines* converts vector polygons (boundaries) to lines as well as
vector points to lines via triangulations.

## NOTES

*v.to.lines* is able to convert point data (via triangulation) and areas
to lines (via boundary to line conversion). This script is a wrapper
script to *v.category*, *v.delaunay*, and *v.edit*.

In order to convert an ordered list of coordinates (ASCII table with
x,y\[,z\] coordinates) into vector lines, use *v.in.lines*.

## EXAMPLES

The examples are for the North Carolina sample dataset:

### Area to line conversion

```sh
v.to.lines input=boundary_municp output=boundary_municp_lines
```

### Point to line conversion

```sh
v.to.lines input=geodetic_pts output=geodetic_pts_lines
```

## SEE ALSO

*[v.category](v.category.md), [v.delaunay](v.delaunay.md),
[v.edit](v.edit.md), [v.in.lines](v.in.lines.md),
[v.to.points](v.to.points.md), [v.type](v.type.md)*

## AUTHOR

Luca Delucchi, Fondazione Edmund Mach

## SOURCE CODE

Available at: [v.to.lines source code](https://github.com/OSGeo/grass/tree/main/scripts/v.to.lines)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.to.lines))  
Latest change: Tuesday Jan 13 09:49:07 2026 in commit [d2ee7c1](https://github.com/OSGeo/grass/commit/d2ee7c143d35d150a935150c80bdabcb45c7ac3a)
