---
name: v.type
description: Changes type of vector features.
keywords: [ vector, geometry, editing, area, line, point ]
---

# v.type

Changes type of vector features.

=== "Command line"

    **v.type**
    **input**=*name*
    [**layer**=*string*]
    **output**=*name*
    **from_type**=*string*
    **to_type**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.type input=name output=name from_type=line to_type=boundary
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.type***",
        **input**,
        **layer**=*"-1"*,
        **output**,
        **from_type**=*"line"*,
        **to_type**=*"boundary"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.type", input="name", output="name", from_type="line", to_type="boundary")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_type*(**input**,
        **layer**=*"-1"*,
        **output**,
        **from_type**=*"line"*,
        **to_type**=*"boundary"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_type(input="name", output="name", from_type="line", to_type="boundary")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **from_type**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type to convert from  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *line*  
    **to_type**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type to convert to  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *boundary*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **from_type** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type to convert from  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *line*  
    **to_type** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type to convert to  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *boundary*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **from_type** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type to convert from  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *line*  
    **to_type** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type to convert to  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *boundary*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.type* changes the type of geometry primitives.

The following vector object types are defined in GRASS:

- point: a point;
- line: a directed sequence of connected vertices with two endpoints
  called nodes;
- boundary: the border line describing an area;
- centroid: a point within a closed ring of boundaries;
- area: the topological composition of a closed ring of boundaries and a
  centroid;
- face: a 3D area;
- kernel: a 3D centroid in a volume (not yet implemented);
- volume: a 3D corpus, the topological composition of faces and kernel
  (not yet implemented).

Lines and boundaries can be composed of multiple vertices.

Area topology also holds information about isles. These isles are
located within that area, not touching the boundaries of the outer area.
Isles are holes inside the area, and can consist of one or more areas.
They are used internally to maintain correct topology for areas.

## EXAMPLES

*Convert lines to area boundaries*  

```sh
v.type input=map_l output=map_b from_type=line to_type=boundary
```

In order to create areas, centroids must be added with **v.centroids**.

## SEE ALSO

*[v.centroids](v.centroids.md), [v.to.points](v.to.points.md)*

## AUTHOR

Radim Blazek, ITC-Irst, Trento, Italy

## SOURCE CODE

Available at: [v.type source code](https://github.com/OSGeo/grass/tree/main/vector/v.type)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.type))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
