/***************************************************************************
    qgsjsoneditwrapper.h
     --------------------------------------
    Date                 : 3.5.2021
    Copyright            : (C) 2021 Damiano Lombardi
    Email                : damiano at opengis dot ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSJSONEDITWRAPPER_H
#define QGSJSONEDITWRAPPER_H

#include "qgis_gui.h"
#include "qgsattributeform.h"
#include "qgseditorwidgetwrapper.h"

class QgsJsonEditWidget;

SIP_NO_FILE

/**
 * \ingroup gui
 * \brief Wraps a JSON edit widget. Users will be able to modify JSON text with this widget type.
 *
 * Options:
 * <ul>
 * <li><b>DefaultView</b> <i>Default view, text or tree can be selected.</i></li>
 * </ul>
 * \note not available in Python bindings
 * \since QGIS 3.20
 */

class GUI_EXPORT QgsJsonEditWrapper : public QgsEditorWidgetWrapper
{
    Q_OBJECT
  public:
    /**
     * Constructor for QgsJsonEditWrapper.
     *
     * The \a layer and \a fieldIdx arguments specify the vector layer field associated with the wrapper.
     *
     * The \a editor argument indicates the editor widget to use with the wrapper. This can be NULLPTR if a
     * new widget should be autogenerated.
     *
     * A \a parent widget for this widget wrapper and the created widget can also be specified.
     */
    explicit QgsJsonEditWrapper( QgsVectorLayer *layer, int fieldIdx, QWidget *editor = nullptr, QWidget *parent = nullptr );

    QVariant value() const override;

    void showIndeterminateState() override;

  protected:
    QWidget *createWidget( QWidget *parent ) override;
    void initWidget( QWidget *editor ) override;
    bool valid() const override;

  public slots:
    void setEnabled( bool enabled ) override;
    void setFeature( const QgsFeature &feature ) override;

  private:
    inline static const QString RAW_VALUE_PROPERTY = "RawValue";

    void updateValues( const QVariant &val, const QVariantList & = QVariantList() ) override;

    QgsJsonEditWidget *mJsonEditWidget = nullptr;
};

#endif // QGSJSONEDITWRAPPER_H
