/***************************************************************************
  qgsvectortilemvtdecoder.h
  --------------------------------------
  Date                 : March 2020
  Copyright            : (C) 2020 by Martin Dobias
  Email                : wonder dot sk at gmail dot com
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSVECTORTILEMVTDECODER_H
#define QGSVECTORTILEMVTDECODER_H


class QgsFeature;

#include "qgsvectortilematrixset.h"
#include "qgsvectortilerenderer.h"
#include "vector_tile.pb.h"

#include <QMap>
#include <QStringList>

#define SIP_NO_FILE

class QgsVectorTileRawData;

/**
 * \ingroup core
 * \brief Responsible for decoding raw tile data written with Mapbox Vector Tiles encoding.
 *
 * \since QGIS 3.14
 */
class CORE_EXPORT QgsVectorTileMVTDecoder
{
  public:

    /**
     * Constructor for QgsVectorTileMVTDecoder, using the specified tile \a structure.
     */
    QgsVectorTileMVTDecoder( const QgsVectorTileMatrixSet &structure );
    ~QgsVectorTileMVTDecoder();

    //! Tries to decode raw tile data, returns true on success
    bool decode( const QgsVectorTileRawData &rawTileData );

    //! Returns a list of sub-layer names in a tile. It can only be called after a successful decode()
    QStringList layers() const;

    //! Returns a list of all field names in a tile. It can only be called after a successful decode()
    QStringList layerFieldNames( const QString &layerName ) const;

    /**
     * Returns decoded features grouped by sub-layers. It can only be called after a successful decode()
     *
     * If \a layerSubset is specified then only features from the specified layers will be returned.
     */
    QgsVectorTileFeatures layerFeatures( const QMap<QString, QgsFields> &perLayerFields, const QgsCoordinateTransform &ct,
                                         const QSet< QString > *layerSubset = nullptr ) const;

  private:
    //! map of tiles for each source
    QMap<QString, vector_tile::Tile> tiles;
    QgsTileXYZ mTileID;
    QgsVectorTileMatrixSet mStructure;
    QMap<QString, QMap<QString, int>> mLayerNameToIndex;
};

#endif // QGSVECTORTILEMVTDECODER_H
