/***************************************************************************
      qgsgeopackageitemguiprovider.h
      -------------------
    begin                : June, 2019
    copyright            : (C) 2019 by Peter Petrik
    email                : zilolv at gmail dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSGEOPACKAGEITEMGUIPROVIDER_H
#define QGSGEOPACKAGEITEMGUIPROVIDER_H

#include "qgsdataitemguiprovider.h"
#include "qgsmimedatautils.h"

#include <QObject>
#include <QString>

#define SIP_NO_FILE

using namespace Qt::StringLiterals;

///@cond PRIVATE

class QgsGeoPackageCollectionItem;
class QgsGeoPackageRootItem;

class QgsGeoPackageItemGuiProvider : public QObject, public QgsDataItemGuiProvider
{
    Q_OBJECT

  public:
    QgsGeoPackageItemGuiProvider() = default;

    QString name() override { return u"geopackage_items"_s; }

    void populateContextMenu( QgsDataItem *item, QMenu *menu, const QList<QgsDataItem *> &selectedItems, QgsDataItemGuiContext context ) override;

    bool rename( QgsDataItem *item, const QString &name, QgsDataItemGuiContext context ) override;
    bool deleteLayer( QgsLayerItem *layerItem, QgsDataItemGuiContext context ) override;

    bool acceptDrop( QgsDataItem *item, QgsDataItemGuiContext context ) override;
    bool handleDrop( QgsDataItem *item, QgsDataItemGuiContext context, const QMimeData *data, Qt::DropAction action ) override;

  private:
    bool handleDropGeopackage( QgsGeoPackageCollectionItem *item, const QMimeData *data, QgsDataItemGuiContext context );
    bool handleDropUri( QgsGeoPackageCollectionItem *item, const QgsMimeDataUtils::Uri &sourceUri, QgsDataItemGuiContext context );
    void handleImportVector( QgsGeoPackageCollectionItem *item, QgsDataItemGuiContext context );

    //! Compacts (VACUUM) a geopackage database
    void vacuumGeoPackageDbAction( const QString &path, const QString &name, QgsDataItemGuiContext context );
    void createDatabase( const QPointer<QgsGeoPackageRootItem> &item );
    void createDatabaseAndLayer( const QPointer<QgsGeoPackageRootItem> &item );

  protected slots:
    void renameVectorLayer( const QString &uri, const QString &key, const QStringList &tableNames, const QPointer<QgsDataItem> &item, QgsDataItemGuiContext context );
};

///@endcond
#endif // QGSGEOPACKAGEITEMGUIPROVIDER_H
