/***************************************************************************
  qgspointcloudlayerproperties.h
  --------------------------------------
  Date                 : October 2020
  Copyright            : (C) 2020 by Nyall Dawson
  Email                : nyall dot dawson at gmail dot com
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSPOINTCLOUDLAYERPROPERTIES_H
#define QGSPOINTCLOUDLAYERPROPERTIES_H

#include "ui_qgspointcloudlayerpropertiesbase.h"

#include "qgis_gui.h"
#include "qgslayerpropertiesdialog.h"
#include "qgspointcloudattribute.h"

#include <QAbstractTableModel>

#define SIP_NO_FILE

class QgsMapLayer;
class QgsMapCanvas;
class QgsMessageBar;
class QgsPointCloudLayer;
class QgsMetadataWidget;
class QgsMapLayerConfigWidgetFactory;
class QgsMapLayerConfigWidget;
class QgsLayerPropertiesGuiUtils;

///@cond private

class QgsPointCloudAttributeStatisticsModel : public QAbstractTableModel
{
    Q_OBJECT

  public:
    enum Columns
    {
      Name,
      Min,
      Max,
      Mean,
      StDev
    };

    QgsPointCloudAttributeStatisticsModel( QgsPointCloudLayer *layer, QObject *parent );
    int columnCount( const QModelIndex &parent = QModelIndex() ) const override;
    int rowCount( const QModelIndex &parent = QModelIndex() ) const override;
    QVariant data( const QModelIndex &index, int role = Qt::DisplayRole ) const override;
    QVariant headerData( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const override;

  private:
    QgsPointCloudLayer *mLayer = nullptr;
    QgsPointCloudAttributeCollection mAttributes;
};

class QgsPointCloudClassificationStatisticsModel : public QAbstractTableModel
{
    Q_OBJECT

  public:
    enum Columns
    {
      Value,
      Classification,
      Count,
      Percent
    };

    QgsPointCloudClassificationStatisticsModel( QgsPointCloudLayer *layer, const QString &attribute, QObject *parent );
    int columnCount( const QModelIndex &parent = QModelIndex() ) const override;
    int rowCount( const QModelIndex &parent = QModelIndex() ) const override;
    QVariant data( const QModelIndex &index, int role = Qt::DisplayRole ) const override;
    QVariant headerData( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const override;

  private:
    QgsPointCloudLayer *mLayer = nullptr;
    QString mAttribute;
    QList<int> mClassifications;
};

///@endcond private

/**
 * \ingroup gui
 * \class QgsPointCloudLayerProperties
 * \brief Layer properties dialog for point cloud layers.
 * \since QGIS 4.0 in the GUI API
 */
class GUI_EXPORT QgsPointCloudLayerProperties : public QgsLayerPropertiesDialog, private Ui::QgsPointCloudLayerPropertiesBase
{
    Q_OBJECT
  public:
    //! Constructor
    QgsPointCloudLayerProperties( QgsPointCloudLayer *lyr, QgsMapCanvas *canvas, QgsMessageBar *messageBar, QWidget *parent = nullptr, Qt::WindowFlags = QgsGuiUtils::ModalDialogFlags );

  protected slots:
    void apply() final;
    void rollback() final;

  private slots:

    void aboutToShowStyleMenu();
    void showHelp();
    void pbnQueryBuilder_clicked();
    void crsChanged( const QgsCoordinateReferenceSystem &crs );

  private:
    void syncToLayer() final;

  private:
    QgsPointCloudLayer *mLayer = nullptr;

    QAction *mActionLoadMetadata = nullptr;
    QAction *mActionSaveMetadataAs = nullptr;

    QgsMetadataWidget *mMetadataWidget = nullptr;

    QgsCoordinateReferenceSystem mBackupCrs;
};

#endif // QGSPOINTCLOUDLAYERPROPERTIES_H
