# The PEP 484 type hints stub file for the _core module.
#
# Generated by SIP 6.15.0


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtXml
from PyQt6 import QtNetwork
from PyQt6 import QtGui
from PyQt6 import QtWidgets
from PyQt6 import QtSql
from PyQt6 import QtPrintSupport
from PyQt6 import QtPositioning
from PyQt6 import QtMultimedia
from PyQt6 import QtSerialPort

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]

class QgsCsException(Exception):
    def __init__(self, *args, **kwargs) -> None: ...

class QgsProcessingException(Exception):
    def __init__(self, *args, **kwargs) -> None: ...

class QgsProviderConnectionException(Exception):
    def __init__(self, *args, **kwargs) -> None: ...

class QgsNotSupportedException(Exception):
    def __init__(self, *args, **kwargs) -> None: ...

class QgsSettingsException(Exception):
    def __init__(self, *args, **kwargs) -> None: ...

class QgsSfcgalException(Exception):
    def __init__(self, *args, **kwargs) -> None: ...

class QgsInvalidArgumentException(Exception):
    def __init__(self, *args, **kwargs) -> None: ...

class QgsException(Exception):
    def __init__(self, *args, **kwargs) -> None: ...


class QgsGpsConnection(QtCore.QObject):

    class Status(enum.IntEnum):
        NotConnected = ... # type: QgsGpsConnection.Status
        Connected = ... # type: QgsGpsConnection.Status
        DataReceived = ... # type: QgsGpsConnection.Status
        GPSDataReceived = ... # type: QgsGpsConnection.Status

    def __init__(self, dev: QtCore.QIODevice|None) -> None: ...

    def parseData(self) -> None: ...
    positionChanged: typing.ClassVar[QtCore.pyqtSignal]
    fixStatusChanged: typing.ClassVar[QtCore.pyqtSignal]
    nmeaSentenceReceived: typing.ClassVar[QtCore.pyqtSignal]
    stateChanged: typing.ClassVar[QtCore.pyqtSignal]
    def lastValidLocation(self) -> 'QgsPoint': ...
    def currentGPSInformation(self) -> 'QgsGpsInformation': ...
    def status(self) -> 'QgsGpsConnection.Status': ...
    def setSource(self, source: QtCore.QIODevice|None) -> None: ...
    def close(self) -> bool: ...
    def connect(self) -> bool: ...


class QgsQtLocationConnection(QgsGpsConnection):

    def __init__(self) -> None: ...

    def satellitesInUseUpdated(self, satellites: collections.abc.Iterable[QtPositioning.QGeoSatelliteInfo]) -> None: ...
    def satellitesInViewUpdated(self, satellites: collections.abc.Iterable[QtPositioning.QGeoSatelliteInfo]) -> None: ...
    def parseData(self) -> None: ...
    def broadcastConnectionAvailable(self) -> None: ...


class Qgis(PyQt6.sip.wrapper):

    class TriangulationAlgorithm(enum.IntFlag):
        ConstrainedDelaunay = ... # type: Qgis.TriangulationAlgorithm
        Earcut = ... # type: Qgis.TriangulationAlgorithm

    class ExtrusionFace(enum.IntFlag):
        NoFace = ... # type: Qgis.ExtrusionFace
        Walls = ... # type: Qgis.ExtrusionFace
        Roof = ... # type: Qgis.ExtrusionFace
        Floor = ... # type: Qgis.ExtrusionFace

    class DevToolsNodeRole(enum.Enum):
        Status = ... # type: Qgis.DevToolsNodeRole
        Id = ... # type: Qgis.DevToolsNodeRole
        ElapsedTime = ... # type: Qgis.DevToolsNodeRole
        MaximumTime = ... # type: Qgis.DevToolsNodeRole
        Sort = ... # type: Qgis.DevToolsNodeRole

    class RasterProcessingParameterCapability(enum.IntFlag):
        WmsScale = ... # type: Qgis.RasterProcessingParameterCapability
        WmsDpi = ... # type: Qgis.RasterProcessingParameterCapability

    class StacObjectType(enum.IntEnum):
        Unknown = ... # type: Qgis.StacObjectType
        Catalog = ... # type: Qgis.StacObjectType
        Collection = ... # type: Qgis.StacObjectType
        Item = ... # type: Qgis.StacObjectType

    class SegmentCalculationMethod(enum.IntEnum):
        Standard = ... # type: Qgis.SegmentCalculationMethod
        Adaptive = ... # type: Qgis.SegmentCalculationMethod
        AreaError = ... # type: Qgis.SegmentCalculationMethod
        ConstantDensity = ... # type: Qgis.SegmentCalculationMethod

    class PointCloudZoomOutRenderBehavior(enum.IntEnum):
        RenderExtents = ... # type: Qgis.PointCloudZoomOutRenderBehavior
        RenderOverview = ... # type: Qgis.PointCloudZoomOutRenderBehavior
        RenderOverviewAndExtents = ... # type: Qgis.PointCloudZoomOutRenderBehavior

    class PointCloudAccessType(enum.IntEnum):
        Local = ... # type: Qgis.PointCloudAccessType
        Remote = ... # type: Qgis.PointCloudAccessType

    class MeshRangeExtent(enum.IntEnum):
        WholeMesh = ... # type: Qgis.MeshRangeExtent
        FixedCanvas = ... # type: Qgis.MeshRangeExtent
        UpdatedCanvas = ... # type: Qgis.MeshRangeExtent

    class MeshRangeLimit(enum.IntEnum):
        NotSet = ... # type: Qgis.MeshRangeLimit
        MinimumMaximum = ... # type: Qgis.MeshRangeLimit

    class MouseHandlesAction(enum.IntEnum):
        MoveItem = ... # type: Qgis.MouseHandlesAction
        ResizeUp = ... # type: Qgis.MouseHandlesAction
        ResizeDown = ... # type: Qgis.MouseHandlesAction
        ResizeLeft = ... # type: Qgis.MouseHandlesAction
        ResizeRight = ... # type: Qgis.MouseHandlesAction
        ResizeLeftUp = ... # type: Qgis.MouseHandlesAction
        ResizeRightUp = ... # type: Qgis.MouseHandlesAction
        ResizeLeftDown = ... # type: Qgis.MouseHandlesAction
        ResizeRightDown = ... # type: Qgis.MouseHandlesAction
        RotateTopLeft = ... # type: Qgis.MouseHandlesAction
        RotateTopRight = ... # type: Qgis.MouseHandlesAction
        RotateBottomLeft = ... # type: Qgis.MouseHandlesAction
        RotateBottomRight = ... # type: Qgis.MouseHandlesAction
        SelectItem = ... # type: Qgis.MouseHandlesAction
        NoAction = ... # type: Qgis.MouseHandlesAction

    class DocumentationBrowser(enum.IntEnum):
        DeveloperToolsPanel = ... # type: Qgis.DocumentationBrowser
        SystemWebBrowser = ... # type: Qgis.DocumentationBrowser

    class DocumentationApi(enum.IntEnum):
        PyQgis = ... # type: Qgis.DocumentationApi
        PyQgisSearch = ... # type: Qgis.DocumentationApi
        CppQgis = ... # type: Qgis.DocumentationApi
        Qt = ... # type: Qgis.DocumentationApi

    class ColorModel(enum.IntEnum):
        Rgb = ... # type: Qgis.ColorModel
        Cmyk = ... # type: Qgis.ColorModel

    class SensorThingsEntity(enum.IntEnum):
        Invalid = ... # type: Qgis.SensorThingsEntity
        Thing = ... # type: Qgis.SensorThingsEntity
        Location = ... # type: Qgis.SensorThingsEntity
        HistoricalLocation = ... # type: Qgis.SensorThingsEntity
        Datastream = ... # type: Qgis.SensorThingsEntity
        Sensor = ... # type: Qgis.SensorThingsEntity
        ObservedProperty = ... # type: Qgis.SensorThingsEntity
        Observation = ... # type: Qgis.SensorThingsEntity
        FeatureOfInterest = ... # type: Qgis.SensorThingsEntity
        MultiDatastream = ... # type: Qgis.SensorThingsEntity

    class RasterBandStatistic(enum.IntFlag):
        NoStatistic = ... # type: Qgis.RasterBandStatistic
        Min = ... # type: Qgis.RasterBandStatistic
        Max = ... # type: Qgis.RasterBandStatistic
        Range = ... # type: Qgis.RasterBandStatistic
        Sum = ... # type: Qgis.RasterBandStatistic
        Mean = ... # type: Qgis.RasterBandStatistic
        StdDev = ... # type: Qgis.RasterBandStatistic
        SumOfSquares = ... # type: Qgis.RasterBandStatistic
        All = ... # type: Qgis.RasterBandStatistic

    class StringStatistic(enum.IntFlag):
        Count = ... # type: Qgis.StringStatistic
        CountDistinct = ... # type: Qgis.StringStatistic
        CountMissing = ... # type: Qgis.StringStatistic
        Min = ... # type: Qgis.StringStatistic
        Max = ... # type: Qgis.StringStatistic
        MinimumLength = ... # type: Qgis.StringStatistic
        MaximumLength = ... # type: Qgis.StringStatistic
        MeanLength = ... # type: Qgis.StringStatistic
        Minority = ... # type: Qgis.StringStatistic
        Majority = ... # type: Qgis.StringStatistic
        All = ... # type: Qgis.StringStatistic

    class DateTimeStatistic(enum.IntFlag):
        Count = ... # type: Qgis.DateTimeStatistic
        CountDistinct = ... # type: Qgis.DateTimeStatistic
        CountMissing = ... # type: Qgis.DateTimeStatistic
        Min = ... # type: Qgis.DateTimeStatistic
        Max = ... # type: Qgis.DateTimeStatistic
        Range = ... # type: Qgis.DateTimeStatistic
        All = ... # type: Qgis.DateTimeStatistic

    class Statistic(enum.IntFlag):
        Count = ... # type: Qgis.Statistic
        CountMissing = ... # type: Qgis.Statistic
        Sum = ... # type: Qgis.Statistic
        Mean = ... # type: Qgis.Statistic
        Median = ... # type: Qgis.Statistic
        StDev = ... # type: Qgis.Statistic
        StDevSample = ... # type: Qgis.Statistic
        Min = ... # type: Qgis.Statistic
        Max = ... # type: Qgis.Statistic
        Range = ... # type: Qgis.Statistic
        Minority = ... # type: Qgis.Statistic
        Majority = ... # type: Qgis.Statistic
        Variety = ... # type: Qgis.Statistic
        FirstQuartile = ... # type: Qgis.Statistic
        ThirdQuartile = ... # type: Qgis.Statistic
        InterQuartileRange = ... # type: Qgis.Statistic
        First = ... # type: Qgis.Statistic
        Last = ... # type: Qgis.Statistic
        All = ... # type: Qgis.Statistic

    class Aggregate(enum.IntEnum):
        Count = ... # type: Qgis.Aggregate
        CountDistinct = ... # type: Qgis.Aggregate
        CountMissing = ... # type: Qgis.Aggregate
        Min = ... # type: Qgis.Aggregate
        Max = ... # type: Qgis.Aggregate
        Sum = ... # type: Qgis.Aggregate
        Mean = ... # type: Qgis.Aggregate
        Median = ... # type: Qgis.Aggregate
        StDev = ... # type: Qgis.Aggregate
        StDevSample = ... # type: Qgis.Aggregate
        Range = ... # type: Qgis.Aggregate
        Minority = ... # type: Qgis.Aggregate
        Majority = ... # type: Qgis.Aggregate
        FirstQuartile = ... # type: Qgis.Aggregate
        ThirdQuartile = ... # type: Qgis.Aggregate
        InterQuartileRange = ... # type: Qgis.Aggregate
        StringMinimumLength = ... # type: Qgis.Aggregate
        StringMaximumLength = ... # type: Qgis.Aggregate
        StringConcatenate = ... # type: Qgis.Aggregate
        GeometryCollect = ... # type: Qgis.Aggregate
        ArrayAggregate = ... # type: Qgis.Aggregate
        StringConcatenateUnique = ... # type: Qgis.Aggregate

    class ZonalStatisticResult(enum.IntEnum):
        Success = ... # type: Qgis.ZonalStatisticResult
        LayerTypeWrong = ... # type: Qgis.ZonalStatisticResult
        LayerInvalid = ... # type: Qgis.ZonalStatisticResult
        RasterInvalid = ... # type: Qgis.ZonalStatisticResult
        RasterBandInvalid = ... # type: Qgis.ZonalStatisticResult
        FailedToCreateField = ... # type: Qgis.ZonalStatisticResult
        Canceled = ... # type: Qgis.ZonalStatisticResult

    class ZonalStatistic(enum.IntFlag):
        Count = ... # type: Qgis.ZonalStatistic
        Sum = ... # type: Qgis.ZonalStatistic
        Mean = ... # type: Qgis.ZonalStatistic
        Median = ... # type: Qgis.ZonalStatistic
        StDev = ... # type: Qgis.ZonalStatistic
        Min = ... # type: Qgis.ZonalStatistic
        Max = ... # type: Qgis.ZonalStatistic
        Range = ... # type: Qgis.ZonalStatistic
        Minority = ... # type: Qgis.ZonalStatistic
        Majority = ... # type: Qgis.ZonalStatistic
        Variety = ... # type: Qgis.ZonalStatistic
        Variance = ... # type: Qgis.ZonalStatistic
        MinimumPoint = ... # type: Qgis.ZonalStatistic
        MaximumPoint = ... # type: Qgis.ZonalStatistic
        All = ... # type: Qgis.ZonalStatistic
        AllNumeric = ... # type: Qgis.ZonalStatistic
        Default = ... # type: Qgis.ZonalStatistic

    class VsiHandlerType(enum.IntEnum):
        Invalid = ... # type: Qgis.VsiHandlerType
        Archive = ... # type: Qgis.VsiHandlerType
        Network = ... # type: Qgis.VsiHandlerType
        Cloud = ... # type: Qgis.VsiHandlerType
        Memory = ... # type: Qgis.VsiHandlerType
        Other = ... # type: Qgis.VsiHandlerType

    class GdalResampleAlgorithm(enum.IntEnum):
        RA_NearestNeighbour = ... # type: Qgis.GdalResampleAlgorithm
        RA_Bilinear = ... # type: Qgis.GdalResampleAlgorithm
        RA_Cubic = ... # type: Qgis.GdalResampleAlgorithm
        RA_CubicSpline = ... # type: Qgis.GdalResampleAlgorithm
        RA_Lanczos = ... # type: Qgis.GdalResampleAlgorithm
        RA_Average = ... # type: Qgis.GdalResampleAlgorithm
        RA_Mode = ... # type: Qgis.GdalResampleAlgorithm
        RA_Max = ... # type: Qgis.GdalResampleAlgorithm
        RA_Min = ... # type: Qgis.GdalResampleAlgorithm
        RA_Median = ... # type: Qgis.GdalResampleAlgorithm
        RA_Q1 = ... # type: Qgis.GdalResampleAlgorithm
        RA_Q3 = ... # type: Qgis.GdalResampleAlgorithm

    class TiledSceneRendererFlag(enum.IntFlag):
        RequiresTextures = ... # type: Qgis.TiledSceneRendererFlag
        ForceRasterRender = ... # type: Qgis.TiledSceneRendererFlag
        RendersTriangles = ... # type: Qgis.TiledSceneRendererFlag
        RendersLines = ... # type: Qgis.TiledSceneRendererFlag

    class TiledSceneRequestFlag(enum.IntFlag):
        NoHierarchyFetch = ... # type: Qgis.TiledSceneRequestFlag

    class TileChildrenAvailability(enum.Enum):
        NoChildren = ... # type: Qgis.TileChildrenAvailability
        Available = ... # type: Qgis.TileChildrenAvailability
        NeedFetching = ... # type: Qgis.TileChildrenAvailability

    class TileRefinementProcess(enum.Enum):
        Replacement = ... # type: Qgis.TileRefinementProcess
        Additive = ... # type: Qgis.TileRefinementProcess

    class TiledSceneBoundingVolumeType(enum.Enum):
        Region = ... # type: Qgis.TiledSceneBoundingVolumeType
        OrientedBox = ... # type: Qgis.TiledSceneBoundingVolumeType
        Sphere = ... # type: Qgis.TiledSceneBoundingVolumeType

    class TiledSceneProviderCapability(enum.IntFlag):
        ReadLayerMetadata = ... # type: Qgis.TiledSceneProviderCapability

    class TileAvailability(enum.Enum):
        Available = ... # type: Qgis.TileAvailability
        NotAvailable = ... # type: Qgis.TileAvailability
        AvailableNoChildren = ... # type: Qgis.TileAvailability
        UseLowerZoomLevelTile = ... # type: Qgis.TileAvailability

    class VectorTileProviderCapability(enum.IntFlag):
        ReadLayerMetadata = ... # type: Qgis.VectorTileProviderCapability

    class VectorTileProviderFlag(enum.IntFlag):
        AlwaysUseTileMatrixSetFromProvider = ... # type: Qgis.VectorTileProviderFlag

    class FeatureSymbologyExport(enum.IntEnum):
        NoSymbology = ... # type: Qgis.FeatureSymbologyExport
        PerFeature = ... # type: Qgis.FeatureSymbologyExport
        PerSymbolLayer = ... # type: Qgis.FeatureSymbologyExport

    class ExpressionType(enum.Enum):
        Qgis = ... # type: Qgis.ExpressionType
        PointCloud = ... # type: Qgis.ExpressionType
        RasterCalculator = ... # type: Qgis.ExpressionType

    class AttributeFormReuseLastValuePolicy(enum.IntEnum):
        NotAllowed = ... # type: Qgis.AttributeFormReuseLastValuePolicy
        AllowedDefaultOn = ... # type: Qgis.AttributeFormReuseLastValuePolicy
        AllowedDefaultOff = ... # type: Qgis.AttributeFormReuseLastValuePolicy

    class AttributeFormPythonInitCodeSource(enum.IntEnum):
        NoSource = ... # type: Qgis.AttributeFormPythonInitCodeSource
        File = ... # type: Qgis.AttributeFormPythonInitCodeSource
        Dialog = ... # type: Qgis.AttributeFormPythonInitCodeSource
        Environment = ... # type: Qgis.AttributeFormPythonInitCodeSource

    class AttributeFormSuppression(enum.IntEnum):
        Default = ... # type: Qgis.AttributeFormSuppression
        On = ... # type: Qgis.AttributeFormSuppression
        Off = ... # type: Qgis.AttributeFormSuppression

    class AttributeFormLayout(enum.IntEnum):
        AutoGenerated = ... # type: Qgis.AttributeFormLayout
        DragAndDrop = ... # type: Qgis.AttributeFormLayout
        UiFile = ... # type: Qgis.AttributeFormLayout

    class AttributeEditorContainerType(enum.IntEnum):
        GroupBox = ... # type: Qgis.AttributeEditorContainerType
        Tab = ... # type: Qgis.AttributeEditorContainerType
        Row = ... # type: Qgis.AttributeEditorContainerType

    class AttributeEditorType(enum.IntEnum):
        Container = ... # type: Qgis.AttributeEditorType
        Field = ... # type: Qgis.AttributeEditorType
        Relation = ... # type: Qgis.AttributeEditorType
        QmlElement = ... # type: Qgis.AttributeEditorType
        HtmlElement = ... # type: Qgis.AttributeEditorType
        Action = ... # type: Qgis.AttributeEditorType
        TextElement = ... # type: Qgis.AttributeEditorType
        SpacerElement = ... # type: Qgis.AttributeEditorType
        Invalid = ... # type: Qgis.AttributeEditorType

    class UserProfileSelectionPolicy(enum.IntEnum):
        LastProfile = ... # type: Qgis.UserProfileSelectionPolicy
        DefaultProfile = ... # type: Qgis.UserProfileSelectionPolicy
        AskUser = ... # type: Qgis.UserProfileSelectionPolicy

    class ProviderStyleStorageCapability(enum.IntFlag):
        SaveToDatabase = ... # type: Qgis.ProviderStyleStorageCapability
        LoadFromDatabase = ... # type: Qgis.ProviderStyleStorageCapability
        DeleteFromDatabase = ... # type: Qgis.ProviderStyleStorageCapability

    class DatabaseProviderTableImportCapability(enum.IntFlag):
        SetGeometryColumnName = ... # type: Qgis.DatabaseProviderTableImportCapability
        SetPrimaryKeyName = ... # type: Qgis.DatabaseProviderTableImportCapability

    class DatabaseProviderConnectionCapability2(enum.IntFlag):
        SetFieldComment = ... # type: Qgis.DatabaseProviderConnectionCapability2
        SetFieldAlias = ... # type: Qgis.DatabaseProviderConnectionCapability2
        SetTableComment = ... # type: Qgis.DatabaseProviderConnectionCapability2
        EditFieldDomain = ... # type: Qgis.DatabaseProviderConnectionCapability2
        DeleteFieldDomain = ... # type: Qgis.DatabaseProviderConnectionCapability2

    class PostgresRelKind(enum.Enum):
        NotSet = ... # type: Qgis.PostgresRelKind
        Unknown = ... # type: Qgis.PostgresRelKind
        OrdinaryTable = ... # type: Qgis.PostgresRelKind
        Index = ... # type: Qgis.PostgresRelKind
        Sequence = ... # type: Qgis.PostgresRelKind
        View = ... # type: Qgis.PostgresRelKind
        MaterializedView = ... # type: Qgis.PostgresRelKind
        CompositeType = ... # type: Qgis.PostgresRelKind
        ToastTable = ... # type: Qgis.PostgresRelKind
        ForeignTable = ... # type: Qgis.PostgresRelKind
        PartitionedTable = ... # type: Qgis.PostgresRelKind

    class InputControllerType(enum.IntEnum):
        Map2D = ... # type: Qgis.InputControllerType
        Map3D = ... # type: Qgis.InputControllerType

    class MapGridAnnotationType(enum.IntEnum):
        Longitude = ... # type: Qgis.MapGridAnnotationType
        Latitude = ... # type: Qgis.MapGridAnnotationType

    class MapGridFrameSideFlag(enum.IntFlag):
        Left = ... # type: Qgis.MapGridFrameSideFlag
        Right = ... # type: Qgis.MapGridFrameSideFlag
        Top = ... # type: Qgis.MapGridFrameSideFlag
        Bottom = ... # type: Qgis.MapGridFrameSideFlag

    class MapGridTickLengthMode(enum.IntEnum):
        OrthogonalTicks = ... # type: Qgis.MapGridTickLengthMode
        NormalizedTicks = ... # type: Qgis.MapGridTickLengthMode

    class MapGridFrameStyle(enum.IntEnum):
        NoFrame = ... # type: Qgis.MapGridFrameStyle
        Zebra = ... # type: Qgis.MapGridFrameStyle
        InteriorTicks = ... # type: Qgis.MapGridFrameStyle
        ExteriorTicks = ... # type: Qgis.MapGridFrameStyle
        InteriorExteriorTicks = ... # type: Qgis.MapGridFrameStyle
        LineBorder = ... # type: Qgis.MapGridFrameStyle
        LineBorderNautical = ... # type: Qgis.MapGridFrameStyle
        ZebraNautical = ... # type: Qgis.MapGridFrameStyle

    class MapGridBorderSide(enum.IntEnum):
        Left = ... # type: Qgis.MapGridBorderSide
        Right = ... # type: Qgis.MapGridBorderSide
        Bottom = ... # type: Qgis.MapGridBorderSide
        Top = ... # type: Qgis.MapGridBorderSide

    class MapGridAnnotationFormat(enum.IntEnum):
        Decimal = ... # type: Qgis.MapGridAnnotationFormat
        DegreeMinute = ... # type: Qgis.MapGridAnnotationFormat
        DegreeMinuteSecond = ... # type: Qgis.MapGridAnnotationFormat
        DecimalWithSuffix = ... # type: Qgis.MapGridAnnotationFormat
        DegreeMinuteNoSuffix = ... # type: Qgis.MapGridAnnotationFormat
        DegreeMinutePadded = ... # type: Qgis.MapGridAnnotationFormat
        DegreeMinuteSecondNoSuffix = ... # type: Qgis.MapGridAnnotationFormat
        DegreeMinuteSecondPadded = ... # type: Qgis.MapGridAnnotationFormat
        CustomFormat = ... # type: Qgis.MapGridAnnotationFormat

    class MapGridAnnotationDirection(enum.IntEnum):
        Horizontal = ... # type: Qgis.MapGridAnnotationDirection
        Vertical = ... # type: Qgis.MapGridAnnotationDirection
        VerticalDescending = ... # type: Qgis.MapGridAnnotationDirection
        BoundaryDirection = ... # type: Qgis.MapGridAnnotationDirection
        AboveTick = ... # type: Qgis.MapGridAnnotationDirection
        OnTick = ... # type: Qgis.MapGridAnnotationDirection
        UnderTick = ... # type: Qgis.MapGridAnnotationDirection

    class MapGridAnnotationPosition(enum.IntEnum):
        InsideMapFrame = ... # type: Qgis.MapGridAnnotationPosition
        OutsideMapFrame = ... # type: Qgis.MapGridAnnotationPosition

    class MapGridComponentVisibility(enum.IntEnum):
        ShowAll = ... # type: Qgis.MapGridComponentVisibility
        LatitudeOnly = ... # type: Qgis.MapGridComponentVisibility
        LongitudeOnly = ... # type: Qgis.MapGridComponentVisibility
        HideAll = ... # type: Qgis.MapGridComponentVisibility

    class MapGridStyle(enum.IntEnum):
        Lines = ... # type: Qgis.MapGridStyle
        LineCrosses = ... # type: Qgis.MapGridStyle
        Markers = ... # type: Qgis.MapGridStyle
        FrameAndAnnotationsOnly = ... # type: Qgis.MapGridStyle

    class MapGridUnit(enum.IntEnum):
        MapUnits = ... # type: Qgis.MapGridUnit
        Millimeters = ... # type: Qgis.MapGridUnit
        Centimeters = ... # type: Qgis.MapGridUnit
        DynamicPageSizeBased = ... # type: Qgis.MapGridUnit

    class ScaleBarDistanceLabelHorizontalPlacement(enum.IntEnum):
        CenteredEdge = ... # type: Qgis.ScaleBarDistanceLabelHorizontalPlacement
        CenteredSegment = ... # type: Qgis.ScaleBarDistanceLabelHorizontalPlacement

    class ScaleBarDistanceLabelVerticalPlacement(enum.IntEnum):
        AboveSegment = ... # type: Qgis.ScaleBarDistanceLabelVerticalPlacement
        BelowSegment = ... # type: Qgis.ScaleBarDistanceLabelVerticalPlacement

    class ScaleBarSegmentSizeMode(enum.IntEnum):
        Fixed = ... # type: Qgis.ScaleBarSegmentSizeMode
        FitWidth = ... # type: Qgis.ScaleBarSegmentSizeMode

    class ScaleBarAlignment(enum.IntEnum):
        Left = ... # type: Qgis.ScaleBarAlignment
        Middle = ... # type: Qgis.ScaleBarAlignment
        Right = ... # type: Qgis.ScaleBarAlignment

    class ScaleCalculationMethod(enum.IntEnum):
        HorizontalTop = ... # type: Qgis.ScaleCalculationMethod
        HorizontalMiddle = ... # type: Qgis.ScaleCalculationMethod
        HorizontalBottom = ... # type: Qgis.ScaleCalculationMethod
        HorizontalAverage = ... # type: Qgis.ScaleCalculationMethod
        AtEquator = ... # type: Qgis.ScaleCalculationMethod

    class PictureFormat(enum.IntEnum):
        SVG = ... # type: Qgis.PictureFormat
        Raster = ... # type: Qgis.PictureFormat
        Unknown = ... # type: Qgis.PictureFormat

    class LayoutRenderFlag(enum.IntFlag):
        Debug = ... # type: Qgis.LayoutRenderFlag
        OutlineOnly = ... # type: Qgis.LayoutRenderFlag
        Antialiasing = ... # type: Qgis.LayoutRenderFlag
        UseAdvancedEffects = ... # type: Qgis.LayoutRenderFlag
        ForceVectorOutput = ... # type: Qgis.LayoutRenderFlag
        HideCoverageLayer = ... # type: Qgis.LayoutRenderFlag
        DrawSelection = ... # type: Qgis.LayoutRenderFlag
        DisableTiledRasterLayerRenders = ... # type: Qgis.LayoutRenderFlag
        RenderLabelsByMapLayer = ... # type: Qgis.LayoutRenderFlag
        LosslessImageRendering = ... # type: Qgis.LayoutRenderFlag
        SynchronousLegendGraphics = ... # type: Qgis.LayoutRenderFlag
        AlwaysUseGlobalMasks = ... # type: Qgis.LayoutRenderFlag
        LimitCoverageLayerRenderToCurrentFeature = ... # type: Qgis.LayoutRenderFlag

    class LayoutUnitType(enum.IntEnum):
        PaperUnits = ... # type: Qgis.LayoutUnitType
        ScreenUnits = ... # type: Qgis.LayoutUnitType

    class LayoutUnit(enum.IntEnum):
        Millimeters = ... # type: Qgis.LayoutUnit
        Centimeters = ... # type: Qgis.LayoutUnit
        Meters = ... # type: Qgis.LayoutUnit
        Inches = ... # type: Qgis.LayoutUnit
        Feet = ... # type: Qgis.LayoutUnit
        Points = ... # type: Qgis.LayoutUnit
        Picas = ... # type: Qgis.LayoutUnit
        Pixels = ... # type: Qgis.LayoutUnit

    class RenderUnit(enum.IntEnum):
        Millimeters = ... # type: Qgis.RenderUnit
        MapUnits = ... # type: Qgis.RenderUnit
        Pixels = ... # type: Qgis.RenderUnit
        Percentage = ... # type: Qgis.RenderUnit
        Points = ... # type: Qgis.RenderUnit
        Inches = ... # type: Qgis.RenderUnit
        Unknown = ... # type: Qgis.RenderUnit
        MetersInMapUnits = ... # type: Qgis.RenderUnit

    class TemporalUnit(enum.IntEnum):
        Milliseconds = ... # type: Qgis.TemporalUnit
        Seconds = ... # type: Qgis.TemporalUnit
        Minutes = ... # type: Qgis.TemporalUnit
        Hours = ... # type: Qgis.TemporalUnit
        Days = ... # type: Qgis.TemporalUnit
        Weeks = ... # type: Qgis.TemporalUnit
        Months = ... # type: Qgis.TemporalUnit
        Years = ... # type: Qgis.TemporalUnit
        Decades = ... # type: Qgis.TemporalUnit
        Centuries = ... # type: Qgis.TemporalUnit
        IrregularStep = ... # type: Qgis.TemporalUnit
        Unknown = ... # type: Qgis.TemporalUnit

    class AngleUnit(enum.IntEnum):
        Degrees = ... # type: Qgis.AngleUnit
        Radians = ... # type: Qgis.AngleUnit
        Gon = ... # type: Qgis.AngleUnit
        MinutesOfArc = ... # type: Qgis.AngleUnit
        SecondsOfArc = ... # type: Qgis.AngleUnit
        Turn = ... # type: Qgis.AngleUnit
        MilliradiansSI = ... # type: Qgis.AngleUnit
        MilNATO = ... # type: Qgis.AngleUnit
        Unknown = ... # type: Qgis.AngleUnit

    class VolumeUnit(enum.IntEnum):
        CubicMeters = ... # type: Qgis.VolumeUnit
        CubicFeet = ... # type: Qgis.VolumeUnit
        CubicYards = ... # type: Qgis.VolumeUnit
        Barrel = ... # type: Qgis.VolumeUnit
        CubicDecimeter = ... # type: Qgis.VolumeUnit
        Liters = ... # type: Qgis.VolumeUnit
        GallonUS = ... # type: Qgis.VolumeUnit
        CubicInch = ... # type: Qgis.VolumeUnit
        CubicCentimeter = ... # type: Qgis.VolumeUnit
        CubicDegrees = ... # type: Qgis.VolumeUnit
        Unknown = ... # type: Qgis.VolumeUnit

    class AreaUnit(enum.IntEnum):
        SquareMeters = ... # type: Qgis.AreaUnit
        SquareKilometers = ... # type: Qgis.AreaUnit
        SquareFeet = ... # type: Qgis.AreaUnit
        SquareYards = ... # type: Qgis.AreaUnit
        SquareMiles = ... # type: Qgis.AreaUnit
        Hectares = ... # type: Qgis.AreaUnit
        Acres = ... # type: Qgis.AreaUnit
        SquareNauticalMiles = ... # type: Qgis.AreaUnit
        SquareDegrees = ... # type: Qgis.AreaUnit
        SquareCentimeters = ... # type: Qgis.AreaUnit
        SquareMillimeters = ... # type: Qgis.AreaUnit
        SquareInches = ... # type: Qgis.AreaUnit
        Unknown = ... # type: Qgis.AreaUnit

    class DistanceUnitType(enum.IntEnum):
        Standard = ... # type: Qgis.DistanceUnitType
        Geographic = ... # type: Qgis.DistanceUnitType
        Unknown = ... # type: Qgis.DistanceUnitType

    class DistanceUnit(enum.IntEnum):
        Meters = ... # type: Qgis.DistanceUnit
        Kilometers = ... # type: Qgis.DistanceUnit
        Feet = ... # type: Qgis.DistanceUnit
        NauticalMiles = ... # type: Qgis.DistanceUnit
        Yards = ... # type: Qgis.DistanceUnit
        Miles = ... # type: Qgis.DistanceUnit
        Degrees = ... # type: Qgis.DistanceUnit
        Centimeters = ... # type: Qgis.DistanceUnit
        Millimeters = ... # type: Qgis.DistanceUnit
        Inches = ... # type: Qgis.DistanceUnit
        ChainsInternational = ... # type: Qgis.DistanceUnit
        ChainsBritishBenoit1895A = ... # type: Qgis.DistanceUnit
        ChainsBritishBenoit1895B = ... # type: Qgis.DistanceUnit
        ChainsBritishSears1922Truncated = ... # type: Qgis.DistanceUnit
        ChainsBritishSears1922 = ... # type: Qgis.DistanceUnit
        ChainsClarkes = ... # type: Qgis.DistanceUnit
        ChainsUSSurvey = ... # type: Qgis.DistanceUnit
        FeetBritish1865 = ... # type: Qgis.DistanceUnit
        FeetBritish1936 = ... # type: Qgis.DistanceUnit
        FeetBritishBenoit1895A = ... # type: Qgis.DistanceUnit
        FeetBritishBenoit1895B = ... # type: Qgis.DistanceUnit
        FeetBritishSears1922Truncated = ... # type: Qgis.DistanceUnit
        FeetBritishSears1922 = ... # type: Qgis.DistanceUnit
        FeetClarkes = ... # type: Qgis.DistanceUnit
        FeetGoldCoast = ... # type: Qgis.DistanceUnit
        FeetIndian = ... # type: Qgis.DistanceUnit
        FeetIndian1937 = ... # type: Qgis.DistanceUnit
        FeetIndian1962 = ... # type: Qgis.DistanceUnit
        FeetIndian1975 = ... # type: Qgis.DistanceUnit
        FeetUSSurvey = ... # type: Qgis.DistanceUnit
        LinksInternational = ... # type: Qgis.DistanceUnit
        LinksBritishBenoit1895A = ... # type: Qgis.DistanceUnit
        LinksBritishBenoit1895B = ... # type: Qgis.DistanceUnit
        LinksBritishSears1922Truncated = ... # type: Qgis.DistanceUnit
        LinksBritishSears1922 = ... # type: Qgis.DistanceUnit
        LinksClarkes = ... # type: Qgis.DistanceUnit
        LinksUSSurvey = ... # type: Qgis.DistanceUnit
        YardsBritishBenoit1895A = ... # type: Qgis.DistanceUnit
        YardsBritishBenoit1895B = ... # type: Qgis.DistanceUnit
        YardsBritishSears1922Truncated = ... # type: Qgis.DistanceUnit
        YardsBritishSears1922 = ... # type: Qgis.DistanceUnit
        YardsClarkes = ... # type: Qgis.DistanceUnit
        YardsIndian = ... # type: Qgis.DistanceUnit
        YardsIndian1937 = ... # type: Qgis.DistanceUnit
        YardsIndian1962 = ... # type: Qgis.DistanceUnit
        YardsIndian1975 = ... # type: Qgis.DistanceUnit
        MilesUSSurvey = ... # type: Qgis.DistanceUnit
        Fathoms = ... # type: Qgis.DistanceUnit
        MetersGermanLegal = ... # type: Qgis.DistanceUnit
        Unknown = ... # type: Qgis.DistanceUnit

    class UnitType(enum.IntEnum):
        Distance = ... # type: Qgis.UnitType
        Area = ... # type: Qgis.UnitType
        Volume = ... # type: Qgis.UnitType
        Unknown = ... # type: Qgis.UnitType
        Temporal = ... # type: Qgis.UnitType

    class MapToolUnit(enum.IntEnum):
        Layer = ... # type: Qgis.MapToolUnit
        Pixels = ... # type: Qgis.MapToolUnit
        Project = ... # type: Qgis.MapToolUnit

    class SystemOfMeasurement(enum.IntEnum):
        Unknown = ... # type: Qgis.SystemOfMeasurement
        Metric = ... # type: Qgis.SystemOfMeasurement
        Imperial = ... # type: Qgis.SystemOfMeasurement
        USCS = ... # type: Qgis.SystemOfMeasurement

    class BlendMode(enum.IntEnum):
        Normal = ... # type: Qgis.BlendMode
        Lighten = ... # type: Qgis.BlendMode
        Screen = ... # type: Qgis.BlendMode
        Dodge = ... # type: Qgis.BlendMode
        Addition = ... # type: Qgis.BlendMode
        Darken = ... # type: Qgis.BlendMode
        Multiply = ... # type: Qgis.BlendMode
        Burn = ... # type: Qgis.BlendMode
        Overlay = ... # type: Qgis.BlendMode
        SoftLight = ... # type: Qgis.BlendMode
        HardLight = ... # type: Qgis.BlendMode
        Difference = ... # type: Qgis.BlendMode
        Subtract = ... # type: Qgis.BlendMode
        Source = ... # type: Qgis.BlendMode
        DestinationOver = ... # type: Qgis.BlendMode
        Clear = ... # type: Qgis.BlendMode
        Destination = ... # type: Qgis.BlendMode
        SourceIn = ... # type: Qgis.BlendMode
        DestinationIn = ... # type: Qgis.BlendMode
        SourceOut = ... # type: Qgis.BlendMode
        DestinationOut = ... # type: Qgis.BlendMode
        SourceAtop = ... # type: Qgis.BlendMode
        DestinationAtop = ... # type: Qgis.BlendMode
        Xor = ... # type: Qgis.BlendMode

    class ElevationMapCombineMethod(enum.IntEnum):
        HighestElevation = ... # type: Qgis.ElevationMapCombineMethod
        NewerElevation = ... # type: Qgis.ElevationMapCombineMethod

    class RasterProviderCapability(enum.IntFlag):
        NoProviderCapabilities = ... # type: Qgis.RasterProviderCapability
        ReadLayerMetadata = ... # type: Qgis.RasterProviderCapability
        WriteLayerMetadata = ... # type: Qgis.RasterProviderCapability
        ProviderHintBenefitsFromResampling = ... # type: Qgis.RasterProviderCapability
        ProviderHintCanPerformProviderResampling = ... # type: Qgis.RasterProviderCapability
        ReloadData = ... # type: Qgis.RasterProviderCapability
        DpiDependentData = ... # type: Qgis.RasterProviderCapability
        NativeRasterAttributeTable = ... # type: Qgis.RasterProviderCapability
        BuildPyramids = ... # type: Qgis.RasterProviderCapability

    class RasterInterfaceCapability(enum.IntFlag):
        NoCapabilities = ... # type: Qgis.RasterInterfaceCapability
        Size = ... # type: Qgis.RasterInterfaceCapability
        Create = ... # type: Qgis.RasterInterfaceCapability
        Remove = ... # type: Qgis.RasterInterfaceCapability
        BuildPyramids = ... # type: Qgis.RasterInterfaceCapability
        Identify = ... # type: Qgis.RasterInterfaceCapability
        IdentifyValue = ... # type: Qgis.RasterInterfaceCapability
        IdentifyText = ... # type: Qgis.RasterInterfaceCapability
        IdentifyHtml = ... # type: Qgis.RasterInterfaceCapability
        IdentifyFeature = ... # type: Qgis.RasterInterfaceCapability
        Prefetch = ... # type: Qgis.RasterInterfaceCapability

    class RasterIdentifyFormat(enum.IntFlag):
        Undefined = ... # type: Qgis.RasterIdentifyFormat
        Value = ... # type: Qgis.RasterIdentifyFormat
        Text = ... # type: Qgis.RasterIdentifyFormat
        Html = ... # type: Qgis.RasterIdentifyFormat
        Feature = ... # type: Qgis.RasterIdentifyFormat

    class RasterBuildPyramidOption(enum.IntEnum):
        No = ... # type: Qgis.RasterBuildPyramidOption
        Yes = ... # type: Qgis.RasterBuildPyramidOption
        CopyExisting = ... # type: Qgis.RasterBuildPyramidOption

    class RasterPyramidFormat(enum.IntEnum):
        GeoTiff = ... # type: Qgis.RasterPyramidFormat
        Internal = ... # type: Qgis.RasterPyramidFormat
        Erdas = ... # type: Qgis.RasterPyramidFormat

    class RasterDrawingStyle(enum.IntEnum):
        Undefined = ... # type: Qgis.RasterDrawingStyle
        SingleBandGray = ... # type: Qgis.RasterDrawingStyle
        SingleBandPseudoColor = ... # type: Qgis.RasterDrawingStyle
        PalettedColor = ... # type: Qgis.RasterDrawingStyle
        PalettedSingleBandGray = ... # type: Qgis.RasterDrawingStyle
        PalettedSingleBandPseudoColor = ... # type: Qgis.RasterDrawingStyle
        PalettedMultiBandColor = ... # type: Qgis.RasterDrawingStyle
        MultiBandSingleBandGray = ... # type: Qgis.RasterDrawingStyle
        MultiBandSingleBandPseudoColor = ... # type: Qgis.RasterDrawingStyle
        MultiBandColor = ... # type: Qgis.RasterDrawingStyle
        SingleBandColorData = ... # type: Qgis.RasterDrawingStyle

    class RasterLayerType(enum.IntEnum):
        GrayOrUndefined = ... # type: Qgis.RasterLayerType
        Palette = ... # type: Qgis.RasterLayerType
        MultiBand = ... # type: Qgis.RasterLayerType
        SingleBandColorData = ... # type: Qgis.RasterLayerType

    class RasterColorInterpretation(enum.IntEnum):
        Undefined = ... # type: Qgis.RasterColorInterpretation
        GrayIndex = ... # type: Qgis.RasterColorInterpretation
        PaletteIndex = ... # type: Qgis.RasterColorInterpretation
        RedBand = ... # type: Qgis.RasterColorInterpretation
        GreenBand = ... # type: Qgis.RasterColorInterpretation
        BlueBand = ... # type: Qgis.RasterColorInterpretation
        AlphaBand = ... # type: Qgis.RasterColorInterpretation
        HueBand = ... # type: Qgis.RasterColorInterpretation
        SaturationBand = ... # type: Qgis.RasterColorInterpretation
        LightnessBand = ... # type: Qgis.RasterColorInterpretation
        CyanBand = ... # type: Qgis.RasterColorInterpretation
        MagentaBand = ... # type: Qgis.RasterColorInterpretation
        YellowBand = ... # type: Qgis.RasterColorInterpretation
        BlackBand = ... # type: Qgis.RasterColorInterpretation
        YCbCr_YBand = ... # type: Qgis.RasterColorInterpretation
        YCbCr_CbBand = ... # type: Qgis.RasterColorInterpretation
        YCbCr_CrBand = ... # type: Qgis.RasterColorInterpretation
        ContinuousPalette = ... # type: Qgis.RasterColorInterpretation
        PanBand = ... # type: Qgis.RasterColorInterpretation
        CoastalBand = ... # type: Qgis.RasterColorInterpretation
        RedEdgeBand = ... # type: Qgis.RasterColorInterpretation
        NIRBand = ... # type: Qgis.RasterColorInterpretation
        SWIRBand = ... # type: Qgis.RasterColorInterpretation
        MWIRBand = ... # type: Qgis.RasterColorInterpretation
        LWIRBand = ... # type: Qgis.RasterColorInterpretation
        TIRBand = ... # type: Qgis.RasterColorInterpretation
        OtherIRBand = ... # type: Qgis.RasterColorInterpretation
        SAR_Ka_Band = ... # type: Qgis.RasterColorInterpretation
        SAR_K_Band = ... # type: Qgis.RasterColorInterpretation
        SAR_Ku_Band = ... # type: Qgis.RasterColorInterpretation
        SAR_X_Band = ... # type: Qgis.RasterColorInterpretation
        SAR_C_Band = ... # type: Qgis.RasterColorInterpretation
        SAR_S_Band = ... # type: Qgis.RasterColorInterpretation
        SAR_L_Band = ... # type: Qgis.RasterColorInterpretation
        SAR_P_Band = ... # type: Qgis.RasterColorInterpretation

    class MetadataDateType(enum.Enum):
        Created = ... # type: Qgis.MetadataDateType
        Published = ... # type: Qgis.MetadataDateType
        Revised = ... # type: Qgis.MetadataDateType
        Superseded = ... # type: Qgis.MetadataDateType

    class AttributeActionType(enum.IntEnum):
        Generic = ... # type: Qgis.AttributeActionType
        GenericPython = ... # type: Qgis.AttributeActionType
        Mac = ... # type: Qgis.AttributeActionType
        Windows = ... # type: Qgis.AttributeActionType
        Unix = ... # type: Qgis.AttributeActionType
        OpenUrl = ... # type: Qgis.AttributeActionType
        SubmitUrlEncoded = ... # type: Qgis.AttributeActionType
        SubmitUrlMultipart = ... # type: Qgis.AttributeActionType

    class MapLayerActionFlag(enum.IntFlag):
        EnabledOnlyWhenEditable = ... # type: Qgis.MapLayerActionFlag
        EnableOnlyWhenHasGeometry = ... # type: Qgis.MapLayerActionFlag

    class MapLayerActionTarget(enum.IntFlag):
        Layer = ... # type: Qgis.MapLayerActionTarget
        SingleFeature = ... # type: Qgis.MapLayerActionTarget
        MultipleFeatures = ... # type: Qgis.MapLayerActionTarget
        AllActions = ... # type: Qgis.MapLayerActionTarget

    class ActionType(enum.IntEnum):
        Invalid = ... # type: Qgis.ActionType
        MapLayerAction = ... # type: Qgis.ActionType
        AttributeAction = ... # type: Qgis.ActionType

    class LegendJsonRenderFlag(enum.IntFlag):
        ShowRuleDetails = ... # type: Qgis.LegendJsonRenderFlag

    class LegendSyncMode(enum.IntEnum):
        AllProjectLayers = ... # type: Qgis.LegendSyncMode
        VisibleLayers = ... # type: Qgis.LegendSyncMode
        Manual = ... # type: Qgis.LegendSyncMode

    class LegendComponent(enum.IntEnum):
        Undefined = ... # type: Qgis.LegendComponent
        Hidden = ... # type: Qgis.LegendComponent
        Title = ... # type: Qgis.LegendComponent
        Group = ... # type: Qgis.LegendComponent
        Subgroup = ... # type: Qgis.LegendComponent
        Symbol = ... # type: Qgis.LegendComponent
        SymbolLabel = ... # type: Qgis.LegendComponent

    class MapLayerLegendFlag(enum.IntFlag):
        ExcludeByDefault = ... # type: Qgis.MapLayerLegendFlag

    class LayerTreeFilterFlag(enum.IntFlag):
        SkipVisibilityCheck = ... # type: Qgis.LayerTreeFilterFlag

    class LayerTreeInsertionMethod(enum.IntEnum):
        AboveInsertionPoint = ... # type: Qgis.LayerTreeInsertionMethod
        TopOfTree = ... # type: Qgis.LayerTreeInsertionMethod
        OptimalInInsertionGroup = ... # type: Qgis.LayerTreeInsertionMethod

    class ScriptLanguageCapability(enum.IntFlag):
        Reformat = ... # type: Qgis.ScriptLanguageCapability
        CheckSyntax = ... # type: Qgis.ScriptLanguageCapability
        ToggleComment = ... # type: Qgis.ScriptLanguageCapability

    class ScriptLanguage(enum.IntEnum):
        Css = ... # type: Qgis.ScriptLanguage
        QgisExpression = ... # type: Qgis.ScriptLanguage
        Html = ... # type: Qgis.ScriptLanguage
        JavaScript = ... # type: Qgis.ScriptLanguage
        Json = ... # type: Qgis.ScriptLanguage
        Python = ... # type: Qgis.ScriptLanguage
        R = ... # type: Qgis.ScriptLanguage
        Sql = ... # type: Qgis.ScriptLanguage
        Batch = ... # type: Qgis.ScriptLanguage
        Bash = ... # type: Qgis.ScriptLanguage
        Unknown = ... # type: Qgis.ScriptLanguage

    class SettingsOrigin(enum.IntEnum):
        Any = ... # type: Qgis.SettingsOrigin
        Global = ... # type: Qgis.SettingsOrigin
        Local = ... # type: Qgis.SettingsOrigin

    class CoordinateDisplayType(enum.IntEnum):
        MapCrs = ... # type: Qgis.CoordinateDisplayType
        MapGeographic = ... # type: Qgis.CoordinateDisplayType
        CustomCrs = ... # type: Qgis.CoordinateDisplayType

    class RelationshipCapability(enum.IntFlag):
        MultipleFieldKeys = ... # type: Qgis.RelationshipCapability
        ForwardPathLabel = ... # type: Qgis.RelationshipCapability
        BackwardPathLabel = ... # type: Qgis.RelationshipCapability

    class RelationshipCardinality(enum.IntEnum):
        OneToOne = ... # type: Qgis.RelationshipCardinality
        OneToMany = ... # type: Qgis.RelationshipCardinality
        ManyToOne = ... # type: Qgis.RelationshipCardinality
        ManyToMany = ... # type: Qgis.RelationshipCardinality

    class RelationshipStrength(enum.IntEnum):
        Association = ... # type: Qgis.RelationshipStrength
        Composition = ... # type: Qgis.RelationshipStrength

    class RelationshipType(enum.IntEnum):
        Normal = ... # type: Qgis.RelationshipType
        Generated = ... # type: Qgis.RelationshipType

    class ArcGisRestServiceType(enum.IntEnum):
        FeatureServer = ... # type: Qgis.ArcGisRestServiceType
        MapServer = ... # type: Qgis.ArcGisRestServiceType
        ImageServer = ... # type: Qgis.ArcGisRestServiceType
        GlobeServer = ... # type: Qgis.ArcGisRestServiceType
        GPServer = ... # type: Qgis.ArcGisRestServiceType
        GeocodeServer = ... # type: Qgis.ArcGisRestServiceType
        Unknown = ... # type: Qgis.ArcGisRestServiceType
        SceneServer = ... # type: Qgis.ArcGisRestServiceType

    class MapBoxGlStyleSourceType(enum.IntEnum):
        Vector = ... # type: Qgis.MapBoxGlStyleSourceType
        Raster = ... # type: Qgis.MapBoxGlStyleSourceType
        RasterDem = ... # type: Qgis.MapBoxGlStyleSourceType
        GeoJson = ... # type: Qgis.MapBoxGlStyleSourceType
        Image = ... # type: Qgis.MapBoxGlStyleSourceType
        Video = ... # type: Qgis.MapBoxGlStyleSourceType
        Unknown = ... # type: Qgis.MapBoxGlStyleSourceType

    class ProjectCapability(enum.IntFlag):
        ProjectStyles = ... # type: Qgis.ProjectCapability

    class ProjectReadFlag(enum.IntFlag):
        DontResolveLayers = ... # type: Qgis.ProjectReadFlag
        DontLoadLayouts = ... # type: Qgis.ProjectReadFlag
        TrustLayerMetadata = ... # type: Qgis.ProjectReadFlag
        DontStoreOriginalStyles = ... # type: Qgis.ProjectReadFlag
        DontLoad3DViews = ... # type: Qgis.ProjectReadFlag
        DontLoadProjectStyles = ... # type: Qgis.ProjectReadFlag
        ForceReadOnlyLayers = ... # type: Qgis.ProjectReadFlag
        DontUpgradeAnnotations = ... # type: Qgis.ProjectReadFlag

    class ProjectFileFormat(enum.IntEnum):
        Qgz = ... # type: Qgis.ProjectFileFormat
        Qgs = ... # type: Qgis.ProjectFileFormat

    class AvoidIntersectionsMode(enum.IntEnum):
        AllowIntersections = ... # type: Qgis.AvoidIntersectionsMode
        AvoidIntersectionsCurrentLayer = ... # type: Qgis.AvoidIntersectionsMode
        AvoidIntersectionsLayers = ... # type: Qgis.AvoidIntersectionsMode

    class PointCloudDrawOrder(enum.IntEnum):
        Default = ... # type: Qgis.PointCloudDrawOrder
        BottomToTop = ... # type: Qgis.PointCloudDrawOrder
        TopToBottom = ... # type: Qgis.PointCloudDrawOrder

    class PointCloudSymbol(enum.IntEnum):
        Square = ... # type: Qgis.PointCloudSymbol
        Circle = ... # type: Qgis.PointCloudSymbol

    class ProfileExportType(enum.IntEnum):
        Features3D = ... # type: Qgis.ProfileExportType
        Profile2D = ... # type: Qgis.ProfileExportType
        DistanceVsElevationTable = ... # type: Qgis.ProfileExportType

    class ProfileGeneratorFlag(enum.IntFlag):
        RespectsMaximumErrorMapUnit = ... # type: Qgis.ProfileGeneratorFlag
        RespectsDistanceRange = ... # type: Qgis.ProfileGeneratorFlag
        RespectsElevationRange = ... # type: Qgis.ProfileGeneratorFlag

    class PointCloudProfileType(enum.IntEnum):
        IndividualPoints = ... # type: Qgis.PointCloudProfileType
        TriangulatedSurface = ... # type: Qgis.PointCloudProfileType

    class VectorProfileType(enum.IntEnum):
        IndividualFeatures = ... # type: Qgis.VectorProfileType
        ContinuousSurface = ... # type: Qgis.VectorProfileType

    class ProfileSurfaceSymbology(enum.IntEnum):
        Line = ... # type: Qgis.ProfileSurfaceSymbology
        FillBelow = ... # type: Qgis.ProfileSurfaceSymbology
        FillAbove = ... # type: Qgis.ProfileSurfaceSymbology

    class VerticalAxisInversion(enum.IntEnum):
        Never = ... # type: Qgis.VerticalAxisInversion
        WhenDragging = ... # type: Qgis.VerticalAxisInversion
        Always = ... # type: Qgis.VerticalAxisInversion

    class SceneMode(enum.IntEnum):
        Local = ... # type: Qgis.SceneMode
        Globe = ... # type: Qgis.SceneMode

    class NavigationMode(enum.IntEnum):
        TerrainBased = ... # type: Qgis.NavigationMode
        Walk = ... # type: Qgis.NavigationMode
        GlobeTerrainBased = ... # type: Qgis.NavigationMode

    class LightSourceType(enum.IntEnum):
        Point = ... # type: Qgis.LightSourceType
        Directional = ... # type: Qgis.LightSourceType

    class Point3DShape(enum.IntEnum):
        Cylinder = ... # type: Qgis.Point3DShape
        Sphere = ... # type: Qgis.Point3DShape
        Cone = ... # type: Qgis.Point3DShape
        Cube = ... # type: Qgis.Point3DShape
        Torus = ... # type: Qgis.Point3DShape
        Plane = ... # type: Qgis.Point3DShape
        ExtrudedText = ... # type: Qgis.Point3DShape
        Model = ... # type: Qgis.Point3DShape
        Billboard = ... # type: Qgis.Point3DShape

    class PlotToolFlag(enum.IntFlag):
        ShowContextMenu = ... # type: Qgis.PlotToolFlag

    class ProjectFlag(enum.IntFlag):
        EvaluateDefaultValuesOnProviderSide = ... # type: Qgis.ProjectFlag
        TrustStoredLayerStatistics = ... # type: Qgis.ProjectFlag
        RememberLayerEditStatusBetweenSessions = ... # type: Qgis.ProjectFlag
        RememberAttributeTableWindowsBetweenSessions = ... # type: Qgis.ProjectFlag

    class CadMeasurementDisplayType(enum.IntEnum):
        Hidden = ... # type: Qgis.CadMeasurementDisplayType
        Cartesian = ... # type: Qgis.CadMeasurementDisplayType
        Ellipsoidal = ... # type: Qgis.CadMeasurementDisplayType

    class CadConstraintType(enum.IntEnum):
        Generic = ... # type: Qgis.CadConstraintType
        Angle = ... # type: Qgis.CadConstraintType
        Distance = ... # type: Qgis.CadConstraintType
        XCoordinate = ... # type: Qgis.CadConstraintType
        YCoordinate = ... # type: Qgis.CadConstraintType
        ZValue = ... # type: Qgis.CadConstraintType
        MValue = ... # type: Qgis.CadConstraintType

    class LineExtensionSide(enum.IntEnum):
        BeforeVertex = ... # type: Qgis.LineExtensionSide
        AfterVertex = ... # type: Qgis.LineExtensionSide
        NoVertex = ... # type: Qgis.LineExtensionSide

    class BetweenLineConstraint(enum.IntEnum):
        NoConstraint = ... # type: Qgis.BetweenLineConstraint
        Perpendicular = ... # type: Qgis.BetweenLineConstraint
        Parallel = ... # type: Qgis.BetweenLineConstraint

    class MeshElevationMode(enum.IntEnum):
        FixedElevationRange = ... # type: Qgis.MeshElevationMode
        FromVertices = ... # type: Qgis.MeshElevationMode
        FixedRangePerGroup = ... # type: Qgis.MeshElevationMode

    class RasterElevationMode(enum.IntEnum):
        FixedElevationRange = ... # type: Qgis.RasterElevationMode
        RepresentsElevationSurface = ... # type: Qgis.RasterElevationMode
        FixedRangePerBand = ... # type: Qgis.RasterElevationMode
        DynamicRangePerBand = ... # type: Qgis.RasterElevationMode

    class RangeLimits(enum.IntEnum):
        IncludeBoth = ... # type: Qgis.RangeLimits
        IncludeLowerExcludeUpper = ... # type: Qgis.RangeLimits
        ExcludeLowerIncludeUpper = ... # type: Qgis.RangeLimits
        ExcludeBoth = ... # type: Qgis.RangeLimits

    class AltitudeBinding(enum.IntEnum):
        Vertex = ... # type: Qgis.AltitudeBinding
        Centroid = ... # type: Qgis.AltitudeBinding

    class AltitudeClamping(enum.IntEnum):
        Absolute = ... # type: Qgis.AltitudeClamping
        Relative = ... # type: Qgis.AltitudeClamping
        Terrain = ... # type: Qgis.AltitudeClamping

    class TransactionMode(enum.IntEnum):
        Disabled = ... # type: Qgis.TransactionMode
        AutomaticGroups = ... # type: Qgis.TransactionMode
        BufferedGroups = ... # type: Qgis.TransactionMode

    class FieldDomainType(enum.IntEnum):
        Coded = ... # type: Qgis.FieldDomainType
        Range = ... # type: Qgis.FieldDomainType
        Glob = ... # type: Qgis.FieldDomainType

    class FieldDuplicatePolicy(enum.IntEnum):
        DefaultValue = ... # type: Qgis.FieldDuplicatePolicy
        Duplicate = ... # type: Qgis.FieldDuplicatePolicy
        UnsetField = ... # type: Qgis.FieldDuplicatePolicy

    class FieldDomainMergePolicy(enum.IntEnum):
        DefaultValue = ... # type: Qgis.FieldDomainMergePolicy
        Sum = ... # type: Qgis.FieldDomainMergePolicy
        GeometryWeighted = ... # type: Qgis.FieldDomainMergePolicy
        UnsetField = ... # type: Qgis.FieldDomainMergePolicy
        LargestGeometry = ... # type: Qgis.FieldDomainMergePolicy
        MinimumValue = ... # type: Qgis.FieldDomainMergePolicy
        MaximumValue = ... # type: Qgis.FieldDomainMergePolicy
        SetToNull = ... # type: Qgis.FieldDomainMergePolicy

    class FieldDomainSplitPolicy(enum.IntEnum):
        DefaultValue = ... # type: Qgis.FieldDomainSplitPolicy
        Duplicate = ... # type: Qgis.FieldDomainSplitPolicy
        GeometryRatio = ... # type: Qgis.FieldDomainSplitPolicy
        UnsetField = ... # type: Qgis.FieldDomainSplitPolicy

    class CrsDefinitionFormat(enum.IntEnum):
        Wkt = ... # type: Qgis.CrsDefinitionFormat
        Proj = ... # type: Qgis.CrsDefinitionFormat

    class ProcessingTinInputLayerType(enum.IntEnum):
        Vertices = ... # type: Qgis.ProcessingTinInputLayerType
        StructureLines = ... # type: Qgis.ProcessingTinInputLayerType
        BreakLines = ... # type: Qgis.ProcessingTinInputLayerType

    class ProcessingModelChildAlgorithmExecutionStatus(enum.IntEnum):
        NotExecuted = ... # type: Qgis.ProcessingModelChildAlgorithmExecutionStatus
        Success = ... # type: Qgis.ProcessingModelChildAlgorithmExecutionStatus
        Failed = ... # type: Qgis.ProcessingModelChildAlgorithmExecutionStatus

    class ProcessingModelChildParameterSource(enum.IntEnum):
        ModelParameter = ... # type: Qgis.ProcessingModelChildParameterSource
        ChildOutput = ... # type: Qgis.ProcessingModelChildParameterSource
        StaticValue = ... # type: Qgis.ProcessingModelChildParameterSource
        Expression = ... # type: Qgis.ProcessingModelChildParameterSource
        ExpressionText = ... # type: Qgis.ProcessingModelChildParameterSource
        ModelOutput = ... # type: Qgis.ProcessingModelChildParameterSource

    class ProcessingDateTimeParameterDataType(enum.IntEnum):
        DateTime = ... # type: Qgis.ProcessingDateTimeParameterDataType
        Date = ... # type: Qgis.ProcessingDateTimeParameterDataType
        Time = ... # type: Qgis.ProcessingDateTimeParameterDataType

    class ProcessingFieldParameterDataType(enum.IntEnum):
        Any = ... # type: Qgis.ProcessingFieldParameterDataType
        Numeric = ... # type: Qgis.ProcessingFieldParameterDataType
        String = ... # type: Qgis.ProcessingFieldParameterDataType
        DateTime = ... # type: Qgis.ProcessingFieldParameterDataType
        Binary = ... # type: Qgis.ProcessingFieldParameterDataType
        Boolean = ... # type: Qgis.ProcessingFieldParameterDataType

    class ProcessingNumberParameterType(enum.IntEnum):
        Integer = ... # type: Qgis.ProcessingNumberParameterType
        Double = ... # type: Qgis.ProcessingNumberParameterType

    class ProcessingFileParameterBehavior(enum.IntEnum):
        File = ... # type: Qgis.ProcessingFileParameterBehavior
        Folder = ... # type: Qgis.ProcessingFileParameterBehavior

    class ProcessingParameterFlag(enum.IntFlag):
        Advanced = ... # type: Qgis.ProcessingParameterFlag
        Hidden = ... # type: Qgis.ProcessingParameterFlag
        Optional = ... # type: Qgis.ProcessingParameterFlag
        IsModelOutput = ... # type: Qgis.ProcessingParameterFlag

    class ProcessingParameterTypeFlag(enum.IntFlag):
        ExposeToModeler = ... # type: Qgis.ProcessingParameterTypeFlag

    class ProcessingFeatureSourceFlag(enum.IntFlag):
        SkipGeometryValidityChecks = ... # type: Qgis.ProcessingFeatureSourceFlag

    class ProcessingFeatureSourceDefinitionFlag(enum.IntFlag):
        OverrideDefaultGeometryCheck = ... # type: Qgis.ProcessingFeatureSourceDefinitionFlag
        CreateIndividualOutputPerInputFeature = ... # type: Qgis.ProcessingFeatureSourceDefinitionFlag

    class ProcessingMode(enum.Enum):
        Standard = ... # type: Qgis.ProcessingMode
        Batch = ... # type: Qgis.ProcessingMode
        Modeler = ... # type: Qgis.ProcessingMode

    class ProcessingLogLevel(enum.IntEnum):
        DefaultLevel = ... # type: Qgis.ProcessingLogLevel
        Verbose = ... # type: Qgis.ProcessingLogLevel
        ModelDebug = ... # type: Qgis.ProcessingLogLevel

    class ProcessingPropertyAvailability(enum.IntEnum):
        NotAvailable = ... # type: Qgis.ProcessingPropertyAvailability
        Available = ... # type: Qgis.ProcessingPropertyAvailability

    class ProcessingAlgorithmDocumentationFlag(enum.IntFlag):
        RegeneratesPrimaryKey = ... # type: Qgis.ProcessingAlgorithmDocumentationFlag
        RegeneratesPrimaryKeyInSomeScenarios = ... # type: Qgis.ProcessingAlgorithmDocumentationFlag
        RespectsEllipsoid = ... # type: Qgis.ProcessingAlgorithmDocumentationFlag

    class ProcessingAlgorithmFlag(enum.IntFlag):
        HideFromToolbox = ... # type: Qgis.ProcessingAlgorithmFlag
        HideFromModeler = ... # type: Qgis.ProcessingAlgorithmFlag
        SupportsBatch = ... # type: Qgis.ProcessingAlgorithmFlag
        CanCancel = ... # type: Qgis.ProcessingAlgorithmFlag
        RequiresMatchingCrs = ... # type: Qgis.ProcessingAlgorithmFlag
        NoThreading = ... # type: Qgis.ProcessingAlgorithmFlag
        DisplayNameIsLiteral = ... # type: Qgis.ProcessingAlgorithmFlag
        SupportsInPlaceEdits = ... # type: Qgis.ProcessingAlgorithmFlag
        KnownIssues = ... # type: Qgis.ProcessingAlgorithmFlag
        CustomException = ... # type: Qgis.ProcessingAlgorithmFlag
        PruneModelBranchesBasedOnAlgorithmResults = ... # type: Qgis.ProcessingAlgorithmFlag
        SkipGenericModelLogging = ... # type: Qgis.ProcessingAlgorithmFlag
        NotAvailableInStandaloneTool = ... # type: Qgis.ProcessingAlgorithmFlag
        RequiresProject = ... # type: Qgis.ProcessingAlgorithmFlag
        SecurityRisk = ... # type: Qgis.ProcessingAlgorithmFlag
        Deprecated = ... # type: Qgis.ProcessingAlgorithmFlag

    class ProcessingProviderFlag(enum.IntFlag):
        DeemphasiseSearchResults = ... # type: Qgis.ProcessingProviderFlag
        CompatibleWithVirtualRaster = ... # type: Qgis.ProcessingProviderFlag

    class ProcessingSourceType(enum.IntEnum):
        MapLayer = ... # type: Qgis.ProcessingSourceType
        VectorAnyGeometry = ... # type: Qgis.ProcessingSourceType
        VectorPoint = ... # type: Qgis.ProcessingSourceType
        VectorLine = ... # type: Qgis.ProcessingSourceType
        VectorPolygon = ... # type: Qgis.ProcessingSourceType
        Raster = ... # type: Qgis.ProcessingSourceType
        File = ... # type: Qgis.ProcessingSourceType
        Vector = ... # type: Qgis.ProcessingSourceType
        Mesh = ... # type: Qgis.ProcessingSourceType
        Plugin = ... # type: Qgis.ProcessingSourceType
        PointCloud = ... # type: Qgis.ProcessingSourceType
        Annotation = ... # type: Qgis.ProcessingSourceType
        VectorTile = ... # type: Qgis.ProcessingSourceType
        TiledScene = ... # type: Qgis.ProcessingSourceType

    class QueryStorageBackend(enum.IntEnum):
        LocalProfile = ... # type: Qgis.QueryStorageBackend
        CurrentProject = ... # type: Qgis.QueryStorageBackend

    class HistoryProviderBackend(enum.IntFlag):
        LocalProfile = ... # type: Qgis.HistoryProviderBackend

    class MapRecenteringMode(enum.Enum):
        Always = ... # type: Qgis.MapRecenteringMode
        WhenOutsideVisibleExtent = ... # type: Qgis.MapRecenteringMode
        Never = ... # type: Qgis.MapRecenteringMode

    class ViewSyncModeFlag(enum.IntFlag):
        Sync3DTo2D = ... # type: Qgis.ViewSyncModeFlag
        Sync2DTo3D = ... # type: Qgis.ViewSyncModeFlag

    class MapCanvasFlag(enum.IntFlag):
        ShowMainAnnotationLayer = ... # type: Qgis.MapCanvasFlag

    class RendererUsage(enum.IntEnum):
        View = ... # type: Qgis.RendererUsage
        Export = ... # type: Qgis.RendererUsage
        Unknown = ... # type: Qgis.RendererUsage

    class AngularDirection(enum.IntEnum):
        Clockwise = ... # type: Qgis.AngularDirection
        CounterClockwise = ... # type: Qgis.AngularDirection
        NoOrientation = ... # type: Qgis.AngularDirection

    class ScaleToTileZoomLevelMethod(enum.IntEnum):
        MapBox = ... # type: Qgis.ScaleToTileZoomLevelMethod
        Esri = ... # type: Qgis.ScaleToTileZoomLevelMethod

    class TextRendererFlag(enum.IntFlag):
        WrapLines = ... # type: Qgis.TextRendererFlag

    class Capitalization(enum.IntEnum):
        MixedCase = ... # type: Qgis.Capitalization
        AllUppercase = ... # type: Qgis.Capitalization
        AllLowercase = ... # type: Qgis.Capitalization
        ForceFirstLetterToCapital = ... # type: Qgis.Capitalization
        SmallCaps = ... # type: Qgis.Capitalization
        TitleCase = ... # type: Qgis.Capitalization
        UpperCamelCase = ... # type: Qgis.Capitalization
        AllSmallCaps = ... # type: Qgis.Capitalization

    class TilePixelRatio(enum.Enum):
        Undefined = ... # type: Qgis.TilePixelRatio
        StandardDpi = ... # type: Qgis.TilePixelRatio
        HighDpi = ... # type: Qgis.TilePixelRatio

    class DpiMode(enum.Enum):
        All = ... # type: Qgis.DpiMode
        Off = ... # type: Qgis.DpiMode
        QGIS = ... # type: Qgis.DpiMode
        UMN = ... # type: Qgis.DpiMode
        GeoServer = ... # type: Qgis.DpiMode

    class PieChartLabelType(enum.IntEnum):
        NoLabels = ... # type: Qgis.PieChartLabelType
        Categories = ... # type: Qgis.PieChartLabelType
        Values = ... # type: Qgis.PieChartLabelType

    class PlotAxisType(enum.Enum):
        Interval = ... # type: Qgis.PlotAxisType
        Categorical = ... # type: Qgis.PlotAxisType

    class PlotAxisSuffixPlacement(enum.Enum):
        NoLabels = ... # type: Qgis.PlotAxisSuffixPlacement
        EveryLabel = ... # type: Qgis.PlotAxisSuffixPlacement
        FirstLabel = ... # type: Qgis.PlotAxisSuffixPlacement
        LastLabel = ... # type: Qgis.PlotAxisSuffixPlacement
        FirstAndLastLabels = ... # type: Qgis.PlotAxisSuffixPlacement

    class GraduatedMethod(enum.IntEnum):
        Color = ... # type: Qgis.GraduatedMethod
        Size = ... # type: Qgis.GraduatedMethod

    class DashPatternSizeAdjustment(enum.IntEnum):
        ScaleBothDashAndGap = ... # type: Qgis.DashPatternSizeAdjustment
        ScaleDashOnly = ... # type: Qgis.DashPatternSizeAdjustment
        ScaleGapOnly = ... # type: Qgis.DashPatternSizeAdjustment

    class DashPatternLineEndingRule(enum.IntEnum):
        NoRule = ... # type: Qgis.DashPatternLineEndingRule
        FullDash = ... # type: Qgis.DashPatternLineEndingRule
        HalfDash = ... # type: Qgis.DashPatternLineEndingRule
        FullGap = ... # type: Qgis.DashPatternLineEndingRule
        HalfGap = ... # type: Qgis.DashPatternLineEndingRule

    class LineClipMode(enum.IntEnum):
        ClipPainterOnly = ... # type: Qgis.LineClipMode
        ClipToIntersection = ... # type: Qgis.LineClipMode
        NoClipping = ... # type: Qgis.LineClipMode

    class MarkerClipMode(enum.IntEnum):
        NoClipping = ... # type: Qgis.MarkerClipMode
        Shape = ... # type: Qgis.MarkerClipMode
        CentroidWithin = ... # type: Qgis.MarkerClipMode
        CompletelyWithin = ... # type: Qgis.MarkerClipMode

    class PointCountMethod(enum.IntEnum):
        Absolute = ... # type: Qgis.PointCountMethod
        DensityBased = ... # type: Qgis.PointCountMethod

    class GradientSpread(enum.IntEnum):
        Pad = ... # type: Qgis.GradientSpread
        Reflect = ... # type: Qgis.GradientSpread
        Repeat = ... # type: Qgis.GradientSpread

    class SymbolCoordinateReference(enum.IntEnum):
        Feature = ... # type: Qgis.SymbolCoordinateReference
        Viewport = ... # type: Qgis.SymbolCoordinateReference

    class GradientType(enum.IntEnum):
        Linear = ... # type: Qgis.GradientType
        Radial = ... # type: Qgis.GradientType
        Conical = ... # type: Qgis.GradientType

    class GradientColorSource(enum.IntEnum):
        SimpleTwoColor = ... # type: Qgis.GradientColorSource
        ColorRamp = ... # type: Qgis.GradientColorSource

    class LinearReferencingLabelSource(enum.IntEnum):
        CartesianDistance2D = ... # type: Qgis.LinearReferencingLabelSource
        Z = ... # type: Qgis.LinearReferencingLabelSource
        M = ... # type: Qgis.LinearReferencingLabelSource

    class LinearReferencingPlacement(enum.IntFlag):
        IntervalCartesian2D = ... # type: Qgis.LinearReferencingPlacement
        IntervalZ = ... # type: Qgis.LinearReferencingPlacement
        IntervalM = ... # type: Qgis.LinearReferencingPlacement
        Vertex = ... # type: Qgis.LinearReferencingPlacement

    class MarkerLinePlacement(enum.IntFlag):
        Interval = ... # type: Qgis.MarkerLinePlacement
        Vertex = ... # type: Qgis.MarkerLinePlacement
        LastVertex = ... # type: Qgis.MarkerLinePlacement
        FirstVertex = ... # type: Qgis.MarkerLinePlacement
        CentralPoint = ... # type: Qgis.MarkerLinePlacement
        CurvePoint = ... # type: Qgis.MarkerLinePlacement
        SegmentCenter = ... # type: Qgis.MarkerLinePlacement
        InnerVertices = ... # type: Qgis.MarkerLinePlacement

    class MarkerShape(enum.IntEnum):
        Square = ... # type: Qgis.MarkerShape
        Diamond = ... # type: Qgis.MarkerShape
        Pentagon = ... # type: Qgis.MarkerShape
        Hexagon = ... # type: Qgis.MarkerShape
        Triangle = ... # type: Qgis.MarkerShape
        EquilateralTriangle = ... # type: Qgis.MarkerShape
        Star = ... # type: Qgis.MarkerShape
        Arrow = ... # type: Qgis.MarkerShape
        Circle = ... # type: Qgis.MarkerShape
        Cross = ... # type: Qgis.MarkerShape
        CrossFill = ... # type: Qgis.MarkerShape
        Cross2 = ... # type: Qgis.MarkerShape
        Line = ... # type: Qgis.MarkerShape
        ArrowHead = ... # type: Qgis.MarkerShape
        ArrowHeadFilled = ... # type: Qgis.MarkerShape
        SemiCircle = ... # type: Qgis.MarkerShape
        ThirdCircle = ... # type: Qgis.MarkerShape
        QuarterCircle = ... # type: Qgis.MarkerShape
        QuarterSquare = ... # type: Qgis.MarkerShape
        HalfSquare = ... # type: Qgis.MarkerShape
        DiagonalHalfSquare = ... # type: Qgis.MarkerShape
        RightHalfTriangle = ... # type: Qgis.MarkerShape
        LeftHalfTriangle = ... # type: Qgis.MarkerShape
        Octagon = ... # type: Qgis.MarkerShape
        SquareWithCorners = ... # type: Qgis.MarkerShape
        AsteriskFill = ... # type: Qgis.MarkerShape
        HalfArc = ... # type: Qgis.MarkerShape
        ThirdArc = ... # type: Qgis.MarkerShape
        QuarterArc = ... # type: Qgis.MarkerShape
        ParallelogramRight = ... # type: Qgis.MarkerShape
        ParallelogramLeft = ... # type: Qgis.MarkerShape
        Trapezoid = ... # type: Qgis.MarkerShape
        Shield = ... # type: Qgis.MarkerShape
        DiamondStar = ... # type: Qgis.MarkerShape
        Heart = ... # type: Qgis.MarkerShape
        Decagon = ... # type: Qgis.MarkerShape
        RoundedSquare = ... # type: Qgis.MarkerShape

    class VertexType(enum.IntEnum):
        Segment = ... # type: Qgis.VertexType
        Curve = ... # type: Qgis.VertexType
        ControlPoint = ... # type: Qgis.VertexType

    class SelectiveMaskSourceType(enum.IntEnum):
        SymbolLayer = ... # type: Qgis.SelectiveMaskSourceType
        Label = ... # type: Qgis.SelectiveMaskSourceType

    class RenderSubcomponentProperty(enum.IntEnum):
        Generic = ... # type: Qgis.RenderSubcomponentProperty
        ShadowOffset = ... # type: Qgis.RenderSubcomponentProperty
        BlurSize = ... # type: Qgis.RenderSubcomponentProperty
        GlowSpread = ... # type: Qgis.RenderSubcomponentProperty

    class VectorRenderingSimplificationFlag(enum.IntFlag):
        NoSimplification = ... # type: Qgis.VectorRenderingSimplificationFlag
        GeometrySimplification = ... # type: Qgis.VectorRenderingSimplificationFlag
        AntialiasingSimplification = ... # type: Qgis.VectorRenderingSimplificationFlag
        FullSimplification = ... # type: Qgis.VectorRenderingSimplificationFlag

    class VectorSimplificationAlgorithm(enum.IntEnum):
        Distance = ... # type: Qgis.VectorSimplificationAlgorithm
        SnapToGrid = ... # type: Qgis.VectorSimplificationAlgorithm
        Visvalingam = ... # type: Qgis.VectorSimplificationAlgorithm
        SnappedToGridGlobal = ... # type: Qgis.VectorSimplificationAlgorithm

    class CurvedTextFlag(enum.IntFlag):
        TruncateStringWhenLineIsTooShort = ... # type: Qgis.CurvedTextFlag
        UseBaselinePlacement = ... # type: Qgis.CurvedTextFlag
        UprightCharactersOnly = ... # type: Qgis.CurvedTextFlag
        ExtendLineToFitText = ... # type: Qgis.CurvedTextFlag

    class TextCharacterVerticalAlignment(enum.IntEnum):
        Normal = ... # type: Qgis.TextCharacterVerticalAlignment
        SuperScript = ... # type: Qgis.TextCharacterVerticalAlignment
        SubScript = ... # type: Qgis.TextCharacterVerticalAlignment

    class TextVerticalAlignment(enum.IntEnum):
        Top = ... # type: Qgis.TextVerticalAlignment
        VerticalCenter = ... # type: Qgis.TextVerticalAlignment
        Bottom = ... # type: Qgis.TextVerticalAlignment

    class TextHorizontalAlignment(enum.IntEnum):
        Left = ... # type: Qgis.TextHorizontalAlignment
        Center = ... # type: Qgis.TextHorizontalAlignment
        Right = ... # type: Qgis.TextHorizontalAlignment
        Justify = ... # type: Qgis.TextHorizontalAlignment

    class TextComponent(enum.IntFlag):
        Text = ... # type: Qgis.TextComponent
        Buffer = ... # type: Qgis.TextComponent
        Background = ... # type: Qgis.TextComponent
        Shadow = ... # type: Qgis.TextComponent

    class TextLayoutMode(enum.IntEnum):
        Rectangle = ... # type: Qgis.TextLayoutMode
        Point = ... # type: Qgis.TextLayoutMode
        Labeling = ... # type: Qgis.TextLayoutMode
        RectangleCapHeightBased = ... # type: Qgis.TextLayoutMode
        RectangleAscentBased = ... # type: Qgis.TextLayoutMode

    class TextOrientation(enum.IntEnum):
        Horizontal = ... # type: Qgis.TextOrientation
        Vertical = ... # type: Qgis.TextOrientation
        RotationBased = ... # type: Qgis.TextOrientation

    class LabelPlacementEngineVersion(enum.IntEnum):
        Version1 = ... # type: Qgis.LabelPlacementEngineVersion
        Version2 = ... # type: Qgis.LabelPlacementEngineVersion

    class LabelingFlag(enum.IntFlag):
        UseAllLabels = ... # type: Qgis.LabelingFlag
        UsePartialCandidates = ... # type: Qgis.LabelingFlag
        RenderOutlineLabels = ... # type: Qgis.LabelingFlag
        DrawLabelRectOnly = ... # type: Qgis.LabelingFlag
        DrawCandidates = ... # type: Qgis.LabelingFlag
        DrawUnplacedLabels = ... # type: Qgis.LabelingFlag
        CollectUnplacedLabels = ... # type: Qgis.LabelingFlag
        DrawLabelMetrics = ... # type: Qgis.LabelingFlag

    class TextRenderFormat(enum.IntEnum):
        AlwaysOutlines = ... # type: Qgis.TextRenderFormat
        AlwaysText = ... # type: Qgis.TextRenderFormat
        PreferText = ... # type: Qgis.TextRenderFormat

    class PaintEffectFlag(enum.IntFlag):
        RequiresRasterization = ... # type: Qgis.PaintEffectFlag

    class MapLayerRendererFlag(enum.IntFlag):
        RenderPartialOutputs = ... # type: Qgis.MapLayerRendererFlag
        RenderPartialOutputOverPreviousCachedImage = ... # type: Qgis.MapLayerRendererFlag
        AffectsLabeling = ... # type: Qgis.MapLayerRendererFlag

    class RenderContextFlag(enum.IntFlag):
        DrawEditingInfo = ... # type: Qgis.RenderContextFlag
        ForceVectorOutput = ... # type: Qgis.RenderContextFlag
        UseAdvancedEffects = ... # type: Qgis.RenderContextFlag
        UseRenderingOptimization = ... # type: Qgis.RenderContextFlag
        DrawSelection = ... # type: Qgis.RenderContextFlag
        DrawSymbolBounds = ... # type: Qgis.RenderContextFlag
        RenderMapTile = ... # type: Qgis.RenderContextFlag
        Antialiasing = ... # type: Qgis.RenderContextFlag
        RenderPartialOutput = ... # type: Qgis.RenderContextFlag
        RenderPreviewJob = ... # type: Qgis.RenderContextFlag
        RenderBlocking = ... # type: Qgis.RenderContextFlag
        RenderSymbolPreview = ... # type: Qgis.RenderContextFlag
        LosslessImageRendering = ... # type: Qgis.RenderContextFlag
        ApplyScalingWorkaroundForTextRendering = ... # type: Qgis.RenderContextFlag
        Render3DMap = ... # type: Qgis.RenderContextFlag
        ApplyClipAfterReprojection = ... # type: Qgis.RenderContextFlag
        RenderingSubSymbol = ... # type: Qgis.RenderContextFlag
        HighQualityImageTransforms = ... # type: Qgis.RenderContextFlag
        SkipSymbolRendering = ... # type: Qgis.RenderContextFlag
        RecordProfile = ... # type: Qgis.RenderContextFlag
        AlwaysUseGlobalMasks = ... # type: Qgis.RenderContextFlag
        DisableSymbolClippingToExtent = ... # type: Qgis.RenderContextFlag
        RenderLayerTree = ... # type: Qgis.RenderContextFlag

    class MapSettingsFlag(enum.IntFlag):
        Antialiasing = ... # type: Qgis.MapSettingsFlag
        DrawEditingInfo = ... # type: Qgis.MapSettingsFlag
        ForceVectorOutput = ... # type: Qgis.MapSettingsFlag
        UseAdvancedEffects = ... # type: Qgis.MapSettingsFlag
        DrawLabeling = ... # type: Qgis.MapSettingsFlag
        UseRenderingOptimization = ... # type: Qgis.MapSettingsFlag
        DrawSelection = ... # type: Qgis.MapSettingsFlag
        DrawSymbolBounds = ... # type: Qgis.MapSettingsFlag
        RenderMapTile = ... # type: Qgis.MapSettingsFlag
        RenderPartialOutput = ... # type: Qgis.MapSettingsFlag
        RenderPreviewJob = ... # type: Qgis.MapSettingsFlag
        RenderBlocking = ... # type: Qgis.MapSettingsFlag
        LosslessImageRendering = ... # type: Qgis.MapSettingsFlag
        Render3DMap = ... # type: Qgis.MapSettingsFlag
        HighQualityImageTransforms = ... # type: Qgis.MapSettingsFlag
        SkipSymbolRendering = ... # type: Qgis.MapSettingsFlag
        ForceRasterMasks = ... # type: Qgis.MapSettingsFlag
        RecordProfile = ... # type: Qgis.MapSettingsFlag
        AlwaysUseGlobalMasks = ... # type: Qgis.MapSettingsFlag

    class RasterizedRenderingPolicy(enum.IntEnum):
        Default = ... # type: Qgis.RasterizedRenderingPolicy
        PreferVector = ... # type: Qgis.RasterizedRenderingPolicy
        ForceVector = ... # type: Qgis.RasterizedRenderingPolicy

    class CoordinateTransformationFlag(enum.IntFlag):
        BallparkTransformsAreAppropriate = ... # type: Qgis.CoordinateTransformationFlag
        IgnoreImpossibleTransformations = ... # type: Qgis.CoordinateTransformationFlag

    class TransformDirection(enum.IntEnum):
        Forward = ... # type: Qgis.TransformDirection
        Reverse = ... # type: Qgis.TransformDirection

    class RasterTemporalCapabilityFlag(enum.IntFlag):
        RequestedTimesMustExactlyMatchAllAvailableTemporalRanges = ... # type: Qgis.RasterTemporalCapabilityFlag

    class TemporalIntervalMatchMethod(enum.IntEnum):
        MatchUsingWholeRange = ... # type: Qgis.TemporalIntervalMatchMethod
        MatchExactUsingStartOfRange = ... # type: Qgis.TemporalIntervalMatchMethod
        MatchExactUsingEndOfRange = ... # type: Qgis.TemporalIntervalMatchMethod
        FindClosestMatchToStartOfRange = ... # type: Qgis.TemporalIntervalMatchMethod
        FindClosestMatchToEndOfRange = ... # type: Qgis.TemporalIntervalMatchMethod

    class RasterTemporalMode(enum.IntEnum):
        FixedTemporalRange = ... # type: Qgis.RasterTemporalMode
        TemporalRangeFromDataProvider = ... # type: Qgis.RasterTemporalMode
        RedrawLayerOnly = ... # type: Qgis.RasterTemporalMode
        FixedRangePerBand = ... # type: Qgis.RasterTemporalMode
        RepresentsTemporalValues = ... # type: Qgis.RasterTemporalMode
        FixedDateTime = ... # type: Qgis.RasterTemporalMode

    class VectorDataProviderTemporalMode(enum.IntEnum):
        HasFixedTemporalRange = ... # type: Qgis.VectorDataProviderTemporalMode
        StoresFeatureDateTimeInstantInField = ... # type: Qgis.VectorDataProviderTemporalMode
        StoresFeatureDateTimeStartAndEndInSeparateFields = ... # type: Qgis.VectorDataProviderTemporalMode

    class VectorTemporalLimitMode(enum.IntEnum):
        IncludeBeginExcludeEnd = ... # type: Qgis.VectorTemporalLimitMode
        IncludeBeginIncludeEnd = ... # type: Qgis.VectorTemporalLimitMode

    class VectorTemporalMode(enum.IntEnum):
        FixedTemporalRange = ... # type: Qgis.VectorTemporalMode
        FeatureDateTimeInstantFromField = ... # type: Qgis.VectorTemporalMode
        FeatureDateTimeStartAndEndFromFields = ... # type: Qgis.VectorTemporalMode
        FeatureDateTimeStartAndDurationFromFields = ... # type: Qgis.VectorTemporalMode
        FeatureDateTimeStartAndEndFromExpressions = ... # type: Qgis.VectorTemporalMode
        RedrawLayerOnly = ... # type: Qgis.VectorTemporalMode

    class PlaybackOperation(enum.IntEnum):
        SkipToStart = ... # type: Qgis.PlaybackOperation
        PreviousFrame = ... # type: Qgis.PlaybackOperation
        PlayReverse = ... # type: Qgis.PlaybackOperation
        Pause = ... # type: Qgis.PlaybackOperation
        PlayForward = ... # type: Qgis.PlaybackOperation
        NextFrame = ... # type: Qgis.PlaybackOperation
        SkipToEnd = ... # type: Qgis.PlaybackOperation

    class AnimationState(enum.IntEnum):
        Forward = ... # type: Qgis.AnimationState
        Reverse = ... # type: Qgis.AnimationState
        Idle = ... # type: Qgis.AnimationState

    class TemporalNavigationMode(enum.IntEnum):
        Disabled = ... # type: Qgis.TemporalNavigationMode
        Animated = ... # type: Qgis.TemporalNavigationMode
        FixedRange = ... # type: Qgis.TemporalNavigationMode
        Movie = ... # type: Qgis.TemporalNavigationMode

    class AnnotationItemEditOperationResult(enum.IntEnum):
        Success = ... # type: Qgis.AnnotationItemEditOperationResult
        Invalid = ... # type: Qgis.AnnotationItemEditOperationResult
        ItemCleared = ... # type: Qgis.AnnotationItemEditOperationResult

    class AnnotationItemNodeType(enum.IntEnum):
        VertexHandle = ... # type: Qgis.AnnotationItemNodeType
        CalloutHandle = ... # type: Qgis.AnnotationItemNodeType

    class AnnotationItemGuiFlag(enum.IntFlag):
        FlagNoCreationTools = ... # type: Qgis.AnnotationItemGuiFlag

    class AnnotationPlacementMode(enum.IntEnum):
        SpatialBounds = ... # type: Qgis.AnnotationPlacementMode
        FixedSize = ... # type: Qgis.AnnotationPlacementMode
        RelativeToMapFrame = ... # type: Qgis.AnnotationPlacementMode

    class AnnotationItemFlag(enum.IntFlag):
        ScaleDependentBoundingBox = ... # type: Qgis.AnnotationItemFlag
        SupportsReferenceScale = ... # type: Qgis.AnnotationItemFlag
        SupportsCallouts = ... # type: Qgis.AnnotationItemFlag

    class Axis(enum.IntEnum):
        X = ... # type: Qgis.Axis
        Y = ... # type: Qgis.Axis
        Z = ... # type: Qgis.Axis

    class CrsWktVariant(enum.IntEnum):
        Wkt1Gdal = ... # type: Qgis.CrsWktVariant
        Wkt1Esri = ... # type: Qgis.CrsWktVariant
        Wkt2_2015 = ... # type: Qgis.CrsWktVariant
        Wkt2_2015Simplified = ... # type: Qgis.CrsWktVariant
        Wkt2_2019 = ... # type: Qgis.CrsWktVariant
        Wkt2_2019Simplified = ... # type: Qgis.CrsWktVariant
        Preferred = ... # type: Qgis.CrsWktVariant
        PreferredSimplified = ... # type: Qgis.CrsWktVariant
        PreferredGdal = ... # type: Qgis.CrsWktVariant

    class CrsIdentifierType(enum.IntEnum):
        ShortString = ... # type: Qgis.CrsIdentifierType
        MediumString = ... # type: Qgis.CrsIdentifierType
        FullString = ... # type: Qgis.CrsIdentifierType

    class CoordinateOrder(enum.IntEnum):
        Default = ... # type: Qgis.CoordinateOrder
        XY = ... # type: Qgis.CoordinateOrder
        YX = ... # type: Qgis.CoordinateOrder

    class CrsAxisDirection(enum.IntEnum):
        North = ... # type: Qgis.CrsAxisDirection
        NorthNorthEast = ... # type: Qgis.CrsAxisDirection
        NorthEast = ... # type: Qgis.CrsAxisDirection
        EastNorthEast = ... # type: Qgis.CrsAxisDirection
        East = ... # type: Qgis.CrsAxisDirection
        EastSouthEast = ... # type: Qgis.CrsAxisDirection
        SouthEast = ... # type: Qgis.CrsAxisDirection
        SouthSouthEast = ... # type: Qgis.CrsAxisDirection
        South = ... # type: Qgis.CrsAxisDirection
        SouthSouthWest = ... # type: Qgis.CrsAxisDirection
        SouthWest = ... # type: Qgis.CrsAxisDirection
        WestSouthWest = ... # type: Qgis.CrsAxisDirection
        West = ... # type: Qgis.CrsAxisDirection
        WestNorthWest = ... # type: Qgis.CrsAxisDirection
        NorthWest = ... # type: Qgis.CrsAxisDirection
        NorthNorthWest = ... # type: Qgis.CrsAxisDirection
        GeocentricX = ... # type: Qgis.CrsAxisDirection
        GeocentricY = ... # type: Qgis.CrsAxisDirection
        GeocentricZ = ... # type: Qgis.CrsAxisDirection
        Up = ... # type: Qgis.CrsAxisDirection
        Down = ... # type: Qgis.CrsAxisDirection
        Forward = ... # type: Qgis.CrsAxisDirection
        Aft = ... # type: Qgis.CrsAxisDirection
        Port = ... # type: Qgis.CrsAxisDirection
        Starboard = ... # type: Qgis.CrsAxisDirection
        Clockwise = ... # type: Qgis.CrsAxisDirection
        CounterClockwise = ... # type: Qgis.CrsAxisDirection
        ColumnPositive = ... # type: Qgis.CrsAxisDirection
        ColumnNegative = ... # type: Qgis.CrsAxisDirection
        RowPositive = ... # type: Qgis.CrsAxisDirection
        RowNegative = ... # type: Qgis.CrsAxisDirection
        DisplayRight = ... # type: Qgis.CrsAxisDirection
        DisplayLeft = ... # type: Qgis.CrsAxisDirection
        DisplayUp = ... # type: Qgis.CrsAxisDirection
        DisplayDown = ... # type: Qgis.CrsAxisDirection
        Future = ... # type: Qgis.CrsAxisDirection
        Past = ... # type: Qgis.CrsAxisDirection
        Towards = ... # type: Qgis.CrsAxisDirection
        AwayFrom = ... # type: Qgis.CrsAxisDirection
        Unspecified = ... # type: Qgis.CrsAxisDirection

    class CrsType(enum.IntEnum):
        Unknown = ... # type: Qgis.CrsType
        Geodetic = ... # type: Qgis.CrsType
        Geocentric = ... # type: Qgis.CrsType
        Geographic2d = ... # type: Qgis.CrsType
        Geographic3d = ... # type: Qgis.CrsType
        Vertical = ... # type: Qgis.CrsType
        Projected = ... # type: Qgis.CrsType
        Compound = ... # type: Qgis.CrsType
        Temporal = ... # type: Qgis.CrsType
        Engineering = ... # type: Qgis.CrsType
        Bound = ... # type: Qgis.CrsType
        Other = ... # type: Qgis.CrsType
        DerivedProjected = ... # type: Qgis.CrsType

    class DataProviderFlag(enum.IntFlag):
        IsBasemapSource = ... # type: Qgis.DataProviderFlag
        FastExtent2D = ... # type: Qgis.DataProviderFlag
        FastExtent3D = ... # type: Qgis.DataProviderFlag
        Is3DBasemapSource = ... # type: Qgis.DataProviderFlag

    class AutoRefreshMode(enum.IntEnum):
        Disabled = ... # type: Qgis.AutoRefreshMode
        ReloadData = ... # type: Qgis.AutoRefreshMode
        RedrawOnly = ... # type: Qgis.AutoRefreshMode

    class MapLayerProperty(enum.IntFlag):
        UsersCannotToggleEditing = ... # type: Qgis.MapLayerProperty
        IsBasemapLayer = ... # type: Qgis.MapLayerProperty
        Is3DBasemapLayer = ... # type: Qgis.MapLayerProperty

    class FileOperationFlag(enum.IntFlag):
        IncludeMetadataFile = ... # type: Qgis.FileOperationFlag
        IncludeStyleFile = ... # type: Qgis.FileOperationFlag

    class SpatialFilterType(enum.IntEnum):
        NoFilter = ... # type: Qgis.SpatialFilterType
        BoundingBox = ... # type: Qgis.SpatialFilterType
        DistanceWithin = ... # type: Qgis.SpatialFilterType

    class InvalidGeometryCheck(enum.IntEnum):
        NoCheck = ... # type: Qgis.InvalidGeometryCheck
        SkipInvalid = ... # type: Qgis.InvalidGeometryCheck
        AbortOnInvalid = ... # type: Qgis.InvalidGeometryCheck

    class FeatureRequestFilterType(enum.IntEnum):
        NoFilter = ... # type: Qgis.FeatureRequestFilterType
        Fid = ... # type: Qgis.FeatureRequestFilterType
        Expression = ... # type: Qgis.FeatureRequestFilterType
        Fids = ... # type: Qgis.FeatureRequestFilterType

    class FeatureRequestFlag(enum.IntFlag):
        NoFlags = ... # type: Qgis.FeatureRequestFlag
        NoGeometry = ... # type: Qgis.FeatureRequestFlag
        SubsetOfAttributes = ... # type: Qgis.FeatureRequestFlag
        ExactIntersect = ... # type: Qgis.FeatureRequestFlag
        IgnoreStaticNodesDuringExpressionCompilation = ... # type: Qgis.FeatureRequestFlag
        EmbeddedSymbols = ... # type: Qgis.FeatureRequestFlag

    class MakeValidMethod(enum.IntEnum):
        Linework = ... # type: Qgis.MakeValidMethod
        Structure = ... # type: Qgis.MakeValidMethod

    class CoverageValidityResult(enum.IntEnum):
        Invalid = ... # type: Qgis.CoverageValidityResult
        Valid = ... # type: Qgis.CoverageValidityResult
        Error = ... # type: Qgis.CoverageValidityResult

    class GeosCreationFlag(enum.IntFlag):
        RejectOnInvalidSubGeometry = ... # type: Qgis.GeosCreationFlag
        SkipEmptyInteriorRings = ... # type: Qgis.GeosCreationFlag

    class JoinStyle3D(enum.IntEnum):
        Round = ... # type: Qgis.JoinStyle3D
        Flat = ... # type: Qgis.JoinStyle3D
        CylindersAndSpheres = ... # type: Qgis.JoinStyle3D

    class JoinStyle(enum.IntEnum):
        Round = ... # type: Qgis.JoinStyle
        Miter = ... # type: Qgis.JoinStyle
        Bevel = ... # type: Qgis.JoinStyle

    class EndCapStyle(enum.IntEnum):
        Round = ... # type: Qgis.EndCapStyle
        Flat = ... # type: Qgis.EndCapStyle
        Square = ... # type: Qgis.EndCapStyle

    class BufferSide(enum.IntEnum):
        Left = ... # type: Qgis.BufferSide
        Right = ... # type: Qgis.BufferSide

    class GeometryValidationEngine(enum.IntEnum):
        QgisInternal = ... # type: Qgis.GeometryValidationEngine
        Geos = ... # type: Qgis.GeometryValidationEngine

    class GeometryValidityFlag(enum.IntFlag):
        AllowSelfTouchingHoles = ... # type: Qgis.GeometryValidityFlag

    class GeometryOperationResult(enum.IntEnum):
        Success = ... # type: Qgis.GeometryOperationResult
        NothingHappened = ... # type: Qgis.GeometryOperationResult
        InvalidBaseGeometry = ... # type: Qgis.GeometryOperationResult
        InvalidInputGeometryType = ... # type: Qgis.GeometryOperationResult
        SelectionIsEmpty = ... # type: Qgis.GeometryOperationResult
        SelectionIsGreaterThanOne = ... # type: Qgis.GeometryOperationResult
        GeometryEngineError = ... # type: Qgis.GeometryOperationResult
        LayerNotEditable = ... # type: Qgis.GeometryOperationResult
        AddPartSelectedGeometryNotFound = ... # type: Qgis.GeometryOperationResult
        AddPartNotMultiGeometry = ... # type: Qgis.GeometryOperationResult
        AddRingNotClosed = ... # type: Qgis.GeometryOperationResult
        AddRingNotValid = ... # type: Qgis.GeometryOperationResult
        AddRingCrossesExistingRings = ... # type: Qgis.GeometryOperationResult
        AddRingNotInExistingFeature = ... # type: Qgis.GeometryOperationResult
        SplitCannotSplitPoint = ... # type: Qgis.GeometryOperationResult
        GeometryTypeHasChanged = ... # type: Qgis.GeometryOperationResult

    class GpsFeatureType(enum.IntEnum):
        Waypoint = ... # type: Qgis.GpsFeatureType
        Route = ... # type: Qgis.GpsFeatureType
        Track = ... # type: Qgis.GpsFeatureType

    class BabelCommandFlag(enum.IntFlag):
        QuoteFilePaths = ... # type: Qgis.BabelCommandFlag

    class BabelFormatCapability(enum.IntFlag):
        Import = ... # type: Qgis.BabelFormatCapability
        Export = ... # type: Qgis.BabelFormatCapability
        Waypoints = ... # type: Qgis.BabelFormatCapability
        Routes = ... # type: Qgis.BabelFormatCapability
        Tracks = ... # type: Qgis.BabelFormatCapability

    class GpsInformationComponent(enum.IntFlag):
        Location = ... # type: Qgis.GpsInformationComponent
        Altitude = ... # type: Qgis.GpsInformationComponent
        GroundSpeed = ... # type: Qgis.GpsInformationComponent
        Bearing = ... # type: Qgis.GpsInformationComponent
        TotalTrackLength = ... # type: Qgis.GpsInformationComponent
        TrackDistanceFromStart = ... # type: Qgis.GpsInformationComponent
        Pdop = ... # type: Qgis.GpsInformationComponent
        Hdop = ... # type: Qgis.GpsInformationComponent
        Vdop = ... # type: Qgis.GpsInformationComponent
        HorizontalAccuracy = ... # type: Qgis.GpsInformationComponent
        VerticalAccuracy = ... # type: Qgis.GpsInformationComponent
        HvAccuracy = ... # type: Qgis.GpsInformationComponent
        SatellitesUsed = ... # type: Qgis.GpsInformationComponent
        Timestamp = ... # type: Qgis.GpsInformationComponent
        TrackStartTime = ... # type: Qgis.GpsInformationComponent
        TrackEndTime = ... # type: Qgis.GpsInformationComponent
        TrackDistanceSinceLastPoint = ... # type: Qgis.GpsInformationComponent
        TrackTimeSinceLastPoint = ... # type: Qgis.GpsInformationComponent
        GeoidalSeparation = ... # type: Qgis.GpsInformationComponent
        EllipsoidAltitude = ... # type: Qgis.GpsInformationComponent

    class GpsNavigationStatus(enum.IntEnum):
        NotValid = ... # type: Qgis.GpsNavigationStatus
        Safe = ... # type: Qgis.GpsNavigationStatus
        Caution = ... # type: Qgis.GpsNavigationStatus
        Unsafe = ... # type: Qgis.GpsNavigationStatus

    class GpsQualityIndicator(enum.Enum):
        Unknown = ... # type: Qgis.GpsQualityIndicator
        Invalid = ... # type: Qgis.GpsQualityIndicator
        GPS = ... # type: Qgis.GpsQualityIndicator
        DGPS = ... # type: Qgis.GpsQualityIndicator
        PPS = ... # type: Qgis.GpsQualityIndicator
        RTK = ... # type: Qgis.GpsQualityIndicator
        FloatRTK = ... # type: Qgis.GpsQualityIndicator
        Estimated = ... # type: Qgis.GpsQualityIndicator
        Manual = ... # type: Qgis.GpsQualityIndicator
        Simulation = ... # type: Qgis.GpsQualityIndicator

    class GnssConstellation(enum.Enum):
        Unknown = ... # type: Qgis.GnssConstellation
        Gps = ... # type: Qgis.GnssConstellation
        Glonass = ... # type: Qgis.GnssConstellation
        Galileo = ... # type: Qgis.GnssConstellation
        BeiDou = ... # type: Qgis.GnssConstellation
        Qzss = ... # type: Qgis.GnssConstellation
        Navic = ... # type: Qgis.GnssConstellation
        Sbas = ... # type: Qgis.GnssConstellation

    class GpsFixStatus(enum.IntEnum):
        NoData = ... # type: Qgis.GpsFixStatus
        NoFix = ... # type: Qgis.GpsFixStatus
        Fix2D = ... # type: Qgis.GpsFixStatus
        Fix3D = ... # type: Qgis.GpsFixStatus

    class DeviceConnectionStatus(enum.IntEnum):
        Disconnected = ... # type: Qgis.DeviceConnectionStatus
        Connecting = ... # type: Qgis.DeviceConnectionStatus
        Connected = ... # type: Qgis.DeviceConnectionStatus

    class GpsConnectionType(enum.IntEnum):
        Automatic = ... # type: Qgis.GpsConnectionType
        Internal = ... # type: Qgis.GpsConnectionType
        Serial = ... # type: Qgis.GpsConnectionType
        Gpsd = ... # type: Qgis.GpsConnectionType

    class ContentStatus(enum.IntEnum):
        NotStarted = ... # type: Qgis.ContentStatus
        Running = ... # type: Qgis.ContentStatus
        Finished = ... # type: Qgis.ContentStatus
        Failed = ... # type: Qgis.ContentStatus
        Canceled = ... # type: Qgis.ContentStatus

    class VertexMarkerType(enum.IntEnum):
        SemiTransparentCircle = ... # type: Qgis.VertexMarkerType
        Cross = ... # type: Qgis.VertexMarkerType
        NoMarker = ... # type: Qgis.VertexMarkerType

    class VectorEditResult(enum.IntEnum):
        Success = ... # type: Qgis.VectorEditResult
        EmptyGeometry = ... # type: Qgis.VectorEditResult
        EditFailed = ... # type: Qgis.VectorEditResult
        FetchFeatureFailed = ... # type: Qgis.VectorEditResult
        InvalidLayer = ... # type: Qgis.VectorEditResult

    class SelectionFlag(enum.IntFlag):
        SingleFeatureSelection = ... # type: Qgis.SelectionFlag
        ToggleSelection = ... # type: Qgis.SelectionFlag

    class SelectGeometryRelationship(enum.IntEnum):
        Intersect = ... # type: Qgis.SelectGeometryRelationship
        Within = ... # type: Qgis.SelectGeometryRelationship

    class SelectBehavior(enum.IntEnum):
        SetSelection = ... # type: Qgis.SelectBehavior
        AddToSelection = ... # type: Qgis.SelectBehavior
        IntersectSelection = ... # type: Qgis.SelectBehavior
        RemoveFromSelection = ... # type: Qgis.SelectBehavior

    class SelectionRenderingMode(enum.IntEnum):
        Default = ... # type: Qgis.SelectionRenderingMode
        CustomColor = ... # type: Qgis.SelectionRenderingMode
        CustomSymbol = ... # type: Qgis.SelectionRenderingMode

    class FieldMetadataProperty(enum.IntEnum):
        GeometryCrs = ... # type: Qgis.FieldMetadataProperty
        GeometryWkbType = ... # type: Qgis.FieldMetadataProperty
        CustomProperty = ... # type: Qgis.FieldMetadataProperty

    class FieldConfigurationFlag(enum.IntFlag):
        NoFlag = ... # type: Qgis.FieldConfigurationFlag
        NotSearchable = ... # type: Qgis.FieldConfigurationFlag
        HideFromWms = ... # type: Qgis.FieldConfigurationFlag
        HideFromWfs = ... # type: Qgis.FieldConfigurationFlag

    class FieldOrigin(enum.IntEnum):
        Unknown = ... # type: Qgis.FieldOrigin
        Provider = ... # type: Qgis.FieldOrigin
        Join = ... # type: Qgis.FieldOrigin
        Edit = ... # type: Qgis.FieldOrigin
        Expression = ... # type: Qgis.FieldOrigin

    class SublayerPromptMode(enum.IntEnum):
        AlwaysAsk = ... # type: Qgis.SublayerPromptMode
        AskExcludingRasterBands = ... # type: Qgis.SublayerPromptMode
        NeverAskSkip = ... # type: Qgis.SublayerPromptMode
        NeverAskLoadAll = ... # type: Qgis.SublayerPromptMode

    class FilePathType(enum.IntEnum):
        Absolute = ... # type: Qgis.FilePathType
        Relative = ... # type: Qgis.FilePathType

    class MeshEditingErrorType(enum.IntEnum):
        NoError = ... # type: Qgis.MeshEditingErrorType
        InvalidFace = ... # type: Qgis.MeshEditingErrorType
        TooManyVerticesInFace = ... # type: Qgis.MeshEditingErrorType
        FlatFace = ... # type: Qgis.MeshEditingErrorType
        UniqueSharedVertex = ... # type: Qgis.MeshEditingErrorType
        InvalidVertex = ... # type: Qgis.MeshEditingErrorType
        ManifoldFace = ... # type: Qgis.MeshEditingErrorType

    class RasterFileWriterResult(enum.IntEnum):
        Success = ... # type: Qgis.RasterFileWriterResult
        SourceProviderError = ... # type: Qgis.RasterFileWriterResult
        DestinationProviderError = ... # type: Qgis.RasterFileWriterResult
        CreateDatasourceError = ... # type: Qgis.RasterFileWriterResult
        WriteError = ... # type: Qgis.RasterFileWriterResult
        NoDataConflict = ... # type: Qgis.RasterFileWriterResult
        Canceled = ... # type: Qgis.RasterFileWriterResult

    class RasterExportType(enum.IntEnum):
        Raw = ... # type: Qgis.RasterExportType
        RenderedImage = ... # type: Qgis.RasterExportType

    class RasterAttributeTableType(enum.IntEnum):
        Thematic = ... # type: Qgis.RasterAttributeTableType
        Athematic = ... # type: Qgis.RasterAttributeTableType

    class RasterAttributeTableFieldUsage(enum.IntEnum):
        Generic = ... # type: Qgis.RasterAttributeTableFieldUsage
        PixelCount = ... # type: Qgis.RasterAttributeTableFieldUsage
        Name = ... # type: Qgis.RasterAttributeTableFieldUsage
        Min = ... # type: Qgis.RasterAttributeTableFieldUsage
        Max = ... # type: Qgis.RasterAttributeTableFieldUsage
        MinMax = ... # type: Qgis.RasterAttributeTableFieldUsage
        Red = ... # type: Qgis.RasterAttributeTableFieldUsage
        Green = ... # type: Qgis.RasterAttributeTableFieldUsage
        Blue = ... # type: Qgis.RasterAttributeTableFieldUsage
        Alpha = ... # type: Qgis.RasterAttributeTableFieldUsage
        RedMin = ... # type: Qgis.RasterAttributeTableFieldUsage
        GreenMin = ... # type: Qgis.RasterAttributeTableFieldUsage
        BlueMin = ... # type: Qgis.RasterAttributeTableFieldUsage
        AlphaMin = ... # type: Qgis.RasterAttributeTableFieldUsage
        RedMax = ... # type: Qgis.RasterAttributeTableFieldUsage
        GreenMax = ... # type: Qgis.RasterAttributeTableFieldUsage
        BlueMax = ... # type: Qgis.RasterAttributeTableFieldUsage
        AlphaMax = ... # type: Qgis.RasterAttributeTableFieldUsage
        MaxCount = ... # type: Qgis.RasterAttributeTableFieldUsage

    class RasterRangeAccuracy(enum.IntEnum):
        Exact = ... # type: Qgis.RasterRangeAccuracy
        Estimated = ... # type: Qgis.RasterRangeAccuracy

    class RasterRangeExtent(enum.IntEnum):
        WholeRaster = ... # type: Qgis.RasterRangeExtent
        FixedCanvas = ... # type: Qgis.RasterRangeExtent
        UpdatedCanvas = ... # type: Qgis.RasterRangeExtent

    class RasterRangeLimit(enum.IntEnum):
        NotSet = ... # type: Qgis.RasterRangeLimit
        MinimumMaximum = ... # type: Qgis.RasterRangeLimit
        StdDev = ... # type: Qgis.RasterRangeLimit
        CumulativeCut = ... # type: Qgis.RasterRangeLimit

    class RasterRendererCapability(enum.IntFlag):
        UsesMultipleBands = ... # type: Qgis.RasterRendererCapability

    class RasterRendererFlag(enum.IntFlag):
        InternalLayerOpacityHandling = ... # type: Qgis.RasterRendererFlag
        UseNoDataForOutOfRangePixels = ... # type: Qgis.RasterRendererFlag

    class RasterResamplingMethod(enum.IntEnum):
        Nearest = ... # type: Qgis.RasterResamplingMethod
        Bilinear = ... # type: Qgis.RasterResamplingMethod
        Cubic = ... # type: Qgis.RasterResamplingMethod
        CubicSpline = ... # type: Qgis.RasterResamplingMethod
        Lanczos = ... # type: Qgis.RasterResamplingMethod
        Average = ... # type: Qgis.RasterResamplingMethod
        Mode = ... # type: Qgis.RasterResamplingMethod
        Gauss = ... # type: Qgis.RasterResamplingMethod

    class RasterResamplingStage(enum.IntEnum):
        ResampleFilter = ... # type: Qgis.RasterResamplingStage
        Provider = ... # type: Qgis.RasterResamplingStage

    class RasterPipeInterfaceRole(enum.IntEnum):
        Unknown = ... # type: Qgis.RasterPipeInterfaceRole
        Provider = ... # type: Qgis.RasterPipeInterfaceRole
        Renderer = ... # type: Qgis.RasterPipeInterfaceRole
        Brightness = ... # type: Qgis.RasterPipeInterfaceRole
        Resampler = ... # type: Qgis.RasterPipeInterfaceRole
        Projector = ... # type: Qgis.RasterPipeInterfaceRole
        Nuller = ... # type: Qgis.RasterPipeInterfaceRole
        HueSaturation = ... # type: Qgis.RasterPipeInterfaceRole

    class ShaderClassificationMethod(enum.IntEnum):
        Continuous = ... # type: Qgis.ShaderClassificationMethod
        EqualInterval = ... # type: Qgis.ShaderClassificationMethod
        Quantile = ... # type: Qgis.ShaderClassificationMethod

    class ShaderInterpolationMethod(enum.IntEnum):
        Linear = ... # type: Qgis.ShaderInterpolationMethod
        Discrete = ... # type: Qgis.ShaderInterpolationMethod
        Exact = ... # type: Qgis.ShaderInterpolationMethod

    class SublayerFlag(enum.IntFlag):
        SystemTable = ... # type: Qgis.SublayerFlag

    class SublayerQueryFlag(enum.IntFlag):
        FastScan = ... # type: Qgis.SublayerQueryFlag
        ResolveGeometryType = ... # type: Qgis.SublayerQueryFlag
        CountFeatures = ... # type: Qgis.SublayerQueryFlag
        IncludeSystemTables = ... # type: Qgis.SublayerQueryFlag
        OpenLayersToResolveDescriptions = ... # type: Qgis.SublayerQueryFlag

    class SourceHierarchyLevel(enum.IntEnum):
        Connection = ... # type: Qgis.SourceHierarchyLevel
        Group = ... # type: Qgis.SourceHierarchyLevel
        Object = ... # type: Qgis.SourceHierarchyLevel

    class UriCleaningFlag(enum.IntFlag):
        RemoveCredentials = ... # type: Qgis.UriCleaningFlag
        RedactCredentials = ... # type: Qgis.UriCleaningFlag

    class FileFilterType(enum.IntEnum):
        Vector = ... # type: Qgis.FileFilterType
        Raster = ... # type: Qgis.FileFilterType
        Mesh = ... # type: Qgis.FileFilterType
        MeshDataset = ... # type: Qgis.FileFilterType
        PointCloud = ... # type: Qgis.FileFilterType
        VectorTile = ... # type: Qgis.FileFilterType
        TiledScene = ... # type: Qgis.FileFilterType

    class LabelMultiLineAlignment(enum.IntEnum):
        Left = ... # type: Qgis.LabelMultiLineAlignment
        Center = ... # type: Qgis.LabelMultiLineAlignment
        Right = ... # type: Qgis.LabelMultiLineAlignment
        FollowPlacement = ... # type: Qgis.LabelMultiLineAlignment
        Justify = ... # type: Qgis.LabelMultiLineAlignment

    class UpsideDownLabelHandling(enum.IntEnum):
        FlipUpsideDownLabels = ... # type: Qgis.UpsideDownLabelHandling
        AllowUpsideDownWhenRotationIsDefined = ... # type: Qgis.UpsideDownLabelHandling
        AlwaysAllowUpsideDown = ... # type: Qgis.UpsideDownLabelHandling

    class LabelPolygonPlacementFlag(enum.IntFlag):
        AllowPlacementOutsideOfPolygon = ... # type: Qgis.LabelPolygonPlacementFlag
        AllowPlacementInsideOfPolygon = ... # type: Qgis.LabelPolygonPlacementFlag

    class LabelLinePlacementFlag(enum.IntFlag):
        OnLine = ... # type: Qgis.LabelLinePlacementFlag
        AboveLine = ... # type: Qgis.LabelLinePlacementFlag
        BelowLine = ... # type: Qgis.LabelLinePlacementFlag
        MapOrientation = ... # type: Qgis.LabelLinePlacementFlag

    class LabelQuadrantPosition(enum.IntEnum):
        AboveLeft = ... # type: Qgis.LabelQuadrantPosition
        Above = ... # type: Qgis.LabelQuadrantPosition
        AboveRight = ... # type: Qgis.LabelQuadrantPosition
        Left = ... # type: Qgis.LabelQuadrantPosition
        Over = ... # type: Qgis.LabelQuadrantPosition
        Right = ... # type: Qgis.LabelQuadrantPosition
        BelowLeft = ... # type: Qgis.LabelQuadrantPosition
        Below = ... # type: Qgis.LabelQuadrantPosition
        BelowRight = ... # type: Qgis.LabelQuadrantPosition

    class LabelOffsetType(enum.IntEnum):
        FromPoint = ... # type: Qgis.LabelOffsetType
        FromSymbolBounds = ... # type: Qgis.LabelOffsetType

    class MultiPartLabelingBehavior(enum.IntEnum):
        LabelLargestPartOnly = ... # type: Qgis.MultiPartLabelingBehavior
        LabelEveryPartWithEntireLabel = ... # type: Qgis.MultiPartLabelingBehavior
        SplitLabelTextLinesOverParts = ... # type: Qgis.MultiPartLabelingBehavior

    class LabelPredefinedPointPosition(enum.IntEnum):
        TopLeft = ... # type: Qgis.LabelPredefinedPointPosition
        TopSlightlyLeft = ... # type: Qgis.LabelPredefinedPointPosition
        TopMiddle = ... # type: Qgis.LabelPredefinedPointPosition
        TopSlightlyRight = ... # type: Qgis.LabelPredefinedPointPosition
        TopRight = ... # type: Qgis.LabelPredefinedPointPosition
        MiddleLeft = ... # type: Qgis.LabelPredefinedPointPosition
        MiddleRight = ... # type: Qgis.LabelPredefinedPointPosition
        BottomLeft = ... # type: Qgis.LabelPredefinedPointPosition
        BottomSlightlyLeft = ... # type: Qgis.LabelPredefinedPointPosition
        BottomMiddle = ... # type: Qgis.LabelPredefinedPointPosition
        BottomSlightlyRight = ... # type: Qgis.LabelPredefinedPointPosition
        BottomRight = ... # type: Qgis.LabelPredefinedPointPosition
        OverPoint = ... # type: Qgis.LabelPredefinedPointPosition

    class CurvedLabelMode(enum.IntEnum):
        Default = ... # type: Qgis.CurvedLabelMode
        PlaceCharactersAtVertices = ... # type: Qgis.CurvedLabelMode
        StretchCharacterSpacingToFitLine = ... # type: Qgis.CurvedLabelMode
        StretchWordSpacingToFitLine = ... # type: Qgis.CurvedLabelMode

    class LabelPlacement(enum.IntEnum):
        AroundPoint = ... # type: Qgis.LabelPlacement
        OverPoint = ... # type: Qgis.LabelPlacement
        Line = ... # type: Qgis.LabelPlacement
        Curved = ... # type: Qgis.LabelPlacement
        Horizontal = ... # type: Qgis.LabelPlacement
        Free = ... # type: Qgis.LabelPlacement
        OrderedPositionsAroundPoint = ... # type: Qgis.LabelPlacement
        PerimeterCurved = ... # type: Qgis.LabelPlacement
        OutsidePolygons = ... # type: Qgis.LabelPlacement

    class LabelPrioritization(enum.IntEnum):
        PreferCloser = ... # type: Qgis.LabelPrioritization
        PreferPositionOrdering = ... # type: Qgis.LabelPrioritization

    class LabelWhitespaceCollisionHandling(enum.IntEnum):
        TreatWhitespaceAsCollision = ... # type: Qgis.LabelWhitespaceCollisionHandling
        IgnoreWhitespaceCollisions = ... # type: Qgis.LabelWhitespaceCollisionHandling

    class LabelOverlapHandling(enum.IntEnum):
        PreventOverlap = ... # type: Qgis.LabelOverlapHandling
        AllowOverlapIfRequired = ... # type: Qgis.LabelOverlapHandling
        AllowOverlapAtNoCost = ... # type: Qgis.LabelOverlapHandling

    class UnplacedLabelVisibility(enum.IntEnum):
        FollowEngineSetting = ... # type: Qgis.UnplacedLabelVisibility
        NeverShow = ... # type: Qgis.UnplacedLabelVisibility

    class ActionStart(enum.IntEnum):
        Deferred = ... # type: Qgis.ActionStart
        Immediate = ... # type: Qgis.ActionStart

    class DriveType(enum.IntEnum):
        Unknown = ... # type: Qgis.DriveType
        Invalid = ... # type: Qgis.DriveType
        Removable = ... # type: Qgis.DriveType
        Fixed = ... # type: Qgis.DriveType
        Remote = ... # type: Qgis.DriveType
        CdRom = ... # type: Qgis.DriveType
        RamDisk = ... # type: Qgis.DriveType
        Cloud = ... # type: Qgis.DriveType

    class SqlKeywordCategory(enum.IntEnum):
        Keyword = ... # type: Qgis.SqlKeywordCategory
        Constant = ... # type: Qgis.SqlKeywordCategory
        Function = ... # type: Qgis.SqlKeywordCategory
        Geospatial = ... # type: Qgis.SqlKeywordCategory
        Operator = ... # type: Qgis.SqlKeywordCategory
        Math = ... # type: Qgis.SqlKeywordCategory
        Aggregate = ... # type: Qgis.SqlKeywordCategory
        String = ... # type: Qgis.SqlKeywordCategory
        Identifier = ... # type: Qgis.SqlKeywordCategory

    class SqlLayerDefinitionCapability(enum.IntFlag):
        SubsetStringFilter = ... # type: Qgis.SqlLayerDefinitionCapability
        GeometryColumn = ... # type: Qgis.SqlLayerDefinitionCapability
        PrimaryKeys = ... # type: Qgis.SqlLayerDefinitionCapability
        UnstableFeatureIds = ... # type: Qgis.SqlLayerDefinitionCapability

    class VectorFileWriterCapability(enum.IntFlag):
        FieldAliases = ... # type: Qgis.VectorFileWriterCapability
        FieldComments = ... # type: Qgis.VectorFileWriterCapability

    class VectorExportResult(enum.IntEnum):
        Success = ... # type: Qgis.VectorExportResult
        ErrorCreatingDataSource = ... # type: Qgis.VectorExportResult
        ErrorCreatingLayer = ... # type: Qgis.VectorExportResult
        ErrorAttributeTypeUnsupported = ... # type: Qgis.VectorExportResult
        ErrorAttributeCreationFailed = ... # type: Qgis.VectorExportResult
        ErrorProjectingFeatures = ... # type: Qgis.VectorExportResult
        ErrorFeatureWriteFailed = ... # type: Qgis.VectorExportResult
        ErrorInvalidLayer = ... # type: Qgis.VectorExportResult
        ErrorInvalidProvider = ... # type: Qgis.VectorExportResult
        ErrorProviderUnsupportedFeature = ... # type: Qgis.VectorExportResult
        ErrorConnectionFailed = ... # type: Qgis.VectorExportResult
        UserCanceled = ... # type: Qgis.VectorExportResult

    class HttpMethod(enum.IntEnum):
        Get = ... # type: Qgis.HttpMethod
        Post = ... # type: Qgis.HttpMethod
        Head = ... # type: Qgis.HttpMethod
        Put = ... # type: Qgis.HttpMethod
        Delete = ... # type: Qgis.HttpMethod

    class BrowserDirectoryMonitoring(enum.IntEnum):
        Default = ... # type: Qgis.BrowserDirectoryMonitoring
        NeverMonitor = ... # type: Qgis.BrowserDirectoryMonitoring
        AlwaysMonitor = ... # type: Qgis.BrowserDirectoryMonitoring

    class BrowserLayerType(enum.IntEnum):
        NoType = ... # type: Qgis.BrowserLayerType
        Vector = ... # type: Qgis.BrowserLayerType
        Raster = ... # type: Qgis.BrowserLayerType
        Point = ... # type: Qgis.BrowserLayerType
        Line = ... # type: Qgis.BrowserLayerType
        Polygon = ... # type: Qgis.BrowserLayerType
        TableLayer = ... # type: Qgis.BrowserLayerType
        Database = ... # type: Qgis.BrowserLayerType
        Table = ... # type: Qgis.BrowserLayerType
        Plugin = ... # type: Qgis.BrowserLayerType
        Mesh = ... # type: Qgis.BrowserLayerType
        VectorTile = ... # type: Qgis.BrowserLayerType
        PointCloud = ... # type: Qgis.BrowserLayerType
        TiledScene = ... # type: Qgis.BrowserLayerType

    class DataItemProviderCapability(enum.IntFlag):
        NoCapabilities = ... # type: Qgis.DataItemProviderCapability
        Files = ... # type: Qgis.DataItemProviderCapability
        Directories = ... # type: Qgis.DataItemProviderCapability
        Databases = ... # type: Qgis.DataItemProviderCapability
        NetworkSources = ... # type: Qgis.DataItemProviderCapability

    class BrowserItemCapability(enum.IntFlag):
        NoCapabilities = ... # type: Qgis.BrowserItemCapability
        SetCrs = ... # type: Qgis.BrowserItemCapability
        Fertile = ... # type: Qgis.BrowserItemCapability
        Fast = ... # type: Qgis.BrowserItemCapability
        Collapse = ... # type: Qgis.BrowserItemCapability
        Rename = ... # type: Qgis.BrowserItemCapability
        Delete = ... # type: Qgis.BrowserItemCapability
        ItemRepresentsFile = ... # type: Qgis.BrowserItemCapability
        RefreshChildrenWhenItemIsRefreshed = ... # type: Qgis.BrowserItemCapability
        ReadOnly = ... # type: Qgis.BrowserItemCapability

    class BrowserItemState(enum.IntEnum):
        NotPopulated = ... # type: Qgis.BrowserItemState
        Populating = ... # type: Qgis.BrowserItemState
        Populated = ... # type: Qgis.BrowserItemState

    class BrowserItemType(enum.IntEnum):
        Collection = ... # type: Qgis.BrowserItemType
        Directory = ... # type: Qgis.BrowserItemType
        Layer = ... # type: Qgis.BrowserItemType
        Error = ... # type: Qgis.BrowserItemType
        Favorites = ... # type: Qgis.BrowserItemType
        Project = ... # type: Qgis.BrowserItemType
        Custom = ... # type: Qgis.BrowserItemType
        Fields = ... # type: Qgis.BrowserItemType
        Field = ... # type: Qgis.BrowserItemType

    class SymbolLayerUserFlag(enum.IntFlag):
        DisableSelectionRecoloring = ... # type: Qgis.SymbolLayerUserFlag

    class SymbolLayerFlag(enum.IntFlag):
        DisableFeatureClipping = ... # type: Qgis.SymbolLayerFlag
        CanCalculateMaskGeometryPerFeature = ... # type: Qgis.SymbolLayerFlag
        AffectsLabeling = ... # type: Qgis.SymbolLayerFlag

    class SymbolPreviewFlag(enum.IntFlag):
        FlagIncludeCrosshairsForMarkerSymbols = ... # type: Qgis.SymbolPreviewFlag

    class SymbolFlag(enum.IntFlag):
        RendererShouldUseSymbolLevels = ... # type: Qgis.SymbolFlag
        AffectsLabeling = ... # type: Qgis.SymbolFlag

    class FeatureRendererFlag(enum.IntFlag):
        AffectsLabeling = ... # type: Qgis.FeatureRendererFlag

    class VerticalAnchorPoint(enum.IntEnum):
        Top = ... # type: Qgis.VerticalAnchorPoint
        Center = ... # type: Qgis.VerticalAnchorPoint
        Bottom = ... # type: Qgis.VerticalAnchorPoint
        Baseline = ... # type: Qgis.VerticalAnchorPoint

    class HorizontalAnchorPoint(enum.IntEnum):
        Left = ... # type: Qgis.HorizontalAnchorPoint
        Center = ... # type: Qgis.HorizontalAnchorPoint
        Right = ... # type: Qgis.HorizontalAnchorPoint

    class SymbolRotationMode(enum.IntEnum):
        RespectMapRotation = ... # type: Qgis.SymbolRotationMode
        IgnoreMapRotation = ... # type: Qgis.SymbolRotationMode

    class SymbolRenderHint(enum.IntFlag):
        DynamicRotation = ... # type: Qgis.SymbolRenderHint
        IsSymbolLayerSubSymbol = ... # type: Qgis.SymbolRenderHint
        ForceVectorRendering = ... # type: Qgis.SymbolRenderHint
        ExcludeSymbolBuffers = ... # type: Qgis.SymbolRenderHint

    class SnappingType(enum.IntFlag):
        NoSnap = ... # type: Qgis.SnappingType
        Vertex = ... # type: Qgis.SnappingType
        Segment = ... # type: Qgis.SnappingType
        Area = ... # type: Qgis.SnappingType
        Centroid = ... # type: Qgis.SnappingType
        MiddleOfSegment = ... # type: Qgis.SnappingType
        LineEndpoint = ... # type: Qgis.SnappingType

    class SnappingMode(enum.IntEnum):
        ActiveLayer = ... # type: Qgis.SnappingMode
        AllLayers = ... # type: Qgis.SnappingMode
        AdvancedConfiguration = ... # type: Qgis.SnappingMode

    class SettingsOption(enum.IntFlag):
        SaveFormerValue = ... # type: Qgis.SettingsOption
        SaveEnumFlagAsInt = ... # type: Qgis.SettingsOption

    class SldExportVendorExtension(enum.IntFlag):
        NoVendorExtension = ... # type: Qgis.SldExportVendorExtension
        GeoServerVendorExtension = ... # type: Qgis.SldExportVendorExtension
        DeegreeVendorExtension = ... # type: Qgis.SldExportVendorExtension

    class SldExportOption(enum.IntFlag):
        NoOptions = ... # type: Qgis.SldExportOption
        Svg = ... # type: Qgis.SldExportOption
        Png = ... # type: Qgis.SldExportOption

    class PropertyType(enum.IntEnum):
        Invalid = ... # type: Qgis.PropertyType
        Static = ... # type: Qgis.PropertyType
        Field = ... # type: Qgis.PropertyType
        Expression = ... # type: Qgis.PropertyType

    class SettingsTreeNodeOption(enum.IntFlag):
        NamedListSelectedItemSetting = ... # type: Qgis.SettingsTreeNodeOption

    class SettingsTreeNodeType(enum.Enum):
        Root = ... # type: Qgis.SettingsTreeNodeType
        Standard = ... # type: Qgis.SettingsTreeNodeType
        NamedList = ... # type: Qgis.SettingsTreeNodeType

    class SettingsType(enum.IntEnum):
        Custom = ... # type: Qgis.SettingsType
        Variant = ... # type: Qgis.SettingsType
        String = ... # type: Qgis.SettingsType
        StringList = ... # type: Qgis.SettingsType
        VariantMap = ... # type: Qgis.SettingsType
        Bool = ... # type: Qgis.SettingsType
        Integer = ... # type: Qgis.SettingsType
        Double = ... # type: Qgis.SettingsType
        EnumFlag = ... # type: Qgis.SettingsType
        Color = ... # type: Qgis.SettingsType

    class ScaleMethod(enum.IntEnum):
        ScaleArea = ... # type: Qgis.ScaleMethod
        ScaleDiameter = ... # type: Qgis.ScaleMethod

    class SymbolType(enum.IntEnum):
        Marker = ... # type: Qgis.SymbolType
        Line = ... # type: Qgis.SymbolType
        Fill = ... # type: Qgis.SymbolType
        Hybrid = ... # type: Qgis.SymbolType

    class VectorDataProviderAttributeEditCapability(enum.IntFlag):
        EditAlias = ... # type: Qgis.VectorDataProviderAttributeEditCapability
        EditComment = ... # type: Qgis.VectorDataProviderAttributeEditCapability

    class FeatureAvailability(enum.IntEnum):
        NoFeaturesAvailable = ... # type: Qgis.FeatureAvailability
        FeaturesAvailable = ... # type: Qgis.FeatureAvailability
        FeaturesMaybeAvailable = ... # type: Qgis.FeatureAvailability

    class SpatialIndexPresence(enum.IntEnum):
        Unknown = ... # type: Qgis.SpatialIndexPresence
        NotPresent = ... # type: Qgis.SpatialIndexPresence
        Present = ... # type: Qgis.SpatialIndexPresence

    class FeatureCountState(enum.IntEnum):
        Uncounted = ... # type: Qgis.FeatureCountState
        UnknownCount = ... # type: Qgis.FeatureCountState

    class VectorProviderCapability(enum.IntFlag):
        NoCapabilities = ... # type: Qgis.VectorProviderCapability
        AddFeatures = ... # type: Qgis.VectorProviderCapability
        DeleteFeatures = ... # type: Qgis.VectorProviderCapability
        ChangeAttributeValues = ... # type: Qgis.VectorProviderCapability
        AddAttributes = ... # type: Qgis.VectorProviderCapability
        DeleteAttributes = ... # type: Qgis.VectorProviderCapability
        CreateSpatialIndex = ... # type: Qgis.VectorProviderCapability
        SelectAtId = ... # type: Qgis.VectorProviderCapability
        ChangeGeometries = ... # type: Qgis.VectorProviderCapability
        SelectEncoding = ... # type: Qgis.VectorProviderCapability
        CreateAttributeIndex = ... # type: Qgis.VectorProviderCapability
        SimplifyGeometries = ... # type: Qgis.VectorProviderCapability
        SimplifyGeometriesWithTopologicalValidation = ... # type: Qgis.VectorProviderCapability
        TransactionSupport = ... # type: Qgis.VectorProviderCapability
        CircularGeometries = ... # type: Qgis.VectorProviderCapability
        ChangeFeatures = ... # type: Qgis.VectorProviderCapability
        RenameAttributes = ... # type: Qgis.VectorProviderCapability
        FastTruncate = ... # type: Qgis.VectorProviderCapability
        ReadLayerMetadata = ... # type: Qgis.VectorProviderCapability
        WriteLayerMetadata = ... # type: Qgis.VectorProviderCapability
        CancelSupport = ... # type: Qgis.VectorProviderCapability
        CreateRenderer = ... # type: Qgis.VectorProviderCapability
        CreateLabeling = ... # type: Qgis.VectorProviderCapability
        ReloadData = ... # type: Qgis.VectorProviderCapability
        FeatureSymbology = ... # type: Qgis.VectorProviderCapability
        EditingCapabilities = ... # type: Qgis.VectorProviderCapability

    class DataProviderReadFlag(enum.IntFlag):
        TrustDataSource = ... # type: Qgis.DataProviderReadFlag
        SkipFeatureCount = ... # type: Qgis.DataProviderReadFlag
        LoadDefaultStyle = ... # type: Qgis.DataProviderReadFlag
        SkipGetExtent = ... # type: Qgis.DataProviderReadFlag
        SkipFullScan = ... # type: Qgis.DataProviderReadFlag
        ForceReadOnly = ... # type: Qgis.DataProviderReadFlag
        SkipCredentialsRequest = ... # type: Qgis.DataProviderReadFlag
        ParallelThreadLoading = ... # type: Qgis.DataProviderReadFlag

    class ProjectTrustStatus(enum.IntEnum):
        Undetermined = ... # type: Qgis.ProjectTrustStatus
        Trusted = ... # type: Qgis.ProjectTrustStatus
        Untrusted = ... # type: Qgis.ProjectTrustStatus

    class EmbeddedScriptType(enum.IntEnum):
        Macro = ... # type: Qgis.EmbeddedScriptType
        ExpressionFunction = ... # type: Qgis.EmbeddedScriptType
        Action = ... # type: Qgis.EmbeddedScriptType
        FormInitCode = ... # type: Qgis.EmbeddedScriptType

    class EmbeddedScriptMode(enum.IntEnum):
        Never = ... # type: Qgis.EmbeddedScriptMode
        Ask = ... # type: Qgis.EmbeddedScriptMode
        SessionOnly = ... # type: Qgis.EmbeddedScriptMode
        Always = ... # type: Qgis.EmbeddedScriptMode
        NotForThisSession = ... # type: Qgis.EmbeddedScriptMode
        NeverAsk = ... # type: Qgis.EmbeddedScriptMode

    class VectorLayerTypeFlag(enum.IntFlag):
        SqlQuery = ... # type: Qgis.VectorLayerTypeFlag

    class CaptureTechnique(enum.IntEnum):
        StraightSegments = ... # type: Qgis.CaptureTechnique
        CircularString = ... # type: Qgis.CaptureTechnique
        Streaming = ... # type: Qgis.CaptureTechnique
        Shape = ... # type: Qgis.CaptureTechnique
        PolyBezier = ... # type: Qgis.CaptureTechnique
        NurbsCurve = ... # type: Qgis.CaptureTechnique

    class DataType(enum.IntEnum):
        UnknownDataType = ... # type: Qgis.DataType
        Byte = ... # type: Qgis.DataType
        Int8 = ... # type: Qgis.DataType
        UInt16 = ... # type: Qgis.DataType
        Int16 = ... # type: Qgis.DataType
        UInt32 = ... # type: Qgis.DataType
        Int32 = ... # type: Qgis.DataType
        Float32 = ... # type: Qgis.DataType
        Float64 = ... # type: Qgis.DataType
        CInt16 = ... # type: Qgis.DataType
        CInt32 = ... # type: Qgis.DataType
        CFloat32 = ... # type: Qgis.DataType
        CFloat64 = ... # type: Qgis.DataType
        ARGB32 = ... # type: Qgis.DataType
        ARGB32_Premultiplied = ... # type: Qgis.DataType

    class GeometryType(enum.IntEnum):
        Point = ... # type: Qgis.GeometryType
        Line = ... # type: Qgis.GeometryType
        Polygon = ... # type: Qgis.GeometryType
        Unknown = ... # type: Qgis.GeometryType
        Null = ... # type: Qgis.GeometryType

    class WkbType(enum.IntEnum):
        Unknown = ... # type: Qgis.WkbType
        Point = ... # type: Qgis.WkbType
        LineString = ... # type: Qgis.WkbType
        Polygon = ... # type: Qgis.WkbType
        Triangle = ... # type: Qgis.WkbType
        MultiPoint = ... # type: Qgis.WkbType
        MultiLineString = ... # type: Qgis.WkbType
        MultiPolygon = ... # type: Qgis.WkbType
        GeometryCollection = ... # type: Qgis.WkbType
        CircularString = ... # type: Qgis.WkbType
        CompoundCurve = ... # type: Qgis.WkbType
        CurvePolygon = ... # type: Qgis.WkbType
        MultiCurve = ... # type: Qgis.WkbType
        MultiSurface = ... # type: Qgis.WkbType
        PolyhedralSurface = ... # type: Qgis.WkbType
        TIN = ... # type: Qgis.WkbType
        NurbsCurve = ... # type: Qgis.WkbType
        NoGeometry = ... # type: Qgis.WkbType
        PointZ = ... # type: Qgis.WkbType
        LineStringZ = ... # type: Qgis.WkbType
        PolygonZ = ... # type: Qgis.WkbType
        TriangleZ = ... # type: Qgis.WkbType
        MultiPointZ = ... # type: Qgis.WkbType
        MultiLineStringZ = ... # type: Qgis.WkbType
        MultiPolygonZ = ... # type: Qgis.WkbType
        GeometryCollectionZ = ... # type: Qgis.WkbType
        CircularStringZ = ... # type: Qgis.WkbType
        CompoundCurveZ = ... # type: Qgis.WkbType
        CurvePolygonZ = ... # type: Qgis.WkbType
        MultiCurveZ = ... # type: Qgis.WkbType
        MultiSurfaceZ = ... # type: Qgis.WkbType
        PolyhedralSurfaceZ = ... # type: Qgis.WkbType
        TINZ = ... # type: Qgis.WkbType
        NurbsCurveZ = ... # type: Qgis.WkbType
        PointM = ... # type: Qgis.WkbType
        LineStringM = ... # type: Qgis.WkbType
        PolygonM = ... # type: Qgis.WkbType
        TriangleM = ... # type: Qgis.WkbType
        MultiPointM = ... # type: Qgis.WkbType
        MultiLineStringM = ... # type: Qgis.WkbType
        MultiPolygonM = ... # type: Qgis.WkbType
        GeometryCollectionM = ... # type: Qgis.WkbType
        CircularStringM = ... # type: Qgis.WkbType
        CompoundCurveM = ... # type: Qgis.WkbType
        CurvePolygonM = ... # type: Qgis.WkbType
        MultiCurveM = ... # type: Qgis.WkbType
        MultiSurfaceM = ... # type: Qgis.WkbType
        PolyhedralSurfaceM = ... # type: Qgis.WkbType
        TINM = ... # type: Qgis.WkbType
        NurbsCurveM = ... # type: Qgis.WkbType
        PointZM = ... # type: Qgis.WkbType
        LineStringZM = ... # type: Qgis.WkbType
        PolygonZM = ... # type: Qgis.WkbType
        MultiPointZM = ... # type: Qgis.WkbType
        MultiLineStringZM = ... # type: Qgis.WkbType
        MultiPolygonZM = ... # type: Qgis.WkbType
        GeometryCollectionZM = ... # type: Qgis.WkbType
        CircularStringZM = ... # type: Qgis.WkbType
        CompoundCurveZM = ... # type: Qgis.WkbType
        CurvePolygonZM = ... # type: Qgis.WkbType
        MultiCurveZM = ... # type: Qgis.WkbType
        MultiSurfaceZM = ... # type: Qgis.WkbType
        PolyhedralSurfaceZM = ... # type: Qgis.WkbType
        TINZM = ... # type: Qgis.WkbType
        TriangleZM = ... # type: Qgis.WkbType
        NurbsCurveZM = ... # type: Qgis.WkbType
        Point25D = ... # type: Qgis.WkbType
        LineString25D = ... # type: Qgis.WkbType
        Polygon25D = ... # type: Qgis.WkbType
        MultiPoint25D = ... # type: Qgis.WkbType
        MultiLineString25D = ... # type: Qgis.WkbType
        MultiPolygon25D = ... # type: Qgis.WkbType

    class LoadStyleFlag(enum.IntFlag):
        IgnoreMissingStyleErrors = ... # type: Qgis.LoadStyleFlag

    class LayerFilter(enum.IntFlag):
        RasterLayer = ... # type: Qgis.LayerFilter
        NoGeometry = ... # type: Qgis.LayerFilter
        PointLayer = ... # type: Qgis.LayerFilter
        LineLayer = ... # type: Qgis.LayerFilter
        PolygonLayer = ... # type: Qgis.LayerFilter
        HasGeometry = ... # type: Qgis.LayerFilter
        VectorLayer = ... # type: Qgis.LayerFilter
        PluginLayer = ... # type: Qgis.LayerFilter
        WritableLayer = ... # type: Qgis.LayerFilter
        MeshLayer = ... # type: Qgis.LayerFilter
        VectorTileLayer = ... # type: Qgis.LayerFilter
        PointCloudLayer = ... # type: Qgis.LayerFilter
        AnnotationLayer = ... # type: Qgis.LayerFilter
        TiledSceneLayer = ... # type: Qgis.LayerFilter
        All = ... # type: Qgis.LayerFilter
        SpatialLayer = ... # type: Qgis.LayerFilter

    class LayerType(enum.IntEnum):
        Vector = ... # type: Qgis.LayerType
        Raster = ... # type: Qgis.LayerType
        Plugin = ... # type: Qgis.LayerType
        Mesh = ... # type: Qgis.LayerType
        VectorTile = ... # type: Qgis.LayerType
        Annotation = ... # type: Qgis.LayerType
        PointCloud = ... # type: Qgis.LayerType
        Group = ... # type: Qgis.LayerType
        TiledScene = ... # type: Qgis.LayerType

    class NetworkRequestFlag(enum.IntFlag):
        DisableMessageLogging = ... # type: Qgis.NetworkRequestFlag

    class StringFormat(enum.IntEnum):
        PlainText = ... # type: Qgis.StringFormat
        Html = ... # type: Qgis.StringFormat

    class MessageLevel(enum.IntEnum):
        Info = ... # type: Qgis.MessageLevel
        Warning = ... # type: Qgis.MessageLevel
        Critical = ... # type: Qgis.MessageLevel
        Success = ... # type: Qgis.MessageLevel
        NoLevel = ... # type: Qgis.MessageLevel

    class AuthConfigurationStorageCapability(enum.IntFlag):
        ClearStorage = ... # type: Qgis.AuthConfigurationStorageCapability
        ReadConfiguration = ... # type: Qgis.AuthConfigurationStorageCapability
        UpdateConfiguration = ... # type: Qgis.AuthConfigurationStorageCapability
        DeleteConfiguration = ... # type: Qgis.AuthConfigurationStorageCapability
        CreateConfiguration = ... # type: Qgis.AuthConfigurationStorageCapability
        ReadCertificateIdentity = ... # type: Qgis.AuthConfigurationStorageCapability
        UpdateCertificateIdentity = ... # type: Qgis.AuthConfigurationStorageCapability
        DeleteCertificateIdentity = ... # type: Qgis.AuthConfigurationStorageCapability
        CreateCertificateIdentity = ... # type: Qgis.AuthConfigurationStorageCapability
        ReadSslCertificateCustomConfig = ... # type: Qgis.AuthConfigurationStorageCapability
        UpdateSslCertificateCustomConfig = ... # type: Qgis.AuthConfigurationStorageCapability
        DeleteSslCertificateCustomConfig = ... # type: Qgis.AuthConfigurationStorageCapability
        CreateSslCertificateCustomConfig = ... # type: Qgis.AuthConfigurationStorageCapability
        ReadCertificateAuthority = ... # type: Qgis.AuthConfigurationStorageCapability
        UpdateCertificateAuthority = ... # type: Qgis.AuthConfigurationStorageCapability
        DeleteCertificateAuthority = ... # type: Qgis.AuthConfigurationStorageCapability
        CreateCertificateAuthority = ... # type: Qgis.AuthConfigurationStorageCapability
        ReadCertificateTrustPolicy = ... # type: Qgis.AuthConfigurationStorageCapability
        UpdateCertificateTrustPolicy = ... # type: Qgis.AuthConfigurationStorageCapability
        DeleteCertificateTrustPolicy = ... # type: Qgis.AuthConfigurationStorageCapability
        CreateCertificateTrustPolicy = ... # type: Qgis.AuthConfigurationStorageCapability
        ReadMasterPassword = ... # type: Qgis.AuthConfigurationStorageCapability
        UpdateMasterPassword = ... # type: Qgis.AuthConfigurationStorageCapability
        DeleteMasterPassword = ... # type: Qgis.AuthConfigurationStorageCapability
        CreateMasterPassword = ... # type: Qgis.AuthConfigurationStorageCapability
        ReadSetting = ... # type: Qgis.AuthConfigurationStorageCapability
        UpdateSetting = ... # type: Qgis.AuthConfigurationStorageCapability
        DeleteSetting = ... # type: Qgis.AuthConfigurationStorageCapability
        CreateSetting = ... # type: Qgis.AuthConfigurationStorageCapability

    DEFAULT_HIGHLIGHT_BUFFER_MM = ... # type: float
    DEFAULT_HIGHLIGHT_COLOR = ... # type: QtGui.QColor|QtCore.Qt.GlobalColor|int
    DEFAULT_HIGHLIGHT_MIN_WIDTH_MM = ... # type: float
    DEFAULT_LINE_WIDTH = ... # type: float
    DEFAULT_MAPTOPIXEL_THRESHOLD = ... # type: float
    DEFAULT_M_COORDINATE = ... # type: float
    DEFAULT_POINT_SIZE = ... # type: float
    DEFAULT_SEARCH_RADIUS_MM = ... # type: float
    DEFAULT_SEGMENT_EPSILON = ... # type: float
    DEFAULT_SNAP_TOLERANCE = ... # type: float
    DEFAULT_SNAP_UNITS = ... # type: 'Qgis.MapToolUnit'
    DEFAULT_Z_COORDINATE = ... # type: float
    QGIS_DEV_VERSION = ... # type: str
    SCALE_PRECISION = ... # type: float
    UI_SCALE_FACTOR = ... # type: float
    USER_CRS_START_ID = ... # type: int
    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'Qgis') -> None: ...

    @staticmethod
    def geoProj4() -> str: ...
    @staticmethod
    def geoWkt() -> str: ...
    @staticmethod
    def geographicCrsAuthId() -> str: ...
    @staticmethod
    def geoNone() -> str: ...
    @staticmethod
    def hasQtWebkit() -> bool: ...
    @staticmethod
    def geographicLibVersion() -> int: ...
    @staticmethod
    def hasGeographicLib() -> bool: ...
    @staticmethod
    def sfcgalVersionInt() -> int: ...
    @staticmethod
    def hasSfcgal() -> bool: ...
    @staticmethod
    def geosVersion() -> str: ...
    @staticmethod
    def geosVersionPatch() -> int: ...
    @staticmethod
    def geosVersionMinor() -> int: ...
    @staticmethod
    def geosVersionMajor() -> int: ...
    @staticmethod
    def geosVersionInt() -> int: ...
    @staticmethod
    def defaultProjectScales() -> str: ...
    @staticmethod
    def devVersion() -> str: ...
    @staticmethod
    def releaseName() -> str: ...
    @staticmethod
    def versionInt() -> int: ...
    @staticmethod
    def version() -> str: ...


class QgsAbstractContentCacheEntry(PyQt6.sip.wrapper):

    fileModified = ... # type: QtCore.QDateTime|datetime.datetime
    fileModifiedLastCheckTimer = ... # type: QtCore.QElapsedTimer
    mFileModifiedCheckTimeout = ... # type: int
    nextEntry = ... # type: 'QgsAbstractContentCacheEntry'
    path = ... # type: str|None
    previousEntry = ... # type: 'QgsAbstractContentCacheEntry'

    def __init__(self, path: str|None) -> None: ...

    def __ne__(self, other: object): ...
    def isEqual(self, other: 'QgsAbstractContentCacheEntry|None') -> bool: ...
    def dump(self) -> None: ...
    def dataSize(self) -> int: ...
    def __eq__(self, other: object): ...


class QgsAbstractContentCacheBase(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None) -> None: ...

    def onRemoteContentFetched(self, url: str|None, success: bool) -> None: ...
    def checkReply(self, reply: QtNetwork.QNetworkReply|None, path: str|None) -> bool: ...
    remoteContentFetched: typing.ClassVar[QtCore.pyqtSignal]
    def invalidateCacheEntry(self, path: str|None) -> bool: ...
    @staticmethod
    def isBase64Data(path: str|None) -> bool: ...
    @staticmethod
    def parseEmbeddedStringData(path: str|None) -> typing.Tuple[bool, str, str]: ...
    @staticmethod
    def parseBase64DataUrl(path: str|None) -> typing.Tuple[bool, str, str]: ...


class QgsAggregateCalculator(PyQt6.sip.wrapper):

    class AggregateInfo(PyQt6.sip.wrapper):

        function = ... # type: str|None
        name = ... # type: str|None
        supportedTypes = ... # type: collections.abc.Iterable[QtCore.QMetaType.Type]

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAggregateCalculator.AggregateInfo') -> None: ...

    class AggregateParameters(PyQt6.sip.wrapper):

        delimiter = ... # type: str|None
        filter = ... # type: str|None
        orderBy = ... # type: 'QgsFeatureRequest.OrderBy'

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAggregateCalculator.AggregateParameters') -> None: ...

    @typing.overload
    def __init__(self, layer: 'QgsVectorLayer|None') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAggregateCalculator') -> None: ...

    @staticmethod
    def aggregates() -> list['QgsAggregateCalculator.AggregateInfo']: ...
    @staticmethod
    def displayName(aggregate: Qgis.Aggregate) -> str: ...
    @staticmethod
    def stringToAggregate(string: str|None) -> typing.Tuple[Qgis.Aggregate, bool]: ...
    def calculate(self, aggregate: Qgis.Aggregate, fieldOrExpression: str|None, context: 'QgsExpressionContext|None' = ..., feedback: 'QgsFeedback|None' = ...) -> typing.Tuple[typing.Any, bool]: ...
    def delimiter(self) -> str: ...
    def setDelimiter(self, delimiter: str|None) -> None: ...
    def filter(self) -> str: ...
    def setFidsFilter(self, fids: typing.Any) -> None: ...
    def setFilter(self, filterExpression: str|None) -> None: ...
    def setParameters(self, parameters: 'QgsAggregateCalculator.AggregateParameters') -> None: ...
    def layer(self) -> 'QgsVectorLayer|None': ...
    def lastError(self) -> str: ...


class QgsAlignRasterData(PyQt6.sip.wrapper):

    class RasterItem(PyQt6.sip.wrapper):

        inputFilename = ... # type: str|None
        outputFilename = ... # type: str|None
        resampleMethod = ... # type: Qgis.GdalResampleAlgorithm
        rescaleValues = ... # type: bool
        srcCellSizeInDestCRS = ... # type: float

        @typing.overload
        def __init__(self, input: str|None, output: str|None) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAlignRasterData.RasterItem') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAlignRasterData') -> None: ...


class QgsAnimatedIcon(QtCore.QObject):

    def __init__(self, iconPath: str|None = ..., parent: QtCore.QObject|None = ...) -> None: ...

    frameChanged: typing.ClassVar[QtCore.pyqtSignal]
    def height(self) -> int: ...
    def width(self) -> int: ...
    def disconnectFrameChanged(self, receiver: QtCore.QObject|None, method: str) -> bool: ...
    def connectFrameChanged(self, receiver: QtCore.QObject|None, method: str) -> bool: ...
    def icon(self) -> QtGui.QIcon: ...
    def setIconPath(self, iconPath: str|None) -> None: ...
    def iconPath(self) -> str: ...


class QgsApplication(QtWidgets.QApplication):

    class endian_t(enum.IntEnum):
        XDR = ... # type: QgsApplication.endian_t
        NDR = ... # type: QgsApplication.endian_t

    class Cursor(enum.IntEnum):
        ZoomIn = ... # type: QgsApplication.Cursor
        ZoomOut = ... # type: QgsApplication.Cursor
        Identify = ... # type: QgsApplication.Cursor
        CrossHair = ... # type: QgsApplication.Cursor
        CapturePoint = ... # type: QgsApplication.Cursor
        Select = ... # type: QgsApplication.Cursor
        Sampler = ... # type: QgsApplication.Cursor

    class StyleSheetType(enum.IntEnum):
        Qt = ... # type: QgsApplication.StyleSheetType
        WebBrowser = ... # type: QgsApplication.StyleSheetType

    QGIS_APPLICATION_NAME = ... # type: str
    QGIS_ORGANIZATION_DOMAIN = ... # type: str
    QGIS_ORGANIZATION_NAME = ... # type: str

    def __init__(self, argv: list, GUIenabled: bool, profileFolder: str|None = ..., platformName: str|None = ...) -> None: ...

    themeChanged: typing.ClassVar[QtCore.pyqtSignal]
    localeChanged: typing.ClassVar[QtCore.pyqtSignal]
    requestForTranslatableObjects: typing.ClassVar[QtCore.pyqtSignal]
    nullRepresentationChanged: typing.ClassVar[QtCore.pyqtSignal]
    customVariablesChanged: typing.ClassVar[QtCore.pyqtSignal]
    def collectTranslatableObjects(self, translationContext: 'QgsTranslationContext|None') -> None: ...
    def translation(self) -> str: ...
    @staticmethod
    def setTranslation(translation: str|None) -> None: ...
    def maxConcurrentConnectionsPerPool(self) -> int: ...
    @staticmethod
    def scaleIconSize(standardSize: int, applyDevicePixelRatio: bool = ...) -> int: ...
    @staticmethod
    def setTemporarilyUntrustedProjectsFolders(untrustedProjectsFolders: collections.abc.Iterable[str|None]) -> None: ...
    @staticmethod
    def temporarilyUntrustedProjectsFolders() -> list[str]: ...
    @staticmethod
    def setTemporarilyTrustedProjectsFolders(trustedProjectsFolders: collections.abc.Iterable[str|None]) -> None: ...
    @staticmethod
    def temporarilyTrustedProjectsFolders() -> list[str]: ...
    @staticmethod
    def setCustomVariable(name: str|None, value: typing.Any) -> None: ...
    @staticmethod
    def setCustomVariables(customVariables: dict[str|None, typing.Any]) -> None: ...
    @staticmethod
    def customVariables() -> dict[str, typing.Any]: ...
    @staticmethod
    def setNullRepresentation(nullRepresentation: str|None) -> None: ...
    @staticmethod
    def nullRepresentation() -> str: ...
    @staticmethod
    def localizedDataPathRegistry() -> 'QgsLocalizedDataPathRegistry|None': ...
    @staticmethod
    def profileSourceRegistry() -> 'QgsProfileSourceRegistry|None': ...
    @staticmethod
    def externalStorageRegistry() -> 'QgsExternalStorageRegistry|None': ...
    @staticmethod
    def layerMetadataProviderRegistry() -> 'QgsLayerMetadataProviderRegistry|None': ...
    @staticmethod
    def projectStorageRegistry() -> 'QgsProjectStorageRegistry|None': ...
    @staticmethod
    def labelingEngineRuleRegistry() -> 'QgsLabelingEngineRuleRegistry|None': ...
    @staticmethod
    def scaleBarRendererRegistry() -> 'QgsScaleBarRendererRegistry|None': ...
    @staticmethod
    def symbol3DRegistry() -> 'Qgs3DSymbolRegistry|None': ...
    @staticmethod
    def renderer3DRegistry() -> 'Qgs3DRendererRegistry|None': ...
    @staticmethod
    def fieldFormatterRegistry() -> 'QgsFieldFormatterRegistry|None': ...
    @staticmethod
    def numericFormatRegistry() -> 'QgsNumericFormatRegistry|None': ...
    @staticmethod
    def profiler() -> 'QgsRuntimeProfiler|None': ...
    @staticmethod
    def connectionRegistry() -> 'QgsConnectionRegistry|None': ...
    @staticmethod
    def actionScopeRegistry() -> 'QgsActionScopeRegistry|None': ...
    @staticmethod
    def applicationThemeRegistry() -> 'QgsApplicationThemeRegistry|None': ...
    @staticmethod
    def pageSizeRegistry() -> 'QgsPageSizeRegistry|None': ...
    @staticmethod
    def processingRegistry() -> 'QgsProcessingRegistry|None': ...
    @staticmethod
    def authConfigurationStorageRegistry() -> 'QgsAuthConfigurationStorageRegistry|None': ...
    @staticmethod
    def authManager() -> 'QgsAuthManager|None': ...
    @staticmethod
    def messageLog() -> 'QgsMessageLog|None': ...
    @staticmethod
    def plotRegistry() -> 'QgsPlotRegistry|None': ...
    @staticmethod
    def sensorRegistry() -> 'QgsSensorRegistry|None': ...
    @staticmethod
    def fontManager() -> 'QgsFontManager|None': ...
    @staticmethod
    def defaultStyleModel() -> 'QgsStyleModel|None': ...
    @staticmethod
    def databaseQueryLog() -> 'QgsDatabaseQueryLog|None': ...
    @staticmethod
    def recentStyleHandler() -> 'QgsRecentStyleHandler|None': ...
    @staticmethod
    def bookmarkManager() -> 'QgsBookmarkManager|None': ...
    @staticmethod
    def classificationMethodRegistry() -> 'QgsClassificationMethodRegistry|None': ...
    @staticmethod
    def pluginLayerRegistry() -> 'QgsPluginLayerRegistry|None': ...
    @staticmethod
    def gpsBabelFormatRegistry() -> 'QgsBabelFormatRegistry|None': ...
    @staticmethod
    def gpsConnectionRegistry() -> 'QgsGpsConnectionRegistry|None': ...
    @staticmethod
    def annotationItemRegistry() -> 'QgsAnnotationItemRegistry|None': ...
    @staticmethod
    def layoutItemRegistry() -> 'QgsLayoutItemRegistry|None': ...
    @staticmethod
    def calloutRegistry() -> 'QgsCalloutRegistry|None': ...
    @staticmethod
    def symbolLayerRegistry() -> 'QgsSymbolLayerRegistry|None': ...
    @staticmethod
    def validityCheckRegistry() -> 'QgsValidityCheckRegistry|None': ...
    @staticmethod
    def networkContentFetcherRegistry() -> 'QgsNetworkContentFetcherRegistry|None': ...
    @staticmethod
    def sourceCache() -> 'QgsSourceCache|None': ...
    @staticmethod
    def imageCache() -> 'QgsImageCache|None': ...
    @staticmethod
    def svgCache() -> 'QgsSvgCache|None': ...
    @staticmethod
    def coordinateReferenceSystemRegistry() -> 'QgsCoordinateReferenceSystemRegistry|None': ...
    @staticmethod
    def dataItemProviderRegistry() -> 'QgsDataItemProviderRegistry|None': ...
    @staticmethod
    def tiledSceneRendererRegistry() -> 'QgsTiledSceneRendererRegistry|None': ...
    @staticmethod
    def pointCloudRendererRegistry() -> 'QgsPointCloudRendererRegistry|None': ...
    @staticmethod
    def rendererRegistry() -> 'QgsRendererRegistry|None': ...
    @staticmethod
    def paintEffectRegistry() -> 'QgsPaintEffectRegistry|None': ...
    @staticmethod
    def colorSchemeRegistry() -> 'QgsColorSchemeRegistry|None': ...
    @staticmethod
    @deprecated("""""")
    def settingsRegistryCore() -> 'QgsSettingsRegistryCore|None': ...
    @staticmethod
    def taskManager() -> 'QgsTaskManager|None': ...
    @staticmethod
    def setMaxThreads(maxThreads: int) -> None: ...
    @staticmethod
    def maxThreads() -> int: ...
    @staticmethod
    def setSkippedGdalDrivers(skippedGdalDrivers: collections.abc.Iterable[str|None], deferredSkippedGdalDrivers: collections.abc.Iterable[str|None]) -> None: ...
    @staticmethod
    def deferredSkippedGdalDrivers() -> list[str]: ...
    @staticmethod
    def registerGdalDriversFromSettings() -> None: ...
    @staticmethod
    def applyGdalSkippedDrivers() -> None: ...
    @staticmethod
    def skippedGdalDrivers() -> list[str]: ...
    @staticmethod
    def restoreGdalDriver(driver: str|None) -> None: ...
    @staticmethod
    def skipGdalDriver(driver: str|None) -> None: ...
    @staticmethod
    def buildOutputPath() -> str: ...
    @staticmethod
    def buildSourcePath() -> str: ...
    @staticmethod
    def isRunningFromBuildDir() -> bool: ...
    @staticmethod
    def relativePathToAbsolutePath(rpath: str|None, targetPath: str|None) -> str: ...
    @staticmethod
    def absolutePathToRelativePath(apath: str|None, targetPath: str|None) -> str: ...
    @staticmethod
    def registerOgrDrivers() -> None: ...
    @staticmethod
    def showSettings() -> str: ...
    @staticmethod
    def reportStyleSheet(styleSheetType: 'QgsApplication.StyleSheetType' = ...) -> str: ...
    @staticmethod
    def endian() -> 'QgsApplication.endian_t': ...
    @staticmethod
    def appIconPath() -> str: ...
    @staticmethod
    def exitQgis() -> None: ...
    @staticmethod
    def createThemeFolder() -> bool: ...
    @staticmethod
    def createDatabase(errorMessage: str|None = ...) -> bool: ...
    @staticmethod
    def initQgis() -> None: ...
    @staticmethod
    def setAuthDatabaseDirPath(authDbDirPath: str|None) -> None: ...
    @staticmethod
    def setDefaultSvgPaths(pathList: collections.abc.Iterable[str|None]) -> None: ...
    @staticmethod
    def setPkgDataPath(pkgDataPath: str|None) -> None: ...
    @staticmethod
    def setPluginPath(pluginPath: str|None) -> None: ...
    @staticmethod
    def setPrefixPath(prefixPath: str|None, useDefaultPaths: bool = ...) -> None: ...
    @staticmethod
    def qmlImportPath() -> str: ...
    @staticmethod
    def libexecPath() -> str: ...
    @staticmethod
    def libraryPath() -> str: ...
    @staticmethod
    def defaultThemesFolder() -> str: ...
    @staticmethod
    def defaultStylePath() -> str: ...
    @staticmethod
    def userThemesFolder() -> str: ...
    @staticmethod
    def setLocale(locale: QtCore.QLocale) -> None: ...
    @staticmethod
    def locale() -> str: ...
    @staticmethod
    def applicationFullName() -> str: ...
    @staticmethod
    def platform() -> str: ...
    @staticmethod
    def systemMemorySizeMb() -> int: ...
    @staticmethod
    def osName() -> str: ...
    @staticmethod
    def userFullName() -> str: ...
    @staticmethod
    def userLoginName() -> str: ...
    @staticmethod
    def shortNameRegularExpression() -> QtCore.QRegularExpression: ...
    @staticmethod
    def userStylePath() -> str: ...
    @staticmethod
    def getThemePixmap(name: str|None, foreColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ..., backColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ..., size: int = ...) -> QtGui.QPixmap: ...
    @staticmethod
    def getThemeCursor(cursor: 'QgsApplication.Cursor') -> QtGui.QCursor: ...
    @staticmethod
    def getThemeIcon(name: str|None, fillColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ..., strokeColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> QtGui.QIcon: ...
    @staticmethod
    def iconPath(iconFile: str|None) -> str: ...
    @staticmethod
    def defaultThemePath() -> str: ...
    @staticmethod
    def activeThemePath() -> str: ...
    @staticmethod
    def pkgDataPath() -> str: ...
    @staticmethod
    def pluginPath() -> str: ...
    @staticmethod
    def prefixPath() -> str: ...
    @staticmethod
    def systemEnvVars() -> dict[str, str]: ...
    @staticmethod
    def layoutTemplatePaths() -> list[str]: ...
    @staticmethod
    def svgPaths() -> list[str]: ...
    @staticmethod
    def setSvgPaths(svgPaths: collections.abc.Iterable[str|None]) -> None: ...
    @staticmethod
    def srsDatabaseFilePath() -> str: ...
    @staticmethod
    def iconsPath() -> str: ...
    @staticmethod
    def splashPath() -> str: ...
    @staticmethod
    def qgisAuthDatabaseUri() -> str: ...
    @staticmethod
    @deprecated("""""")
    def qgisAuthDatabaseFilePath() -> str: ...
    @staticmethod
    def qgisUserDatabaseFilePath() -> str: ...
    @staticmethod
    def qgisSettingsDirPath() -> str: ...
    @staticmethod
    def qgisMasterDatabaseFilePath() -> str: ...
    @staticmethod
    def metadataPath() -> str: ...
    @staticmethod
    def i18nPath() -> str: ...
    @staticmethod
    def licenceFilePath() -> str: ...
    @staticmethod
    def translatorsFilePath() -> str: ...
    @staticmethod
    def serverResourcesPath() -> str: ...
    @staticmethod
    def donorsFilePath() -> str: ...
    @staticmethod
    def sponsorsFilePath() -> str: ...
    @staticmethod
    def contributorsFilePath() -> str: ...
    @staticmethod
    def authorsFilePath() -> str: ...
    @staticmethod
    def uiThemes() -> dict[str, str]: ...
    @staticmethod
    def setUITheme(themeName: str|None) -> None: ...
    @staticmethod
    def themeName() -> str: ...
    @staticmethod
    def resolvePkgPath() -> str: ...
    @staticmethod
    def setThemeName(themeName: str|None) -> None: ...
    @staticmethod
    def setFileOpenEventReceiver(receiver: QtCore.QObject|None) -> None: ...
    def notify(self, receiver: QtCore.QObject|None, event: QtCore.QEvent|None) -> bool: ...
    def event(self, event: QtCore.QEvent|None) -> bool: ...
    @staticmethod
    def instance() -> 'QgsApplication|None': ...


class QgsApplicationThemeRegistry(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsApplicationThemeRegistry') -> None: ...

    def themeFolders(self) -> dict[str, str]: ...
    def themeFolder(self, name: str|None) -> str: ...
    def themes(self) -> list[str]: ...
    def removeTheme(self, name: str|None) -> bool: ...
    def addTheme(self, name: str|None, folder: str|None) -> bool: ...


class QgsArchive(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsArchive') -> None: ...

    def exists(self) -> bool: ...
    def dir(self) -> str: ...
    def files(self) -> list[str]: ...
    def removeFile(self, filename: str|None) -> bool: ...
    def addFile(self, filename: str|None) -> None: ...
    def clear(self) -> None: ...
    def unzip(self, zipFilename: str|None) -> bool: ...
    def zip(self, zipFilename: str|None) -> bool: ...


class QgsProjectArchive(QgsArchive):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsProjectArchive') -> None: ...

    def auxiliaryStorageFile(self) -> str: ...
    def clearProjectFile(self) -> bool: ...
    def projectFile(self) -> str: ...
    def unzip(self, zipFilename: str|None) -> bool: ...


class QgsArrowInferSchemaOptions(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsArrowInferSchemaOptions') -> None: ...

    def geometryColumnName(self) -> str: ...
    def setGeometryColumnName(self, geometryColumnName: str|None) -> None: ...


class QgsArrowSchema(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsArrowSchema') -> None: ...

    def setGeometryColumnIndex(self, geometryColumnIndex: int) -> None: ...
    def geometryColumnIndex(self) -> int: ...
    def isValid(self) -> bool: ...
    def exportToAddress(self, otherAddress: int) -> None: ...
    def cSchemaAddress(self) -> int: ...


class QgsArrowArray(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def isValid(self) -> bool: ...
    def exportToAddress(self, otherAddress: int) -> None: ...
    def cArrayAddress(self) -> int: ...


class QgsArrowArrayStream(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def isValid(self) -> bool: ...
    def exportToAddress(self, otherAddress: int) -> None: ...
    def cArrayStreamAddress(self) -> int: ...


class QgsArrowIterator(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, featureIterator: 'QgsFeatureIterator') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsArrowIterator') -> None: ...

    @typing.overload
    @staticmethod
    def inferSchema(layer: 'QgsVectorLayer', options: QgsArrowInferSchemaOptions = ...) -> QgsArrowSchema: ...
    @typing.overload
    @staticmethod
    def inferSchema(fields: 'QgsFields', hasGeometry: bool = ..., crs: 'QgsCoordinateReferenceSystem' = ..., options: QgsArrowInferSchemaOptions = ...) -> QgsArrowSchema: ...
    def nextFeatures(self, n: int) -> QgsArrowArray: ...
    def toArrayStream(self, batchSize: int = ...) -> QgsArrowArrayStream: ...
    def setSchema(self, schema: QgsArrowSchema) -> None: ...


class QgsAttributeTableConfig(PyQt6.sip.wrapper):

    class ActionWidgetStyle(enum.IntEnum):
        ButtonList = ... # type: QgsAttributeTableConfig.ActionWidgetStyle
        DropDown = ... # type: QgsAttributeTableConfig.ActionWidgetStyle

    class Type(enum.IntEnum):
        Field = ... # type: QgsAttributeTableConfig.Type
        Action = ... # type: QgsAttributeTableConfig.Type

    class ColumnConfig(PyQt6.sip.wrapper):

        hidden = ... # type: bool
        name = ... # type: str|None
        type = ... # type: 'QgsAttributeTableConfig.Type'
        width = ... # type: int

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAttributeTableConfig.ColumnConfig') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAttributeTableConfig') -> None: ...

    def __eq__(self, other: object): ...
    def __ne__(self, other: object): ...
    def hasSameColumns(self, other: 'QgsAttributeTableConfig') -> bool: ...
    def setSortOrder(self, sortOrder: QtCore.Qt.SortOrder) -> None: ...
    def sortOrder(self) -> QtCore.Qt.SortOrder: ...
    def setColumnHidden(self, column: int, hidden: bool) -> None: ...
    def columnHidden(self, column: int) -> bool: ...
    def setColumnWidth(self, column: int, width: int) -> None: ...
    def columnWidth(self, column: int) -> int: ...
    def setSortExpression(self, sortExpression: str|None) -> None: ...
    def sortExpression(self) -> str: ...
    def readXml(self, node: QtXml.QDomNode) -> None: ...
    def writeXml(self, node: QtXml.QDomNode) -> None: ...
    def setActionWidgetStyle(self, actionWidgetStyle: 'QgsAttributeTableConfig.ActionWidgetStyle') -> None: ...
    def actionWidgetStyle(self) -> 'QgsAttributeTableConfig.ActionWidgetStyle': ...
    def setActionWidgetVisible(self, visible: bool) -> None: ...
    def actionWidgetVisible(self) -> bool: ...
    def update(self, fields: 'QgsFields') -> None: ...
    def setColumns(self, columns: collections.abc.Iterable['QgsAttributeTableConfig.ColumnConfig']) -> None: ...
    def mapVisibleColumnToIndex(self, visibleColumn: int) -> int: ...
    def __len__(self) -> int: ...
    def size(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def columns(self) -> list['QgsAttributeTableConfig.ColumnConfig']: ...


class QgsMapLayer(QtCore.QObject):

    class SaveStyleResult(enum.Enum):
        Success = ... # type: QgsMapLayer.SaveStyleResult
        QmlGenerationFailed = ... # type: QgsMapLayer.SaveStyleResult
        SldGenerationFailed = ... # type: QgsMapLayer.SaveStyleResult
        DatabaseWriteFailed = ... # type: QgsMapLayer.SaveStyleResult

    class ReadFlag(enum.IntEnum):
        FlagDontResolveLayers = ... # type: QgsMapLayer.ReadFlag
        FlagTrustLayerMetadata = ... # type: QgsMapLayer.ReadFlag
        FlagReadExtentFromXml = ... # type: QgsMapLayer.ReadFlag
        FlagForceReadOnly = ... # type: QgsMapLayer.ReadFlag

    class StyleCategory(enum.IntEnum):
        LayerConfiguration = ... # type: QgsMapLayer.StyleCategory
        Symbology = ... # type: QgsMapLayer.StyleCategory
        Symbology3D = ... # type: QgsMapLayer.StyleCategory
        Labeling = ... # type: QgsMapLayer.StyleCategory
        Fields = ... # type: QgsMapLayer.StyleCategory
        Forms = ... # type: QgsMapLayer.StyleCategory
        Actions = ... # type: QgsMapLayer.StyleCategory
        MapTips = ... # type: QgsMapLayer.StyleCategory
        Diagrams = ... # type: QgsMapLayer.StyleCategory
        AttributeTable = ... # type: QgsMapLayer.StyleCategory
        Rendering = ... # type: QgsMapLayer.StyleCategory
        CustomProperties = ... # type: QgsMapLayer.StyleCategory
        GeometryOptions = ... # type: QgsMapLayer.StyleCategory
        Relations = ... # type: QgsMapLayer.StyleCategory
        Temporal = ... # type: QgsMapLayer.StyleCategory
        Legend = ... # type: QgsMapLayer.StyleCategory
        Elevation = ... # type: QgsMapLayer.StyleCategory
        Notes = ... # type: QgsMapLayer.StyleCategory
        AllVisualStyleCategories = ... # type: QgsMapLayer.StyleCategory
        AllAttributeCategories = ... # type: QgsMapLayer.StyleCategory
        AllStyleCategories = ... # type: QgsMapLayer.StyleCategory

    class LayerFlag(enum.IntEnum):
        Identifiable = ... # type: QgsMapLayer.LayerFlag
        Removable = ... # type: QgsMapLayer.LayerFlag
        Searchable = ... # type: QgsMapLayer.LayerFlag
        Private = ... # type: QgsMapLayer.LayerFlag

    class PropertyType(enum.IntEnum):
        Style = ... # type: QgsMapLayer.PropertyType
        Metadata = ... # type: QgsMapLayer.PropertyType

    def __init__(self, type: Qgis.LayerType = ..., name: str|None = ..., source: str|None = ...) -> None: ...

    def hasDependencyCycle(self, a0: collections.abc.Iterable['QgsMapLayerDependency']) -> bool: ...
    def invalidateWgs84Extent(self) -> None: ...
    def setError(self, error: 'QgsError') -> None: ...
    def appendError(self, error: 'QgsErrorMessage') -> None: ...
    def setProviderType(self, providerType: str|None) -> None: ...
    def readCommonStyle(self, layerElement: QtXml.QDomElement, context: 'QgsReadWriteContext', categories: 'QgsMapLayer.StyleCategory' = ...) -> None: ...
    def writeCommonStyle(self, layerElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: 'QgsReadWriteContext', categories: 'QgsMapLayer.StyleCategory' = ...) -> None: ...
    def writeStyleManager(self, layerNode: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    def readStyleManager(self, layerNode: QtXml.QDomNode) -> None: ...
    def writeCustomProperties(self, layerNode: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    def readCustomProperties(self, layerNode: QtXml.QDomNode, keyStartsWith: str|None = ...) -> None: ...
    def decodedSource(self, source: str|None, dataProvider: str|None, context: 'QgsReadWriteContext') -> str: ...
    def encodedSource(self, source: str|None, context: 'QgsReadWriteContext') -> str: ...
    def writeXml(self, layer_node: QtXml.QDomNode, document: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> bool: ...
    def readXml(self, layer_node: QtXml.QDomNode, context: 'QgsReadWriteContext') -> bool: ...
    def setValid(self, valid: bool) -> None: ...
    def setExtent3D(self, box: 'QgsBox3D') -> None: ...
    def setExtent(self, rect: 'QgsRectangle') -> None: ...
    mapTipsEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    mapTipTemplateChanged: typing.ClassVar[QtCore.pyqtSignal]
    layerModified: typing.ClassVar[QtCore.pyqtSignal]
    editingStopped: typing.ClassVar[QtCore.pyqtSignal]
    editingStarted: typing.ClassVar[QtCore.pyqtSignal]
    customPropertyChanged: typing.ClassVar[QtCore.pyqtSignal]
    isValidChanged: typing.ClassVar[QtCore.pyqtSignal]
    styleLoaded: typing.ClassVar[QtCore.pyqtSignal]
    dataSourceChanged: typing.ClassVar[QtCore.pyqtSignal]
    flagsChanged: typing.ClassVar[QtCore.pyqtSignal]
    metadataChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoRefreshIntervalChanged: typing.ClassVar[QtCore.pyqtSignal]
    willBeDeleted: typing.ClassVar[QtCore.pyqtSignal]
    dependenciesChanged: typing.ClassVar[QtCore.pyqtSignal]
    configChanged: typing.ClassVar[QtCore.pyqtSignal]
    request3DUpdate: typing.ClassVar[QtCore.pyqtSignal]
    renderer3DChanged: typing.ClassVar[QtCore.pyqtSignal]
    legendChanged: typing.ClassVar[QtCore.pyqtSignal]
    styleChanged: typing.ClassVar[QtCore.pyqtSignal]
    rendererChanged: typing.ClassVar[QtCore.pyqtSignal]
    opacityChanged: typing.ClassVar[QtCore.pyqtSignal]
    blendModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataChanged: typing.ClassVar[QtCore.pyqtSignal]
    recalculateExtents: typing.ClassVar[QtCore.pyqtSignal]
    repaintRequested: typing.ClassVar[QtCore.pyqtSignal]
    verticalCrsChanged: typing.ClassVar[QtCore.pyqtSignal]
    crs3DChanged: typing.ClassVar[QtCore.pyqtSignal]
    crsChanged: typing.ClassVar[QtCore.pyqtSignal]
    nameChanged: typing.ClassVar[QtCore.pyqtSignal]
    idChanged: typing.ClassVar[QtCore.pyqtSignal]
    statusChanged: typing.ClassVar[QtCore.pyqtSignal]
    beforeResolveReferences: typing.ClassVar[QtCore.pyqtSignal]
    def project(self) -> 'QgsProject|None': ...
    def __repr__(self) -> typing.Any: ...
    def setTransformContext(self, transformContext: 'QgsCoordinateTransformContext') -> None: ...
    def setRefreshOnNofifyMessage(self, message: str|None) -> None: ...
    def setRefreshOnNotifyEnabled(self, enabled: bool) -> None: ...
    def setDependencies(self, layers: collections.abc.Iterable['QgsMapLayerDependency']) -> bool: ...
    def emitStyleChanged(self) -> None: ...
    def trigger3DUpdate(self) -> None: ...
    def triggerRepaint(self, deferredUpdate: bool = ...) -> None: ...
    def setScaleBasedVisibility(self, enabled: bool) -> None: ...
    def setMaximumScale(self, scale: float) -> None: ...
    def setMinimumScale(self, scale: float) -> None: ...
    @staticmethod
    def providerReadFlags(layerNode: QtXml.QDomNode, layerReadFlags: 'QgsMapLayer.ReadFlag') -> Qgis.DataProviderReadFlag: ...
    def mapTipsEnabled(self) -> bool: ...
    def setMapTipsEnabled(self, enabled: bool) -> None: ...
    def setMapTipTemplate(self, mapTipTemplate: str|None) -> None: ...
    def mapTipTemplate(self) -> str: ...
    def hasMapTips(self) -> bool: ...
    def setLegendPlaceholderImage(self, imgPath: str|None) -> None: ...
    def legendPlaceholderImage(self) -> str: ...
    def profileSource(self) -> 'QgsAbstractProfileSource|None': ...
    def elevationProperties(self) -> 'QgsMapLayerElevationProperties|None': ...
    def temporalProperties(self) -> 'QgsMapLayerTemporalProperties|None': ...
    def selectionProperties(self) -> 'QgsMapLayerSelectionProperties|None': ...
    @typing.overload
    def accept(self, visitor: 'QgsStyleEntityVisitorInterface|None') -> bool: ...
    @typing.overload
    def accept(self, visitor: 'QgsObjectEntityVisitorInterface|None', context: 'QgsObjectVisitorContext') -> bool: ...
    @staticmethod
    def generateId(layerName: str|None) -> str: ...
    def setOriginalXmlProperties(self, originalXmlProperties: str|None) -> None: ...
    def originalXmlProperties(self) -> str: ...
    def isRefreshOnNotifyEnabled(self) -> bool: ...
    def refreshOnNotifyMessage(self) -> str: ...
    def dependencies(self) -> set['QgsMapLayerDependency']: ...
    def timestamp(self) -> QtCore.QDateTime: ...
    def htmlMetadata(self) -> str: ...
    def setMetadata(self, metadata: 'QgsLayerMetadata') -> None: ...
    def metadata(self) -> 'QgsLayerMetadata': ...
    def setAutoRefreshMode(self, mode: Qgis.AutoRefreshMode) -> None: ...
    @deprecated("""""")
    def setAutoRefreshEnabled(self, enabled: bool) -> None: ...
    def setAutoRefreshInterval(self, interval: int) -> None: ...
    def autoRefreshInterval(self) -> int: ...
    def autoRefreshMode(self) -> Qgis.AutoRefreshMode: ...
    @deprecated("""""")
    def hasAutoRefreshEnabled(self) -> bool: ...
    def hasScaleBasedVisibility(self) -> bool: ...
    def maximumScale(self) -> float: ...
    def minimumScale(self) -> float: ...
    def isInScaleRange(self, scale: float) -> bool: ...
    def renderer3D(self) -> 'QgsAbstract3DRenderer|None': ...
    def setRenderer3D(self, renderer: 'QgsAbstract3DRenderer|None') -> None: ...
    def styleManager(self) -> 'QgsMapLayerStyleManager|None': ...
    def legend(self) -> 'QgsMapLayerLegend|None': ...
    def setLegend(self, legend: 'QgsMapLayerLegend|None') -> None: ...
    @deprecated("""""")
    def legendUrlFormat(self) -> str: ...
    @deprecated("""""")
    def setLegendUrlFormat(self, legendUrlFormat: str|None) -> None: ...
    @deprecated("""""")
    def legendUrl(self) -> str: ...
    @deprecated("""""")
    def setLegendUrl(self, legendUrl: str|None) -> None: ...
    def undoStackStyles(self) -> QtGui.QUndoStack|None: ...
    def undoStack(self) -> QtGui.QUndoStack|None: ...
    def providerType(self) -> str: ...
    @typing.overload
    def setDataSource(self, dataSource: str|None, baseName: str|None = ..., provider: str|None = ..., loadDefaultStyleFlag: bool = ...) -> None: ...
    @typing.overload
    def setDataSource(self, dataSource: str|None, baseName: str|None, provider: str|None, options: 'QgsDataProvider.ProviderOptions', loadDefaultStyleFlag: bool = ...) -> None: ...
    @typing.overload
    def setDataSource(self, dataSource: str|None, baseName: str|None, provider: str|None, options: 'QgsDataProvider.ProviderOptions', flags: Qgis.DataProviderReadFlag) -> None: ...
    def writeStyle(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str|None, context: 'QgsReadWriteContext', categories: 'QgsMapLayer.StyleCategory' = ...) -> bool: ...
    def writeSymbology(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str|None, context: 'QgsReadWriteContext', categories: 'QgsMapLayer.StyleCategory' = ...) -> bool: ...
    def readStyle(self, node: QtXml.QDomNode, errorMessage: str|None, context: 'QgsReadWriteContext', categories: 'QgsMapLayer.StyleCategory' = ...) -> bool: ...
    def readSymbology(self, node: QtXml.QDomNode, errorMessage: str|None, context: 'QgsReadWriteContext', categories: 'QgsMapLayer.StyleCategory' = ...) -> bool: ...
    def readSld(self, node: QtXml.QDomNode, errorMessage: str|None) -> bool: ...
    def loadSldStyle(self, uri: str|None) -> typing.Tuple[str, bool]: ...
    def saveSldStyleV2(self, exportContext: 'QgsSldExportContext') -> typing.Tuple[str, bool]: ...
    def saveSldStyle(self, uri: str|None) -> typing.Tuple[str, bool]: ...
    def saveNamedStyle(self, uri: str|None, categories: 'QgsMapLayer.StyleCategory' = ...) -> typing.Tuple[str, bool]: ...
    @typing.overload
    def saveDefaultStyle(self, categories: 'QgsMapLayer.StyleCategory') -> typing.Tuple[str, bool]: ...
    @typing.overload
    @deprecated("""""")
    def saveDefaultStyle(self) -> typing.Tuple[str, bool]: ...
    def exportSldStyleV3(self, exportContext: 'QgsSldExportContext') -> QtXml.QDomDocument: ...
    @deprecated("""""")
    def exportSldStyleV2(self, doc: QtXml.QDomDocument, errorMsg: str|None, exportContext: 'QgsSldExportContext') -> None: ...
    @deprecated("""""")
    def exportSldStyle(self, doc: QtXml.QDomDocument, errorMsg: str|None) -> None: ...
    def exportNamedStyle(self, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext' = ..., categories: 'QgsMapLayer.StyleCategory' = ...) -> str: ...
    def importNamedStyle(self, doc: QtXml.QDomDocument, categories: 'QgsMapLayer.StyleCategory' = ...) -> typing.Tuple[bool, str]: ...
    def loadNamedStyleFromDatabase(self, db: str|None, uri: str|None) -> typing.Tuple[bool, str]: ...
    def loadDefaultStyle(self) -> typing.Tuple[str, bool]: ...
    def styleURI(self) -> str: ...
    def importNamedMetadata(self, document: QtXml.QDomDocument, errorMessage: str|None) -> bool: ...
    def loadNamedMetadataFromDatabase(self, db: str|None, uri: str|None, qmd: str|None) -> bool: ...
    def loadDefaultMetadata(self) -> typing.Tuple[str, bool]: ...
    def loadNamedMetadata(self, uri: str|None) -> typing.Tuple[str, bool]: ...
    def saveNamedMetadata(self, uri: str|None) -> typing.Tuple[str, bool]: ...
    def saveDefaultMetadata(self) -> typing.Tuple[str, bool]: ...
    def exportNamedMetadata(self, doc: QtXml.QDomDocument, errorMsg: str|None) -> None: ...
    def metadataUri(self) -> str: ...
    @staticmethod
    def formatLayerName(name: str|None) -> str: ...
    def transformContext(self) -> 'QgsCoordinateTransformContext': ...
    def setVerticalCrs(self, crs: 'QgsCoordinateReferenceSystem') -> typing.Tuple[bool, str]: ...
    def setCrs(self, srs: 'QgsCoordinateReferenceSystem', emitSignal: bool = ...) -> None: ...
    def crs3D(self) -> 'QgsCoordinateReferenceSystem': ...
    def verticalCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...
    def error(self) -> 'QgsError': ...
    def removeCustomProperty(self, key: str|None) -> None: ...
    @typing.overload
    def loadNamedStyle(self, theURI: str|None, loadFromLocalDb: bool, categories: 'QgsMapLayer.StyleCategory' = ..., flags: Qgis.LoadStyleFlag = ...) -> typing.Tuple[str, bool]: ...
    @typing.overload
    def loadNamedStyle(self, uri: str|None, categories: 'QgsMapLayer.StyleCategory' = ..., flags: Qgis.LoadStyleFlag = ...) -> typing.Tuple[str, bool]: ...
    def saveStyleToDatabaseV2(self, name: str|None, description: str|None, useAsDefault: bool, uiFileContent: str|None, categories: 'QgsMapLayer.StyleCategory' = ...) -> typing.Tuple['QgsMapLayer.SaveStyleResult', str]: ...
    @deprecated("""""")
    def saveStyleToDatabase(self, name: str|None, description: str|None, useAsDefault: bool, uiFileContent: str|None, categories: 'QgsMapLayer.StyleCategory' = ...) -> str: ...
    def deleteStyleFromDatabase(self, styleId: str|None) -> typing.Tuple[bool, str]: ...
    def getStyleFromDatabase(self, styleId: str|None) -> typing.Tuple[str, str]: ...
    def listStylesInDatabase(self) -> typing.Tuple[int, list[str], list[str], list[str], str]: ...
    def customProperties(self) -> 'QgsObjectCustomProperties': ...
    def setCustomProperties(self, properties: 'QgsObjectCustomProperties') -> None: ...
    def customProperty(self, value: str|None, defaultValue: typing.Any = ...) -> typing.Any: ...
    def setCustomProperty(self, key: str|None, value: typing.Any) -> None: ...
    def customPropertyKeys(self) -> list[str]: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def writeLayerXml(self, layerElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> bool: ...
    def readLayerXml(self, layerElement: QtXml.QDomElement, context: 'QgsReadWriteContext', flags: 'QgsMapLayer.ReadFlag' = ..., preloadedProvider: 'QgsDataProvider|None' = ...) -> bool: ...
    def isTemporary(self) -> bool: ...
    def isSpatial(self) -> bool: ...
    def isModified(self) -> bool: ...
    def isEditable(self) -> bool: ...
    def supportsEditing(self) -> bool: ...
    def setSubLayerVisibility(self, name: str|None, visible: bool) -> None: ...
    def setLayerOrder(self, layers: collections.abc.Iterable[str|None]) -> None: ...
    def subLayers(self) -> list[str]: ...
    def source(self) -> str: ...
    def publicSource(self, hidePassword: bool = ...) -> str: ...
    def isValid(self) -> bool: ...
    def wgs84Extent(self, forceRecalculate: bool = ...) -> 'QgsRectangle': ...
    def extent3D(self) -> 'QgsBox3D': ...
    def extent(self) -> 'QgsRectangle': ...
    def createMapRenderer(self, rendererContext: 'QgsRenderContext') -> 'QgsMapLayerRenderer|None': ...
    def reload(self) -> None: ...
    def readOnly(self) -> bool: ...
    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, blendMode: QtGui.QPainter.CompositionMode) -> None: ...
    @deprecated("""""")
    def metadataUrlFormat(self) -> str: ...
    @deprecated("""""")
    def setMetadataUrlFormat(self, metaUrlFormat: str|None) -> None: ...
    @deprecated("""""")
    def metadataUrlType(self) -> str: ...
    @deprecated("""""")
    def setMetadataUrlType(self, metaUrlType: str|None) -> None: ...
    @deprecated("""""")
    def metadataUrl(self) -> str: ...
    @deprecated("""""")
    def setMetadataUrl(self, metaUrl: str|None) -> None: ...
    def serverProperties(self) -> 'QgsMapLayerServerProperties|None': ...
    @deprecated("""""")
    def attributionUrl(self) -> str: ...
    @deprecated("""""")
    def setAttributionUrl(self, attribUrl: str|None) -> None: ...
    @deprecated("""""")
    def attribution(self) -> str: ...
    @deprecated("""""")
    def setAttribution(self, attrib: str|None) -> None: ...
    @deprecated("""""")
    def dataUrlFormat(self) -> str: ...
    @deprecated("""""")
    def setDataUrlFormat(self, dataUrlFormat: str|None) -> None: ...
    @deprecated("""""")
    def dataUrl(self) -> str: ...
    @deprecated("""""")
    def setDataUrl(self, dataUrl: str|None) -> None: ...
    @deprecated("""""")
    def keywordList(self) -> str: ...
    @deprecated("""""")
    def setKeywordList(self, keywords: str|None) -> None: ...
    @deprecated("""""")
    def abstract(self) -> str: ...
    @deprecated("""""")
    def setAbstract(self, abstract: str|None) -> None: ...
    @deprecated("""""")
    def title(self) -> str: ...
    @deprecated("""""")
    def setTitle(self, title: str|None) -> None: ...
    @deprecated("""""")
    def shortName(self) -> str: ...
    @deprecated("""""")
    def setShortName(self, shortName: str|None) -> None: ...
    def providerMetadata(self) -> 'QgsProviderMetadata|None': ...
    def dataProvider(self) -> 'QgsDataProvider|None': ...
    def name(self) -> str: ...
    def setName(self, name: str|None) -> None: ...
    def setId(self, id: str|None) -> bool: ...
    def id(self) -> str: ...
    @staticmethod
    def extensionPropertyType(type: 'QgsMapLayer.PropertyType') -> str: ...
    def properties(self) -> Qgis.MapLayerProperty: ...
    def setFlags(self, flags: 'QgsMapLayer.LayerFlag') -> None: ...
    def flags(self) -> 'QgsMapLayer.LayerFlag': ...
    def type(self) -> Qgis.LayerType: ...
    @typing.overload
    def clone(self) -> 'QgsMapLayer|None': ...
    @typing.overload
    def clone(self, layer: 'QgsMapLayer|None') -> None: ...


class QgsExpressionContextGenerator(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsExpressionContextGenerator') -> None: ...

    def createExpressionContext(self) -> 'QgsExpressionContext': ...


class QgsExpressionContextScopeGenerator(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsExpressionContextScopeGenerator') -> None: ...

    def createExpressionContextScope(self) -> 'QgsExpressionContextScope|None': ...


class QgsFeatureSink(PyQt6.sip.wrapper):

    class Flag(enum.IntEnum):
        FastInsert = ... # type: QgsFeatureSink.Flag
        RollBackOnErrors = ... # type: QgsFeatureSink.Flag

    class SinkFlag(enum.IntEnum):
        RegeneratePrimaryKey = ... # type: QgsFeatureSink.SinkFlag

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFeatureSink') -> None: ...

    def lastError(self) -> str: ...
    def flushBuffer(self) -> bool: ...
    @typing.overload
    def addFeatures(self, features: collections.abc.Iterable['QgsFeature'], flags: 'QgsFeatureSink.Flag' = ...) -> bool: ...
    @typing.overload
    def addFeatures(self, iterator: 'QgsFeatureIterator', flags: 'QgsFeatureSink.Flag' = ...) -> bool: ...
    def addFeature(self, feature: 'QgsFeature', flags: 'QgsFeatureSink.Flag' = ...) -> bool: ...
    def finalize(self) -> None: ...


class QgsFeatureSource(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFeatureSource') -> None: ...

    def hasSpatialIndex(self) -> Qgis.SpatialIndexPresence: ...
    def materialize(self, request: 'QgsFeatureRequest', feedback: 'QgsFeedback|None' = ...) -> 'QgsVectorLayer|None': ...
    def allFeatureIds(self) -> typing.Any: ...
    def sourceExtent3D(self) -> 'QgsBox3D': ...
    def sourceExtent(self) -> 'QgsRectangle': ...
    def maximumValue(self, fieldIndex: int) -> typing.Any: ...
    def minimumValue(self, fieldIndex: int) -> typing.Any: ...
    def uniqueValues(self, fieldIndex: int, limit: int = ...) -> set[typing.Any]: ...
    def hasFeatures(self) -> Qgis.FeatureAvailability: ...
    def featureCount(self) -> int: ...
    def __bool__(self) -> int: ...
    def __len__(self) -> int: ...
    def wkbType(self) -> Qgis.WkbType: ...
    def fields(self) -> 'QgsFields': ...
    def sourceCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def sourceName(self) -> str: ...
    def getFeatures(self, request: 'QgsFeatureRequest' = ...) -> 'QgsFeatureIterator': ...


class QgsAbstractProfileSource(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractProfileSource') -> None: ...

    def profileSourceName(self) -> str: ...
    def profileSourceId(self) -> str: ...
    def createProfileGenerator(self, request: 'QgsProfileRequest') -> 'QgsAbstractProfileGenerator|None': ...


class QgsVectorLayer(QgsMapLayer, QgsExpressionContextGenerator, QgsExpressionContextScopeGenerator, QgsFeatureSink, QgsFeatureSource, QgsAbstractProfileSource):

    class LayerOptions(PyQt6.sip.wrapper):

        fallbackCrs = ... # type: 'QgsCoordinateReferenceSystem'
        fallbackWkbType = ... # type: Qgis.WkbType
        forceReadOnly = ... # type: bool
        loadAllStoredStyles = ... # type: bool
        loadDefaultStyle = ... # type: bool
        readExtentFromXml = ... # type: bool
        skipCrsValidation = ... # type: bool
        transformContext = ... # type: 'QgsCoordinateTransformContext'

        @typing.overload
        def __init__(self, loadDefaultStyle: bool = ..., readExtentFromXml: bool = ...) -> None: ...
        @typing.overload
        def __init__(self, transformContext: 'QgsCoordinateTransformContext', loadDefaultStyle: bool = ..., readExtentFromXml: bool = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorLayer.LayerOptions') -> None: ...

    class DeleteContext(PyQt6.sip.wrapper):

        cascade = ... # type: bool
        project = ... # type: 'QgsProject'

        @typing.overload
        def __init__(self, cascade: bool = ..., project: 'QgsProject|None' = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorLayer.DeleteContext') -> None: ...

        def handledFeatures(self, layer: 'QgsVectorLayer|None') -> typing.Any: ...
        def handledLayers(self, includeAuxiliaryLayers: bool = ...) -> list['QgsVectorLayer']: ...

    def __init__(self, path: str|None = ..., baseName: str|None = ..., providerLib: str|None = ..., options: 'QgsVectorLayer.LayerOptions' = ...) -> None: ...

    def setExtent3D(self, rect: 'QgsBox3D') -> None: ...
    def setExtent(self, rect: 'QgsRectangle') -> None: ...
    symbolFeatureCountMapChanged: typing.ClassVar[QtCore.pyqtSignal]
    supportsEditingChanged: typing.ClassVar[QtCore.pyqtSignal]
    readOnlyChanged: typing.ClassVar[QtCore.pyqtSignal]
    editFormConfigChanged: typing.ClassVar[QtCore.pyqtSignal]
    raiseError: typing.ClassVar[QtCore.pyqtSignal]
    displayExpressionChanged: typing.ClassVar[QtCore.pyqtSignal]
    writeCustomSymbology: typing.ClassVar[QtCore.pyqtSignal]
    readCustomSymbology: typing.ClassVar[QtCore.pyqtSignal]
    editCommandDestroyed: typing.ClassVar[QtCore.pyqtSignal]
    editCommandEnded: typing.ClassVar[QtCore.pyqtSignal]
    editCommandStarted: typing.ClassVar[QtCore.pyqtSignal]
    featureBlendModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelingFontNotFound: typing.ClassVar[QtCore.pyqtSignal]
    committedGeometriesChanges: typing.ClassVar[QtCore.pyqtSignal]
    committedAttributeValuesChanges: typing.ClassVar[QtCore.pyqtSignal]
    committedFeaturesRemoved: typing.ClassVar[QtCore.pyqtSignal]
    committedFeaturesAdded: typing.ClassVar[QtCore.pyqtSignal]
    committedAttributesAdded: typing.ClassVar[QtCore.pyqtSignal]
    committedAttributesDeleted: typing.ClassVar[QtCore.pyqtSignal]
    geometryChanged: typing.ClassVar[QtCore.pyqtSignal]
    attributeValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    subsetStringChanged: typing.ClassVar[QtCore.pyqtSignal]
    updatedFields: typing.ClassVar[QtCore.pyqtSignal]
    featuresDeleted: typing.ClassVar[QtCore.pyqtSignal]
    featureDeleted: typing.ClassVar[QtCore.pyqtSignal]
    featureAdded: typing.ClassVar[QtCore.pyqtSignal]
    beforeRemovingExpressionField: typing.ClassVar[QtCore.pyqtSignal]
    attributeDeleted: typing.ClassVar[QtCore.pyqtSignal]
    beforeAddingExpressionField: typing.ClassVar[QtCore.pyqtSignal]
    attributeAdded: typing.ClassVar[QtCore.pyqtSignal]
    afterRollBack: typing.ClassVar[QtCore.pyqtSignal]
    afterCommitChanges: typing.ClassVar[QtCore.pyqtSignal]
    beforeRollBack: typing.ClassVar[QtCore.pyqtSignal]
    beforeCommitChanges: typing.ClassVar[QtCore.pyqtSignal]
    beforeEditingStarted: typing.ClassVar[QtCore.pyqtSignal]
    beforeModifiedCheck: typing.ClassVar[QtCore.pyqtSignal]
    allowCommitChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    @typing.overload
    def accept(self, visitor: 'QgsStyleEntityVisitorInterface|None') -> bool: ...
    @typing.overload
    def accept(self, visitor: 'QgsObjectEntityVisitorInterface|None', context: 'QgsObjectVisitorContext') -> bool: ...
    def hasSpatialIndex(self) -> Qgis.SpatialIndexPresence: ...
    def setTransformContext(self, transformContext: 'QgsCoordinateTransformContext') -> None: ...
    def startEditing(self) -> bool: ...
    def updateExtents(self, force: bool = ...) -> None: ...
    def reselect(self) -> None: ...
    def removeSelection(self) -> None: ...
    @typing.overload
    def deselect(self, featureId: int) -> None: ...
    @typing.overload
    def deselect(self, featureIds: typing.Any) -> None: ...
    @typing.overload
    def select(self, featureId: int) -> None: ...
    @typing.overload
    def select(self, featureIds: typing.Any) -> None: ...
    def storedExpressionManager(self) -> 'QgsStoredExpressionManager|None': ...
    def geometryOptions(self) -> 'QgsGeometryOptions|None': ...
    def isEditCommandActive(self) -> bool: ...
    def readExtentFromXml(self) -> bool: ...
    def setReadExtentFromXml(self, readExtentFromXml: bool) -> None: ...
    def setEditFormConfig(self, editFormConfig: 'QgsEditFormConfig') -> None: ...
    def editFormConfig(self) -> 'QgsEditFormConfig': ...
    def createExpressionContextScope(self) -> 'QgsExpressionContextScope|None': ...
    def createExpressionContext(self) -> 'QgsExpressionContext': ...
    def setAttributeTableConfig(self, attributeTableConfig: QgsAttributeTableConfig) -> None: ...
    def attributeTableConfig(self) -> QgsAttributeTableConfig: ...
    def conditionalStyles(self) -> 'QgsConditionalLayerStyles|None': ...
    def simplifyDrawingCanbeApplied(self, renderContext: 'QgsRenderContext', simplifyHint: Qgis.VectorRenderingSimplificationFlag) -> bool: ...
    def simplifyMethod(self) -> 'QgsVectorSimplifyMethod': ...
    def setSimplifyMethod(self, simplifyMethod: 'QgsVectorSimplifyMethod') -> None: ...
    def htmlMetadata(self) -> str: ...
    def featureBlendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setFeatureBlendMode(self, blendMode: QtGui.QPainter.CompositionMode) -> None: ...
    def aggregate(self, aggregate: Qgis.Aggregate, fieldOrExpression: str|None, parameters: QgsAggregateCalculator.AggregateParameters = ..., context: 'QgsExpressionContext|None' = ..., fids: typing.Any = ..., feedback: 'QgsFeedback|None' = ...) -> typing.Tuple[typing.Any, bool]: ...
    def minimumAndMaximumValue(self, index: int) -> typing.Tuple[typing.Any, typing.Any]: ...
    def maximumValue(self, index: int) -> typing.Any: ...
    def minimumValue(self, index: int) -> typing.Any: ...
    def uniqueStringsMatching(self, index: int, substring: str|None, limit: int = ..., feedback: 'QgsFeedback|None' = ...) -> list[str]: ...
    def uniqueValues(self, fieldIndex: int, limit: int = ...) -> set[typing.Any]: ...
    def editorWidgetSetup(self, index: int) -> 'QgsEditorWidgetSetup': ...
    def setEditorWidgetSetup(self, index: int, setup: 'QgsEditorWidgetSetup') -> None: ...
    def fieldConfigurationFlags(self, index: int) -> Qgis.FieldConfigurationFlag: ...
    def setFieldConfigurationFlag(self, index: int, flag: Qgis.FieldConfigurationFlag, active: bool) -> None: ...
    def setFieldConfigurationFlags(self, index: int, flags: Qgis.FieldConfigurationFlag) -> None: ...
    def setConstraintExpression(self, index: int, expression: str|None, description: str|None = ...) -> None: ...
    def constraintDescription(self, index: int) -> str: ...
    def constraintExpression(self, index: int) -> str: ...
    def removeFieldConstraint(self, index: int, constraint: 'QgsFieldConstraints.Constraint') -> None: ...
    def setFieldConstraint(self, index: int, constraint: 'QgsFieldConstraints.Constraint', strength: 'QgsFieldConstraints.ConstraintStrength' = ...) -> None: ...
    def fieldConstraintsAndStrength(self, fieldIndex: int) -> dict['QgsFieldConstraints.Constraint', 'QgsFieldConstraints.ConstraintStrength']: ...
    def fieldConstraints(self, fieldIndex: int) -> 'QgsFieldConstraints.Constraint': ...
    def defaultValueDefinition(self, index: int) -> 'QgsDefaultValue': ...
    def setDefaultValueDefinition(self, index: int, definition: 'QgsDefaultValue') -> None: ...
    def defaultValue(self, index: int, feature: 'QgsFeature' = ..., context: 'QgsExpressionContext|None' = ...) -> typing.Any: ...
    def updateFields(self) -> None: ...
    @staticmethod
    def drawVertexMarker(x: float, y: float, p: QtGui.QPainter, type: Qgis.VertexMarkerType, vertexSize: int) -> None: ...
    def destroyEditCommand(self) -> None: ...
    def endEditCommand(self) -> None: ...
    def beginEditCommand(self, text: str|None) -> None: ...
    def editBuffer(self) -> 'QgsVectorLayerEditBuffer|None': ...
    def referencingRelations(self, idx: int) -> list['QgsRelation']: ...
    def rollBack(self, deleteBuffer: bool = ...) -> bool: ...
    def commitErrors(self) -> list[str]: ...
    def commitChanges(self, stopEditing: bool = ...) -> bool: ...
    def deleteFeatures(self, fids: typing.Any, context: 'QgsVectorLayer.DeleteContext|None' = ...) -> bool: ...
    def deleteFeature(self, fid: int, context: 'QgsVectorLayer.DeleteContext|None' = ...) -> bool: ...
    def addFeatures(self, features: collections.abc.Iterable['QgsFeature'], flags: QgsFeatureSink.Flag = ...) -> bool: ...
    def deleteAttributes(self, attrs: collections.abc.Iterable[int]) -> bool: ...
    def deleteAttribute(self, attr: int) -> bool: ...
    @deprecated("""""")
    def setExcludeAttributesWfs(self, att: collections.abc.Iterable[str|None]) -> None: ...
    @deprecated("""""")
    def excludeAttributesWfs(self) -> set[str]: ...
    @deprecated("""""")
    def setExcludeAttributesWms(self, att: collections.abc.Iterable[str|None]) -> None: ...
    @deprecated("""""")
    def excludeAttributesWms(self) -> set[str]: ...
    def setFieldMergePolicy(self, index: int, policy: Qgis.FieldDomainMergePolicy) -> None: ...
    def setFieldDuplicatePolicy(self, index: int, policy: Qgis.FieldDuplicatePolicy) -> None: ...
    def setFieldSplitPolicy(self, index: int, policy: Qgis.FieldDomainSplitPolicy) -> None: ...
    def attributeAliases(self) -> dict[str, str]: ...
    def attributeDisplayName(self, index: int) -> str: ...
    def attributeAlias(self, index: int) -> str: ...
    def renameAttribute(self, index: int, newName: str|None) -> bool: ...
    def removeFieldAlias(self, index: int) -> None: ...
    def setFieldAlias(self, index: int, aliasString: str|None) -> None: ...
    def addAttribute(self, field: 'QgsField') -> bool: ...
    def changeAttributeValues(self, fid: int, newValues: dict[int, typing.Any], oldValues: dict[int, typing.Any] = ..., skipDefaultValues: bool = ..., context: 'QgsVectorLayerToolsContext|None' = ...) -> bool: ...
    def changeAttributeValue(self, fid: int, field: int, newValue: typing.Any, oldValue: typing.Any = ..., skipDefaultValues: bool = ..., context: 'QgsVectorLayerToolsContext|None' = ...) -> bool: ...
    def changeGeometry(self, fid: int, geometry: 'QgsGeometry', skipDefaultValue: bool = ...) -> bool: ...
    def supportsEditing(self) -> bool: ...
    def setReadOnly(self, readonly: bool = ...) -> bool: ...
    def primaryKeyAttributes(self) -> list[int]: ...
    def attributeList(self) -> list[int]: ...
    def fields(self) -> 'QgsFields': ...
    def sourceExtent3D(self) -> 'QgsBox3D': ...
    def extent3D(self) -> 'QgsBox3D': ...
    def sourceExtent(self) -> 'QgsRectangle': ...
    def extent(self) -> 'QgsRectangle': ...
    def createMapRenderer(self, rendererContext: 'QgsRenderContext') -> 'QgsMapLayerRenderer|None': ...
    def reload(self) -> None: ...
    def isAuxiliaryField(self, index: int) -> typing.Tuple[bool, int]: ...
    def isModified(self) -> bool: ...
    def isSpatial(self) -> bool: ...
    def isEditable(self) -> bool: ...
    def setLabeling(self, labeling: 'QgsAbstractVectorLayerLabeling|None') -> None: ...
    def labeling(self) -> 'QgsAbstractVectorLayerLabeling|None': ...
    @typing.overload
    def addTopologicalPoints(self, geom: 'QgsGeometry') -> int: ...
    @typing.overload
    @deprecated("""""")
    def addTopologicalPoints(self, p: 'QgsPointXY') -> int: ...
    @typing.overload
    def addTopologicalPoints(self, p: 'QgsPoint') -> int: ...
    @typing.overload
    def addTopologicalPoints(self, ps: collections.abc.Iterable['QgsPoint']) -> int: ...
    @typing.overload
    @deprecated("""""")
    def splitFeatures(self, splitLine: collections.abc.Iterable['QgsPointXY'], topologicalEditing: bool = ...) -> Qgis.GeometryOperationResult: ...
    @typing.overload
    def splitFeatures(self, splitLine: collections.abc.Iterable['QgsPoint'], topologicalEditing: bool = ...) -> Qgis.GeometryOperationResult: ...
    @typing.overload
    def splitFeatures(self, curve: 'QgsCurve|None', preserveCircular: bool = ..., topologicalEditing: bool = ...) -> typing.Tuple[Qgis.GeometryOperationResult, list['QgsPoint']]: ...
    @typing.overload
    @deprecated("""""")
    def splitParts(self, splitLine: collections.abc.Iterable['QgsPointXY'], topologicalEditing: bool = ...) -> Qgis.GeometryOperationResult: ...
    @typing.overload
    def splitParts(self, splitLine: collections.abc.Iterable['QgsPoint'], topologicalEditing: bool = ...) -> Qgis.GeometryOperationResult: ...
    def translateFeature(self, featureId: int, dx: float, dy: float) -> int: ...
    def addCurvedPart(self, ring: 'QgsCurve|None') -> Qgis.GeometryOperationResult: ...
    def addPartV2(self, ring: collections.abc.Iterable['QgsPoint']) -> Qgis.GeometryOperationResult: ...
    @deprecated("""""")
    def addPart(self, ring: collections.abc.Iterable['QgsPointXY']) -> Qgis.GeometryOperationResult: ...
    def addCurvedRing(self, ring: 'QgsCurve|None') -> typing.Tuple[Qgis.GeometryOperationResult, int]: ...
    @typing.overload
    @deprecated("""""")
    def addRing(self, ring: collections.abc.Iterable['QgsPointXY']) -> typing.Tuple[Qgis.GeometryOperationResult, int]: ...
    @typing.overload
    def addRing(self, ring: collections.abc.Iterable['QgsPoint']) -> typing.Tuple[Qgis.GeometryOperationResult, int]: ...
    def deleteSelectedFeatures(self, context: 'QgsVectorLayer.DeleteContext|None' = ...) -> typing.Tuple[bool, int]: ...
    def deleteVertex(self, featureId: int, vertex: int) -> Qgis.VectorEditResult: ...
    def moveVertexV2(self, p: 'QgsPoint', atFeatureId: int, atVertex: int) -> bool: ...
    def moveVertex(self, x: float, y: float, atFeatureId: int, atVertex: int) -> bool: ...
    @typing.overload
    def insertVertex(self, x: float, y: float, atFeatureId: int, beforeVertex: int) -> bool: ...
    @typing.overload
    def insertVertex(self, point: 'QgsPoint', atFeatureId: int, beforeVertex: int) -> bool: ...
    def updateFeature(self, feature: 'QgsFeature', skipDefaultValues: bool = ...) -> bool: ...
    def addFeature(self, feature: 'QgsFeature', flags: QgsFeatureSink.Flag = ...) -> bool: ...
    def getGeometry(self, fid: int) -> 'QgsGeometry': ...
    def getFeature(self, fid: int) -> 'QgsFeature': ...
    @typing.overload
    def getFeatures(self, request: 'QgsFeatureRequest' = ...) -> 'QgsFeatureIterator': ...
    @typing.overload
    def getFeatures(self, expression: str|None) -> 'QgsFeatureIterator': ...
    @typing.overload
    def getFeatures(self, fids: typing.Any) -> 'QgsFeatureIterator': ...
    @typing.overload
    def getFeatures(self, rectangle: 'QgsRectangle') -> 'QgsFeatureIterator': ...
    def subsetString(self) -> str: ...
    def setSubsetString(self, subset: str|None) -> bool: ...
    def countSymbolFeatures(self, storeSymbolFids: bool = ...) -> 'QgsVectorLayerFeatureCounter|None': ...
    def loadDefaultStyle(self) -> typing.Tuple[str, bool]: ...
    def hasFeatures(self) -> Qgis.FeatureAvailability: ...
    def symbolFeatureIds(self, legendKey: str|None) -> typing.Any: ...
    @typing.overload
    def featureCount(self, legendKey: str|None) -> int: ...
    @typing.overload
    def featureCount(self) -> int: ...
    def readSld(self, node: QtXml.QDomNode, errorMessage: str|None) -> bool: ...
    @typing.overload
    @deprecated("""""")
    def writeSld(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str|None, props: dict[str|None, typing.Any] = ...) -> bool: ...
    @typing.overload
    def writeSld(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, context: 'QgsSldExportContext') -> bool: ...
    def writeStyle(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str|None, context: 'QgsReadWriteContext', categories: QgsMapLayer.StyleCategory = ...) -> bool: ...
    def writeSymbology(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str|None, context: 'QgsReadWriteContext', categories: QgsMapLayer.StyleCategory = ...) -> bool: ...
    def readStyle(self, node: QtXml.QDomNode, errorMessage: str|None, context: 'QgsReadWriteContext', categories: QgsMapLayer.StyleCategory = ...) -> bool: ...
    def readSymbology(self, layerNode: QtXml.QDomNode, errorMessage: str|None, context: 'QgsReadWriteContext', categories: QgsMapLayer.StyleCategory = ...) -> bool: ...
    def auxiliaryLayer(self) -> 'QgsAuxiliaryLayer|None': ...
    def setAuxiliaryLayer(self, layer: 'QgsAuxiliaryLayer|None' = ...) -> None: ...
    def loadAuxiliaryLayer(self, storage: 'QgsAuxiliaryStorage', key: str|None = ...) -> bool: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def decodedSource(self, source: str|None, provider: str|None, context: 'QgsReadWriteContext') -> str: ...
    def encodedSource(self, source: str|None, context: 'QgsReadWriteContext') -> str: ...
    def writeXml(self, layer_node: QtXml.QDomNode, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> bool: ...
    def readXml(self, layer_node: QtXml.QDomNode, context: 'QgsReadWriteContext') -> bool: ...
    def sourceName(self) -> str: ...
    def sourceCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def wkbType(self) -> Qgis.WkbType: ...
    def geometryType(self) -> Qgis.GeometryType: ...
    def featureRendererGenerators(self) -> list['QgsFeatureRendererGenerator']: ...
    def removeFeatureRendererGenerator(self, id: str|None) -> None: ...
    def addFeatureRendererGenerator(self, generator: 'QgsFeatureRendererGenerator|None') -> None: ...
    def setRenderer(self, r: 'QgsFeatureRenderer|None') -> None: ...
    def renderer(self) -> 'QgsFeatureRenderer|None': ...
    def diagramLayerSettings(self) -> 'QgsDiagramLayerSettings|None': ...
    def setDiagramLayerSettings(self, s: 'QgsDiagramLayerSettings') -> None: ...
    def diagramRenderer(self) -> 'QgsDiagramRenderer|None': ...
    def setDiagramRenderer(self, r: 'QgsDiagramRenderer|None') -> None: ...
    def diagramsEnabled(self) -> bool: ...
    def setLabelsEnabled(self, enabled: bool) -> None: ...
    def labelsEnabled(self) -> bool: ...
    def boundingBoxOfSelected(self) -> 'QgsRectangle': ...
    def selectedFeatureIds(self) -> typing.Any: ...
    def getSelectedFeatures(self, request: 'QgsFeatureRequest' = ...) -> 'QgsFeatureIterator': ...
    def selectedFeatures(self) -> list['QgsFeature']: ...
    def invertSelectionInRectangle(self, rect: 'QgsRectangle') -> None: ...
    def selectAll(self) -> None: ...
    def invertSelection(self) -> None: ...
    def modifySelection(self, selectIds: typing.Any, deselectIds: typing.Any) -> None: ...
    def selectByIds(self, ids: typing.Any, behavior: Qgis.SelectBehavior = ...) -> None: ...
    def selectByExpression(self, expression: str|None, behavior: Qgis.SelectBehavior = ..., context: 'QgsExpressionContext|None' = ...) -> None: ...
    def selectByRect(self, rect: 'QgsRectangle', behavior: Qgis.SelectBehavior = ...) -> None: ...
    def selectedFeatureCount(self) -> int: ...
    def actions(self) -> 'QgsActionManager|None': ...
    def updateExpressionField(self, index: int, exp: str|None) -> None: ...
    def expressionField(self, index: int) -> str: ...
    def removeExpressionField(self, index: int) -> None: ...
    def addExpressionField(self, exp: str|None, fld: 'QgsField') -> int: ...
    def dependencies(self) -> set['QgsMapLayerDependency']: ...
    def setDependencies(self, layers: collections.abc.Iterable['QgsMapLayerDependency']) -> bool: ...
    def vectorJoins(self) -> list['QgsVectorLayerJoinInfo']: ...
    def joinBuffer(self) -> 'QgsVectorLayerJoinBuffer|None': ...
    def removeJoin(self, joinLayerId: str|None) -> bool: ...
    def addJoin(self, joinInfo: 'QgsVectorLayerJoinInfo') -> bool: ...
    def setCoordinateSystem(self) -> None: ...
    def setProviderEncoding(self, encoding: str|None) -> None: ...
    def createProfileGenerator(self, request: 'QgsProfileRequest') -> 'QgsAbstractProfileGenerator|None': ...
    def profileSourceName(self) -> str: ...
    def profileSourceId(self) -> str: ...
    def profileSource(self) -> QgsAbstractProfileSource|None: ...
    def elevationProperties(self) -> 'QgsMapLayerElevationProperties|None': ...
    def temporalProperties(self) -> 'QgsMapLayerTemporalProperties|None': ...
    def selectionProperties(self) -> 'QgsMapLayerSelectionProperties|None': ...
    def dataProvider(self) -> 'QgsVectorDataProvider|None': ...
    def hasMapTips(self) -> bool: ...
    def displayExpression(self) -> str: ...
    def setDisplayExpression(self, displayExpression: str|None) -> None: ...
    def displayField(self) -> str: ...
    def dataComment(self) -> str: ...
    def vectorLayerTypeFlags(self) -> Qgis.VectorLayerTypeFlag: ...
    def isSqlQuery(self) -> bool: ...
    def capabilitiesString(self) -> str: ...
    def storageType(self) -> str: ...
    def clone(self) -> 'QgsVectorLayer|None': ...
    def __repr__(self) -> typing.Any: ...


class QgsAuxiliaryLayer(QgsVectorLayer):

    def __init__(self, pkField: str|None, filename: str|None, table: str|None, vlayer: QgsVectorLayer|None) -> None: ...

    @staticmethod
    def propertyDefinitionFromField(field: 'QgsField') -> 'QgsPropertyDefinition': ...
    @staticmethod
    def nameFromProperty(def_: 'QgsPropertyDefinition', joined: bool = ...) -> str: ...
    @typing.overload
    @staticmethod
    def createAuxiliaryField(definition: 'QgsPropertyDefinition') -> 'QgsField': ...
    @typing.overload
    @staticmethod
    def createAuxiliaryField(field: 'QgsField') -> 'QgsField': ...
    @typing.overload
    @staticmethod
    def createProperty(property: 'QgsPalLayerSettings.Property', vlayer: QgsVectorLayer|None, overwriteExisting: bool = ...) -> int: ...
    @typing.overload
    @staticmethod
    def createProperty(property: 'QgsDiagramLayerSettings.Property', vlayer: QgsVectorLayer|None, overwriteExisting: bool = ...) -> int: ...
    @typing.overload
    @staticmethod
    def createProperty(property: 'QgsCallout.Property', vlayer: QgsVectorLayer|None, overwriteExisting: bool = ...) -> int: ...
    def propertyDefinitionFromIndex(self, index: int) -> 'QgsPropertyDefinition': ...
    def propertyFromIndex(self, index: int) -> int: ...
    def indexOfPropertyDefinition(self, definition: 'QgsPropertyDefinition') -> int: ...
    def isHiddenProperty(self, index: int) -> bool: ...
    def deleteAttribute(self, attr: int) -> bool: ...
    def save(self) -> bool: ...
    def auxiliaryFields(self) -> 'QgsFields': ...
    def addAuxiliaryField(self, definition: 'QgsPropertyDefinition') -> bool: ...
    def exists(self, definition: 'QgsPropertyDefinition') -> bool: ...
    def joinInfo(self) -> 'QgsVectorLayerJoinInfo': ...
    def clear(self) -> bool: ...
    def toSpatialLayer(self) -> QgsVectorLayer|None: ...
    def clone(self, layer: QgsVectorLayer|None) -> 'QgsAuxiliaryLayer|None': ...
    def __repr__(self) -> typing.Any: ...


class QgsAuxiliaryStorage(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, project: 'QgsProject', copy: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, filename: str|None = ..., copy: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAuxiliaryStorage') -> None: ...

    @staticmethod
    def exists(project: 'QgsProject') -> bool: ...
    @staticmethod
    def extension() -> str: ...
    @staticmethod
    def duplicateTable(uri: 'QgsDataSourceUri', newTable: str|None) -> bool: ...
    @staticmethod
    def deleteTable(uri: 'QgsDataSourceUri') -> bool: ...
    def createAuxiliaryLayer(self, field: 'QgsField', layer: QgsVectorLayer|None) -> QgsAuxiliaryLayer|None: ...
    def save(self) -> bool: ...
    @typing.overload
    def saveAs(self, filename: str|None) -> bool: ...
    @typing.overload
    def saveAs(self, project: 'QgsProject') -> bool: ...
    def errorString(self) -> str: ...
    def currentFileName(self) -> str: ...
    def fileName(self) -> str: ...
    def isValid(self) -> bool: ...


class QgsBearingUtils(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsBearingUtils') -> None: ...

    @staticmethod
    def bearingTrueNorth(crs: 'QgsCoordinateReferenceSystem', transformContext: 'QgsCoordinateTransformContext', point: 'QgsPointXY') -> float: ...


class QgsBookmark(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsBookmark') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def __repr__(self) -> typing.Any: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    @staticmethod
    def fromXml(element: QtXml.QDomElement, doc: QtXml.QDomDocument) -> 'QgsBookmark': ...
    def setRotation(self, rotation: float) -> None: ...
    def rotation(self) -> float: ...
    def setExtent(self, extent: 'QgsReferencedRectangle') -> None: ...
    def extent(self) -> 'QgsReferencedRectangle': ...
    def setGroup(self, group: str|None) -> None: ...
    def group(self) -> str: ...
    def setName(self, name: str|None) -> None: ...
    def name(self) -> str: ...
    def setId(self, id: str|None) -> None: ...
    def id(self) -> str: ...


class QgsBookmarkManager(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    bookmarkChanged: typing.ClassVar[QtCore.pyqtSignal]
    bookmarkAboutToBeRemoved: typing.ClassVar[QtCore.pyqtSignal]
    bookmarkRemoved: typing.ClassVar[QtCore.pyqtSignal]
    bookmarkAdded: typing.ClassVar[QtCore.pyqtSignal]
    bookmarkAboutToBeAdded: typing.ClassVar[QtCore.pyqtSignal]
    def importFromFile(self, path: str|None) -> bool: ...
    @staticmethod
    def exportToFile(path: str|None, managers: collections.abc.Iterable['QgsBookmarkManager'], group: str|None = ...) -> bool: ...
    def moveBookmark(self, id: str|None, destination: 'QgsBookmarkManager|None') -> bool: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    def readXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument) -> bool: ...
    def bookmarksByGroup(self, group: str|None) -> list[QgsBookmark]: ...
    def bookmarkById(self, id: str|None) -> QgsBookmark: ...
    def bookmarks(self) -> list[QgsBookmark]: ...
    def renameGroup(self, oldName: str|None, newName: str|None) -> None: ...
    def groups(self) -> list[str]: ...
    def clear(self) -> None: ...
    def updateBookmark(self, bookmark: QgsBookmark) -> bool: ...
    def removeBookmark(self, id: str|None) -> bool: ...
    def addBookmark(self, bookmark: QgsBookmark) -> typing.Tuple[str, bool]: ...
    def initialize(self, filePath: str|None) -> None: ...
    @staticmethod
    def createProjectBasedManager(project: 'QgsProject|None') -> 'QgsBookmarkManager|None': ...


class QgsBookmarkManagerModel(QtCore.QAbstractTableModel):

    class Columns(enum.IntEnum):
        ColumnName = ... # type: QgsBookmarkManagerModel.Columns
        ColumnGroup = ... # type: QgsBookmarkManagerModel.Columns
        ColumnXMin = ... # type: QgsBookmarkManagerModel.Columns
        ColumnYMin = ... # type: QgsBookmarkManagerModel.Columns
        ColumnXMax = ... # type: QgsBookmarkManagerModel.Columns
        ColumnYMax = ... # type: QgsBookmarkManagerModel.Columns
        ColumnRotation = ... # type: QgsBookmarkManagerModel.Columns
        ColumnCrs = ... # type: QgsBookmarkManagerModel.Columns
        ColumnStore = ... # type: QgsBookmarkManagerModel.Columns

    class CustomRole(enum.IntEnum):
        Extent = ... # type: QgsBookmarkManagerModel.CustomRole
        Name = ... # type: QgsBookmarkManagerModel.CustomRole
        Id = ... # type: QgsBookmarkManagerModel.CustomRole
        Group = ... # type: QgsBookmarkManagerModel.CustomRole
        Rotation = ... # type: QgsBookmarkManagerModel.CustomRole

    def __init__(self, manager: QgsBookmarkManager|None, projectManager: QgsBookmarkManager|None = ..., parent: QtCore.QObject|None = ...) -> None: ...

    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlag: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...


class QgsBookmarkManagerProxyModel(QtCore.QSortFilterProxyModel):

    def __init__(self, manager: QgsBookmarkManager|None, projectManager: QgsBookmarkManager|None = ..., parent: QtCore.QObject|None = ...) -> None: ...


class QgsAbstractFeatureIterator(PyQt6.sip.wrapper):

    class RequestToSourceCrsResult(enum.IntEnum):
        Success = ... # type: QgsAbstractFeatureIterator.RequestToSourceCrsResult
        DistanceWithinMustBeCheckedManually = ... # type: QgsAbstractFeatureIterator.RequestToSourceCrsResult

    class CompileStatus(enum.IntEnum):
        NoCompilation = ... # type: QgsAbstractFeatureIterator.CompileStatus
        PartiallyCompiled = ... # type: QgsAbstractFeatureIterator.CompileStatus
        Compiled = ... # type: QgsAbstractFeatureIterator.CompileStatus

    @typing.overload
    def __init__(self, request: 'QgsFeatureRequest') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractFeatureIterator') -> None: ...

    def prepareSimplification(self, simplifyMethod: 'QgsSimplifyMethod') -> bool: ...
    def deref(self) -> None: ...
    def ref(self) -> None: ...
    def updateRequestToSourceCrs(self, request: 'QgsFeatureRequest', transform: 'QgsCoordinateTransform') -> 'QgsAbstractFeatureIterator.RequestToSourceCrsResult': ...
    def filterRectToSourceCrs(self, transform: 'QgsCoordinateTransform') -> 'QgsRectangle': ...
    def geometryToDestinationCrs(self, feature: 'QgsFeature', transform: 'QgsCoordinateTransform') -> None: ...
    def nextFeatureFilterFids(self, f: 'QgsFeature') -> bool: ...
    def nextFeatureFilterExpression(self, f: 'QgsFeature') -> bool: ...
    def fetchFeature(self, f: 'QgsFeature') -> bool: ...
    def compileFailed(self) -> bool: ...
    def isValid(self) -> bool: ...
    def compileStatus(self) -> 'QgsAbstractFeatureIterator.CompileStatus': ...
    def close(self) -> bool: ...
    def rewind(self) -> bool: ...
    def nextFeature(self, f: 'QgsFeature') -> bool: ...


class QgsCachedFeatureIterator(QgsAbstractFeatureIterator):

    def __init__(self, vlCache: 'QgsVectorLayerCache|None', featureRequest: 'QgsFeatureRequest') -> None: ...

    def nextFeatureFilterFids(self, f: 'QgsFeature') -> bool: ...
    def fetchFeature(self, f: 'QgsFeature') -> bool: ...
    def close(self) -> bool: ...
    def rewind(self) -> bool: ...


class QgsCachedFeatureWriterIterator(QgsAbstractFeatureIterator):

    @typing.overload
    def __init__(self, vlCache: 'QgsVectorLayerCache|None', featureRequest: 'QgsFeatureRequest') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCachedFeatureWriterIterator') -> None: ...

    def fetchFeature(self, f: 'QgsFeature') -> bool: ...
    def close(self) -> bool: ...
    def rewind(self) -> bool: ...


class QgsAbstractCacheIndex(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractCacheIndex') -> None: ...

    def getCacheIterator(self, featureIterator: 'QgsFeatureIterator', featureRequest: 'QgsFeatureRequest') -> bool: ...
    def requestCompleted(self, featureRequest: 'QgsFeatureRequest', fids: typing.Any) -> None: ...
    def flush(self) -> None: ...
    def flushFeature(self, fid: int) -> None: ...


class QgsCacheIndexFeatureId(QgsAbstractCacheIndex):

    @typing.overload
    def __init__(self, a0: 'QgsVectorLayerCache|None') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCacheIndexFeatureId') -> None: ...

    def getCacheIterator(self, featureIterator: 'QgsFeatureIterator', featureRequest: 'QgsFeatureRequest') -> bool: ...
    def requestCompleted(self, featureRequest: 'QgsFeatureRequest', fids: typing.Any) -> None: ...
    def flush(self) -> None: ...
    def flushFeature(self, fid: int) -> None: ...


class QgsCadUtils(PyQt6.sip.wrapper):

    class AlignMapPointConstraint(PyQt6.sip.wrapper):

        locked = ... # type: bool
        relative = ... # type: bool
        value = ... # type: float

        @typing.overload
        def __init__(self, locked: bool = ..., relative: bool = ..., value: float = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsCadUtils.AlignMapPointConstraint') -> None: ...

    class AlignMapPointOutput(PyQt6.sip.wrapper):

        edgeMatch = ... # type: 'QgsPointLocator.Match'
        finalMapPoint = ... # type: 'QgsPointXY'
        snapMatch = ... # type: 'QgsPointLocator.Match'
        softLockCommonAngle = ... # type: float
        softLockLineExtension = ... # type: Qgis.LineExtensionSide
        softLockX = ... # type: float
        softLockY = ... # type: float
        valid = ... # type: bool

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsCadUtils.AlignMapPointOutput') -> None: ...

    class AlignMapPointContext(PyQt6.sip.wrapper):

        angleConstraint = ... # type: 'QgsCadUtils.AlignMapPointConstraint'
        commonAngleConstraint = ... # type: 'QgsCadUtils.AlignMapPointConstraint'
        distanceConstraint = ... # type: 'QgsCadUtils.AlignMapPointConstraint'
        lineExtensionConstraint = ... # type: 'QgsCadUtils.AlignMapPointConstraint'
        mConstraint = ... # type: 'QgsCadUtils.AlignMapPointConstraint'
        mapUnitsPerPixel = ... # type: float
        snappingToFeaturesOverridesCommonAngle = ... # type: bool
        snappingUtils = ... # type: 'QgsSnappingUtils'
        xConstraint = ... # type: 'QgsCadUtils.AlignMapPointConstraint'
        xyVertexConstraint = ... # type: 'QgsCadUtils.AlignMapPointConstraint'
        yConstraint = ... # type: 'QgsCadUtils.AlignMapPointConstraint'
        zConstraint = ... # type: 'QgsCadUtils.AlignMapPointConstraint'

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsCadUtils.AlignMapPointContext') -> None: ...

        def _cadPointList(self) -> list['QgsPointXY']: ...
        def _setCadPointList(self, list: collections.abc.Iterable['QgsPointXY']) -> None: ...
        def cadPoint(self, index: int) -> 'QgsPoint': ...
        def setCadPoint(self, index: int, point: 'QgsPoint') -> None: ...
        def setCadPoints(self, points: collections.abc.Iterable['QgsPoint']) -> None: ...
        def cadPoints(self) -> list['QgsPoint']: ...
        @property
        def cadPointList(self) -> list['QgsPointXY']: ...
        @cadPointList.setter
        def cadPointList(self, list: collections.abc.Iterable['QgsPointXY']) -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCadUtils') -> None: ...

    @staticmethod
    def alignMapPoint(originalMapPoint: 'QgsPointXY', ctx: 'QgsCadUtils.AlignMapPointContext') -> 'QgsCadUtils.AlignMapPointOutput': ...


class QgsClipper(PyQt6.sip.wrapper):

    class Boundary(enum.IntEnum):
        XMax = ... # type: QgsClipper.Boundary
        XMin = ... # type: QgsClipper.Boundary
        YMax = ... # type: QgsClipper.Boundary
        YMin = ... # type: QgsClipper.Boundary
        ZMax = ... # type: QgsClipper.Boundary
        ZMin = ... # type: QgsClipper.Boundary

    MAX_X = ... # type: float
    MAX_Y = ... # type: float
    MIN_X = ... # type: float
    MIN_Y = ... # type: float

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClipper') -> None: ...

    @staticmethod
    def clipLineSegment(left: float, right: float, bottom: float, top: float, x0: float, y0: float, x1: float, y1: float) -> typing.Tuple[bool, float, float, float, float]: ...
    @typing.overload
    @staticmethod
    def clippedLine(curve: 'QgsCurve', clipExtent: 'QgsRectangle') -> QtGui.QPolygonF: ...
    @typing.overload
    @staticmethod
    def clippedLine(curve: QtGui.QPolygonF, clipExtent: 'QgsRectangle') -> QtGui.QPolygonF: ...
    @staticmethod
    def trimPolygon(pts: QtGui.QPolygonF, clipRect: 'QgsRectangle') -> None: ...
    @staticmethod
    def trimFeature(x: collections.abc.Iterable[float], y: collections.abc.Iterable[float], shapeOpen: bool) -> None: ...


class QgsCommandLineUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCommandLineUtils') -> None: ...

    @staticmethod
    def allVersions() -> str: ...


class QgsColorRamp(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsColorRamp') -> None: ...

    @staticmethod
    def rampTypes() -> list[tuple[str, str]]: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def clone(self) -> 'QgsColorRamp|None': ...
    def invert(self) -> None: ...
    def type(self) -> str: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def value(self, index: int) -> float: ...
    def count(self) -> int: ...


class QgsGradientStop(PyQt6.sip.wrapper):

    color = ... # type: QtGui.QColor|QtCore.Qt.GlobalColor|int
    offset = ... # type: float

    @typing.overload
    def __init__(self, offset: float, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGradientStop') -> None: ...

    def setDirection(self, direction: Qgis.AngularDirection) -> None: ...
    def direction(self) -> Qgis.AngularDirection: ...
    def setColorSpec(self, spec: QtGui.QColor.Spec) -> None: ...
    def colorSpec(self) -> QtGui.QColor.Spec: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsGradientColorRamp(QgsColorRamp):

    @typing.overload
    def __init__(self, color1: QtGui.QColor|QtCore.Qt.GlobalColor|int = ..., color2: QtGui.QColor|QtCore.Qt.GlobalColor|int = ..., discrete: bool = ..., stops: collections.abc.Iterable[QgsGradientStop] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGradientColorRamp') -> None: ...

    def setDirection(self, direction: Qgis.AngularDirection) -> None: ...
    def direction(self) -> Qgis.AngularDirection: ...
    def setColorSpec(self, spec: QtGui.QColor.Spec) -> None: ...
    def colorSpec(self) -> QtGui.QColor.Spec: ...
    def addStopsToGradient(self, gradient: QtGui.QGradient|None, opacity: float = ...) -> None: ...
    def setInfo(self, info: dict[str|None, str|None]) -> None: ...
    def info(self) -> dict[str, str]: ...
    def stops(self) -> list[QgsGradientStop]: ...
    def setStops(self, stops: collections.abc.Iterable[QgsGradientStop]) -> None: ...
    def convertToDiscrete(self, discrete: bool) -> None: ...
    def setDiscrete(self, discrete: bool) -> None: ...
    def isDiscrete(self) -> bool: ...
    def setColor2(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setColor1(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def color2(self) -> QtGui.QColor: ...
    def color1(self) -> QtGui.QColor: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def clone(self) -> 'QgsGradientColorRamp|None': ...
    def invert(self) -> None: ...
    def type(self) -> str: ...
    @staticmethod
    def typeString() -> str: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def value(self, index: int) -> float: ...
    def count(self) -> int: ...
    @staticmethod
    def create(properties: dict[str|None, typing.Any] = ...) -> QgsColorRamp|None: ...


class QgsLimitedRandomColorRamp(QgsColorRamp):

    @typing.overload
    def __init__(self, count: int = ..., hueMin: int = ..., hueMax: int = ..., satMin: int = ..., satMax: int = ..., valMin: int = ..., valMax: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLimitedRandomColorRamp') -> None: ...

    def setValMax(self, val: int) -> None: ...
    def setValMin(self, val: int) -> None: ...
    def setSatMax(self, val: int) -> None: ...
    def setSatMin(self, val: int) -> None: ...
    def setHueMax(self, val: int) -> None: ...
    def setHueMin(self, val: int) -> None: ...
    def setCount(self, val: int) -> None: ...
    def valMax(self) -> int: ...
    def valMin(self) -> int: ...
    def satMax(self) -> int: ...
    def satMin(self) -> int: ...
    def hueMax(self) -> int: ...
    def hueMin(self) -> int: ...
    def updateColors(self) -> None: ...
    @staticmethod
    def randomColors(count: int, hueMax: int = ..., hueMin: int = ..., satMax: int = ..., satMin: int = ..., valMax: int = ..., valMin: int = ...) -> list[QtGui.QColor]: ...
    def count(self) -> int: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def clone(self) -> 'QgsLimitedRandomColorRamp|None': ...
    def type(self) -> str: ...
    @staticmethod
    def typeString() -> str: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def value(self, index: int) -> float: ...
    @staticmethod
    def create(properties: dict[str|None, typing.Any] = ...) -> QgsColorRamp|None: ...


class QgsRandomColorRamp(QgsColorRamp):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRandomColorRamp') -> None: ...

    def properties(self) -> dict[str, typing.Any]: ...
    def clone(self) -> 'QgsRandomColorRamp|None': ...
    def type(self) -> str: ...
    @staticmethod
    def typeString() -> str: ...
    def setTotalColorCount(self, colorCount: int) -> None: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def value(self, index: int) -> float: ...
    def count(self) -> int: ...


class QgsColorScheme(PyQt6.sip.wrapper):

    class SchemeFlag(enum.IntEnum):
        ShowInColorDialog = ... # type: QgsColorScheme.SchemeFlag
        ShowInColorButtonMenu = ... # type: QgsColorScheme.SchemeFlag
        ShowInAllContexts = ... # type: QgsColorScheme.SchemeFlag

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsColorScheme') -> None: ...

    def clone(self) -> 'QgsColorScheme|None': ...
    def setColors(self, colors: collections.abc.Iterable[tuple[QtGui.QColor|QtCore.Qt.GlobalColor|int, str|None]], context: str|None = ..., baseColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> bool: ...
    def isEditable(self) -> bool: ...
    def fetchColors(self, context: str|None = ..., baseColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> list[tuple[QtGui.QColor, str]]: ...
    def flags(self) -> 'QgsColorScheme.SchemeFlag': ...
    def schemeName(self) -> str: ...


class QgsPresetSchemeColorRamp(QgsColorRamp, QgsColorScheme):

    @typing.overload
    def __init__(self, colors: collections.abc.Iterable[QtGui.QColor|QtCore.Qt.GlobalColor|int] = ...) -> None: ...
    @typing.overload
    def __init__(self, colors: collections.abc.Iterable[tuple[QtGui.QColor|QtCore.Qt.GlobalColor|int, str|None]]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPresetSchemeColorRamp') -> None: ...

    def isEditable(self) -> bool: ...
    def fetchColors(self, context: str|None = ..., baseColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> list[tuple[QtGui.QColor, str]]: ...
    def schemeName(self) -> str: ...
    def count(self) -> int: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def clone(self) -> 'QgsPresetSchemeColorRamp|None': ...
    def invert(self) -> None: ...
    def type(self) -> str: ...
    @staticmethod
    def typeString() -> str: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def value(self, index: int) -> float: ...
    def colors(self) -> list[QtGui.QColor]: ...
    def setColors(self, colors: collections.abc.Iterable[tuple[QtGui.QColor|QtCore.Qt.GlobalColor|int, str|None]], a1: str|None = ..., a2: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> bool: ...
    @staticmethod
    def create(properties: dict[str|None, typing.Any] = ...) -> QgsColorRamp|None: ...


class QgsColorBrewerColorRamp(QgsColorRamp):

    @typing.overload
    def __init__(self, schemeName: str|None = ..., colors: int = ..., inverted: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsColorBrewerColorRamp') -> None: ...

    def loadPalette(self) -> None: ...
    @staticmethod
    def listSchemeVariants(schemeName: str|None) -> list[int]: ...
    @staticmethod
    def listSchemeNames() -> list[str]: ...
    def setColors(self, colors: int) -> None: ...
    def setSchemeName(self, schemeName: str|None) -> None: ...
    def colors(self) -> int: ...
    def schemeName(self) -> str: ...
    def count(self) -> int: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def clone(self) -> 'QgsColorBrewerColorRamp|None': ...
    def invert(self) -> None: ...
    def type(self) -> str: ...
    @staticmethod
    def typeString() -> str: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def value(self, index: int) -> float: ...
    @staticmethod
    def create(properties: dict[str|None, typing.Any] = ...) -> QgsColorRamp|None: ...


class QgsCptCityColorRamp(QgsGradientColorRamp):

    @typing.overload
    def __init__(self, schemeName: str|None = ..., variantName: str|None = ..., inverted: bool = ..., doLoadFile: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, schemeName: str|None, variantList: collections.abc.Iterable[str|None], variantName: str|None = ..., inverted: bool = ..., doLoadFile: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCptCityColorRamp') -> None: ...

    def copyingInfo(self) -> dict[str, str]: ...
    def descFileName(self) -> str: ...
    def copyingFileName(self) -> str: ...
    def fileLoaded(self) -> bool: ...
    def loadFile(self) -> bool: ...
    def fileName(self) -> str: ...
    def hasMultiStops(self) -> bool: ...
    def loadPalette(self) -> None: ...
    def setName(self, schemeName: str|None, variantName: str|None = ..., variantList: collections.abc.Iterable[str|None] = ...) -> None: ...
    def setVariantList(self, variantList: collections.abc.Iterable[str|None]) -> None: ...
    def setVariantName(self, variantName: str|None) -> None: ...
    def setSchemeName(self, schemeName: str|None) -> None: ...
    def variantList(self) -> list[str]: ...
    def variantName(self) -> str: ...
    def schemeName(self) -> str: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def cloneGradientRamp(self) -> QgsGradientColorRamp|None: ...
    def copy(self, other: 'QgsCptCityColorRamp|None') -> None: ...
    def clone(self) -> 'QgsCptCityColorRamp|None': ...
    def invert(self) -> None: ...
    def type(self) -> str: ...
    @staticmethod
    def typeString() -> str: ...
    @staticmethod
    def create(properties: dict[str|None, typing.Any] = ...) -> QgsColorRamp|None: ...


class QgsGplColorScheme(QgsColorScheme):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGplColorScheme') -> None: ...

    def gplFilePath(self) -> str: ...
    def setColors(self, colors: collections.abc.Iterable[tuple[QtGui.QColor|QtCore.Qt.GlobalColor|int, str|None]], context: str|None = ..., baseColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> bool: ...
    def fetchColors(self, context: str|None = ..., baseColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> list[tuple[QtGui.QColor, str]]: ...


class QgsUserColorScheme(QgsGplColorScheme):

    @typing.overload
    def __init__(self, filename: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsUserColorScheme') -> None: ...

    def gplFilePath(self) -> str: ...
    def setShowSchemeInMenu(self, show: bool) -> None: ...
    def erase(self) -> bool: ...
    def setName(self, name: str|None) -> None: ...
    def flags(self) -> QgsColorScheme.SchemeFlag: ...
    def isEditable(self) -> bool: ...
    def clone(self) -> 'QgsUserColorScheme|None': ...
    def schemeName(self) -> str: ...


class QgsRecentColorScheme(QgsColorScheme):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRecentColorScheme') -> None: ...

    @staticmethod
    def lastUsedColor() -> QtGui.QColor: ...
    @staticmethod
    def addRecentColor(color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def clone(self) -> 'QgsRecentColorScheme|None': ...
    def fetchColors(self, context: str|None = ..., baseColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> list[tuple[QtGui.QColor, str]]: ...
    def flags(self) -> QgsColorScheme.SchemeFlag: ...
    def schemeName(self) -> str: ...


class QgsCustomColorScheme(QgsColorScheme):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCustomColorScheme') -> None: ...

    def clone(self) -> 'QgsCustomColorScheme|None': ...
    def setColors(self, colors: collections.abc.Iterable[tuple[QtGui.QColor|QtCore.Qt.GlobalColor|int, str|None]], context: str|None = ..., baseColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> bool: ...
    def isEditable(self) -> bool: ...
    def fetchColors(self, context: str|None = ..., baseColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> list[tuple[QtGui.QColor, str]]: ...
    def flags(self) -> QgsColorScheme.SchemeFlag: ...
    def schemeName(self) -> str: ...


class QgsProjectColorScheme(QgsColorScheme):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsProjectColorScheme') -> None: ...

    def clone(self) -> 'QgsProjectColorScheme|None': ...
    def setColors(self, colors: collections.abc.Iterable[tuple[QtGui.QColor|QtCore.Qt.GlobalColor|int, str|None]], context: str|None = ..., baseColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> bool: ...
    def isEditable(self) -> bool: ...
    def fetchColors(self, context: str|None = ..., baseColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> list[tuple[QtGui.QColor, str]]: ...
    def flags(self) -> QgsColorScheme.SchemeFlag: ...
    def schemeName(self) -> str: ...


class QgsColorSchemeRegistry(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsColorSchemeRegistry') -> None: ...

    def fetchRandomStyleColor(self) -> QtGui.QColor: ...
    def randomStyleColorScheme(self) -> QgsColorScheme|None: ...
    def setRandomStyleColorScheme(self, scheme: QgsColorScheme|None) -> None: ...
    @typing.overload
    def schemes(self) -> list[QgsColorScheme]: ...
    @typing.overload
    def schemes(self, flag: QgsColorScheme.SchemeFlag) -> list[QgsColorScheme]: ...
    def removeColorScheme(self, scheme: QgsColorScheme|None) -> bool: ...
    def addColorScheme(self, scheme: QgsColorScheme|None) -> None: ...
    def addUserSchemes(self) -> None: ...
    def initStyleScheme(self) -> None: ...
    def addDefaultSchemes(self) -> None: ...
    def populateFromInstance(self) -> None: ...


class QgsColorUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsColorUtils') -> None: ...

    @staticmethod
    def saveIccProfile(colorSpace: QtGui.QColorSpace, iccProfileFilePath: str|None) -> str: ...
    @staticmethod
    def iccProfile(iccProfileFilePath: str|None) -> typing.Tuple[QtGui.QColorSpace, str]: ...
    @staticmethod
    def colorFromString(string: str|None) -> QtGui.QColor: ...
    @staticmethod
    def colorToString(color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> str: ...
    @staticmethod
    def readXml(element: QtXml.QDomElement, identifier: str|None, context: 'QgsReadWriteContext') -> QtGui.QColor: ...
    @staticmethod
    def writeXml(color: QtGui.QColor|QtCore.Qt.GlobalColor|int, identifier: str|None, document: QtXml.QDomDocument, element: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...


class QgsConditionalLayerStyles(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    changed: typing.ClassVar[QtCore.pyqtSignal]
    def rulesNeedGeometry(self) -> bool: ...
    def writeXml(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> bool: ...
    def readXml(self, node: QtXml.QDomNode, context: 'QgsReadWriteContext') -> bool: ...
    def fieldStyles(self, fieldName: str|None) -> list['QgsConditionalStyle']: ...
    def setFieldStyles(self, fieldName: str|None, styles: collections.abc.Iterable['QgsConditionalStyle']) -> None: ...
    def constraintFailureStyles(self, strength: 'QgsFieldConstraints.ConstraintStrength') -> 'QgsConditionalStyle': ...
    def setRowStyles(self, styles: collections.abc.Iterable['QgsConditionalStyle']) -> None: ...
    def rowStyles(self) -> list['QgsConditionalStyle']: ...


class QgsConditionalStyle(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsConditionalStyle') -> None: ...
    @typing.overload
    def __init__(self, rule: str|None) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def writeXml(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> bool: ...
    def readXml(self, node: QtXml.QDomNode, context: 'QgsReadWriteContext') -> bool: ...
    @staticmethod
    def compressStyles(styles: collections.abc.Iterable['QgsConditionalStyle']) -> 'QgsConditionalStyle': ...
    @staticmethod
    def matchingConditionalStyle(styles: collections.abc.Iterable['QgsConditionalStyle'], value: typing.Any, context: 'QgsExpressionContext') -> 'QgsConditionalStyle': ...
    @staticmethod
    def matchingConditionalStyles(styles: collections.abc.Iterable['QgsConditionalStyle'], value: typing.Any, context: 'QgsExpressionContext') -> list['QgsConditionalStyle']: ...
    def isValid(self) -> bool: ...
    def rule(self) -> str: ...
    def font(self) -> QtGui.QFont: ...
    def validBackgroundColor(self) -> bool: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def validTextColor(self) -> bool: ...
    def textColor(self) -> QtGui.QColor: ...
    def symbol(self) -> 'QgsSymbol|None': ...
    def icon(self) -> QtGui.QPixmap: ...
    def name(self) -> str: ...
    def displayText(self) -> str: ...
    def setSymbol(self, value: 'QgsSymbol|None') -> None: ...
    def setFont(self, value: QtGui.QFont) -> None: ...
    def setTextColor(self, value: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setBackgroundColor(self, value: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setRule(self, value: str|None) -> None: ...
    def setName(self, value: str|None) -> None: ...
    def renderPreview(self, size: QtCore.QSize = ...) -> QtGui.QPixmap: ...
    def matches(self, value: typing.Any, context: 'QgsExpressionContext') -> bool: ...


class QgsConnectionRegistry(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def createConnection(self, name: str|None) -> 'QgsAbstractProviderConnection|None': ...


class QgsCoordinateFormatter(PyQt6.sip.wrapper):

    class FormatFlag(enum.IntEnum):
        FlagDegreesUseStringSuffix = ... # type: QgsCoordinateFormatter.FormatFlag
        FlagDegreesPadMinutesSeconds = ... # type: QgsCoordinateFormatter.FormatFlag

    class Format(enum.IntEnum):
        FormatPair = ... # type: QgsCoordinateFormatter.Format
        FormatDegreesMinutesSeconds = ... # type: QgsCoordinateFormatter.Format
        FormatDegreesMinutes = ... # type: QgsCoordinateFormatter.Format
        FormatDecimalDegrees = ... # type: QgsCoordinateFormatter.Format

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCoordinateFormatter') -> None: ...

    @staticmethod
    def separator() -> QtCore.QChar: ...
    @staticmethod
    def asPair(x: float, y: float, precision: int = ..., order: Qgis.CoordinateOrder = ...) -> str: ...
    @staticmethod
    def format(point: 'QgsPointXY', format: 'QgsCoordinateFormatter.Format', precision: int = ..., flags: 'QgsCoordinateFormatter.FormatFlag' = ..., order: Qgis.CoordinateOrder = ...) -> str: ...
    @staticmethod
    def formatY(y: float, format: 'QgsCoordinateFormatter.Format', precision: int = ..., flags: 'QgsCoordinateFormatter.FormatFlag' = ...) -> str: ...
    @staticmethod
    def formatX(x: float, format: 'QgsCoordinateFormatter.Format', precision: int = ..., flags: 'QgsCoordinateFormatter.FormatFlag' = ...) -> str: ...


class QgsTask(QtCore.QObject):

    class SubTaskDependency(enum.IntEnum):
        SubTaskIndependent = ... # type: QgsTask.SubTaskDependency
        ParentDependsOnSubTask = ... # type: QgsTask.SubTaskDependency

    class Flag(enum.IntEnum):
        CanCancel = ... # type: QgsTask.Flag
        CancelWithoutPrompt = ... # type: QgsTask.Flag
        Hidden = ... # type: QgsTask.Flag
        Silent = ... # type: QgsTask.Flag
        AllFlags = ... # type: QgsTask.Flag

    class TaskStatus(enum.IntEnum):
        Queued = ... # type: QgsTask.TaskStatus
        OnHold = ... # type: QgsTask.TaskStatus
        Running = ... # type: QgsTask.TaskStatus
        Complete = ... # type: QgsTask.TaskStatus
        Terminated = ... # type: QgsTask.TaskStatus

    def __init__(self, description: str|None = ..., flags: 'QgsTask.Flag' = ...) -> None: ...

    def setProgress(self, progress: float) -> None: ...
    def isCanceled(self) -> bool: ...
    def finished(self, result: bool) -> None: ...
    def run(self) -> bool: ...
    taskTerminated: typing.ClassVar[QtCore.pyqtSignal]
    taskCompleted: typing.ClassVar[QtCore.pyqtSignal]
    begun: typing.ClassVar[QtCore.pyqtSignal]
    statusChanged: typing.ClassVar[QtCore.pyqtSignal]
    progressChanged: typing.ClassVar[QtCore.pyqtSignal]
    def waitForFinished(self, timeout: int = ...) -> bool: ...
    def dependentLayers(self) -> list[QgsMapLayer]: ...
    def setDependentLayers(self, dependentLayers: collections.abc.Iterable[QgsMapLayer]) -> None: ...
    def addSubTask(self, subTask: 'QgsTask|None', dependencies: collections.abc.Iterable['QgsTask'] = ..., subTaskDependency: 'QgsTask.SubTaskDependency' = ...) -> None: ...
    def unhold(self) -> None: ...
    def hold(self) -> None: ...
    def cancel(self) -> None: ...
    def elapsedTime(self) -> int: ...
    def progress(self) -> float: ...
    def description(self) -> str: ...
    def status(self) -> 'QgsTask.TaskStatus': ...
    def isActive(self) -> bool: ...
    def canCancel(self) -> bool: ...
    def setDescription(self, description: str|None) -> None: ...
    def flags(self) -> 'QgsTask.Flag': ...


class QgsCopyFileTask(QgsTask):

    def __init__(self, source: str|None, destination: str|None) -> None: ...

    def destination(self) -> str: ...
    def errorString(self) -> str: ...
    def run(self) -> bool: ...


class QgsCredentials(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def setInstance(self, instance: 'QgsCredentials|None') -> None: ...
    def requestMasterPassword(self, password: str|None, stored: bool = ...) -> typing.Tuple[bool, str]: ...
    def request(self, realm: str|None, username: str|None, password: str|None, message: str|None = ...) -> typing.Tuple[bool, str, str]: ...
    def mutex(self) -> QtCore.QMutex|None: ...
    def unlock(self) -> None: ...
    def lock(self) -> None: ...
    @staticmethod
    def instance() -> 'QgsCredentials|None': ...
    def getMasterPassword(self, password: str|None, stored: bool = ...) -> typing.Tuple[bool, str]: ...
    def put(self, realm: str|None, username: str|None, password: str|None) -> None: ...
    def get(self, realm: str|None, username: str|None, password: str|None, message: str|None = ..., requestCredentials: bool = ...) -> typing.Tuple[bool, str, str]: ...


class QgsCredentialsNone(QtCore.QObject, QgsCredentials):

    def __init__(self) -> None: ...

    def requestMasterPassword(self, password: str|None, stored: bool = ...) -> typing.Tuple[bool, str]: ...
    def request(self, realm: str|None, username: str|None, password: str|None, message: str|None = ...) -> typing.Tuple[bool, str, str]: ...
    destroyed: typing.ClassVar[QtCore.pyqtSignal]


class QgsCredentialsConsole(QtCore.QObject, QgsCredentials):

    def __init__(self) -> None: ...

    def requestMasterPassword(self, password: str|None, stored: bool = ...) -> typing.Tuple[bool, str]: ...
    def request(self, realm: str|None, username: str|None, password: str|None, message: str|None = ...) -> typing.Tuple[bool, str, str]: ...
    destroyed: typing.ClassVar[QtCore.pyqtSignal]


class QgsDartMeasurement(PyQt6.sip.wrapper):

    class Type(enum.IntEnum):
        Text = ... # type: QgsDartMeasurement.Type
        ImagePng = ... # type: QgsDartMeasurement.Type
        Integer = ... # type: QgsDartMeasurement.Type

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name: str|None, type: 'QgsDartMeasurement.Type', value: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDartMeasurement') -> None: ...

    @staticmethod
    def typeToString(type: 'QgsDartMeasurement.Type') -> str: ...
    def send(self) -> None: ...
    def toString(self) -> str: ...


class QgsDatabaseSchemaModel(QtCore.QAbstractItemModel):

    class CustomRole(enum.IntEnum):
        Empty = ... # type: QgsDatabaseSchemaModel.CustomRole

    @typing.overload
    def __init__(self, provider: str|None, connection: str|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, connection: 'QgsAbstractDatabaseProviderConnection|None', parent: QtCore.QObject|None = ...) -> None: ...

    def refresh(self) -> None: ...
    def allowEmptySchema(self) -> bool: ...
    def setAllowEmptySchema(self, allowEmpty: bool) -> None: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...


class QgsDatabaseTableModel(QtCore.QAbstractItemModel):

    class CustomRole(enum.IntEnum):
        TableName = ... # type: QgsDatabaseTableModel.CustomRole
        Schema = ... # type: QgsDatabaseTableModel.CustomRole
        TableFlags = ... # type: QgsDatabaseTableModel.CustomRole
        Comment = ... # type: QgsDatabaseTableModel.CustomRole
        CustomInfo = ... # type: QgsDatabaseTableModel.CustomRole
        WkbType = ... # type: QgsDatabaseTableModel.CustomRole
        Crs = ... # type: QgsDatabaseTableModel.CustomRole
        Empty = ... # type: QgsDatabaseTableModel.CustomRole

    @typing.overload
    def __init__(self, provider: str|None, connection: str|None, schema: str|None = ..., parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, connection: 'QgsAbstractDatabaseProviderConnection|None', schema: str|None = ..., parent: QtCore.QObject|None = ...) -> None: ...

    def refresh(self) -> None: ...
    def allowEmptyTable(self) -> bool: ...
    def setAllowEmptyTable(self, allowEmpty: bool) -> None: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...


class QgsDataDefinedSizeLegend(PyQt6.sip.wrapper):

    class VerticalAlignment(enum.IntEnum):
        AlignCenter = ... # type: QgsDataDefinedSizeLegend.VerticalAlignment
        AlignBottom = ... # type: QgsDataDefinedSizeLegend.VerticalAlignment

    class LegendType(enum.IntEnum):
        LegendSeparated = ... # type: QgsDataDefinedSizeLegend.LegendType
        LegendCollapsed = ... # type: QgsDataDefinedSizeLegend.LegendType

    class SizeClass(PyQt6.sip.wrapper):

        label = ... # type: str|None
        size = ... # type: float

        @typing.overload
        def __init__(self, size: float, label: str|None) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsDataDefinedSizeLegend.SizeClass') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsDataDefinedSizeLegend') -> None: ...

    def writeXml(self, elem: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    @staticmethod
    def readXml(elem: QtXml.QDomElement, context: 'QgsReadWriteContext') -> 'QgsDataDefinedSizeLegend|None': ...
    def collapsedLegendImage(self, context: 'QgsRenderContext', backgroundColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ..., paddingMM: float = ...) -> QtGui.QImage: ...
    def drawCollapsedLegend(self, context: 'QgsRenderContext') -> typing.Tuple[QtCore.QSizeF|None, float]: ...
    def legendSymbolList(self) -> list['QgsLegendSymbolItem']: ...
    def updateFromSymbolAndProperty(self, symbol: 'QgsMarkerSymbol|None', ddSize: 'QgsProperty') -> None: ...
    def textAlignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def setTextAlignment(self, flag: QtCore.Qt.AlignmentFlag) -> None: ...
    def textColor(self) -> QtGui.QColor: ...
    def setTextColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def verticalAlignment(self) -> 'QgsDataDefinedSizeLegend.VerticalAlignment': ...
    def setVerticalAlignment(self, vAlign: 'QgsDataDefinedSizeLegend.VerticalAlignment') -> None: ...
    def title(self) -> str: ...
    def setTitle(self, title: str|None) -> None: ...
    def classes(self) -> list['QgsDataDefinedSizeLegend.SizeClass']: ...
    def setClasses(self, classes: collections.abc.Iterable['QgsDataDefinedSizeLegend.SizeClass']) -> None: ...
    def sizeScaleTransformer(self) -> 'QgsSizeScaleTransformer|None': ...
    def setSizeScaleTransformer(self, transformer: 'QgsSizeScaleTransformer|None') -> None: ...
    def lineSymbol(self) -> 'QgsLineSymbol|None': ...
    def setLineSymbol(self, symbol: 'QgsLineSymbol|None') -> None: ...
    def symbol(self) -> 'QgsMarkerSymbol|None': ...
    def setSymbol(self, symbol: 'QgsMarkerSymbol|None') -> None: ...
    def legendType(self) -> 'QgsDataDefinedSizeLegend.LegendType': ...
    def setLegendType(self, type: 'QgsDataDefinedSizeLegend.LegendType') -> None: ...


class QgsDataProviderElevationProperties(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDataProviderElevationProperties') -> None: ...

    def setContainsElevationData(self, contains: bool) -> None: ...
    def containsElevationData(self) -> bool: ...


class QgsDataProviderTemporalCapabilities(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, available: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDataProviderTemporalCapabilities') -> None: ...

    def setHasTemporalCapabilities(self, available: bool) -> None: ...
    def hasTemporalCapabilities(self) -> bool: ...


class QgsDataSourceUri(PyQt6.sip.wrapper):

    class SslMode(enum.IntEnum):
        SslPrefer = ... # type: QgsDataSourceUri.SslMode
        SslDisable = ... # type: QgsDataSourceUri.SslMode
        SslAllow = ... # type: QgsDataSourceUri.SslMode
        SslRequire = ... # type: QgsDataSourceUri.SslMode
        SslVerifyCa = ... # type: QgsDataSourceUri.SslMode
        SslVerifyFull = ... # type: QgsDataSourceUri.SslMode

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, uri: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDataSourceUri') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def __repr__(self) -> typing.Any: ...
    def setHttpHeaders(self, headers: 'QgsHttpHeaders') -> None: ...
    def httpHeader(self, key: str|None) -> str: ...
    def httpHeaders(self) -> 'QgsHttpHeaders': ...
    def parameterKeys(self) -> set[str]: ...
    def setGeometryColumn(self, geometryColumn: str|None) -> None: ...
    def setTable(self, table: str|None) -> None: ...
    @staticmethod
    def encodeSslMode(sslMode: 'QgsDataSourceUri.SslMode') -> str: ...
    @staticmethod
    def decodeSslMode(sslMode: str|None) -> 'QgsDataSourceUri.SslMode': ...
    def setSrid(self, srid: str|None) -> None: ...
    def srid(self) -> str: ...
    def setWkbType(self, type: Qgis.WkbType) -> None: ...
    def wkbType(self) -> Qgis.WkbType: ...
    def setKeyColumn(self, column: str|None) -> None: ...
    def keyColumn(self) -> str: ...
    def service(self) -> str: ...
    def setService(self, service: str|None) -> None: ...
    def sslMode(self) -> 'QgsDataSourceUri.SslMode': ...
    def setSslMode(self, mode: 'QgsDataSourceUri.SslMode') -> None: ...
    def password(self) -> str: ...
    def setDriver(self, driver: str|None) -> None: ...
    def driver(self) -> str: ...
    def port(self) -> str: ...
    def setPort(self, port: str|None) -> None: ...
    def database(self) -> str: ...
    def host(self) -> str: ...
    def setHost(self, host: str|None) -> None: ...
    def setSql(self, sql: str|None) -> None: ...
    def setSchema(self, schema: str|None) -> None: ...
    def clearSchema(self) -> None: ...
    def selectAtIdDisabled(self) -> bool: ...
    def disableSelectAtId(self, flag: bool) -> None: ...
    def useEstimatedMetadata(self) -> bool: ...
    def setUseEstimatedMetadata(self, flag: bool) -> None: ...
    def geometryColumn(self) -> str: ...
    def sql(self) -> str: ...
    def table(self) -> str: ...
    def schema(self) -> str: ...
    def username(self) -> str: ...
    def authConfigId(self) -> str: ...
    @staticmethod
    def removePassword(aUri: str|None, hide: bool = ...) -> str: ...
    def setPassword(self, password: str|None) -> None: ...
    def setUsername(self, username: str|None) -> None: ...
    def setAuthConfigId(self, authcfg: str|None) -> None: ...
    def setDataSource(self, aSchema: str|None, aTable: str|None, aGeometryColumn: str|None, aSql: str|None = ..., aKeyColumn: str|None = ...) -> None: ...
    def setDatabase(self, database: str|None) -> None: ...
    @typing.overload
    def setConnection(self, aHost: str|None, aPort: str|None, aDatabase: str|None, aUsername: str|None, aPassword: str|None, sslmode: 'QgsDataSourceUri.SslMode' = ..., authConfigId: str|None = ...) -> None: ...
    @typing.overload
    def setConnection(self, aService: str|None, aDatabase: str|None, aUsername: str|None, aPassword: str|None, sslmode: 'QgsDataSourceUri.SslMode' = ..., authConfigId: str|None = ...) -> None: ...
    def hasParam(self, key: str|None) -> bool: ...
    def params(self, key: str|None) -> list[str]: ...
    def param(self, key: str|None) -> str: ...
    def removeParam(self, key: str|None) -> int: ...
    def setParamList(self, key: str|None, value: collections.abc.Iterable[str|None]) -> None: ...
    def setParam(self, key: str|None, value: str|None) -> None: ...
    def quotedTablename(self) -> str: ...
    def setEncodedUri(self, uri: str|None) -> None: ...
    def encodedUri(self) -> QtCore.QByteArray: ...
    def uri(self, expandAuthConfig: bool = ...) -> str: ...
    def connectionInfo(self, expandAuthConfig: bool = ...) -> str: ...


class QgsDateTimeStatisticalSummary(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, stats: Qgis.DateTimeStatistic = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDateTimeStatisticalSummary') -> None: ...

    @staticmethod
    def displayName(statistic: Qgis.DateTimeStatistic) -> str: ...
    def range(self) -> 'QgsInterval': ...
    def max(self) -> QtCore.QDateTime: ...
    def min(self) -> QtCore.QDateTime: ...
    def countMissing(self) -> int: ...
    def distinctValues(self) -> set[QtCore.QDateTime]: ...
    def countDistinct(self) -> int: ...
    def count(self) -> int: ...
    def statistic(self, stat: Qgis.DateTimeStatistic) -> typing.Any: ...
    def finalize(self) -> None: ...
    def addValue(self, value: typing.Any) -> None: ...
    def calculate(self, values: collections.abc.Iterable[typing.Any]) -> None: ...
    def reset(self) -> None: ...
    def setStatistics(self, stats: Qgis.DateTimeStatistic) -> None: ...
    def statistics(self) -> Qgis.DateTimeStatistic: ...


@deprecated("")
class QgsDatabaseFilterProxyModel(QtCore.QSortFilterProxyModel):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def filterAcceptsRow(self, row: int, source_parent: QtCore.QModelIndex) -> bool: ...
    def _setFilterRegExp(self, pattern: str|None) -> None: ...
    def _setFilterWildcard(self, pattern: str|None) -> None: ...


class QgsDatabaseQueryLogEntry(PyQt6.sip.wrapper):

    canceled = ... # type: bool
    error = ... # type: str|None
    fetchedRows = ... # type: int
    finishedTime = ... # type: int
    initiatorClass = ... # type: str|None
    origin = ... # type: str|None
    provider = ... # type: str|None
    query = ... # type: str|None
    queryId = ... # type: int
    startedTime = ... # type: int
    uri = ... # type: str|None

    @typing.overload
    def __init__(self, query: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDatabaseQueryLogEntry') -> None: ...


class QgsDatabaseQueryLog(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    @staticmethod
    def finished(query: QgsDatabaseQueryLogEntry) -> None: ...
    @staticmethod
    def log(query: QgsDatabaseQueryLogEntry) -> None: ...
    @staticmethod
    def enabled() -> bool: ...


class QgsDefaultValue(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, expression: str|None = ..., applyOnUpdate: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDefaultValue') -> None: ...

    def __ne__(self, other: object): ...
    def isValid(self) -> bool: ...
    def setApplyOnUpdate(self, applyOnUpdate: bool) -> None: ...
    def applyOnUpdate(self) -> bool: ...
    def setExpression(self, expression: str|None) -> None: ...
    def expression(self) -> str: ...
    def __repr__(self) -> typing.Any: ...
    def __eq__(self, other: object): ...


class QgsDiagramLayerSettings(PyQt6.sip.wrapper):

    class DiagramType(enum.IntEnum):
        Single = ... # type: QgsDiagramLayerSettings.DiagramType
        Stacked = ... # type: QgsDiagramLayerSettings.DiagramType

    class Property(enum.IntEnum):
        BackgroundColor = ... # type: QgsDiagramLayerSettings.Property
        StrokeColor = ... # type: QgsDiagramLayerSettings.Property
        StrokeWidth = ... # type: QgsDiagramLayerSettings.Property
        PositionX = ... # type: QgsDiagramLayerSettings.Property
        PositionY = ... # type: QgsDiagramLayerSettings.Property
        Distance = ... # type: QgsDiagramLayerSettings.Property
        Priority = ... # type: QgsDiagramLayerSettings.Property
        ZIndex = ... # type: QgsDiagramLayerSettings.Property
        IsObstacle = ... # type: QgsDiagramLayerSettings.Property
        Show = ... # type: QgsDiagramLayerSettings.Property
        AlwaysShow = ... # type: QgsDiagramLayerSettings.Property
        StartAngle = ... # type: QgsDiagramLayerSettings.Property

    class LinePlacementFlag(enum.IntEnum):
        OnLine = ... # type: QgsDiagramLayerSettings.LinePlacementFlag
        AboveLine = ... # type: QgsDiagramLayerSettings.LinePlacementFlag
        BelowLine = ... # type: QgsDiagramLayerSettings.LinePlacementFlag
        MapOrientation = ... # type: QgsDiagramLayerSettings.LinePlacementFlag

    class Placement(enum.IntEnum):
        AroundPoint = ... # type: QgsDiagramLayerSettings.Placement
        OverPoint = ... # type: QgsDiagramLayerSettings.Placement
        Line = ... # type: QgsDiagramLayerSettings.Placement
        Curved = ... # type: QgsDiagramLayerSettings.Placement
        Horizontal = ... # type: QgsDiagramLayerSettings.Placement
        Free = ... # type: QgsDiagramLayerSettings.Placement

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, rh: 'QgsDiagramLayerSettings') -> None: ...

    def setDataDefinedProperties(self, collection: 'QgsPropertyCollection') -> None: ...
    def dataDefinedProperties(self) -> 'QgsPropertyCollection': ...
    def referencedFields(self, context: 'QgsExpressionContext' = ...) -> set[str]: ...
    def prepare(self, context: 'QgsExpressionContext' = ...) -> bool: ...
    def writeXml(self, layerElem: QtXml.QDomElement, doc: QtXml.QDomDocument) -> None: ...
    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def setShowAllDiagrams(self, showAllDiagrams: bool) -> None: ...
    def showAllDiagrams(self) -> bool: ...
    def setCoordinateTransform(self, transform: 'QgsCoordinateTransform') -> None: ...
    def coordinateTransform(self) -> 'QgsCoordinateTransform': ...
    def setRenderer(self, diagramRenderer: 'QgsDiagramRenderer|None') -> None: ...
    def renderer(self) -> 'QgsDiagramRenderer|None': ...
    def setDistance(self, distance: float) -> None: ...
    def distance(self) -> float: ...
    def setIsObstacle(self, isObstacle: bool) -> None: ...
    def isObstacle(self) -> bool: ...
    def setZIndex(self, index: float) -> None: ...
    def zIndex(self) -> float: ...
    def setPriority(self, value: int) -> None: ...
    def priority(self) -> int: ...
    def setLinePlacementFlags(self, flags: 'QgsDiagramLayerSettings.LinePlacementFlag') -> None: ...
    def linePlacementFlags(self) -> 'QgsDiagramLayerSettings.LinePlacementFlag': ...
    def setPlacement(self, value: 'QgsDiagramLayerSettings.Placement') -> None: ...
    def placement(self) -> 'QgsDiagramLayerSettings.Placement': ...
    @staticmethod
    def propertyDefinitions() -> dict[int, 'QgsPropertyDefinition']: ...


class QgsDiagramSettings(PyQt6.sip.wrapper):

    class StackedDiagramMode(enum.IntEnum):
        Horizontal = ... # type: QgsDiagramSettings.StackedDiagramMode
        Vertical = ... # type: QgsDiagramSettings.StackedDiagramMode

    class Direction(enum.IntEnum):
        Clockwise = ... # type: QgsDiagramSettings.Direction
        Counterclockwise = ... # type: QgsDiagramSettings.Direction

    class DiagramOrientation(enum.IntEnum):
        Up = ... # type: QgsDiagramSettings.DiagramOrientation
        Down = ... # type: QgsDiagramSettings.DiagramOrientation
        Left = ... # type: QgsDiagramSettings.DiagramOrientation
        Right = ... # type: QgsDiagramSettings.DiagramOrientation

    class LabelPlacementMethod(enum.IntEnum):
        Height = ... # type: QgsDiagramSettings.LabelPlacementMethod
        XHeight = ... # type: QgsDiagramSettings.LabelPlacementMethod

    backgroundColor = ... # type: QtGui.QColor|QtCore.Qt.GlobalColor|int
    barWidth = ... # type: float
    categoryAttributes = ... # type: collections.abc.Iterable[str|None]
    categoryColors = ... # type: collections.abc.Iterable[QtGui.QColor|QtCore.Qt.GlobalColor|int]
    categoryLabels = ... # type: collections.abc.Iterable[str|None]
    diagramOrientation = ... # type: 'QgsDiagramSettings.DiagramOrientation'
    enabled = ... # type: bool
    font = ... # type: QtGui.QFont
    labelPlacementMethod = ... # type: 'QgsDiagramSettings.LabelPlacementMethod'
    lineSizeScale = ... # type: 'QgsMapUnitScale'
    lineSizeUnit = ... # type: Qgis.RenderUnit
    maximumScale = ... # type: float
    minimumScale = ... # type: float
    minimumSize = ... # type: float
    opacity = ... # type: float
    penColor = ... # type: QtGui.QColor|QtCore.Qt.GlobalColor|int
    penWidth = ... # type: float
    rotationOffset = ... # type: float
    scaleBasedVisibility = ... # type: bool
    scaleByArea = ... # type: bool
    size = ... # type: QtCore.QSizeF
    sizeScale = ... # type: 'QgsMapUnitScale'
    sizeType = ... # type: Qgis.RenderUnit
    stackedDiagramMode = ... # type: 'QgsDiagramSettings.StackedDiagramMode'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsDiagramSettings') -> None: ...

    def setPaintEffect(self, effect: 'QgsPaintEffect|None') -> None: ...
    def paintEffect(self) -> 'QgsPaintEffect|None': ...
    def setShowAxis(self, showAxis: bool) -> None: ...
    def showAxis(self) -> bool: ...
    def setAxisLineSymbol(self, symbol: 'QgsLineSymbol|None') -> None: ...
    def axisLineSymbol(self) -> 'QgsLineSymbol|None': ...
    def legendItems(self, nodeLayer: 'QgsLayerTreeLayer|None') -> list['QgsLayerTreeModelLegendNode']: ...
    def writeXml(self, rendererElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext' = ...) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: 'QgsReadWriteContext' = ...) -> None: ...
    def setDirection(self, direction: 'QgsDiagramSettings.Direction') -> None: ...
    def direction(self) -> 'QgsDiagramSettings.Direction': ...
    def stackedDiagramSpacingMapUnitScale(self) -> 'QgsMapUnitScale': ...
    def setStackedDiagramSpacingMapUnitScale(self, scale: 'QgsMapUnitScale') -> None: ...
    def stackedDiagramSpacingUnit(self) -> Qgis.RenderUnit: ...
    def setStackedDiagramSpacingUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setStackedDiagramSpacing(self, spacing: float) -> None: ...
    def stackedDiagramSpacing(self) -> float: ...
    def spacingMapUnitScale(self) -> 'QgsMapUnitScale': ...
    def setSpacingMapUnitScale(self, scale: 'QgsMapUnitScale') -> None: ...
    def spacingUnit(self) -> Qgis.RenderUnit: ...
    def setSpacingUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def spacing(self) -> float: ...


class QgsDiagramInterpolationSettings(PyQt6.sip.wrapper):

    classificationAttributeExpression = ... # type: str|None
    classificationAttributeIsExpression = ... # type: bool
    classificationField = ... # type: str|None
    lowerSize = ... # type: QtCore.QSizeF
    lowerValue = ... # type: float
    upperSize = ... # type: QtCore.QSizeF
    upperValue = ... # type: float

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDiagramInterpolationSettings') -> None: ...


class QgsDiagramRenderer(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsDiagramRenderer') -> None: ...

    def _writeXml(self, rendererElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> None: ...
    def _readXml(self, elem: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    @staticmethod
    def dpiPaintDevice(a0: QtGui.QPainter|None) -> int: ...
    def convertSizeToMapUnits(self, size: QtCore.QSizeF, context: 'QgsRenderContext') -> None: ...
    def diagramSize(self, feature: 'QgsFeature', c: 'QgsRenderContext') -> QtCore.QSizeF: ...
    def setAttributeLegend(self, enabled: bool) -> None: ...
    def attributeLegend(self) -> bool: ...
    def legendItems(self, nodeLayer: 'QgsLayerTreeLayer|None') -> list['QgsLayerTreeModelLegendNode']: ...
    def writeXml(self, layerElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    @typing.overload
    def diagramSettings(self) -> list[QgsDiagramSettings]: ...
    @typing.overload
    def diagramSettings(self, feature: 'QgsFeature', c: 'QgsRenderContext', s: QgsDiagramSettings) -> bool: ...
    def diagram(self) -> 'QgsDiagram|None': ...
    def setDiagram(self, d: 'QgsDiagram|None') -> None: ...
    def renderDiagram(self, feature: 'QgsFeature', c: 'QgsRenderContext', pos: QtCore.QPointF, properties: 'QgsPropertyCollection' = ...) -> None: ...
    def referencedFields(self, context: 'QgsExpressionContext' = ...) -> set[str]: ...
    def diagramAttributes(self) -> list[str]: ...
    def rendererName(self) -> str: ...
    def sizeMapUnits(self, feature: 'QgsFeature', c: 'QgsRenderContext') -> QtCore.QSizeF: ...
    def clone(self) -> 'QgsDiagramRenderer|None': ...


class QgsSingleCategoryDiagramRenderer(QgsDiagramRenderer):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSingleCategoryDiagramRenderer') -> None: ...

    def diagramSize(self, a0: 'QgsFeature', c: 'QgsRenderContext') -> QtCore.QSizeF: ...
    def legendItems(self, nodeLayer: 'QgsLayerTreeLayer|None') -> list['QgsLayerTreeModelLegendNode']: ...
    def writeXml(self, layerElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    @typing.overload
    def diagramSettings(self) -> list[QgsDiagramSettings]: ...
    @typing.overload
    def diagramSettings(self, feature: 'QgsFeature', c: 'QgsRenderContext', s: QgsDiagramSettings) -> bool: ...
    def setDiagramSettings(self, s: QgsDiagramSettings) -> None: ...
    def diagramAttributes(self) -> list[str]: ...
    def rendererName(self) -> str: ...
    def clone(self) -> 'QgsSingleCategoryDiagramRenderer|None': ...


class QgsLinearlyInterpolatedDiagramRenderer(QgsDiagramRenderer):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsLinearlyInterpolatedDiagramRenderer') -> None: ...

    def diagramSize(self, a0: 'QgsFeature', c: 'QgsRenderContext') -> QtCore.QSizeF: ...
    def dataDefinedSizeLegend(self) -> QgsDataDefinedSizeLegend|None: ...
    def setDataDefinedSizeLegend(self, settings: QgsDataDefinedSizeLegend|None) -> None: ...
    def legendItems(self, nodeLayer: 'QgsLayerTreeLayer|None') -> list['QgsLayerTreeModelLegendNode']: ...
    def writeXml(self, layerElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    def setClassificationAttributeIsExpression(self, isExpression: bool) -> None: ...
    def classificationAttributeIsExpression(self) -> bool: ...
    def setClassificationAttributeExpression(self, expression: str|None) -> None: ...
    def classificationAttributeExpression(self) -> str: ...
    def setClassificationField(self, field: str|None) -> None: ...
    def classificationField(self) -> str: ...
    def upperSize(self) -> QtCore.QSizeF: ...
    def setUpperSize(self, s: QtCore.QSizeF) -> None: ...
    def lowerSize(self) -> QtCore.QSizeF: ...
    def setLowerSize(self, s: QtCore.QSizeF) -> None: ...
    def upperValue(self) -> float: ...
    def setUpperValue(self, val: float) -> None: ...
    def lowerValue(self) -> float: ...
    def setLowerValue(self, val: float) -> None: ...
    def rendererName(self) -> str: ...
    def referencedFields(self, context: 'QgsExpressionContext' = ...) -> set[str]: ...
    def diagramAttributes(self) -> list[str]: ...
    def setDiagramSettings(self, s: QgsDiagramSettings) -> None: ...
    @typing.overload
    def diagramSettings(self) -> list[QgsDiagramSettings]: ...
    @typing.overload
    def diagramSettings(self, feature: 'QgsFeature', c: 'QgsRenderContext', s: QgsDiagramSettings) -> bool: ...
    def clone(self) -> 'QgsLinearlyInterpolatedDiagramRenderer|None': ...


class QgsStackedDiagramRenderer(QgsDiagramRenderer):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsStackedDiagramRenderer') -> None: ...

    def diagramSize(self, a0: 'QgsFeature', c: 'QgsRenderContext') -> QtCore.QSizeF: ...
    def rendererCount(self) -> int: ...
    def renderer(self, index: int) -> QgsDiagramRenderer|None: ...
    def addRenderer(self, renderer: QgsDiagramRenderer|None) -> None: ...
    def renderers(self, sortByDiagramMode: bool = ...) -> list[QgsDiagramRenderer]: ...
    def legendItems(self, nodeLayer: 'QgsLayerTreeLayer|None') -> list['QgsLayerTreeModelLegendNode']: ...
    def _writeXmlSubRenderers(self, rendererElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> None: ...
    def _readXmlSubRenderers(self, elem: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    def writeXml(self, layerElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    def rendererName(self) -> str: ...
    def diagramAttributes(self) -> list[str]: ...
    def setDiagramSettings(self, s: QgsDiagramSettings) -> None: ...
    @typing.overload
    def diagramSettings(self) -> list[QgsDiagramSettings]: ...
    @typing.overload
    def diagramSettings(self, feature: 'QgsFeature', c: 'QgsRenderContext', s: QgsDiagramSettings) -> bool: ...
    def renderDiagram(self, feature: 'QgsFeature', c: 'QgsRenderContext', pos: QtCore.QPointF, properties: 'QgsPropertyCollection' = ...) -> None: ...
    def sizeMapUnits(self, feature: 'QgsFeature', c: 'QgsRenderContext') -> QtCore.QSizeF: ...
    def clone(self) -> 'QgsStackedDiagramRenderer|None': ...


class QgsDistanceArea(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsDistanceArea') -> None: ...

    def splitGeometryAtAntimeridian(self, geometry: 'QgsGeometry') -> 'QgsGeometry': ...
    def latitudeGeodesicCrossesAntimeridian(self, p1: 'QgsPointXY', p2: 'QgsPointXY') -> typing.Tuple[float, float]: ...
    def geodesicLine(self, p1: 'QgsPointXY', p2: 'QgsPointXY', interval: float, breakLine: bool = ...) -> typing.Any: ...
    def computeSpheroidProject(self, p1: 'QgsPointXY', distance: float = ..., azimuth: float = ...) -> 'QgsPointXY': ...
    def convertAreaMeasurement(self, area: float, toUnits: Qgis.AreaUnit) -> float: ...
    def convertLengthMeasurement(self, length: float, toUnits: Qgis.DistanceUnit) -> float: ...
    @staticmethod
    def formatArea(area: float, decimals: int, unit: Qgis.AreaUnit, keepBaseUnit: bool = ...) -> str: ...
    @staticmethod
    def formatDistance(distance: float, decimals: int, unit: Qgis.DistanceUnit, keepBaseUnit: bool = ...) -> str: ...
    def bearing(self, p1: 'QgsPointXY', p2: 'QgsPointXY') -> float: ...
    def measurePolygon(self, points: collections.abc.Iterable['QgsPointXY']) -> float: ...
    def areaUnits(self) -> Qgis.AreaUnit: ...
    def lengthUnits(self) -> Qgis.DistanceUnit: ...
    def measureLineProjected(self, p1: 'QgsPointXY', distance: float = ..., azimuth: float = ...) -> typing.Tuple[float, 'QgsPointXY|None']: ...
    @typing.overload
    def measureLine(self, points: collections.abc.Iterable['QgsPointXY']) -> float: ...
    @typing.overload
    def measureLine(self, p1: 'QgsPointXY', p2: 'QgsPointXY') -> float: ...
    def measurePerimeter(self, geometry: 'QgsGeometry') -> float: ...
    def measureLength(self, geometry: 'QgsGeometry') -> float: ...
    def measureArea(self, geometry: 'QgsGeometry') -> float: ...
    def ellipsoidInverseFlattening(self) -> float: ...
    def ellipsoidSemiMinor(self) -> float: ...
    def ellipsoidSemiMajor(self) -> float: ...
    def ellipsoid(self) -> str: ...
    @typing.overload
    def setEllipsoid(self, ellipsoid: str|None) -> bool: ...
    @typing.overload
    def setEllipsoid(self, semiMajor: float, semiMinor: float) -> bool: ...
    def ellipsoidCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def sourceCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def setSourceCrs(self, crs: 'QgsCoordinateReferenceSystem', context: 'QgsCoordinateTransformContext') -> None: ...
    def willUseEllipsoid(self) -> bool: ...


class QgsEditorWidgetSetup(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, type: str|None, config: dict[str|None, typing.Any]) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsEditorWidgetSetup') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def isNull(self) -> bool: ...
    def config(self) -> dict[str, typing.Any]: ...
    def type(self) -> str: ...


class QgsElevationMap(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, size: QtCore.QSize, devicePixelRatio: float = ...) -> None: ...
    @typing.overload
    def __init__(self, image: QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsElevationMap') -> None: ...

    def noDataValue(self) -> float: ...
    def isNoData(self, colorRaw: int) -> bool: ...
    @staticmethod
    def decodeElevation(colorRaw: int) -> float: ...
    @staticmethod
    def encodeElevation(z: float) -> int: ...
    def isValid(self) -> bool: ...
    def combine(self, otherElevationMap: 'QgsElevationMap', method: Qgis.ElevationMapCombineMethod) -> None: ...
    def painter(self) -> QtGui.QPainter|None: ...
    def rawElevationImage(self) -> QtGui.QImage: ...
    def applyHillshading(self, image: QtGui.QImage, multiDirectional: bool, altitude: float, azimuth: float, zFactor: float, cellSizeX: float, cellSizeY: float) -> None: ...
    def applyEyeDomeLighting(self, image: QtGui.QImage, distance: int, strength: float, rendererScale: float) -> None: ...


class QgsElevationShadingRenderer(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsElevationShadingRenderer') -> None: ...

    def setCombinedElevationMethod(self, method: Qgis.ElevationMapCombineMethod) -> None: ...
    def combinedElevationMethod(self) -> Qgis.ElevationMapCombineMethod: ...
    def readXml(self, element: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    def setLightAzimuth(self, lightAzimuth: float) -> None: ...
    def lightAzimuth(self) -> float: ...
    def setLightAltitude(self, lightAltitude: float) -> None: ...
    def lightAltitude(self) -> float: ...
    def setHillshadingMultidirectional(self, multiDirectional: bool) -> None: ...
    def isHillshadingMultidirectional(self) -> bool: ...
    def setHillshadingZFactor(self, zFactor: float) -> None: ...
    def hillshadingZFactor(self) -> float: ...
    def isActiveHillshading(self) -> bool: ...
    def setActiveHillshading(self, active: bool) -> None: ...
    def setEyeDomeLightingDistanceUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def eyeDomeLightingDistanceUnit(self) -> Qgis.RenderUnit: ...
    def setEyeDomeLightingDistance(self, distance: float) -> None: ...
    def eyeDomeLightingDistance(self) -> float: ...
    def setEyeDomeLightingStrength(self, strength: float) -> None: ...
    def eyeDomeLightingStrength(self) -> float: ...
    def isActiveEyeDomeLighting(self) -> bool: ...
    def setActiveEyeDomeLighting(self, active: bool) -> None: ...
    def isActive(self) -> bool: ...
    def setActive(self, active: bool) -> None: ...
    def renderShading(self, elevation: QgsElevationMap, image: QtGui.QImage, context: 'QgsRenderContext') -> None: ...


class QgsElevationUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsElevationUtils') -> None: ...

    @staticmethod
    def enableElevationForLayer(layer: QgsMapLayer|None) -> bool: ...
    @staticmethod
    def canEnableElevationForLayer(layer: QgsMapLayer|None) -> bool: ...
    @staticmethod
    def significantZValuesForLayers(layers: collections.abc.Iterable[QgsMapLayer]) -> list[float]: ...
    @staticmethod
    def significantZValuesForProject(project: 'QgsProject|None') -> list[float]: ...
    @staticmethod
    def calculateZRangeForProject(project: 'QgsProject|None') -> 'QgsDoubleRange': ...


class QgsErrorMessage(PyQt6.sip.wrapper):

    class Format(enum.IntEnum):
        Text = ... # type: QgsErrorMessage.Format
        Html = ... # type: QgsErrorMessage.Format

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str|None, tag: str|None = ..., file: str|None = ..., function: str|None = ..., line: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsErrorMessage') -> None: ...

    def line(self) -> int: ...
    def function(self) -> str: ...
    def file(self) -> str: ...
    def tag(self) -> str: ...
    def message(self) -> str: ...


class QgsError(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str|None, tag: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsError') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def messageList(self) -> list[QgsErrorMessage]: ...
    def clear(self) -> None: ...
    def summary(self) -> str: ...
    def message(self, format: QgsErrorMessage.Format = ...) -> str: ...
    def isEmpty(self) -> bool: ...
    @typing.overload
    def append(self, message: str|None, tag: str|None) -> None: ...
    @typing.overload
    def append(self, message: QgsErrorMessage) -> None: ...


class QgsExpressionFunction(PyQt6.sip.wrapper):

    class Parameter(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self, name: str|None, optional: bool = ..., defaultValue: typing.Any = ..., isSubExpression: bool = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsExpressionFunction.Parameter') -> None: ...

        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def isSubExpression(self) -> bool: ...
        def defaultValue(self) -> typing.Any: ...
        def optional(self) -> bool: ...
        def name(self) -> str: ...

    @typing.overload
    def __init__(self, fnname: str|None, params: int, group: str|None, helpText: str|None = ..., lazyEval: bool = ..., handlesNull: bool = ..., isContextual: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, fnname: str|None, params: int, groups: collections.abc.Iterable[str|None], helpText: str|None = ..., lazyEval: bool = ..., handlesNull: bool = ..., isContextual: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, fnname: str|None, params: collections.abc.Iterable['QgsExpressionFunction.Parameter'], group: str|None, helpText: str|None = ..., lazyEval: bool = ..., handlesNull: bool = ..., isContextual: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, fnname: str|None, params: collections.abc.Iterable['QgsExpressionFunction.Parameter'], groups: collections.abc.Iterable[str|None], helpText: str|None = ..., lazyEval: bool = ..., handlesNull: bool = ..., isContextual: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsExpressionFunction') -> None: ...

    def __ne__(self, other: object): ...
    @staticmethod
    def allParamsStatic(node: 'QgsExpressionNodeFunction|None', parent: 'QgsExpression|None', context: 'QgsExpressionContext|None') -> bool: ...
    def handlesNull(self) -> bool: ...
    def __eq__(self, other: object): ...
    def run(self, args: 'QgsExpressionNode.NodeList|None', context: 'QgsExpressionContext|None', parent: 'QgsExpression|None', node: 'QgsExpressionNodeFunction|None') -> typing.Any: ...
    def func(self, values: collections.abc.Iterable[typing.Any], context: 'QgsExpressionContext|None', parent: 'QgsExpression|None', node: 'QgsExpressionNodeFunction|None') -> typing.Any: ...
    def helpText(self) -> str: ...
    def groups(self) -> list[str]: ...
    def group(self) -> str: ...
    def isDeprecated(self) -> bool: ...
    def isContextual(self) -> bool: ...
    def referencedColumns(self, node: 'QgsExpressionNodeFunction|None') -> set[str]: ...
    def prepare(self, node: 'QgsExpressionNodeFunction|None', parent: 'QgsExpression|None', context: 'QgsExpressionContext|None') -> bool: ...
    def isStatic(self, node: 'QgsExpressionNodeFunction|None', parent: 'QgsExpression|None', context: 'QgsExpressionContext|None') -> bool: ...
    def lazyEval(self) -> bool: ...
    def aliases(self) -> list[str]: ...
    def usesGeometry(self, node: 'QgsExpressionNodeFunction|None') -> bool: ...
    def parameters(self) -> list['QgsExpressionFunction.Parameter']: ...
    def minParams(self) -> int: ...
    def params(self) -> int: ...
    def name(self) -> str: ...


class QgsScopedExpressionFunction(QgsExpressionFunction):

    @typing.overload
    def __init__(self, fnname: str|None, params: int, group: str|None, helpText: str|None = ..., usesGeometry: bool = ..., referencedColumns: collections.abc.Iterable[str|None] = ..., lazyEval: bool = ..., handlesNull: bool = ..., isContextual: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, fnname: str|None, params: collections.abc.Iterable[QgsExpressionFunction.Parameter], group: str|None, helpText: str|None = ..., usesGeometry: bool = ..., referencedColumns: collections.abc.Iterable[str|None] = ..., lazyEval: bool = ..., handlesNull: bool = ..., isContextual: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsScopedExpressionFunction') -> None: ...

    def isStatic(self, node: 'QgsExpressionNodeFunction|None', parent: 'QgsExpression|None', context: 'QgsExpressionContext|None') -> bool: ...
    def referencedColumns(self, node: 'QgsExpressionNodeFunction|None') -> set[str]: ...
    def usesGeometry(self, node: 'QgsExpressionNodeFunction|None') -> bool: ...
    def clone(self) -> 'QgsScopedExpressionFunction|None': ...
    def func(self, values: collections.abc.Iterable[typing.Any], context: 'QgsExpressionContext|None', parent: 'QgsExpression|None', node: 'QgsExpressionNodeFunction|None') -> typing.Any: ...


class QgsExpressionContextScope(PyQt6.sip.wrapper):

    class StaticVariable(PyQt6.sip.wrapper):

        description = ... # type: str|None
        isStatic = ... # type: bool
        name = ... # type: str|None
        readOnly = ... # type: bool
        value = ... # type: typing.Any

        @typing.overload
        def __init__(self, name: str|None = ..., value: typing.Any = ..., readOnly: bool = ..., isStatic: bool = ..., description: str|None = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsExpressionContextScope.StaticVariable') -> None: ...

    @typing.overload
    def __init__(self, name: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsExpressionContextScope') -> None: ...

    def layerStores(self) -> list['QgsMapLayerStore']: ...
    def addLayerStore(self, store: 'QgsMapLayerStore|None') -> None: ...
    def removeHiddenVariable(self, hiddenVariable: str|None) -> None: ...
    def addHiddenVariable(self, hiddenVariable: str|None) -> None: ...
    def setHiddenVariables(self, hiddenVariables: collections.abc.Iterable[str|None]) -> None: ...
    def hiddenVariables(self) -> list[str]: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> bool: ...
    def readXml(self, element: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    def setFields(self, fields: 'QgsFields') -> None: ...
    def removeGeometry(self) -> None: ...
    def setGeometry(self, geometry: 'QgsGeometry') -> None: ...
    def geometry(self) -> 'QgsGeometry': ...
    def hasGeometry(self) -> bool: ...
    def removeFeature(self) -> None: ...
    def setFeature(self, feature: 'QgsFeature') -> None: ...
    def feature(self) -> 'QgsFeature': ...
    def hasFeature(self) -> bool: ...
    def addFunction(self, name: str|None, function: QgsScopedExpressionFunction|None) -> None: ...
    def functionNames(self) -> list[str]: ...
    def function(self, name: str|None) -> QgsExpressionFunction|None: ...
    def hasFunction(self, name: str|None) -> bool: ...
    def variableCount(self) -> int: ...
    def description(self, name: str|None) -> str: ...
    def isStatic(self, name: str|None) -> bool: ...
    def isReadOnly(self, name: str|None) -> bool: ...
    def filteredVariableNames(self) -> list[str]: ...
    def variableNames(self) -> list[str]: ...
    def variable(self, name: str|None) -> typing.Any: ...
    def hasVariable(self, name: str|None) -> bool: ...
    def removeVariable(self, name: str|None) -> bool: ...
    def addVariable(self, variable: 'QgsExpressionContextScope.StaticVariable') -> None: ...
    def setVariable(self, name: str|None, value: typing.Any, isStatic: bool = ...) -> None: ...
    def name(self) -> str: ...


class QgsExpressionContext(PyQt6.sip.wrapper):

    EXPR_CLUSTER_COLOR = ... # type: str|None
    EXPR_CLUSTER_SIZE = ... # type: str|None
    EXPR_FIELDS = ... # type: str|None
    EXPR_GEOMETRY_PART_COUNT = ... # type: str|None
    EXPR_GEOMETRY_PART_NUM = ... # type: str|None
    EXPR_GEOMETRY_POINT_COUNT = ... # type: str|None
    EXPR_GEOMETRY_POINT_NUM = ... # type: str|None
    EXPR_GEOMETRY_RING_NUM = ... # type: str|None
    EXPR_ORIGINAL_VALUE = ... # type: str|None
    EXPR_SYMBOL_ANGLE = ... # type: str|None
    EXPR_SYMBOL_COLOR = ... # type: str|None

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, scopes: collections.abc.Iterable[QgsExpressionContextScope]) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsExpressionContext') -> None: ...

    def uniqueHash(self, variables: collections.abc.Iterable[str|None] = ...) -> typing.Tuple[str, bool]: ...
    def feedback(self) -> 'QgsFeedback|None': ...
    def setFeedback(self, feedback: 'QgsFeedback|None') -> None: ...
    def loadedLayerStore(self) -> 'QgsMapLayerStore|None': ...
    def setLoadedLayerStore(self, store: 'QgsMapLayerStore|None') -> None: ...
    def layerStores(self) -> list['QgsMapLayerStore']: ...
    def clearCachedValues(self) -> None: ...
    def cachedValue(self, key: str|None) -> typing.Any: ...
    def hasCachedValue(self, key: str|None) -> bool: ...
    def setCachedValue(self, key: str|None, value: typing.Any) -> None: ...
    def setOriginalValueVariable(self, value: typing.Any) -> None: ...
    def fields(self) -> 'QgsFields': ...
    def setFields(self, fields: 'QgsFields') -> None: ...
    def geometry(self) -> 'QgsGeometry': ...
    def hasGeometry(self) -> bool: ...
    def setGeometry(self, geometry: 'QgsGeometry') -> None: ...
    def feature(self) -> 'QgsFeature': ...
    def hasFeature(self) -> bool: ...
    def setFeature(self, feature: 'QgsFeature') -> None: ...
    def popScope(self) -> QgsExpressionContextScope|None: ...
    def appendScopes(self, scopes: collections.abc.Iterable[QgsExpressionContextScope]) -> None: ...
    def appendScope(self, scope: QgsExpressionContextScope|None) -> None: ...
    def scopeCount(self) -> int: ...
    def function(self, name: str|None) -> QgsExpressionFunction|None: ...
    def functionNames(self) -> list[str]: ...
    def hasFunction(self, name: str|None) -> bool: ...
    def description(self, name: str|None) -> str: ...
    def isReadOnly(self, name: str|None) -> bool: ...
    def filteredVariableNames(self) -> list[str]: ...
    def variableNames(self) -> list[str]: ...
    @typing.overload
    def indexOfScope(self, scope: QgsExpressionContextScope|None) -> int: ...
    @typing.overload
    def indexOfScope(self, scopeName: str|None) -> int: ...
    def scopes(self) -> list[QgsExpressionContextScope]: ...
    def lastScope(self) -> QgsExpressionContextScope|None: ...
    def scope(self, index: int) -> QgsExpressionContextScope|None: ...
    def activeScopeForVariable(self, name: str|None) -> QgsExpressionContextScope|None: ...
    def setHighlightedFunctions(self, names: collections.abc.Iterable[str|None]) -> None: ...
    def isHighlightedFunction(self, name: str|None) -> bool: ...
    def setHighlightedVariables(self, variableNames: collections.abc.Iterable[str|None]) -> None: ...
    def highlightedVariables(self) -> list[str]: ...
    def isHighlightedVariable(self, name: str|None) -> bool: ...
    def variablesToMap(self) -> dict[str, typing.Any]: ...
    def variable(self, name: str|None) -> typing.Any: ...
    def hasVariable(self, name: str|None) -> bool: ...


class QgsExpressionFieldBuffer(PyQt6.sip.wrapper):

    class ExpressionField(PyQt6.sip.wrapper):

        cachedExpression = ... # type: 'QgsExpression'
        field = ... # type: 'QgsField'

        @typing.overload
        def __init__(self, exp: str|None, fld: 'QgsField') -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsExpressionFieldBuffer.ExpressionField') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsExpressionFieldBuffer') -> None: ...

    def expressions(self) -> list['QgsExpressionFieldBuffer.ExpressionField']: ...
    def updateFields(self, flds: 'QgsFields') -> None: ...
    def readXml(self, layer_node: QtXml.QDomNode) -> None: ...
    def writeXml(self, layer_node: QtXml.QDomNode, document: QtXml.QDomDocument) -> None: ...
    def updateExpression(self, index: int, exp: str|None) -> None: ...
    def renameExpression(self, index: int, name: str|None) -> None: ...
    def removeExpression(self, index: int) -> None: ...
    def addExpression(self, exp: str|None, fld: 'QgsField') -> None: ...


class QgsFeature(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, id: int = ...) -> None: ...
    @typing.overload
    def __init__(self, fields: 'QgsFields', id: int = ...) -> None: ...
    @typing.overload
    def __init__(self, rhs: 'QgsFeature') -> None: ...

    def approximateMemoryUsage(self) -> int: ...
    def fieldNameIndex(self, fieldName: str|None) -> int: ...
    def setEmbeddedSymbol(self, symbol: 'QgsSymbol|None') -> None: ...
    def embeddedSymbol(self) -> 'QgsSymbol|None': ...
    def isUnsetValue(self, fieldIdx: int) -> bool: ...
    @typing.overload
    def attribute(self, name: str|None) -> typing.Any: ...
    @typing.overload
    def attribute(self, fieldIdx: int) -> typing.Any: ...
    def fields(self) -> 'QgsFields': ...
    def setFields(self, fields: 'QgsFields', initAttributes: bool = ...) -> None: ...
    def clearGeometry(self) -> None: ...
    @typing.overload
    def setGeometry(self, geometry: 'QgsGeometry') -> None: ...
    @typing.overload
    def setGeometry(self, geometry: 'QgsAbstractGeometry|None') -> None: ...
    def geometry(self) -> 'QgsGeometry': ...
    def hasGeometry(self) -> bool: ...
    def setValid(self, validity: bool) -> None: ...
    def isValid(self) -> bool: ...
    @typing.overload
    def deleteAttribute(self, field: int) -> None: ...
    @typing.overload
    def deleteAttribute(self, name: str|None) -> bool: ...
    def padAttributes(self, count: int) -> None: ...
    def resizeAttributes(self, fieldCount: int) -> None: ...
    def initAttributes(self, fieldCount: int) -> None: ...
    @typing.overload
    def setAttribute(self, field: int, attr: bool|int|float|str|typing.Any|None) -> bool: ...
    @typing.overload
    def setAttribute(self, name: str|None, value: bool|int|float|str|typing.Any|None) -> None: ...
    def setAttributes(self, attrs: typing.Any) -> None: ...
    def attributeCount(self) -> int: ...
    def attributeMap(self) -> dict[str, object|None]: ...
    def attributes(self) -> typing.Any: ...
    def setId(self, id: int) -> None: ...
    def id(self) -> int: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def __hash__(self) -> int: ...
    @typing.overload
    def __delitem__(self, key: int) -> None: ...
    @typing.overload
    def __delitem__(self, name: str|None) -> None: ...
    @typing.overload
    def __setitem__(self, key: int, value: bool|int|float|str|typing.Any|None) -> None: ...
    @typing.overload
    def __setitem__(self, key: str|None, value: bool|int|float|str|typing.Any|None) -> None: ...
    @typing.overload
    def __getitem__(self, key: int) -> typing.Any: ...
    @typing.overload
    def __getitem__(self, name: str|None) -> typing.Any: ...
    def __iter__(self) -> typing.Any: ...


class QgsFeatureFilterProvider(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFeatureFilterProvider') -> None: ...

    def clone(self) -> 'QgsFeatureFilterProvider|None': ...
    def layerAttributes(self, layer: QgsVectorLayer|None, attributes: collections.abc.Iterable[str|None]) -> list[str]: ...
    @typing.overload
    @deprecated("""""")
    def filterFeatures(self, layer: QgsVectorLayer|None, featureRequest: 'QgsFeatureRequest') -> None: ...
    @typing.overload
    def filterFeatures(self, layerId: str|None, featureRequest: 'QgsFeatureRequest') -> None: ...
    @deprecated("""""")
    def isFilterThreadSafe(self) -> bool: ...


class QgsFeatureExpressionFilterProvider(QgsFeatureFilterProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFeatureExpressionFilterProvider') -> None: ...

    def setFilter(self, layerId: str|None, expression: 'QgsExpression') -> None: ...
    def clone(self) -> 'QgsFeatureExpressionFilterProvider|None': ...
    def layerAttributes(self, layer: QgsVectorLayer|None, attributes: collections.abc.Iterable[str|None]) -> list[str]: ...
    @typing.overload
    @deprecated("""""")
    def filterFeatures(self, layer: QgsVectorLayer|None, filterFeatures: 'QgsFeatureRequest') -> None: ...
    @typing.overload
    def filterFeatures(self, layerId: str|None, filterFeatures: 'QgsFeatureRequest') -> None: ...


class QgsFeaturePickerModelBase(QtCore.QAbstractItemModel):

    class CustomRole(enum.IntEnum):
        IdentifierValue = ... # type: QgsFeaturePickerModelBase.CustomRole
        IdentifierValues = ... # type: QgsFeaturePickerModelBase.CustomRole
        Value = ... # type: QgsFeaturePickerModelBase.CustomRole
        Feature = ... # type: QgsFeaturePickerModelBase.CustomRole
        FeatureId = ... # type: QgsFeaturePickerModelBase.CustomRole

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def setExtraIdentifierValueUnguarded(self, identifierValue: typing.Any) -> None: ...
    def requestToReloadCurrentFeature(self, request: 'QgsFeatureRequest') -> None: ...
    def setExtraIdentifierValue(self, extraIdentifierValue: typing.Any) -> None: ...
    def extraIdentifierValue(self) -> typing.Any: ...
    fetchLimitChanged: typing.ClassVar[QtCore.pyqtSignal]
    fetchGeometryChanged: typing.ClassVar[QtCore.pyqtSignal]
    allowNullChanged: typing.ClassVar[QtCore.pyqtSignal]
    endUpdate: typing.ClassVar[QtCore.pyqtSignal]
    beginUpdate: typing.ClassVar[QtCore.pyqtSignal]
    extraValueDoesNotExistChanged: typing.ClassVar[QtCore.pyqtSignal]
    extraIdentifierValueIndexChanged: typing.ClassVar[QtCore.pyqtSignal]
    extraIdentifierValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    filterJobCompleted: typing.ClassVar[QtCore.pyqtSignal]
    isLoadingChanged: typing.ClassVar[QtCore.pyqtSignal]
    parentFormFeatureChanged: typing.ClassVar[QtCore.pyqtSignal]
    formFeatureChanged: typing.ClassVar[QtCore.pyqtSignal]
    sortOrderChanged: typing.ClassVar[QtCore.pyqtSignal]
    orderExpressionChanged: typing.ClassVar[QtCore.pyqtSignal]
    filterExpressionChanged: typing.ClassVar[QtCore.pyqtSignal]
    filterValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    displayExpressionChanged: typing.ClassVar[QtCore.pyqtSignal]
    sourceLayerChanged: typing.ClassVar[QtCore.pyqtSignal]
    currentFeatureChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setFetchLimit(self, fetchLimit: int) -> None: ...
    def fetchLimit(self) -> int: ...
    def setFetchGeometry(self, fetchGeometry: bool) -> None: ...
    def fetchGeometry(self) -> bool: ...
    def setAllowNull(self, allowNull: bool) -> None: ...
    def allowNull(self) -> bool: ...
    def extraValueDoesNotExist(self) -> bool: ...
    def extraIdentifierValueIndex(self) -> int: ...
    def setExtraIdentifierValueToNull(self) -> None: ...
    def isLoading(self) -> bool: ...
    def setParentFormFeature(self, feature: QgsFeature) -> None: ...
    def parentFormFeature(self) -> QgsFeature: ...
    def setFormFeature(self, feature: QgsFeature) -> None: ...
    def formFeature(self) -> QgsFeature: ...
    def setSortOrder(self, sortOrder: QtCore.Qt.SortOrder) -> None: ...
    def sortOrder(self) -> QtCore.Qt.SortOrder: ...
    def setOrderExpression(self, orderExpression: str|None) -> None: ...
    def orderExpression(self) -> str: ...
    def setFilterExpression(self, filterExpression: str|None) -> None: ...
    def filterExpression(self) -> str: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def setFilterValue(self, filterValue: str|None) -> None: ...
    def filterValue(self) -> str: ...
    def setDisplayExpression(self, displayExpression: str|None) -> None: ...
    def displayExpression(self) -> str: ...
    def setSourceLayer(self, sourceLayer: QgsVectorLayer|None) -> None: ...
    def sourceLayer(self) -> QgsVectorLayer|None: ...


class QgsFeaturePickerModel(QgsFeaturePickerModelBase):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    featureChanged: typing.ClassVar[QtCore.pyqtSignal]
    def feature(self) -> QgsFeature: ...
    def setFeature(self, fid: int) -> None: ...
    def setExtraIdentifierValueToNull(self) -> None: ...


class QgsFeatureFilterModel(QgsFeaturePickerModelBase):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    extraIdentifierValuesChanged: typing.ClassVar[QtCore.pyqtSignal]
    identifierFieldsChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setExtraIdentifierValues(self, extraIdentifierValues: collections.abc.Iterable[typing.Any]) -> None: ...
    def extraIdentifierValues(self) -> list[typing.Any]: ...
    def setExtraIdentifierValueToNull(self) -> None: ...
    def setIdentifierFields(self, identifierFields: collections.abc.Iterable[str|None]) -> None: ...
    def identifierFields(self) -> list[str]: ...
    def identifierField(self) -> str: ...


class QgsFeatureIterator(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, iter: QgsAbstractFeatureIterator|None) -> None: ...
    @typing.overload
    def __init__(self, fi: 'QgsFeatureIterator') -> None: ...

    def compileFailed(self) -> bool: ...
    def compileStatus(self) -> QgsAbstractFeatureIterator.CompileStatus: ...
    def isClosed(self) -> bool: ...
    def isValid(self) -> bool: ...
    def close(self) -> bool: ...
    def rewind(self) -> bool: ...
    def nextFeature(self, f: QgsFeature) -> bool: ...
    def __next__(self) -> QgsFeature: ...
    def __iter__(self) -> 'QgsFeatureIterator|None': ...


class QgsFeatureRequest(PyQt6.sip.wrapper):

    class OrderByClause(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self, expression: str|None, ascending: bool = ...) -> None: ...
        @typing.overload
        def __init__(self, expression: str|None, ascending: bool, nullsfirst: bool) -> None: ...
        @typing.overload
        def __init__(self, expression: 'QgsExpression', ascending: bool = ...) -> None: ...
        @typing.overload
        def __init__(self, expression: 'QgsExpression', ascending: bool, nullsfirst: bool) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsFeatureRequest.OrderByClause') -> None: ...

        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def dump(self) -> str: ...
        def setNullsFirst(self, nullsFirst: bool) -> None: ...
        def nullsFirst(self) -> bool: ...
        def setAscending(self, ascending: bool) -> None: ...
        def ascending(self) -> bool: ...
        def prepare(self, context: QgsExpressionContext|None) -> bool: ...
        def expression(self) -> 'QgsExpression': ...

    class OrderBy(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, other: collections.abc.Iterable['QgsFeatureRequest.OrderByClause']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsFeatureRequest.OrderBy') -> None: ...

        def dump(self) -> str: ...
        def usedAttributeIndices(self, fields: 'QgsFields') -> typing.Any: ...
        def usedAttributes(self) -> set[str]: ...
        def load(self, elem: QtXml.QDomElement) -> None: ...
        def save(self, elem: QtXml.QDomElement) -> None: ...
        def list(self) -> list['QgsFeatureRequest.OrderByClause']: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...

    ALL_ATTRIBUTES = ... # type: str|None

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fid: int) -> None: ...
    @typing.overload
    def __init__(self, fids: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, rectangle: 'QgsRectangle') -> None: ...
    @typing.overload
    def __init__(self, expr: 'QgsExpression', context: QgsExpressionContext = ...) -> None: ...
    @typing.overload
    def __init__(self, rh: 'QgsFeatureRequest') -> None: ...

    def feedback(self) -> 'QgsFeedback|None': ...
    def setFeedback(self, feedback: 'QgsFeedback|None') -> None: ...
    def setRequestMayBeNested(self, requestMayBeNested: bool) -> 'QgsFeatureRequest': ...
    def requestMayBeNested(self) -> bool: ...
    def setTimeout(self, timeout: int) -> 'QgsFeatureRequest': ...
    def timeout(self) -> int: ...
    @deprecated("""""")
    def setConnectionTimeout(self, connectionTimeout: int) -> 'QgsFeatureRequest': ...
    @deprecated("""""")
    def connectionTimeout(self) -> int: ...
    def acceptFeature(self, feature: QgsFeature) -> bool: ...
    def setTransformErrorCallback(self, a0: typing.Callable[..., None]) -> 'QgsFeatureRequest': ...
    def setDestinationCrs(self, crs: 'QgsCoordinateReferenceSystem', context: 'QgsCoordinateTransformContext') -> 'QgsFeatureRequest': ...
    def setCoordinateTransform(self, transform: 'QgsCoordinateTransform') -> 'QgsFeatureRequest': ...
    def calculateTransform(self, sourceCrs: 'QgsCoordinateReferenceSystem') -> 'QgsCoordinateTransform': ...
    def transformContext(self) -> 'QgsCoordinateTransformContext': ...
    def destinationCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def coordinateTransform(self) -> 'QgsCoordinateTransform': ...
    def simplifyMethod(self) -> 'QgsSimplifyMethod': ...
    def setSimplifyMethod(self, simplifyMethod: 'QgsSimplifyMethod') -> 'QgsFeatureRequest': ...
    def subsetOfAttributes(self) -> list[int]: ...
    def setNoAttributes(self) -> 'QgsFeatureRequest': ...
    @typing.overload
    def setSubsetOfAttributes(self, attrs: collections.abc.Iterable[int]) -> 'QgsFeatureRequest': ...
    @typing.overload
    def setSubsetOfAttributes(self, attrNames: collections.abc.Iterable[str|None], fields: 'QgsFields') -> 'QgsFeatureRequest': ...
    @typing.overload
    def setSubsetOfAttributes(self, attrNames: collections.abc.Iterable[str|None], fields: 'QgsFields') -> 'QgsFeatureRequest': ...
    def flags(self) -> Qgis.FeatureRequestFlag: ...
    def setFlags(self, flags: Qgis.FeatureRequestFlag) -> 'QgsFeatureRequest': ...
    def limit(self) -> int: ...
    def setLimit(self, limit: int) -> 'QgsFeatureRequest': ...
    def setOrderBy(self, orderBy: 'QgsFeatureRequest.OrderBy') -> 'QgsFeatureRequest': ...
    def orderBy(self) -> 'QgsFeatureRequest.OrderBy': ...
    @typing.overload
    def addOrderBy(self, expression: str|None, ascending: bool = ...) -> 'QgsFeatureRequest': ...
    @typing.overload
    def addOrderBy(self, expression: str|None, ascending: bool, nullsfirst: bool) -> 'QgsFeatureRequest': ...
    def disableFilter(self) -> 'QgsFeatureRequest': ...
    def setExpressionContext(self, context: QgsExpressionContext) -> 'QgsFeatureRequest': ...
    def expressionContext(self) -> QgsExpressionContext|None: ...
    def combineFilterExpression(self, expression: str|None) -> 'QgsFeatureRequest': ...
    def filterExpression(self) -> 'QgsExpression|None': ...
    def setFilterExpression(self, expression: str|None) -> 'QgsFeatureRequest': ...
    def setInvalidGeometryCallback(self, a0: typing.Callable[..., None]) -> 'QgsFeatureRequest': ...
    def invalidGeometryCheck(self) -> Qgis.InvalidGeometryCheck: ...
    def setInvalidGeometryCheck(self, check: Qgis.InvalidGeometryCheck) -> 'QgsFeatureRequest': ...
    def filterFids(self) -> typing.Any: ...
    def setFilterFids(self, fids: typing.Any) -> 'QgsFeatureRequest': ...
    def filterFid(self) -> int: ...
    def setFilterFid(self, fid: int) -> 'QgsFeatureRequest': ...
    def distanceWithin(self) -> float: ...
    def referenceGeometry(self) -> 'QgsGeometry': ...
    def setDistanceWithin(self, geometry: 'QgsGeometry', distance: float) -> 'QgsFeatureRequest': ...
    def filterRect(self) -> 'QgsRectangle': ...
    def setFilterRect(self, rectangle: 'QgsRectangle') -> 'QgsFeatureRequest': ...
    def spatialFilterType(self) -> Qgis.SpatialFilterType: ...
    def filterType(self) -> Qgis.FeatureRequestFilterType: ...
    def compare(self, other: 'QgsFeatureRequest') -> bool: ...


class QgsAbstractFeatureSource(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractFeatureSource') -> None: ...

    def iteratorClosed(self, it: QgsAbstractFeatureIterator|None) -> None: ...
    def iteratorOpened(self, it: QgsAbstractFeatureIterator|None) -> None: ...
    def getFeatures(self, request: QgsFeatureRequest = ...) -> QgsFeatureIterator: ...


class QgsFeatureStore(QgsFeatureSink):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fields: 'QgsFields', crs: 'QgsCoordinateReferenceSystem') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFeatureStore') -> None: ...

    def params(self) -> dict[str, typing.Any]: ...
    def setParams(self, parameters: dict[str|None, typing.Any]) -> None: ...
    def features(self) -> list[QgsFeature]: ...
    def __bool__(self) -> int: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def addFeatures(self, features: collections.abc.Iterable[QgsFeature], flags: QgsFeatureSink.Flag = ...) -> bool: ...
    def addFeature(self, feature: QgsFeature, flags: QgsFeatureSink.Flag = ...) -> bool: ...
    def setCrs(self, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...
    def setFields(self, fields: 'QgsFields') -> None: ...
    def fields(self) -> 'QgsFields': ...


class QgsFeedback(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    processedCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    progressChanged: typing.ClassVar[QtCore.pyqtSignal]
    canceled: typing.ClassVar[QtCore.pyqtSignal]
    def cancel(self) -> None: ...
    @staticmethod
    def createScaledFeedback(parentFeedback: 'QgsFeedback|None', startPercentage: float, endPercentage: float) -> 'QgsFeedback'|None: ...
    def setProcessedCount(self, processedCount: int) -> None: ...
    def processedCount(self) -> int: ...
    def progress(self) -> float: ...
    def setProgress(self, progress: float) -> None: ...
    def isCanceled(self) -> bool: ...


class QgsField(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, name: str|None = ..., type: QtCore.QMetaType.Type = ..., typeName: str|None = ..., len: int = ..., prec: int = ..., comment: str|None = ..., subType: QtCore.QMetaType.Type = ...) -> None: ...
    @typing.overload
    @deprecated("""""")
    def __init__(self, name: str|None, type: typing.Any, typeName: str|None = ..., len: int = ..., prec: int = ..., comment: str|None = ..., subType: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsField') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def setMergePolicy(self, policy: Qgis.FieldDomainMergePolicy) -> None: ...
    def mergePolicy(self) -> Qgis.FieldDomainMergePolicy: ...
    def setDuplicatePolicy(self, policy: Qgis.FieldDuplicatePolicy) -> None: ...
    def duplicatePolicy(self) -> Qgis.FieldDuplicatePolicy: ...
    def setSplitPolicy(self, policy: Qgis.FieldDomainSplitPolicy) -> None: ...
    def splitPolicy(self) -> Qgis.FieldDomainSplitPolicy: ...
    def isReadOnly(self) -> bool: ...
    def setReadOnly(self, readOnly: bool) -> None: ...
    def editorWidgetSetup(self) -> QgsEditorWidgetSetup: ...
    def setEditorWidgetSetup(self, v: QgsEditorWidgetSetup) -> None: ...
    def convertCompatible(self, v: typing.Any) -> bool: ...
    @staticmethod
    def readableConfigurationFlag(flag: Qgis.FieldConfigurationFlag) -> str: ...
    def displayString(self, v: typing.Any) -> str: ...
    def setConfigurationFlags(self, flags: Qgis.FieldConfigurationFlag) -> None: ...
    def configurationFlags(self) -> Qgis.FieldConfigurationFlag: ...
    def setAlias(self, alias: str|None) -> None: ...
    def alias(self) -> str: ...
    def setConstraints(self, constraints: 'QgsFieldConstraints') -> None: ...
    def constraints(self) -> 'QgsFieldConstraints': ...
    def setDefaultValueDefinition(self, defaultValueDefinition: QgsDefaultValue) -> None: ...
    def defaultValueDefinition(self) -> QgsDefaultValue: ...
    def setComment(self, comment: str|None) -> None: ...
    def setPrecision(self, precision: int) -> None: ...
    def setLength(self, len: int) -> None: ...
    def setTypeName(self, typeName: str|None) -> None: ...
    @typing.overload
    def setSubType(self, subType: QtCore.QMetaType.Type) -> None: ...
    @typing.overload
    @deprecated("""""")
    def setSubType(self, subType: typing.Any) -> None: ...
    @typing.overload
    def setType(self, type: QtCore.QMetaType.Type) -> None: ...
    @typing.overload
    @deprecated("""""")
    def setType(self, type: typing.Any) -> None: ...
    def setName(self, name: str|None) -> None: ...
    def isDateOrTime(self) -> bool: ...
    def isNumeric(self) -> bool: ...
    @typing.overload
    def setMetadata(self, metadata: dict[int, typing.Any]) -> None: ...
    @typing.overload
    def setMetadata(self, property: int, value: typing.Any) -> None: ...
    @typing.overload
    def metadata(self) -> dict[int, typing.Any]: ...
    @typing.overload
    def metadata(self, property: int) -> typing.Any: ...
    def comment(self) -> str: ...
    def precision(self) -> int: ...
    def length(self) -> int: ...
    def typeName(self) -> str: ...
    def subType(self) -> QtCore.QMetaType.Type: ...
    def type(self) -> QtCore.QMetaType.Type: ...
    def friendlyTypeString(self) -> str: ...
    def displayType(self, showConstraints: bool = ...) -> str: ...
    def displayNameWithAlias(self) -> str: ...
    def displayName(self) -> str: ...
    def name(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsFieldConstraints(PyQt6.sip.wrapper):

    class ConstraintStrength(enum.IntEnum):
        ConstraintStrengthNotSet = ... # type: QgsFieldConstraints.ConstraintStrength
        ConstraintStrengthHard = ... # type: QgsFieldConstraints.ConstraintStrength
        ConstraintStrengthSoft = ... # type: QgsFieldConstraints.ConstraintStrength

    class ConstraintOrigin(enum.IntEnum):
        ConstraintOriginNotSet = ... # type: QgsFieldConstraints.ConstraintOrigin
        ConstraintOriginProvider = ... # type: QgsFieldConstraints.ConstraintOrigin
        ConstraintOriginLayer = ... # type: QgsFieldConstraints.ConstraintOrigin

    class Constraint(enum.IntEnum):
        ConstraintNotNull = ... # type: QgsFieldConstraints.Constraint
        ConstraintUnique = ... # type: QgsFieldConstraints.Constraint
        ConstraintExpression = ... # type: QgsFieldConstraints.Constraint

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFieldConstraints') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def setDomainName(self, domain: str|None) -> None: ...
    def domainName(self) -> str: ...
    def setConstraintExpression(self, expression: str|None, description: str|None = ...) -> None: ...
    def constraintDescription(self) -> str: ...
    def constraintExpression(self) -> str: ...
    def removeConstraint(self, constraint: 'QgsFieldConstraints.Constraint') -> None: ...
    def setConstraint(self, constraint: 'QgsFieldConstraints.Constraint', origin: 'QgsFieldConstraints.ConstraintOrigin' = ...) -> None: ...
    def setConstraintStrength(self, constraint: 'QgsFieldConstraints.Constraint', strength: 'QgsFieldConstraints.ConstraintStrength') -> None: ...
    def constraintStrength(self, constraint: 'QgsFieldConstraints.Constraint') -> 'QgsFieldConstraints.ConstraintStrength': ...
    def constraintOrigin(self, constraint: 'QgsFieldConstraints.Constraint') -> 'QgsFieldConstraints.ConstraintOrigin': ...
    def constraints(self) -> 'QgsFieldConstraints.Constraint': ...


class QgsFieldFormatterContext(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFieldFormatterContext') -> None: ...

    def setProject(self, project: 'QgsProject|None') -> None: ...
    def project(self) -> 'QgsProject|None': ...


class QgsFieldFormatter(PyQt6.sip.wrapper):

    class Flag(enum.IntEnum):
        CanProvideAvailableValues = ... # type: QgsFieldFormatter.Flag

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFieldFormatter') -> None: ...

    def setFlags(self, flags: 'QgsFieldFormatter.Flag') -> None: ...
    def flags(self) -> 'QgsFieldFormatter.Flag': ...
    def availableValues(self, config: dict[str|None, typing.Any], countLimit: int, context: QgsFieldFormatterContext) -> list[typing.Any]: ...
    def createCache(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any]) -> typing.Any: ...
    def alignmentFlag(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any]) -> QtCore.Qt.AlignmentFlag: ...
    def sortValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> typing.Any: ...
    def representValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsFieldFormatterRegistry(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    fieldFormatterRemoved: typing.ClassVar[QtCore.pyqtSignal]
    fieldFormatterAdded: typing.ClassVar[QtCore.pyqtSignal]
    def fallbackFieldFormatter(self) -> QgsFieldFormatter|None: ...
    def fieldFormatter(self, id: str|None) -> QgsFieldFormatter|None: ...
    @typing.overload
    def removeFieldFormatter(self, formatter: QgsFieldFormatter|None) -> None: ...
    @typing.overload
    def removeFieldFormatter(self, id: str|None) -> None: ...
    def addFieldFormatter(self, formatter: QgsFieldFormatter|None) -> None: ...


class QgsFieldModel(QtCore.QAbstractItemModel):

    class CustomRole(enum.IntEnum):
        FieldName = ... # type: QgsFieldModel.CustomRole
        FieldIndex = ... # type: QgsFieldModel.CustomRole
        Expression = ... # type: QgsFieldModel.CustomRole
        IsExpression = ... # type: QgsFieldModel.CustomRole
        ExpressionValidity = ... # type: QgsFieldModel.CustomRole
        FieldType = ... # type: QgsFieldModel.CustomRole
        FieldOrigin = ... # type: QgsFieldModel.CustomRole
        IsEmpty = ... # type: QgsFieldModel.CustomRole
        EditorWidgetType = ... # type: QgsFieldModel.CustomRole
        JoinedFieldIsEditable = ... # type: QgsFieldModel.CustomRole
        FieldIsWidgetEditable = ... # type: QgsFieldModel.CustomRole

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def updateModel(self) -> None: ...
    def setLayer(self, layer: QgsVectorLayer|None) -> None: ...
    def fields(self) -> 'QgsFields': ...
    def setFields(self, fields: 'QgsFields') -> None: ...
    @staticmethod
    def fieldToolTipExtended(field: QgsField, layer: QgsVectorLayer|None) -> str: ...
    @staticmethod
    def fieldToolTip(field: QgsField) -> str: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def layer(self) -> QgsVectorLayer|None: ...
    def removeExpression(self) -> None: ...
    def setExpression(self, expression: str|None) -> None: ...
    def isField(self, expression: str|None) -> bool: ...
    def allowEmptyFieldName(self) -> bool: ...
    def setAllowEmptyFieldName(self, allowEmpty: bool) -> None: ...
    def allowExpression(self) -> bool: ...
    def setAllowExpression(self, allowExpression: bool) -> None: ...
    def indexFromName(self, fieldName: str|None) -> QtCore.QModelIndex: ...


class QgsFieldProxyModel(QtCore.QSortFilterProxyModel):

    class Filter(enum.IntEnum):
        String = ... # type: QgsFieldProxyModel.Filter
        Int = ... # type: QgsFieldProxyModel.Filter
        LongLong = ... # type: QgsFieldProxyModel.Filter
        Double = ... # type: QgsFieldProxyModel.Filter
        Numeric = ... # type: QgsFieldProxyModel.Filter
        Date = ... # type: QgsFieldProxyModel.Filter
        Time = ... # type: QgsFieldProxyModel.Filter
        HideReadOnly = ... # type: QgsFieldProxyModel.Filter
        DateTime = ... # type: QgsFieldProxyModel.Filter
        Binary = ... # type: QgsFieldProxyModel.Filter
        Boolean = ... # type: QgsFieldProxyModel.Filter
        OriginProvider = ... # type: QgsFieldProxyModel.Filter
        AllTypes = ... # type: QgsFieldProxyModel.Filter

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...
    def filterAcceptsRow(self, source_row: int, source_parent: QtCore.QModelIndex) -> bool: ...
    def filters(self) -> 'QgsFieldProxyModel.Filter': ...
    def setFilters(self, filters: 'QgsFieldProxyModel.Filter') -> 'QgsFieldProxyModel|None': ...
    def sourceFieldModel(self) -> QgsFieldModel|None: ...


class QgsFields(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsFields') -> None: ...
    @typing.overload
    def __init__(self, fields: typing.Any) -> None: ...

    def __setitem__(self, key: int, field: QgsField) -> None: ...
    @typing.overload
    @staticmethod
    def iconForFieldType(type: QtCore.QMetaType.Type, subType: QtCore.QMetaType.Type = ..., typeString: str|None = ...) -> QtGui.QIcon: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def iconForFieldType(type: typing.Any, subType: typing.Any, typeString: str|None = ...) -> QtGui.QIcon: ...
    def iconForField(self, fieldIdx: int, considerOrigin: bool = ...) -> QtGui.QIcon: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def toList(self) -> typing.Any: ...
    def allAttributesList(self) -> list[int]: ...
    def lookupField(self, fieldName: str|None) -> int: ...
    def indexOf(self, fieldName: str|None) -> int: ...
    def indexFromName(self, fieldName: str|None) -> int: ...
    def fieldOriginIndex(self, fieldIdx: int) -> int: ...
    def fieldOrigin(self, fieldIdx: int) -> Qgis.FieldOrigin: ...
    @typing.overload
    def field(self, fieldIdx: int) -> QgsField: ...
    @typing.overload
    def field(self, name: str|None) -> QgsField: ...
    def at(self, i: int) -> QgsField: ...
    @typing.overload
    def __getitem__(self, i: int) -> QgsField: ...
    @typing.overload
    def __getitem__(self, name: str|None) -> QgsField: ...
    def exists(self, i: int) -> bool: ...
    def names(self) -> list[str]: ...
    def size(self) -> int: ...
    def __bool__(self) -> int: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def extend(self, other: 'QgsFields') -> None: ...
    def remove(self, fieldIdx: int) -> None: ...
    def appendExpressionField(self, field: QgsField, originIndex: int) -> bool: ...
    def rename(self, fieldIdx: int, name: str|None) -> bool: ...
    @typing.overload
    def append(self, field: QgsField, origin: Qgis.FieldOrigin = ..., originIndex: int = ...) -> bool: ...
    @typing.overload
    def append(self, fields: typing.Any, origin: Qgis.FieldOrigin = ...) -> bool: ...
    @typing.overload
    def append(self, fields: 'QgsFields') -> bool: ...
    def clear(self) -> None: ...


class QgsFileFilterGenerator(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFileFilterGenerator') -> None: ...

    def createFileFilter(self) -> str: ...


class QgsFileUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFileUtils') -> None: ...

    @staticmethod
    def uniquePath(path: str|None) -> str: ...
    @staticmethod
    def splitPathToComponents(path: str|None) -> list[str]: ...
    @staticmethod
    def renameDataset(oldPath: str|None, newPath: str|None, flags: Qgis.FileOperationFlag = ...) -> typing.Tuple[bool, str]: ...
    @staticmethod
    def sidecarFilesForPath(path: str|None) -> set[str]: ...
    @staticmethod
    def pathIsSlowDevice(path: str|None) -> bool: ...
    @staticmethod
    def driveType(path: str|None) -> Qgis.DriveType: ...
    @staticmethod
    def findFile(file: str|None, basepath: str|None = ..., maxClimbs: int = ..., searchCeiling: int = ..., currentDir: str|None = ...) -> list[str]: ...
    @staticmethod
    def findClosestExistingPath(path: str|None) -> str: ...
    @staticmethod
    def stringToSafeFilename(string: str|None) -> str: ...
    @staticmethod
    def addExtensionFromFilter(fileName: str|None, filter: str|None) -> str: ...
    @staticmethod
    def ensureFileNameHasExtension(fileName: str|None, extensions: collections.abc.Iterable[str|None]) -> str: ...
    @staticmethod
    def fileMatchesFilter(fileName: str|None, filter: str|None) -> bool: ...
    @staticmethod
    def wildcardsFromFilter(filter: str|None) -> str: ...
    @staticmethod
    def extensionsFromFilter(filter: str|None) -> list[str]: ...
    @staticmethod
    def representFileSize(bytes: int) -> str: ...


class QgsFontUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFontUtils') -> None: ...

    @staticmethod
    def createFont(family: str|None, pointSize: int = ..., weight: int = ..., italic: bool = ...) -> QtGui.QFont: ...
    @staticmethod
    def setFontFamily(font: QtGui.QFont, family: str|None) -> None: ...
    @staticmethod
    def recentFontFamilies() -> list[str]: ...
    @staticmethod
    def addRecentFontFamily(family: str|None) -> None: ...
    @staticmethod
    def asCSS(font: QtGui.QFont, pointToPixelMultiplier: float = ...) -> str: ...
    @staticmethod
    def untranslateNamedStyle(namedStyle: str|None) -> str: ...
    @staticmethod
    def translateNamedStyle(namedStyle: str|None) -> str: ...
    @staticmethod
    def fromMimeData(data: QtCore.QMimeData|None) -> typing.Tuple[QtGui.QFont, bool]: ...
    @staticmethod
    def toMimeData(font: QtGui.QFont) -> QtCore.QMimeData|None: ...
    @staticmethod
    def setFromXmlChildNode(font: QtGui.QFont, element: QtXml.QDomElement, childNode: str|None) -> bool: ...
    @staticmethod
    def setFromXmlElement(font: QtGui.QFont, element: QtXml.QDomElement) -> bool: ...
    @staticmethod
    def toXmlElement(font: QtGui.QFont, document: QtXml.QDomDocument, elementName: str|None) -> QtXml.QDomElement: ...
    @staticmethod
    def getStandardTestFont(style: str|None = ..., pointsize: int = ...) -> QtGui.QFont: ...
    @staticmethod
    def loadStandardTestFonts(loadstyles: collections.abc.Iterable[str|None]) -> bool: ...
    @staticmethod
    def standardTestFontFamily() -> str: ...
    @staticmethod
    def updateFontViaStyle(f: QtGui.QFont, fontstyle: str|None, fallback: bool = ...) -> bool: ...
    @staticmethod
    def fontFamilyMatchOnSystem(family: str|None, chosen: str|None = ...) -> typing.Tuple[bool, bool]: ...
    @staticmethod
    def resolveFontStyleName(font: QtGui.QFont) -> str: ...
    @staticmethod
    def fontFamilyHasStyle(family: str|None, style: str|None) -> bool: ...
    @staticmethod
    def fontFamilyOnSystem(family: str|None) -> bool: ...
    @staticmethod
    def fontMatchOnSystem(f: QtGui.QFont) -> bool: ...


class QgsGeometryOptions(QtCore.QObject):

    def __init__(self) -> None: ...

    geometryPrecisionChanged: typing.ClassVar[QtCore.pyqtSignal]
    removeDuplicateNodesChanged: typing.ClassVar[QtCore.pyqtSignal]
    geometryChecksChanged: typing.ClassVar[QtCore.pyqtSignal]
    checkConfigurationChanged: typing.ClassVar[QtCore.pyqtSignal]
    def readXml(self, node: QtXml.QDomNode) -> None: ...
    def writeXml(self, node: QtXml.QDomNode) -> None: ...
    def setCheckConfiguration(self, checkId: str|None, checkConfiguration: dict[str|None, typing.Any]) -> None: ...
    def checkConfiguration(self, checkId: str|None) -> dict[str, typing.Any]: ...
    def setGeometryChecks(self, geometryChecks: collections.abc.Iterable[str|None]) -> None: ...
    def geometryChecks(self) -> list[str]: ...
    def apply(self, geometry: 'QgsGeometry') -> None: ...
    def isActive(self) -> bool: ...
    def setGeometryPrecision(self, value: float) -> None: ...
    def geometryPrecision(self) -> float: ...
    def setRemoveDuplicateNodes(self, value: bool) -> None: ...
    def removeDuplicateNodes(self) -> bool: ...


class QgsAbstractGeometrySimplifier(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractGeometrySimplifier') -> None: ...

    @typing.overload
    @staticmethod
    def isGeneralizableByDeviceBoundingBox(envelope: 'QgsRectangle', mapToPixelTol: float = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def isGeneralizableByDeviceBoundingBox(points: collections.abc.Iterable[QtCore.QPointF], mapToPixelTol: float = ...) -> bool: ...
    @typing.overload
    def simplify(self, geometry: 'QgsGeometry') -> 'QgsGeometry': ...
    @typing.overload
    def simplify(self, geometry: 'QgsAbstractGeometry|None') -> 'QgsAbstractGeometry|None': ...


class QgsTopologyPreservingSimplifier(QgsAbstractGeometrySimplifier):

    @typing.overload
    def __init__(self, tolerance: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTopologyPreservingSimplifier') -> None: ...

    @typing.overload
    def simplify(self, geometry: 'QgsGeometry') -> 'QgsGeometry': ...
    @typing.overload
    def simplify(self, geometry: 'QgsAbstractGeometry|None') -> 'QgsAbstractGeometry|None': ...


class QgsGeometryValidator(QtCore.QThread):

    def __init__(self, geometry: 'QgsGeometry', errors: collections.abc.Iterable['QgsGeometry.Error'] = ..., method: Qgis.GeometryValidationEngine = ...) -> None: ...

    def addError(self, a0: 'QgsGeometry.Error') -> None: ...
    validationFinished: typing.ClassVar[QtCore.pyqtSignal]
    errorFound: typing.ClassVar[QtCore.pyqtSignal]
    @staticmethod
    def validateGeometry(geometry: 'QgsGeometry', method: Qgis.GeometryValidationEngine = ...) -> list['QgsGeometry.Error']: ...
    def stop(self) -> None: ...
    def run(self) -> None: ...


class QgsGml(QtCore.QObject):

    def __init__(self, typeName: str|None, geometryAttribute: str|None, fields: QgsFields) -> None: ...

    dataProgressAndSteps: typing.ClassVar[QtCore.pyqtSignal]
    totalStepsUpdate: typing.ClassVar[QtCore.pyqtSignal]
    dataReadProgress: typing.ClassVar[QtCore.pyqtSignal]
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...
    def idsMap(self) -> typing.Any: ...
    def featuresMap(self) -> typing.Any: ...
    def getFeatures(self, data: QtCore.QByteArray|bytes|bytearray|memoryview, extent: 'QgsRectangle|None' = ...) -> typing.Tuple[int, Qgis.WkbType|None]: ...
    def getFeaturesUri(self, uri: str|None, extent: 'QgsRectangle|None' = ..., userName: str|None = ..., password: str|None = ..., authcfg: str|None = ...) -> typing.Tuple[int, Qgis.WkbType|None]: ...


class QgsGmlFeatureClass(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name: str|None, path: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGmlFeatureClass') -> None: ...

    def geometryAttributes(self) -> list[str]: ...
    def path(self) -> str: ...
    def fieldIndex(self, name: str|None) -> int: ...
    def fields(self) -> typing.Any: ...


class QgsGmlSchema(QtCore.QObject):

    def __init__(self) -> None: ...

    def error(self) -> QgsError: ...
    def geometryAttributes(self, typeName: str|None) -> list[str]: ...
    def fields(self, typeName: str|None) -> typing.Any: ...
    def typeNames(self) -> list[str]: ...
    def guessSchema(self, data: QtCore.QByteArray|bytes|bytearray|memoryview) -> bool: ...
    def parseXSD(self, xml: QtCore.QByteArray|bytes|bytearray|memoryview) -> bool: ...


class QgsGroupedFeatureFilterProvider(QgsFeatureFilterProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGroupedFeatureFilterProvider') -> None: ...

    def addProvider(self, provider: QgsFeatureFilterProvider|None) -> 'QgsGroupedFeatureFilterProvider': ...
    def clone(self) -> 'QgsGroupedFeatureFilterProvider|None': ...
    def layerAttributes(self, layer: QgsVectorLayer|None, attributes: collections.abc.Iterable[str|None]) -> list[str]: ...
    @typing.overload
    @deprecated("""""")
    def filterFeatures(self, layer: QgsVectorLayer|None, filterFeatures: QgsFeatureRequest) -> None: ...
    @typing.overload
    def filterFeatures(self, layerId: str|None, filterFeatures: QgsFeatureRequest) -> None: ...
    @deprecated("""""")
    def isFilterThreadSafe(self) -> bool: ...


class QgsGroupLayer(QgsMapLayer):

    class LayerOptions(PyQt6.sip.wrapper):

        transformContext = ... # type: 'QgsCoordinateTransformContext'

        @typing.overload
        def __init__(self, transformContext: 'QgsCoordinateTransformContext') -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsGroupLayer.LayerOptions') -> None: ...

    def __init__(self, name: str|None, options: 'QgsGroupLayer.LayerOptions') -> None: ...

    def prepareLayersForRemovalFromGroup(self) -> None: ...
    def setPaintEffect(self, effect: 'QgsPaintEffect|None') -> None: ...
    def paintEffect(self) -> 'QgsPaintEffect|None': ...
    def childLayers(self) -> list[QgsMapLayer]: ...
    def setChildLayers(self, layers: collections.abc.Iterable[QgsMapLayer]) -> None: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def htmlMetadata(self) -> str: ...
    def dataProvider(self) -> 'QgsDataProvider|None': ...
    def readSymbology(self, node: QtXml.QDomNode, errorMessage: str|None, context: 'QgsReadWriteContext', categories: QgsMapLayer.StyleCategory = ...) -> bool: ...
    def writeSymbology(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str|None, a3: 'QgsReadWriteContext', categories: QgsMapLayer.StyleCategory = ...) -> bool: ...
    def writeXml(self, layer_node: QtXml.QDomNode, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> bool: ...
    def readXml(self, layerNode: QtXml.QDomNode, context: 'QgsReadWriteContext') -> bool: ...
    def setTransformContext(self, context: 'QgsCoordinateTransformContext') -> None: ...
    def extent(self) -> 'QgsRectangle': ...
    def createMapRenderer(self, rendererContext: 'QgsRenderContext') -> 'QgsMapLayerRenderer|None': ...
    def clone(self) -> 'QgsGroupLayer|None': ...
    def __repr__(self) -> typing.Any: ...


class QgsHistogram(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsHistogram') -> None: ...

    def counts(self, bins: int) -> list[int]: ...
    def binEdges(self, bins: int) -> list[float]: ...
    def optimalNumberBins(self) -> int: ...
    def optimalBinWidth(self) -> float: ...
    @typing.overload
    def setValues(self, values: collections.abc.Iterable[float]) -> None: ...
    @typing.overload
    def setValues(self, layer: QgsVectorLayer|None, fieldOrExpression: str|None, feedback: QgsFeedback|None = ...) -> bool: ...


class QgsHstoreUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsHstoreUtils') -> None: ...

    @staticmethod
    def build(map: dict[str|None, typing.Any]) -> str: ...
    @staticmethod
    def parse(string: str|None) -> dict[str, typing.Any]: ...


class QgsHtmlUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsHtmlUtils') -> None: ...

    @staticmethod
    def buildBulletList(values: collections.abc.Iterable[str|None]) -> str: ...


class QgsIconUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsIconUtils') -> None: ...

    @staticmethod
    def iconForLayerType(type: Qgis.LayerType) -> QtGui.QIcon: ...
    @staticmethod
    def iconForLayer(layer: QgsMapLayer|None) -> QtGui.QIcon: ...
    @staticmethod
    def iconTiledScene() -> QtGui.QIcon: ...
    @staticmethod
    def iconPointCloud() -> QtGui.QIcon: ...
    @staticmethod
    def iconVectorTile() -> QtGui.QIcon: ...
    @staticmethod
    def iconMesh() -> QtGui.QIcon: ...
    @staticmethod
    def iconDefaultLayer() -> QtGui.QIcon: ...
    @staticmethod
    def iconRaster() -> QtGui.QIcon: ...
    @staticmethod
    def iconTable() -> QtGui.QIcon: ...
    @staticmethod
    def iconGeometryCollection() -> QtGui.QIcon: ...
    @staticmethod
    def iconPolygon() -> QtGui.QIcon: ...
    @staticmethod
    def iconLine() -> QtGui.QIcon: ...
    @staticmethod
    def iconPoint() -> QtGui.QIcon: ...
    @staticmethod
    def iconForGeometryType(typeGroup: Qgis.GeometryType) -> QtGui.QIcon: ...
    @staticmethod
    def iconForWkbType(type: Qgis.WkbType) -> QtGui.QIcon: ...


class QgsIdentifyContext(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsIdentifyContext') -> None: ...

    def setZRange(self, range: 'QgsDoubleRange') -> None: ...
    def zRange(self) -> 'QgsDoubleRange': ...
    def isTemporal(self) -> bool: ...
    def temporalRange(self) -> 'QgsDateTimeRange': ...
    def setTemporalRange(self, range: 'QgsDateTimeRange') -> None: ...


class QgsImageCache(QgsAbstractContentCacheBase):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    remoteImageFetched: typing.ClassVar[QtCore.pyqtSignal]
    def prepareAnimation(self, path: str|None) -> None: ...
    def nextFrameDelay(self, path: str|None, currentFrame: int = ..., blocking: bool = ...) -> int: ...
    def totalFrameCount(self, path: str|None, blocking: bool = ...) -> int: ...
    def originalSize(self, path: str|None, blocking: bool = ...) -> QtCore.QSize: ...
    def pathAsImage(self, path: str|None, size: QtCore.QSize, keepAspectRatio: bool, opacity: float, blocking: bool = ..., targetDpi: float = ..., frameNumber: int = ...) -> typing.Tuple[QtGui.QImage, bool]: ...
    def maximumSize(self) -> int: ...


class QgsInterval(PyQt6.sip.wrapper):

    DAY = ... # type: int
    HOUR = ... # type: int
    MINUTE = ... # type: int
    MONTHS = ... # type: int
    WEEKS = ... # type: int
    YEARS = ... # type: int

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, seconds: float) -> None: ...
    @typing.overload
    def __init__(self, duration: float, unit: Qgis.TemporalUnit) -> None: ...
    @typing.overload
    def __init__(self, years: float, months: float, weeks: float, days: float, hours: float, minutes: float, seconds: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsInterval') -> None: ...

    @staticmethod
    def fromString(string: str|None) -> 'QgsInterval': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def originalUnit(self) -> Qgis.TemporalUnit: ...
    def originalDuration(self) -> float: ...
    def setValid(self, valid: bool) -> None: ...
    def isValid(self) -> bool: ...
    def setSeconds(self, seconds: float) -> None: ...
    def seconds(self) -> float: ...
    def setMinutes(self, minutes: float) -> None: ...
    def minutes(self) -> float: ...
    def setHours(self, hours: float) -> None: ...
    def hours(self) -> float: ...
    def setDays(self, days: float) -> None: ...
    def days(self) -> float: ...
    def setWeeks(self, weeks: float) -> None: ...
    def weeks(self) -> float: ...
    def setMonths(self, months: float) -> None: ...
    def months(self) -> float: ...
    def setYears(self, years: float) -> None: ...
    def years(self) -> float: ...
    def __repr__(self) -> typing.Any: ...


class QgsJsonExporter(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, vectorLayer: QgsVectorLayer|None = ..., precision: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsJsonExporter') -> None: ...

    def setDestinationCrs(self, destinationCrs: 'QgsCoordinateReferenceSystem') -> None: ...
    def exportFeatures(self, features: collections.abc.Iterable[QgsFeature], indent: int = ...) -> str: ...
    def exportFeature(self, feature: QgsFeature, extraProperties: dict[str|None, typing.Any] = ..., id: typing.Any = ..., indent: int = ...) -> str: ...
    def useFieldFormatters(self) -> bool: ...
    def setUseFieldFormatters(self, useFieldFormatters: bool) -> None: ...
    def excludedAttributes(self) -> list[int]: ...
    def setExcludedAttributes(self, attributes: collections.abc.Iterable[int]) -> None: ...
    def attributes(self) -> list[int]: ...
    def setAttributes(self, attributes: collections.abc.Iterable[int]) -> None: ...
    def setTransformGeometries(self, activate: bool) -> None: ...
    def sourceCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def setSourceCrs(self, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    def vectorLayer(self) -> QgsVectorLayer|None: ...
    def setVectorLayer(self, vectorLayer: QgsVectorLayer|None) -> None: ...
    def attributeDisplayName(self) -> bool: ...
    def setAttributeDisplayName(self, displayName: bool) -> None: ...
    def includeRelated(self) -> bool: ...
    def setIncludeRelated(self, includeRelated: bool) -> None: ...
    def includeAttributes(self) -> bool: ...
    def setIncludeAttributes(self, includeAttributes: bool) -> None: ...
    def includeGeometry(self) -> bool: ...
    def setIncludeGeometry(self, includeGeometry: bool) -> None: ...
    def precision(self) -> int: ...
    def setPrecision(self, precision: int) -> None: ...


class QgsJsonUtils(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsJsonUtils') -> None: ...

    @staticmethod
    def geometryFromGeoJson(geometry: str|None) -> 'QgsGeometry': ...
    @typing.overload
    @staticmethod
    def parseArray(json: str|None, type: QtCore.QMetaType.Type = ...) -> list[typing.Any]: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def parseArray(json: str|None, type: typing.Any) -> list[typing.Any]: ...
    @staticmethod
    def exportAttributes(feature: QgsFeature, layer: QgsVectorLayer|None = ..., attributeWidgetCaches: collections.abc.Iterable[typing.Any] = ...) -> str: ...
    @staticmethod
    def encodeValue(value: typing.Any) -> str: ...
    @staticmethod
    def stringToFields(string: str|None) -> QgsFields: ...
    @staticmethod
    def stringToFeatureList(string: str|None, fields: QgsFields = ...) -> list[QgsFeature]: ...


class QgsLayerDefinition(PyQt6.sip.wrapper):

    class DependencySorter(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self, doc: QtXml.QDomDocument) -> None: ...
        @typing.overload
        def __init__(self, fileName: str|None) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsLayerDefinition.DependencySorter') -> None: ...

        def isLayerDependent(self, layerId: str|None) -> bool: ...
        def hasMissingDependency(self) -> bool: ...
        def hasCycle(self) -> bool: ...
        def sortedLayerIds(self) -> list[str]: ...
        def sortedLayerNodes(self) -> list[QtXml.QDomNode]: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLayerDefinition') -> None: ...

    @typing.overload
    @staticmethod
    def loadLayerDefinitionLayers(document: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> list[QgsMapLayer]: ...
    @typing.overload
    @staticmethod
    def loadLayerDefinitionLayers(qlrfile: str|None) -> list[QgsMapLayer]: ...
    @staticmethod
    def exportLayerDefinitionLayers(layers: collections.abc.Iterable[QgsMapLayer], context: 'QgsReadWriteContext') -> QtXml.QDomDocument: ...
    @typing.overload
    @staticmethod
    def exportLayerDefinition(path: str|None, selectedTreeNodes: collections.abc.Iterable['QgsLayerTreeNode']) -> typing.Tuple[bool, str]: ...
    @typing.overload
    @staticmethod
    def exportLayerDefinition(path: str|None, selectedTreeNodes: collections.abc.Iterable['QgsLayerTreeNode'], pathType: Qgis.FilePathType) -> typing.Tuple[bool, str]: ...
    @typing.overload
    @staticmethod
    def exportLayerDefinition(doc: QtXml.QDomDocument, selectedTreeNodes: collections.abc.Iterable['QgsLayerTreeNode'], context: 'QgsReadWriteContext') -> typing.Tuple[bool, str]: ...
    @typing.overload
    @staticmethod
    def loadLayerDefinition(path: str|None, project: 'QgsProject|None', rootGroup: 'QgsLayerTreeGroup|None', insertMethod: Qgis.LayerTreeInsertionMethod = ..., insertPoint: 'QgsLayerTreeRegistryBridge.InsertionPoint|None' = ...) -> typing.Tuple[bool, str]: ...
    @typing.overload
    @staticmethod
    def loadLayerDefinition(doc: QtXml.QDomDocument, project: 'QgsProject|None', rootGroup: 'QgsLayerTreeGroup|None', context: 'QgsReadWriteContext', insertMethod: Qgis.LayerTreeInsertionMethod = ..., insertPoint: 'QgsLayerTreeRegistryBridge.InsertionPoint|None' = ...) -> typing.Tuple[bool, str]: ...


class QgsLayerNotesUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLayerNotesUtils') -> None: ...

    @staticmethod
    def removeNotes(layer: QgsMapLayer|None) -> None: ...
    @staticmethod
    def layerHasNotes(layer: QgsMapLayer|None) -> bool: ...
    @staticmethod
    def setLayerNotes(layer: QgsMapLayer|None, notes: str|None) -> None: ...
    @staticmethod
    def layerNotes(layer: QgsMapLayer|None) -> str: ...


class QgsLegendRenderer(PyQt6.sip.wrapper):

    def __init__(self, legendModel: 'QgsLayerTreeModel|None', settings: 'QgsLegendSettings') -> None: ...

    @staticmethod
    def nodeLegendStyle(node: 'QgsLayerTreeNode|None', model: 'QgsLayerTreeModel|None') -> Qgis.LegendComponent: ...
    @staticmethod
    def setNodeLegendStyle(node: 'QgsLayerTreeNode|None', style: Qgis.LegendComponent) -> None: ...
    def exportLegendToJson(self, context: 'QgsRenderContext') -> dict[str, QtCore.QJsonValue]: ...
    @typing.overload
    @deprecated("""""")
    def drawLegend(self, painter: QtGui.QPainter|None) -> None: ...
    @typing.overload
    def drawLegend(self, context: 'QgsRenderContext') -> None: ...
    def legendSize(self) -> QtCore.QSizeF: ...
    def setLegendSize(self, s: QtCore.QSizeF) -> None: ...
    def minimumSize(self, renderContext: 'QgsRenderContext|None' = ...) -> QtCore.QSizeF: ...
    def proxyModel(self) -> 'QgsLayerTreeFilterProxyModel|None': ...
    def setProxyModel(self, model: 'QgsLayerTreeFilterProxyModel|None') -> None: ...


class QgsLegendSettings(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLegendSettings') -> None: ...

    def setAutoWrapLinesAfter(self, length: float) -> None: ...
    def autoWrapLinesAfter(self) -> float: ...
    def setJsonRenderFlags(self, jsonRenderFlags: Qgis.LegendJsonRenderFlag) -> None: ...
    def jsonRenderFlags(self) -> Qgis.LegendJsonRenderFlag: ...
    def fontDescentMillimeters(self, font: QtGui.QFont) -> float: ...
    def fontAscentMillimeters(self, font: QtGui.QFont) -> float: ...
    def fontHeightCharacterMM(self, font: QtGui.QFont, c: QtCore.QChar) -> float: ...
    def textWidthMillimeters(self, font: QtGui.QFont, text: str|None) -> float: ...
    def pixelFontSize(self, pointSize: float) -> float: ...
    def scaledFontPixelSize(self, font: QtGui.QFont) -> QtGui.QFont: ...
    @typing.overload
    def drawText(self, p: QtGui.QPainter|None, x: float, y: float, text: str|None, font: QtGui.QFont) -> None: ...
    @typing.overload
    def drawText(self, p: QtGui.QPainter|None, rect: QtCore.QRectF, text: str|None, font: QtGui.QFont, halignment: QtCore.Qt.AlignmentFlag = ..., valignment: QtCore.Qt.AlignmentFlag = ..., flags: int = ...) -> None: ...
    def splitStringForWrapping(self, stringToSplt: str|None) -> list[str]: ...
    def evaluateItemText(self, text: str|None, context: QgsExpressionContext) -> list[str]: ...
    @deprecated("""""")
    def setDpi(self, dpi: int) -> None: ...
    @deprecated("""""")
    def dpi(self) -> int: ...
    @deprecated("""""")
    def setMapUnitsPerPixel(self, mapUnitsPerPixel: float) -> None: ...
    @deprecated("""""")
    def mapUnitsPerPixel(self) -> float: ...
    @deprecated("""""")
    def setMapScale(self, scale: float) -> None: ...
    @deprecated("""""")
    def mapScale(self) -> float: ...
    @deprecated("""""")
    def setUseAdvancedEffects(self, use: bool) -> None: ...
    @deprecated("""""")
    def useAdvancedEffects(self) -> bool: ...
    @deprecated("""""")
    def setMmPerMapUnit(self, mmPerMapUnit: float) -> None: ...
    @deprecated("""""")
    def mmPerMapUnit(self) -> float: ...
    def setLineSpacing(self, s: float) -> None: ...
    @deprecated("""""")
    def lineSpacing(self) -> float: ...
    def synchronousLegendRequests(self) -> bool: ...
    def setSynchronousLegendRequests(self, b: bool) -> None: ...
    def setWmsLegendSize(self, s: QtCore.QSizeF) -> None: ...
    def wmsLegendSize(self) -> QtCore.QSizeF: ...
    def setRasterStrokeWidth(self, width: float) -> None: ...
    def rasterStrokeWidth(self) -> float: ...
    def setRasterStrokeColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def rasterStrokeColor(self) -> QtGui.QColor: ...
    def setDrawRasterStroke(self, enabled: bool) -> None: ...
    def drawRasterStroke(self) -> bool: ...
    def symbolAlignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def setSymbolAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def setMinimumSymbolSize(self, size: float) -> None: ...
    def minimumSymbolSize(self) -> float: ...
    def setMaximumSymbolSize(self, size: float) -> None: ...
    def maximumSymbolSize(self) -> float: ...
    def setSymbolSize(self, s: QtCore.QSizeF) -> None: ...
    def symbolSize(self) -> QtCore.QSizeF: ...
    @deprecated("""""")
    def setLayerFontColor(self, fontColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    @deprecated("""""")
    def layerFontColor(self) -> QtGui.QColor: ...
    @deprecated("""""")
    def setFontColor(self, c: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    @deprecated("""""")
    def fontColor(self) -> QtGui.QColor: ...
    def setEqualColumnWidth(self, s: bool) -> None: ...
    def equalColumnWidth(self) -> bool: ...
    def setSplitLayer(self, s: bool) -> None: ...
    def splitLayer(self) -> bool: ...
    def setColumnCount(self, c: int) -> None: ...
    def columnCount(self) -> int: ...
    def setColumnSpace(self, s: float) -> None: ...
    def columnSpace(self) -> float: ...
    def wrapChar(self) -> str: ...
    def setWrapChar(self, t: str|None) -> None: ...
    def setBoxSpace(self, s: float) -> None: ...
    def boxSpace(self) -> float: ...
    def setStyle(self, s: Qgis.LegendComponent, style: 'QgsLegendStyle') -> None: ...
    def style(self, s: Qgis.LegendComponent) -> 'QgsLegendStyle': ...
    def setTitleAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def titleAlignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def title(self) -> str: ...
    def setTitle(self, t: str|None) -> None: ...
    def updateDataDefinedProperties(self, context: 'QgsRenderContext') -> None: ...


class QgsLegendStyle(PyQt6.sip.wrapper):

    class Side(enum.IntEnum):
        Top = ... # type: QgsLegendStyle.Side
        Bottom = ... # type: QgsLegendStyle.Side
        Left = ... # type: QgsLegendStyle.Side
        Right = ... # type: QgsLegendStyle.Side

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLegendStyle') -> None: ...

    @staticmethod
    def styleLabel(s: Qgis.LegendComponent) -> str: ...
    @staticmethod
    def styleFromName(styleName: str|None) -> Qgis.LegendComponent: ...
    @staticmethod
    def styleName(s: Qgis.LegendComponent) -> str: ...
    def updateDataDefinedProperties(self, context: 'QgsRenderContext') -> None: ...
    def readXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext' = ...) -> None: ...
    def writeXml(self, name: str|None, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext' = ...) -> None: ...
    def setIndent(self, indent: float) -> None: ...
    def indent(self) -> float: ...
    def setAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def alignment(self) -> QtCore.Qt.AlignmentFlag: ...
    @typing.overload
    def setMargin(self, side: 'QgsLegendStyle.Side', margin: float) -> None: ...
    @typing.overload
    def setMargin(self, margin: float) -> None: ...
    def margin(self, side: 'QgsLegendStyle.Side') -> float: ...
    def setTextFormat(self, format: 'QgsTextFormat') -> None: ...
    def textFormat(self) -> 'QgsTextFormat': ...
    @deprecated("""""")
    def setFont(self, font: QtGui.QFont) -> None: ...
    @deprecated("""""")
    def font(self) -> QtGui.QFont: ...


class QgsLocalDefaultSettings(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLocalDefaultSettings') -> None: ...

    @staticmethod
    def geographicCoordinateFormat() -> 'QgsGeographicCoordinateNumericFormat|None': ...
    @staticmethod
    def setGeographicCoordinateFormat(format: 'QgsGeographicCoordinateNumericFormat|None') -> None: ...
    @staticmethod
    def bearingFormat() -> 'QgsBearingNumericFormat|None': ...
    @staticmethod
    def setBearingFormat(format: 'QgsBearingNumericFormat|None') -> None: ...


class QgsLocalizedDataPathRegistry(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def unregisterPath(self, path: str|None) -> None: ...
    def registerPath(self, path: str|None, position: int = ...) -> None: ...
    def paths(self) -> list[str]: ...
    def localizedPath(self, globalPath: str|None) -> str: ...
    def globalPath(self, localizedPath: str|None) -> str: ...


class QgsLogger(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLogger') -> None: ...

    @staticmethod
    def logFile() -> str: ...
    @staticmethod
    def logMessageToFile(message: str|None) -> None: ...
    @staticmethod
    def debugLevel() -> int: ...
    @staticmethod
    def fatal(msg: str|None) -> None: ...
    @staticmethod
    def critical(msg: str|None) -> None: ...
    @staticmethod
    def warning(msg: str|None) -> None: ...
    @typing.overload
    @staticmethod
    def debug(msg: str|None, debuglevel: int = ..., file: str = ..., function: str = ..., line: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def debug(var: str|None, val: int, debuglevel: int = ..., file: str = ..., function: str = ..., line: int = ...) -> None: ...


class QgsScopeLogger(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, file: str, func: str, line: int) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsScopeLogger') -> None: ...


class QgsMagneticModel(PyQt6.sip.wrapper):

    def __init__(self, name: str|None, path: str|None = ..., maxDegree: int = ..., maxOrder: int = ...) -> None: ...

    @staticmethod
    def fieldComponentsWithTimeDerivatives(Bx: float, By: float, Bz: float, Bxt: float, Byt: float, Bzt: float) -> typing.Tuple[bool, float, float, float, float, float, float, float, float]: ...
    @staticmethod
    def fieldComponents(Bx: float, By: float, Bz: float) -> typing.Tuple[bool, float, float, float, float]: ...
    def getComponentsWithTimeDerivatives(self, years: float, latitude: float, longitude: float, height: float) -> typing.Tuple[bool, float, float, float, float, float, float]: ...
    def getComponents(self, years: float, latitude: float, longitude: float, height: float) -> typing.Tuple[bool, float, float, float]: ...
    def inclination(self, years: float, latitude: float, longitude: float, height: float) -> typing.Tuple[bool, float]: ...
    def declination(self, years: float, latitude: float, longitude: float, height: float) -> typing.Tuple[bool, float]: ...
    def order(self) -> int: ...
    def degree(self) -> int: ...
    def maximumYear(self) -> float: ...
    def minimumYear(self) -> float: ...
    def maximumHeight(self) -> float: ...
    def minimumHeight(self) -> float: ...
    def error(self) -> str: ...
    def name(self) -> str: ...
    def directory(self) -> str: ...
    def file(self) -> str: ...
    def dateTime(self) -> QtCore.QDateTime: ...
    def description(self) -> str: ...
    def isValid(self) -> bool: ...
    @staticmethod
    def defaultModelName() -> str: ...
    @staticmethod
    def defaultFilePath() -> str: ...


class QgsMapClippingRegion(PyQt6.sip.wrapper):

    class FeatureClippingType(enum.IntEnum):
        ClipToIntersection = ... # type: QgsMapClippingRegion.FeatureClippingType
        ClipPainterOnly = ... # type: QgsMapClippingRegion.FeatureClippingType
        NoClipping = ... # type: QgsMapClippingRegion.FeatureClippingType

    @typing.overload
    def __init__(self, geometry: 'QgsGeometry') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapClippingRegion') -> None: ...

    def appliesToLayer(self, layer: QgsMapLayer|None) -> bool: ...
    def restrictedLayers(self) -> list[QgsMapLayer]: ...
    def setRestrictedLayers(self, layers: collections.abc.Iterable[QgsMapLayer]) -> None: ...
    def setRestrictToLayers(self, enabled: bool) -> None: ...
    def restrictToLayers(self) -> bool: ...
    def setFeatureClip(self, type: 'QgsMapClippingRegion.FeatureClippingType') -> None: ...
    def featureClip(self) -> 'QgsMapClippingRegion.FeatureClippingType': ...
    def setGeometry(self, geometry: 'QgsGeometry') -> None: ...
    def geometry(self) -> 'QgsGeometry': ...


class QgsMapClippingUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapClippingUtils') -> None: ...

    @staticmethod
    def calculateLabelIntersectionGeometry(regions: collections.abc.Iterable[QgsMapClippingRegion], context: 'QgsRenderContext') -> typing.Tuple['QgsGeometry', bool]: ...
    @staticmethod
    def calculatePainterClipRegion(regions: collections.abc.Iterable[QgsMapClippingRegion], context: 'QgsRenderContext', layerType: Qgis.LayerType) -> typing.Tuple[QtGui.QPainterPath, bool]: ...
    @staticmethod
    def calculateFeatureIntersectionGeometry(regions: collections.abc.Iterable[QgsMapClippingRegion], context: 'QgsRenderContext') -> typing.Tuple['QgsGeometry', bool]: ...
    @staticmethod
    def calculateFeatureRequestGeometry(regions: collections.abc.Iterable[QgsMapClippingRegion], context: 'QgsRenderContext') -> typing.Tuple['QgsGeometry', bool]: ...
    @staticmethod
    def collectClippingRegionsForLayer(context: 'QgsRenderContext', layer: QgsMapLayer|None) -> list[QgsMapClippingRegion]: ...


class QgsMapDecoration(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapDecoration') -> None: ...

    def setDisplayName(self, name: str|None) -> None: ...
    def hasFixedMapPosition(self) -> bool: ...
    def displayName(self) -> str: ...
    def render(self, mapSettings: 'QgsMapSettings', context: 'QgsRenderContext') -> None: ...


class QgsMapHitTest(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, settings: 'QgsMapSettings', polygon: 'QgsGeometry' = ..., layerFilterExpression: dict[str|None, str|None] = ...) -> None: ...
    @typing.overload
    def __init__(self, settings: 'QgsMapSettings', layerFilterExpression: dict[str|None, str|None]) -> None: ...
    @typing.overload
    def __init__(self, settings: 'QgsLayerTreeFilterSettings') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapHitTest') -> None: ...

    def legendKeyVisible(self, ruleKey: str|None, layer: QgsVectorLayer|None) -> bool: ...
    def symbolVisible(self, symbol: 'QgsSymbol|None', layer: QgsVectorLayer|None) -> bool: ...
    def resultsRenderersUpdatedCanvas(self) -> dict[str, tuple[float, float]]: ...
    def results(self) -> typing.Any: ...
    def run(self) -> None: ...


class QgsMapHitTestTask(QgsTask):

    def __init__(self, settings: 'QgsLayerTreeFilterSettings') -> None: ...

    def run(self) -> bool: ...
    def resultsRenderersUpdatedCanvas(self) -> dict[str, tuple[float, float]]: ...
    def cancel(self) -> None: ...
    def results(self) -> typing.Any: ...


class QgsMapLayerDependency(PyQt6.sip.wrapper):

    class Origin(enum.IntEnum):
        FromProvider = ... # type: QgsMapLayerDependency.Origin
        FromUser = ... # type: QgsMapLayerDependency.Origin

    class Type(enum.IntEnum):
        PresenceDependency = ... # type: QgsMapLayerDependency.Type
        DataDependency = ... # type: QgsMapLayerDependency.Type

    @typing.overload
    def __init__(self, layerId: str|None, type: 'QgsMapLayerDependency.Type' = ..., origin: 'QgsMapLayerDependency.Origin' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapLayerDependency') -> None: ...

    def __ne__(self, other: object): ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: object): ...
    def layerId(self) -> str: ...
    def origin(self) -> 'QgsMapLayerDependency.Origin': ...
    def type(self) -> 'QgsMapLayerDependency.Type': ...


class QgsMapLayerFactory(PyQt6.sip.wrapper):

    class LayerOptions(PyQt6.sip.wrapper):

        loadAllStoredStyles = ... # type: bool
        loadDefaultStyle = ... # type: bool
        transformContext = ... # type: 'QgsCoordinateTransformContext'

        @typing.overload
        def __init__(self, transformContext: 'QgsCoordinateTransformContext') -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsMapLayerFactory.LayerOptions') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapLayerFactory') -> None: ...

    @staticmethod
    def createLayer(uri: str|None, name: str|None, type: Qgis.LayerType, options: 'QgsMapLayerFactory.LayerOptions', provider: str|None = ...) -> QgsMapLayer|None: ...
    @staticmethod
    def typeToString(type: Qgis.LayerType) -> str: ...
    @staticmethod
    def typeFromString(string: str|None) -> typing.Tuple[Qgis.LayerType, bool]: ...


class QgsMapLayerLegend(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    itemsChanged: typing.ClassVar[QtCore.pyqtSignal]
    @staticmethod
    def defaultPointCloudLegend(layer: 'QgsPointCloudLayer|None') -> 'QgsMapLayerLegend|None': ...
    @staticmethod
    def defaultMeshLegend(ml: 'QgsMeshLayer|None') -> 'QgsMapLayerLegend|None': ...
    @staticmethod
    def defaultRasterLegend(rl: 'QgsRasterLayer|None') -> 'QgsMapLayerLegend|None': ...
    @staticmethod
    def defaultVectorLegend(vl: QgsVectorLayer|None) -> 'QgsMapLayerLegend|None': ...
    def createLayerTreeModelLegendNodes(self, nodeLayer: 'QgsLayerTreeLayer|None') -> list['QgsLayerTreeModelLegendNode']: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> QtXml.QDomElement: ...
    def readXml(self, elem: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    def setFlags(self, flags: Qgis.MapLayerLegendFlag) -> None: ...
    def setFlag(self, flag: Qgis.MapLayerLegendFlag, on: bool = ...) -> None: ...
    def flags(self) -> Qgis.MapLayerLegendFlag: ...


class QgsMapLayerLegendUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapLayerLegendUtils') -> None: ...

    @staticmethod
    def applyLayerNodeProperties(nodeLayer: 'QgsLayerTreeLayer|None', nodes: collections.abc.Iterable['QgsLayerTreeModelLegendNode']) -> None: ...
    @staticmethod
    def legendNodeColumnBreak(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int) -> bool: ...
    @staticmethod
    def setLegendNodeColumnBreak(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int, columnBreakBeforeNode: bool) -> None: ...
    @staticmethod
    def legendNodeColorRampSettings(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int) -> 'QgsColorRampLegendNodeSettings|None': ...
    @staticmethod
    def setLegendNodeColorRampSettings(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int, settings: 'QgsColorRampLegendNodeSettings|None') -> None: ...
    @staticmethod
    def legendNodeCustomSymbol(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int) -> 'QgsSymbol'|None: ...
    @staticmethod
    def setLegendNodeCustomSymbol(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int, symbol: 'QgsSymbol|None') -> None: ...
    @staticmethod
    def legendNodeSymbolSize(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int) -> QtCore.QSizeF: ...
    @staticmethod
    def setLegendNodeSymbolSize(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int, size: QtCore.QSizeF) -> None: ...
    @staticmethod
    def legendNodePatchShape(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int) -> 'QgsLegendPatchShape': ...
    @staticmethod
    def setLegendNodePatchShape(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int, shape: 'QgsLegendPatchShape') -> None: ...
    @staticmethod
    def hasLegendNodeUserLabel(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int) -> bool: ...
    @staticmethod
    def legendNodeUserLabel(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int) -> str: ...
    @staticmethod
    def setLegendNodeUserLabel(nodeLayer: 'QgsLayerTreeLayer|None', originalIndex: int, newLabel: str|None) -> None: ...
    @staticmethod
    def hasLegendNodeOrder(nodeLayer: 'QgsLayerTreeLayer|None') -> bool: ...
    @staticmethod
    def legendNodeOrder(nodeLayer: 'QgsLayerTreeLayer|None') -> list[int]: ...
    @staticmethod
    def setLegendNodeOrder(nodeLayer: 'QgsLayerTreeLayer|None', order: collections.abc.Iterable[int]) -> None: ...


class QgsDefaultVectorLayerLegend(QgsMapLayerLegend):

    def __init__(self, vl: QgsVectorLayer|None) -> None: ...

    def writeXml(self, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> QtXml.QDomElement: ...
    def readXml(self, elem: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    def createLayerTreeModelLegendNodes(self, nodeLayer: 'QgsLayerTreeLayer|None') -> list['QgsLayerTreeModelLegendNode']: ...
    def setTextOnSymbolContent(self, content: dict[str|None, str|None]) -> None: ...
    def textOnSymbolContent(self) -> dict[str, str]: ...
    def setTextOnSymbolTextFormat(self, format: 'QgsTextFormat') -> None: ...
    def textOnSymbolTextFormat(self) -> 'QgsTextFormat': ...
    def setShowLabelLegend(self, enabled: bool) -> None: ...
    def showLabelLegend(self) -> bool: ...
    def setTextOnSymbolEnabled(self, enabled: bool) -> None: ...
    def textOnSymbolEnabled(self) -> bool: ...


class QgsDefaultRasterLayerLegend(QgsMapLayerLegend):

    def __init__(self, rl: 'QgsRasterLayer|None') -> None: ...

    def createLayerTreeModelLegendNodes(self, nodeLayer: 'QgsLayerTreeLayer|None') -> list['QgsLayerTreeModelLegendNode']: ...


class QgsDefaultMeshLayerLegend(QgsMapLayerLegend):

    def __init__(self, ml: 'QgsMeshLayer|None') -> None: ...

    def createLayerTreeModelLegendNodes(self, nodeLayer: 'QgsLayerTreeLayer|None') -> list['QgsLayerTreeModelLegendNode']: ...


class QgsDefaultPointCloudLayerLegend(QgsMapLayerLegend):

    def __init__(self, layer: 'QgsPointCloudLayer|None') -> None: ...

    def createLayerTreeModelLegendNodes(self, nodeLayer: 'QgsLayerTreeLayer|None') -> list['QgsLayerTreeModelLegendNode']: ...


class QgsMapLayerModel(QtCore.QAbstractItemModel):

    class CustomRole(enum.IntEnum):
        LayerId = ... # type: QgsMapLayerModel.CustomRole
        Layer = ... # type: QgsMapLayerModel.CustomRole
        Empty = ... # type: QgsMapLayerModel.CustomRole
        Additional = ... # type: QgsMapLayerModel.CustomRole

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ..., project: 'QgsProject|None' = ...) -> None: ...
    @typing.overload
    def __init__(self, layers: collections.abc.Iterable[QgsMapLayer], parent: QtCore.QObject|None = ..., project: 'QgsProject|None' = ...) -> None: ...

    def addLayers(self, layers: collections.abc.Iterable[QgsMapLayer]) -> None: ...
    def removeLayers(self, layerIds: collections.abc.Iterable[str|None]) -> None: ...
    @staticmethod
    def iconForLayer(layer: QgsMapLayer|None) -> QtGui.QIcon: ...
    def supportedDropActions(self) -> QtCore.Qt.DropAction: ...
    def dropMimeData(self, data: QtCore.QMimeData|None, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: collections.abc.Iterable[QtCore.QModelIndex]) -> QtCore.QMimeData|None: ...
    def canDropMimeData(self, data: QtCore.QMimeData|None, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeTypes(self) -> list[str]: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlag: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def additionalLayers(self) -> list[QgsMapLayer]: ...
    def setAdditionalLayers(self, layers: collections.abc.Iterable[QgsMapLayer]) -> None: ...
    def additionalItems(self) -> list[str]: ...
    def setAdditionalItems(self, items: collections.abc.Iterable[str|None]) -> None: ...
    def layerFromIndex(self, index: QtCore.QModelIndex) -> QgsMapLayer|None: ...
    def indexFromLayer(self, layer: QgsMapLayer|None) -> QtCore.QModelIndex: ...
    def itemsCheckable(self) -> bool: ...
    def setLayersChecked(self, layers: collections.abc.Iterable[QgsMapLayer]) -> None: ...
    def layersChecked(self, checkState: QtCore.Qt.CheckState = ...) -> list[QgsMapLayer]: ...
    def showCrs(self) -> bool: ...
    def setShowCrs(self, showCrs: bool) -> None: ...
    def allowEmptyLayer(self) -> bool: ...
    def setAllowEmptyLayer(self, allowEmpty: bool, text: str|None = ..., icon: QtGui.QIcon = ...) -> None: ...
    def checkAll(self, checkState: QtCore.Qt.CheckState) -> None: ...
    def itemsCanBeReordered(self) -> bool: ...
    def setItemsCanBeReordered(self, allow: bool) -> None: ...
    def setProject(self, project: 'QgsProject|None') -> None: ...
    def setItemsCheckable(self, checkable: bool) -> None: ...


class QgsMapLayerProxyModel(QtCore.QSortFilterProxyModel):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def setFilterString(self, filter: str|None) -> None: ...
    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...
    def filterAcceptsRow(self, source_row: int, source_parent: QtCore.QModelIndex) -> bool: ...
    def acceptsLayer(self, layer: QgsMapLayer|None) -> bool: ...
    def filterString(self) -> str: ...
    def excludedProviders(self) -> list[str]: ...
    def setExcludedProviders(self, providers: collections.abc.Iterable[str|None]) -> None: ...
    def exceptedLayerIds(self) -> list[str]: ...
    def setExceptedLayerIds(self, ids: collections.abc.Iterable[str|None]) -> None: ...
    def exceptedLayerList(self) -> list[QgsMapLayer]: ...
    def setExceptedLayerList(self, exceptList: collections.abc.Iterable[QgsMapLayer]) -> None: ...
    def layerAllowlist(self) -> list[QgsMapLayer]: ...
    @deprecated("""""")
    def layerWhitelist(self) -> list[QgsMapLayer]: ...
    def setLayerAllowlist(self, layers: collections.abc.Iterable[QgsMapLayer]) -> None: ...
    @deprecated("""""")
    def setLayerWhitelist(self, layers: collections.abc.Iterable[QgsMapLayer]) -> None: ...
    @staticmethod
    def layerMatchesFilters(layer: QgsMapLayer|None, filters: Qgis.LayerFilter) -> bool: ...
    def setProject(self, project: 'QgsProject|None') -> None: ...
    def filters(self) -> Qgis.LayerFilter: ...
    @typing.overload
    def setFilters(self, filters: Qgis.LayerFilter) -> 'QgsMapLayerProxyModel|None': ...
    @typing.overload
    @deprecated("""""")
    def setFilters(self, filters: int) -> None: ...
    def sourceLayerModel(self) -> QgsMapLayerModel|None: ...


class QgsMapLayerRenderer(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, layerID: str|None, context: 'QgsRenderContext|None' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapLayerRenderer') -> None: ...

    def appendRenderedItemDetails(self, details: 'QgsRenderedItemDetails|None') -> None: ...
    def takeRenderedItemDetails(self) -> list['QgsRenderedItemDetails']: ...
    def isReadyToCompose(self) -> bool: ...
    def renderContext(self) -> 'QgsRenderContext|None': ...
    def layerId(self) -> str: ...
    def errors(self) -> list[str]: ...
    def feedback(self) -> QgsFeedback|None: ...
    def flags(self) -> Qgis.MapLayerRendererFlag: ...
    def forceRasterRender(self) -> bool: ...
    def render(self) -> bool: ...


class QgsServerMetadataUrlProperties(PyQt6.sip.wrapper):

    class MetadataUrl(PyQt6.sip.wrapper):

        format = ... # type: str|None
        type = ... # type: str|None
        url = ... # type: str|None

        @typing.overload
        def __init__(self, url: str|None = ..., type: str|None = ..., format: str|None = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsServerMetadataUrlProperties.MetadataUrl') -> None: ...

        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerMetadataUrlProperties') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def layer(self) -> QgsMapLayer|None: ...
    def addMetadataUrl(self, metaUrl: 'QgsServerMetadataUrlProperties.MetadataUrl') -> None: ...
    def setMetadataUrls(self, metaUrls: collections.abc.Iterable['QgsServerMetadataUrlProperties.MetadataUrl']) -> None: ...
    def metadataUrls(self) -> list['QgsServerMetadataUrlProperties.MetadataUrl']: ...


class QgsServerWmsDimensionProperties(PyQt6.sip.wrapper):

    class PredefinedWmsDimensionName(enum.IntEnum):
        TIME = ... # type: QgsServerWmsDimensionProperties.PredefinedWmsDimensionName
        DATE = ... # type: QgsServerWmsDimensionProperties.PredefinedWmsDimensionName
        ELEVATION = ... # type: QgsServerWmsDimensionProperties.PredefinedWmsDimensionName

    class WmsDimensionInfo(PyQt6.sip.wrapper):

        class DefaultDisplay(enum.IntEnum):
            AllValues = ... # type: QgsServerWmsDimensionProperties.WmsDimensionInfo.DefaultDisplay
            MinValue = ... # type: QgsServerWmsDimensionProperties.WmsDimensionInfo.DefaultDisplay
            MaxValue = ... # type: QgsServerWmsDimensionProperties.WmsDimensionInfo.DefaultDisplay
            ReferenceValue = ... # type: QgsServerWmsDimensionProperties.WmsDimensionInfo.DefaultDisplay

        defaultDisplayType = ... # type: int
        endFieldName = ... # type: str|None
        fieldName = ... # type: str|None
        name = ... # type: str|None
        referenceValue = ... # type: typing.Any
        unitSymbol = ... # type: str|None
        units = ... # type: str|None

        @typing.overload
        def __init__(self, dimName: str|None, dimFieldName: str|None, dimEndFieldName: str|None = ..., dimUnits: str|None = ..., dimUnitSymbol: str|None = ..., dimDefaultDisplayType: int = ..., dimReferenceValue: typing.Any = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsServerWmsDimensionProperties.WmsDimensionInfo') -> None: ...

        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerWmsDimensionProperties') -> None: ...

    def layer(self) -> QgsMapLayer|None: ...
    def wmsDimensions(self) -> list['QgsServerWmsDimensionProperties.WmsDimensionInfo']: ...
    def setWmsDimensions(self, dimensions: collections.abc.Iterable['QgsServerWmsDimensionProperties.WmsDimensionInfo']) -> None: ...
    def removeWmsDimension(self, wmsDimName: str|None) -> bool: ...
    def addWmsDimension(self, wmsDimInfo: 'QgsServerWmsDimensionProperties.WmsDimensionInfo') -> bool: ...
    @staticmethod
    def wmsDimensionDefaultDisplayLabels() -> dict[int, str]: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsMapLayerServerProperties(QgsServerMetadataUrlProperties, QgsServerWmsDimensionProperties):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, layer: QgsMapLayer|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapLayerServerProperties') -> None: ...

    def layer(self) -> QgsMapLayer|None: ...
    def legendUrlFormat(self) -> str: ...
    def setLegendUrlFormat(self, legendUrlFormat: str|None) -> None: ...
    def legendUrl(self) -> str: ...
    def setLegendUrl(self, legendUrl: str|None) -> None: ...
    def attributionUrl(self) -> str: ...
    def setAttributionUrl(self, url: str|None) -> None: ...
    def attribution(self) -> str: ...
    def setAttribution(self, attrib: str|None) -> None: ...
    def dataUrlFormat(self) -> str: ...
    def setDataUrlFormat(self, dataUrlFormat: str|None) -> None: ...
    def dataUrl(self) -> str: ...
    def setDataUrl(self, dataUrl: str|None) -> None: ...
    def keywordList(self) -> str: ...
    def setKeywordList(self, keywords: str|None) -> None: ...
    def abstract(self) -> str: ...
    def setAbstract(self, abstract: str|None) -> None: ...
    def wfsTitle(self) -> str: ...
    def title(self) -> str: ...
    def setWfsTitle(self, title: str|None) -> None: ...
    def setTitle(self, title: str|None) -> None: ...
    def wfsTypeName(self) -> str: ...
    def shortName(self) -> str: ...
    def setShortName(self, name: str|None) -> None: ...
    def reset(self) -> None: ...
    def readXml(self, layer_node: QtXml.QDomNode) -> None: ...
    def writeXml(self, layer_node: QtXml.QDomNode, document: QtXml.QDomDocument) -> None: ...
    def copyTo(self, properties: 'QgsMapLayerServerProperties|None') -> None: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsVectorLayerServerProperties(QgsMapLayerServerProperties):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVectorLayerServerProperties') -> None: ...


class QgsMapLayerStore(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    layerWasAdded: typing.ClassVar[QtCore.pyqtSignal]
    layersAdded: typing.ClassVar[QtCore.pyqtSignal]
    allLayersRemoved: typing.ClassVar[QtCore.pyqtSignal]
    layerRemoved: typing.ClassVar[QtCore.pyqtSignal]
    layersRemoved: typing.ClassVar[QtCore.pyqtSignal]
    layerWillBeRemoved: typing.ClassVar[QtCore.pyqtSignal]
    layersWillBeRemoved: typing.ClassVar[QtCore.pyqtSignal]
    def transferLayersFromStore(self, other: 'QgsMapLayerStore|None') -> None: ...
    def removeAllMapLayers(self) -> None: ...
    def takeMapLayer(self, layer: QgsMapLayer|None) -> QgsMapLayer|None: ...
    @typing.overload
    def removeMapLayer(self, id: str|None) -> None: ...
    @typing.overload
    def removeMapLayer(self, layer: QgsMapLayer|None) -> None: ...
    def removeMapLayers(self, layers: collections.abc.Iterable[QgsMapLayer]) -> None: ...
    def removeMapLayersById(self, layerIds: collections.abc.Iterable[str|None]) -> None: ...
    def addMapLayer(self, layer: QgsMapLayer|None) -> QgsMapLayer|None: ...
    def addMapLayers(self, layers: collections.abc.Iterable[QgsMapLayer]) -> list[QgsMapLayer]: ...
    def validMapLayers(self) -> typing.Any: ...
    def mapLayers(self) -> typing.Any: ...
    def mapLayersByName(self, name: str|None) -> list[QgsMapLayer]: ...
    def mapLayer(self, id: str|None) -> QgsMapLayer|None: ...
    def __bool__(self) -> int: ...
    def __len__(self) -> int: ...
    def validCount(self) -> int: ...
    def count(self) -> int: ...


class QgsMapLayerStyle(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, xmlData: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapLayerStyle') -> None: ...

    def writeXml(self, styleElement: QtXml.QDomElement) -> None: ...
    def readXml(self, styleElement: QtXml.QDomElement) -> None: ...
    def writeToLayer(self, layer: QgsMapLayer|None) -> None: ...
    def readFromLayer(self, layer: QgsMapLayer|None) -> None: ...
    def xmlData(self) -> str: ...
    def clear(self) -> None: ...
    def isValid(self) -> bool: ...


class QgsMapLayerStyleOverride(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, layer: QgsMapLayer|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapLayerStyleOverride') -> None: ...

    def setOverrideStyle(self, style: str|None) -> None: ...


class QgsMapLayerStyleManager(QtCore.QObject):

    def __init__(self, layer: QgsMapLayer|None) -> None: ...

    currentStyleChanged: typing.ClassVar[QtCore.pyqtSignal]
    styleRenamed: typing.ClassVar[QtCore.pyqtSignal]
    styleRemoved: typing.ClassVar[QtCore.pyqtSignal]
    styleAdded: typing.ClassVar[QtCore.pyqtSignal]
    def copyStylesFrom(self, other: 'QgsMapLayerStyleManager|None') -> None: ...
    @staticmethod
    def isDefault(styleName: str|None) -> bool: ...
    def restoreOverrideStyle(self) -> bool: ...
    def setOverrideStyle(self, styleDef: str|None) -> bool: ...
    def setCurrentStyle(self, name: str|None) -> bool: ...
    def currentStyle(self) -> str: ...
    def renameStyle(self, name: str|None, newName: str|None) -> bool: ...
    def removeStyle(self, name: str|None) -> bool: ...
    def addStyleFromLayer(self, name: str|None) -> bool: ...
    def addStyle(self, name: str|None, style: QgsMapLayerStyle) -> bool: ...
    def style(self, name: str|None) -> QgsMapLayerStyle: ...
    def mapLayerStyles(self) -> dict[str, QgsMapLayerStyle]: ...
    def styles(self) -> list[str]: ...
    def writeXml(self, mgrElement: QtXml.QDomElement) -> None: ...
    def readXml(self, mgrElement: QtXml.QDomElement) -> None: ...
    def reset(self) -> None: ...
    def layer(self) -> QgsMapLayer|None: ...


class QgsMapLayerElevationProperties(QtCore.QObject):

    class Flag(enum.IntEnum):
        FlagDontInvalidateCachedRendersWhenRangeChanges = ... # type: QgsMapLayerElevationProperties.Flag

    class Property(enum.IntEnum):
        ZOffset = ... # type: QgsMapLayerElevationProperties.Property
        ExtrusionHeight = ... # type: QgsMapLayerElevationProperties.Property
        RasterPerBandLowerElevation = ... # type: QgsMapLayerElevationProperties.Property
        RasterPerBandUpperElevation = ... # type: QgsMapLayerElevationProperties.Property

    def __init__(self, parent: QtCore.QObject|None) -> None: ...

    def copyCommonProperties(self, other: 'QgsMapLayerElevationProperties|None') -> None: ...
    def readCommonProperties(self, element: QtXml.QDomElement, context: 'QgsReadWriteContext') -> None: ...
    def writeCommonProperties(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> None: ...
    profileGenerationPropertyChanged: typing.ClassVar[QtCore.pyqtSignal]
    profileRenderingPropertyChanged: typing.ClassVar[QtCore.pyqtSignal]
    zScaleChanged: typing.ClassVar[QtCore.pyqtSignal]
    zOffsetChanged: typing.ClassVar[QtCore.pyqtSignal]
    changed: typing.ClassVar[QtCore.pyqtSignal]
    @staticmethod
    def propertyDefinitions() -> dict[int, 'QgsPropertyDefinition']: ...
    def setDataDefinedProperties(self, collection: 'QgsPropertyCollection') -> None: ...
    def dataDefinedProperties(self) -> 'QgsPropertyCollection': ...
    def setZScale(self, scale: float) -> None: ...
    def zScale(self) -> float: ...
    def setZOffset(self, offset: float) -> None: ...
    def zOffset(self) -> float: ...
    def showByDefaultInElevationProfilePlots(self) -> bool: ...
    def significantZValues(self, layer: QgsMapLayer|None) -> list[float]: ...
    def calculateZRange(self, layer: QgsMapLayer|None) -> 'QgsDoubleRange': ...
    def flags(self) -> 'QgsMapLayerElevationProperties.Flag': ...
    def isVisibleInZRange(self, range: 'QgsDoubleRange', layer: QgsMapLayer|None = ...) -> bool: ...
    def clone(self) -> 'QgsMapLayerElevationProperties|None': ...
    def htmlSummary(self) -> str: ...
    def setDefaultsFromLayer(self, layer: QgsMapLayer|None) -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: 'QgsReadWriteContext') -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> QtXml.QDomElement: ...
    def hasElevation(self) -> bool: ...


class QgsMapLayerSelectionProperties(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None) -> None: ...

    def clone(self) -> 'QgsMapLayerSelectionProperties|None': ...
    def readXml(self, element: QtXml.QDomElement, context: 'QgsReadWriteContext') -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> QtXml.QDomElement: ...


class QgsTemporalProperty(QtCore.QObject):

    class Flag(enum.IntEnum):
        FlagDontInvalidateCachedRendersWhenRangeChanges = ... # type: QgsTemporalProperty.Flag

    def __init__(self, parent: QtCore.QObject|None = ..., enabled: bool = ...) -> None: ...

    changed: typing.ClassVar[QtCore.pyqtSignal]
    def flags(self) -> 'QgsTemporalProperty.Flag': ...
    def isActive(self) -> bool: ...
    def setIsActive(self, active: bool) -> None: ...


class QgsMapLayerTemporalProperties(QgsTemporalProperty):

    def __init__(self, parent: QtCore.QObject|None, enabled: bool = ...) -> None: ...

    def allTemporalRanges(self, layer: QgsMapLayer|None) -> list['QgsDateTimeRange']: ...
    def setDefaultsFromDataProviderTemporalCapabilities(self, capabilities: QgsDataProviderTemporalCapabilities|None) -> None: ...
    def isVisibleInTemporalRange(self, range: 'QgsDateTimeRange') -> bool: ...
    def readXml(self, element: QtXml.QDomElement, context: 'QgsReadWriteContext') -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: 'QgsReadWriteContext') -> QtXml.QDomElement: ...


class QgsMapLayerUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapLayerUtils') -> None: ...

    @staticmethod
    def layerTypeToString(type: Qgis.LayerType) -> str: ...
    @staticmethod
    def isOpenStreetMapLayer(layer: QgsMapLayer|None) -> bool: ...
    @staticmethod
    def launderLayerName(name: str|None) -> str: ...
    @staticmethod
    def sortLayersByType(layers: collections.abc.Iterable[QgsMapLayer], order: collections.abc.Iterable[Qgis.LayerType]) -> list[QgsMapLayer]: ...
    @staticmethod
    def updateLayerSourcePath(layer: QgsMapLayer|None, newPath: str|None) -> bool: ...
    @staticmethod
    def layerRefersToUri(layer: QgsMapLayer|None, uri: str|None, level: Qgis.SourceHierarchyLevel = ...) -> bool: ...
    @staticmethod
    def layerSourceMatchesPath(layer: QgsMapLayer|None, path: str|None) -> bool: ...
    @staticmethod
    def databaseConnection(layer: QgsMapLayer|None) -> 'QgsAbstractDatabaseProviderConnection|None': ...
    @staticmethod
    def combinedExtent(layers: collections.abc.Iterable[QgsMapLayer], crs: 'QgsCoordinateReferenceSystem', transformContext: 'QgsCoordinateTransformContext') -> 'QgsRectangle': ...


class QgsLabelBlockingRegion(PyQt6.sip.wrapper):

    geometry = ... # type: 'QgsGeometry'

    @typing.overload
    def __init__(self, geometry: 'QgsGeometry') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLabelBlockingRegion') -> None: ...


class QgsTemporalRangeObject(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, enabled: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTemporalRangeObject') -> None: ...

    def temporalRange(self) -> 'QgsDateTimeRange': ...
    def setTemporalRange(self, range: 'QgsDateTimeRange') -> None: ...
    def isTemporal(self) -> bool: ...
    def setIsTemporal(self, enabled: bool) -> None: ...


class QgsMapSettings(QgsTemporalRangeObject):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapSettings') -> None: ...

    def updateDerived(self) -> None: ...
    def setSelectiveMaskingSourceSets(self, sets: collections.abc.Iterable['QgsSelectiveMaskingSourceSet']) -> None: ...
    def selectiveMaskingSourceSets(self) -> dict[str, 'QgsSelectiveMaskingSourceSet']: ...
    def setRasterizedRenderingPolicy(self, policy: Qgis.RasterizedRenderingPolicy) -> None: ...
    def rasterizedRenderingPolicy(self) -> Qgis.RasterizedRenderingPolicy: ...
    def setElevationShadingRenderer(self, renderer: QgsElevationShadingRenderer) -> None: ...
    def elevationShadingRenderer(self) -> QgsElevationShadingRenderer: ...
    def setCurrentFrame(self, frame: int) -> None: ...
    def currentFrame(self) -> int: ...
    def setFrameRate(self, rate: float) -> None: ...
    def frameRate(self) -> float: ...
    def setRendererUsage(self, rendererUsage: Qgis.RendererUsage) -> None: ...
    def rendererUsage(self) -> Qgis.RendererUsage: ...
    def setZRange(self, range: 'QgsDoubleRange') -> None: ...
    def zRange(self) -> 'QgsDoubleRange': ...
    def renderedFeatureHandlers(self) -> list['QgsRenderedFeatureHandlerInterface']: ...
    def addRenderedFeatureHandler(self, handler: 'QgsRenderedFeatureHandlerInterface|None') -> None: ...
    def setMaskSettings(self, settings: 'QgsMaskRenderSettings') -> None: ...
    def maskSettings(self) -> 'QgsMaskRenderSettings': ...
    def simplifyMethod(self) -> 'QgsVectorSimplifyMethod': ...
    def setSimplifyMethod(self, method: 'QgsVectorSimplifyMethod') -> None: ...
    def clippingRegions(self) -> list[QgsMapClippingRegion]: ...
    def setClippingRegions(self, regions: collections.abc.Iterable[QgsMapClippingRegion]) -> None: ...
    def addClippingRegion(self, region: QgsMapClippingRegion) -> None: ...
    def labelBlockingRegions(self) -> list[QgsLabelBlockingRegion]: ...
    def setLabelBlockingRegions(self, regions: collections.abc.Iterable[QgsLabelBlockingRegion]) -> None: ...
    def setLabelBoundaryGeometry(self, boundary: 'QgsGeometry') -> None: ...
    def labelBoundaryGeometry(self) -> 'QgsGeometry': ...
    def labelingEngineSettings(self) -> 'QgsLabelingEngineSettings': ...
    def setLabelingEngineSettings(self, settings: 'QgsLabelingEngineSettings') -> None: ...
    def segmentationToleranceType(self) -> 'QgsAbstractGeometry.SegmentationToleranceType': ...
    def setSegmentationToleranceType(self, type: 'QgsAbstractGeometry.SegmentationToleranceType') -> None: ...
    def segmentationTolerance(self) -> float: ...
    def setSegmentationTolerance(self, tolerance: float) -> None: ...
    def writeXml(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    def readXml(self, node: QtXml.QDomNode) -> None: ...
    def fullExtent(self) -> 'QgsRectangle': ...
    def computeScaleForExtent(self, extent: 'QgsRectangle') -> float: ...
    def computeExtentForScale(self, center: 'QgsPointXY', scale: float) -> 'QgsRectangle': ...
    def layerTransform(self, layer: QgsMapLayer|None) -> 'QgsCoordinateTransform': ...
    @typing.overload
    def mapToLayerCoordinates(self, layer: QgsMapLayer|None, point: 'QgsPointXY') -> 'QgsPointXY': ...
    @typing.overload
    def mapToLayerCoordinates(self, layer: QgsMapLayer|None, point: 'QgsPoint') -> 'QgsPoint': ...
    @typing.overload
    def mapToLayerCoordinates(self, layer: QgsMapLayer|None, rect: 'QgsRectangle') -> 'QgsRectangle': ...
    @typing.overload
    def layerToMapCoordinates(self, layer: QgsMapLayer|None, point: 'QgsPointXY') -> 'QgsPointXY': ...
    @typing.overload
    def layerToMapCoordinates(self, layer: QgsMapLayer|None, point: 'QgsPoint') -> 'QgsPoint': ...
    @typing.overload
    def layerToMapCoordinates(self, layer: QgsMapLayer|None, rect: 'QgsRectangle') -> 'QgsRectangle': ...
    def outputExtentToLayerExtent(self, layer: QgsMapLayer|None, extent: 'QgsRectangle') -> 'QgsRectangle': ...
    def layerExtentToOutputExtent(self, layer: QgsMapLayer|None, extent: 'QgsRectangle') -> 'QgsRectangle': ...
    def layerToMapUnits(self, layer: QgsMapLayer|None, referenceExtent: 'QgsRectangle' = ...) -> float: ...
    def mapToPixel(self) -> 'QgsMapToPixel': ...
    def setPathResolver(self, resolver: 'QgsPathResolver') -> None: ...
    def pathResolver(self) -> 'QgsPathResolver': ...
    def setTransformContext(self, context: 'QgsCoordinateTransformContext') -> None: ...
    def transformContext(self) -> 'QgsCoordinateTransformContext': ...
    def expressionContext(self) -> QgsExpressionContext: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> None: ...
    def scale(self) -> float: ...
    def mapUnitsPerPixel(self) -> float: ...
    def visiblePolygonWithBuffer(self) -> QtGui.QPolygonF: ...
    def visiblePolygon(self) -> QtGui.QPolygonF: ...
    def visibleExtent(self) -> 'QgsRectangle': ...
    def hasValidSettings(self) -> bool: ...
    def outputImageFormat(self) -> QtGui.QImage.Format: ...
    def setOutputImageFormat(self, format: QtGui.QImage.Format) -> None: ...
    def setTextRenderFormat(self, format: Qgis.TextRenderFormat) -> None: ...
    def textRenderFormat(self) -> Qgis.TextRenderFormat: ...
    def testFlag(self, flag: Qgis.MapSettingsFlag) -> bool: ...
    def flags(self) -> Qgis.MapSettingsFlag: ...
    def setFlag(self, flag: Qgis.MapSettingsFlag, on: bool = ...) -> None: ...
    def setFlags(self, flags: Qgis.MapSettingsFlag) -> None: ...
    def selectionColor(self) -> QtGui.QColor: ...
    def setSelectionColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setBackgroundColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def ellipsoid(self) -> str: ...
    def setEllipsoid(self, ellipsoid: str|None) -> bool: ...
    def setScaleMethod(self, method: Qgis.ScaleCalculationMethod) -> None: ...
    def scaleMethod(self) -> Qgis.ScaleCalculationMethod: ...
    def mapUnits(self) -> Qgis.DistanceUnit: ...
    def destinationCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def setDestinationCrs(self, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    def clearCustomRenderingFlag(self, flag: str|None) -> None: ...
    def setCustomRenderingFlag(self, flag: str|None, value: typing.Any) -> None: ...
    def customRenderingFlags(self) -> dict[str, typing.Any]: ...
    def setCustomRenderFlags(self, customRenderFlags: str|None) -> None: ...
    def customRenderFlags(self) -> str: ...
    def setLayerStyleOverrides(self, overrides: dict[str|None, str|None]) -> None: ...
    def layerStyleOverrides(self) -> dict[str, str]: ...
    def setLayers(self, layers: collections.abc.Iterable[QgsMapLayer]) -> None: ...
    def layers(self, expandGroupLayers: bool = ...) -> list[QgsMapLayer]: ...
    def layerIds(self, expandGroupLayers: bool = ...) -> list[str]: ...
    def magnificationFactor(self) -> float: ...
    def setMagnificationFactor(self, factor: float, center: 'QgsPointXY|None' = ...) -> None: ...
    def setDpiTarget(self, dpi: float) -> None: ...
    def dpiTarget(self) -> float: ...
    def setOutputDpi(self, dpi: float) -> None: ...
    def outputDpi(self) -> float: ...
    def setRotation(self, rotation: float) -> None: ...
    def rotation(self) -> float: ...
    def deviceOutputSize(self) -> QtCore.QSize: ...
    def setDevicePixelRatio(self, dpr: float) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def setOutputSize(self, size: QtCore.QSize) -> None: ...
    def outputSize(self) -> QtCore.QSize: ...
    def setExtentBuffer(self, buffer: float) -> None: ...
    def extentBuffer(self) -> float: ...
    def setExtent(self, rect: 'QgsRectangle', magnified: bool = ...) -> None: ...
    def extent(self) -> 'QgsRectangle': ...


class QgsMapSettingsUtils(PyQt6.sip.wrapper):

    class EffectsCheckFlag(enum.IntFlag):
        IgnoreGeoPdfSupportedEffects = ... # type: QgsMapSettingsUtils.EffectsCheckFlag

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapSettingsUtils') -> None: ...

    @staticmethod
    def worldFileContent(mapSettings: QgsMapSettings) -> str: ...
    @staticmethod
    def worldFileParameters(mapSettings: QgsMapSettings) -> typing.Tuple[float, float, float, float, float, float]: ...
    @staticmethod
    def containsAdvancedEffects(mapSettings: QgsMapSettings, flags: 'QgsMapSettingsUtils.EffectsCheckFlag' = ...) -> list[str]: ...


class QgsMapThemeCollection(QtCore.QObject):

    class MapThemeLayerRecord(PyQt6.sip.wrapper):

        checkedLegendItems = ... # type: collections.abc.Iterable[str|None]
        currentStyle = ... # type: str|None
        expandedLayerNode = ... # type: bool
        expandedLegendItems = ... # type: collections.abc.Iterable[str|None]
        isVisible = ... # type: bool
        usingCurrentStyle = ... # type: bool
        usingLegendItems = ... # type: bool

        @typing.overload
        def __init__(self, l: QgsMapLayer|None = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsMapThemeCollection.MapThemeLayerRecord') -> None: ...

        def setLayer(self, layer: QgsMapLayer|None) -> None: ...
        def layer(self) -> QgsMapLayer|None: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...

    class MapThemeRecord(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsMapThemeCollection.MapThemeRecord') -> None: ...

        def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument) -> None: ...
        @staticmethod
        def readXml(element: QtXml.QDomElement, project: 'QgsProject|None') -> 'QgsMapThemeCollection.MapThemeRecord': ...
        def setCheckedGroupNodes(self, checkedGroupNodes: collections.abc.Iterable[str|None]) -> None: ...
        def setExpandedGroupNodes(self, expandedGroupNodes: collections.abc.Iterable[str|None]) -> None: ...
        def checkedGroupNodes(self) -> set[str]: ...
        def expandedGroupNodes(self) -> set[str]: ...
        def setHasCheckedStateInfo(self, hasInfo: bool) -> None: ...
        def setHasExpandedStateInfo(self, hasInfo: bool) -> None: ...
        def hasCheckedStateInfo(self) -> bool: ...
        def hasExpandedStateInfo(self) -> bool: ...
        def addLayerRecord(self, record: 'QgsMapThemeCollection.MapThemeLayerRecord') -> None: ...
        def removeLayerRecord(self, layer: QgsMapLayer|None) -> None: ...
        def setLayerRecords(self, records: collections.abc.Iterable['QgsMapThemeCollection.MapThemeLayerRecord']) -> None: ...
        def layerRecords(self) -> list['QgsMapThemeCollection.MapThemeLayerRecord']: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...

    def __init__(self, project: 'QgsProject|None' = ...) -> None: ...

    projectChanged: typing.ClassVar[QtCore.pyqtSignal]
    mapThemeRenamed: typing.ClassVar[QtCore.pyqtSignal]
    mapThemeChanged: typing.ClassVar[QtCore.pyqtSignal]
    mapThemesChanged: typing.ClassVar[QtCore.pyqtSignal]
    def masterVisibleLayers(self) -> list[QgsMapLayer]: ...
    def masterLayerOrder(self) -> list[QgsMapLayer]: ...
    def setProject(self, project: 'QgsProject|None') -> None: ...
    def project(self) -> 'QgsProject|None': ...
    def applyTheme(self, name: str|None, root: 'QgsLayerTreeGroup|None', model: 'QgsLayerTreeModel|None') -> None: ...
    @staticmethod
    def createThemeFromCurrentState(root: 'QgsLayerTreeGroup|None', model: 'QgsLayerTreeModel|None') -> 'QgsMapThemeCollection.MapThemeRecord': ...
    def writeXml(self, doc: QtXml.QDomDocument) -> None: ...
    def readXml(self, doc: QtXml.QDomDocument) -> None: ...
    def mapThemeStyleOverrides(self, name: str|None) -> dict[str, str]: ...
    def mapThemeVisibleLayers(self, name: str|None) -> list[QgsMapLayer]: ...
    def mapThemeVisibleLayerIds(self, name: str|None) -> list[str]: ...
    def mapThemeState(self, name: str|None) -> 'QgsMapThemeCollection.MapThemeRecord': ...
    def mapThemes(self) -> list[str]: ...
    def clear(self) -> None: ...
    def renameMapTheme(self, name: str|None, newName: str|None) -> bool: ...
    def removeMapTheme(self, name: str|None) -> None: ...
    def update(self, name: str|None, state: 'QgsMapThemeCollection.MapThemeRecord') -> None: ...
    def insert(self, name: str|None, state: 'QgsMapThemeCollection.MapThemeRecord') -> None: ...
    def hasMapTheme(self, name: str|None) -> bool: ...


class QgsMapToPixel(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, mapUnitsPerPixel: float, centerX: float, centerY: float, widthPixels: int, heightPixels: int, rotation: float) -> None: ...
    @typing.overload
    def __init__(self, mapUnitsPerPixel: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapToPixel') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def yCenter(self) -> float: ...
    def xCenter(self) -> float: ...
    def showParameters(self) -> str: ...
    def setParameters(self, mapUnitsPerPixel: float, centerX: float, centerY: float, widthPixels: int, heightPixels: int, rotation: float) -> None: ...
    def mapRotation(self) -> float: ...
    def setMapRotation(self, degrees: float, cx: float, cy: float) -> None: ...
    def mapHeight(self) -> int: ...
    def mapWidth(self) -> int: ...
    def mapUnitsPerPixel(self) -> float: ...
    def setMapUnitsPerPixel(self, mapUnitsPerPixel: float) -> None: ...
    @deprecated("""""")
    def toMapPoint(self, x: float, y: float) -> 'QgsPointXY': ...
    def toMapCoordinatesF(self, x: float, y: float) -> 'QgsPointXY': ...
    @typing.overload
    def toMapCoordinates(self, x: int, y: int) -> 'QgsPointXY': ...
    @typing.overload
    def toMapCoordinates(self, p: QtCore.QPoint) -> 'QgsPointXY': ...
    def transformBounds(self, bounds: QtCore.QRectF) -> QtCore.QRectF: ...
    def transformInPlace(self) -> typing.Tuple[float, float]: ...
    @typing.overload
    def transform(self, p: 'QgsPointXY') -> 'QgsPointXY': ...
    @typing.overload
    def transform(self, p: 'QgsPointXY|None') -> None: ...
    @typing.overload
    def transform(self, x: float, y: float) -> 'QgsPointXY': ...
    @typing.overload
    def transform(self) -> QtGui.QTransform: ...
    def isValid(self) -> bool: ...
    @staticmethod
    def fromScale(scale: float, mapUnits: Qgis.DistanceUnit, dpi: float = ...) -> 'QgsMapToPixel': ...


class QgsMapToPixelSimplifier(QgsAbstractGeometrySimplifier):

    class SimplifyFlag(enum.IntEnum):
        NoFlags = ... # type: QgsMapToPixelSimplifier.SimplifyFlag
        SimplifyGeometry = ... # type: QgsMapToPixelSimplifier.SimplifyFlag
        SimplifyEnvelope = ... # type: QgsMapToPixelSimplifier.SimplifyFlag

    @typing.overload
    def __init__(self, simplifyFlags: int, tolerance: float, simplifyAlgorithm: Qgis.VectorSimplificationAlgorithm = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapToPixelSimplifier') -> None: ...

    @typing.overload
    @staticmethod
    def isGeneralizableByMapBoundingBox(envelope: 'QgsRectangle', map2pixelTol: float) -> bool: ...
    @typing.overload
    def isGeneralizableByMapBoundingBox(self, envelope: 'QgsRectangle') -> bool: ...
    def setTolerance(self, value: float) -> None: ...
    @typing.overload
    def simplify(self, geometry: 'QgsGeometry') -> 'QgsGeometry': ...
    @typing.overload
    def simplify(self, geometry: 'QgsAbstractGeometry|None') -> 'QgsAbstractGeometry|None': ...
    def setSimplifyAlgorithm(self, simplifyAlgorithm: Qgis.VectorSimplificationAlgorithm) -> None: ...
    def simplifyAlgorithm(self) -> Qgis.VectorSimplificationAlgorithm: ...
    def setSimplifyFlags(self, simplifyFlags: int) -> None: ...
    def simplifyFlags(self) -> int: ...
    @staticmethod
    def equalSnapToGrid(x1: float, y1: float, x2: float, y2: float, gridOriginX: float, gridOriginY: float, gridInverseSizeXY: float) -> bool: ...
    @staticmethod
    def calculateLengthSquared2D(x1: float, y1: float, x2: float, y2: float) -> float: ...


class QgsMapUnitScale(PyQt6.sip.wrapper):

    maxScale = ... # type: float
    maxSizeMM = ... # type: float
    maxSizeMMEnabled = ... # type: bool
    minScale = ... # type: float
    minSizeMM = ... # type: float
    minSizeMMEnabled = ... # type: bool

    @typing.overload
    def __init__(self, minScale: float = ..., maxScale: float = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMapUnitScale') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def computeMapUnitsPerPixel(self, c: 'QgsRenderContext') -> float: ...
    def isNull(self) -> bool: ...


class QgsMargins(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMargins') -> None: ...

    def __eq__(self, other: object): ...
    def __ne__(self, other: object): ...
    @typing.overload
    def __add__(self, m2: 'QgsMargins') -> 'QgsMargins': ...
    @typing.overload
    def __add__(self, rhs: float) -> 'QgsMargins': ...
    def __radd__(self, lhs: float) -> 'QgsMargins': ...
    @typing.overload
    def __sub__(self, m2: 'QgsMargins') -> 'QgsMargins': ...
    @typing.overload
    def __sub__(self, rhs: float) -> 'QgsMargins': ...
    def __mul__(self, factor: float) -> 'QgsMargins': ...
    def __rmul__(self, factor: float) -> 'QgsMargins': ...
    def __truediv__(self, divisor: float) -> 'QgsMargins': ...
    def __pos__(self) -> 'QgsMargins': ...
    def __neg__(self) -> 'QgsMargins': ...
    def __repr__(self) -> typing.Any: ...
    @staticmethod
    def fromString(string: str|None) -> 'QgsMargins': ...
    def toString(self) -> str: ...
    def __itruediv__(self, divisor: float) -> 'QgsMargins': ...
    def __imul__(self, factor: float) -> 'QgsMargins': ...
    @typing.overload
    def __isub__(self, margins: 'QgsMargins') -> 'QgsMargins': ...
    @typing.overload
    def __isub__(self, subtrahend: float) -> 'QgsMargins': ...
    @typing.overload
    def __iadd__(self, margins: 'QgsMargins') -> 'QgsMargins': ...
    @typing.overload
    def __iadd__(self, addend: float) -> 'QgsMargins': ...
    def setBottom(self, bottom: float) -> None: ...
    def setRight(self, right: float) -> None: ...
    def setTop(self, top: float) -> None: ...
    def setLeft(self, left: float) -> None: ...
    def bottom(self) -> float: ...
    def right(self) -> float: ...
    def top(self) -> float: ...
    def left(self) -> float: ...
    def isNull(self) -> bool: ...


class QgsMaskIdProvider(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMaskIdProvider') -> None: ...

    def size(self) -> int: ...
    def maskId(self, labelLayerId: str|None = ..., labelRuleId: str|None = ...) -> int: ...
    def insertLabelLayer(self, layerId: str|None, ruleId: str|None, maskedSymbolLayers: collections.abc.Iterable['QgsSymbolLayerReference']) -> int: ...


class QgsMaskRenderSettings(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMaskRenderSettings') -> None: ...

    def setSimplificationTolerance(self, tolerance: float) -> None: ...
    def simplifyTolerance(self) -> float: ...


class QgsMathUtils(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMathUtils') -> None: ...

    @staticmethod
    def doubleToRational(value: float, tolerance: float = ..., maxIterations: int = ...) -> typing.Tuple[int, int]: ...


class QgsMatrix4x4(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, m11: float, m12: float, m13: float, m14: float, m21: float, m22: float, m23: float, m24: float, m31: float, m32: float, m33: float, m34: float, m41: float, m42: float, m43: float, m44: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMatrix4x4') -> None: ...

    @typing.overload
    def __mul__(self, vector: 'QgsVector3D') -> 'QgsVector3D': ...
    @typing.overload
    def __mul__(self, m2: 'QgsMatrix4x4') -> 'QgsMatrix4x4': ...
    def __repr__(self) -> typing.Any: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def map(self, vector: 'QgsVector3D') -> 'QgsVector3D': ...
    def translate(self, vector: 'QgsVector3D') -> None: ...
    def data(self) -> list[float]: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsMeasureUtils(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMeasureUtils') -> None: ...

    @staticmethod
    def formatDistanceForProject(project: 'QgsProject|None', distance: float, unit: Qgis.DistanceUnit) -> str: ...
    @staticmethod
    def formatAreaForProject(project: 'QgsProject|None', area: float, unit: Qgis.AreaUnit) -> str: ...


class QgsMessageLog(QtCore.QObject):

    def __init__(self) -> None: ...

    messageReceivedWithFormat: typing.ClassVar[QtCore.pyqtSignal]
    messageReceived: typing.ClassVar[QtCore.pyqtSignal]
    @staticmethod
    def logMessage(message: str|None, tag: str|None = ..., level: Qgis.MessageLevel = ..., notifyUser: bool = ..., file: str = ..., function: str = ..., line: int = ..., format: Qgis.StringFormat = ...) -> None: ...


class QgsMessageLogNotifyBlocker(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...


class QgsMessageLogConsole(QtCore.QObject):

    def __init__(self) -> None: ...

    @typing.overload
    def logMessage(self, message: str|None, tag: str|None, level: Qgis.MessageLevel) -> None: ...
    @typing.overload
    def logMessage(self, message: str|None, tag: str|None, level: Qgis.MessageLevel, format: Qgis.StringFormat) -> None: ...
    def formatLogMessage(self, message: str|None, tag: str|None, level: Qgis.MessageLevel = ...) -> str: ...


class QgsMessageOutput(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMessageOutput') -> None: ...

    @staticmethod
    def createMessageOutput() -> 'QgsMessageOutput|None': ...
    @typing.overload
    def showMessage(self, blocking: bool = ...) -> None: ...
    @typing.overload
    @staticmethod
    def showMessage(title: str|None, message: str|None, format: Qgis.StringFormat) -> None: ...
    def setTitle(self, title: str|None) -> None: ...
    def appendMessage(self, message: str|None) -> None: ...
    def setMessage(self, message: str|None, format: Qgis.StringFormat) -> None: ...


class QgsMessageOutputConsole(QtCore.QObject, QgsMessageOutput):

    def __init__(self) -> None: ...

    destroyed: typing.ClassVar[QtCore.pyqtSignal]
    def showMessage(self, blocking: bool = ...) -> None: ...
    def setTitle(self, title: str|None) -> None: ...
    def appendMessage(self, message: str|None) -> None: ...
    def setMessage(self, message: str|None, format: Qgis.StringFormat) -> None: ...


class QgsMimeDataUtils(PyQt6.sip.wrapper):

    class Uri(PyQt6.sip.wrapper):

        filePath = ... # type: str|None
        layerId = ... # type: str|None
        layerType = ... # type: str|None
        name = ... # type: str|None
        pId = ... # type: str|None
        providerKey = ... # type: str|None
        supportedCrs = ... # type: collections.abc.Iterable[str|None]
        supportedFormats = ... # type: collections.abc.Iterable[str|None]
        uri = ... # type: str|None
        wkbType = ... # type: Qgis.WkbType

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, encData: str|None) -> None: ...
        @typing.overload
        def __init__(self, layer: QgsMapLayer|None) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsMimeDataUtils.Uri') -> None: ...

        def __repr__(self) -> typing.Any: ...
        def mapLayer(self) -> QgsMapLayer|None: ...
        def meshLayer(self, error: str|None) -> typing.Tuple['QgsMeshLayer|None', bool]: ...
        def rasterLayer(self, error: str|None) -> typing.Tuple['QgsRasterLayer|None', bool]: ...
        def vectorLayer(self, error: str|None) -> typing.Tuple[QgsVectorLayer|None, bool]: ...
        def data(self) -> str: ...
        def isValid(self) -> bool: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMimeDataUtils') -> None: ...

    @staticmethod
    def hasOriginatedFromCurrentAppInstance(uri: 'QgsMimeDataUtils.Uri') -> bool: ...
    @staticmethod
    def layerTreeNodesToUriList(nodes: collections.abc.Iterable['QgsLayerTreeNode']) -> QtCore.QByteArray: ...
    @staticmethod
    def decodeUriList(data: QtCore.QMimeData|None) -> list['QgsMimeDataUtils.Uri']: ...
    @staticmethod
    def isUriList(data: QtCore.QMimeData|None) -> bool: ...
    @staticmethod
    def encodeUriList(layers: collections.abc.Iterable['QgsMimeDataUtils.Uri']) -> QtCore.QMimeData|None: ...


class QgsMultiRenderChecker(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMultiRenderChecker') -> None: ...

    @staticmethod
    def drawBackground(image: QtGui.QImage|None) -> None: ...
    def controlImagePath(self) -> str: ...
    def markdownReport(self) -> str: ...
    def report(self) -> str: ...
    def runTest(self, testName: str|None, mismatchCount: int = ...) -> bool: ...
    def setSizeTolerance(self, xTolerance: int, yTolerance: int) -> None: ...
    def setColorTolerance(self, colorTolerance: int) -> None: ...
    def setMapSettings(self, mapSettings: QgsMapSettings) -> None: ...
    def setExpectFail(self, expectFail: bool) -> None: ...
    def setRenderedImage(self, renderedImagePath: str|None) -> None: ...
    def setControlPathPrefix(self, prefix: str|None) -> None: ...
    def setFileFunctionLine(self, file: str|None, function: str|None, line: int) -> None: ...
    def setControlName(self, name: str|None) -> None: ...


class QgsLayoutChecker(QgsMultiRenderChecker):

    @typing.overload
    def __init__(self, testName: str|None, layout: 'QgsLayout|None') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLayoutChecker') -> None: ...

    def testLayout(self, page: int = ..., pixelDiff: int = ..., createReferenceImage: bool = ...) -> typing.Tuple[bool, str]: ...
    def setSize(self, size: QtCore.QSize) -> None: ...


class QgsObjectCustomProperties(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsObjectCustomProperties') -> None: ...

    def writeXml(self, parentNode: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    def readXml(self, parentNode: QtXml.QDomNode, keyStartsWith: str|None = ...) -> None: ...
    def contains(self, key: str|None) -> bool: ...
    def remove(self, key: str|None) -> None: ...
    def value(self, key: str|None, defaultValue: typing.Any = ...) -> typing.Any: ...
    def setValue(self, key: str|None, value: typing.Any) -> None: ...
    def keys(self) -> list[str]: ...


class QgsEmbeddedScriptEntity(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, type: Qgis.EmbeddedScriptType, name: str|None, script: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsEmbeddedScriptEntity') -> None: ...

    def script(self) -> str: ...
    def name(self) -> str: ...
    def type(self) -> Qgis.EmbeddedScriptType: ...


class QgsObjectVisitorContext(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsObjectVisitorContext') -> None: ...


class QgsObjectEntityVisitorInterface(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsObjectEntityVisitorInterface') -> None: ...

    def visitEmbeddedScript(self, entity: QgsEmbeddedScriptEntity, context: QgsObjectVisitorContext) -> bool: ...


class QgsEmbeddedScriptVisitor(QgsObjectEntityVisitorInterface):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsEmbeddedScriptVisitor') -> None: ...

    def embeddedScripts(self) -> list[QgsEmbeddedScriptEntity]: ...
    def visitEmbeddedScript(self, entity: QgsEmbeddedScriptEntity, a1: QgsObjectVisitorContext) -> bool: ...


class QgsOfflineEditing(QtCore.QObject):

    class ContainerType(enum.IntEnum):
        SpatiaLite = ... # type: QgsOfflineEditing.ContainerType
        GPKG = ... # type: QgsOfflineEditing.ContainerType

    class ProgressMode(enum.IntEnum):
        CopyFeatures = ... # type: QgsOfflineEditing.ProgressMode
        ProcessFeatures = ... # type: QgsOfflineEditing.ProgressMode
        AddFields = ... # type: QgsOfflineEditing.ProgressMode
        AddFeatures = ... # type: QgsOfflineEditing.ProgressMode
        RemoveFeatures = ... # type: QgsOfflineEditing.ProgressMode
        UpdateFeatures = ... # type: QgsOfflineEditing.ProgressMode
        UpdateGeometries = ... # type: QgsOfflineEditing.ProgressMode

    def __init__(self) -> None: ...

    warning: typing.ClassVar[QtCore.pyqtSignal]
    progressStopped: typing.ClassVar[QtCore.pyqtSignal]
    progressUpdated: typing.ClassVar[QtCore.pyqtSignal]
    progressModeSet: typing.ClassVar[QtCore.pyqtSignal]
    layerProgressUpdated: typing.ClassVar[QtCore.pyqtSignal]
    progressStarted: typing.ClassVar[QtCore.pyqtSignal]
    def synchronize(self, useTransaction: bool = ...) -> None: ...
    def isOfflineProject(self) -> bool: ...
    def convertToOfflineProject(self, offlineDataPath: str|None, offlineDbFile: str|None, layerIds: collections.abc.Iterable[str|None], onlySelected: bool = ..., containerType: 'QgsOfflineEditing.ContainerType' = ..., layerNameSuffix: str|None = ...) -> bool: ...


class QgsOgcUtils(PyQt6.sip.wrapper):

    class FilterVersion(enum.IntEnum):
        FILTER_OGC_1_0 = ... # type: QgsOgcUtils.FilterVersion
        FILTER_OGC_1_1 = ... # type: QgsOgcUtils.FilterVersion
        FILTER_FES_2_0 = ... # type: QgsOgcUtils.FilterVersion

    class GMLVersion(enum.IntEnum):
        GML_2_1_2 = ... # type: QgsOgcUtils.GMLVersion
        GML_3_1_0 = ... # type: QgsOgcUtils.GMLVersion
        GML_3_2_1 = ... # type: QgsOgcUtils.GMLVersion

    class Context(PyQt6.sip.wrapper):

        layer = ... # type: QgsMapLayer
        transformContext = ... # type: 'QgsCoordinateTransformContext'

        @typing.overload
        def __init__(self, layer: QgsMapLayer|None = ..., transformContext: 'QgsCoordinateTransformContext' = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsOgcUtils.Context') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsOgcUtils') -> None: ...

    @staticmethod
    def elseFilterExpression(doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    @typing.overload
    @staticmethod
    def expressionToOgcExpression(exp: 'QgsExpression', doc: QtXml.QDomDocument, errorMessage: str|None = ..., requiresFilterElement: bool = ...) -> QtXml.QDomElement: ...
    @typing.overload
    @staticmethod
    def expressionToOgcExpression(exp: 'QgsExpression', doc: QtXml.QDomDocument, gmlVersion: 'QgsOgcUtils.GMLVersion', filterVersion: 'QgsOgcUtils.FilterVersion', geometryName: str|None, srsName: str|None, honourAxisOrientation: bool, invertAxisOrientation: bool, errorMessage: str|None = ..., requiresFilterElement: bool = ..., fieldNameToXPathMap: dict[str|None, str|None] = ..., namespacePrefixToUriMap: dict[str|None, str|None] = ...) -> QtXml.QDomElement: ...
    @staticmethod
    def expressionToOgcFilter(exp: 'QgsExpression', doc: QtXml.QDomDocument, errorMessage: str|None = ...) -> QtXml.QDomElement: ...
    @typing.overload
    @staticmethod
    def expressionFromOgcFilter(element: QtXml.QDomElement, layer: QgsVectorLayer|None = ...) -> 'QgsExpression|None': ...
    @typing.overload
    @staticmethod
    def expressionFromOgcFilter(element: QtXml.QDomElement, version: 'QgsOgcUtils.FilterVersion', layer: QgsVectorLayer|None = ...) -> 'QgsExpression|None': ...
    @staticmethod
    def colorFromOgcFill(fillElement: QtXml.QDomElement) -> QtGui.QColor: ...
    @typing.overload
    @staticmethod
    def rectangleToGMLEnvelope(env: 'QgsRectangle|None', doc: QtXml.QDomDocument, precision: int = ...) -> QtXml.QDomElement: ...
    @typing.overload
    @staticmethod
    def rectangleToGMLEnvelope(env: 'QgsRectangle|None', doc: QtXml.QDomDocument, srsName: str|None, invertAxisOrientation: bool, precision: int = ...) -> QtXml.QDomElement: ...
    @typing.overload
    @staticmethod
    def rectangleToGMLBox(box: 'QgsRectangle|None', doc: QtXml.QDomDocument, precision: int = ...) -> QtXml.QDomElement: ...
    @typing.overload
    @staticmethod
    def rectangleToGMLBox(box: 'QgsRectangle|None', doc: QtXml.QDomDocument, srsName: str|None, invertAxisOrientation: bool, precision: int = ...) -> QtXml.QDomElement: ...
    @typing.overload
    @staticmethod
    def geometryToGML(geometry: 'QgsGeometry', doc: QtXml.QDomDocument, gmlVersion: 'QgsOgcUtils.GMLVersion', srsName: str|None, invertAxisOrientation: bool, gmlIdBase: str|None, precision: int = ...) -> QtXml.QDomElement: ...
    @typing.overload
    @staticmethod
    def geometryToGML(geometry: 'QgsGeometry', doc: QtXml.QDomDocument, format: str|None, precision: int = ...) -> QtXml.QDomElement: ...
    @typing.overload
    @staticmethod
    def geometryToGML(geometry: 'QgsGeometry', doc: QtXml.QDomDocument, precision: int = ...) -> QtXml.QDomElement: ...
    @staticmethod
    def rectangleFromGMLEnvelope(envelopeNode: QtXml.QDomNode) -> 'QgsRectangle': ...
    @staticmethod
    def rectangleFromGMLBox(boxNode: QtXml.QDomNode) -> 'QgsRectangle': ...
    @typing.overload
    @staticmethod
    def geometryFromGML(xmlString: str|None, context: 'QgsOgcUtils.Context' = ...) -> 'QgsGeometry': ...
    @typing.overload
    @staticmethod
    def geometryFromGML(geometryNode: QtXml.QDomNode, context: 'QgsOgcUtils.Context' = ...) -> 'QgsGeometry': ...


class QgsOptionalQgsExpressionBase(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, data: 'QgsExpression') -> None: ...
    @typing.overload
    def __init__(self, data: 'QgsExpression', enabled: bool) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsOptionalQgsExpressionBase') -> None: ...

    def __ne__(self, other: object): ...
    def setData(self, data: 'QgsExpression') -> None: ...
    def data(self) -> 'QgsExpression': ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def __eq__(self, other: object): ...


class QgsOptionalExpression(QgsOptionalQgsExpressionBase):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, expression: 'QgsExpression') -> None: ...
    @typing.overload
    def __init__(self, expression: 'QgsExpression', enabled: bool) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsOptionalExpression') -> None: ...

    def readXml(self, element: QtXml.QDomElement) -> None: ...
    def writeXml(self, element: QtXml.QDomElement) -> None: ...


class QgsOwsConnection(QtCore.QObject):

    def __init__(self, service: str|None, connName: str|None) -> None: ...

    @staticmethod
    def setSelectedConnection(service: str|None, name: str|None) -> None: ...
    @staticmethod
    def selectedConnection(service: str|None) -> str: ...
    @staticmethod
    def deleteConnection(service: str|None, name: str|None) -> None: ...
    @staticmethod
    def connectionList(service: str|None) -> list[str]: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def addWfsConnectionSettings(uri: QgsDataSourceUri, settingsKey: str|None) -> QgsDataSourceUri: ...
    @typing.overload
    @staticmethod
    def addWfsConnectionSettings(uri: QgsDataSourceUri, service: str|None, connName: str|None) -> QgsDataSourceUri: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def addWmsWcsConnectionSettings(uri: QgsDataSourceUri, settingsKey: str|None) -> QgsDataSourceUri: ...
    @typing.overload
    @staticmethod
    def addWmsWcsConnectionSettings(uri: QgsDataSourceUri, service: str|None, connName: str|None) -> QgsDataSourceUri: ...
    def uri(self) -> QgsDataSourceUri: ...
    def service(self) -> str: ...
    def connectionInfo(self) -> str: ...
    def connectionName(self) -> str: ...


class QgsPathResolver(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, baseFileName: str|None = ..., attachmentDir: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPathResolver') -> None: ...

    @staticmethod
    def removePathWriter(id: str|None) -> None: ...
    @staticmethod
    def setPathWriter(a0: typing.Callable[..., None]) -> str: ...
    @staticmethod
    def removePathPreprocessor(id: str|None) -> None: ...
    @staticmethod
    def setPathPreprocessor(a0: typing.Callable[..., None]) -> str: ...
    def readPath(self, filename: str|None) -> str: ...
    def writePath(self, filename: str|None) -> str: ...


class QgsPluginLayer(QgsMapLayer):

    def __init__(self, layerType: str|None, layerName: str|None = ...) -> None: ...

    def icon(self) -> QtGui.QIcon: ...
    def dataProvider(self) -> 'QgsDataProvider|None': ...
    def setSource(self, source: str|None) -> None: ...
    def setExtent(self, extent: 'QgsRectangle') -> None: ...
    def pluginLayerType(self) -> str: ...
    def clone(self) -> 'QgsPluginLayer|None': ...
    def __repr__(self) -> typing.Any: ...


class QgsPluginLayerType(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, name: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPluginLayerType') -> None: ...

    def showLayerProperties(self, layer: QgsPluginLayer|None) -> bool: ...
    @typing.overload
    def createLayer(self) -> QgsPluginLayer|None: ...
    @typing.overload
    def createLayer(self, uri: str|None) -> QgsPluginLayer|None: ...
    def name(self) -> str: ...


class QgsPluginLayerRegistry(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def createLayer(self, typeName: str|None, uri: str|None = ...) -> QgsPluginLayer|None: ...
    def pluginLayerType(self, typeName: str|None) -> QgsPluginLayerType|None: ...
    def removePluginLayerType(self, typeName: str|None) -> bool: ...
    def addPluginLayerType(self, pluginLayerType: QgsPluginLayerType|None) -> bool: ...
    def pluginLayerTypes(self) -> list[str]: ...


class QgsPointLocator(QtCore.QObject):

    class Type(enum.IntEnum):
        Invalid = ... # type: QgsPointLocator.Type
        Vertex = ... # type: QgsPointLocator.Type
        Edge = ... # type: QgsPointLocator.Type
        Area = ... # type: QgsPointLocator.Type
        Centroid = ... # type: QgsPointLocator.Type
        MiddleOfSegment = ... # type: QgsPointLocator.Type
        LineEndpoint = ... # type: QgsPointLocator.Type
        All = ... # type: QgsPointLocator.Type

    class Match(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, t: 'QgsPointLocator.Type', vl: QgsVectorLayer|None, fid: int, dist: float, pt: 'QgsPointXY', vertexIndex: int = ..., edgePoints: 'QgsPointXY|None' = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsPointLocator.Match') -> None: ...

        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def interpolatedPoint(self, destinationCrs: 'QgsCoordinateReferenceSystem' = ...) -> 'QgsPoint': ...
        def edgePoints(self) -> typing.Tuple['QgsPointXY', 'QgsPointXY']: ...
        def featureId(self) -> int: ...
        def layer(self) -> QgsVectorLayer|None: ...
        def vertexIndex(self) -> int: ...
        def point(self) -> 'QgsPointXY': ...
        def distance(self) -> float: ...
        def hasLineEndpoint(self) -> bool: ...
        def hasMiddleSegment(self) -> bool: ...
        def hasArea(self) -> bool: ...
        def hasCentroid(self) -> bool: ...
        def hasEdge(self) -> bool: ...
        def hasVertex(self) -> bool: ...
        def isValid(self) -> bool: ...
        def type(self) -> 'QgsPointLocator.Type': ...

    class MatchFilter(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsPointLocator.MatchFilter') -> None: ...

        def acceptMatch(self, match: 'QgsPointLocator.Match') -> bool: ...

    def __init__(self, layer: QgsVectorLayer|None, destinationCrs: 'QgsCoordinateReferenceSystem' = ..., transformContext: 'QgsCoordinateTransformContext' = ..., extent: 'QgsRectangle|None' = ...) -> None: ...

    def destroyIndex(self) -> None: ...
    def rebuildIndex(self, maxFeaturesToIndex: int = ...) -> bool: ...
    initFinished: typing.ClassVar[QtCore.pyqtSignal]
    def waitForIndexingFinished(self) -> None: ...
    def isIndexing(self) -> bool: ...
    def cachedGeometryCount(self) -> int: ...
    def pointInPolygon(self, point: 'QgsPointXY', relaxed: bool = ..., filter: 'QgsPointLocator.MatchFilter|None' = ...) -> list['QgsPointLocator.Match']: ...
    @typing.overload
    def verticesInRect(self, rect: 'QgsRectangle', filter: 'QgsPointLocator.MatchFilter|None' = ..., relaxed: bool = ...) -> list['QgsPointLocator.Match']: ...
    @typing.overload
    def verticesInRect(self, point: 'QgsPointXY', tolerance: float, filter: 'QgsPointLocator.MatchFilter|None' = ..., relaxed: bool = ...) -> list['QgsPointLocator.Match']: ...
    @typing.overload
    def edgesInRect(self, rect: 'QgsRectangle', filter: 'QgsPointLocator.MatchFilter|None' = ..., relaxed: bool = ...) -> list['QgsPointLocator.Match']: ...
    @typing.overload
    def edgesInRect(self, point: 'QgsPointXY', tolerance: float, filter: 'QgsPointLocator.MatchFilter|None' = ..., relaxed: bool = ...) -> list['QgsPointLocator.Match']: ...
    def nearestArea(self, point: 'QgsPointXY', tolerance: float, filter: 'QgsPointLocator.MatchFilter|None' = ..., relaxed: bool = ...) -> 'QgsPointLocator.Match': ...
    def nearestEdge(self, point: 'QgsPointXY', tolerance: float, filter: 'QgsPointLocator.MatchFilter|None' = ..., relaxed: bool = ...) -> 'QgsPointLocator.Match': ...
    def nearestLineEndpoints(self, point: 'QgsPointXY', tolerance: float, filter: 'QgsPointLocator.MatchFilter|None' = ..., relaxed: bool = ...) -> 'QgsPointLocator.Match': ...
    def nearestMiddleOfSegment(self, point: 'QgsPointXY', tolerance: float, filter: 'QgsPointLocator.MatchFilter|None' = ..., relaxed: bool = ...) -> 'QgsPointLocator.Match': ...
    def nearestCentroid(self, point: 'QgsPointXY', tolerance: float, filter: 'QgsPointLocator.MatchFilter|None' = ..., relaxed: bool = ...) -> 'QgsPointLocator.Match': ...
    def nearestVertex(self, point: 'QgsPointXY', tolerance: float, filter: 'QgsPointLocator.MatchFilter|None' = ..., relaxed: bool = ...) -> 'QgsPointLocator.Match': ...
    def hasIndex(self) -> bool: ...
    def init(self, maxFeaturesToIndex: int = ..., relaxed: bool = ...) -> bool: ...
    def setRenderContext(self, context: 'QgsRenderContext|None') -> None: ...
    def setExtent(self, extent: 'QgsRectangle|None') -> None: ...
    def extent(self) -> 'QgsRectangle|None': ...
    def destinationCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def layer(self) -> QgsVectorLayer|None: ...


class QgsPointXY(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, p: 'QgsPointXY') -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float) -> None: ...
    @typing.overload
    def __init__(self, point: QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, point: QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, point: 'QgsPoint') -> None: ...

    def __hash__(self) -> int: ...
    def __getitem__(self, a0: int) -> typing.Any: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def __itruediv__(self, scalar: float) -> 'QgsPointXY': ...
    def __imul__(self, scalar: float) -> 'QgsPointXY': ...
    def __truediv__(self, scalar: float) -> 'QgsPointXY': ...
    def __mul__(self, scalar: float) -> 'QgsPointXY': ...
    def __add__(self, v: 'QgsVector') -> 'QgsPointXY': ...
    def __isub__(self, v: 'QgsVector') -> 'QgsPointXY': ...
    def __iadd__(self, v: 'QgsVector') -> 'QgsPointXY': ...
    @typing.overload
    def __sub__(self, p: 'QgsPointXY') -> 'QgsVector': ...
    @typing.overload
    def __sub__(self, v: 'QgsVector') -> 'QgsPointXY': ...
    def multiply(self, scalar: float) -> None: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def distanceCompare(self, other: 'QgsPointXY', epsilon: float = ...) -> bool: ...
    def compare(self, other: 'QgsPointXY', epsilon: float = ...) -> bool: ...
    def isEmpty(self) -> bool: ...
    def project(self, distance: float, bearing: float) -> 'QgsPointXY': ...
    def azimuth(self, other: 'QgsPointXY') -> float: ...
    def sqrDistToSegment(self, x1: float, y1: float, x2: float, y2: float, epsilon: float = ...) -> typing.Tuple[float, 'QgsPointXY']: ...
    @typing.overload
    def distance(self, x: float, y: float) -> float: ...
    @typing.overload
    def distance(self, other: 'QgsPointXY') -> float: ...
    @typing.overload
    def sqrDist(self, x: float, y: float) -> float: ...
    @typing.overload
    def sqrDist(self, other: 'QgsPointXY') -> float: ...
    def asWkt(self) -> str: ...
    def toString(self, precision: int = ...) -> str: ...
    def toQPointF(self) -> QtCore.QPointF: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def set(self, x: float, y: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setX(self, x: float) -> None: ...


class QgsPostgresStringUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPostgresStringUtils') -> None: ...

    @staticmethod
    def buildArray(list: collections.abc.Iterable[typing.Any]) -> str: ...
    @staticmethod
    def parseArray(string: str|None) -> list[typing.Any]: ...


class QgsPropertyDefinition(PyQt6.sip.wrapper):

    class DataType(enum.IntEnum):
        DataTypeString = ... # type: QgsPropertyDefinition.DataType
        DataTypeNumeric = ... # type: QgsPropertyDefinition.DataType
        DataTypeBoolean = ... # type: QgsPropertyDefinition.DataType

    class StandardPropertyTemplate(enum.IntEnum):
        Boolean = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        Integer = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        IntegerPositive = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        IntegerPositiveGreaterZero = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        Double = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        DoublePositive = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        Double0To1 = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        Rotation = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        String = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        Opacity = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        RenderUnits = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        ColorWithAlpha = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        ColorNoAlpha = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        PenJoinStyle = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        BlendMode = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        Point = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        Size = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        Size2D = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        LineStyle = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        StrokeWidth = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        FillStyle = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        CapStyle = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        HorizontalAnchor = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        VerticalAnchor = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        SvgPath = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        Offset = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        DateTime = ... # type: QgsPropertyDefinition.StandardPropertyTemplate
        Custom = ... # type: QgsPropertyDefinition.StandardPropertyTemplate

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name: str|None, description: str|None, type: 'QgsPropertyDefinition.StandardPropertyTemplate', origin: str|None = ..., comment: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, name: str|None, dataType: 'QgsPropertyDefinition.DataType', description: str|None, helpText: str|None, origin: str|None = ..., comment: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPropertyDefinition') -> None: ...

    def supportsAssistant(self) -> bool: ...
    def standardTemplate(self) -> 'QgsPropertyDefinition.StandardPropertyTemplate': ...
    def dataType(self) -> 'QgsPropertyDefinition.DataType': ...
    def setDataType(self, type: 'QgsPropertyDefinition.DataType') -> None: ...
    def helpText(self) -> str: ...
    def setComment(self, comment: str|None) -> None: ...
    def comment(self) -> str: ...
    def description(self) -> str: ...
    def setOrigin(self, origin: str|None) -> None: ...
    def origin(self) -> str: ...
    def setName(self, name: str|None) -> None: ...
    def name(self) -> str: ...


class QgsProperty(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsProperty') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def convertToTransformer(self) -> bool: ...
    def transformer(self) -> 'QgsPropertyTransformer|None': ...
    def setTransformer(self, transformer: 'QgsPropertyTransformer|None') -> None: ...
    def loadVariant(self, property: typing.Any) -> bool: ...
    def toVariant(self) -> typing.Any: ...
    def valueAsBool(self, context: QgsExpressionContext, defaultValue: bool = ...) -> typing.Tuple[bool, bool]: ...
    def valueAsInt(self, context: QgsExpressionContext, defaultValue: int = ...) -> typing.Tuple[int, bool]: ...
    def valueAsDouble(self, context: QgsExpressionContext, defaultValue: float = ...) -> typing.Tuple[float, bool]: ...
    def valueAsColor(self, context: QgsExpressionContext, defaultColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> typing.Tuple[QtGui.QColor, bool]: ...
    def valueAsString(self, context: QgsExpressionContext, defaultString: str|None = ...) -> typing.Tuple[str, bool]: ...
    def valueAsDateTime(self, context: QgsExpressionContext, defaultDateTime: QtCore.QDateTime|datetime.datetime = ...) -> typing.Tuple[QtCore.QDateTime, bool]: ...
    def value(self, context: QgsExpressionContext, defaultValue: typing.Any = ...) -> typing.Tuple[typing.Any, bool]: ...
    def isProjectColor(self) -> bool: ...
    def referencedFields(self, context: QgsExpressionContext = ..., ignoreContext: bool = ...) -> set[str]: ...
    def prepare(self, context: QgsExpressionContext = ...) -> bool: ...
    def asExpression(self) -> str: ...
    def expressionString(self) -> str: ...
    def setExpressionString(self, expression: str|None) -> None: ...
    def field(self) -> str: ...
    def setField(self, field: str|None) -> None: ...
    def staticValue(self) -> typing.Any: ...
    def setStaticValue(self, value: typing.Any) -> None: ...
    def setActive(self, active: bool) -> None: ...
    def isStaticValueInContext(self, context: QgsExpressionContext) -> typing.Tuple[bool, typing.Any]: ...
    def isActive(self) -> bool: ...
    def propertyType(self) -> Qgis.PropertyType: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    @staticmethod
    def fromValue(value: typing.Any, isActive: bool = ...) -> 'QgsProperty': ...
    @staticmethod
    def fromField(fieldName: str|None, isActive: bool = ...) -> 'QgsProperty': ...
    @staticmethod
    def fromExpression(expression: str|None, isActive: bool = ...) -> 'QgsProperty': ...
    @staticmethod
    def variantMapToPropertyMap(variantMap: dict[str|None, typing.Any]) -> dict[str, 'QgsProperty']: ...
    @staticmethod
    def propertyMapToVariantMap(propertyMap: dict[str|None, 'QgsProperty']) -> dict[str, typing.Any]: ...


class QgsAbstractPropertyCollection(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, name: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractPropertyCollection') -> None: ...

    def loadVariant(self, configuration: typing.Any, definitions: dict[int, QgsPropertyDefinition]) -> bool: ...
    def toVariant(self, definitions: dict[int, QgsPropertyDefinition]) -> typing.Any: ...
    def readXml(self, collectionElem: QtXml.QDomElement, definitions: dict[int, QgsPropertyDefinition]) -> bool: ...
    def writeXml(self, collectionElem: QtXml.QDomElement, definitions: dict[int, QgsPropertyDefinition]) -> bool: ...
    def hasDynamicProperties(self) -> bool: ...
    def hasActiveProperties(self) -> bool: ...
    def isActive(self, key: int) -> bool: ...
    def referencedFields(self, context: QgsExpressionContext = ..., ignoreContext: bool = ...) -> set[str]: ...
    def prepare(self, context: QgsExpressionContext = ...) -> bool: ...
    def valueAsBool(self, key: int, context: QgsExpressionContext, defaultValue: bool = ...) -> typing.Tuple[bool, bool]: ...
    def valueAsInt(self, key: int, context: QgsExpressionContext, defaultValue: int = ...) -> typing.Tuple[int, bool]: ...
    def valueAsDouble(self, key: int, context: QgsExpressionContext, defaultValue: float = ...) -> typing.Tuple[float, bool]: ...
    def valueAsColor(self, key: int, context: QgsExpressionContext, defaultColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> typing.Tuple[QtGui.QColor, bool]: ...
    def valueAsString(self, key: int, context: QgsExpressionContext, defaultString: str|None = ...) -> typing.Tuple[str, bool]: ...
    def valueAsDateTime(self, key: int, context: QgsExpressionContext, defaultDateTime: QtCore.QDateTime|datetime.datetime = ...) -> typing.Tuple[QtCore.QDateTime, bool]: ...
    def value(self, key: int, context: QgsExpressionContext, defaultValue: typing.Any = ...) -> typing.Any: ...
    def property(self, key: int) -> QgsProperty: ...
    def hasProperty(self, key: int) -> bool: ...
    def clear(self) -> None: ...
    def propertyKeys(self) -> typing.Any: ...
    def setName(self, name: str|None) -> None: ...
    def name(self) -> str: ...


class QgsPropertyCollection(QgsAbstractPropertyCollection):

    @typing.overload
    def __init__(self, name: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsPropertyCollection') -> None: ...

    @typing.overload
    def setProperty(self, key: int, property: QgsProperty) -> None: ...
    @typing.overload
    def setProperty(self, key: int, value: typing.Any) -> None: ...
    def loadVariant(self, configuration: typing.Any, definitions: dict[int, QgsPropertyDefinition]) -> bool: ...
    def toVariant(self, definitions: dict[int, QgsPropertyDefinition]) -> typing.Any: ...
    def hasDynamicProperties(self) -> bool: ...
    def hasActiveProperties(self) -> bool: ...
    def isActive(self, key: int) -> bool: ...
    def referencedFields(self, context: QgsExpressionContext = ..., ignoreContext: bool = ...) -> set[str]: ...
    def prepare(self, context: QgsExpressionContext = ...) -> bool: ...
    def value(self, key: int, context: QgsExpressionContext, defaultValue: typing.Any = ...) -> typing.Any: ...
    def property(self, key: int) -> QgsProperty: ...
    def hasProperty(self, key: int) -> bool: ...
    def clear(self) -> None: ...
    def propertyKeys(self) -> typing.Any: ...
    def count(self) -> int: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsPropertyCollectionStack(QgsAbstractPropertyCollection):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsPropertyCollectionStack') -> None: ...

    def loadVariant(self, collection: typing.Any, definitions: dict[int, QgsPropertyDefinition]) -> bool: ...
    def toVariant(self, definitions: dict[int, QgsPropertyDefinition]) -> typing.Any: ...
    def hasProperty(self, key: int) -> bool: ...
    def propertyKeys(self) -> typing.Any: ...
    def prepare(self, context: QgsExpressionContext = ...) -> bool: ...
    def referencedFields(self, context: QgsExpressionContext = ..., ignoreContext: bool = ...) -> set[str]: ...
    def value(self, key: int, context: QgsExpressionContext, defaultValue: typing.Any = ...) -> typing.Any: ...
    def property(self, key: int) -> QgsProperty: ...
    def isActive(self, key: int) -> bool: ...
    def hasDynamicProperties(self) -> bool: ...
    def hasActiveProperties(self) -> bool: ...
    def collection(self, name: str|None) -> QgsPropertyCollection|None: ...
    def at(self, index: int) -> QgsPropertyCollection|None: ...
    def appendCollection(self, collection: QgsPropertyCollection|None) -> None: ...
    def clear(self) -> None: ...
    def count(self) -> int: ...


class QgsCurveTransform(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, controlPoints: collections.abc.Iterable[QgsPointXY]) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsCurveTransform') -> None: ...

    def loadVariant(self, transformer: typing.Any) -> bool: ...
    def toVariant(self) -> typing.Any: ...
    def writeXml(self, transformElem: QtXml.QDomElement, doc: QtXml.QDomDocument) -> bool: ...
    def readXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument) -> bool: ...
    @typing.overload
    def y(self, x: float) -> float: ...
    @typing.overload
    def y(self, x: collections.abc.Iterable[float]) -> list[float]: ...
    def removeControlPoint(self, x: float, y: float) -> None: ...
    def addControlPoint(self, x: float, y: float) -> None: ...
    def setControlPoints(self, points: collections.abc.Iterable[QgsPointXY]) -> None: ...
    def controlPoints(self) -> list[QgsPointXY]: ...


class QgsPropertyTransformer(PyQt6.sip.wrapper):

    class Type(enum.IntEnum):
        GenericNumericTransformer = ... # type: QgsPropertyTransformer.Type
        SizeScaleTransformer = ... # type: QgsPropertyTransformer.Type
        ColorRampTransformer = ... # type: QgsPropertyTransformer.Type

    @typing.overload
    def __init__(self, minValue: float = ..., maxValue: float = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsPropertyTransformer') -> None: ...

    def transformNumeric(self, input: float) -> float: ...
    @staticmethod
    def fromExpression(expression: str|None) -> typing.Tuple['QgsPropertyTransformer|None', str, str]: ...
    def toExpression(self, baseExpression: str|None) -> str: ...
    def transform(self, context: QgsExpressionContext, value: typing.Any) -> typing.Any: ...
    def setCurveTransform(self, transform: QgsCurveTransform|None) -> None: ...
    def curveTransform(self) -> QgsCurveTransform|None: ...
    def setMaxValue(self, max: float) -> None: ...
    def maxValue(self) -> float: ...
    def setMinValue(self, min: float) -> None: ...
    def minValue(self) -> float: ...
    def toVariant(self) -> typing.Any: ...
    def loadVariant(self, transformer: typing.Any) -> bool: ...
    def clone(self) -> 'QgsPropertyTransformer|None': ...
    def transformerType(self) -> 'QgsPropertyTransformer.Type': ...
    @staticmethod
    def create(type: 'QgsPropertyTransformer.Type') -> 'QgsPropertyTransformer|None': ...


class QgsGenericNumericTransformer(QgsPropertyTransformer):

    @typing.overload
    def __init__(self, minValue: float = ..., maxValue: float = ..., minOutput: float = ..., maxOutput: float = ..., nullOutput: float = ..., exponent: float = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGenericNumericTransformer') -> None: ...

    def setExponent(self, exponent: float) -> None: ...
    def exponent(self) -> float: ...
    def setNullOutputValue(self, size: float) -> None: ...
    def nullOutputValue(self) -> float: ...
    def setMaxOutputValue(self, size: float) -> None: ...
    def maxOutputValue(self) -> float: ...
    def setMinOutputValue(self, size: float) -> None: ...
    def minOutputValue(self) -> float: ...
    def value(self, input: float) -> float: ...
    @staticmethod
    def fromExpression(expression: str|None) -> typing.Tuple['QgsGenericNumericTransformer|None', str, str]: ...
    def toExpression(self, baseExpression: str|None) -> str: ...
    def transform(self, context: QgsExpressionContext, value: typing.Any) -> typing.Any: ...
    def loadVariant(self, definition: typing.Any) -> bool: ...
    def toVariant(self) -> typing.Any: ...
    def clone(self) -> 'QgsGenericNumericTransformer|None': ...
    def transformerType(self) -> QgsPropertyTransformer.Type: ...


class QgsSizeScaleTransformer(QgsPropertyTransformer):

    class ScaleType(enum.IntEnum):
        Linear = ... # type: QgsSizeScaleTransformer.ScaleType
        Area = ... # type: QgsSizeScaleTransformer.ScaleType
        Flannery = ... # type: QgsSizeScaleTransformer.ScaleType
        Exponential = ... # type: QgsSizeScaleTransformer.ScaleType

    @typing.overload
    def __init__(self, type: 'QgsSizeScaleTransformer.ScaleType' = ..., minValue: float = ..., maxValue: float = ..., minSize: float = ..., maxSize: float = ..., nullSize: float = ..., exponent: float = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSizeScaleTransformer') -> None: ...

    def setType(self, type: 'QgsSizeScaleTransformer.ScaleType') -> None: ...
    def type(self) -> 'QgsSizeScaleTransformer.ScaleType': ...
    def setExponent(self, exponent: float) -> None: ...
    def exponent(self) -> float: ...
    def setNullSize(self, size: float) -> None: ...
    def nullSize(self) -> float: ...
    def setMaxSize(self, size: float) -> None: ...
    def maxSize(self) -> float: ...
    def setMinSize(self, size: float) -> None: ...
    def minSize(self) -> float: ...
    def size(self, value: float) -> float: ...
    @staticmethod
    def fromExpression(expression: str|None) -> typing.Tuple['QgsSizeScaleTransformer|None', str, str]: ...
    def toExpression(self, baseExpression: str|None) -> str: ...
    def transform(self, context: QgsExpressionContext, value: typing.Any) -> typing.Any: ...
    def loadVariant(self, definition: typing.Any) -> bool: ...
    def toVariant(self) -> typing.Any: ...
    def clone(self) -> 'QgsSizeScaleTransformer|None': ...
    def transformerType(self) -> QgsPropertyTransformer.Type: ...


class QgsColorRampTransformer(QgsPropertyTransformer):

    @typing.overload
    def __init__(self, minValue: float = ..., maxValue: float = ..., ramp: QgsColorRamp|None = ..., nullColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ..., rampName: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsColorRampTransformer') -> None: ...

    def setRampName(self, name: str|None) -> None: ...
    def rampName(self) -> str: ...
    def setNullColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def nullColor(self) -> QtGui.QColor: ...
    def setColorRamp(self, ramp: QgsColorRamp|None) -> None: ...
    def colorRamp(self) -> QgsColorRamp|None: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def toExpression(self, baseExpression: str|None) -> str: ...
    def transform(self, context: QgsExpressionContext, value: typing.Any) -> typing.Any: ...
    def loadVariant(self, definition: typing.Any) -> bool: ...
    def toVariant(self) -> typing.Any: ...
    def clone(self) -> 'QgsColorRampTransformer|None': ...
    def transformerType(self) -> QgsPropertyTransformer.Type: ...


class QgsProviderConnectionModel(QtCore.QAbstractItemModel):

    class CustomRole(enum.IntEnum):
        ConnectionName = ... # type: QgsProviderConnectionModel.CustomRole
        Uri = ... # type: QgsProviderConnectionModel.CustomRole
        Configuration = ... # type: QgsProviderConnectionModel.CustomRole
        Empty = ... # type: QgsProviderConnectionModel.CustomRole

    def __init__(self, provider: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    def index(self, row: int, column: int, parent: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def allowEmptyConnection(self) -> bool: ...
    def setAllowEmptyConnection(self, allowEmpty: bool) -> None: ...


class QgsProxyFeatureSink(QgsFeatureSink):

    @typing.overload
    def __init__(self, sink: QgsFeatureSink|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsProxyFeatureSink') -> None: ...

    def destinationSink(self) -> QgsFeatureSink|None: ...
    def finalize(self) -> None: ...
    def flushBuffer(self) -> bool: ...
    def lastError(self) -> str: ...
    @typing.overload
    def addFeatures(self, features: collections.abc.Iterable[QgsFeature], flags: QgsFeatureSink.Flag = ...) -> bool: ...
    @typing.overload
    def addFeatures(self, iterator: QgsFeatureIterator, flags: QgsFeatureSink.Flag = ...) -> bool: ...
    def addFeature(self, feature: QgsFeature, flags: QgsFeatureSink.Flag = ...) -> bool: ...


class QgsProxyProgressTask(QgsTask):

    def __init__(self, description: str|None, canCancel: bool = ...) -> None: ...

    canceled: typing.ClassVar[QtCore.pyqtSignal]
    def cancel(self) -> None: ...
    def setProxyProgress(self, progress: float) -> None: ...
    def run(self) -> bool: ...
    def finalize(self, result: bool) -> None: ...


class QgsScopedProxyProgressTask(PyQt6.sip.wrapper):

    def __init__(self, description: str|None) -> None: ...

    def setProgress(self, progress: float) -> None: ...


class QgsPythonRunner(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPythonRunner') -> None: ...

    def setArgvCommand(self, arguments: collections.abc.Iterable[str|None], messageOnError: str|None = ...) -> bool: ...
    def evalCommand(self, command: str|None, result: str|None) -> bool: ...
    def runFileCommand(self, filename: str|None, messageOnError: str|None = ...) -> bool: ...
    def runCommand(self, command: str|None, messageOnError: str|None = ...) -> bool: ...
    @staticmethod
    def setInstance(runner: 'QgsPythonRunner|None') -> None: ...
    @staticmethod
    def setArgv(arguments: collections.abc.Iterable[str|None], messageOnError: str|None = ...) -> bool: ...
    @staticmethod
    def eval(command: str|None) -> typing.Tuple[bool, str]: ...
    @staticmethod
    def runFile(filename: str|None, messageOnError: str|None = ...) -> bool: ...
    @staticmethod
    def run(command: str|None, messageOnError: str|None = ...) -> bool: ...
    @staticmethod
    def isValid() -> bool: ...


class QgsQueryResultModel(QtCore.QAbstractTableModel):

    def __init__(self, queryResult: 'QgsAbstractDatabaseProviderConnection.QueryResult', parent: QtCore.QObject|None = ...) -> None: ...

    fetchingStarted: typing.ClassVar[QtCore.pyqtSignal]
    fetchMoreRows: typing.ClassVar[QtCore.pyqtSignal]
    fetchingComplete: typing.ClassVar[QtCore.pyqtSignal]
    def cancel(self) -> None: ...
    def rowsReady(self, rows: typing.Any) -> None: ...
    def queryResult(self) -> 'QgsAbstractDatabaseProviderConnection.QueryResult': ...
    def columns(self) -> list[str]: ...
    def canFetchMore(self, parent: QtCore.QModelIndex) -> bool: ...
    def fetchMore(self, parent: QtCore.QModelIndex) -> None: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int) -> typing.Any: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex) -> int: ...


class QgsRangedoubleBase(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, lower: float, upper: float, includeLower: bool = ..., includeUpper: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, lower: float, upper: float, limits: Qgis.RangeLimits) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRangedoubleBase') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def overlaps(self, other: 'QgsRangedoubleBase') -> bool: ...
    @typing.overload
    def contains(self, other: 'QgsRangedoubleBase') -> bool: ...
    @typing.overload
    def contains(self, element: float) -> bool: ...
    def isSingleton(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def rangeLimits(self) -> Qgis.RangeLimits: ...
    def includeUpper(self) -> bool: ...
    def includeLower(self) -> bool: ...
    def upper(self) -> float: ...
    def lower(self) -> float: ...


class QgsDoubleRange(QgsRangedoubleBase):

    @typing.overload
    def __init__(self, lower: float, upper: float, limits: Qgis.RangeLimits) -> None: ...
    @typing.overload
    def __init__(self, lower: float, upper: float, includeLower: bool = ..., includeUpper: bool = ...) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDoubleRange') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def __repr__(self) -> typing.Any: ...
    def isInfinite(self) -> bool: ...


class QgsRangeintBase(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, lower: int, upper: int, includeLower: bool = ..., includeUpper: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, lower: int, upper: int, limits: Qgis.RangeLimits) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRangeintBase') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def overlaps(self, other: 'QgsRangeintBase') -> bool: ...
    @typing.overload
    def contains(self, other: 'QgsRangeintBase') -> bool: ...
    @typing.overload
    def contains(self, element: int) -> bool: ...
    def isSingleton(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def rangeLimits(self) -> Qgis.RangeLimits: ...
    def includeUpper(self) -> bool: ...
    def includeLower(self) -> bool: ...
    def upper(self) -> int: ...
    def lower(self) -> int: ...


class QgsIntRange(QgsRangeintBase):

    @typing.overload
    def __init__(self, lower: int, upper: int, limits: Qgis.RangeLimits) -> None: ...
    @typing.overload
    def __init__(self, lower: int, upper: int, includeLower: bool = ..., includeUpper: bool = ...) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsIntRange') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def isInfinite(self) -> bool: ...


class QgsDateRange(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, begin: QtCore.QDate|datetime.date, end: QtCore.QDate|datetime.date, includeBeginning: bool = ..., includeEnd: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDateRange') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def extend(self, other: 'QgsDateRange') -> bool: ...
    def overlaps(self, other: 'QgsDateRange') -> bool: ...
    @typing.overload
    def contains(self, other: 'QgsDateRange') -> bool: ...
    @typing.overload
    def contains(self, element: QtCore.QDate|datetime.date) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isInfinite(self) -> bool: ...
    def isInstant(self) -> bool: ...
    def includeEnd(self) -> bool: ...
    def includeBeginning(self) -> bool: ...
    def end(self) -> QtCore.QDate: ...
    def begin(self) -> QtCore.QDate: ...


class QgsDateTimeRange(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, begin: QtCore.QDateTime|datetime.datetime, end: QtCore.QDateTime|datetime.datetime, includeBeginning: bool = ..., includeEnd: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDateTimeRange') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def extend(self, other: 'QgsDateTimeRange') -> bool: ...
    def overlaps(self, other: 'QgsDateTimeRange') -> bool: ...
    @typing.overload
    def contains(self, other: 'QgsDateTimeRange') -> bool: ...
    @typing.overload
    def contains(self, element: QtCore.QDateTime|datetime.datetime) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isInfinite(self) -> bool: ...
    def isInstant(self) -> bool: ...
    def includeEnd(self) -> bool: ...
    def includeBeginning(self) -> bool: ...
    def end(self) -> QtCore.QDateTime: ...
    def begin(self) -> QtCore.QDateTime: ...


class QgsReadWriteContext(PyQt6.sip.wrapper):

    class ReadWriteMessage(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self, message: str|None = ..., level: Qgis.MessageLevel = ..., categories: collections.abc.Iterable[str|None] = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsReadWriteContext.ReadWriteMessage') -> None: ...

        def __repr__(self) -> typing.Any: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def categories(self) -> list[str]: ...
        def level(self) -> Qgis.MessageLevel: ...
        def message(self) -> str: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsReadWriteContext') -> None: ...

    def setCurrentLayerId(self, layerId: str|None) -> None: ...
    def currentLayerId(self) -> str: ...
    def setTransformContext(self, transformContext: 'QgsCoordinateTransformContext') -> None: ...
    def transformContext(self) -> 'QgsCoordinateTransformContext': ...
    def setProjectTranslator(self, projectTranslator: 'QgsProjectTranslator|None') -> None: ...
    def projectTranslator(self) -> 'QgsProjectTranslator|None': ...
    def takeMessages(self) -> list['QgsReadWriteContext.ReadWriteMessage']: ...
    def _enterCategory(self, category: str|None, details: str|None = ...) -> 'QgsReadWriteContextCategoryPopper': ...
    def pushMessage(self, message: str|None, level: Qgis.MessageLevel = ...) -> None: ...
    def setPathResolver(self, resolver: QgsPathResolver) -> None: ...
    def pathResolver(self) -> QgsPathResolver: ...


class QgsReadWriteContextCategoryPopper(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, context: QgsReadWriteContext) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsReadWriteContextCategoryPopper') -> None: ...


class QgsReadWriteLocker(PyQt6.sip.wrapper):

    class Mode(enum.IntEnum):
        Read = ... # type: QgsReadWriteLocker.Mode
        Write = ... # type: QgsReadWriteLocker.Mode
        Unlocked = ... # type: QgsReadWriteLocker.Mode

    @typing.overload
    def __init__(self, lock: QtCore.QReadWriteLock, mode: 'QgsReadWriteLocker.Mode') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsReadWriteLocker') -> None: ...

    def unlock(self) -> None: ...
    def changeMode(self, mode: 'QgsReadWriteLocker.Mode') -> None: ...


class QgsRecentStyleHandler(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def recentSymbol(self, identifier: str|None) -> 'QgsSymbol|None': ...
    def pushRecentSymbol(self, identifier: str|None, symbol: 'QgsSymbol|None') -> None: ...


class QgsRelation(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, context: 'QgsRelationContext') -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsRelation') -> None: ...

    @staticmethod
    def strengthToDisplayString(strength: Qgis.RelationshipStrength) -> str: ...
    @staticmethod
    def cardinalityToDisplayString(cardinality: Qgis.RelationshipCardinality) -> str: ...
    def type(self) -> Qgis.RelationshipType: ...
    def polymorphicRelation(self) -> 'QgsPolymorphicRelation': ...
    def polymorphicRelationId(self) -> str: ...
    def setPolymorphicRelationId(self, polymorphicRelationId: str|None) -> None: ...
    def updateRelationStatus(self) -> None: ...
    def resolveReferencingField(self, referencedField: str|None) -> str: ...
    def resolveReferencedField(self, referencingField: str|None) -> str: ...
    def hasEqualDefinition(self, other: 'QgsRelation') -> bool: ...
    def validationError(self) -> str: ...
    def isValid(self) -> bool: ...
    def referencingFieldsAllowNull(self) -> bool: ...
    def referencingFields(self) -> list[int]: ...
    def referencedFields(self) -> list[int]: ...
    def fieldPairs(self) -> dict[str, str]: ...
    def referencedLayer(self) -> QgsVectorLayer|None: ...
    def referencedLayerId(self) -> str: ...
    def referencingLayer(self) -> QgsVectorLayer|None: ...
    def referencingLayerId(self) -> str: ...
    def generateId(self) -> None: ...
    def id(self) -> str: ...
    def strength(self) -> Qgis.RelationshipStrength: ...
    def name(self) -> str: ...
    def getReferencedFeature(self, feature: QgsFeature) -> QgsFeature: ...
    @typing.overload
    def getReferencedFeatureRequest(self, attributes: typing.Any) -> QgsFeatureRequest: ...
    @typing.overload
    def getReferencedFeatureRequest(self, feature: QgsFeature) -> QgsFeatureRequest: ...
    def getRelatedFeaturesFilter(self, feature: QgsFeature) -> str: ...
    def getRelatedFeaturesRequest(self, feature: QgsFeature) -> QgsFeatureRequest: ...
    def getRelatedFeatures(self, feature: QgsFeature) -> QgsFeatureIterator: ...
    def addFieldPair(self, referencingField: str|None, referencedField: str|None) -> None: ...
    def setReferencedLayer(self, id: str|None) -> None: ...
    def setReferencingLayer(self, id: str|None) -> None: ...
    def setStrength(self, strength: Qgis.RelationshipStrength) -> None: ...
    def setName(self, name: str|None) -> None: ...
    def setId(self, id: str|None) -> None: ...
    def writeXml(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    @staticmethod
    def createFromXml(node: QtXml.QDomNode, context: QgsReadWriteContext, relationContext: 'QgsRelationContext' = ...) -> 'QgsRelation': ...


class QgsPolymorphicRelation(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, context: 'QgsRelationContext') -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsPolymorphicRelation') -> None: ...

    def setRelationStrength(self, relationStrength: Qgis.RelationshipStrength) -> None: ...
    def strength(self) -> Qgis.RelationshipStrength: ...
    def layerRepresentation(self, layer: QgsVectorLayer|None) -> str: ...
    def generateRelations(self) -> list[QgsRelation]: ...
    def referencedLayerIds(self) -> list[str]: ...
    def setReferencedLayerIds(self, childRelationIds: collections.abc.Iterable[str|None]) -> None: ...
    def referencedLayerExpression(self) -> str: ...
    def setReferencedLayerExpression(self, expression: str|None) -> None: ...
    def referencedLayerField(self) -> str: ...
    def setReferencedLayerField(self, referencedLayerField: str|None) -> None: ...
    def updateRelationStatus(self) -> None: ...
    def hasEqualDefinition(self, other: 'QgsPolymorphicRelation') -> bool: ...
    def isValid(self) -> bool: ...
    def referencingFields(self) -> list[int]: ...
    def referencedFields(self, layerId: str|None) -> list[int]: ...
    def fieldPairs(self) -> dict[str, str]: ...
    def referencingLayer(self) -> QgsVectorLayer|None: ...
    def referencingLayerId(self) -> str: ...
    def generateId(self) -> None: ...
    def id(self) -> str: ...
    def name(self) -> str: ...
    def addFieldPair(self, referencingField: str|None, referencedField: str|None) -> None: ...
    def setReferencingLayer(self, id: str|None) -> None: ...
    def setName(self, name: str|None) -> None: ...
    def setId(self, id: str|None) -> None: ...
    def writeXml(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    @staticmethod
    def createFromXml(node: QtXml.QDomNode, context: QgsReadWriteContext, relationContext: 'QgsRelationContext' = ...) -> 'QgsPolymorphicRelation': ...


class QgsRelationContext(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, project: 'QgsProject|None' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRelationContext') -> None: ...

    def project(self) -> 'QgsProject|None': ...


class QgsRemappingSinkDefinition(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRemappingSinkDefinition') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def loadVariant(self, map: dict[str|None, typing.Any]) -> bool: ...
    def toVariant(self) -> typing.Any: ...
    def setDestinationFields(self, fields: QgsFields) -> None: ...
    def destinationFields(self) -> QgsFields: ...
    def setDestinationWkbType(self, type: Qgis.WkbType) -> None: ...
    def destinationWkbType(self) -> Qgis.WkbType: ...
    def setDestinationCrs(self, destination: 'QgsCoordinateReferenceSystem') -> None: ...
    def destinationCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def setSourceCrs(self, source: 'QgsCoordinateReferenceSystem') -> None: ...
    def sourceCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def addMappedField(self, destinationField: str|None, property: QgsProperty) -> None: ...
    def setFieldMap(self, map: dict[str|None, QgsProperty]) -> None: ...
    def fieldMap(self) -> dict[str, QgsProperty]: ...


class QgsRemappingProxyFeatureSink(QgsFeatureSink):

    @typing.overload
    def __init__(self, mappingDefinition: QgsRemappingSinkDefinition, sink: QgsFeatureSink|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRemappingProxyFeatureSink') -> None: ...

    def destinationSink(self) -> QgsFeatureSink|None: ...
    def lastError(self) -> str: ...
    @typing.overload
    def addFeatures(self, features: collections.abc.Iterable[QgsFeature], flags: QgsFeatureSink.Flag = ...) -> bool: ...
    @typing.overload
    def addFeatures(self, iterator: QgsFeatureIterator, flags: QgsFeatureSink.Flag = ...) -> bool: ...
    def addFeature(self, feature: QgsFeature, flags: QgsFeatureSink.Flag = ...) -> bool: ...
    def remapFeature(self, feature: QgsFeature) -> list[QgsFeature]: ...
    def setTransformContext(self, context: 'QgsCoordinateTransformContext') -> None: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> None: ...


class QgsWeakRelation(PyQt6.sip.wrapper):

    class WeakRelationType(enum.IntEnum):
        Referencing = ... # type: QgsWeakRelation.WeakRelationType
        Referenced = ... # type: QgsWeakRelation.WeakRelationType

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, relationId: str|None, relationName: str|None, strength: Qgis.RelationshipStrength, referencingLayerId: str|None, referencingLayerName: str|None, referencingLayerSource: str|None, referencingLayerProviderKey: str|None, referencedLayerId: str|None, referencedLayerName: str|None, referencedLayerSource: str|None, referencedLayerProviderKey: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsWeakRelation') -> None: ...

    def __repr__(self) -> typing.Any: ...
    @staticmethod
    def writeXml(layer: QgsVectorLayer|None, type: 'QgsWeakRelation.WeakRelationType', relation: QgsRelation, node: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    @staticmethod
    def readXml(layer: QgsVectorLayer|None, type: 'QgsWeakRelation.WeakRelationType', node: QtXml.QDomNode, resolver: QgsPathResolver) -> 'QgsWeakRelation': ...
    def setRelatedTableType(self, type: str|None) -> None: ...
    def relatedTableType(self) -> str: ...
    def setBackwardPathLabel(self, label: str|None) -> None: ...
    def setForwardPathLabel(self, label: str|None) -> None: ...
    def backwardPathLabel(self) -> str: ...
    def forwardPathLabel(self) -> str: ...
    def setCardinality(self, cardinality: Qgis.RelationshipCardinality) -> None: ...
    def cardinality(self) -> Qgis.RelationshipCardinality: ...
    def strength(self) -> Qgis.RelationshipStrength: ...
    def setMappingReferencedLayerFields(self, fields: collections.abc.Iterable[str|None]) -> None: ...
    def mappingReferencedLayerFields(self) -> list[str]: ...
    def setReferencedLayerFields(self, fields: collections.abc.Iterable[str|None]) -> None: ...
    def referencedLayerFields(self) -> list[str]: ...
    def setMappingReferencingLayerFields(self, fields: collections.abc.Iterable[str|None]) -> None: ...
    def mappingReferencingLayerFields(self) -> list[str]: ...
    def setReferencingLayerFields(self, fields: collections.abc.Iterable[str|None]) -> None: ...
    def referencingLayerFields(self) -> list[str]: ...
    def setMappingTable(self, sourceUri: str|None, provider: str|None) -> None: ...
    def mappingTableName(self) -> str: ...
    def mappingTableProvider(self) -> str: ...
    def mappingTableSource(self) -> str: ...
    def setReferencedLayer(self, sourceUri: str|None, provider: str|None) -> None: ...
    def referencedLayerName(self) -> str: ...
    def referencedLayerProvider(self) -> str: ...
    def referencedLayerSource(self) -> str: ...
    def setReferencingLayer(self, sourceUri: str|None, provider: str|None) -> None: ...
    def referencingLayerName(self) -> str: ...
    def referencingLayerProvider(self) -> str: ...
    def referencingLayerSource(self) -> str: ...
    def name(self) -> str: ...
    def id(self) -> str: ...
    def resolvedRelations(self, project: 'QgsProject|None') -> list[QgsRelation]: ...


class QgsRelationManager(QtCore.QObject):

    def __init__(self, project: 'QgsProject|None' = ...) -> None: ...

    def updateRelationsStatus(self) -> None: ...
    changed: typing.ClassVar[QtCore.pyqtSignal]
    relationsLoaded: typing.ClassVar[QtCore.pyqtSignal]
    def setPolymorphicRelations(self, relations: collections.abc.Iterable[QgsPolymorphicRelation]) -> None: ...
    def removePolymorphicRelation(self, polymorphicRelationId: str|None) -> None: ...
    def addPolymorphicRelation(self, polymorphicRelation: QgsPolymorphicRelation) -> None: ...
    def polymorphicRelation(self, polymorphicRelationId: str|None) -> QgsPolymorphicRelation: ...
    def polymorphicRelations(self) -> dict[str, QgsPolymorphicRelation]: ...
    @staticmethod
    def discoverRelations(existingRelations: collections.abc.Iterable[QgsRelation], layers: collections.abc.Iterable[QgsVectorLayer]) -> list[QgsRelation]: ...
    def referencedRelations(self, layer: QgsVectorLayer|None = ...) -> list[QgsRelation]: ...
    def referencingRelations(self, layer: QgsVectorLayer|None = ..., fieldIdx: int = ...) -> list[QgsRelation]: ...
    def clear(self) -> None: ...
    def relationsByName(self, name: str|None) -> list[QgsRelation]: ...
    def relation(self, id: str|None) -> QgsRelation: ...
    @typing.overload
    def removeRelation(self, id: str|None) -> None: ...
    @typing.overload
    def removeRelation(self, relation: QgsRelation) -> None: ...
    def addRelation(self, relation: QgsRelation) -> None: ...
    def relations(self) -> dict[str, QgsRelation]: ...
    def setRelations(self, relations: collections.abc.Iterable[QgsRelation]) -> None: ...
    def context(self) -> QgsRelationContext: ...


class QgsRenderChecker(PyQt6.sip.wrapper):

    class Flag(enum.IntFlag):
        AvoidExportingRenderedImage = ... # type: QgsRenderChecker.Flag
        Silent = ... # type: QgsRenderChecker.Flag

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRenderChecker') -> None: ...

    @staticmethod
    def sourcePath() -> str: ...
    def dartMeasurements(self) -> list[QgsDartMeasurement]: ...
    def enableDashBuffering(self, enable: bool) -> None: ...
    def expectedImageFile(self) -> str: ...
    @staticmethod
    def drawBackground(image: QtGui.QImage|None) -> None: ...
    @deprecated("""""")
    def isKnownAnomaly(self, diffImageFile: str|None) -> bool: ...
    @typing.overload
    def compareImages(self, testName: str|None, mismatchCount: int = ..., renderedImageFile: str|None = ..., flags: 'QgsRenderChecker.Flag' = ...) -> bool: ...
    @typing.overload
    def compareImages(self, testName: str|None, referenceImageFile: str|None, renderedImageFile: str|None, mismatchCount: int = ..., flags: 'QgsRenderChecker.Flag' = ...) -> bool: ...
    def runTest(self, testName: str|None, mismatchCount: int = ..., flags: 'QgsRenderChecker.Flag' = ...) -> bool: ...
    def setSizeTolerance(self, xTolerance: int, yTolerance: int) -> None: ...
    def setColorTolerance(self, colorTolerance: int) -> None: ...
    def setMapSettings(self, mapSettings: QgsMapSettings) -> None: ...
    def renderedImage(self) -> str: ...
    def setExpectFail(self, expectFail: bool) -> None: ...
    def setRenderedImage(self, imageFileName: str|None) -> None: ...
    def imageToHash(self, imageFile: str|None) -> str: ...
    def setControlPathSuffix(self, name: str|None) -> None: ...
    def setControlPathPrefix(self, name: str|None) -> None: ...
    def setControlExtension(self, extension: str|None) -> None: ...
    def setControlName(self, name: str|None) -> None: ...
    def setElapsedTimeTarget(self, target: int) -> None: ...
    def elapsedTime(self) -> int: ...
    def matchTarget(self) -> int: ...
    def mismatchCount(self) -> int: ...
    def matchPercent(self) -> float: ...
    def markdownReport(self, ignoreSuccess: bool = ...) -> str: ...
    def report(self, ignoreSuccess: bool = ...) -> str: ...
    def setControlImagePath(self, path: str|None) -> None: ...
    def controlImagePath(self) -> str: ...
    @staticmethod
    def shouldGenerateReport() -> bool: ...
    @staticmethod
    def testReportDir() -> QtCore.QDir: ...


class QgsRenderContext(QgsTemporalRangeObject):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, rh: 'QgsRenderContext') -> None: ...

    def setElevationMap(self, map: QgsElevationMap|None) -> None: ...
    def elevationMap(self) -> QgsElevationMap|None: ...
    def setCurrentFrame(self, frame: int) -> None: ...
    def currentFrame(self) -> int: ...
    def setFrameRate(self, rate: float) -> None: ...
    def frameRate(self) -> float: ...
    def setRendererUsage(self, usage: Qgis.RendererUsage) -> None: ...
    def rendererUsage(self) -> Qgis.RendererUsage: ...
    def setRasterizedRenderingPolicy(self, policy: Qgis.RasterizedRenderingPolicy) -> None: ...
    def rasterizedRenderingPolicy(self) -> Qgis.RasterizedRenderingPolicy: ...
    def imageFormat(self) -> QtGui.QImage.Format: ...
    def setImageFormat(self, format: QtGui.QImage.Format) -> None: ...
    def deviceOutputSize(self) -> QtCore.QSize: ...
    def setDevicePixelRatio(self, ratio: float) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def setOutputSize(self, size: QtCore.QSize) -> None: ...
    def outputSize(self) -> QtCore.QSize: ...
    def setZRange(self, range: QgsDoubleRange) -> None: ...
    def zRange(self) -> QgsDoubleRange: ...
    def symbolLayerClipGeometries(self, symbolLayerId: str|None) -> list['QgsGeometry']: ...
    def symbolLayerHasClipGeometries(self, symbolLayerId: str|None) -> bool: ...
    def addSymbolLayerClipGeometry(self, symbolLayerId: str|None, geometry: 'QgsGeometry') -> None: ...
    @deprecated("""""")
    def symbolLayerClipPaths(self, symbolLayerId: str|None) -> list[QtGui.QPainterPath]: ...
    @deprecated("""""")
    def addSymbolLayerClipPath(self, symbolLayerId: str|None, path: QtGui.QPainterPath) -> None: ...
    def setMaskSettings(self, settings: QgsMaskRenderSettings) -> None: ...
    def maskSettings(self) -> QgsMaskRenderSettings: ...
    def setTextureOrigin(self, origin: QtCore.QPointF) -> None: ...
    def textureOrigin(self) -> QtCore.QPointF: ...
    def setFeatureClipGeometry(self, geometry: 'QgsGeometry') -> None: ...
    def featureClipGeometry(self) -> 'QgsGeometry': ...
    def clippingRegions(self) -> list[QgsMapClippingRegion]: ...
    def clearCustomProperty(self, property: str|None) -> None: ...
    @deprecated("""""")
    def clearCustomRenderingFlag(self, flag: str|None) -> None: ...
    def setCustomProperty(self, property: str|None, value: typing.Any) -> None: ...
    @deprecated("""""")
    def setCustomRenderingFlag(self, flag: str|None, value: typing.Any) -> None: ...
    def customProperties(self) -> dict[str, typing.Any]: ...
    @deprecated("""""")
    def customRenderingFlags(self) -> dict[str, typing.Any]: ...
    def isGuiPreview(self) -> bool: ...
    def setIsGuiPreview(self, preview: bool) -> None: ...
    def currentMaskId(self) -> int: ...
    def setCurrentMaskId(self, id: int) -> None: ...
    def maskIdProvider(self) -> QgsMaskIdProvider|None: ...
    def setMaskIdProvider(self, provider: QgsMaskIdProvider|None) -> None: ...
    def hasRenderedFeatureHandlers(self) -> bool: ...
    def renderedFeatureHandlers(self) -> list['QgsRenderedFeatureHandlerInterface']: ...
    def setTextRenderFormat(self, format: Qgis.TextRenderFormat) -> None: ...
    def textRenderFormat(self) -> Qgis.TextRenderFormat: ...
    def convertMetersToMapUnits(self, meters: float) -> float: ...
    def convertFromMapUnits(self, sizeInMapUnits: float, outputUnit: Qgis.RenderUnit) -> float: ...
    def convertToMapUnits(self, size: float, unit: Qgis.RenderUnit, scale: QgsMapUnitScale = ...) -> float: ...
    def convertFromPainterUnits(self, size: float, unit: Qgis.RenderUnit) -> float: ...
    def convertToPainterUnits(self, size: float, unit: Qgis.RenderUnit, scale: QgsMapUnitScale = ..., property: Qgis.RenderSubcomponentProperty = ...) -> float: ...
    def segmentationToleranceType(self) -> 'QgsAbstractGeometry.SegmentationToleranceType': ...
    def setSegmentationToleranceType(self, type: 'QgsAbstractGeometry.SegmentationToleranceType') -> None: ...
    def segmentationTolerance(self) -> float: ...
    def setSegmentationTolerance(self, tolerance: float) -> None: ...
    def featureFilterProvider(self) -> QgsFeatureFilterProvider|None: ...
    def setFeatureFilterProvider(self, ffp: QgsFeatureFilterProvider|None) -> None: ...
    def setGeometry(self, geometry: 'QgsAbstractGeometry|None') -> None: ...
    def geometry(self) -> 'QgsAbstractGeometry|None': ...
    def expressionContext(self) -> QgsExpressionContext: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> None: ...
    def setVectorSimplifyMethod(self, simplifyMethod: 'QgsVectorSimplifyMethod') -> None: ...
    def vectorSimplifyMethod(self) -> 'QgsVectorSimplifyMethod': ...
    def setUseRenderingOptimization(self, enabled: bool) -> None: ...
    def useRenderingOptimization(self) -> bool: ...
    def setShowSelection(self, showSelection: bool) -> None: ...
    def setSelectionColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    @deprecated("""""")
    def setForceVectorOutput(self, force: bool) -> None: ...
    def setMaskPainter(self, p: QtGui.QPainter|None, id: int = ...) -> None: ...
    def setPreviewRenderPainter(self, painter: QtGui.QPainter|None) -> None: ...
    def setPainter(self, p: QtGui.QPainter|None) -> None: ...
    def setSymbologyReferenceScale(self, scale: float) -> None: ...
    def setRendererScale(self, scale: float) -> None: ...
    def setDpiTarget(self, dpi: float) -> None: ...
    def setScaleFactor(self, factor: float) -> None: ...
    def setDistanceArea(self, distanceArea: QgsDistanceArea) -> None: ...
    def setRenderingStopped(self, stopped: bool) -> None: ...
    def setDrawEditingInformation(self, b: bool) -> None: ...
    def setMapExtent(self, extent: 'QgsRectangle') -> None: ...
    def setExtent(self, extent: 'QgsRectangle') -> None: ...
    def setMapToPixel(self, mtp: QgsMapToPixel) -> None: ...
    def setCoordinateTransform(self, t: 'QgsCoordinateTransform') -> None: ...
    def showSelection(self) -> bool: ...
    def selectionColor(self) -> QtGui.QColor: ...
    def symbologyReferenceScale(self) -> float: ...
    def rendererScale(self) -> float: ...
    def drawEditingInformation(self) -> bool: ...
    @deprecated("""""")
    def setUseAdvancedEffects(self, enabled: bool) -> None: ...
    @deprecated("""""")
    def useAdvancedEffects(self) -> bool: ...
    @deprecated("""""")
    def forceVectorOutput(self) -> bool: ...
    def feedback(self) -> QgsFeedback|None: ...
    def setFeedback(self, feedback: QgsFeedback|None) -> None: ...
    def renderingStopped(self) -> bool: ...
    def dpiTarget(self) -> float: ...
    def scaleFactor(self) -> float: ...
    def mapToPixel(self) -> QgsMapToPixel: ...
    def mapExtent(self) -> 'QgsRectangle': ...
    def extent(self) -> 'QgsRectangle': ...
    def setPathResolver(self, resolver: QgsPathResolver) -> None: ...
    def pathResolver(self) -> QgsPathResolver: ...
    def setTransformContext(self, context: 'QgsCoordinateTransformContext') -> None: ...
    def transformContext(self) -> 'QgsCoordinateTransformContext': ...
    def distanceArea(self) -> QgsDistanceArea: ...
    def coordinateTransform(self) -> 'QgsCoordinateTransform': ...
    def isSymbolLayerEnabled(self, layer: 'QgsSymbolLayer|None') -> bool: ...
    def disabledSymbolLayersV2(self) -> set[str]: ...
    @deprecated("""""")
    def disabledSymbolLayers(self) -> set['QgsSymbolLayer']: ...
    def setDisabledSymbolLayersV2(self, symbolLayers: collections.abc.Iterable[str|None]) -> None: ...
    @deprecated("""""")
    def setDisabledSymbolLayers(self, symbolLayers: collections.abc.Iterable['QgsSymbolLayer']) -> None: ...
    def maskPainter(self, id: int = ...) -> QtGui.QPainter|None: ...
    def setPainterFlagsUsingContext(self, painter: QtGui.QPainter|None = ...) -> None: ...
    def previewRenderPainter(self) -> QtGui.QPainter|None: ...
    def painter(self) -> QtGui.QPainter|None: ...
    @staticmethod
    def fromQPainter(painter: QtGui.QPainter|None) -> 'QgsRenderContext': ...
    @staticmethod
    def fromMapSettings(mapSettings: QgsMapSettings) -> 'QgsRenderContext': ...
    def testFlag(self, flag: Qgis.RenderContextFlag) -> bool: ...
    def flags(self) -> Qgis.RenderContextFlag: ...
    def setFlag(self, flag: Qgis.RenderContextFlag, on: bool = ...) -> None: ...
    def setFlags(self, flags: Qgis.RenderContextFlag) -> None: ...


class QgsRenderedFeatureHandlerInterface(PyQt6.sip.wrapper):

    class RenderedFeatureContext(PyQt6.sip.wrapper):

        renderContext = ... # type: QgsRenderContext

        @typing.overload
        def __init__(self, renderContext: QgsRenderContext) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsRenderedFeatureHandlerInterface.RenderedFeatureContext') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRenderedFeatureHandlerInterface') -> None: ...

    def usedAttributes(self, layer: QgsVectorLayer|None, context: QgsRenderContext) -> set[str]: ...
    def handleRenderedFeature(self, feature: QgsFeature, renderedBounds: 'QgsGeometry', context: 'QgsRenderedFeatureHandlerInterface.RenderedFeatureContext') -> None: ...


class QgsRenderedItemDetails(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, layerId: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRenderedItemDetails') -> None: ...

    def setBoundingBox(self, bounds: 'QgsRectangle') -> None: ...
    def boundingBox(self) -> 'QgsRectangle': ...
    def layerId(self) -> str: ...


class QgsRenderedLayerStatistics(QgsRenderedItemDetails):

    @typing.overload
    def __init__(self, layerId: str|None, minimum: collections.abc.Iterable[float], maximum: collections.abc.Iterable[float]) -> None: ...
    @typing.overload
    def __init__(self, layerId: str|None, minimum: float|None = ..., maximum: float|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRenderedLayerStatistics') -> None: ...

    @typing.overload
    def setMaximum(self, maximum: collections.abc.Iterable[float]) -> None: ...
    @typing.overload
    def setMaximum(self, index: int, maximum: float) -> bool: ...
    @typing.overload
    def setMinimum(self, minimum: collections.abc.Iterable[float]) -> None: ...
    @typing.overload
    def setMinimum(self, index: int, minimum: float) -> bool: ...
    @typing.overload
    def maximum(self) -> list[float]: ...
    @typing.overload
    def maximum(self, index: int) -> float: ...
    @typing.overload
    def minimum(self) -> list[float]: ...
    @typing.overload
    def minimum(self, index: int) -> float: ...
    def __repr__(self) -> typing.Any: ...


class QgsRunProcess(QtCore.QObject):

    def dialogGone(self) -> None: ...
    def processExit(self, a0: int, a1: QtCore.QProcess.ExitStatus) -> None: ...
    def processError(self, a0: QtCore.QProcess.ProcessError) -> None: ...
    def stderrAvailable(self) -> None: ...
    def stdoutAvailable(self) -> None: ...
    @staticmethod
    def splitCommand(command: str|None) -> list[str]: ...
    @staticmethod
    def create(action: str|None, capture: bool) -> 'QgsRunProcess|None': ...


class QgsBlockingProcess(QtCore.QObject):

    def __init__(self, program: str|None, arguments: collections.abc.Iterable[str|None]) -> None: ...

    def processError(self) -> QtCore.QProcess.ProcessError: ...
    def exitStatus(self) -> QtCore.QProcess.ExitStatus: ...
    def run(self, feedback: QgsFeedback|None = ...) -> int: ...
    def setStdErrHandler(self, a0: typing.Callable[..., None]) -> None: ...
    def setStdOutHandler(self, a0: typing.Callable[..., None]) -> None: ...


class QgsRuntimeProfiler(QtCore.QAbstractItemModel):

    def __init__(self) -> None: ...

    def groupAdded(self, group: str|None) -> None: ...
    def asText(self, group: str|None = ...) -> str: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    @staticmethod
    def translateGroupName(group: str|None) -> str: ...
    def groupIsActive(self, group: str|None) -> bool: ...
    def groups(self) -> set[str]: ...
    def totalTime(self, group: str|None = ...) -> float: ...
    def clear(self, group: str|None = ...) -> None: ...
    def profileTime(self, name: str|None, group: str|None = ...) -> float: ...
    def record(self, name: str|None, time: float, group: str|None = ..., id: str|None = ...) -> None: ...
    def end(self, group: str|None = ...) -> None: ...
    def start(self, name: str|None, group: str|None = ..., id: str|None = ...) -> None: ...
    def childGroups(self, parent: str|None = ..., group: str|None = ...) -> list[str]: ...
    @deprecated("""""")
    def endGroup(self) -> None: ...
    @deprecated("""""")
    def beginGroup(self, name: str|None) -> None: ...


class QgsScopedRuntimeProfile(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, name: str|None, group: str|None = ..., id: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsScopedRuntimeProfile') -> None: ...

    def switchTask(self, name: str|None) -> None: ...


class QgsScaleCalculator(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, dpi: float = ..., mapUnits: Qgis.DistanceUnit = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsScaleCalculator') -> None: ...

    def calculateGeographicDistanceAtLatitude(self, latitude: float, longitude1: float, longitude2: float) -> float: ...
    def calculateGeographicDistance(self, mapExtent: 'QgsRectangle') -> float: ...
    def calculateImageSize(self, mapExtent: 'QgsRectangle', scale: float) -> QtCore.QSizeF: ...
    def calculate(self, mapExtent: 'QgsRectangle', canvasWidth: float) -> float: ...
    def mapUnits(self) -> Qgis.DistanceUnit: ...
    def setMapUnits(self, mapUnits: Qgis.DistanceUnit) -> None: ...
    def dpi(self) -> float: ...
    def setDpi(self, dpi: float) -> None: ...
    def setMethod(self, method: Qgis.ScaleCalculationMethod) -> None: ...
    def method(self) -> Qgis.ScaleCalculationMethod: ...


class QgsScaleUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsScaleUtils') -> None: ...

    @staticmethod
    def lessThanMaximumScale(scale: float, maxScale: float) -> bool: ...
    @staticmethod
    def equalToOrGreaterThanMinimumScale(scale: float, minScale: float) -> bool: ...
    @staticmethod
    def loadScaleList(fileName: str|None, scales: collections.abc.Iterable[str|None], errorMessage: str|None) -> bool: ...
    @staticmethod
    def saveScaleList(fileName: str|None, scales: collections.abc.Iterable[str|None], errorMessage: str|None) -> bool: ...


class QgsScreenProperties(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, screen: QtGui.QScreen|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsScreenProperties') -> None: ...

    def updateRenderContextForScreen(self, context: QgsRenderContext) -> None: ...
    def setPhysicalDpi(self, dpi: float) -> None: ...
    def physicalDpi(self) -> float: ...
    def setDevicePixelRatio(self, ratio: float) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def isValid(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsSelectionContext(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSelectionContext') -> None: ...

    def setScale(self, scale: float) -> None: ...
    def scale(self) -> float: ...


class QgsSimplifyMethod(PyQt6.sip.wrapper):

    class MethodType(enum.IntEnum):
        NoSimplification = ... # type: QgsSimplifyMethod.MethodType
        OptimizeForRendering = ... # type: QgsSimplifyMethod.MethodType
        PreserveTopology = ... # type: QgsSimplifyMethod.MethodType

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSimplifyMethod') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    @staticmethod
    def createGeometrySimplifier(simplifyMethod: 'QgsSimplifyMethod') -> QgsAbstractGeometrySimplifier|None: ...
    def forceLocalOptimization(self) -> bool: ...
    def setForceLocalOptimization(self, localOptimization: bool) -> None: ...
    def threshold(self) -> float: ...
    def setThreshold(self, threshold: float) -> None: ...
    def tolerance(self) -> float: ...
    def setTolerance(self, tolerance: float) -> None: ...
    def methodType(self) -> 'QgsSimplifyMethod.MethodType': ...
    def setMethodType(self, methodType: 'QgsSimplifyMethod.MethodType') -> None: ...


class QgsSingleItemModel(QtCore.QAbstractItemModel):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ..., text: str|None = ..., data: dict[int, typing.Any] = ..., flags: QtCore.Qt.ItemFlag = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject|None, columnData: typing.Any, flags: QtCore.Qt.ItemFlag = ...) -> None: ...

    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlag: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...


class QgsSipUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSipUtils') -> None: ...

    @staticmethod
    def isPyOwned(a0: typing.Any) -> bool: ...


class QgsSldExportContext(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsSldExportContext') -> None: ...
    @typing.overload
    def __init__(self, options: Qgis.SldExportOption, vendorExtension: Qgis.SldExportVendorExtension, filePath: str|None) -> None: ...

    def setExtraProperties(self, properties: dict[str|None, typing.Any]) -> None: ...
    def extraProperties(self) -> dict[str, typing.Any]: ...
    def pushWarning(self, warning: str|None) -> None: ...
    def warnings(self) -> list[str]: ...
    def pushError(self, error: str|None) -> None: ...
    def errors(self) -> list[str]: ...
    def setExportFilePath(self, exportFilePath: str|None) -> None: ...
    def exportFilePath(self) -> str: ...
    def setVendorExtension(self, vendorExtension: Qgis.SldExportVendorExtension) -> None: ...
    def vendorExtensions(self) -> Qgis.SldExportVendorExtension: ...
    def setExportOptions(self, exportOptions: Qgis.SldExportOption) -> None: ...
    def exportOptions(self) -> Qgis.SldExportOption: ...


class QgsSnappingConfig(PyQt6.sip.wrapper):

    class ScaleDependencyMode(enum.IntEnum):
        Disabled = ... # type: QgsSnappingConfig.ScaleDependencyMode
        Global = ... # type: QgsSnappingConfig.ScaleDependencyMode
        PerLayer = ... # type: QgsSnappingConfig.ScaleDependencyMode

    class SnappingType(enum.IntEnum):
        Vertex = ... # type: QgsSnappingConfig.SnappingType
        VertexAndSegment = ... # type: QgsSnappingConfig.SnappingType
        Segment = ... # type: QgsSnappingConfig.SnappingType

    class IndividualLayerSettings(PyQt6.sip.wrapper):

        @typing.overload
        @deprecated("""""")
        def __init__(self, enabled: bool, type: 'QgsSnappingConfig.SnappingType', tolerance: float, units: Qgis.MapToolUnit) -> None: ...
        @typing.overload
        def __init__(self, enabled: bool, type: Qgis.SnappingType, tolerance: float, units: Qgis.MapToolUnit, minScale: float = ..., maxScale: float = ...) -> None: ...
        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsSnappingConfig.IndividualLayerSettings') -> None: ...

        def __eq__(self, other: object): ...
        def __ne__(self, other: object): ...
        def setMaximumScale(self, maxScale: float) -> None: ...
        def maximumScale(self) -> float: ...
        def setMinimumScale(self, minScale: float) -> None: ...
        def minimumScale(self) -> float: ...
        def setUnits(self, units: Qgis.MapToolUnit) -> None: ...
        def units(self) -> Qgis.MapToolUnit: ...
        def setTolerance(self, tolerance: float) -> None: ...
        def tolerance(self) -> float: ...
        def setTypeFlag(self, type: Qgis.SnappingType) -> None: ...
        @deprecated("""""")
        def setType(self, type: 'QgsSnappingConfig.SnappingType') -> None: ...
        @deprecated("""""")
        def type(self) -> 'QgsSnappingConfig.SnappingType': ...
        def typeFlag(self) -> Qgis.SnappingType: ...
        def setEnabled(self, enabled: bool) -> None: ...
        def enabled(self) -> bool: ...
        def valid(self) -> bool: ...

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, project: 'QgsProject|None' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSnappingConfig') -> None: ...

    def setProject(self, project: 'QgsProject|None') -> None: ...
    def project(self) -> 'QgsProject|None': ...
    def removeLayers(self, layers: collections.abc.Iterable[QgsMapLayer]) -> bool: ...
    def addLayers(self, layers: collections.abc.Iterable[QgsMapLayer]) -> bool: ...
    def writeProject(self, doc: QtXml.QDomDocument) -> None: ...
    def readProject(self, doc: QtXml.QDomDocument) -> None: ...
    def __ne__(self, other: object): ...
    def clearIndividualLayerSettings(self) -> None: ...
    def setIndividualLayerSettings(self, vl: QgsVectorLayer|None, individualLayerSettings: 'QgsSnappingConfig.IndividualLayerSettings') -> None: ...
    @typing.overload
    def individualLayerSettings(self) -> dict: ...
    @typing.overload
    def individualLayerSettings(self, vl: QgsVectorLayer|None) -> 'QgsSnappingConfig.IndividualLayerSettings': ...
    def setSelfSnapping(self, enabled: bool) -> None: ...
    def selfSnapping(self) -> bool: ...
    def setIntersectionSnapping(self, enabled: bool) -> None: ...
    def intersectionSnapping(self) -> bool: ...
    def setUnits(self, units: Qgis.MapToolUnit) -> None: ...
    def units(self) -> Qgis.MapToolUnit: ...
    def scaleDependencyMode(self) -> 'QgsSnappingConfig.ScaleDependencyMode': ...
    def setScaleDependencyMode(self, mode: 'QgsSnappingConfig.ScaleDependencyMode') -> None: ...
    def setMaximumScale(self, maxScale: float) -> None: ...
    def maximumScale(self) -> float: ...
    def setMinimumScale(self, minScale: float) -> None: ...
    def minimumScale(self) -> float: ...
    def setTolerance(self, tolerance: float) -> None: ...
    def tolerance(self) -> float: ...
    def setTypeFlag(self, type: Qgis.SnappingType) -> None: ...
    def setType(self, type: 'QgsSnappingConfig.SnappingType') -> None: ...
    @deprecated("""""")
    def type(self) -> 'QgsSnappingConfig.SnappingType': ...
    def typeFlag(self) -> Qgis.SnappingType: ...
    def setMode(self, mode: Qgis.SnappingMode) -> None: ...
    def mode(self) -> Qgis.SnappingMode: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def reset(self) -> None: ...
    def __eq__(self, other: object): ...
    @staticmethod
    @deprecated("""""")
    def snappingTypeFlagToIcon(type: Qgis.SnappingType) -> QtGui.QIcon: ...
    @staticmethod
    def snappingTypeToIcon(type: Qgis.SnappingType) -> QtGui.QIcon: ...
    @staticmethod
    @deprecated("""""")
    def snappingTypeFlagToString(type: Qgis.SnappingType) -> str: ...
    @staticmethod
    def snappingTypeToString(type: Qgis.SnappingType) -> str: ...


class QgsSnappingUtils(QtCore.QObject):

    class IndexingStrategy(enum.IntEnum):
        IndexAlwaysFull = ... # type: QgsSnappingUtils.IndexingStrategy
        IndexNeverFull = ... # type: QgsSnappingUtils.IndexingStrategy
        IndexHybrid = ... # type: QgsSnappingUtils.IndexingStrategy
        IndexExtent = ... # type: QgsSnappingUtils.IndexingStrategy

    class LayerConfig(PyQt6.sip.wrapper):

        layer = ... # type: QgsVectorLayer
        tolerance = ... # type: float
        type = ... # type: QgsPointLocator.Type
        unit = ... # type: Qgis.MapToolUnit

        @typing.overload
        def __init__(self, l: QgsVectorLayer|None, t: QgsPointLocator.Type, tol: float, u: Qgis.MapToolUnit) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsSnappingUtils.LayerConfig') -> None: ...

        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...

    def __init__(self, parent: QtCore.QObject|None = ..., enableSnappingForInvisibleFeature: bool = ...) -> None: ...

    def clearAllLocators(self) -> None: ...
    def prepareIndexProgress(self, index: int) -> None: ...
    def prepareIndexStarting(self, count: int) -> None: ...
    configChanged: typing.ClassVar[QtCore.pyqtSignal]
    def toggleEnabled(self) -> None: ...
    def setConfig(self, snappingConfig: QgsSnappingConfig) -> None: ...
    def getExtraSnapLayers(self) -> set[QgsVectorLayer]: ...
    def removeExtraSnapLayer(self, vl: QgsVectorLayer|None) -> None: ...
    def addExtraSnapLayer(self, vl: QgsVectorLayer|None) -> None: ...
    def setEnableSnappingForInvisibleFeature(self, enable: bool) -> None: ...
    def config(self) -> QgsSnappingConfig: ...
    def dump(self) -> str: ...
    def layers(self) -> list['QgsSnappingUtils.LayerConfig']: ...
    def indexingStrategy(self) -> 'QgsSnappingUtils.IndexingStrategy': ...
    def setIndexingStrategy(self, strategy: 'QgsSnappingUtils.IndexingStrategy') -> None: ...
    def currentLayer(self) -> QgsVectorLayer|None: ...
    def setCurrentLayer(self, layer: QgsVectorLayer|None) -> None: ...
    def mapSettings(self) -> QgsMapSettings: ...
    def setMapSettings(self, settings: QgsMapSettings) -> None: ...
    def snapToCurrentLayer(self, point: QtCore.QPoint, type: QgsPointLocator.Type, filter: QgsPointLocator.MatchFilter|None = ...) -> QgsPointLocator.Match: ...
    @typing.overload
    def snapToMap(self, point: QtCore.QPoint, filter: QgsPointLocator.MatchFilter|None = ..., relaxed: bool = ...) -> QgsPointLocator.Match: ...
    @typing.overload
    def snapToMap(self, pointMap: QgsPointXY, filter: QgsPointLocator.MatchFilter|None = ..., relaxed: bool = ...) -> QgsPointLocator.Match: ...
    def locatorForLayer(self, vl: QgsVectorLayer|None) -> QgsPointLocator|None: ...


class QgsSpatialIndex(QgsFeatureSink):

    class Flag(enum.IntEnum):
        FlagStoreFeatureGeometries = ... # type: QgsSpatialIndex.Flag

    @typing.overload
    def __init__(self, flags: 'QgsSpatialIndex.Flag' = ...) -> None: ...
    @typing.overload
    def __init__(self, fi: QgsFeatureIterator, feedback: QgsFeedback|None = ..., flags: 'QgsSpatialIndex.Flag' = ...) -> None: ...
    @typing.overload
    def __init__(self, source: QgsFeatureSource, feedback: QgsFeedback|None = ..., flags: 'QgsSpatialIndex.Flag' = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsSpatialIndex') -> None: ...

    def refs(self) -> int: ...
    def geometry(self, id: int) -> 'QgsGeometry': ...
    @typing.overload
    def nearestNeighbor(self, point: QgsPointXY, neighbors: int = ..., maxDistance: float = ...) -> list[int]: ...
    @typing.overload
    def nearestNeighbor(self, geometry: 'QgsGeometry', neighbors: int = ..., maxDistance: float = ...) -> list[int]: ...
    def intersects(self, rectangle: 'QgsRectangle') -> list[int]: ...
    @typing.overload
    def deleteFeature(self, feature: QgsFeature) -> bool: ...
    @typing.overload
    def deleteFeature(self, id: int, bounds: 'QgsRectangle') -> bool: ...
    def addFeatures(self, features: collections.abc.Iterable[QgsFeature], flags: QgsFeatureSink.Flag = ...) -> bool: ...
    @typing.overload
    def addFeature(self, feature: QgsFeature, flags: QgsFeatureSink.Flag = ...) -> bool: ...
    @typing.overload
    def addFeature(self, id: int, bounds: 'QgsRectangle') -> bool: ...
    @typing.overload
    @deprecated("""""")
    def insertFeature(self, feature: QgsFeature) -> bool: ...
    @typing.overload
    @deprecated("""""")
    def insertFeature(self, id: int, bounds: 'QgsRectangle') -> bool: ...


class QgsSpatialIndexKDBush(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, fi: QgsFeatureIterator, feedback: QgsFeedback|None = ...) -> None: ...
    @typing.overload
    def __init__(self, source: QgsFeatureSource, feedback: QgsFeedback|None = ...) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsSpatialIndexKDBush') -> None: ...

    def size(self) -> int: ...
    def within(self, point: QgsPointXY, radius: float) -> list['QgsSpatialIndexKDBushData']: ...
    def intersects(self, rectangle: 'QgsRectangle') -> list['QgsSpatialIndexKDBushData']: ...
    def finalize(self) -> None: ...
    def addFeature(self, id: int, point: QgsPointXY) -> bool: ...


class QgsSpatialIndexKDBushData(PyQt6.sip.wrapper):

    id = ... # type: int

    @typing.overload
    def __init__(self, id: int, x: float, y: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSpatialIndexKDBushData') -> None: ...

    def point(self) -> QgsPointXY: ...


class QgsSourceCache(QgsAbstractContentCacheBase):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    remoteSourceFetched: typing.ClassVar[QtCore.pyqtSignal]
    def localFilePath(self, path: str|None, blocking: bool = ...) -> str: ...


class QgsSqliteUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSqliteUtils') -> None: ...

    @staticmethod
    def systemTables() -> list[str]: ...
    @staticmethod
    def quotedValue(value: typing.Any) -> str: ...
    @staticmethod
    def quotedIdentifier(identifier: str|None) -> str: ...
    @staticmethod
    def quotedString(value: str|None) -> str: ...


class QgsSQLStatement(PyQt6.sip.wrapper):

    class NodeType(enum.IntEnum):
        ntUnaryOperator = ... # type: QgsSQLStatement.NodeType
        ntBinaryOperator = ... # type: QgsSQLStatement.NodeType
        ntInOperator = ... # type: QgsSQLStatement.NodeType
        ntBetweenOperator = ... # type: QgsSQLStatement.NodeType
        ntFunction = ... # type: QgsSQLStatement.NodeType
        ntLiteral = ... # type: QgsSQLStatement.NodeType
        ntColumnRef = ... # type: QgsSQLStatement.NodeType
        ntSelectedColumn = ... # type: QgsSQLStatement.NodeType
        ntSelect = ... # type: QgsSQLStatement.NodeType
        ntTableDef = ... # type: QgsSQLStatement.NodeType
        ntJoin = ... # type: QgsSQLStatement.NodeType
        ntColumnSorted = ... # type: QgsSQLStatement.NodeType
        ntCast = ... # type: QgsSQLStatement.NodeType

    class JoinType(enum.IntEnum):
        jtDefault = ... # type: QgsSQLStatement.JoinType
        jtLeft = ... # type: QgsSQLStatement.JoinType
        jtLeftOuter = ... # type: QgsSQLStatement.JoinType
        jtRight = ... # type: QgsSQLStatement.JoinType
        jtRightOuter = ... # type: QgsSQLStatement.JoinType
        jtCross = ... # type: QgsSQLStatement.JoinType
        jtInner = ... # type: QgsSQLStatement.JoinType
        jtFull = ... # type: QgsSQLStatement.JoinType

    class BinaryOperator(enum.IntEnum):
        boOr = ... # type: QgsSQLStatement.BinaryOperator
        boAnd = ... # type: QgsSQLStatement.BinaryOperator
        boEQ = ... # type: QgsSQLStatement.BinaryOperator
        boNE = ... # type: QgsSQLStatement.BinaryOperator
        boLE = ... # type: QgsSQLStatement.BinaryOperator
        boGE = ... # type: QgsSQLStatement.BinaryOperator
        boLT = ... # type: QgsSQLStatement.BinaryOperator
        boGT = ... # type: QgsSQLStatement.BinaryOperator
        boLike = ... # type: QgsSQLStatement.BinaryOperator
        boNotLike = ... # type: QgsSQLStatement.BinaryOperator
        boILike = ... # type: QgsSQLStatement.BinaryOperator
        boNotILike = ... # type: QgsSQLStatement.BinaryOperator
        boIs = ... # type: QgsSQLStatement.BinaryOperator
        boIsNot = ... # type: QgsSQLStatement.BinaryOperator
        boPlus = ... # type: QgsSQLStatement.BinaryOperator
        boMinus = ... # type: QgsSQLStatement.BinaryOperator
        boMul = ... # type: QgsSQLStatement.BinaryOperator
        boDiv = ... # type: QgsSQLStatement.BinaryOperator
        boIntDiv = ... # type: QgsSQLStatement.BinaryOperator
        boMod = ... # type: QgsSQLStatement.BinaryOperator
        boPow = ... # type: QgsSQLStatement.BinaryOperator
        boConcat = ... # type: QgsSQLStatement.BinaryOperator

    class UnaryOperator(enum.IntEnum):
        uoNot = ... # type: QgsSQLStatement.UnaryOperator
        uoMinus = ... # type: QgsSQLStatement.UnaryOperator

    class Node(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsSQLStatement.Node') -> None: ...

        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...

    class NodeList(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsSQLStatement.NodeList') -> None: ...

        def dump(self) -> str: ...
        def clone(self) -> 'QgsSQLStatement.NodeList|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def count(self) -> int: ...
        def list(self) -> list['QgsSQLStatement.Node']: ...
        def append(self, node: 'QgsSQLStatement.Node|None') -> None: ...

    class NodeUnaryOperator('QgsSQLStatement.Node'):

        def __init__(self, op: 'QgsSQLStatement.UnaryOperator', operand: 'QgsSQLStatement.Node|None') -> None: ...

        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def operand(self) -> 'QgsSQLStatement.Node|None': ...
        def op(self) -> 'QgsSQLStatement.UnaryOperator': ...

    class NodeBinaryOperator('QgsSQLStatement.Node'):

        def __init__(self, op: 'QgsSQLStatement.BinaryOperator', opLeft: 'QgsSQLStatement.Node|None', opRight: 'QgsSQLStatement.Node|None') -> None: ...

        def leftAssociative(self) -> bool: ...
        def precedence(self) -> int: ...
        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def opRight(self) -> 'QgsSQLStatement.Node|None': ...
        def opLeft(self) -> 'QgsSQLStatement.Node|None': ...
        def op(self) -> 'QgsSQLStatement.BinaryOperator': ...

    class NodeInOperator('QgsSQLStatement.Node'):

        def __init__(self, node: 'QgsSQLStatement.Node|None', list: 'QgsSQLStatement.NodeList|None', notin: bool = ...) -> None: ...

        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def list(self) -> 'QgsSQLStatement.NodeList|None': ...
        def isNotIn(self) -> bool: ...
        def node(self) -> 'QgsSQLStatement.Node|None': ...

    class NodeBetweenOperator('QgsSQLStatement.Node'):

        def __init__(self, node: 'QgsSQLStatement.Node|None', minVal: 'QgsSQLStatement.Node|None', maxVal: 'QgsSQLStatement.Node|None', notBetween: bool = ...) -> None: ...

        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def maxVal(self) -> 'QgsSQLStatement.Node|None': ...
        def minVal(self) -> 'QgsSQLStatement.Node|None': ...
        def isNotBetween(self) -> bool: ...
        def node(self) -> 'QgsSQLStatement.Node|None': ...

    class NodeFunction('QgsSQLStatement.Node'):

        def __init__(self, name: str|None, args: 'QgsSQLStatement.NodeList|None') -> None: ...

        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def args(self) -> 'QgsSQLStatement.NodeList|None': ...
        def name(self) -> str: ...

    class NodeLiteral('QgsSQLStatement.Node'):

        @typing.overload
        def __init__(self, value: typing.Any) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsSQLStatement.NodeLiteral') -> None: ...

        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def value(self) -> typing.Any: ...

    class NodeColumnRef('QgsSQLStatement.Node'):

        @typing.overload
        def __init__(self, name: str|None, star: bool) -> None: ...
        @typing.overload
        def __init__(self, tableName: str|None, name: str|None, star: bool) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsSQLStatement.NodeColumnRef') -> None: ...

        def cloneThis(self) -> 'QgsSQLStatement.NodeColumnRef|None': ...
        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def distinct(self) -> bool: ...
        def star(self) -> bool: ...
        def name(self) -> str: ...
        def tableName(self) -> str: ...
        def setDistinct(self, distinct: bool = ...) -> None: ...

    class NodeSelectedColumn('QgsSQLStatement.Node'):

        def __init__(self, node: 'QgsSQLStatement.Node|None') -> None: ...

        def cloneThis(self) -> 'QgsSQLStatement.NodeSelectedColumn|None': ...
        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def alias(self) -> str: ...
        def column(self) -> 'QgsSQLStatement.Node|None': ...
        def setAlias(self, alias: str|None) -> None: ...

    class NodeCast('QgsSQLStatement.Node'):

        def __init__(self, node: 'QgsSQLStatement.Node|None', type: str|None) -> None: ...

        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def type(self) -> str: ...
        def node(self) -> 'QgsSQLStatement.Node|None': ...

    class NodeTableDef('QgsSQLStatement.Node'):

        @typing.overload
        def __init__(self, name: str|None) -> None: ...
        @typing.overload
        def __init__(self, name: str|None, alias: str|None) -> None: ...
        @typing.overload
        def __init__(self, schema: str|None, name: str|None, alias: str|None) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsSQLStatement.NodeTableDef') -> None: ...

        def cloneThis(self) -> 'QgsSQLStatement.NodeTableDef|None': ...
        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def alias(self) -> str: ...
        def schema(self) -> str: ...
        def name(self) -> str: ...

    class NodeJoin('QgsSQLStatement.Node'):

        @typing.overload
        def __init__(self, tabledef: 'QgsSQLStatement.NodeTableDef|None', onExpr: 'QgsSQLStatement.Node|None', type: 'QgsSQLStatement.JoinType') -> None: ...
        @typing.overload
        def __init__(self, tabledef: 'QgsSQLStatement.NodeTableDef|None', usingColumns: collections.abc.Iterable[str|None], type: 'QgsSQLStatement.JoinType') -> None: ...

        def cloneThis(self) -> 'QgsSQLStatement.NodeJoin|None': ...
        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def type(self) -> 'QgsSQLStatement.JoinType': ...
        def usingColumns(self) -> list[str]: ...
        def onExpr(self) -> 'QgsSQLStatement.Node|None': ...
        def tableDef(self) -> 'QgsSQLStatement.NodeTableDef|None': ...

    class NodeColumnSorted('QgsSQLStatement.Node'):

        def __init__(self, column: 'QgsSQLStatement.NodeColumnRef|None', asc: bool) -> None: ...

        def cloneThis(self) -> 'QgsSQLStatement.NodeColumnSorted|None': ...
        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def ascending(self) -> bool: ...
        def column(self) -> 'QgsSQLStatement.NodeColumnRef|None': ...

    class NodeSelect('QgsSQLStatement.Node'):

        def __init__(self, tableList: collections.abc.Iterable['QgsSQLStatement.NodeTableDef'], columns: collections.abc.Iterable['QgsSQLStatement.NodeSelectedColumn'], distinct: bool) -> None: ...

        def clone(self) -> 'QgsSQLStatement.Node|None': ...
        def accept(self, v: 'QgsSQLStatement.Visitor') -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> 'QgsSQLStatement.NodeType': ...
        def orderBy(self) -> list['QgsSQLStatement.NodeColumnSorted']: ...
        def where(self) -> 'QgsSQLStatement.Node|None': ...
        def joins(self) -> list['QgsSQLStatement.NodeJoin']: ...
        def distinct(self) -> bool: ...
        def columns(self) -> list['QgsSQLStatement.NodeSelectedColumn']: ...
        def tables(self) -> list['QgsSQLStatement.NodeTableDef']: ...
        def setOrderBy(self, orderBy: collections.abc.Iterable['QgsSQLStatement.NodeColumnSorted']) -> None: ...
        def setWhere(self, where: 'QgsSQLStatement.Node|None') -> None: ...
        def appendJoin(self, join: 'QgsSQLStatement.NodeJoin|None') -> None: ...
        def setJoins(self, joins: collections.abc.Iterable['QgsSQLStatement.NodeJoin']) -> None: ...

    class Visitor(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsSQLStatement.Visitor') -> None: ...

        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeUnaryOperator') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeBinaryOperator') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeInOperator') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeBetweenOperator') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeFunction') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeLiteral') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeColumnRef') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeSelectedColumn') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeTableDef') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeSelect') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeJoin') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeColumnSorted') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeCast') -> None: ...

    class RecursiveVisitor('QgsSQLStatement.Visitor'):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsSQLStatement.RecursiveVisitor') -> None: ...

        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeUnaryOperator') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeBinaryOperator') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeInOperator') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeBetweenOperator') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeFunction') -> None: ...
        @typing.overload
        def visit(self, a0: 'QgsSQLStatement.NodeLiteral') -> None: ...
        @typing.overload
        def visit(self, a0: 'QgsSQLStatement.NodeColumnRef') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeSelectedColumn') -> None: ...
        @typing.overload
        def visit(self, a0: 'QgsSQLStatement.NodeTableDef') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeSelect') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeJoin') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeColumnSorted') -> None: ...
        @typing.overload
        def visit(self, n: 'QgsSQLStatement.NodeCast') -> None: ...

    @typing.overload
    def __init__(self, statement: str|None) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsSQLStatement') -> None: ...
    @typing.overload
    def __init__(self, statement: str|None, allowFragments: bool) -> None: ...

    def acceptVisitor(self, v: 'QgsSQLStatement.Visitor') -> None: ...
    @staticmethod
    def quotedString(text: str|None) -> str: ...
    @staticmethod
    def stripMsQuotedIdentifier(text: str|None) -> str: ...
    @staticmethod
    def stripQuotedIdentifier(text: str|None) -> str: ...
    @staticmethod
    def quotedIdentifierIfNeeded(name: str|None) -> str: ...
    @staticmethod
    def quotedIdentifier(name: str|None) -> str: ...
    def dump(self) -> str: ...
    def statement(self) -> str: ...
    def rootNode(self) -> 'QgsSQLStatement.Node|None': ...
    def doBasicValidationChecks(self) -> typing.Tuple[bool, str]: ...
    def parserErrorString(self) -> str: ...
    def hasParserError(self) -> bool: ...


class QgsSQLStatementFragment(QgsSQLStatement):

    @typing.overload
    def __init__(self, fragment: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSQLStatementFragment') -> None: ...


class QgsStatisticalSummary(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, stats: Qgis.Statistic = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsStatisticalSummary') -> None: ...

    @staticmethod
    def shortName(statistic: Qgis.Statistic) -> str: ...
    @staticmethod
    def displayName(statistic: Qgis.Statistic) -> str: ...
    def interQuartileRange(self) -> float: ...
    def thirdQuartile(self) -> float: ...
    def firstQuartile(self) -> float: ...
    def majority(self) -> float: ...
    def minority(self) -> float: ...
    def variety(self) -> int: ...
    def sampleStDev(self) -> float: ...
    def stDev(self) -> float: ...
    def last(self) -> float: ...
    def first(self) -> float: ...
    def range(self) -> float: ...
    def max(self) -> float: ...
    def min(self) -> float: ...
    def median(self) -> float: ...
    def mean(self) -> float: ...
    def sum(self) -> float: ...
    def countMissing(self) -> int: ...
    def count(self) -> int: ...
    def statistic(self, stat: Qgis.Statistic) -> float: ...
    def finalize(self) -> None: ...
    def addVariant(self, value: typing.Any) -> None: ...
    def addValue(self, value: float) -> None: ...
    def calculate(self, values: collections.abc.Iterable[float]) -> None: ...
    def reset(self) -> None: ...
    def setStatistics(self, stats: Qgis.Statistic) -> None: ...
    def statistics(self) -> Qgis.Statistic: ...


class QgsStoredExpression(PyQt6.sip.wrapper):

    class Category(enum.IntEnum):
        FilterExpression = ... # type: QgsStoredExpression.Category
        DefaultValueExpression = ... # type: QgsStoredExpression.Category
        All = ... # type: QgsStoredExpression.Category

    expression = ... # type: str|None
    id = ... # type: str|None
    name = ... # type: str|None
    tag = ... # type: 'QgsStoredExpression.Category'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsStoredExpression') -> None: ...


class QgsStoredExpressionManager(QtCore.QObject):

    def __init__(self) -> None: ...

    def readXml(self, layerNode: QtXml.QDomNode) -> bool: ...
    def writeXml(self, layerNode: QtXml.QDomNode) -> bool: ...
    def clearStoredExpressions(self) -> None: ...
    def findStoredExpressionByExpression(self, expression: str|None, tag: QgsStoredExpression.Category = ...) -> QgsStoredExpression: ...
    def storedExpression(self, id: str|None) -> QgsStoredExpression: ...
    def storedExpressions(self, tag: QgsStoredExpression.Category = ...) -> list[QgsStoredExpression]: ...
    def addStoredExpressions(self, storedExpressions: collections.abc.Iterable[QgsStoredExpression]) -> None: ...
    def updateStoredExpression(self, id: str|None, name: str|None, expression: str|None, tag: QgsStoredExpression.Category) -> None: ...
    def removeStoredExpression(self, id: str|None) -> None: ...
    def addStoredExpression(self, name: str|None, expression: str|None, tag: QgsStoredExpression.Category = ...) -> str: ...


class QgsStringStatisticalSummary(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, stats: Qgis.StringStatistic = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsStringStatisticalSummary') -> None: ...

    @staticmethod
    def displayName(statistic: Qgis.StringStatistic) -> str: ...
    def majority(self) -> str: ...
    def minority(self) -> str: ...
    def meanLength(self) -> float: ...
    def maxLength(self) -> int: ...
    def minLength(self) -> int: ...
    def max(self) -> str: ...
    def min(self) -> str: ...
    def countMissing(self) -> int: ...
    def distinctValues(self) -> set[str]: ...
    def countDistinct(self) -> int: ...
    def count(self) -> int: ...
    def statistic(self, stat: Qgis.StringStatistic) -> typing.Any: ...
    def finalize(self) -> None: ...
    def addValue(self, value: typing.Any) -> None: ...
    def addString(self, string: str|None) -> None: ...
    def calculateFromVariants(self, values: collections.abc.Iterable[typing.Any]) -> None: ...
    def calculate(self, values: collections.abc.Iterable[str|None]) -> None: ...
    def reset(self) -> None: ...
    def setStatistics(self, stats: Qgis.StringStatistic) -> None: ...
    def statistics(self) -> Qgis.StringStatistic: ...


class QgsStringReplacement(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, match: str|None, replacement: str|None, caseSensitive: bool = ..., wholeWordOnly: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsStringReplacement') -> None: ...

    def __ne__(self, other: object): ...
    @staticmethod
    def fromProperties(properties: dict[str|None, str|None]) -> 'QgsStringReplacement': ...
    def properties(self) -> dict[str, str]: ...
    def __eq__(self, other: object): ...
    def process(self, input: str|None) -> str: ...
    def wholeWordOnly(self) -> bool: ...
    def caseSensitive(self) -> bool: ...
    def replacement(self) -> str: ...
    def match(self) -> str: ...


class QgsStringReplacementCollection(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, replacements: collections.abc.Iterable[QgsStringReplacement] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsStringReplacementCollection') -> None: ...

    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument) -> None: ...
    def process(self, input: str|None) -> str: ...
    def setReplacements(self, replacements: collections.abc.Iterable[QgsStringReplacement]) -> None: ...
    def replacements(self) -> list[QgsStringReplacement]: ...


class QgsStringUtils(PyQt6.sip.wrapper):

    UNACCENT_MAP = ... # type: dict[str|None, str|None]

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsStringUtils') -> None: ...

    @staticmethod
    def unaccent(input: str|None) -> str: ...
    @staticmethod
    def createUnaccentMap() -> dict[str, str]: ...
    @staticmethod
    def containsByWord(candidate: str|None, words: str|None, sensitivity: QtCore.Qt.CaseSensitivity = ...) -> bool: ...
    @staticmethod
    def truncateMiddleOfString(string: str|None, maxLength: int) -> str: ...
    @staticmethod
    def qRegExpEscape(string: str|None) -> str: ...
    @staticmethod
    def htmlToMarkdown(html: str|None) -> str: ...
    @staticmethod
    def substituteVerticalCharacters(string: str|None) -> str: ...
    @staticmethod
    def wordWrap(string: str|None, length: int, useMaxLineLength: bool = ..., customDelimiter: str|None = ...) -> str: ...
    @staticmethod
    def isUrl(string: str|None) -> bool: ...
    @staticmethod
    def insertLinks(string: str|None) -> typing.Tuple[str, bool]: ...
    @staticmethod
    def fuzzyScore(candidate: str|None, search: str|None) -> float: ...
    @staticmethod
    def soundex(string: str|None) -> str: ...
    @staticmethod
    def hammingDistance(string1: str|None, string2: str|None, caseSensitive: bool = ...) -> int: ...
    @staticmethod
    def longestCommonSubstring(string1: str|None, string2: str|None, caseSensitive: bool = ...) -> str: ...
    @staticmethod
    def levenshteinDistance(string1: str|None, string2: str|None, caseSensitive: bool = ...) -> int: ...
    @staticmethod
    def ampersandEncode(string: str|None) -> str: ...
    @staticmethod
    def capitalize(string: str|None, capitalization: Qgis.Capitalization) -> str: ...


class QgsTableCell(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, content: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsTableCell') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def setProperties(self, properties: dict[str|None, typing.Any], context: QgsReadWriteContext) -> None: ...
    def properties(self, context: QgsReadWriteContext) -> dict[str, typing.Any]: ...
    def columnSpan(self) -> int: ...
    def rowSpan(self) -> int: ...
    def setSpan(self, rowSpan: int, columnSpan: int) -> None: ...
    def setVerticalAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def verticalAlignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def setHorizontalAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def horizontalAlignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def setNumericFormat(self, format: 'QgsNumericFormat|None') -> None: ...
    def numericFormat(self) -> 'QgsNumericFormat|None': ...
    def setTextFormat(self, format: 'QgsTextFormat') -> None: ...
    def textFormat(self) -> 'QgsTextFormat': ...
    def setForegroundColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def foregroundColor(self) -> QtGui.QColor: ...
    def setBackgroundColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setContent(self, content: typing.Any) -> None: ...
    def content(self) -> typing.Any: ...


class QgsTaskManager(QtCore.QObject):

    class TaskDefinition(PyQt6.sip.wrapper):

        dependentTasks = ... # type: collections.abc.Iterable[QgsTask]
        task = ... # type: QgsTask

        @typing.overload
        def __init__(self, task: QgsTask|None, dependentTasks: collections.abc.Iterable[QgsTask] = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsTaskManager.TaskDefinition') -> None: ...

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    taskTriggered: typing.ClassVar[QtCore.pyqtSignal]
    countActiveTasksChanged: typing.ClassVar[QtCore.pyqtSignal]
    allTasksFinished: typing.ClassVar[QtCore.pyqtSignal]
    taskAboutToBeDeleted: typing.ClassVar[QtCore.pyqtSignal]
    taskAdded: typing.ClassVar[QtCore.pyqtSignal]
    statusChanged: typing.ClassVar[QtCore.pyqtSignal]
    finalTaskProgressChanged: typing.ClassVar[QtCore.pyqtSignal]
    progressChanged: typing.ClassVar[QtCore.pyqtSignal]
    def triggerTask(self, task: QgsTask|None) -> None: ...
    def countActiveTasks(self, includeHidden: bool = ...) -> int: ...
    def activeTasks(self) -> list[QgsTask]: ...
    def tasksDependentOnLayer(self, layer: QgsMapLayer|None) -> list[QgsTask]: ...
    def dependentLayers(self, taskId: int) -> list[QgsMapLayer]: ...
    def dependenciesSatisfied(self, taskId: int) -> bool: ...
    def cancelAll(self) -> None: ...
    def taskId(self, task: QgsTask|None) -> int: ...
    def count(self) -> int: ...
    def tasks(self) -> list[QgsTask]: ...
    def task(self, id: int) -> QgsTask|None: ...
    @typing.overload
    def addTask(self, task: QgsTask|None, priority: int = ...) -> int: ...
    @typing.overload
    def addTask(self, task: 'QgsTaskManager.TaskDefinition', priority: int = ...) -> int: ...
    def threadPool(self) -> QtCore.QThreadPool|None: ...


class QgsTaskWithSerialSubTasks(QgsTask):

    def __init__(self, desc: str|None = ...) -> None: ...

    def run(self) -> bool: ...
    def cancel(self) -> None: ...
    def addSubTask(self, subTask: QgsTask|None) -> None: ...


class QgsTemporalController(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    updateTemporalRange: typing.ClassVar[QtCore.pyqtSignal]


class QgsTemporalNavigationObject(QgsTemporalController, QgsExpressionContextScopeGenerator):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def skipToEnd(self) -> None: ...
    def rewindToStart(self) -> None: ...
    def previous(self) -> None: ...
    def next(self) -> None: ...
    def playBackward(self) -> None: ...
    def playForward(self) -> None: ...
    def pause(self) -> None: ...
    def play(self) -> None: ...
    totalMovieFramesChanged: typing.ClassVar[QtCore.pyqtSignal]
    temporalFrameDurationChanged: typing.ClassVar[QtCore.pyqtSignal]
    temporalExtentsChanged: typing.ClassVar[QtCore.pyqtSignal]
    navigationModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    stateChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setTotalMovieFrames(self, frames: int) -> None: ...
    def totalMovieFrames(self) -> int: ...
    def createExpressionContextScope(self) -> QgsExpressionContextScope|None: ...
    def findBestFrameNumberForFrameStart(self, frameStart: QtCore.QDateTime|datetime.datetime) -> int: ...
    def setLooping(self, loop: bool) -> None: ...
    def isLooping(self) -> bool: ...
    def totalFrameCount(self) -> int: ...
    def temporalRangeCumulative(self) -> bool: ...
    def setTemporalRangeCumulative(self, state: bool) -> None: ...
    def framesPerSecond(self) -> float: ...
    def setFramesPerSecond(self, rate: float) -> None: ...
    def dateTimeRangeForFrameNumber(self, frame: int) -> QgsDateTimeRange: ...
    def frameDuration(self) -> QgsInterval: ...
    def setFrameDuration(self, duration: QgsInterval) -> None: ...
    def currentFrameNumber(self) -> int: ...
    def setCurrentFrameNumber(self, frame: int) -> None: ...
    def availableTemporalRanges(self) -> list[QgsDateTimeRange]: ...
    def setAvailableTemporalRanges(self, ranges: collections.abc.Iterable[QgsDateTimeRange]) -> None: ...
    def temporalExtents(self) -> QgsDateTimeRange: ...
    def setTemporalExtents(self, extents: QgsDateTimeRange) -> None: ...
    def navigationMode(self) -> Qgis.TemporalNavigationMode: ...
    def setNavigationMode(self, mode: Qgis.TemporalNavigationMode) -> None: ...
    def animationState(self) -> Qgis.AnimationState: ...
    def setAnimationState(self, state: Qgis.AnimationState) -> None: ...


class QgsTemporalUtils(PyQt6.sip.wrapper):

    class AnimationExportSettings(PyQt6.sip.wrapper):

        animationRange = ... # type: QgsDateTimeRange
        availableTemporalRanges = ... # type: collections.abc.Iterable[QgsDateTimeRange]
        decorations = ... # type: collections.abc.Iterable[QgsMapDecoration]
        fileNameTemplate = ... # type: str|None
        frameDuration = ... # type: QgsInterval
        frameRate = ... # type: float
        outputDirectory = ... # type: str|None
        temporalRangeCumulative = ... # type: bool

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsTemporalUtils.AnimationExportSettings') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTemporalUtils') -> None: ...

    @staticmethod
    def calculateDateTimesFromISO8601(string: str|None, maxValues: int = ...) -> typing.Tuple[list[QtCore.QDateTime], bool, bool]: ...
    @staticmethod
    def calculateDateTimesUsingDuration(start: QtCore.QDateTime|datetime.datetime, end: QtCore.QDateTime|datetime.datetime, duration: str|None, maxValues: int = ...) -> typing.Tuple[list[QtCore.QDateTime], bool, bool]: ...
    @staticmethod
    def calculateFrameTime(start: QtCore.QDateTime|datetime.datetime, frame: int, interval: QgsInterval) -> QtCore.QDateTime: ...
    @staticmethod
    def exportAnimation(mapSettings: QgsMapSettings, settings: 'QgsTemporalUtils.AnimationExportSettings', feedback: QgsFeedback|None = ...) -> typing.Tuple[bool, str]: ...
    @staticmethod
    def usedTemporalRangesForProject(project: 'QgsProject|None') -> list[QgsDateTimeRange]: ...
    @staticmethod
    def calculateTemporalRangeForProject(project: 'QgsProject|None') -> QgsDateTimeRange: ...


class QgsTessellator(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    @deprecated("""""")
    def __init__(self, originX: float, originY: float, addNormals: bool, invertNormals: bool = ..., addBackFaces: bool = ..., noZ: bool = ..., addTextureCoords: bool = ..., facade: int = ..., textureRotation: float = ...) -> None: ...
    @typing.overload
    @deprecated("""""")
    def __init__(self, bounds: 'QgsRectangle', addNormals: bool, invertNormals: bool = ..., addBackFaces: bool = ..., noZ: bool = ..., addTextureCoords: bool = ..., facade: int = ..., textureRotation: float = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTessellator') -> None: ...

    def uniqueVertexCount(self) -> int: ...
    def error(self) -> str: ...
    def zMaximum(self) -> float: ...
    def zMinimum(self) -> float: ...
    def indexStride(self) -> int: ...
    def stride(self) -> int: ...
    def dataVerticesCount(self) -> int: ...
    def vertexBuffer(self) -> QtCore.QByteArray: ...
    def indexBuffer(self) -> QtCore.QByteArray: ...
    @deprecated("""""")
    def data(self) -> list[float]: ...
    def addPolygon(self, polygon: 'QgsPolygon', extrusionHeight: float) -> None: ...
    def isOutputZUp(self) -> bool: ...
    def setOutputZUp(self, zUp: bool) -> None: ...
    def triangulationAlgorithm(self) -> Qgis.TriangulationAlgorithm: ...
    def setTriangulationAlgorithm(self, algorithm: Qgis.TriangulationAlgorithm) -> None: ...
    def hasInvertedNormals(self) -> bool: ...
    def setInvertNormals(self, invertNormals: bool) -> None: ...
    def hasBackFacesEnabled(self) -> bool: ...
    def setBackFacesEnabled(self, addBackFaces: bool) -> None: ...
    def hasNormals(self) -> bool: ...
    def setAddNormals(self, addNormals: bool) -> None: ...
    def hasTextureUVs(self) -> bool: ...
    def setAddTextureUVs(self, addTextureUVs: bool) -> None: ...
    def textureRotation(self) -> float: ...
    def setTextureRotation(self, rotation: float) -> None: ...
    def extrusionFaces(self) -> Qgis.ExtrusionFace: ...
    def setExtrusionFaces(self, faces: Qgis.ExtrusionFace) -> None: ...
    def isZValueIgnored(self) -> bool: ...
    def setInputZValueIgnored(self, ignore: bool) -> None: ...
    def setBounds(self, bounds: 'QgsRectangle') -> None: ...
    def origin(self) -> 'QgsVector3D': ...
    def setOrigin(self, origin: 'QgsVector3D') -> None: ...


class QgsTestUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTestUtils') -> None: ...

    @staticmethod
    def sanitizeFakeHttpEndpoint(urlString: str|None) -> str: ...
    @staticmethod
    def compareDomElements(element1: QtXml.QDomElement, element2: QtXml.QDomElement) -> bool: ...
    @staticmethod
    def testProviderIteratorThreadSafety(provider: 'QgsVectorDataProvider|None', request: QgsFeatureRequest = ...) -> bool: ...


class QgsTileXYZ(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, tc: int = ..., tr: int = ..., tz: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTileXYZ') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def toString(self) -> str: ...
    def zoomLevel(self) -> int: ...
    def row(self) -> int: ...
    def column(self) -> int: ...


class QgsTileRange(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, c1: int = ..., c2: int = ..., r1: int = ..., r2: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTileRange') -> None: ...

    def count(self) -> int: ...
    def endRow(self) -> int: ...
    def startRow(self) -> int: ...
    def endColumn(self) -> int: ...
    def startColumn(self) -> int: ...
    def isValid(self) -> bool: ...


class QgsTileMatrix(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTileMatrix') -> None: ...

    def isRootTileMatrix(self) -> bool: ...
    def mapToTileCoordinates(self, mapPoint: QgsPointXY) -> QtCore.QPointF: ...
    def tileRangeFromExtent(self, mExtent: 'QgsRectangle') -> QgsTileRange: ...
    def tileCenter(self, id: QgsTileXYZ) -> QgsPointXY: ...
    def tileExtent(self, id: QgsTileXYZ) -> 'QgsRectangle': ...
    def setScale(self, scale: float) -> None: ...
    def scale(self) -> float: ...
    def extent(self) -> 'QgsRectangle': ...
    def matrixHeight(self) -> int: ...
    def matrixWidth(self) -> int: ...
    def setZoomLevel(self, level: int) -> None: ...
    def zoomLevel(self) -> int: ...
    def setCrs(self, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...
    @staticmethod
    def fromTileMatrix(zoomLevel: int, tileMatrix: 'QgsTileMatrix') -> 'QgsTileMatrix': ...
    @staticmethod
    def fromCustomDef(zoomLevel: int, crs: 'QgsCoordinateReferenceSystem', z0TopLeftPoint: QgsPointXY, z0Dimension: float, z0MatrixWidth: int = ..., z0MatrixHeight: int = ...) -> 'QgsTileMatrix': ...
    @staticmethod
    def fromWebMercator(zoomLevel: int) -> 'QgsTileMatrix': ...


class QgsTileMatrixSet(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTileMatrixSet') -> None: ...

    def tilesInRange(self, range: QgsTileRange, zoomLevel: int) -> list[QgsTileXYZ]: ...
    def setScaleToTileZoomMethod(self, method: Qgis.ScaleToTileZoomLevelMethod) -> None: ...
    def scaleToTileZoomMethod(self) -> Qgis.ScaleToTileZoomLevelMethod: ...
    def writeXml(self, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def calculateTileScaleForMap(self, actualMapScale: float, mapCrs: 'QgsCoordinateReferenceSystem', mapExtent: 'QgsRectangle', mapSize: QtCore.QSize, mapDpi: float) -> float: ...
    def scaleForRenderContext(self, context: QgsRenderContext) -> float: ...
    def scaleToZoomLevel(self, scale: float, clamp: bool = ...) -> int: ...
    def scaleToZoom(self, scale: float) -> float: ...
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...
    def tileAvailability(self, id: QgsTileXYZ) -> Qgis.TileAvailability: ...
    def dropMatricesOutsideZoomRange(self, minimumZoom: int, maximumZoom: int) -> None: ...
    def maximumZoom(self) -> int: ...
    def minimumZoom(self) -> int: ...
    def addMatrix(self, matrix: QgsTileMatrix) -> None: ...
    def setRootMatrix(self, matrix: QgsTileMatrix) -> None: ...
    def rootMatrix(self) -> QgsTileMatrix: ...
    def tileMatrix(self, zoom: int) -> QgsTileMatrix: ...
    def addGoogleCrs84QuadTiles(self, minimumZoom: int = ..., maximumZoom: int = ...) -> None: ...
    def isEmpty(self) -> bool: ...


class QgsTolerance(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTolerance') -> None: ...

    @staticmethod
    def toleranceInMapUnits(tolerance: float, layer: QgsMapLayer|None, mapSettings: QgsMapSettings, units: Qgis.MapToolUnit = ...) -> float: ...
    @staticmethod
    def toleranceInProjectUnits(tolerance: float, layer: QgsMapLayer|None, mapSettings: QgsMapSettings, units: Qgis.MapToolUnit) -> float: ...
    @staticmethod
    def defaultTolerance(layer: QgsMapLayer|None, mapSettings: QgsMapSettings) -> float: ...
    @typing.overload
    @staticmethod
    def vertexSearchRadius(mapSettings: QgsMapSettings) -> float: ...
    @typing.overload
    @staticmethod
    def vertexSearchRadius(layer: QgsMapLayer|None, mapSettings: QgsMapSettings) -> float: ...


class QgsTracer(QtCore.QObject):

    class PathError(enum.IntEnum):
        ErrNone = ... # type: QgsTracer.PathError
        ErrTooManyFeatures = ... # type: QgsTracer.PathError
        ErrPoint1 = ... # type: QgsTracer.PathError
        ErrPoint2 = ... # type: QgsTracer.PathError
        ErrNoPath = ... # type: QgsTracer.PathError

    def __init__(self) -> None: ...

    def invalidateGraph(self) -> None: ...
    def configure(self) -> None: ...
    def addPointsOnIntersectionsEnabled(self) -> bool: ...
    def setAddPointsOnIntersectionsEnabled(self, enable: bool) -> None: ...
    def isPointSnapped(self, pt: QgsPointXY) -> bool: ...
    def findShortestPath(self, p1: QgsPointXY, p2: QgsPointXY) -> typing.Tuple[list[QgsPointXY], 'QgsTracer.PathError|None']: ...
    def hasTopologyProblem(self) -> bool: ...
    def isInitialized(self) -> bool: ...
    def init(self) -> bool: ...
    def setMaxFeatureCount(self, count: int) -> None: ...
    def maxFeatureCount(self) -> int: ...
    def setOffsetParameters(self, quadSegments: int, joinStyle: int, miterLimit: float) -> None: ...
    def offsetParameters(self) -> typing.Tuple[int, int, float]: ...
    def setOffset(self, offset: float) -> None: ...
    def offset(self) -> float: ...
    def setExtent(self, extent: 'QgsRectangle') -> None: ...
    def extent(self) -> 'QgsRectangle': ...
    def setRenderContext(self, renderContext: QgsRenderContext|None) -> None: ...
    def setDestinationCrs(self, crs: 'QgsCoordinateReferenceSystem', context: 'QgsCoordinateTransformContext') -> None: ...
    def destinationCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def setLayers(self, layers: collections.abc.Iterable[QgsVectorLayer]) -> None: ...
    def layers(self) -> list[QgsVectorLayer]: ...


class QgsVectorLayerTools(QtCore.QObject):

    def __init__(self) -> None: ...

    def project(self) -> 'QgsProject|None': ...
    def setProject(self, project: 'QgsProject|None') -> None: ...
    def setForceSuppressFormPopup(self, forceSuppressFormPopup: bool) -> None: ...
    def forceSuppressFormPopup(self) -> bool: ...
    def copyMoveFeatures(self, layer: QgsVectorLayer|None, request: QgsFeatureRequest, dx: float = ..., dy: float = ..., topologicalEditing: bool = ..., topologicalLayer: QgsVectorLayer|None = ..., childrenInfoMsg: str|None = ...) -> typing.Tuple[bool, QgsFeatureRequest, str]: ...
    def saveEdits(self, layer: QgsVectorLayer|None) -> bool: ...
    def stopEditing(self, layer: QgsVectorLayer|None, allowCancel: bool = ...) -> bool: ...
    def startEditing(self, layer: QgsVectorLayer|None) -> bool: ...
    def addFeatureV2(self, layer: QgsVectorLayer|None, defaultValues: dict[int, typing.Any] = ..., defaultGeometry: 'QgsGeometry' = ..., context: 'QgsVectorLayerToolsContext' = ...) -> typing.Tuple[bool, QgsFeature|None]: ...
    def addFeature(self, layer: QgsVectorLayer|None, defaultValues: dict[int, typing.Any] = ..., defaultGeometry: 'QgsGeometry' = ..., parentWidget: QtWidgets.QWidget|None = ..., showModal: bool = ..., hideParent: bool = ...) -> typing.Tuple[bool, QgsFeature|None]: ...


class QgsTrackedVectorLayerTools(QgsVectorLayerTools):

    def __init__(self) -> None: ...

    def rollback(self) -> None: ...
    def setVectorLayerTools(self, tools: QgsVectorLayerTools|None) -> None: ...
    def copyMoveFeatures(self, layer: QgsVectorLayer|None, request: QgsFeatureRequest, dx: float = ..., dy: float = ..., errorMsg: str|None = ..., topologicalEditing: bool = ..., topologicalLayer: QgsVectorLayer|None = ..., childrenInfoMsg: str|None = ...) -> bool: ...
    def saveEdits(self, layer: QgsVectorLayer|None) -> bool: ...
    def stopEditing(self, layer: QgsVectorLayer|None, allowCancel: bool) -> bool: ...
    def startEditing(self, layer: QgsVectorLayer|None) -> bool: ...
    def addFeatureV2(self, layer: QgsVectorLayer|None, defaultValues: dict[int, typing.Any], defaultGeometry: 'QgsGeometry', context: 'QgsVectorLayerToolsContext') -> typing.Tuple[bool, QgsFeature|None]: ...


class QgsTransaction(QtCore.QObject):

    def __init__(self) -> None: ...

    dirtied: typing.ClassVar[QtCore.pyqtSignal]
    afterRollbackToSavepoint: typing.ClassVar[QtCore.pyqtSignal]
    afterRollback: typing.ClassVar[QtCore.pyqtSignal]
    def lastSavePointIsDirty(self) -> bool: ...
    def savePoints(self) -> list[str]: ...
    def dirtyLastSavePoint(self) -> None: ...
    def rollbackToSavepoint(self, name: str|None) -> typing.Tuple[bool, str]: ...
    @typing.overload
    def createSavepoint(self) -> typing.Tuple[str, str]: ...
    @typing.overload
    def createSavepoint(self, savePointId: str|None) -> typing.Tuple[str, str]: ...
    @staticmethod
    def supportsTransaction(layer: QgsVectorLayer|None) -> bool: ...
    def executeSql(self, sql: str|None, isDirty: bool = ..., name: str|None = ...) -> typing.Tuple[bool, str]: ...
    def rollback(self) -> typing.Tuple[bool, str]: ...
    def commit(self) -> typing.Tuple[bool, str]: ...
    def begin(self, statementTimeout: int = ...) -> typing.Tuple[bool, str]: ...
    def addLayer(self, layer: QgsVectorLayer|None, addLayersInEditMode: bool = ...) -> bool: ...
    def connectionString(self) -> str: ...
    @typing.overload
    @staticmethod
    def create(connString: str|None, providerKey: str|None) -> 'QgsTransaction|None': ...
    @typing.overload
    @staticmethod
    def create(layers: collections.abc.Iterable[QgsVectorLayer]) -> 'QgsTransaction|None': ...


class QgsTransactionGroup(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    commitError: typing.ClassVar[QtCore.pyqtSignal]
    def isEmpty(self) -> bool: ...
    def providerKey(self) -> str: ...
    def connString(self) -> str: ...
    def modified(self) -> bool: ...
    def layers(self) -> set[QgsVectorLayer]: ...
    def addLayer(self, layer: QgsVectorLayer|None) -> bool: ...


class QgsTranslationContext(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTranslationContext') -> None: ...

    def writeTsFile(self, locale: str|None) -> None: ...
    def registerTranslation(self, context: str|None, source: str|None) -> None: ...
    def setFileName(self, fileName: str|None) -> None: ...
    def fileName(self) -> str: ...
    def setProject(self, project: 'QgsProject|None') -> None: ...
    def project(self) -> 'QgsProject|None': ...


class QgsUnitTypes(PyQt6.sip.wrapper):

    class DistanceValue(PyQt6.sip.wrapper):

        unit = ... # type: Qgis.DistanceUnit
        value = ... # type: float

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsUnitTypes.DistanceValue') -> None: ...

    class AreaValue(PyQt6.sip.wrapper):

        unit = ... # type: Qgis.AreaUnit
        value = ... # type: float

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsUnitTypes.AreaValue') -> None: ...

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsUnitTypes') -> None: ...

    @staticmethod
    def decodeLayoutUnit(string: str|None) -> typing.Tuple[Qgis.LayoutUnit, bool]: ...
    @staticmethod
    def decodeRenderUnit(string: str|None) -> typing.Tuple[Qgis.RenderUnit, bool]: ...
    @staticmethod
    def formatArea(area: float, decimals: int, unit: Qgis.AreaUnit, keepBaseUnit: bool = ...) -> str: ...
    @staticmethod
    def formatDistance(distance: float, decimals: int, unit: Qgis.DistanceUnit, keepBaseUnit: bool = ...) -> str: ...
    @staticmethod
    def scaledArea(area: float, unit: Qgis.AreaUnit, decimals: int, keepBaseUnit: bool = ...) -> 'QgsUnitTypes.AreaValue': ...
    @staticmethod
    def scaledDistance(distance: float, unit: Qgis.DistanceUnit, decimals: int, keepBaseUnit: bool = ...) -> 'QgsUnitTypes.DistanceValue': ...
    @staticmethod
    def formatAngle(angle: float, decimals: int, unit: Qgis.AngleUnit) -> str: ...
    @staticmethod
    def decodeAngleUnit(string: str|None) -> typing.Tuple[Qgis.AngleUnit, bool]: ...
    @staticmethod
    def volumeToDistanceUnit(volumeUnit: Qgis.VolumeUnit) -> Qgis.DistanceUnit: ...
    @staticmethod
    def distanceToVolumeUnit(distanceUnit: Qgis.DistanceUnit) -> Qgis.VolumeUnit: ...
    @staticmethod
    def stringToVolumeUnit(string: str|None) -> typing.Tuple[Qgis.VolumeUnit, bool]: ...
    @staticmethod
    def decodeVolumeUnit(string: str|None) -> typing.Tuple[Qgis.VolumeUnit, bool]: ...
    @staticmethod
    def stringToTemporalUnit(string: str|None) -> typing.Tuple[Qgis.TemporalUnit, bool]: ...
    @staticmethod
    def decodeTemporalUnit(string: str|None) -> typing.Tuple[Qgis.TemporalUnit, bool]: ...
    @staticmethod
    def areaToDistanceUnit(areaUnit: Qgis.AreaUnit) -> Qgis.DistanceUnit: ...
    @staticmethod
    def distanceToAreaUnit(distanceUnit: Qgis.DistanceUnit) -> Qgis.AreaUnit: ...
    @staticmethod
    def stringToAreaUnit(string: str|None) -> typing.Tuple[Qgis.AreaUnit, bool]: ...
    @staticmethod
    def decodeAreaUnit(string: str|None) -> typing.Tuple[Qgis.AreaUnit, bool]: ...
    @typing.overload
    @staticmethod
    def fromUnitToUnitFactor(fromUnit: Qgis.DistanceUnit, toUnit: Qgis.DistanceUnit) -> float: ...
    @typing.overload
    @staticmethod
    def fromUnitToUnitFactor(fromUnit: Qgis.AreaUnit, toUnit: Qgis.AreaUnit) -> float: ...
    @typing.overload
    @staticmethod
    def fromUnitToUnitFactor(fromUnit: Qgis.TemporalUnit, toUnit: Qgis.TemporalUnit) -> float: ...
    @typing.overload
    @staticmethod
    def fromUnitToUnitFactor(fromUnit: Qgis.VolumeUnit, toUnit: Qgis.VolumeUnit) -> float: ...
    @typing.overload
    @staticmethod
    def fromUnitToUnitFactor(fromUnit: Qgis.AngleUnit, toUnit: Qgis.AngleUnit) -> float: ...
    @staticmethod
    def stringToDistanceUnit(string: str|None) -> typing.Tuple[Qgis.DistanceUnit, bool]: ...
    @typing.overload
    @staticmethod
    def toAbbreviatedString(unit: Qgis.DistanceUnit) -> str: ...
    @typing.overload
    @staticmethod
    def toAbbreviatedString(unit: Qgis.AreaUnit) -> str: ...
    @typing.overload
    @staticmethod
    def toAbbreviatedString(unit: Qgis.TemporalUnit) -> str: ...
    @typing.overload
    @staticmethod
    def toAbbreviatedString(unit: Qgis.VolumeUnit) -> str: ...
    @typing.overload
    @staticmethod
    def toAbbreviatedString(unit: Qgis.RenderUnit) -> str: ...
    @typing.overload
    @staticmethod
    def toAbbreviatedString(unit: Qgis.LayoutUnit) -> str: ...
    @typing.overload
    @staticmethod
    def toString(unit: Qgis.DistanceUnit) -> str: ...
    @typing.overload
    @staticmethod
    def toString(unit: Qgis.AreaUnit) -> str: ...
    @typing.overload
    @staticmethod
    def toString(unit: Qgis.TemporalUnit) -> str: ...
    @typing.overload
    @staticmethod
    def toString(unit: Qgis.VolumeUnit) -> str: ...
    @typing.overload
    @staticmethod
    def toString(unit: Qgis.AngleUnit) -> str: ...
    @typing.overload
    @staticmethod
    def toString(unit: Qgis.RenderUnit) -> str: ...
    @typing.overload
    @staticmethod
    def toString(unit: Qgis.LayoutUnit) -> str: ...
    @staticmethod
    def decodeDistanceUnit(string: str|None) -> typing.Tuple[Qgis.DistanceUnit, bool]: ...
    @typing.overload
    @staticmethod
    def encodeUnit(unit: Qgis.DistanceUnit) -> str: ...
    @typing.overload
    @staticmethod
    def encodeUnit(unit: Qgis.AreaUnit) -> str: ...
    @typing.overload
    @staticmethod
    def encodeUnit(unit: Qgis.TemporalUnit) -> str: ...
    @typing.overload
    @staticmethod
    def encodeUnit(unit: Qgis.VolumeUnit) -> str: ...
    @typing.overload
    @staticmethod
    def encodeUnit(unit: Qgis.AngleUnit) -> str: ...
    @typing.overload
    @staticmethod
    def encodeUnit(unit: Qgis.RenderUnit) -> str: ...
    @typing.overload
    @staticmethod
    def encodeUnit(unit: Qgis.LayoutUnit) -> str: ...
    @typing.overload
    @staticmethod
    def unitType(unit: Qgis.DistanceUnit) -> Qgis.DistanceUnitType: ...
    @typing.overload
    @staticmethod
    def unitType(unit: Qgis.AreaUnit) -> Qgis.DistanceUnitType: ...
    @typing.overload
    @staticmethod
    def unitType(unit: Qgis.VolumeUnit) -> Qgis.DistanceUnitType: ...
    @typing.overload
    @staticmethod
    def unitType(units: Qgis.LayoutUnit) -> Qgis.LayoutUnitType: ...
    @staticmethod
    def decodeUnitType(string: str|None) -> typing.Tuple[Qgis.UnitType, bool]: ...
    @staticmethod
    def encodeUnitType(type: Qgis.UnitType) -> str: ...


class QgsUnsetAttributeValue(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, defaultValueClause: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsUnsetAttributeValue') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def defaultValueClause(self) -> str: ...


class QgsUserProfile(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, folder: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsUserProfile') -> None: ...

    def icon(self) -> QtGui.QIcon: ...
    def setAlias(self, alias: str|None) -> QgsError: ...
    def alias(self) -> str: ...
    def initSettings(self) -> None: ...
    def name(self) -> str: ...
    def validate(self) -> QgsError: ...
    def folder(self) -> str: ...


class QgsUserProfileManager(QtCore.QObject):

    def __init__(self, rootLocation: str|None = ..., parent: QtCore.QObject|None = ...) -> None: ...

    profilesChanged: typing.ClassVar[QtCore.pyqtSignal]
    def settings(self) -> QtCore.QSettings|None: ...
    def loadUserProfile(self, name: str|None) -> None: ...
    def setActiveUserProfile(self, profile: str|None) -> None: ...
    def userProfile(self) -> QgsUserProfile|None: ...
    def deleteProfile(self, name: str|None) -> QgsError: ...
    def createUserProfile(self, name: str|None) -> QgsError: ...
    def profileForName(self, name: str|None) -> QgsUserProfile|None: ...
    def setUserProfileSelectionPolicy(self, policy: Qgis.UserProfileSelectionPolicy) -> None: ...
    def userProfileSelectionPolicy(self) -> Qgis.UserProfileSelectionPolicy: ...
    def lastProfileName(self) -> str: ...
    def setDefaultFromActive(self) -> None: ...
    def setDefaultProfileName(self, name: str|None) -> None: ...
    def defaultProfileName(self) -> str: ...
    def profileExists(self, name: str|None) -> bool: ...
    def allProfiles(self) -> list[str]: ...
    def rootLocationIsSet(self) -> bool: ...
    def isNewProfileNotificationEnabled(self) -> bool: ...
    def setNewProfileNotificationEnabled(self, enabled: bool) -> None: ...
    def rootLocation(self) -> str: ...
    def setRootLocation(self, rootProfileLocation: str|None) -> None: ...
    def getProfile(self, defaultProfile: str|None = ..., createNew: bool = ..., initSettings: bool = ...) -> QgsUserProfile|None: ...
    @staticmethod
    def resolveProfilesFolder(basePath: str|None = ...) -> str: ...


class QgsVariantUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVariantUtils') -> None: ...

    @staticmethod
    def displayString(variant: typing.Any, precision: int = ...) -> str: ...
    @staticmethod
    def isNumericType(metaType: QtCore.QMetaType.Type) -> bool: ...
    @staticmethod
    def isNull(variant: typing.Any) -> bool: ...
    @typing.overload
    @staticmethod
    def typeToDisplayString(type: QtCore.QMetaType.Type, subType: QtCore.QMetaType.Type = ...) -> str: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def typeToDisplayString(type: typing.Any, subType: typing.Any = ...) -> str: ...


class QgsVector(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVector') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def toString(self, precision: int = ...) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def normalized(self) -> 'QgsVector': ...
    def rotateBy(self, rot: float) -> 'QgsVector': ...
    def crossProduct(self, v: 'QgsVector') -> float: ...
    @typing.overload
    def angle(self) -> float: ...
    @typing.overload
    def angle(self, v: 'QgsVector') -> float: ...
    def perpVector(self) -> 'QgsVector': ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...
    def __isub__(self, other: 'QgsVector') -> 'QgsVector': ...
    def __sub__(self, other: 'QgsVector') -> 'QgsVector': ...
    def __iadd__(self, other: 'QgsVector') -> 'QgsVector': ...
    def __add__(self, other: 'QgsVector') -> 'QgsVector': ...
    def __truediv__(self, scalar: float) -> 'QgsVector': ...
    @typing.overload
    def __mul__(self, scalar: float) -> 'QgsVector': ...
    @typing.overload
    def __mul__(self, v: 'QgsVector') -> float: ...
    def __neg__(self) -> 'QgsVector': ...


class QgsVector3D(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def __init__(self, v: QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVector3D') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def toVector3D(self) -> QtGui.QVector3D: ...
    def toString(self, precision: int = ...) -> str: ...
    @staticmethod
    def perpendicularPoint(v1: 'QgsVector3D', v2: 'QgsVector3D', vp: 'QgsVector3D') -> 'QgsVector3D': ...
    def distance(self, other: 'QgsVector3D') -> float: ...
    def normalize(self) -> None: ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...
    @staticmethod
    def crossProduct(v1: 'QgsVector3D', v2: 'QgsVector3D') -> 'QgsVector3D': ...
    @staticmethod
    def dotProduct(v1: 'QgsVector3D', v2: 'QgsVector3D') -> float: ...
    def __truediv__(self, factor: float) -> 'QgsVector3D': ...
    def __mul__(self, factor: float) -> 'QgsVector3D': ...
    def __neg__(self) -> 'QgsVector3D': ...
    def __sub__(self, other: 'QgsVector3D') -> 'QgsVector3D': ...
    def __iadd__(self, other: 'QgsVector3D') -> 'QgsVector3D': ...
    def __add__(self, other: 'QgsVector3D') -> 'QgsVector3D': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def set(self, x: float, y: float, z: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setX(self, x: float) -> None: ...
    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def isNull(self) -> bool: ...


class QgsVectorFileWriter(QgsFeatureSink):

    class ActionOnExistingFile(enum.IntEnum):
        CreateOrOverwriteFile = ... # type: QgsVectorFileWriter.ActionOnExistingFile
        CreateOrOverwriteLayer = ... # type: QgsVectorFileWriter.ActionOnExistingFile
        AppendToLayerNoNewFields = ... # type: QgsVectorFileWriter.ActionOnExistingFile
        AppendToLayerAddFields = ... # type: QgsVectorFileWriter.ActionOnExistingFile

    class EditionCapability(enum.IntEnum):
        CanAddNewLayer = ... # type: QgsVectorFileWriter.EditionCapability
        CanAppendToExistingLayer = ... # type: QgsVectorFileWriter.EditionCapability
        CanAddNewFieldsToExistingLayer = ... # type: QgsVectorFileWriter.EditionCapability
        CanDeleteLayer = ... # type: QgsVectorFileWriter.EditionCapability

    class VectorFormatOption(enum.IntEnum):
        SortRecommended = ... # type: QgsVectorFileWriter.VectorFormatOption
        SkipNonSpatialFormats = ... # type: QgsVectorFileWriter.VectorFormatOption
        SupportsMultipleLayers = ... # type: QgsVectorFileWriter.VectorFormatOption

    class FieldNameSource(enum.IntEnum):
        Original = ... # type: QgsVectorFileWriter.FieldNameSource
        PreferAlias = ... # type: QgsVectorFileWriter.FieldNameSource

    class WriterError(enum.IntEnum):
        NoError = ... # type: QgsVectorFileWriter.WriterError
        ErrDriverNotFound = ... # type: QgsVectorFileWriter.WriterError
        ErrCreateDataSource = ... # type: QgsVectorFileWriter.WriterError
        ErrCreateLayer = ... # type: QgsVectorFileWriter.WriterError
        ErrAttributeTypeUnsupported = ... # type: QgsVectorFileWriter.WriterError
        ErrAttributeCreationFailed = ... # type: QgsVectorFileWriter.WriterError
        ErrProjection = ... # type: QgsVectorFileWriter.WriterError
        ErrFeatureWriteFailed = ... # type: QgsVectorFileWriter.WriterError
        ErrInvalidLayer = ... # type: QgsVectorFileWriter.WriterError
        ErrSavingMetadata = ... # type: QgsVectorFileWriter.WriterError
        Canceled = ... # type: QgsVectorFileWriter.WriterError

    class OptionType(enum.IntEnum):
        Set = ... # type: QgsVectorFileWriter.OptionType
        String = ... # type: QgsVectorFileWriter.OptionType
        Int = ... # type: QgsVectorFileWriter.OptionType
        Hidden = ... # type: QgsVectorFileWriter.OptionType

    class Option(PyQt6.sip.wrapper):

        docString = ... # type: str|None
        type = ... # type: 'QgsVectorFileWriter.OptionType'

        @typing.overload
        def __init__(self, docString: str|None, type: 'QgsVectorFileWriter.OptionType') -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorFileWriter.Option') -> None: ...

    class SetOption('QgsVectorFileWriter.Option'):

        allowNone = ... # type: bool
        defaultValue = ... # type: str|None
        values = ... # type: collections.abc.Iterable[str|None]

        @typing.overload
        def __init__(self, docString: str|None, values: collections.abc.Iterable[str|None], defaultValue: str|None, allowNone: bool = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorFileWriter.SetOption') -> None: ...

    class StringOption('QgsVectorFileWriter.Option'):

        defaultValue = ... # type: str|None

        @typing.overload
        def __init__(self, docString: str|None, defaultValue: str|None = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorFileWriter.StringOption') -> None: ...

    class IntOption('QgsVectorFileWriter.Option'):

        defaultValue = ... # type: int

        @typing.overload
        def __init__(self, docString: str|None, defaultValue: int) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorFileWriter.IntOption') -> None: ...

    class BoolOption('QgsVectorFileWriter.SetOption'):

        @typing.overload
        def __init__(self, docString: str|None, defaultValue: bool) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorFileWriter.BoolOption') -> None: ...

    class HiddenOption('QgsVectorFileWriter.Option'):

        mValue = ... # type: str|None

        @typing.overload
        def __init__(self, value: str|None) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorFileWriter.HiddenOption') -> None: ...

    class MetaData(PyQt6.sip.wrapper):

        compulsoryEncoding = ... # type: str|None
        driverOptions = ... # type: typing.Any
        ext = ... # type: str|None
        glob = ... # type: str|None
        layerOptions = ... # type: typing.Any
        longName = ... # type: str|None
        trLongName = ... # type: str|None

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, longName: str|None, trLongName: str|None, glob: str|None, ext: str|None, driverOptions: typing.Any, layerOptions: typing.Any, compulsoryEncoding: str|None = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorFileWriter.MetaData') -> None: ...

    class FieldValueConverter(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorFileWriter.FieldValueConverter') -> None: ...

        def clone(self) -> 'QgsVectorFileWriter.FieldValueConverter|None': ...
        def convert(self, fieldIdxInLayer: int, value: typing.Any) -> typing.Any: ...
        def fieldDefinition(self, field: QgsField) -> QgsField: ...

    class SaveVectorOptions(PyQt6.sip.wrapper):

        actionOnExistingFile = ... # type: 'QgsVectorFileWriter.ActionOnExistingFile'
        attributes = ... # type: collections.abc.Iterable[int]
        attributesExportNames = ... # type: collections.abc.Iterable[str|None]
        ct = ... # type: 'QgsCoordinateTransform'
        datasourceOptions = ... # type: collections.abc.Iterable[str|None]
        driverName = ... # type: str|None
        feedback = ... # type: QgsFeedback
        fieldNameSource = ... # type: 'QgsVectorFileWriter.FieldNameSource'
        fieldValueConverter = ... # type: 'QgsVectorFileWriter.FieldValueConverter'
        fileEncoding = ... # type: str|None
        filterExtent = ... # type: 'QgsRectangle'
        forceMulti = ... # type: bool
        includeConstraints = ... # type: bool
        includeZ = ... # type: bool
        layerMetadata = ... # type: 'QgsLayerMetadata'
        layerName = ... # type: str|None
        layerOptions = ... # type: collections.abc.Iterable[str|None]
        onlySelectedFeatures = ... # type: bool
        overrideGeometryType = ... # type: Qgis.WkbType
        saveMetadata = ... # type: bool
        setFieldDomains = ... # type: bool
        skipAttributeCreation = ... # type: bool
        sourceDatabaseProviderConnection = ... # type: 'QgsAbstractDatabaseProviderConnection'
        symbologyExport = ... # type: Qgis.FeatureSymbologyExport
        symbologyScale = ... # type: float

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorFileWriter.SaveVectorOptions') -> None: ...

    class FilterFormatDetails(PyQt6.sip.wrapper):

        driverName = ... # type: str|None
        filterString = ... # type: str|None
        globs = ... # type: collections.abc.Iterable[str|None]

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorFileWriter.FilterFormatDetails') -> None: ...

    class DriverDetails(PyQt6.sip.wrapper):

        driverName = ... # type: str|None
        longName = ... # type: str|None

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVectorFileWriter.DriverDetails') -> None: ...

    @deprecated("""""")
    def __init__(self, vectorFileName: str|None, fileEncoding: str|None, fields: QgsFields, geometryType: Qgis.WkbType, srs: 'QgsCoordinateReferenceSystem' = ..., driverName: str|None = ..., datasourceOptions: collections.abc.Iterable[str|None] = ..., layerOptions: collections.abc.Iterable[str|None] = ..., newFilename: str|None = ..., symbologyExport: Qgis.FeatureSymbologyExport = ..., sinkFlags: QgsFeatureSink.SinkFlag = ...) -> None: ...

    @staticmethod
    def areThereNewFieldsToCreate(datasetName: str|None, layerName: str|None, layer: QgsVectorLayer|None, attributes: collections.abc.Iterable[int]) -> bool: ...
    @staticmethod
    def targetLayerExists(datasetName: str|None, layerName: str|None) -> bool: ...
    @staticmethod
    def editionCapabilities(datasetName: str|None) -> 'QgsVectorFileWriter.EditionCapability': ...
    @staticmethod
    def defaultLayerOptions(driverName: str|None) -> list[str]: ...
    @staticmethod
    def defaultDatasetOptions(driverName: str|None) -> list[str]: ...
    @staticmethod
    def driverMetadata(driverName: str|None, driverMetadata: 'QgsVectorFileWriter.MetaData') -> bool: ...
    def setSymbologyScale(self, scale: float) -> None: ...
    def symbologyScale(self) -> float: ...
    def setSymbologyExport(self, symExport: Qgis.FeatureSymbologyExport) -> None: ...
    def symbologyExport(self) -> Qgis.FeatureSymbologyExport: ...
    @staticmethod
    def deleteShapeFile(fileName: str|None) -> bool: ...
    def sourceFieldIndexToWriterFieldIndex(self) -> typing.Any: ...
    def addFeatureWithStyle(self, feature: QgsFeature, renderer: 'QgsFeatureRenderer|None', outputUnit: Qgis.DistanceUnit = ...) -> bool: ...
    def lastError(self) -> str: ...
    def addFeatures(self, features: collections.abc.Iterable[QgsFeature], flags: QgsFeatureSink.Flag = ...) -> bool: ...
    def addFeature(self, feature: QgsFeature, flags: QgsFeatureSink.Flag = ...) -> bool: ...
    def capabilities(self) -> Qgis.VectorFileWriterCapability: ...
    def driverLongName(self) -> str: ...
    def driver(self) -> str: ...
    def errorMessage(self) -> str: ...
    def hasError(self) -> 'QgsVectorFileWriter.WriterError': ...
    @staticmethod
    def convertCodecNameForEncodingOption(codecName: str|None) -> str: ...
    @staticmethod
    def filterForDriver(driverName: str|None) -> str: ...
    @staticmethod
    def fileFilterString(options: 'QgsVectorFileWriter.VectorFormatOption' = ...) -> str: ...
    @staticmethod
    def driverForExtension(extension: str|None) -> str: ...
    @staticmethod
    def ogrDriverList(options: 'QgsVectorFileWriter.VectorFormatOption' = ...) -> list['QgsVectorFileWriter.DriverDetails']: ...
    @staticmethod
    def supportsFeatureStyles(driverName: str|None) -> bool: ...
    @staticmethod
    def supportedFormatExtensions(options: 'QgsVectorFileWriter.VectorFormatOption' = ...) -> list[str]: ...
    @staticmethod
    def supportedFiltersAndFormats(options: 'QgsVectorFileWriter.VectorFormatOption' = ...) -> list['QgsVectorFileWriter.FilterFormatDetails']: ...
    @staticmethod
    def writeAsVectorFormatV3(layer: QgsVectorLayer|None, fileName: str|None, transformContext: 'QgsCoordinateTransformContext', options: 'QgsVectorFileWriter.SaveVectorOptions') -> typing.Tuple['QgsVectorFileWriter.WriterError', str, str, str]: ...
    @staticmethod
    @deprecated("""""")
    def writeAsVectorFormatV2(layer: QgsVectorLayer|None, fileName: str|None, transformContext: 'QgsCoordinateTransformContext', options: 'QgsVectorFileWriter.SaveVectorOptions', newFilename: str|None = ..., newLayer: str|None = ...) -> typing.Tuple['QgsVectorFileWriter.WriterError', str]: ...
    @staticmethod
    def create(fileName: str|None, fields: QgsFields, geometryType: Qgis.WkbType, srs: 'QgsCoordinateReferenceSystem', transformContext: 'QgsCoordinateTransformContext', options: 'QgsVectorFileWriter.SaveVectorOptions', sinkFlags: QgsFeatureSink.SinkFlag = ..., newFilename: str|None = ..., newLayer: str|None = ...) -> 'QgsVectorFileWriter|None': ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def writeAsVectorFormat(layer: QgsVectorLayer|None, fileName: str|None, fileEncoding: str|None, destCRS: 'QgsCoordinateReferenceSystem' = ..., driverName: str|None = ..., onlySelected: bool = ..., datasourceOptions: collections.abc.Iterable[str|None] = ..., layerOptions: collections.abc.Iterable[str|None] = ..., skipAttributeCreation: bool = ..., newFilename: str|None = ..., symbologyExport: Qgis.FeatureSymbologyExport = ..., symbologyScale: float = ..., filterExtent: 'QgsRectangle|None' = ..., overrideGeometryType: Qgis.WkbType = ..., forceMulti: bool = ..., includeZ: bool = ..., attributes: collections.abc.Iterable[int] = ..., fieldValueConverter: 'QgsVectorFileWriter.FieldValueConverter|None' = ...) -> typing.Tuple['QgsVectorFileWriter.WriterError', str]: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def writeAsVectorFormat(layer: QgsVectorLayer|None, fileName: str|None, fileEncoding: str|None, ct: 'QgsCoordinateTransform', driverName: str|None = ..., onlySelected: bool = ..., datasourceOptions: collections.abc.Iterable[str|None] = ..., layerOptions: collections.abc.Iterable[str|None] = ..., skipAttributeCreation: bool = ..., newFilename: str|None = ..., symbologyExport: Qgis.FeatureSymbologyExport = ..., symbologyScale: float = ..., filterExtent: 'QgsRectangle|None' = ..., overrideGeometryType: Qgis.WkbType = ..., forceMulti: bool = ..., includeZ: bool = ..., attributes: collections.abc.Iterable[int] = ..., fieldValueConverter: 'QgsVectorFileWriter.FieldValueConverter|None' = ...) -> typing.Tuple['QgsVectorFileWriter.WriterError', str]: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def writeAsVectorFormat(layer: QgsVectorLayer|None, fileName: str|None, options: 'QgsVectorFileWriter.SaveVectorOptions', newFilename: str|None = ...) -> typing.Tuple['QgsVectorFileWriter.WriterError', str]: ...


class QgsVectorFileWriterTask(QgsTask):

    def __init__(self, layer: QgsVectorLayer|None, fileName: str|None, options: QgsVectorFileWriter.SaveVectorOptions, sinkFlags: QgsFeatureSink.SinkFlag = ...) -> None: ...

    def finished(self, result: bool) -> None: ...
    def run(self) -> bool: ...
    errorOccurred: typing.ClassVar[QtCore.pyqtSignal]
    writeComplete: typing.ClassVar[QtCore.pyqtSignal]
    def cancel(self) -> None: ...


class QgsVectorSimplifyMethod(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVectorSimplifyMethod') -> None: ...

    def maximumScale(self) -> float: ...
    def setMaximumScale(self, maximumScale: float) -> None: ...
    def forceLocalOptimization(self) -> bool: ...
    def setForceLocalOptimization(self, localOptimization: bool) -> None: ...
    def threshold(self) -> float: ...
    def setThreshold(self, threshold: float) -> None: ...
    def tolerance(self) -> float: ...
    def setTolerance(self, tolerance: float) -> None: ...
    def simplifyAlgorithm(self) -> Qgis.VectorSimplificationAlgorithm: ...
    def setSimplifyAlgorithm(self, simplifyAlgorithm: Qgis.VectorSimplificationAlgorithm) -> None: ...
    def simplifyHints(self) -> Qgis.VectorRenderingSimplificationFlag: ...
    def setSimplifyHints(self, simplifyHints: Qgis.VectorRenderingSimplificationFlag) -> None: ...


class QgsVirtualLayerDefinition(PyQt6.sip.wrapper):

    class SourceLayer(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self, name: str|None, ref: str|None) -> None: ...
        @typing.overload
        def __init__(self, name: str|None, source: str|None, provider: str|None, encoding: str|None) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsVirtualLayerDefinition.SourceLayer') -> None: ...

        def encoding(self) -> str: ...
        def source(self) -> str: ...
        def provider(self) -> str: ...
        def name(self) -> str: ...
        def reference(self) -> str: ...
        def isReferenced(self) -> bool: ...

    @typing.overload
    def __init__(self, filePath: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVirtualLayerDefinition') -> None: ...

    def setSubsetString(self, subsetString: str|None) -> None: ...
    def subsetString(self) -> str: ...
    def hasDefinedGeometry(self) -> bool: ...
    def hasReferencedLayers(self) -> bool: ...
    def hasSourceLayer(self, name: str|None) -> bool: ...
    def setFields(self, fields: QgsFields) -> None: ...
    def fields(self) -> QgsFields: ...
    def setGeometrySrid(self, srid: int) -> None: ...
    def geometrySrid(self) -> int: ...
    def setGeometryWkbType(self, t: Qgis.WkbType) -> None: ...
    def geometryWkbType(self) -> Qgis.WkbType: ...
    def setGeometryField(self, geometryField: str|None) -> None: ...
    def geometryField(self) -> str: ...
    def isLazy(self) -> bool: ...
    def setLazy(self, lazy: bool) -> None: ...
    def setUid(self, uid: str|None) -> None: ...
    def uid(self) -> str: ...
    def setFilePath(self, filePath: str|None) -> None: ...
    def filePath(self) -> str: ...
    def setQuery(self, query: str|None) -> None: ...
    def query(self) -> str: ...
    def sourceLayers(self) -> list['QgsVirtualLayerDefinition.SourceLayer']: ...
    @typing.overload
    def addSource(self, name: str|None, ref: str|None) -> None: ...
    @typing.overload
    def addSource(self, name: str|None, source: str|None, provider: str|None, encoding: str|None = ...) -> None: ...
    def toString(self) -> str: ...
    def toUrl(self) -> QtCore.QUrl: ...
    @staticmethod
    def fromUrl(url: QtCore.QUrl) -> 'QgsVirtualLayerDefinition': ...


class QgsVirtualLayerDefinitionUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVirtualLayerDefinitionUtils') -> None: ...

    @staticmethod
    def fromJoinedLayer(joinedLayer: QgsVectorLayer|None) -> QgsVirtualLayerDefinition: ...


class QgsVirtualLayerTask(QgsTask):

    def __init__(self, definition: QgsVirtualLayerDefinition) -> None: ...

    def setExceptionText(self, exceptionText: str|None) -> None: ...
    def exceptionText(self) -> str: ...
    def cancel(self) -> None: ...
    def run(self) -> bool: ...
    def definition(self) -> QgsVirtualLayerDefinition: ...
    def takeLayer(self) -> QgsVectorLayer|None: ...
    def layer(self) -> QgsVectorLayer|None: ...


class QgsWmsUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsWmsUtils') -> None: ...

    @staticmethod
    def wmsVersion(layer: 'QgsRasterLayer|None') -> str: ...
    @staticmethod
    def isWmsLayer(layer: QgsMapLayer|None) -> bool: ...


class QgsXmlUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsXmlUtils') -> None: ...

    @staticmethod
    def readVariant(element: QtXml.QDomElement) -> typing.Any: ...
    @staticmethod
    def writeVariant(value: typing.Any, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    @staticmethod
    def writeRectangle(rect: 'QgsRectangle', doc: QtXml.QDomDocument, elementName: str|None = ...) -> QtXml.QDomElement: ...
    @staticmethod
    def writeBox3D(box: 'QgsBox3D', doc: QtXml.QDomDocument, elementName: str|None = ...) -> QtXml.QDomElement: ...
    @staticmethod
    def writeMapUnits(units: Qgis.DistanceUnit, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    @staticmethod
    def readBox3D(element: QtXml.QDomElement) -> 'QgsBox3D': ...
    @staticmethod
    def readRectangle(element: QtXml.QDomElement) -> 'QgsRectangle': ...
    @staticmethod
    def readMapUnits(element: QtXml.QDomElement) -> Qgis.DistanceUnit: ...


class QgsZipUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsZipUtils') -> None: ...

    @staticmethod
    def extractFileFromZip(zipFilename: str|None, filenameInZip: str|None) -> typing.Tuple[bool, QtCore.QByteArray]: ...
    @staticmethod
    def files(zip: str|None) -> list[str]: ...
    @staticmethod
    def zip(zip: str|None, files: collections.abc.Iterable[str|None], overwrite: bool = ...) -> bool: ...
    @staticmethod
    def unzip(zip: str|None, dir: str|None, checkConsistency: bool = ...) -> typing.Tuple[bool, list[str]]: ...
    @staticmethod
    def isZipFile(filename: str|None) -> bool: ...


class Qgs3DRendererAbstractMetadata(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, type: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'Qgs3DRendererAbstractMetadata') -> None: ...

    def createRenderer(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> 'QgsAbstract3DRenderer|None': ...
    def type(self) -> str: ...


class Qgs3DRendererRegistry(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'Qgs3DRendererRegistry') -> None: ...

    def renderersList(self) -> list[str]: ...
    def rendererMetadata(self, type: str|None) -> Qgs3DRendererAbstractMetadata|None: ...
    def removeRenderer(self, type: str|None) -> None: ...
    def addRenderer(self, metadata: Qgs3DRendererAbstractMetadata|None) -> None: ...


class Qgs3DSymbolAbstractMetadata(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, type: str|None, visibleName: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'Qgs3DSymbolAbstractMetadata') -> None: ...

    def create(self) -> 'QgsAbstract3DSymbol|None': ...
    def visibleName(self) -> str: ...
    def type(self) -> str: ...


class Qgs3DSymbolRegistry(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def defaultSymbolForGeometryType(self, type: Qgis.GeometryType) -> 'QgsAbstract3DSymbol|None': ...
    def createSymbol(self, type: str|None) -> 'QgsAbstract3DSymbol|None': ...
    def addSymbolType(self, metadata: Qgs3DSymbolAbstractMetadata|None) -> bool: ...
    def symbolTypes(self) -> list[str]: ...
    def symbolMetadata(self, type: str|None) -> Qgs3DSymbolAbstractMetadata|None: ...


class QgsAbstract3DSymbol(PyQt6.sip.wrapper):

    class Property(enum.IntEnum):
        Height = ... # type: QgsAbstract3DSymbol.Property
        ExtrusionHeight = ... # type: QgsAbstract3DSymbol.Property

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstract3DSymbol') -> None: ...

    def copyBaseSettings(self, destination: 'QgsAbstract3DSymbol|None') -> None: ...
    def setDefaultPropertiesFromLayer(self, layer: QgsVectorLayer|None) -> None: ...
    def setDataDefinedProperties(self, collection: QgsPropertyCollection) -> None: ...
    def dataDefinedProperties(self) -> QgsPropertyCollection: ...
    @staticmethod
    def propertyDefinitions() -> dict[int, QgsPropertyDefinition]: ...
    def compatibleGeometryTypes(self) -> list[Qgis.GeometryType]: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def clone(self) -> 'QgsAbstract3DSymbol|None': ...
    def type(self) -> str: ...


class QgsAbstract3DRenderer(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def resolveReferences(self, project: 'QgsProject') -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def clone(self) -> 'QgsAbstract3DRenderer|None': ...
    def type(self) -> str: ...


class QgsAbstractPointCloud3DRenderer(QgsAbstract3DRenderer):

    def __init__(self) -> None: ...

    def convertFrom2DRenderer(self, renderer: 'QgsPointCloudRenderer|None') -> bool: ...


class QgsAction(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, type: Qgis.AttributeActionType, description: str|None, command: str|None, capture: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, type: Qgis.AttributeActionType, description: str|None, action: str|None, icon: str|None, capture: bool, shortTitle: str|None = ..., actionScopes: collections.abc.Iterable[str|None] = ..., notificationMessage: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, id: QtCore.QUuid, type: Qgis.AttributeActionType, description: str|None, action: str|None, icon: str|None, capture: bool, shortTitle: str|None = ..., actionScopes: collections.abc.Iterable[str|None] = ..., notificationMessage: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAction') -> None: ...

    def setCommand(self, newCommand: str|None) -> None: ...
    def html(self) -> str: ...
    def expressionContextScope(self) -> QgsExpressionContextScope: ...
    def setExpressionContextScope(self, scope: QgsExpressionContextScope) -> None: ...
    def writeXml(self, actionsNode: QtXml.QDomNode) -> None: ...
    def readXml(self, actionNode: QtXml.QDomNode, context: QgsReadWriteContext = ...) -> None: ...
    def setActionScopes(self, actionScopes: collections.abc.Iterable[str|None]) -> None: ...
    def actionScopes(self) -> set[str]: ...
    @typing.overload
    def run(self, layer: QgsVectorLayer|None, feature: QgsFeature, expressionContext: QgsExpressionContext) -> None: ...
    @typing.overload
    def run(self, expressionContext: QgsExpressionContext) -> None: ...
    def runable(self) -> bool: ...
    def setEnabledOnlyWhenEditable(self, enable: bool) -> None: ...
    def isEnabledOnlyWhenEditable(self) -> bool: ...
    def capture(self) -> bool: ...
    def type(self) -> Qgis.AttributeActionType: ...
    def notificationMessage(self) -> str: ...
    def command(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def iconPath(self) -> str: ...
    def isValid(self) -> bool: ...
    def id(self) -> QtCore.QUuid: ...
    def shortTitle(self) -> str: ...
    def name(self) -> str: ...


class QgsActionManager(QtCore.QObject):

    def __init__(self, layer: QgsVectorLayer|None) -> None: ...

    def defaultAction(self, actionScope: str|None) -> QgsAction: ...
    def setDefaultAction(self, actionScope: str|None, actionId: QtCore.QUuid) -> None: ...
    @typing.overload
    def action(self, id: QtCore.QUuid) -> QgsAction: ...
    @typing.overload
    def action(self, id: str|None) -> QgsAction: ...
    def readXml(self, layer_node: QtXml.QDomNode, context: QgsReadWriteContext = ...) -> bool: ...
    def writeXml(self, layer_node: QtXml.QDomNode) -> bool: ...
    def layer(self) -> QgsVectorLayer|None: ...
    def actions(self, actionScope: str|None = ...) -> list[QgsAction]: ...
    def clearActions(self) -> None: ...
    def doAction(self, actionId: QtCore.QUuid, feature: QgsFeature, context: QgsExpressionContext) -> None: ...
    def doActionFeature(self, actionId: QtCore.QUuid, feature: QgsFeature, defaultValueIndex: int = ..., scope: QgsExpressionContextScope = ...) -> None: ...
    def removeAction(self, actionId: QtCore.QUuid) -> None: ...
    @typing.overload
    def addAction(self, type: Qgis.AttributeActionType, name: str|None, command: str|None, capture: bool = ...) -> QtCore.QUuid: ...
    @typing.overload
    def addAction(self, type: Qgis.AttributeActionType, name: str|None, command: str|None, icon: str|None, capture: bool = ...) -> QtCore.QUuid: ...
    @typing.overload
    def addAction(self, action: QgsAction) -> None: ...


class QgsActionScope(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, id: str|None, title: str|None, description: str|None, expressionContextScope: QgsExpressionContextScope = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsActionScope') -> None: ...

    def __ne__(self, other: object): ...
    def __hash__(self) -> int: ...
    def isValid(self) -> bool: ...
    def setDescription(self, description: str|None) -> None: ...
    def description(self) -> str: ...
    def setTitle(self, title: str|None) -> None: ...
    def title(self) -> str: ...
    def setId(self, id: str|None) -> None: ...
    def id(self) -> str: ...
    def setExpressionContextScope(self, expressionContextScope: QgsExpressionContextScope) -> None: ...
    def expressionContextScope(self) -> QgsExpressionContextScope: ...
    def __eq__(self, other: object): ...


class QgsActionScopeRegistry(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    actionScopesChanged: typing.ClassVar[QtCore.pyqtSignal]
    def actionScope(self, id: str|None) -> QgsActionScope: ...
    def unregisterActionScope(self, actionScope: QgsActionScope) -> None: ...
    def registerActionScope(self, actionScope: QgsActionScope) -> None: ...
    def actionScopes(self) -> set[QgsActionScope]: ...


class QgsAnnotation(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def copyCommonProperties(self, target: 'QgsAnnotation|None') -> None: ...
    def _readXml(self, annotationElem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def _writeXml(self, itemElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def minimumFrameSize(self) -> QtCore.QSizeF: ...
    def renderAnnotation(self, context: QgsRenderContext, size: QtCore.QSizeF) -> None: ...
    mapLayerChanged: typing.ClassVar[QtCore.pyqtSignal]
    moved: typing.ClassVar[QtCore.pyqtSignal]
    appearanceChanged: typing.ClassVar[QtCore.pyqtSignal]
    def accept(self, visitor: 'QgsStyleEntityVisitorInterface|None') -> bool: ...
    def setAssociatedFeature(self, feature: QgsFeature) -> None: ...
    def associatedFeature(self) -> QgsFeature: ...
    def setMapLayer(self, layer: QgsMapLayer|None) -> None: ...
    def mapLayer(self) -> QgsMapLayer|None: ...
    def markerSymbol(self) -> 'QgsMarkerSymbol|None': ...
    def setMarkerSymbol(self, symbol: 'QgsMarkerSymbol|None') -> None: ...
    def readXml(self, itemElem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def render(self, context: QgsRenderContext) -> None: ...
    def fillSymbol(self) -> 'QgsFillSymbol|None': ...
    def setFillSymbol(self, symbol: 'QgsFillSymbol|None') -> None: ...
    def contentsMargin(self) -> QgsMargins: ...
    def setContentsMargin(self, margins: QgsMargins) -> None: ...
    def frameSizeMm(self) -> QtCore.QSizeF: ...
    def setFrameSizeMm(self, size: QtCore.QSizeF) -> None: ...
    @deprecated("""""")
    def frameSize(self) -> QtCore.QSizeF: ...
    @deprecated("""""")
    def setFrameSize(self, size: QtCore.QSizeF) -> None: ...
    def frameOffsetFromReferencePointMm(self) -> QtCore.QPointF: ...
    def setFrameOffsetFromReferencePointMm(self, offset: QtCore.QPointF) -> None: ...
    @deprecated("""""")
    def frameOffsetFromReferencePoint(self) -> QtCore.QPointF: ...
    @deprecated("""""")
    def setFrameOffsetFromReferencePoint(self, offset: QtCore.QPointF) -> None: ...
    def setRelativePosition(self, position: QtCore.QPointF) -> None: ...
    def relativePosition(self) -> QtCore.QPointF: ...
    def setMapPositionCrs(self, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    def mapPositionCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def setMapPosition(self, position: QgsPointXY) -> None: ...
    def mapPosition(self) -> QgsPointXY: ...
    def setHasFixedMapPosition(self, fixed: bool) -> None: ...
    def hasFixedMapPosition(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def clone(self) -> 'QgsAnnotation|None': ...


class QgsAnnotationItem(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def renderCallout(self, context: QgsRenderContext, rect: QtCore.QRectF, angle: float, calloutContext: 'QgsCallout.QgsCalloutContext', feedback: QgsFeedback|None) -> None: ...
    def readCommonProperties(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def writeCommonProperties(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def copyCommonProperties(self, other: 'QgsAnnotationItem|None') -> None: ...
    def setOffsetFromCalloutUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def offsetFromCalloutUnit(self) -> Qgis.RenderUnit: ...
    def setOffsetFromCallout(self, offset: QtCore.QSizeF) -> None: ...
    def offsetFromCallout(self) -> QtCore.QSizeF: ...
    def setCalloutAnchor(self, anchor: 'QgsGeometry') -> None: ...
    def calloutAnchor(self) -> 'QgsGeometry': ...
    def setCallout(self, callout: 'QgsCallout|None') -> None: ...
    def callout(self) -> 'QgsCallout|None': ...
    def setSymbologyReferenceScale(self, scale: float) -> None: ...
    def symbologyReferenceScale(self) -> float: ...
    def setUseSymbologyReferenceScale(self, enabled: bool) -> None: ...
    def useSymbologyReferenceScale(self) -> bool: ...
    def nodesV2(self, context: 'QgsAnnotationItemEditContext') -> list['QgsAnnotationItemNode']: ...
    @deprecated("""""")
    def nodes(self) -> list['QgsAnnotationItemNode']: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def setZIndex(self, index: int) -> None: ...
    def zIndex(self) -> int: ...
    def transientEditResultsV2(self, operation: 'QgsAbstractAnnotationItemEditOperation|None', context: 'QgsAnnotationItemEditContext') -> 'QgsAnnotationItemEditOperationTransientResults|None': ...
    def transientEditResults(self, operation: 'QgsAbstractAnnotationItemEditOperation|None') -> 'QgsAnnotationItemEditOperationTransientResults|None': ...
    def applyEditV2(self, operation: 'QgsAbstractAnnotationItemEditOperation|None', context: 'QgsAnnotationItemEditContext') -> Qgis.AnnotationItemEditOperationResult: ...
    @deprecated("""""")
    def applyEdit(self, operation: 'QgsAbstractAnnotationItemEditOperation|None') -> Qgis.AnnotationItemEditOperationResult: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def render(self, context: QgsRenderContext, feedback: QgsFeedback|None) -> None: ...
    @typing.overload
    def boundingBox(self) -> 'QgsRectangle': ...
    @typing.overload
    def boundingBox(self, context: QgsRenderContext) -> 'QgsRectangle': ...
    def type(self) -> str: ...
    def clone(self) -> 'QgsAnnotationItem|None': ...
    def flags(self) -> Qgis.AnnotationItemFlag: ...


class QgsAnnotationItemEditContext(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAnnotationItemEditContext') -> None: ...

    def setRenderContext(self, context: QgsRenderContext) -> None: ...
    def renderContext(self) -> QgsRenderContext: ...
    def setCurrentItemBounds(self, bounds: 'QgsRectangle') -> None: ...
    def currentItemBounds(self) -> 'QgsRectangle': ...


class QgsAbstractAnnotationItemEditOperation(PyQt6.sip.wrapper):

    class Type(enum.IntEnum):
        MoveNode = ... # type: QgsAbstractAnnotationItemEditOperation.Type
        DeleteNode = ... # type: QgsAbstractAnnotationItemEditOperation.Type
        AddNode = ... # type: QgsAbstractAnnotationItemEditOperation.Type
        TranslateItem = ... # type: QgsAbstractAnnotationItemEditOperation.Type
        RotateItem = ... # type: QgsAbstractAnnotationItemEditOperation.Type

    @typing.overload
    def __init__(self, itemId: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractAnnotationItemEditOperation') -> None: ...

    def itemId(self) -> str: ...
    def type(self) -> 'QgsAbstractAnnotationItemEditOperation.Type': ...


class QgsAnnotationItemEditOperationMoveNode(QgsAbstractAnnotationItemEditOperation):

    @typing.overload
    def __init__(self, itemId: str|None, nodeId: 'QgsVertexId', before: 'QgsPoint', after: 'QgsPoint', translatePixelsX: float = ..., translatePixelsY: float = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAnnotationItemEditOperationMoveNode') -> None: ...

    def translationYPixels(self) -> float: ...
    def translationXPixels(self) -> float: ...
    def after(self) -> 'QgsPoint': ...
    def before(self) -> 'QgsPoint': ...
    def nodeId(self) -> 'QgsVertexId': ...
    def type(self) -> QgsAbstractAnnotationItemEditOperation.Type: ...


class QgsAnnotationItemEditOperationDeleteNode(QgsAbstractAnnotationItemEditOperation):

    @typing.overload
    def __init__(self, itemId: str|None, nodeId: 'QgsVertexId', before: 'QgsPoint') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAnnotationItemEditOperationDeleteNode') -> None: ...

    def before(self) -> 'QgsPoint': ...
    def nodeId(self) -> 'QgsVertexId': ...
    def type(self) -> QgsAbstractAnnotationItemEditOperation.Type: ...


class QgsAnnotationItemEditOperationAddNode(QgsAbstractAnnotationItemEditOperation):

    @typing.overload
    def __init__(self, itemId: str|None, point: 'QgsPoint') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAnnotationItemEditOperationAddNode') -> None: ...

    def point(self) -> 'QgsPoint': ...
    def type(self) -> QgsAbstractAnnotationItemEditOperation.Type: ...


class QgsAnnotationItemEditOperationTranslateItem(QgsAbstractAnnotationItemEditOperation):

    @typing.overload
    def __init__(self, itemId: str|None, translateX: float, translateY: float, translatePixelsX: float = ..., translatePixelsY: float = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAnnotationItemEditOperationTranslateItem') -> None: ...

    def translationYPixels(self) -> float: ...
    def translationXPixels(self) -> float: ...
    def translationY(self) -> float: ...
    def translationX(self) -> float: ...
    def nodeId(self) -> 'QgsVertexId': ...
    def type(self) -> QgsAbstractAnnotationItemEditOperation.Type: ...


class QgsAnnotationItemEditOperationRotateItem(QgsAbstractAnnotationItemEditOperation):

    @typing.overload
    def __init__(self, itemId: str|None, angle: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAnnotationItemEditOperationRotateItem') -> None: ...

    def angle(self) -> float: ...
    def type(self) -> QgsAbstractAnnotationItemEditOperation.Type: ...


class QgsAnnotationItemEditOperationTransientResults(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, representativeGeometry: 'QgsGeometry') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAnnotationItemEditOperationTransientResults') -> None: ...

    def representativeGeometry(self) -> 'QgsGeometry': ...


class QgsAnnotationItemNode(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, id: 'QgsVertexId', point: QgsPointXY, type: Qgis.AnnotationItemNodeType, cursor: QtCore.Qt.CursorShape = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAnnotationItemNode') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def setCursor(self, shape: QtCore.Qt.CursorShape) -> None: ...
    def cursor(self) -> QtCore.Qt.CursorShape: ...
    def setType(self, type: Qgis.AnnotationItemNodeType) -> None: ...
    def type(self) -> Qgis.AnnotationItemNodeType: ...
    def setPoint(self, point: QgsPointXY) -> None: ...
    def point(self) -> QgsPointXY: ...
    def id(self) -> 'QgsVertexId': ...
    def __repr__(self) -> typing.Any: ...


class QgsAnnotationItemAbstractMetadata(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, type: str|None, visibleName: str|None, visiblePluralName: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAnnotationItemAbstractMetadata') -> None: ...

    def createItem(self) -> QgsAnnotationItem|None: ...
    def visiblePluralName(self) -> str: ...
    def visibleName(self) -> str: ...
    def type(self) -> str: ...


class QgsAnnotationItemRegistry(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    typeAdded: typing.ClassVar[QtCore.pyqtSignal]
    def itemTypes(self) -> dict[str, str]: ...
    def createItem(self, type: str|None) -> QgsAnnotationItem|None: ...
    def addItemType(self, metadata: QgsAnnotationItemAbstractMetadata|None) -> bool: ...
    def itemMetadata(self, type: str|None) -> QgsAnnotationItemAbstractMetadata|None: ...
    def populate(self) -> bool: ...


class QgsAnnotationLayer(QgsMapLayer):

    class LayerOptions(PyQt6.sip.wrapper):

        transformContext = ... # type: 'QgsCoordinateTransformContext'

        @typing.overload
        def __init__(self, transformContext: 'QgsCoordinateTransformContext') -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAnnotationLayer.LayerOptions') -> None: ...

    def __init__(self, name: str|None, options: 'QgsAnnotationLayer.LayerOptions') -> None: ...

    def setLinkedVisibilityLayer(self, layer: QgsMapLayer|None) -> None: ...
    def linkedVisibilityLayer(self) -> QgsMapLayer|None: ...
    def setPaintEffect(self, effect: 'QgsPaintEffect|None') -> None: ...
    def paintEffect(self) -> 'QgsPaintEffect|None': ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def htmlMetadata(self) -> str: ...
    def dataProvider(self) -> 'QgsDataProvider|None': ...
    def supportsEditing(self) -> bool: ...
    def isEditable(self) -> bool: ...
    def readStyle(self, node: QtXml.QDomNode, errorMessage: str|None, context: QgsReadWriteContext, categories: QgsMapLayer.StyleCategory) -> bool: ...
    def writeStyle(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str|None, context: QgsReadWriteContext, categories: QgsMapLayer.StyleCategory) -> bool: ...
    def readSymbology(self, node: QtXml.QDomNode, errorMessage: str|None, context: QgsReadWriteContext, categories: QgsMapLayer.StyleCategory = ...) -> bool: ...
    def writeSymbology(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str|None, a3: QgsReadWriteContext, categories: QgsMapLayer.StyleCategory = ...) -> bool: ...
    def writeXml(self, layer_node: QtXml.QDomNode, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def readXml(self, layerNode: QtXml.QDomNode, context: QgsReadWriteContext) -> bool: ...
    def setTransformContext(self, context: 'QgsCoordinateTransformContext') -> None: ...
    def extent(self) -> 'QgsRectangle': ...
    def createMapRenderer(self, rendererContext: QgsRenderContext) -> QgsMapLayerRenderer|None: ...
    def clone(self) -> 'QgsAnnotationLayer|None': ...
    def properties(self) -> Qgis.MapLayerProperty: ...
    def applyEditV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> Qgis.AnnotationItemEditOperationResult: ...
    @deprecated("""""")
    def applyEdit(self, operation: QgsAbstractAnnotationItemEditOperation|None) -> Qgis.AnnotationItemEditOperationResult: ...
    def itemsInBounds(self, bounds: 'QgsRectangle', context: QgsRenderContext, feedback: QgsFeedback|None = ...) -> list[str]: ...
    def item(self, id: str|None) -> QgsAnnotationItem|None: ...
    def items(self) -> typing.Any: ...
    def isEmpty(self) -> bool: ...
    def clear(self) -> None: ...
    def removeItem(self, id: str|None) -> bool: ...
    def replaceItem(self, id: str|None, item: QgsAnnotationItem|None) -> None: ...
    def addItem(self, item: QgsAnnotationItem|None) -> str: ...
    def reset(self) -> None: ...
    def __repr__(self) -> typing.Any: ...


class QgsAnnotationLineItem(QgsAnnotationItem):

    def __init__(self, curve: 'QgsCurve|None') -> None: ...

    def setSymbol(self, symbol: 'QgsLineSymbol|None') -> None: ...
    def symbol(self) -> 'QgsLineSymbol|None': ...
    def setGeometry(self, geometry: 'QgsCurve|None') -> None: ...
    def geometry(self) -> 'QgsCurve|None': ...
    def clone(self) -> 'QgsAnnotationLineItem|None': ...
    def boundingBox(self) -> 'QgsRectangle': ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    @staticmethod
    def create() -> 'QgsAnnotationLineItem|None': ...
    def flags(self) -> Qgis.AnnotationItemFlag: ...
    def transientEditResultsV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> QgsAnnotationItemEditOperationTransientResults|None: ...
    def applyEditV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> Qgis.AnnotationItemEditOperationResult: ...
    def nodesV2(self, context: QgsAnnotationItemEditContext) -> list[QgsAnnotationItemNode]: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def render(self, context: QgsRenderContext, feedback: QgsFeedback|None) -> None: ...
    def type(self) -> str: ...


class QgsAnnotationLineTextItem(QgsAnnotationItem):

    def __init__(self, text: str|None, curve: 'QgsCurve|None') -> None: ...

    def offsetFromLineMapUnitScale(self) -> QgsMapUnitScale: ...
    def setOffsetFromLineMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def offsetFromLineUnit(self) -> Qgis.RenderUnit: ...
    def setOffsetFromLineUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setOffsetFromLine(self, distance: float) -> None: ...
    def offsetFromLine(self) -> float: ...
    def setFormat(self, format: 'QgsTextFormat') -> None: ...
    def format(self) -> 'QgsTextFormat': ...
    def setText(self, text: str|None) -> None: ...
    def text(self) -> str: ...
    def setGeometry(self, geometry: 'QgsCurve|None') -> None: ...
    def geometry(self) -> 'QgsCurve|None': ...
    def clone(self) -> 'QgsAnnotationLineTextItem|None': ...
    @typing.overload
    def boundingBox(self) -> 'QgsRectangle': ...
    @typing.overload
    def boundingBox(self, context: QgsRenderContext) -> 'QgsRectangle': ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    @staticmethod
    def create() -> 'QgsAnnotationLineTextItem|None': ...
    def transientEditResultsV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> QgsAnnotationItemEditOperationTransientResults|None: ...
    def applyEditV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> Qgis.AnnotationItemEditOperationResult: ...
    def nodesV2(self, context: QgsAnnotationItemEditContext) -> list[QgsAnnotationItemNode]: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def render(self, context: QgsRenderContext, feedback: QgsFeedback|None) -> None: ...
    def type(self) -> str: ...
    def flags(self) -> Qgis.AnnotationItemFlag: ...


class QgsAnnotationMarkerItem(QgsAnnotationItem):

    def __init__(self, point: 'QgsPoint') -> None: ...

    def setSymbol(self, symbol: 'QgsMarkerSymbol|None') -> None: ...
    def symbol(self) -> 'QgsMarkerSymbol|None': ...
    def setGeometry(self, geometry: 'QgsPoint') -> None: ...
    def geometry(self) -> QgsPointXY: ...
    @typing.overload
    def boundingBox(self) -> 'QgsRectangle': ...
    @typing.overload
    def boundingBox(self, context: QgsRenderContext) -> 'QgsRectangle': ...
    def clone(self) -> 'QgsAnnotationMarkerItem|None': ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    @staticmethod
    def create() -> 'QgsAnnotationMarkerItem|None': ...
    def transientEditResultsV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> QgsAnnotationItemEditOperationTransientResults|None: ...
    def applyEditV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> Qgis.AnnotationItemEditOperationResult: ...
    def nodesV2(self, context: QgsAnnotationItemEditContext) -> list[QgsAnnotationItemNode]: ...
    def flags(self) -> Qgis.AnnotationItemFlag: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def render(self, context: QgsRenderContext, feedback: QgsFeedback|None) -> None: ...
    def type(self) -> str: ...


class QgsAnnotationManager(QtCore.QObject):

    def __init__(self, project: 'QgsProject|None' = ...) -> None: ...

    annotationAboutToBeRemoved: typing.ClassVar[QtCore.pyqtSignal]
    annotationRemoved: typing.ClassVar[QtCore.pyqtSignal]
    annotationAdded: typing.ClassVar[QtCore.pyqtSignal]
    def accept(self, visitor: 'QgsStyleEntityVisitorInterface|None') -> bool: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def cloneAnnotations(self) -> list[QgsAnnotation]: ...
    def annotations(self) -> list[QgsAnnotation]: ...
    def clear(self) -> None: ...
    def removeAnnotation(self, annotation: QgsAnnotation|None) -> bool: ...
    def addAnnotation(self, annotation: QgsAnnotation|None) -> bool: ...


class QgsAnnotationRectItem(QgsAnnotationItem):

    def __init__(self, bounds: 'QgsRectangle') -> None: ...

    def renderInBounds(self, context: QgsRenderContext, painterRect: QtCore.QRectF, feedback: QgsFeedback|None) -> None: ...
    def readCommonProperties(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def writeCommonProperties(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def copyCommonProperties(self, other: QgsAnnotationItem|None) -> None: ...
    def setFrameSymbol(self, symbol: 'QgsFillSymbol|None') -> None: ...
    def frameSymbol(self) -> 'QgsFillSymbol|None': ...
    def setFrameEnabled(self, enabled: bool) -> None: ...
    def frameEnabled(self) -> bool: ...
    def setBackgroundSymbol(self, symbol: 'QgsFillSymbol|None') -> None: ...
    def backgroundSymbol(self) -> 'QgsFillSymbol|None': ...
    def setBackgroundEnabled(self, enabled: bool) -> None: ...
    def backgroundEnabled(self) -> bool: ...
    def setFixedSizeUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def fixedSizeUnit(self) -> Qgis.RenderUnit: ...
    def setFixedSize(self, size: QtCore.QSizeF) -> None: ...
    def fixedSize(self) -> QtCore.QSizeF: ...
    def setPlacementMode(self, mode: Qgis.AnnotationPlacementMode) -> None: ...
    def placementMode(self) -> Qgis.AnnotationPlacementMode: ...
    def setBounds(self, bounds: 'QgsRectangle') -> None: ...
    def bounds(self) -> 'QgsRectangle': ...
    @typing.overload
    def boundingBox(self) -> 'QgsRectangle': ...
    @typing.overload
    def boundingBox(self, context: QgsRenderContext) -> 'QgsRectangle': ...
    def transientEditResultsV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> QgsAnnotationItemEditOperationTransientResults|None: ...
    def applyEditV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> Qgis.AnnotationItemEditOperationResult: ...
    def nodesV2(self, context: QgsAnnotationItemEditContext) -> list[QgsAnnotationItemNode]: ...
    def render(self, context: QgsRenderContext, feedback: QgsFeedback|None) -> None: ...
    def flags(self) -> Qgis.AnnotationItemFlag: ...


class QgsAnnotationPictureItem(QgsAnnotationRectItem):

    def __init__(self, format: Qgis.PictureFormat, path: str|None, bounds: 'QgsRectangle') -> None: ...

    def renderInBounds(self, context: QgsRenderContext, painterBounds: QtCore.QRectF, feedback: QgsFeedback|None) -> None: ...
    def setLockAspectRatio(self, locked: bool) -> None: ...
    def lockAspectRatio(self) -> bool: ...
    def setPath(self, format: Qgis.PictureFormat, path: str|None) -> None: ...
    def format(self) -> Qgis.PictureFormat: ...
    def path(self) -> str: ...
    @staticmethod
    def create() -> 'QgsAnnotationPictureItem|None': ...
    def clone(self) -> 'QgsAnnotationPictureItem|None': ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def type(self) -> str: ...


class QgsAnnotationPointTextItem(QgsAnnotationItem):

    def __init__(self, text: str|None, point: QgsPointXY) -> None: ...

    def setRotationMode(self, mode: Qgis.SymbolRotationMode) -> None: ...
    def rotationMode(self) -> Qgis.SymbolRotationMode: ...
    def setAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def alignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def setAngle(self, angle: float) -> None: ...
    def angle(self) -> float: ...
    def setFormat(self, format: 'QgsTextFormat') -> None: ...
    def format(self) -> 'QgsTextFormat': ...
    def setText(self, text: str|None) -> None: ...
    def text(self) -> str: ...
    def setPoint(self, point: QgsPointXY) -> None: ...
    def point(self) -> QgsPointXY: ...
    def transientEditResultsV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> QgsAnnotationItemEditOperationTransientResults|None: ...
    def applyEditV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> Qgis.AnnotationItemEditOperationResult: ...
    def nodesV2(self, context: QgsAnnotationItemEditContext) -> list[QgsAnnotationItemNode]: ...
    @typing.overload
    def boundingBox(self) -> 'QgsRectangle': ...
    @typing.overload
    def boundingBox(self, context: QgsRenderContext) -> 'QgsRectangle': ...
    def clone(self) -> 'QgsAnnotationPointTextItem|None': ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    @staticmethod
    def create() -> 'QgsAnnotationPointTextItem|None': ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def render(self, context: QgsRenderContext, feedback: QgsFeedback|None) -> None: ...
    def type(self) -> str: ...
    def flags(self) -> Qgis.AnnotationItemFlag: ...


class QgsAnnotationPolygonItem(QgsAnnotationItem):

    def __init__(self, polygon: 'QgsCurvePolygon|None') -> None: ...

    def setSymbol(self, symbol: 'QgsFillSymbol|None') -> None: ...
    def symbol(self) -> 'QgsFillSymbol|None': ...
    def setGeometry(self, geometry: 'QgsCurvePolygon|None') -> None: ...
    def geometry(self) -> 'QgsCurvePolygon|None': ...
    def boundingBox(self) -> 'QgsRectangle': ...
    def clone(self) -> 'QgsAnnotationPolygonItem|None': ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    @staticmethod
    def create() -> 'QgsAnnotationPolygonItem|None': ...
    def flags(self) -> Qgis.AnnotationItemFlag: ...
    def transientEditResultsV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> QgsAnnotationItemEditOperationTransientResults|None: ...
    def applyEditV2(self, operation: QgsAbstractAnnotationItemEditOperation|None, context: QgsAnnotationItemEditContext) -> Qgis.AnnotationItemEditOperationResult: ...
    def nodesV2(self, context: QgsAnnotationItemEditContext) -> list[QgsAnnotationItemNode]: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def render(self, context: QgsRenderContext, feedback: QgsFeedback|None) -> None: ...
    def type(self) -> str: ...


class QgsAnnotationRectangleTextItem(QgsAnnotationRectItem):

    def __init__(self, text: str|None, bounds: 'QgsRectangle') -> None: ...

    def renderInBounds(self, context: QgsRenderContext, painterBounds: QtCore.QRectF, feedback: QgsFeedback|None) -> None: ...
    def marginsUnit(self) -> Qgis.RenderUnit: ...
    def setMarginsUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setMargins(self, margins: QgsMargins) -> None: ...
    def margins(self) -> QgsMargins: ...
    def setAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def alignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def setFormat(self, format: 'QgsTextFormat') -> None: ...
    def format(self) -> 'QgsTextFormat': ...
    def setText(self, text: str|None) -> None: ...
    def text(self) -> str: ...
    def clone(self) -> 'QgsAnnotationRectangleTextItem|None': ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    @staticmethod
    def create() -> 'QgsAnnotationRectangleTextItem|None': ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def flags(self) -> Qgis.AnnotationItemFlag: ...
    def type(self) -> str: ...


class QgsHtmlAnnotation(QgsAnnotation):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def renderAnnotation(self, context: QgsRenderContext, size: QtCore.QSizeF) -> None: ...
    @staticmethod
    def create() -> 'QgsHtmlAnnotation|None': ...
    def setAssociatedFeature(self, feature: QgsFeature) -> None: ...
    def readXml(self, itemElem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def htmlSource(self) -> str: ...
    def setHtmlSource(self, htmlSource: str|None) -> None: ...
    def sourceFile(self) -> str: ...
    def setSourceFile(self, htmlFile: str|None) -> None: ...
    def minimumFrameSize(self) -> QtCore.QSizeF: ...
    def clone(self) -> 'QgsHtmlAnnotation|None': ...


class QgsRenderedAnnotationItemDetails(QgsRenderedItemDetails):

    @typing.overload
    def __init__(self, layerId: str|None, itemId: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRenderedAnnotationItemDetails') -> None: ...

    def itemId(self) -> str: ...
    def __repr__(self) -> typing.Any: ...


class QgsSvgAnnotation(QgsAnnotation):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def renderAnnotation(self, context: QgsRenderContext, size: QtCore.QSizeF) -> None: ...
    @staticmethod
    def create() -> 'QgsSvgAnnotation|None': ...
    def filePath(self) -> str: ...
    def setFilePath(self, file: str|None) -> None: ...
    def readXml(self, itemElem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def clone(self) -> 'QgsSvgAnnotation|None': ...


class QgsTextAnnotation(QgsAnnotation):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def renderAnnotation(self, context: QgsRenderContext, size: QtCore.QSizeF) -> None: ...
    @staticmethod
    def create() -> 'QgsTextAnnotation|None': ...
    def readXml(self, itemElem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def setDocument(self, doc: QtGui.QTextDocument|None) -> None: ...
    def document(self) -> QtGui.QTextDocument|None: ...
    def clone(self) -> 'QgsTextAnnotation|None': ...


class QgsAuthManager(QtCore.QObject):

    class MessageLevel(enum.IntEnum):
        INFO = ... # type: QgsAuthManager.MessageLevel
        WARNING = ... # type: QgsAuthManager.MessageLevel
        CRITICAL = ... # type: QgsAuthManager.MessageLevel

    AUTH_MAN_TAG = ... # type: str|None
    AUTH_PASSWORD_HELPER_DISPLAY_NAME = ... # type: str|None

    def __init__(self) -> None: ...

    def clearCachedConfig(self, authcfg: str|None) -> None: ...
    def clearAllCachedConfigs(self) -> None: ...
    authDatabaseChanged: typing.ClassVar[QtCore.pyqtSignal]
    authDatabaseEraseRequested: typing.ClassVar[QtCore.pyqtSignal]
    masterPasswordVerified: typing.ClassVar[QtCore.pyqtSignal]
    passwordHelperMessageLog: typing.ClassVar[QtCore.pyqtSignal]
    passwordHelperMessageOut: typing.ClassVar[QtCore.pyqtSignal]
    messageLog: typing.ClassVar[QtCore.pyqtSignal]
    messageOut: typing.ClassVar[QtCore.pyqtSignal]
    passwordHelperSuccess: typing.ClassVar[QtCore.pyqtSignal]
    passwordHelperFailure: typing.ClassVar[QtCore.pyqtSignal]
    @staticmethod
    def passwordHelperDisplayName(titleCase: bool = ...) -> str: ...
    def passwordHelperSync(self) -> bool: ...
    def setPasswordHelperEnabled(self, enabled: bool) -> None: ...
    @staticmethod
    def passwordHelperEnabled() -> bool: ...
    def trustedCaCertsPemText(self) -> QtCore.QByteArray: ...
    def trustedCaCertsCache(self) -> list[QtNetwork.QSslCertificate]: ...
    def rebuildTrustedCaCertsCache(self) -> bool: ...
    def untrustedCaCerts(self, trustedCAs: collections.abc.Iterable[QtNetwork.QSslCertificate] = ...) -> list[QtNetwork.QSslCertificate]: ...
    def trustedCaCerts(self, includeinvalid: bool = ...) -> list[QtNetwork.QSslCertificate]: ...
    def rebuildCertTrustCache(self) -> bool: ...
    def certTrustCache(self) -> dict['QgsAuthCertUtils.CertTrustPolicy', list[str]]: ...
    def defaultCertTrustPolicy(self) -> 'QgsAuthCertUtils.CertTrustPolicy': ...
    def setDefaultCertTrustPolicy(self, policy: 'QgsAuthCertUtils.CertTrustPolicy') -> bool: ...
    def certificateTrustPolicy(self, cert: QtNetwork.QSslCertificate) -> 'QgsAuthCertUtils.CertTrustPolicy': ...
    def removeCertTrustPolicy(self, cert: QtNetwork.QSslCertificate) -> bool: ...
    def removeCertTrustPolicies(self, certs: collections.abc.Iterable[QtNetwork.QSslCertificate]) -> bool: ...
    def certTrustPolicy(self, cert: QtNetwork.QSslCertificate) -> 'QgsAuthCertUtils.CertTrustPolicy': ...
    def storeCertTrustPolicy(self, cert: QtNetwork.QSslCertificate, policy: 'QgsAuthCertUtils.CertTrustPolicy') -> bool: ...
    def rebuildCaCertsCache(self) -> bool: ...
    def mappedDatabaseCAs(self) -> dict[str, QtNetwork.QSslCertificate]: ...
    def databaseCAs(self) -> list[QtNetwork.QSslCertificate]: ...
    def extraFileCAs(self) -> list[QtNetwork.QSslCertificate]: ...
    @staticmethod
    def systemRootCAs() -> list[QtNetwork.QSslCertificate]: ...
    def removeCertAuthority(self, cert: QtNetwork.QSslCertificate) -> bool: ...
    def existsCertAuthority(self, cert: QtNetwork.QSslCertificate) -> bool: ...
    def certAuthority(self, id: str|None) -> QtNetwork.QSslCertificate: ...
    def storeCertAuthority(self, cert: QtNetwork.QSslCertificate) -> bool: ...
    def storeCertAuthorities(self, certs: collections.abc.Iterable[QtNetwork.QSslCertificate]) -> bool: ...
    def rebuildIgnoredSslErrorCache(self) -> bool: ...
    def updateIgnoredSslErrorsCache(self, shahostport: str|None, errors: collections.abc.Iterable[QtNetwork.QSslError]) -> bool: ...
    def updateIgnoredSslErrorsCacheFromConfig(self, config: 'QgsAuthConfigSslServer') -> bool: ...
    def dumpIgnoredSslErrorsCache_(self) -> None: ...
    def removeSslCertCustomConfig(self, id: str|None, hostport: str|None) -> bool: ...
    def existsSslCertCustomConfig(self, id: str|None, hostport: str|None) -> bool: ...
    def sslCertCustomConfigs(self) -> list['QgsAuthConfigSslServer']: ...
    def sslCertCustomConfigByHost(self, hostport: str|None) -> 'QgsAuthConfigSslServer': ...
    def sslCertCustomConfig(self, id: str|None, hostport: str|None) -> 'QgsAuthConfigSslServer': ...
    def storeSslCertCustomConfig(self, config: 'QgsAuthConfigSslServer') -> bool: ...
    def removeCertIdentity(self, id: str|None) -> bool: ...
    def existsCertIdentity(self, id: str|None) -> bool: ...
    def certIdentityIds(self) -> list[str]: ...
    def certIdentities(self) -> list[QtNetwork.QSslCertificate]: ...
    def certIdentityBundleToPem(self, id: str|None) -> list[str]: ...
    def certIdentity(self, id: str|None) -> QtNetwork.QSslCertificate: ...
    def storeCertIdentity(self, cert: QtNetwork.QSslCertificate, key: QtNetwork.QSslKey) -> bool: ...
    def initSslCaches(self) -> bool: ...
    def removeAuthSetting(self, key: str|None) -> bool: ...
    def existsAuthSetting(self, key: str|None) -> bool: ...
    def authSetting(self, key: str|None, defaultValue: typing.Any = ..., decrypt: bool = ...) -> typing.Any: ...
    def storeAuthSetting(self, key: str|None, value: typing.Any, encrypt: bool = ...) -> bool: ...
    def updateNetworkProxy(self, proxy: QtNetwork.QNetworkProxy, authcfg: str|None, dataprovider: str|None = ...) -> typing.Tuple[bool, QtNetwork.QNetworkProxy]: ...
    def updateDataSourceUriItems(self, connectionItems: collections.abc.Iterable[str|None], authcfg: str|None, dataprovider: str|None = ...) -> typing.Tuple[bool, list[str]]: ...
    def updateNetworkReply(self, reply: QtNetwork.QNetworkReply|None, authcfg: str|None, dataprovider: str|None = ...) -> bool: ...
    def updateNetworkRequest(self, request: QtNetwork.QNetworkRequest, authcfg: str|None, dataprovider: str|None = ...) -> typing.Tuple[bool, QtNetwork.QNetworkRequest]: ...
    def eraseAuthenticationDatabase(self, backup: bool, backuppath: str|None = ...) -> typing.Tuple[bool, str]: ...
    def backupAuthenticationDatabase(self, backuppath: str|None = ...) -> typing.Tuple[bool, str]: ...
    def removeAllAuthenticationConfigs(self) -> bool: ...
    def importAuthenticationConfigsFromXml(self, filename: str|None, password: str|None = ..., overwrite: bool = ...) -> bool: ...
    def exportAuthenticationConfigsToXml(self, filename: str|None, authcfgs: collections.abc.Iterable[str|None], password: str|None = ...) -> bool: ...
    def removeAuthenticationConfig(self, authcfg: str|None) -> bool: ...
    def loadAuthenticationConfig(self, authcfg: str|None, mconfig: 'QgsAuthMethodConfig', full: bool = ...) -> typing.Tuple[bool, 'QgsAuthMethodConfig']: ...
    def updateAuthenticationConfig(self, config: 'QgsAuthMethodConfig') -> bool: ...
    def storeAuthenticationConfig(self, mconfig: 'QgsAuthMethodConfig', overwrite: bool = ...) -> typing.Tuple[bool, 'QgsAuthMethodConfig']: ...
    def configIds(self) -> list[str]: ...
    def configIdRegex(self) -> str: ...
    @staticmethod
    def hasConfigId(txt: str|None) -> bool: ...
    def configIdUnique(self, id: str|None) -> bool: ...
    def uniqueConfigId(self) -> str: ...
    def supportedAuthMethodExpansions(self, authcfg: str|None) -> 'QgsAuthMethod.Expansion': ...
    def authMethodEditWidget(self, authMethodKey: str|None, parent: QtWidgets.QWidget|None) -> QtWidgets.QWidget|None: ...
    def authMethod(self, authMethodKey: str|None) -> 'QgsAuthMethod|None': ...
    def authMethodsKeys(self, dataprovider: str|None = ...) -> list[str]: ...
    def configAuthMethodKey(self, authcfg: str|None) -> str: ...
    def configAuthMethod(self, authcfg: str|None) -> 'QgsAuthMethod|None': ...
    def updateConfigAuthMethods(self) -> None: ...
    def availableAuthMethodConfigs(self, dataprovider: str|None = ...) -> dict[str, 'QgsAuthMethodConfig']: ...
    def registerCoreAuthMethods(self) -> bool: ...
    def authManTag(self) -> str: ...
    def setScheduledAuthDatabaseEraseRequestEmitted(self, emitted: bool) -> None: ...
    def resetMasterPassword(self, newpass: str|None, oldpass: str|None, keepbackup: bool, backuppath: str|None = ...) -> typing.Tuple[bool, str]: ...
    def masterPasswordSame(self, password: str|None) -> bool: ...
    def clearMasterPassword(self) -> None: ...
    def masterPasswordHashInDatabase(self) -> bool: ...
    def masterPasswordIsSet(self) -> bool: ...
    def verifyMasterPassword(self, compare: str|None = ...) -> bool: ...
    @typing.overload
    def setMasterPassword(self, verify: bool = ...) -> bool: ...
    @typing.overload
    def setMasterPassword(self, password: str|None, verify: bool = ...) -> bool: ...
    def authenticationDatabaseUriStripped(self) -> str: ...
    def authenticationDatabaseUri(self) -> str: ...
    @staticmethod
    def isFilesystemBasedDatabase(uri: str|None) -> bool: ...
    def authenticationDatabasePath(self) -> str: ...
    def disabledMessage(self) -> str: ...
    def isDisabled(self) -> bool: ...
    @deprecated("""""")
    def authDatabaseServersTable(self) -> str: ...
    def methodConfigTableName(self) -> str: ...
    @deprecated("""""")
    def authDatabaseConfigTable(self) -> str: ...
    @deprecated("""""")
    def authDatabaseConnection(self) -> QtSql.QSqlDatabase: ...
    def authConfigurationStorageRegistry(self) -> 'QgsAuthConfigurationStorageRegistry|None': ...
    def ensureInitialized(self) -> bool: ...
    def setup(self, pluginPath: str|None = ..., authDatabasePath: str|None = ...) -> None: ...
    @deprecated("""""")
    def init(self, pluginPath: str|None = ..., authDatabasePath: str|None = ...) -> bool: ...


class QgsBrowserModel(QtCore.QAbstractItemModel):

    class CustomRole(enum.IntEnum):
        Path = ... # type: QgsBrowserModel.CustomRole
        Comment = ... # type: QgsBrowserModel.CustomRole
        Sort = ... # type: QgsBrowserModel.CustomRole
        ProviderKey = ... # type: QgsBrowserModel.CustomRole
        LayerMetadata = ... # type: QgsBrowserModel.CustomRole

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def removeRootItems(self) -> None: ...
    def addRootItems(self) -> None: ...
    def initialize(self) -> None: ...
    def hidePath(self, item: 'QgsDataItem|None') -> None: ...
    def updateProjectHome(self) -> None: ...
    def removeFavorite(self, index: QtCore.QModelIndex) -> None: ...
    def addFavoriteDirectory(self, directory: str|None, name: str|None = ...) -> None: ...
    def itemStateChanged(self, item: 'QgsDataItem|None', oldState: Qgis.BrowserItemState) -> None: ...
    def itemDataChanged(self, item: 'QgsDataItem|None') -> None: ...
    def endRemoveItems(self) -> None: ...
    def beginRemoveItems(self, parent: 'QgsDataItem|None', first: int, last: int) -> None: ...
    def endInsertItems(self) -> None: ...
    def beginInsertItems(self, parent: 'QgsDataItem|None', first: int, last: int) -> None: ...
    def refreshDrives(self) -> None: ...
    def reload(self) -> None: ...
    connectionsChanged: typing.ClassVar[QtCore.pyqtSignal]
    stateChanged: typing.ClassVar[QtCore.pyqtSignal]
    def rootItems(self) -> list['QgsDataItem']: ...
    def driveItems(self) -> typing.Any: ...
    def initialized(self) -> bool: ...
    @deprecated("""""")
    def connectItem(self, item: 'QgsDataItem|None') -> None: ...
    def findUri(self, uri: str|None, index: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def findPath(self, path: str|None, matchFlag: QtCore.Qt.MatchFlag = ...) -> QtCore.QModelIndex: ...
    @typing.overload
    def refresh(self, path: str|None) -> None: ...
    @typing.overload
    def refresh(self, index: QtCore.QModelIndex = ...) -> None: ...
    def dataItem(self, idx: QtCore.QModelIndex) -> 'QgsDataItem|None': ...
    def findItem(self, item: 'QgsDataItem|None', parent: 'QgsDataItem|None' = ...) -> QtCore.QModelIndex: ...
    def fetchMore(self, parent: QtCore.QModelIndex) -> None: ...
    def canFetchMore(self, parent: QtCore.QModelIndex) -> bool: ...
    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def dropMimeData(self, data: QtCore.QMimeData|None, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: collections.abc.Iterable[QtCore.QModelIndex]) -> QtCore.QMimeData|None: ...
    def mimeTypes(self) -> list[str]: ...
    def parent(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlag: ...


class QgsBrowserProxyModel(QtCore.QSortFilterProxyModel):

    class FilterSyntax(enum.IntEnum):
        Normal = ... # type: QgsBrowserProxyModel.FilterSyntax
        Wildcards = ... # type: QgsBrowserProxyModel.FilterSyntax
        RegularExpression = ... # type: QgsBrowserProxyModel.FilterSyntax

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def filterAcceptsRow(self, sourceRow: int, sourceParent: QtCore.QModelIndex) -> bool: ...
    def setShowLayers(self, showLayers: bool) -> None: ...
    def showLayers(self) -> bool: ...
    def setShownDataItemProviderKeyFilter(self, shownItemsFilter: collections.abc.Iterable[str|None]) -> None: ...
    def setHiddenDataItemProviderKeyFilter(self, hiddenItemsFilter: collections.abc.Iterable[str|None]) -> None: ...
    def setLayerType(self, type: Qgis.LayerType) -> None: ...
    def layerType(self) -> Qgis.LayerType: ...
    def setFilterByLayerType(self, enabled: bool) -> None: ...
    def filterByLayerType(self) -> bool: ...
    def caseSensitivity(self) -> QtCore.Qt.CaseSensitivity: ...
    def setFilterCaseSensitivity(self, sensitivity: QtCore.Qt.CaseSensitivity) -> None: ...
    def filterString(self) -> str: ...
    def setFilterString(self, filter: str|None) -> None: ...
    def filterSyntax(self) -> 'QgsBrowserProxyModel.FilterSyntax': ...
    def setFilterSyntax(self, syntax: 'QgsBrowserProxyModel.FilterSyntax') -> None: ...
    def dataItem(self, index: QtCore.QModelIndex) -> 'QgsDataItem|None': ...
    def browserModel(self) -> QgsBrowserModel|None: ...
    def setBrowserModel(self, model: QgsBrowserModel|None) -> None: ...


class QgsDataItem(QtCore.QObject):

    def __init__(self, type: Qgis.BrowserItemType, parent: 'QgsDataItem|None', name: str|None, path: str|None, providerKey: str|None = ...) -> None: ...

    def updateIcon(self) -> None: ...
    connectionsChanged: typing.ClassVar[QtCore.pyqtSignal]
    stateChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataChanged: typing.ClassVar[QtCore.pyqtSignal]
    endRemoveItems: typing.ClassVar[QtCore.pyqtSignal]
    beginRemoveItems: typing.ClassVar[QtCore.pyqtSignal]
    endInsertItems: typing.ClassVar[QtCore.pyqtSignal]
    beginInsertItems: typing.ClassVar[QtCore.pyqtSignal]
    def childrenCreated(self) -> None: ...
    def refreshConnections(self, providerKey: str|None = ...) -> None: ...
    def depopulate(self) -> None: ...
    def deferredDelete(self) -> bool: ...
    @typing.overload
    def refresh(self, children: collections.abc.Iterable['QgsDataItem']) -> None: ...
    @typing.overload
    def refresh(self) -> None: ...
    @typing.overload
    def populate(self, children: collections.abc.Iterable['QgsDataItem']) -> None: ...
    @typing.overload
    def populate(self, foreground: bool = ...) -> None: ...
    def databaseConnection(self) -> 'QgsAbstractDatabaseProviderConnection|None': ...
    def moveToThread(self, targetThread: QtCore.QThread|None) -> None: ...
    @typing.overload
    @staticmethod
    def deleteLater(items: collections.abc.Iterable['QgsDataItem']) -> None: ...
    @typing.overload
    def deleteLater(self) -> None: ...
    def toolTip(self) -> str: ...
    def setToolTip(self, msg: str|None) -> None: ...
    def setIconName(self, iconName: str|None) -> None: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def setSortKey(self, key: typing.Any) -> None: ...
    def sortKey(self) -> typing.Any: ...
    @staticmethod
    def pathComponent(component: str|None) -> str: ...
    def setProviderKey(self, value: str|None) -> None: ...
    def providerKey(self) -> str: ...
    def setPath(self, path: str|None) -> None: ...
    def path(self) -> str: ...
    def setName(self, name: str|None) -> None: ...
    def name(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def children(self) -> list['QgsDataItem']: ...
    def setParent(self, parent: 'QgsDataItem|None') -> None: ...
    def ancestorAtDepth(self, depth: int) -> 'QgsDataItem|None': ...
    def parent(self) -> 'QgsDataItem|None': ...
    def type(self) -> Qgis.BrowserItemType: ...
    @staticmethod
    def findItem(items: collections.abc.Iterable['QgsDataItem'], item: 'QgsDataItem|None') -> int: ...
    @deprecated("""""")
    def setCapabilities(self, capabilities: int) -> None: ...
    def setCapabilitiesV2(self, capabilities: Qgis.BrowserItemCapability) -> None: ...
    def capabilities2(self) -> Qgis.BrowserItemCapability: ...
    @deprecated("""""")
    def rename(self, name: str|None) -> bool: ...
    @deprecated("""""")
    def setCrs(self, crs: 'QgsCoordinateReferenceSystem') -> bool: ...
    def mimeUris(self) -> list[QgsMimeDataUtils.Uri]: ...
    @deprecated("""""")
    def mimeUri(self) -> QgsMimeDataUtils.Uri: ...
    def hasDragEnabled(self) -> bool: ...
    def handleDoubleClick(self) -> bool: ...
    @deprecated("""""")
    def handleDrop(self, a0: QtCore.QMimeData|None, a1: QtCore.Qt.DropAction) -> bool: ...
    @deprecated("""""")
    def acceptDrop(self) -> bool: ...
    def menus(self, parent: QtWidgets.QWidget|None) -> list[QtWidgets.QMenu]: ...
    def actions(self, parent: QtWidgets.QWidget|None) -> list[QtGui.QAction]: ...
    @deprecated("""""")
    def paramWidget(self) -> QtWidgets.QWidget|None: ...
    def equal(self, other: 'QgsDataItem|None') -> bool: ...
    def removeChildItem(self, child: 'QgsDataItem|None') -> 'QgsDataItem|None': ...
    def deleteChildItem(self, child: 'QgsDataItem|None') -> None: ...
    def addChildItem(self, child: 'QgsDataItem|None', refresh: bool = ...) -> None: ...
    def setState(self, state: Qgis.BrowserItemState) -> None: ...
    def state(self) -> Qgis.BrowserItemState: ...
    def creatorAncestorDepth(self) -> int: ...
    def createChildren(self) -> list['QgsDataItem']: ...
    def rowCount(self) -> int: ...
    def layerCollection(self) -> bool: ...
    def hasChildren(self) -> bool: ...
    def __repr__(self) -> typing.Any: ...


class QgsDataCollectionItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem|None, name: str|None, path: str|None = ..., providerKey: str|None = ...) -> None: ...

    @staticmethod
    def homeDirIcon(fillColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ..., strokeColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> QtGui.QIcon: ...
    @staticmethod
    def openDirIcon(fillColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ..., strokeColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> QtGui.QIcon: ...
    def databaseConnection(self) -> 'QgsAbstractDatabaseProviderConnection|None': ...
    @staticmethod
    def iconDataCollection() -> QtGui.QIcon: ...
    @staticmethod
    def iconDir(fillColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ..., strokeColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> QtGui.QIcon: ...
    def addChild(self, item: QgsDataItem|None) -> None: ...
    def __repr__(self) -> typing.Any: ...


class QgsConnectionsRootItem(QgsDataCollectionItem):

    def __init__(self, parent: QgsDataItem|None, name: str|None, path: str|None = ..., providerKey: str|None = ...) -> None: ...

    def __repr__(self) -> typing.Any: ...


class QgsDatabaseSchemaItem(QgsDataCollectionItem):

    def __init__(self, parent: QgsDataItem|None, name: str|None, path: str|None = ..., providerKey: str|None = ...) -> None: ...

    def databaseConnection(self) -> 'QgsAbstractDatabaseProviderConnection|None': ...
    def __repr__(self) -> typing.Any: ...


class QgsErrorItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem|None, error: str|None, path: str|None) -> None: ...

    def __repr__(self) -> typing.Any: ...


class QgsDataItemProvider(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDataItemProvider') -> None: ...

    def handlesDirectoryPath(self, path: str|None) -> bool: ...
    def createDataItems(self, path: str|None, parentItem: QgsDataItem|None) -> list[QgsDataItem]: ...
    def createDataItem(self, path: str|None, parentItem: QgsDataItem|None) -> QgsDataItem|None: ...
    def capabilities(self) -> Qgis.DataItemProviderCapability: ...
    def dataProviderKey(self) -> str: ...
    def name(self) -> str: ...


class QgsDataItemProviderRegistry(QtCore.QObject):

    def __init__(self) -> None: ...

    providerWillBeRemoved: typing.ClassVar[QtCore.pyqtSignal]
    providerAdded: typing.ClassVar[QtCore.pyqtSignal]
    def dataProviderKey(self, dataItemProviderName: str|None) -> str: ...
    def removeProvider(self, provider: QgsDataItemProvider|None) -> None: ...
    def addProvider(self, provider: QgsDataItemProvider|None) -> None: ...
    def provider(self, providerName: str|None) -> QgsDataItemProvider|None: ...
    def providers(self) -> list[QgsDataItemProvider]: ...


class QgsDirectoryItem(QgsDataCollectionItem):

    @typing.overload
    def __init__(self, parent: QgsDataItem|None, name: str|None, path: str|None) -> None: ...
    @typing.overload
    def __init__(self, parent: QgsDataItem|None, name: str|None, dirPath: str|None, path: str|None, providerKey: str|None = ...) -> None: ...

    def directoryChanged(self) -> None: ...
    def childrenCreated(self) -> None: ...
    def setMonitoring(self, monitoring: Qgis.BrowserDirectoryMonitoring) -> None: ...
    def monitoring(self) -> Qgis.BrowserDirectoryMonitoring: ...
    def isMonitored(self) -> bool: ...
    @staticmethod
    def pathShouldByMonitoredByDefault(path: str|None) -> bool: ...
    @staticmethod
    def monitoringForPath(path: str|None) -> Qgis.BrowserDirectoryMonitoring: ...
    @staticmethod
    def hiddenPath(path: str|None) -> bool: ...
    def mimeUris(self) -> list[QgsMimeDataUtils.Uri]: ...
    def hasDragEnabled(self) -> bool: ...
    @deprecated("""""")
    def paramWidget(self) -> QtWidgets.QWidget|None: ...
    @staticmethod
    def setCustomColor(directory: str|None, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setIconColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def iconColor(self) -> QtGui.QColor: ...
    def icon(self) -> QtGui.QIcon: ...
    def equal(self, other: QgsDataItem|None) -> bool: ...
    def dirPath(self) -> str: ...
    def createChildren(self) -> list[QgsDataItem]: ...
    def setState(self, state: Qgis.BrowserItemState) -> None: ...
    def __repr__(self) -> typing.Any: ...


class QgsDirectoryParamWidget(QtWidgets.QTreeWidget):

    def __init__(self, path: str|None, parent: QtWidgets.QWidget|None = ...) -> None: ...

    def showHideColumn(self) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent|None) -> None: ...


class QgsFavoritesItem(QgsDataCollectionItem):

    def __init__(self, parent: QgsDataItem|None, name: str|None, path: str|None = ...) -> None: ...

    def sortKey(self) -> typing.Any: ...
    @staticmethod
    def iconFavorites() -> QtGui.QIcon: ...
    def renameFavorite(self, path: str|None, name: str|None) -> None: ...
    def removeDirectory(self, item: QgsDirectoryItem|None) -> None: ...
    def addDirectory(self, directory: str|None, name: str|None = ...) -> None: ...
    def createChildren(self) -> list[QgsDataItem]: ...
    def __repr__(self) -> typing.Any: ...


class QgsFieldDomainsItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem|None, path: str|None, connectionUri: str|None, providerKey: str|None) -> None: ...

    def connectionUri(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def createChildren(self) -> list[QgsDataItem]: ...
    def __repr__(self) -> typing.Any: ...


class QgsFieldDomainItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem|None, domain: 'QgsFieldDomain|None') -> None: ...

    def connectionUri(self) -> str: ...
    def fieldDomain(self) -> 'QgsFieldDomain|None': ...
    def icon(self) -> QtGui.QIcon: ...
    def __repr__(self) -> typing.Any: ...


class QgsFieldsItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem|None, path: str|None, connectionUri: str|None, providerKey: str|None, schema: str|None, tableName: str|None) -> None: ...

    def canRenameFields(self) -> bool: ...
    def tableProperty(self) -> 'QgsAbstractDatabaseProviderConnection.TableProperty|None': ...
    def fields(self) -> QgsFields: ...
    def layer(self) -> QgsVectorLayer|None: ...
    def connectionUri(self) -> str: ...
    def tableName(self) -> str: ...
    def schema(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def createChildren(self) -> list[QgsDataItem]: ...
    def __repr__(self) -> typing.Any: ...


class QgsFieldItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem|None, field: QgsField) -> None: ...

    def equal(self, other: QgsDataItem|None) -> bool: ...
    def field(self) -> QgsField: ...
    def icon(self) -> QtGui.QIcon: ...
    def __repr__(self) -> typing.Any: ...


class QgsLayerItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem|None, name: str|None, path: str|None, uri: str|None, layerType: Qgis.BrowserLayerType, providerKey: str|None) -> None: ...

    def setLayerMetadata(self, metadata: 'QgsLayerMetadata') -> None: ...
    def layerMetadata(self) -> 'QgsLayerMetadata': ...
    def databaseConnection(self) -> 'QgsAbstractDatabaseProviderConnection|None': ...
    def layerName(self) -> str: ...
    @staticmethod
    def iconPointCloud() -> QtGui.QIcon: ...
    @staticmethod
    def iconVectorTile() -> QtGui.QIcon: ...
    @staticmethod
    def iconMesh() -> QtGui.QIcon: ...
    @staticmethod
    def iconDefault() -> QtGui.QIcon: ...
    @staticmethod
    def iconRaster() -> QtGui.QIcon: ...
    @staticmethod
    def iconTable() -> QtGui.QIcon: ...
    @staticmethod
    def iconPolygon() -> QtGui.QIcon: ...
    @staticmethod
    def iconLine() -> QtGui.QIcon: ...
    @staticmethod
    def iconPoint() -> QtGui.QIcon: ...
    @staticmethod
    def iconForWkbType(type: Qgis.WkbType) -> QtGui.QIcon: ...
    @deprecated("""""")
    def deleteLayer(self) -> bool: ...
    @staticmethod
    def iconName(layerType: Qgis.BrowserLayerType) -> str: ...
    @staticmethod
    def layerTypeAsString(layerType: Qgis.BrowserLayerType) -> str: ...
    def comments(self) -> str: ...
    def supportedFormats(self) -> list[str]: ...
    def supportedCrs(self) -> list[str]: ...
    def uri(self) -> str: ...
    @staticmethod
    def typeFromMapLayer(layer: QgsMapLayer|None) -> Qgis.BrowserLayerType: ...
    def mapLayerType(self) -> Qgis.LayerType: ...
    def mimeUris(self) -> list[QgsMimeDataUtils.Uri]: ...
    def hasDragEnabled(self) -> bool: ...
    def equal(self, other: QgsDataItem|None) -> bool: ...
    def __repr__(self) -> typing.Any: ...


class QgsProjectItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem|None, name: str|None, path: str|None, providerKey: str|None = ...) -> None: ...

    def mimeUris(self) -> list[QgsMimeDataUtils.Uri]: ...
    def hasDragEnabled(self) -> bool: ...
    def __repr__(self) -> typing.Any: ...


class QgsRelationshipsItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem|None, path: str|None, connectionUri: str|None, providerKey: str|None, schema: str|None = ..., tableName: str|None = ...) -> None: ...

    def tableName(self) -> str: ...
    def schema(self) -> str: ...
    def connectionUri(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def createChildren(self) -> list[QgsDataItem]: ...
    def __repr__(self) -> typing.Any: ...


class QgsRelationshipItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem|None, relation: QgsWeakRelation) -> None: ...

    def relation(self) -> QgsWeakRelation: ...
    def icon(self) -> QtGui.QIcon: ...
    def __repr__(self) -> typing.Any: ...


class QgsZipItem(QgsDataCollectionItem):

    sProviderNames = ... # type: collections.abc.Iterable[str|None]

    @typing.overload
    def __init__(self, parent: QgsDataItem|None, name: str|None, path: str|None) -> None: ...
    @typing.overload
    def __init__(self, parent: QgsDataItem|None, name: str|None, filePath: str|None, path: str|None, providerKey: str|None = ...) -> None: ...

    @staticmethod
    def iconZip() -> QtGui.QIcon: ...
    @staticmethod
    def itemFromFilePath(parent: QgsDataItem|None, filePath: str|None, name: str|None, path: str|None) -> QgsDataItem|None: ...
    @staticmethod
    def itemFromPath(parent: QgsDataItem|None, path: str|None, name: str|None) -> QgsDataItem|None: ...
    @staticmethod
    @deprecated("""""")
    def vsiPrefix(uri: str|None) -> str: ...
    def mimeUris(self) -> list[QgsMimeDataUtils.Uri]: ...
    def hasDragEnabled(self) -> bool: ...
    def getZipFileList(self) -> list[str]: ...
    def createChildren(self) -> list[QgsDataItem]: ...
    def __repr__(self) -> typing.Any: ...


class QgsCallout(PyQt6.sip.wrapper):

    class LabelAnchorPoint(enum.IntEnum):
        LabelPointOnExterior = ... # type: QgsCallout.LabelAnchorPoint
        LabelCentroid = ... # type: QgsCallout.LabelAnchorPoint
        LabelTopLeft = ... # type: QgsCallout.LabelAnchorPoint
        LabelTopMiddle = ... # type: QgsCallout.LabelAnchorPoint
        LabelTopRight = ... # type: QgsCallout.LabelAnchorPoint
        LabelMiddleLeft = ... # type: QgsCallout.LabelAnchorPoint
        LabelMiddleRight = ... # type: QgsCallout.LabelAnchorPoint
        LabelBottomLeft = ... # type: QgsCallout.LabelAnchorPoint
        LabelBottomMiddle = ... # type: QgsCallout.LabelAnchorPoint
        LabelBottomRight = ... # type: QgsCallout.LabelAnchorPoint

    class AnchorPoint(enum.IntEnum):
        PoleOfInaccessibility = ... # type: QgsCallout.AnchorPoint
        PointOnExterior = ... # type: QgsCallout.AnchorPoint
        PointOnSurface = ... # type: QgsCallout.AnchorPoint
        Centroid = ... # type: QgsCallout.AnchorPoint

    class DrawOrder(enum.IntEnum):
        OrderBelowAllLabels = ... # type: QgsCallout.DrawOrder
        OrderBelowIndividualLabels = ... # type: QgsCallout.DrawOrder

    class Property(enum.IntEnum):
        MinimumCalloutLength = ... # type: QgsCallout.Property
        OffsetFromAnchor = ... # type: QgsCallout.Property
        OffsetFromLabel = ... # type: QgsCallout.Property
        DrawCalloutToAllParts = ... # type: QgsCallout.Property
        AnchorPointPosition = ... # type: QgsCallout.Property
        LabelAnchorPointPosition = ... # type: QgsCallout.Property
        OriginX = ... # type: QgsCallout.Property
        OriginY = ... # type: QgsCallout.Property
        DestinationX = ... # type: QgsCallout.Property
        DestinationY = ... # type: QgsCallout.Property
        Curvature = ... # type: QgsCallout.Property
        Orientation = ... # type: QgsCallout.Property
        Margins = ... # type: QgsCallout.Property
        WedgeWidth = ... # type: QgsCallout.Property
        CornerRadius = ... # type: QgsCallout.Property
        BlendMode = ... # type: QgsCallout.Property

    class QgsCalloutContext(PyQt6.sip.wrapper):

        allFeaturePartsLabeled = ... # type: bool
        originalFeatureCrs = ... # type: 'QgsCoordinateReferenceSystem'

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsCallout.QgsCalloutContext') -> None: ...

        def positions(self) -> list['QgsCalloutPosition']: ...
        def addCalloutPosition(self, position: 'QgsCalloutPosition') -> None: ...
        def originalFeatureToMapTransform(self, renderContext: QgsRenderContext) -> 'QgsCoordinateTransform': ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCallout') -> None: ...

    def calloutLineToPart(self, labelGeometry: 'QgsGeometry', partGeometry: 'QgsAbstractGeometry|None', context: QgsRenderContext, calloutContext: 'QgsCallout.QgsCalloutContext') -> typing.Tuple['QgsGeometry', bool]: ...
    def calloutLabelPoint(self, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: 'QgsCallout.LabelAnchorPoint', context: QgsRenderContext, calloutContext: 'QgsCallout.QgsCalloutContext') -> typing.Tuple['QgsGeometry', bool]: ...
    @deprecated("""""")
    def labelAnchorGeometry(self, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: 'QgsCallout.LabelAnchorPoint') -> 'QgsGeometry': ...
    def draw(self, context: QgsRenderContext, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: 'QgsGeometry', calloutContext: 'QgsCallout.QgsCalloutContext') -> None: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    @staticmethod
    def decodeLabelAnchorPoint(name: str|None) -> typing.Tuple['QgsCallout.LabelAnchorPoint', bool]: ...
    @staticmethod
    def encodeLabelAnchorPoint(anchor: 'QgsCallout.LabelAnchorPoint') -> str: ...
    def setLabelAnchorPoint(self, anchor: 'QgsCallout.LabelAnchorPoint') -> None: ...
    def labelAnchorPoint(self) -> 'QgsCallout.LabelAnchorPoint': ...
    @staticmethod
    def decodeAnchorPoint(name: str|None) -> typing.Tuple['QgsCallout.AnchorPoint', bool]: ...
    @staticmethod
    def encodeAnchorPoint(anchor: 'QgsCallout.AnchorPoint') -> str: ...
    def setAnchorPoint(self, anchor: 'QgsCallout.AnchorPoint') -> None: ...
    def anchorPoint(self) -> 'QgsCallout.AnchorPoint': ...
    @staticmethod
    def propertyDefinitions() -> dict[int, QgsPropertyDefinition]: ...
    def setDataDefinedProperties(self, collection: QgsPropertyCollection) -> None: ...
    def dataDefinedProperties(self) -> QgsPropertyCollection: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def render(self, context: QgsRenderContext, rect: QtCore.QRectF, angle: float, anchor: 'QgsGeometry', calloutContext: 'QgsCallout.QgsCalloutContext') -> None: ...
    def drawOrder(self) -> 'QgsCallout.DrawOrder': ...
    def referencedFields(self, context: QgsRenderContext) -> set[str]: ...
    def stopRender(self, context: QgsRenderContext) -> None: ...
    def startRender(self, context: QgsRenderContext) -> None: ...
    def containsAdvancedEffects(self) -> bool: ...
    def restoreProperties(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def saveProperties(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def readProperties(self, props: dict[str|None, typing.Any], context: QgsReadWriteContext) -> None: ...
    def properties(self, context: QgsReadWriteContext) -> dict[str, typing.Any]: ...
    def clone(self) -> 'QgsCallout|None': ...
    def type(self) -> str: ...


class QgsSimpleLineCallout(QgsCallout):

    def __init__(self) -> None: ...

    def createCalloutLine(self, start: 'QgsPoint', end: 'QgsPoint', context: QgsRenderContext, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: 'QgsGeometry', calloutContext: QgsCallout.QgsCalloutContext) -> 'QgsCurve|None': ...
    def draw(self, context: QgsRenderContext, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: 'QgsGeometry', calloutContext: QgsCallout.QgsCalloutContext) -> None: ...
    def setDrawCalloutToAllParts(self, drawToAllParts: bool) -> None: ...
    def drawCalloutToAllParts(self) -> bool: ...
    def offsetFromLabelMapUnitScale(self) -> QgsMapUnitScale: ...
    def setOffsetFromLabelMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def offsetFromLabelUnit(self) -> Qgis.RenderUnit: ...
    def setOffsetFromLabelUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setOffsetFromLabel(self, distance: float) -> None: ...
    def offsetFromLabel(self) -> float: ...
    def offsetFromAnchorMapUnitScale(self) -> QgsMapUnitScale: ...
    def setOffsetFromAnchorMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def offsetFromAnchorUnit(self) -> Qgis.RenderUnit: ...
    def setOffsetFromAnchorUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setOffsetFromAnchor(self, distance: float) -> None: ...
    def offsetFromAnchor(self) -> float: ...
    def minimumLengthMapUnitScale(self) -> QgsMapUnitScale: ...
    def setMinimumLengthMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def minimumLengthUnit(self) -> Qgis.RenderUnit: ...
    def setMinimumLengthUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setMinimumLength(self, length: float) -> None: ...
    def minimumLength(self) -> float: ...
    def setLineSymbol(self, symbol: 'QgsLineSymbol|None') -> None: ...
    def lineSymbol(self) -> 'QgsLineSymbol|None': ...
    def referencedFields(self, context: QgsRenderContext) -> set[str]: ...
    def stopRender(self, context: QgsRenderContext) -> None: ...
    def startRender(self, context: QgsRenderContext) -> None: ...
    def readProperties(self, props: dict[str|None, typing.Any], context: QgsReadWriteContext) -> None: ...
    def properties(self, context: QgsReadWriteContext) -> dict[str, typing.Any]: ...
    def clone(self) -> 'QgsSimpleLineCallout|None': ...
    def type(self) -> str: ...
    @staticmethod
    def create(properties: dict[str|None, typing.Any] = ..., context: QgsReadWriteContext = ...) -> QgsCallout|None: ...


class QgsManhattanLineCallout(QgsSimpleLineCallout):

    def __init__(self) -> None: ...

    def createCalloutLine(self, start: 'QgsPoint', end: 'QgsPoint', context: QgsRenderContext, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: 'QgsGeometry', calloutContext: QgsCallout.QgsCalloutContext) -> 'QgsCurve|None': ...
    def clone(self) -> 'QgsManhattanLineCallout|None': ...
    def type(self) -> str: ...
    @staticmethod
    def create(properties: dict[str|None, typing.Any] = ..., context: QgsReadWriteContext = ...) -> QgsCallout|None: ...


class QgsCurvedLineCallout(QgsSimpleLineCallout):

    class Orientation(enum.IntEnum):
        Automatic = ... # type: QgsCurvedLineCallout.Orientation
        Clockwise = ... # type: QgsCurvedLineCallout.Orientation
        CounterClockwise = ... # type: QgsCurvedLineCallout.Orientation

    def __init__(self) -> None: ...

    def createCalloutLine(self, start: 'QgsPoint', end: 'QgsPoint', context: QgsRenderContext, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: 'QgsGeometry', calloutContext: QgsCallout.QgsCalloutContext) -> 'QgsCurve|None': ...
    def setOrientation(self, orientation: 'QgsCurvedLineCallout.Orientation') -> None: ...
    def orientation(self) -> 'QgsCurvedLineCallout.Orientation': ...
    def setCurvature(self, curvature: float) -> None: ...
    def curvature(self) -> float: ...
    def properties(self, context: QgsReadWriteContext) -> dict[str, typing.Any]: ...
    def clone(self) -> 'QgsCurvedLineCallout|None': ...
    def type(self) -> str: ...
    @staticmethod
    def create(properties: dict[str|None, typing.Any] = ..., context: QgsReadWriteContext = ...) -> QgsCallout|None: ...


class QgsBalloonCallout(QgsCallout):

    def __init__(self) -> None: ...

    def draw(self, context: QgsRenderContext, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: 'QgsGeometry', calloutContext: QgsCallout.QgsCalloutContext) -> None: ...
    def cornerRadiusMapUnitScale(self) -> QgsMapUnitScale: ...
    def setCornerRadiusMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def cornerRadiusUnit(self) -> Qgis.RenderUnit: ...
    def setCornerRadiusUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setCornerRadius(self, radius: float) -> None: ...
    def cornerRadius(self) -> float: ...
    def wedgeWidthMapUnitScale(self) -> QgsMapUnitScale: ...
    def setWedgeWidthMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def wedgeWidthUnit(self) -> Qgis.RenderUnit: ...
    def setWedgeWidthUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setWedgeWidth(self, width: float) -> None: ...
    def wedgeWidth(self) -> float: ...
    def marginsUnit(self) -> Qgis.RenderUnit: ...
    def setMarginsUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setMargins(self, margins: QgsMargins) -> None: ...
    def margins(self) -> QgsMargins: ...
    def offsetFromAnchorMapUnitScale(self) -> QgsMapUnitScale: ...
    def setOffsetFromAnchorMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def offsetFromAnchorUnit(self) -> Qgis.RenderUnit: ...
    def setOffsetFromAnchorUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setOffsetFromAnchor(self, distance: float) -> None: ...
    def offsetFromAnchor(self) -> float: ...
    def setMarkerSymbol(self, symbol: 'QgsMarkerSymbol|None') -> None: ...
    def markerSymbol(self) -> 'QgsMarkerSymbol|None': ...
    def setFillSymbol(self, symbol: 'QgsFillSymbol|None') -> None: ...
    def fillSymbol(self) -> 'QgsFillSymbol|None': ...
    def referencedFields(self, context: QgsRenderContext) -> set[str]: ...
    def stopRender(self, context: QgsRenderContext) -> None: ...
    def startRender(self, context: QgsRenderContext) -> None: ...
    def readProperties(self, props: dict[str|None, typing.Any], context: QgsReadWriteContext) -> None: ...
    def properties(self, context: QgsReadWriteContext) -> dict[str, typing.Any]: ...
    def clone(self) -> 'QgsBalloonCallout|None': ...
    def type(self) -> str: ...
    @staticmethod
    def create(properties: dict[str|None, typing.Any] = ..., context: QgsReadWriteContext = ...) -> QgsCallout|None: ...


class QgsCalloutAbstractMetadata(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, name: str|None, visibleName: str|None, icon: QtGui.QIcon = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCalloutAbstractMetadata') -> None: ...

    def createCalloutWidget(self, a0: QgsMapLayer|None) -> QgsCalloutWidget|None: ...
    def createCallout(self, properties: dict[str|None, typing.Any], context: QgsReadWriteContext) -> QgsCallout|None: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def icon(self) -> QtGui.QIcon: ...
    def visibleName(self) -> str: ...
    def name(self) -> str: ...


class QgsCalloutMetadata(QgsCalloutAbstractMetadata):

    def __init__(self, a0: 'QgsCalloutMetadata') -> None: ...

    def createCalloutWidget(self, vl: QgsMapLayer|None) -> QgsCalloutWidget|None: ...
    def createCallout(self, properties: dict[str|None, typing.Any], context: QgsReadWriteContext) -> QgsCallout|None: ...


class QgsCalloutRegistry(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    @staticmethod
    def defaultCallout() -> QgsCallout|None: ...
    def calloutTypes(self) -> list[str]: ...
    @typing.overload
    def createCallout(self, type: str|None, properties: dict[str|None, typing.Any] = ..., context: QgsReadWriteContext = ...) -> QgsCallout|None: ...
    @typing.overload
    def createCallout(self, type: str|None, element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsCallout|None: ...
    def addCalloutType(self, metadata: QgsCalloutAbstractMetadata|None) -> bool: ...
    def calloutMetadata(self, type: str|None) -> QgsCalloutAbstractMetadata|None: ...


class QgsClassificationMethod(PyQt6.sip.wrapper):

    class ClassPosition(enum.IntEnum):
        LowerBound = ... # type: QgsClassificationMethod.ClassPosition
        Inner = ... # type: QgsClassificationMethod.ClassPosition
        UpperBound = ... # type: QgsClassificationMethod.ClassPosition

    class MethodProperty(enum.IntEnum):
        NoFlag = ... # type: QgsClassificationMethod.MethodProperty
        ValuesNotRequired = ... # type: QgsClassificationMethod.MethodProperty
        SymmetricModeAvailable = ... # type: QgsClassificationMethod.MethodProperty
        IgnoresClassCount = ... # type: QgsClassificationMethod.MethodProperty

    MAX_PRECISION = ... # type: int
    MIN_PRECISION = ... # type: int

    @typing.overload
    def __init__(self, properties: 'QgsClassificationMethod.MethodProperty' = ..., codeComplexity: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClassificationMethod') -> None: ...

    def addParameter(self, definition: 'QgsProcessingParameterDefinition|None') -> None: ...
    def formatNumber(self, value: float) -> str: ...
    def copyBase(self, c: 'QgsClassificationMethod|None') -> None: ...
    def parameterValues(self) -> dict[str, typing.Any]: ...
    def setParameterValues(self, values: dict[str|None, typing.Any]) -> None: ...
    def parameterDefinitions(self) -> list['QgsProcessingParameterDefinition']: ...
    def parameterDefinition(self, parameterName: str|None) -> 'QgsProcessingParameterDefinition|None': ...
    @staticmethod
    def makeBreaksSymmetric(breaks: collections.abc.Iterable[float], symmetryPoint: float, astride: bool) -> list[float]: ...
    @staticmethod
    def create(element: QtXml.QDomElement, context: QgsReadWriteContext) -> 'QgsClassificationMethod'|None: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def classesV2(self, layer: QgsVectorLayer|None, expression: str|None, nclasses: int) -> typing.Tuple[list['QgsClassificationRange'], str]: ...
    @typing.overload
    @deprecated("""""")
    def classes(self, layer: QgsVectorLayer|None, expression: str|None, nclasses: int) -> list['QgsClassificationRange']: ...
    @typing.overload
    def classes(self, values: collections.abc.Iterable[float], nclasses: int) -> list['QgsClassificationRange']: ...
    @typing.overload
    def classes(self, minimum: float, maximum: float, nclasses: int) -> list['QgsClassificationRange']: ...
    @staticmethod
    def rangesToBreaks(classes: collections.abc.Iterable['QgsClassificationRange']) -> list[float]: ...
    def setLabelTrimTrailingZeroes(self, trimTrailingZeroes: bool) -> None: ...
    def labelTrimTrailingZeroes(self) -> bool: ...
    def setLabelPrecision(self, labelPrecision: int) -> None: ...
    def labelPrecision(self) -> int: ...
    def setLabelFormat(self, format: str|None) -> None: ...
    def labelFormat(self) -> str: ...
    def setSymmetricMode(self, enabled: bool, symmetryPoint: float = ..., symmetryAstride: bool = ...) -> None: ...
    def symmetryAstride(self) -> bool: ...
    def symmetryPoint(self) -> float: ...
    def symmetricModeEnabled(self) -> bool: ...
    def symmetricModeAvailable(self) -> bool: ...
    def codeComplexity(self) -> int: ...
    def valuesRequired(self) -> bool: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    @typing.overload
    def labelForRange(self, lowerValue: float, upperValue: float, position: 'QgsClassificationMethod.ClassPosition' = ...) -> str: ...
    @typing.overload
    def labelForRange(self, range: 'QgsRendererRange', position: 'QgsClassificationMethod.ClassPosition' = ...) -> str: ...
    def flags(self) -> 'QgsClassificationMethod.MethodProperty': ...
    def icon(self) -> QtGui.QIcon: ...
    def id(self) -> str: ...
    def name(self) -> str: ...
    def clone(self) -> 'QgsClassificationMethod'|None: ...


class QgsClassificationCustom(QgsClassificationMethod):

    METHOD_ID = ... # type: str|None

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClassificationCustom') -> None: ...

    def valuesRequired(self) -> bool: ...
    def id(self) -> str: ...
    def name(self) -> str: ...
    def clone(self) -> QgsClassificationMethod|None: ...


class QgsClassificationEqualInterval(QgsClassificationMethod):

    METHOD_ID = ... # type: str|None

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClassificationEqualInterval') -> None: ...

    def valuesRequired(self) -> bool: ...
    def icon(self) -> QtGui.QIcon: ...
    def clone(self) -> QgsClassificationMethod|None: ...
    def id(self) -> str: ...
    def name(self) -> str: ...


class QgsClassificationFixedInterval(QgsClassificationMethod):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClassificationFixedInterval') -> None: ...

    def valuesRequired(self) -> bool: ...
    def icon(self) -> QtGui.QIcon: ...
    def id(self) -> str: ...
    def name(self) -> str: ...
    def clone(self) -> QgsClassificationMethod|None: ...


class QgsClassificationJenks(QgsClassificationMethod):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClassificationJenks') -> None: ...

    def icon(self) -> QtGui.QIcon: ...
    def clone(self) -> QgsClassificationMethod|None: ...
    def id(self) -> str: ...
    def name(self) -> str: ...


class QgsClassificationLogarithmic(QgsClassificationMethod):

    class NegativeValueHandling(enum.IntEnum):
        NoHandling = ... # type: QgsClassificationLogarithmic.NegativeValueHandling
        Discard = ... # type: QgsClassificationLogarithmic.NegativeValueHandling
        PrependBreak = ... # type: QgsClassificationLogarithmic.NegativeValueHandling

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClassificationLogarithmic') -> None: ...

    def valuesRequired(self) -> bool: ...
    def labelForRange(self, lowerValue: float, upperValue: float, position: QgsClassificationMethod.ClassPosition) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def id(self) -> str: ...
    def name(self) -> str: ...
    def clone(self) -> QgsClassificationMethod|None: ...


class QgsClassificationRange(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, label: str|None, lowerBound: float, upperBound: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClassificationRange') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def label(self) -> str: ...
    def upperBound(self) -> float: ...
    def lowerBound(self) -> float: ...


class QgsClassificationMethodRegistry(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClassificationMethodRegistry') -> None: ...

    def icon(self, id: str|None) -> QtGui.QIcon: ...
    def methodNames(self) -> dict[str, str]: ...
    def method(self, id: str|None) -> QgsClassificationMethod|None: ...
    def addMethod(self, method: QgsClassificationMethod|None) -> bool: ...


class QgsClassificationPrettyBreaks(QgsClassificationMethod):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClassificationPrettyBreaks') -> None: ...

    def valuesRequired(self) -> bool: ...
    def icon(self) -> QtGui.QIcon: ...
    def clone(self) -> QgsClassificationMethod|None: ...
    def id(self) -> str: ...
    def name(self) -> str: ...


class QgsClassificationQuantile(QgsClassificationMethod):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClassificationQuantile') -> None: ...

    def icon(self) -> QtGui.QIcon: ...
    def clone(self) -> QgsClassificationMethod|None: ...
    def id(self) -> str: ...
    def name(self) -> str: ...


class QgsClassificationStandardDeviation(QgsClassificationMethod):

    METHOD_ID = ... # type: str|None

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsClassificationStandardDeviation') -> None: ...

    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def labelForRange(self, lowerValue: float, upperValue: float, position: QgsClassificationMethod.ClassPosition) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def clone(self) -> QgsClassificationMethod|None: ...
    def id(self) -> str: ...
    def name(self) -> str: ...


class QgsDiagram(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsDiagram') -> None: ...

    def sizeForValue(self, value: float, s: QgsDiagramSettings, interpolationSettings: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def scaledFont(self, s: QgsDiagramSettings, c: QgsRenderContext) -> QtGui.QFont: ...
    @typing.overload
    def sizePainterUnits(self, size: QtCore.QSizeF, s: QgsDiagramSettings, c: QgsRenderContext) -> QtCore.QSizeF: ...
    @typing.overload
    def sizePainterUnits(self, l: float, s: QgsDiagramSettings, c: QgsRenderContext) -> float: ...
    def setPenWidth(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int, s: QgsDiagramSettings, c: QgsRenderContext) -> None: ...
    def legendSize(self, value: float, s: QgsDiagramSettings, interpolationSettings: QgsDiagramInterpolationSettings) -> float: ...
    @typing.overload
    def diagramSize(self, attributes: typing.Any, c: QgsRenderContext, s: QgsDiagramSettings) -> QtCore.QSizeF: ...
    @typing.overload
    def diagramSize(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, interpolationSettings: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def diagramName(self) -> str: ...
    def renderDiagram(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, position: QtCore.QPointF) -> None: ...
    def getExpression(self, expression: str|None, context: QgsExpressionContext) -> 'QgsExpression|None': ...
    def clearCache(self) -> None: ...
    def clone(self) -> 'QgsDiagram|None': ...


class QgsHistogramDiagram(QgsDiagram):

    def __init__(self) -> None: ...

    def diagramName(self) -> str: ...
    def legendSize(self, value: float, s: QgsDiagramSettings, interpolationSettings: QgsDiagramInterpolationSettings) -> float: ...
    @typing.overload
    def diagramSize(self, attributes: typing.Any, c: QgsRenderContext, s: QgsDiagramSettings) -> QtCore.QSizeF: ...
    @typing.overload
    def diagramSize(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, interpolationSettings: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def renderDiagram(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, position: QtCore.QPointF) -> None: ...
    def clone(self) -> 'QgsHistogramDiagram|None': ...


class QgsPieDiagram(QgsDiagram):

    def __init__(self) -> None: ...

    def diagramName(self) -> str: ...
    def legendSize(self, value: float, s: QgsDiagramSettings, interpolationSettings: QgsDiagramInterpolationSettings) -> float: ...
    @typing.overload
    def diagramSize(self, attributes: typing.Any, c: QgsRenderContext, s: QgsDiagramSettings) -> QtCore.QSizeF: ...
    @typing.overload
    def diagramSize(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, interpolationSettings: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def renderDiagram(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, position: QtCore.QPointF) -> None: ...
    def clone(self) -> 'QgsPieDiagram|None': ...


class QgsStackedBarDiagram(QgsDiagram):

    def __init__(self) -> None: ...

    def diagramName(self) -> str: ...
    def legendSize(self, value: float, s: QgsDiagramSettings, interpolationSettings: QgsDiagramInterpolationSettings) -> float: ...
    @typing.overload
    def diagramSize(self, attributes: typing.Any, c: QgsRenderContext, s: QgsDiagramSettings) -> QtCore.QSizeF: ...
    @typing.overload
    def diagramSize(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, interpolationSettings: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def renderDiagram(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, position: QtCore.QPointF) -> None: ...
    def clone(self) -> 'QgsStackedBarDiagram|None': ...


class QgsStackedDiagram(QgsDiagram):

    def __init__(self) -> None: ...

    def diagramName(self) -> str: ...
    def legendSize(self, value: float, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> float: ...
    @typing.overload
    def diagramSize(self, attributes: typing.Any, c: QgsRenderContext, s: QgsDiagramSettings) -> QtCore.QSizeF: ...
    @typing.overload
    def diagramSize(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def renderDiagram(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, position: QtCore.QPointF) -> None: ...
    def subDiagramPosition(self, newPos: QtCore.QPointF, c: QgsRenderContext, s: QgsDiagramSettings, subSettings: QgsDiagramSettings) -> None: ...
    def clone(self) -> 'QgsStackedDiagram|None': ...


class QgsTextDiagram(QgsDiagram):

    class Orientation(enum.IntEnum):
        Horizontal = ... # type: QgsTextDiagram.Orientation
        Vertical = ... # type: QgsTextDiagram.Orientation

    class Shape(enum.IntEnum):
        Circle = ... # type: QgsTextDiagram.Shape
        Rectangle = ... # type: QgsTextDiagram.Shape
        Triangle = ... # type: QgsTextDiagram.Shape

    def __init__(self) -> None: ...

    def diagramName(self) -> str: ...
    def legendSize(self, value: float, s: QgsDiagramSettings, interpolationSettings: QgsDiagramInterpolationSettings) -> float: ...
    @typing.overload
    def diagramSize(self, attributes: typing.Any, c: QgsRenderContext, s: QgsDiagramSettings) -> QtCore.QSizeF: ...
    @typing.overload
    def diagramSize(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, interpolationSettings: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def renderDiagram(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, position: QtCore.QPointF) -> None: ...
    def clone(self) -> 'QgsTextDiagram|None': ...


class QgsDxfExport(PyQt6.sip.wrapper):

    class DxfPolylineFlag(enum.IntEnum):
        Closed = ... # type: QgsDxfExport.DxfPolylineFlag
        Curve = ... # type: QgsDxfExport.DxfPolylineFlag
        Spline = ... # type: QgsDxfExport.DxfPolylineFlag
        Is3DPolyline = ... # type: QgsDxfExport.DxfPolylineFlag
        Is3DPolygonMesh = ... # type: QgsDxfExport.DxfPolylineFlag
        PolygonMesh = ... # type: QgsDxfExport.DxfPolylineFlag
        PolyfaceMesh = ... # type: QgsDxfExport.DxfPolylineFlag
        ContinuousPattern = ... # type: QgsDxfExport.DxfPolylineFlag

    class HAlign(enum.IntEnum):
        HLeft = ... # type: QgsDxfExport.HAlign
        HCenter = ... # type: QgsDxfExport.HAlign
        HRight = ... # type: QgsDxfExport.HAlign
        HAligned = ... # type: QgsDxfExport.HAlign
        HMiddle = ... # type: QgsDxfExport.HAlign
        HFit = ... # type: QgsDxfExport.HAlign
        Undefined = ... # type: QgsDxfExport.HAlign

    class VAlign(enum.IntEnum):
        VBaseLine = ... # type: QgsDxfExport.VAlign
        VBottom = ... # type: QgsDxfExport.VAlign
        VMiddle = ... # type: QgsDxfExport.VAlign
        VTop = ... # type: QgsDxfExport.VAlign
        Undefined = ... # type: QgsDxfExport.VAlign

    class ExportResult(enum.Enum):
        Success = ... # type: QgsDxfExport.ExportResult
        InvalidDeviceError = ... # type: QgsDxfExport.ExportResult
        DeviceNotWritableError = ... # type: QgsDxfExport.ExportResult
        EmptyExtentError = ... # type: QgsDxfExport.ExportResult

    class Flag(enum.IntEnum):
        FlagNoMText = ... # type: QgsDxfExport.Flag
        FlagOnlySelectedFeatures = ... # type: QgsDxfExport.Flag
        FlagHairlineWidthExport = ... # type: QgsDxfExport.Flag

    class DxfLayer(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self, vl: QgsVectorLayer|None, layerOutputAttributeIndex: int = ..., buildDDBlocks: bool = ..., ddBlocksMaxNumberOfClasses: int = ..., overriddenName: str|None = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsDxfExport.DxfLayer') -> None: ...

        def overriddenName(self) -> str: ...
        def dataDefinedBlocksMaximumNumberOfClasses(self) -> int: ...
        def buildDataDefinedBlocks(self) -> bool: ...
        def splitLayerAttribute(self) -> str: ...
        def layerOutputAttributeIndex(self) -> int: ...
        def layer(self) -> QgsVectorLayer|None: ...

    def __init__(self) -> None: ...

    def registerDxfLayer(self, layerId: str|None, fid: int, layer: str|None) -> None: ...
    @staticmethod
    def encodings() -> list[str]: ...
    @staticmethod
    def dxfEncoding(name: str|None) -> str: ...
    @staticmethod
    def dxfLayerName(name: str|None) -> str: ...
    def clipValueToMapUnitScale(self, scale: QgsMapUnitScale, pixelToMMFactor: float) -> float: ...
    @staticmethod
    def mapUnitScaleFactor(scale: float, symbolUnits: Qgis.RenderUnit, mapUnits: Qgis.DistanceUnit, mapUnitsPerPixel: float = ...) -> float: ...
    def writeMText(self, layer: str|None, text: str|None, pt: 'QgsPoint', width: float, angle: float, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def writeTextV2(self, layer: str|None, text: str|None, pt: 'QgsPoint', size: float, angle: float, color: QtGui.QColor|QtCore.Qt.GlobalColor|int, hali: 'QgsDxfExport.HAlign' = ..., vali: 'QgsDxfExport.VAlign' = ...) -> None: ...
    def writeCircleV2(self, layer: str|None, color: QtGui.QColor|QtCore.Qt.GlobalColor|int, pt: 'QgsPoint', radius: float, lineStyleName: str|None, width: float) -> None: ...
    def writeFillCircleV2(self, layer: str|None, color: QtGui.QColor|QtCore.Qt.GlobalColor|int, pt: 'QgsPoint', radius: float) -> None: ...
    def writePointV2(self, layer: str|None, color: QtGui.QColor|QtCore.Qt.GlobalColor|int, pt: 'QgsPoint') -> None: ...
    def writeLine(self, pt1: 'QgsPoint', pt2: 'QgsPoint', layer: str|None, lineStyleName: str|None, color: QtGui.QColor|QtCore.Qt.GlobalColor|int, width: float = ...) -> None: ...
    def writeHandle(self, code: int = ..., handle: int = ...) -> int: ...
    def writeString(self, s: str|None) -> None: ...
    def writeDouble(self, d: float) -> None: ...
    def writeInt(self, i: int) -> None: ...
    def writeGroupCode(self, code: int) -> None: ...
    def writeGroupPointV2(self, code: int, p: 'QgsPoint') -> None: ...
    @typing.overload
    def writeGroup(self, code: int, s: str|None) -> None: ...
    @typing.overload
    def writeGroup(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int, exactMatch: int = ..., rgbCode: int = ..., transparencyCode: int = ...) -> None: ...
    def writeGroupDouble(self, code: int, d: float) -> None: ...
    def writeGroupLong(self, code: int, i: int) -> None: ...
    def writeGroupInt(self, code: int, i: int) -> None: ...
    @typing.overload
    def layerName(self, id: str|None, f: QgsFeature) -> str: ...
    @typing.overload
    def layerName(self, vl: QgsVectorLayer|None) -> str: ...
    @staticmethod
    def closestColorMatch(color: int) -> int: ...
    def force2d(self) -> bool: ...
    def setForce2d(self, force2d: bool) -> None: ...
    def layerTitleAsName(self) -> bool: ...
    def setLayerTitleAsName(self, layerTitleAsName: bool) -> None: ...
    def extent(self) -> 'QgsRectangle': ...
    def setExtent(self, r: 'QgsRectangle') -> None: ...
    def symbologyExport(self) -> Qgis.FeatureSymbologyExport: ...
    def setSymbologyExport(self, e: Qgis.FeatureSymbologyExport) -> None: ...
    def destinationCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def setDestinationCrs(self, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    def mapUnits(self) -> Qgis.DistanceUnit: ...
    def symbologyScale(self) -> float: ...
    def setSymbologyScale(self, scale: float) -> None: ...
    def feedbackMessage(self) -> str: ...
    def writeToFile(self, d: QtCore.QIODevice|None, codec: str|None) -> 'QgsDxfExport.ExportResult': ...
    def addLayers(self, layers: collections.abc.Iterable['QgsDxfExport.DxfLayer']) -> None: ...
    def flags(self) -> 'QgsDxfExport.Flag': ...
    def setFlags(self, flags: 'QgsDxfExport.Flag') -> None: ...
    def setMapSettings(self, settings: QgsMapSettings) -> None: ...


class QgsEditFormConfig(PyQt6.sip.wrapper):

    class DataDefinedProperty(enum.IntEnum):
        NoProperty = ... # type: QgsEditFormConfig.DataDefinedProperty
        AllProperties = ... # type: QgsEditFormConfig.DataDefinedProperty
        Alias = ... # type: QgsEditFormConfig.DataDefinedProperty
        Editable = ... # type: QgsEditFormConfig.DataDefinedProperty

    class GroupData(PyQt6.sip.wrapper):

        mFields = ... # type: collections.abc.Iterable[str|None]
        mName = ... # type: str|None

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, name: str|None, fields: collections.abc.Iterable[str|None]) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsEditFormConfig.GroupData') -> None: ...

    class TabData(PyQt6.sip.wrapper):

        mFields = ... # type: collections.abc.Iterable[str|None]
        mGroups = ... # type: collections.abc.Iterable['QgsEditFormConfig.GroupData']
        mName = ... # type: str|None

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, name: str|None, fields: collections.abc.Iterable[str|None], groups: collections.abc.Iterable['QgsEditFormConfig.GroupData']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsEditFormConfig.TabData') -> None: ...

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, o: 'QgsEditFormConfig') -> None: ...
    @typing.overload
    def __init__(self) -> None: ...

    def __ne__(self, other: object): ...
    @staticmethod
    def propertyDefinitions() -> dict[int, QgsPropertyDefinition]: ...
    def dataDefinedFieldProperties(self, fieldName: str|None) -> QgsPropertyCollection: ...
    def setDataDefinedFieldProperties(self, fieldName: str|None, properties: QgsPropertyCollection) -> None: ...
    @deprecated("""""")
    def attributeEditorElementFromDomElement(self, elem: QtXml.QDomElement, parent: 'QgsAttributeEditorElement|None', layerId: str|None = ..., context: QgsReadWriteContext = ...) -> 'QgsAttributeEditorElement|None': ...
    def writeXml(self, node: QtXml.QDomNode, context: QgsReadWriteContext) -> None: ...
    def readXml(self, node: QtXml.QDomNode, context: QgsReadWriteContext) -> None: ...
    def setSuppress(self, s: Qgis.AttributeFormSuppression) -> None: ...
    def suppress(self) -> Qgis.AttributeFormSuppression: ...
    def setInitCodeSource(self, initCodeSource: Qgis.AttributeFormPythonInitCodeSource) -> None: ...
    def initCodeSource(self) -> Qgis.AttributeFormPythonInitCodeSource: ...
    def setInitFilePath(self, filePath: str|None) -> None: ...
    def initFilePath(self) -> str: ...
    def setInitCode(self, code: str|None) -> None: ...
    def initCode(self) -> str: ...
    def setInitFunction(self, function: str|None) -> None: ...
    def initFunction(self) -> str: ...
    def setReuseLastValuePolicy(self, index: int, policy: Qgis.AttributeFormReuseLastValuePolicy) -> None: ...
    def reuseLastValuePolicy(self, index: int) -> Qgis.AttributeFormReuseLastValuePolicy: ...
    def setReuseLastValue(self, index: int, reuse: bool) -> None: ...
    def reuseLastValue(self, index: int) -> bool: ...
    def setLabelOnTop(self, idx: int, onTop: bool) -> None: ...
    def labelOnTop(self, idx: int) -> bool: ...
    def setReadOnly(self, idx: int, readOnly: bool = ...) -> None: ...
    def readOnly(self, idx: int) -> bool: ...
    def removeWidgetConfig(self, widgetName: str|None) -> bool: ...
    def widgetConfig(self, widgetName: str|None) -> dict[str, typing.Any]: ...
    def setWidgetConfig(self, widgetName: str|None, config: dict[str|None, typing.Any]) -> bool: ...
    def setUiForm(self, ui: str|None) -> None: ...
    def uiForm(self) -> str: ...
    def setLayout(self, editorLayout: Qgis.AttributeFormLayout) -> None: ...
    def layout(self) -> Qgis.AttributeFormLayout: ...
    def invisibleRootContainer(self) -> 'QgsAttributeEditorContainer|None': ...
    def clearTabs(self) -> None: ...
    def tabs(self) -> list['QgsAttributeEditorElement']: ...
    def addTab(self, data: 'QgsAttributeEditorElement|None') -> None: ...
    def __eq__(self, other: object): ...


class QgsAttributeEditorElement(PyQt6.sip.wrapper):

    class LabelStyle(PyQt6.sip.wrapper):

        color = ... # type: QtGui.QColor|QtCore.Qt.GlobalColor|int
        font = ... # type: QtGui.QFont
        overrideColor = ... # type: bool
        overrideFont = ... # type: bool

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAttributeEditorElement.LabelStyle') -> None: ...

    @typing.overload
    def __init__(self, type: Qgis.AttributeEditorType, name: str|None, parent: 'QgsAttributeEditorElement|None' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAttributeEditorElement') -> None: ...

    def setLabelStyle(self, labelStyle: 'QgsAttributeEditorElement.LabelStyle') -> None: ...
    def labelStyle(self) -> 'QgsAttributeEditorElement.LabelStyle': ...
    def setVerticalStretch(self, stretch: int) -> None: ...
    def verticalStretch(self) -> int: ...
    def setHorizontalStretch(self, stretch: int) -> None: ...
    def horizontalStretch(self) -> int: ...
    def setShowLabel(self, showLabel: bool) -> None: ...
    def showLabel(self) -> bool: ...
    def clone(self, parent: 'QgsAttributeEditorElement|None') -> 'QgsAttributeEditorElement|None': ...
    def toDomElement(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    def parent(self) -> 'QgsAttributeEditorElement|None': ...
    def type(self) -> Qgis.AttributeEditorType: ...
    def name(self) -> str: ...
    @staticmethod
    def create(element: QtXml.QDomElement, layerId: str|None, fields: QgsFields, context: QgsReadWriteContext, parent: 'QgsAttributeEditorElement|None' = ...) -> 'QgsAttributeEditorElement|None': ...


class QgsAttributeEditorAction(QgsAttributeEditorElement):

    @typing.overload
    def __init__(self, action: QgsAction, parent: QgsAttributeEditorElement|None) -> None: ...
    @typing.overload
    def __init__(self, uuid: QtCore.QUuid, parent: QgsAttributeEditorElement|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAttributeEditorAction') -> None: ...

    def setAction(self, newAction: QgsAction) -> None: ...
    def action(self, layer: QgsVectorLayer|None) -> QgsAction: ...
    def clone(self, parent: QgsAttributeEditorElement|None) -> QgsAttributeEditorElement|None: ...


class QgsAttributeEditorContainer(QgsAttributeEditorElement):

    @typing.overload
    def __init__(self, name: str|None, parent: QgsAttributeEditorElement|None, backgroundColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAttributeEditorContainer') -> None: ...

    def setBackgroundColor(self, backgroundColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setVisibilityExpression(self, visibilityExpression: QgsOptionalExpression) -> None: ...
    def visibilityExpression(self) -> QgsOptionalExpression: ...
    def clone(self, parent: QgsAttributeEditorElement|None) -> QgsAttributeEditorElement|None: ...
    def setColumnCount(self, columnCount: int) -> None: ...
    def columnCount(self) -> int: ...
    def setName(self, name: str|None) -> None: ...
    def clear(self) -> None: ...
    def findElements(self, type: Qgis.AttributeEditorType) -> list[QgsAttributeEditorElement]: ...
    def children(self) -> list[QgsAttributeEditorElement]: ...
    def setCollapsed(self, collapsed: bool) -> None: ...
    def collapsed(self) -> bool: ...
    @deprecated("""""")
    def isGroupBox(self) -> bool: ...
    @deprecated("""""")
    def setIsGroupBox(self, isGroupBox: bool) -> None: ...
    def type(self) -> Qgis.AttributeEditorContainerType: ...
    def setType(self, type: Qgis.AttributeEditorContainerType) -> None: ...
    def addChildElement(self, element: QgsAttributeEditorElement|None) -> None: ...


class QgsAttributeEditorField(QgsAttributeEditorElement):

    @typing.overload
    def __init__(self, name: str|None, idx: int, parent: QgsAttributeEditorElement|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAttributeEditorField') -> None: ...

    def clone(self, parent: QgsAttributeEditorElement|None) -> QgsAttributeEditorElement|None: ...
    def idx(self) -> int: ...


class QgsAttributeEditorRelation(QgsAttributeEditorElement):

    class Button(enum.IntEnum):
        Link = ... # type: QgsAttributeEditorRelation.Button
        Unlink = ... # type: QgsAttributeEditorRelation.Button
        SaveChildEdits = ... # type: QgsAttributeEditorRelation.Button
        AddChildFeature = ... # type: QgsAttributeEditorRelation.Button
        DuplicateChildFeature = ... # type: QgsAttributeEditorRelation.Button
        DeleteChildFeature = ... # type: QgsAttributeEditorRelation.Button
        ZoomToChildFeature = ... # type: QgsAttributeEditorRelation.Button
        AllButtons = ... # type: QgsAttributeEditorRelation.Button

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, name: str|None, relationId: str|None, parent: QgsAttributeEditorElement|None) -> None: ...
    @typing.overload
    def __init__(self, name: str|None, relation: QgsRelation, parent: QgsAttributeEditorElement|None) -> None: ...
    @typing.overload
    def __init__(self, relationId: str|None, parent: QgsAttributeEditorElement|None) -> None: ...
    @typing.overload
    def __init__(self, relation: QgsRelation, parent: QgsAttributeEditorElement|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAttributeEditorRelation') -> None: ...

    def setRelationEditorConfiguration(self, config: dict[str|None, typing.Any]) -> None: ...
    def relationEditorConfiguration(self) -> dict[str, typing.Any]: ...
    def setRelationWidgetTypeId(self, relationWidgetTypeId: str|None) -> None: ...
    def relationWidgetTypeId(self) -> str: ...
    def setLabel(self, label: str|None = ...) -> None: ...
    def label(self) -> str: ...
    def setNmRelationId(self, nmRelationId: typing.Any = ...) -> None: ...
    def nmRelationId(self) -> typing.Any: ...
    def setForceSuppressFormPopup(self, forceSuppressFormPopup: bool) -> None: ...
    def forceSuppressFormPopup(self) -> bool: ...
    def clone(self, parent: QgsAttributeEditorElement|None) -> QgsAttributeEditorElement|None: ...
    def init(self, relManager: QgsRelationManager|None) -> bool: ...
    def relation(self) -> QgsRelation: ...


class QgsAttributeEditorHtmlElement(QgsAttributeEditorElement):

    @typing.overload
    def __init__(self, name: str|None, parent: QgsAttributeEditorElement|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAttributeEditorHtmlElement') -> None: ...

    def setHtmlCode(self, htmlCode: str|None) -> None: ...
    def htmlCode(self) -> str: ...
    def clone(self, parent: QgsAttributeEditorElement|None) -> QgsAttributeEditorElement|None: ...


class QgsAttributeEditorTextElement(QgsAttributeEditorElement):

    @typing.overload
    def __init__(self, name: str|None, parent: QgsAttributeEditorElement|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAttributeEditorTextElement') -> None: ...

    def setText(self, text: str|None) -> None: ...
    def text(self) -> str: ...
    def clone(self, parent: QgsAttributeEditorElement|None) -> QgsAttributeEditorElement|None: ...


class QgsAttributeEditorQmlElement(QgsAttributeEditorElement):

    @typing.overload
    def __init__(self, name: str|None, parent: QgsAttributeEditorElement|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAttributeEditorQmlElement') -> None: ...

    def setQmlCode(self, qmlCode: str|None) -> None: ...
    def qmlCode(self) -> str: ...
    def clone(self, parent: QgsAttributeEditorElement|None) -> QgsAttributeEditorElement|None: ...


class QgsAttributeEditorSpacerElement(QgsAttributeEditorElement):

    @typing.overload
    def __init__(self, name: str|None, parent: QgsAttributeEditorElement|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAttributeEditorSpacerElement') -> None: ...

    def setDrawLine(self, drawLine: bool) -> None: ...
    def drawLine(self) -> bool: ...
    def clone(self, parent: QgsAttributeEditorElement|None) -> QgsAttributeEditorElement|None: ...


class QgsProfileRenderContext(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, context: QgsRenderContext) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsProfileRenderContext') -> None: ...

    def setElevationRange(self, range: QgsDoubleRange) -> None: ...
    def elevationRange(self) -> QgsDoubleRange: ...
    def setDistanceRange(self, range: QgsDoubleRange) -> None: ...
    def distanceRange(self) -> QgsDoubleRange: ...
    def setWorldTransform(self, transform: QtGui.QTransform) -> None: ...
    def worldTransform(self) -> QtGui.QTransform: ...
    def renderContext(self) -> QgsRenderContext: ...


class QgsProfileIdentifyContext(PyQt6.sip.wrapper):

    displayRatioElevationVsDistance = ... # type: float
    maximumPointDistanceDelta = ... # type: float
    maximumPointElevationDelta = ... # type: float
    maximumSurfaceDistanceDelta = ... # type: float
    maximumSurfaceElevationDelta = ... # type: float
    project = ... # type: 'QgsProject'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsProfileIdentifyContext') -> None: ...


class QgsProfileIdentifyResults(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, layer: QgsMapLayer|None = ..., results: collections.abc.Iterable[dict[str, typing.Any]] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsProfileIdentifyResults') -> None: ...

    def results(self) -> collections.abc.Iterable[dict[str, typing.Any]]: ...
    def layer(self) -> QgsMapLayer|None: ...


class QgsAbstractProfileResults(PyQt6.sip.wrapper):

    class Feature(PyQt6.sip.wrapper):

        attributes = ... # type: dict[str|None, typing.Any]
        geometry = ... # type: 'QgsGeometry'
        layerIdentifier = ... # type: str|None

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAbstractProfileResults.Feature') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractProfileResults') -> None: ...

    def copyPropertiesFromGenerator(self, generator: 'QgsAbstractProfileGenerator|None') -> None: ...
    @typing.overload
    def identify(self, point: 'QgsProfilePoint', context: QgsProfileIdentifyContext) -> list[QgsProfileIdentifyResults]: ...
    @typing.overload
    def identify(self, distanceRange: QgsDoubleRange, elevationRange: QgsDoubleRange, context: QgsProfileIdentifyContext) -> list[QgsProfileIdentifyResults]: ...
    def snapPoint(self, point: 'QgsProfilePoint', context: 'QgsProfileSnapContext') -> 'QgsProfileSnapResult': ...
    def zRange(self) -> QgsDoubleRange: ...
    def renderResults(self, context: QgsProfileRenderContext) -> None: ...
    def asFeatures(self, type: Qgis.ProfileExportType, feedback: QgsFeedback|None = ...) -> list['QgsAbstractProfileResults.Feature']: ...
    def asGeometries(self) -> list['QgsGeometry']: ...
    def sampledPoints(self) -> list['QgsPoint']: ...
    def distanceToHeightMap(self) -> typing.Any: ...
    def type(self) -> str: ...


class QgsProfileGenerationContext(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsProfileGenerationContext') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def convertDistanceToPixels(self, size: float, unit: Qgis.RenderUnit) -> float: ...
    def dpi(self) -> float: ...
    def setDpi(self, dpi: float) -> None: ...
    def setElevationRange(self, range: QgsDoubleRange) -> None: ...
    def elevationRange(self) -> QgsDoubleRange: ...
    def setDistanceRange(self, range: QgsDoubleRange) -> None: ...
    def distanceRange(self) -> QgsDoubleRange: ...
    def setMapUnitsPerDistancePixel(self, units: float) -> None: ...
    def mapUnitsPerDistancePixel(self) -> float: ...
    def setMaximumErrorMapUnits(self, error: float) -> None: ...
    def maximumErrorMapUnits(self) -> float: ...


class QgsAbstractProfileGenerator(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractProfileGenerator') -> None: ...

    def type(self) -> str: ...
    def takeResults(self) -> QgsAbstractProfileResults|None: ...
    def feedback(self) -> QgsFeedback|None: ...
    def generateProfile(self, context: QgsProfileGenerationContext = ...) -> bool: ...
    def flags(self) -> Qgis.ProfileGeneratorFlag: ...
    def sourceId(self) -> str: ...


class QgsElevationProfile(QtCore.QObject):

    def __init__(self, project: 'QgsProject|None') -> None: ...

    useProjectLayerTreeChanged: typing.ClassVar[QtCore.pyqtSignal]
    nameChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setUseProjectLayerTree(self, useProjectTree: bool) -> None: ...
    def setDistanceUnit(self, unit: Qgis.DistanceUnit) -> None: ...
    def setLockAxisScales(self, lock: bool) -> None: ...
    def setTolerance(self, tolerance: float) -> None: ...
    def setCrs(self, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    def setName(self, name: str|None) -> None: ...
    def setSubsectionsSymbol(self, symbol: 'QgsLineSymbol|None') -> None: ...
    def subsectionsSymbol(self) -> 'QgsLineSymbol|None': ...
    def distanceUnit(self) -> Qgis.DistanceUnit: ...
    def lockAxisScales(self) -> bool: ...
    def tolerance(self) -> float: ...
    def profileCurve(self) -> 'QgsCurve|None': ...
    def setProfileCurve(self, curve: 'QgsCurve|None') -> None: ...
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...
    def useProjectLayerTree(self) -> bool: ...
    def layerTree(self) -> 'QgsLayerTree|None': ...
    def icon(self) -> QtGui.QIcon: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def readXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def name(self) -> str: ...


class QgsProjectStoredObjectManagerBase(QtCore.QObject):

    def __init__(self, project: 'QgsProject|None' = ...) -> None: ...

    def markProjectDirty(self) -> None: ...
    objectAboutToBeRemoved: typing.ClassVar[QtCore.pyqtSignal]
    objectRemoved: typing.ClassVar[QtCore.pyqtSignal]
    objectAdded: typing.ClassVar[QtCore.pyqtSignal]
    objectAboutToBeAdded: typing.ClassVar[QtCore.pyqtSignal]


class QgsElevationProfileManager(QgsProjectStoredObjectManagerBase):

    def __init__(self, project: 'QgsProject|None' = ...) -> None: ...

    def setupObjectConnections(self, profile: QgsElevationProfile|None) -> None: ...
    profileRenamed: typing.ClassVar[QtCore.pyqtSignal]
    profileAboutToBeRemoved: typing.ClassVar[QtCore.pyqtSignal]
    profileRemoved: typing.ClassVar[QtCore.pyqtSignal]
    profileAdded: typing.ClassVar[QtCore.pyqtSignal]
    profileAboutToBeAdded: typing.ClassVar[QtCore.pyqtSignal]
    def generateUniqueTitle(self) -> str: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def profileByName(self, name: str|None) -> QgsElevationProfile|None: ...
    def profiles(self) -> list[QgsElevationProfile]: ...
    def clear(self) -> None: ...
    def removeProfile(self, profile: QgsElevationProfile|None) -> bool: ...
    def addProfile(self, profile: QgsElevationProfile|None) -> bool: ...


class QgsProjectStoredObjectManagerModelBase(QtCore.QAbstractListModel):

    class CustomRole(enum.IntEnum):
        Object = ... # type: QgsProjectStoredObjectManagerModelBase.CustomRole
        IsEmptyObject = ... # type: QgsProjectStoredObjectManagerModelBase.CustomRole

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlag: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def rowCount(self, parent: QtCore.QModelIndex) -> int: ...


class QgsElevationProfileManagerModel(QgsProjectStoredObjectManagerModelBase):

    class CustomRole(enum.IntEnum):
        ElevationProfile = ... # type: QgsElevationProfileManagerModel.CustomRole

    def __init__(self, manager: QgsElevationProfileManager|None, parent: QtCore.QObject|None = ...) -> None: ...

    def indexFromProfile(self, profile: QgsElevationProfile|None) -> QtCore.QModelIndex: ...
    def profileFromIndex(self, index: QtCore.QModelIndex) -> QgsElevationProfile|None: ...


class QgsProjectStoredObjectManagerProxyModelBase(QtCore.QSortFilterProxyModel):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def filterAcceptsRowInternal(self, sourceRow: int, sourceParent: QtCore.QModelIndex) -> bool: ...
    def setFilterString(self, filter: str|None) -> None: ...
    def filterString(self) -> str: ...
    def filterAcceptsRow(self, sourceRow: int, sourceParent: QtCore.QModelIndex) -> bool: ...
    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...


class QgsElevationProfileManagerProxyModel(QgsProjectStoredObjectManagerProxyModelBase):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...


class QgsProfileExporter(PyQt6.sip.wrapper):

    def __init__(self, sources: collections.abc.Iterable[QgsAbstractProfileSource], request: 'QgsProfileRequest', type: Qgis.ProfileExportType) -> None: ...

    def toLayers(self) -> list[QgsVectorLayer]: ...
    def run(self, feedback: QgsFeedback|None = ...) -> None: ...


class QgsProfileExporterTask(QgsTask):

    class ExportResult(enum.Enum):
        Success = ... # type: QgsProfileExporterTask.ExportResult
        Empty = ... # type: QgsProfileExporterTask.ExportResult
        DeviceError = ... # type: QgsProfileExporterTask.ExportResult
        DxfExportFailed = ... # type: QgsProfileExporterTask.ExportResult
        LayerExportFailed = ... # type: QgsProfileExporterTask.ExportResult
        Canceled = ... # type: QgsProfileExporterTask.ExportResult

    def __init__(self, sources: collections.abc.Iterable[QgsAbstractProfileSource], request: 'QgsProfileRequest', type: Qgis.ProfileExportType, destination: str|None, transformContext: 'QgsCoordinateTransformContext') -> None: ...

    def error(self) -> str: ...
    def createdFiles(self) -> list[str]: ...
    def result(self) -> 'QgsProfileExporterTask.ExportResult': ...
    def takeLayers(self) -> list[QgsVectorLayer]: ...
    def cancel(self) -> None: ...
    def run(self) -> bool: ...


class QgsProfilePoint(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, distance: float, elevation: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsProfilePoint') -> None: ...

    def __getitem__(self, a0: int) -> typing.Any: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def isEmpty(self) -> bool: ...
    def elevation(self) -> float: ...
    def distance(self) -> float: ...
    def setElevation(self, elevation: float) -> None: ...
    def setDistance(self, distance: float) -> None: ...


class QgsProfilePlotRenderer(QtCore.QObject):

    def __init__(self, sources: collections.abc.Iterable[QgsAbstractProfileSource], request: 'QgsProfileRequest') -> None: ...

    generationFinished: typing.ClassVar[QtCore.pyqtSignal]
    def asFeatures(self, type: Qgis.ProfileExportType, feedback: QgsFeedback|None = ...) -> list[QgsAbstractProfileResults.Feature]: ...
    @typing.overload
    def identify(self, point: QgsProfilePoint, context: QgsProfileIdentifyContext) -> list[QgsProfileIdentifyResults]: ...
    @typing.overload
    def identify(self, distanceRange: QgsDoubleRange, elevationRange: QgsDoubleRange, context: QgsProfileIdentifyContext) -> list[QgsProfileIdentifyResults]: ...
    def snapPoint(self, point: QgsProfilePoint, context: 'QgsProfileSnapContext') -> 'QgsProfileSnapResult': ...
    def renderSubsectionsIndicator(self, context: QgsRenderContext, plotArea: QtCore.QRectF, distanceMin: float, distanceMax: float, zMin: float, zMax: float) -> None: ...
    def setSubsectionsSymbol(self, symbol: 'QgsLineSymbol|None') -> None: ...
    def subsectionsSymbol(self) -> 'QgsLineSymbol|None': ...
    @staticmethod
    def defaultSubSectionsSymbol() -> 'QgsLineSymbol'|None: ...
    def render(self, context: QgsRenderContext, width: float, height: float, distanceMin: float, distanceMax: float, zMin: float, zMax: float, sourceId: str|None = ...) -> None: ...
    def renderToImage(self, width: int, height: int, distanceMin: float, distanceMax: float, zMin: float, zMax: float, sourceId: str|None = ..., devicePixelRatio: float = ...) -> QtGui.QImage: ...
    def zRange(self) -> QgsDoubleRange: ...
    def regenerateInvalidatedResults(self) -> None: ...
    def invalidateResults(self, source: QgsAbstractProfileSource|None) -> bool: ...
    def replaceSource(self, source: QgsAbstractProfileSource|None) -> None: ...
    def invalidateAllRefinableSources(self) -> None: ...
    def setContext(self, context: QgsProfileGenerationContext) -> None: ...
    def isActive(self) -> bool: ...
    def waitForFinished(self) -> None: ...
    def cancelGenerationWithoutBlocking(self) -> None: ...
    def cancelGeneration(self) -> None: ...
    def generateSynchronously(self) -> None: ...
    def startGeneration(self) -> None: ...
    def sourceIds(self) -> list[str]: ...


class QgsProfileRequest(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, curve: 'QgsCurve|None') -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsProfileRequest') -> None: ...

    def setExpressionContext(self, context: QgsExpressionContext) -> 'QgsProfileRequest': ...
    def expressionContext(self) -> QgsExpressionContext: ...
    def stepDistance(self) -> float: ...
    def setStepDistance(self, distance: float) -> 'QgsProfileRequest': ...
    def terrainProvider(self) -> 'QgsAbstractTerrainProvider|None': ...
    def setTerrainProvider(self, provider: 'QgsAbstractTerrainProvider|None') -> 'QgsProfileRequest': ...
    def tolerance(self) -> float: ...
    def setTolerance(self, tolerance: float) -> 'QgsProfileRequest': ...
    def setTransformContext(self, context: 'QgsCoordinateTransformContext') -> 'QgsProfileRequest': ...
    def transformContext(self) -> 'QgsCoordinateTransformContext': ...
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...
    def setCrs(self, crs: 'QgsCoordinateReferenceSystem') -> 'QgsProfileRequest': ...
    def profileCurve(self) -> 'QgsCurve|None': ...
    def setProfileCurve(self, curve: 'QgsCurve|None') -> 'QgsProfileRequest': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsProfileSnapContext(PyQt6.sip.wrapper):

    displayRatioElevationVsDistance = ... # type: float
    maximumPointDistanceDelta = ... # type: float
    maximumPointElevationDelta = ... # type: float
    maximumSurfaceDistanceDelta = ... # type: float
    maximumSurfaceElevationDelta = ... # type: float

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsProfileSnapContext') -> None: ...


class QgsProfileSnapResult(PyQt6.sip.wrapper):

    snappedPoint = ... # type: QgsProfilePoint

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsProfileSnapResult') -> None: ...

    def isValid(self) -> bool: ...


class QgsProfileSourceRegistry(QtCore.QObject):

    def __init__(self) -> None: ...

    profileSourceUnregistered: typing.ClassVar[QtCore.pyqtSignal]
    profileSourceRegistered: typing.ClassVar[QtCore.pyqtSignal]
    def findSourceById(self, sourceId: str|None) -> QgsAbstractProfileSource|None: ...
    @typing.overload
    @deprecated("""""")
    def unregisterProfileSource(self, source: QgsAbstractProfileSource|None) -> bool: ...
    @typing.overload
    def unregisterProfileSource(self, sourceId: str|None) -> bool: ...
    def registerProfileSource(self, source: QgsAbstractProfileSource|None) -> bool: ...
    def profileSources(self) -> list[QgsAbstractProfileSource]: ...


class QgsAbstractTerrainProvider(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def readCommonProperties(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeCommonProperties(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def setOffset(self, offset: float) -> None: ...
    def offset(self) -> float: ...
    def setScale(self, scale: float) -> None: ...
    def scale(self) -> float: ...
    def heightAt(self, x: float, y: float) -> float: ...
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...
    def prepare(self) -> None: ...
    def clone(self) -> 'QgsAbstractTerrainProvider|None': ...
    def type(self) -> str: ...
    def writeXml(self, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def equals(self, other: 'QgsAbstractTerrainProvider|None') -> bool: ...


class QgsFlatTerrainProvider(QgsAbstractTerrainProvider):

    def __init__(self) -> None: ...

    def equals(self, other: QgsAbstractTerrainProvider|None) -> bool: ...
    def prepare(self) -> None: ...
    def clone(self) -> 'QgsFlatTerrainProvider|None': ...
    def heightAt(self, x: float, y: float) -> float: ...
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...
    def writeXml(self, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def type(self) -> str: ...


class QgsRasterDemTerrainProvider(QgsAbstractTerrainProvider):

    def __init__(self) -> None: ...

    def layer(self) -> 'QgsRasterLayer|None': ...
    def setLayer(self, layer: 'QgsRasterLayer|None') -> None: ...
    def prepare(self) -> None: ...
    def equals(self, other: QgsAbstractTerrainProvider|None) -> bool: ...
    def clone(self) -> 'QgsRasterDemTerrainProvider|None': ...
    def heightAt(self, x: float, y: float) -> float: ...
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...
    def writeXml(self, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def type(self) -> str: ...


class QgsMeshTerrainProvider(QgsAbstractTerrainProvider):

    def __init__(self) -> None: ...

    def layer(self) -> 'QgsMeshLayer|None': ...
    def setLayer(self, layer: 'QgsMeshLayer|None') -> None: ...
    def prepare(self) -> None: ...
    def equals(self, other: QgsAbstractTerrainProvider|None) -> bool: ...
    def clone(self) -> 'QgsMeshTerrainProvider|None': ...
    def heightAt(self, x: float, y: float) -> float: ...
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...
    def writeXml(self, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def type(self) -> str: ...


class QgsExternalStorage(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsExternalStorage') -> None: ...

    def doFetch(self, url: str|None, authCfg: str|None = ...) -> 'QgsExternalStorageFetchedContent|None': ...
    def doStore(self, filePath: str|None, url: str|None, authCfg: str|None = ...) -> 'QgsExternalStorageStoredContent|None': ...
    def fetch(self, url: str|None, authCfg: str|None = ..., fetchingMode: Qgis.ActionStart = ...) -> 'QgsExternalStorageFetchedContent|None': ...
    def store(self, filePath: str|None, url: str|None, authCfg: str|None = ..., storingMode: Qgis.ActionStart = ...) -> 'QgsExternalStorageStoredContent|None': ...
    def displayName(self) -> str: ...
    def type(self) -> str: ...


class QgsExternalStorageContent(QtCore.QObject):

    def __init__(self) -> None: ...

    def setStatus(self, status: Qgis.ContentStatus) -> None: ...
    def reportError(self, errorMsg: str|None) -> None: ...
    canceled: typing.ClassVar[QtCore.pyqtSignal]
    progressChanged: typing.ClassVar[QtCore.pyqtSignal]
    errorOccurred: typing.ClassVar[QtCore.pyqtSignal]
    def cancel(self) -> None: ...
    def errorString(self) -> str: ...
    def status(self) -> Qgis.ContentStatus: ...


class QgsExternalStorageFetchedContent(QgsExternalStorageContent):

    def __init__(self) -> None: ...

    fetched: typing.ClassVar[QtCore.pyqtSignal]
    def fetch(self) -> None: ...
    def filePath(self) -> str: ...


class QgsExternalStorageStoredContent(QgsExternalStorageContent):

    def __init__(self) -> None: ...

    stored: typing.ClassVar[QtCore.pyqtSignal]
    def store(self) -> None: ...
    def url(self) -> str: ...


class QgsExternalStorageRegistry(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsExternalStorageRegistry') -> None: ...

    def unregisterExternalStorage(self, storage: QgsExternalStorage|None) -> None: ...
    def registerExternalStorage(self, storage: QgsExternalStorage|None) -> None: ...
    def externalStorages(self) -> list[QgsExternalStorage]: ...
    def externalStorageFromType(self, type: str|None) -> QgsExternalStorage|None: ...


class QgsPaintEffect(PyQt6.sip.wrapper):

    class DrawMode(enum.IntEnum):
        Modifier = ... # type: QgsPaintEffect.DrawMode
        Render = ... # type: QgsPaintEffect.DrawMode
        ModifyAndRender = ... # type: QgsPaintEffect.DrawMode

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsPaintEffect') -> None: ...

    @deprecated("""""")
    def fixQPictureDpi(self, painter: QtGui.QPainter|None) -> None: ...
    def boundingRect(self, rect: QtCore.QRectF, context: QgsRenderContext) -> QtCore.QRectF: ...
    def imageOffset(self, context: QgsRenderContext) -> QtCore.QPointF: ...
    def sourceAsImage(self, context: QgsRenderContext) -> QtGui.QImage: ...
    def source(self) -> QtGui.QPicture: ...
    def drawSource(self, painter: QtGui.QPainter) -> None: ...
    def draw(self, context: QgsRenderContext) -> None: ...
    def setDrawMode(self, drawMode: 'QgsPaintEffect.DrawMode') -> None: ...
    def drawMode(self) -> 'QgsPaintEffect.DrawMode': ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def end(self, context: QgsRenderContext) -> None: ...
    def begin(self, context: QgsRenderContext) -> None: ...
    def render(self, picture: QtGui.QPicture, context: QgsRenderContext) -> None: ...
    def saveProperties(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement) -> bool: ...
    @typing.overload
    def readProperties(self, props: dict[str|None, typing.Any]) -> None: ...
    @typing.overload
    def readProperties(self, element: QtXml.QDomElement) -> bool: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def flags(self) -> Qgis.PaintEffectFlag: ...
    def clone(self) -> 'QgsPaintEffect|None': ...
    def type(self) -> str: ...


class QgsBlurEffect(QgsPaintEffect):

    class BlurMethod(enum.IntEnum):
        StackBlur = ... # type: QgsBlurEffect.BlurMethod
        GaussianBlur = ... # type: QgsBlurEffect.BlurMethod

    def __init__(self) -> None: ...

    def boundingRect(self, rect: QtCore.QRectF, context: QgsRenderContext) -> QtCore.QRectF: ...
    def draw(self, context: QgsRenderContext) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def blurMethod(self) -> 'QgsBlurEffect.BlurMethod': ...
    def setBlurMethod(self, method: 'QgsBlurEffect.BlurMethod') -> None: ...
    def blurMapUnitScale(self) -> QgsMapUnitScale: ...
    def setBlurMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def blurUnit(self) -> Qgis.RenderUnit: ...
    def setBlurUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def blurLevel(self) -> float: ...
    def setBlurLevel(self, level: float) -> None: ...
    def clone(self) -> 'QgsBlurEffect|None': ...
    def readProperties(self, props: dict[str|None, typing.Any]) -> None: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def type(self) -> str: ...
    def flags(self) -> Qgis.PaintEffectFlag: ...
    @staticmethod
    def create(map: dict[str|None, typing.Any]) -> QgsPaintEffect|None: ...


class QgsColorEffect(QgsPaintEffect):

    def __init__(self) -> None: ...

    def draw(self, context: QgsRenderContext) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def colorizeStrength(self) -> int: ...
    def setColorizeStrength(self, colorizeStrength: int) -> None: ...
    def colorizeColor(self) -> QtGui.QColor: ...
    def setColorizeColor(self, colorizeColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def colorizeOn(self) -> bool: ...
    def setColorizeOn(self, colorizeOn: bool) -> None: ...
    def grayscaleMode(self) -> 'QgsImageOperation.GrayscaleMode': ...
    def setGrayscaleMode(self, grayscaleMode: 'QgsImageOperation.GrayscaleMode') -> None: ...
    def saturation(self) -> float: ...
    def setSaturation(self, saturation: float) -> None: ...
    def contrast(self) -> int: ...
    def setContrast(self, contrast: int) -> None: ...
    def brightness(self) -> int: ...
    def setBrightness(self, brightness: int) -> None: ...
    def clone(self) -> 'QgsColorEffect|None': ...
    def readProperties(self, props: dict[str|None, typing.Any]) -> None: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def type(self) -> str: ...
    def flags(self) -> Qgis.PaintEffectFlag: ...
    @staticmethod
    def create(map: dict[str|None, typing.Any]) -> QgsPaintEffect|None: ...


class QgsEffectStack(QgsPaintEffect):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsEffectStack') -> None: ...
    @typing.overload
    def __init__(self, effect: QgsPaintEffect) -> None: ...

    def draw(self, context: QgsRenderContext) -> None: ...
    def effect(self, index: int) -> QgsPaintEffect|None: ...
    def count(self) -> int: ...
    def effectList(self) -> list[QgsPaintEffect]: ...
    def takeEffect(self, index: int) -> QgsPaintEffect|None: ...
    def changeEffect(self, index: int, effect: QgsPaintEffect|None) -> bool: ...
    def insertEffect(self, index: int, effect: QgsPaintEffect|None) -> bool: ...
    def appendEffect(self, effect: QgsPaintEffect|None) -> None: ...
    def properties(self) -> dict[str, typing.Any]: ...
    @typing.overload
    def readProperties(self, element: QtXml.QDomElement) -> bool: ...
    @typing.overload
    def readProperties(self, props: dict[str|None, typing.Any]) -> None: ...
    def saveProperties(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement) -> bool: ...
    def clone(self) -> 'QgsEffectStack|None': ...
    def type(self) -> str: ...
    def flags(self) -> Qgis.PaintEffectFlag: ...
    @staticmethod
    def create(map: dict[str|None, typing.Any]) -> QgsPaintEffect|None: ...


class QgsGlowEffect(QgsPaintEffect):

    class GlowColorType(enum.IntEnum):
        SingleColor = ... # type: QgsGlowEffect.GlowColorType
        ColorRamp = ... # type: QgsGlowEffect.GlowColorType

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsGlowEffect') -> None: ...

    def shadeExterior(self) -> bool: ...
    def draw(self, context: QgsRenderContext) -> None: ...
    def boundingRect(self, rect: QtCore.QRectF, context: QgsRenderContext) -> QtCore.QRectF: ...
    def colorType(self) -> 'QgsGlowEffect.GlowColorType': ...
    def setColorType(self, colorType: 'QgsGlowEffect.GlowColorType') -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def ramp(self) -> QgsColorRamp|None: ...
    def setRamp(self, ramp: QgsColorRamp|None) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def blurMapUnitScale(self) -> QgsMapUnitScale: ...
    def setBlurMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def blurUnit(self) -> Qgis.RenderUnit: ...
    def setBlurUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def blurLevel(self) -> float: ...
    def setBlurLevel(self, level: float) -> None: ...
    def spreadMapUnitScale(self) -> QgsMapUnitScale: ...
    def setSpreadMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def spreadUnit(self) -> Qgis.RenderUnit: ...
    def setSpreadUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def spread(self) -> float: ...
    def setSpread(self, spread: float) -> None: ...
    def readProperties(self, props: dict[str|None, typing.Any]) -> None: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def flags(self) -> Qgis.PaintEffectFlag: ...


class QgsOuterGlowEffect(QgsGlowEffect):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsOuterGlowEffect') -> None: ...

    def shadeExterior(self) -> bool: ...
    def clone(self) -> 'QgsOuterGlowEffect|None': ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: dict[str|None, typing.Any]) -> QgsPaintEffect|None: ...


class QgsInnerGlowEffect(QgsGlowEffect):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsInnerGlowEffect') -> None: ...

    def shadeExterior(self) -> bool: ...
    def clone(self) -> 'QgsInnerGlowEffect|None': ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: dict[str|None, typing.Any]) -> QgsPaintEffect|None: ...


class QgsImageOperation(PyQt6.sip.wrapper):

    class FlipType(enum.IntEnum):
        FlipHorizontal = ... # type: QgsImageOperation.FlipType
        FlipVertical = ... # type: QgsImageOperation.FlipType

    class GrayscaleMode(enum.IntEnum):
        GrayscaleLightness = ... # type: QgsImageOperation.GrayscaleMode
        GrayscaleLuminosity = ... # type: QgsImageOperation.GrayscaleMode
        GrayscaleAverage = ... # type: QgsImageOperation.GrayscaleMode
        GrayscaleOff = ... # type: QgsImageOperation.GrayscaleMode

    class DistanceTransformProperties(PyQt6.sip.wrapper):

        ramp = ... # type: QgsColorRamp
        shadeExterior = ... # type: bool
        spread = ... # type: float
        useMaxDistance = ... # type: bool

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsImageOperation.DistanceTransformProperties') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsImageOperation') -> None: ...

    @staticmethod
    def cropTransparent(image: QtGui.QImage, minSize: QtCore.QSize = ..., center: bool = ...) -> QtGui.QImage: ...
    @staticmethod
    def nonTransparentImageRect(image: QtGui.QImage, minSize: QtCore.QSize = ..., center: bool = ...) -> QtCore.QRect: ...
    @staticmethod
    def flipImage(image: QtGui.QImage, type: 'QgsImageOperation.FlipType') -> None: ...
    @staticmethod
    def gaussianBlur(image: QtGui.QImage, radius: int, feedback: QgsFeedback|None = ...) -> QtGui.QImage|None: ...
    @staticmethod
    def stackBlur(image: QtGui.QImage, radius: int, alphaOnly: bool = ..., feedback: QgsFeedback|None = ...) -> None: ...
    @staticmethod
    def distanceTransform(image: QtGui.QImage, properties: 'QgsImageOperation.DistanceTransformProperties', feedback: QgsFeedback|None = ...) -> None: ...
    @staticmethod
    def overlayColor(image: QtGui.QImage, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    @staticmethod
    def multiplyOpacity(image: QtGui.QImage, factor: float, feedback: QgsFeedback|None = ...) -> None: ...
    @staticmethod
    def adjustHueSaturation(image: QtGui.QImage, saturation: float, colorizeColor: QtGui.QColor|QtCore.Qt.GlobalColor|int = ..., colorizeStrength: float = ..., feedback: QgsFeedback|None = ...) -> None: ...
    @staticmethod
    def adjustBrightnessContrast(image: QtGui.QImage, brightness: int, contrast: float, feedback: QgsFeedback|None = ...) -> None: ...
    @staticmethod
    def convertToGrayscale(image: QtGui.QImage, mode: 'QgsImageOperation.GrayscaleMode' = ..., feedback: QgsFeedback|None = ...) -> None: ...


class QgsDrawSourceEffect(QgsPaintEffect):

    def __init__(self) -> None: ...

    def draw(self, context: QgsRenderContext) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def readProperties(self, props: dict[str|None, typing.Any]) -> None: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def clone(self) -> 'QgsDrawSourceEffect|None': ...
    def type(self) -> str: ...
    def flags(self) -> Qgis.PaintEffectFlag: ...
    @staticmethod
    def create(map: dict[str|None, typing.Any]) -> QgsPaintEffect|None: ...


class QgsEffectPainter(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, renderContext: QgsRenderContext) -> None: ...
    @typing.overload
    def __init__(self, renderContext: QgsRenderContext, effect: QgsPaintEffect|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsEffectPainter') -> None: ...

    def setEffect(self, effect: QgsPaintEffect|None) -> None: ...


class QgsPaintEffectAbstractMetadata(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, name: str|None, visibleName: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPaintEffectAbstractMetadata') -> None: ...

    def createWidget(self) -> QgsPaintEffectWidget|None: ...
    def createPaintEffect(self, map: dict[str|None, typing.Any]) -> QgsPaintEffect|None: ...
    def visibleName(self) -> str: ...
    def name(self) -> str: ...


class QgsPaintEffectRegistry(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    @staticmethod
    def isDefaultStack(effect: QgsPaintEffect|None) -> bool: ...
    @staticmethod
    def defaultStack() -> QgsPaintEffect|None: ...
    def effects(self) -> list[str]: ...
    @typing.overload
    def createEffect(self, name: str|None, properties: dict[str|None, typing.Any] = ...) -> QgsPaintEffect|None: ...
    @typing.overload
    def createEffect(self, element: QtXml.QDomElement) -> QgsPaintEffect|None: ...
    def addEffectType(self, metadata: QgsPaintEffectAbstractMetadata|None) -> bool: ...
    def effectMetadata(self, name: str|None) -> QgsPaintEffectAbstractMetadata|None: ...


class QgsShadowEffect(QgsPaintEffect):

    def __init__(self) -> None: ...

    def exteriorShadow(self) -> bool: ...
    def draw(self, context: QgsRenderContext) -> None: ...
    def boundingRect(self, rect: QtCore.QRectF, context: QgsRenderContext) -> QtCore.QRectF: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def offsetMapUnitScale(self) -> QgsMapUnitScale: ...
    def setOffsetMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def offsetUnit(self) -> Qgis.RenderUnit: ...
    def setOffsetUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def offsetDistance(self) -> float: ...
    def setOffsetDistance(self, distance: float) -> None: ...
    def offsetAngle(self) -> int: ...
    def setOffsetAngle(self, angle: int) -> None: ...
    def blurMapUnitScale(self) -> QgsMapUnitScale: ...
    def setBlurMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def blurUnit(self) -> Qgis.RenderUnit: ...
    def setBlurUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def blurLevel(self) -> float: ...
    def setBlurLevel(self, level: float) -> None: ...
    def readProperties(self, props: dict[str|None, typing.Any]) -> None: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def flags(self) -> Qgis.PaintEffectFlag: ...


class QgsDropShadowEffect(QgsShadowEffect):

    def __init__(self) -> None: ...

    def exteriorShadow(self) -> bool: ...
    def clone(self) -> 'QgsDropShadowEffect|None': ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: dict[str|None, typing.Any]) -> QgsPaintEffect|None: ...


class QgsInnerShadowEffect(QgsShadowEffect):

    def __init__(self) -> None: ...

    def exteriorShadow(self) -> bool: ...
    def clone(self) -> 'QgsInnerShadowEffect|None': ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: dict[str|None, typing.Any]) -> QgsPaintEffect|None: ...


class QgsTransformEffect(QgsPaintEffect):

    def __init__(self) -> None: ...

    def boundingRect(self, rect: QtCore.QRectF, context: QgsRenderContext) -> QtCore.QRectF: ...
    def draw(self, context: QgsRenderContext) -> None: ...
    def reflectY(self) -> bool: ...
    def setReflectY(self, reflectY: bool) -> None: ...
    def reflectX(self) -> bool: ...
    def setReflectX(self, reflectX: bool) -> None: ...
    def shearY(self) -> float: ...
    def setShearY(self, shearY: float) -> None: ...
    def shearX(self) -> float: ...
    def setShearX(self, shearX: float) -> None: ...
    def rotation(self) -> float: ...
    def setRotation(self, rotation: float) -> None: ...
    def scaleY(self) -> float: ...
    def setScaleY(self, scaleY: float) -> None: ...
    def scaleX(self) -> float: ...
    def setScaleX(self, scaleX: float) -> None: ...
    def translateMapUnitScale(self) -> QgsMapUnitScale: ...
    def setTranslateMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def translateUnit(self) -> Qgis.RenderUnit: ...
    def setTranslateUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def translateY(self) -> float: ...
    def setTranslateY(self, translateY: float) -> None: ...
    def translateX(self) -> float: ...
    def setTranslateX(self, translateX: float) -> None: ...
    def clone(self) -> 'QgsTransformEffect|None': ...
    def readProperties(self, props: dict[str|None, typing.Any]) -> None: ...
    def properties(self) -> dict[str, typing.Any]: ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: dict[str|None, typing.Any]) -> QgsPaintEffect|None: ...


class QgsExpression(PyQt6.sip.wrapper):

    class SpatialOperator(enum.IntEnum):
        soBbox = ... # type: QgsExpression.SpatialOperator
        soIntersects = ... # type: QgsExpression.SpatialOperator
        soContains = ... # type: QgsExpression.SpatialOperator
        soCrosses = ... # type: QgsExpression.SpatialOperator
        soEquals = ... # type: QgsExpression.SpatialOperator
        soDisjoint = ... # type: QgsExpression.SpatialOperator
        soOverlaps = ... # type: QgsExpression.SpatialOperator
        soTouches = ... # type: QgsExpression.SpatialOperator
        soWithin = ... # type: QgsExpression.SpatialOperator

    class ParserError(PyQt6.sip.wrapper):

        class ParserErrorType(enum.IntEnum):
            Unknown = ... # type: QgsExpression.ParserError.ParserErrorType
            FunctionUnknown = ... # type: QgsExpression.ParserError.ParserErrorType
            FunctionWrongArgs = ... # type: QgsExpression.ParserError.ParserErrorType
            FunctionInvalidParams = ... # type: QgsExpression.ParserError.ParserErrorType
            FunctionNamedArgsError = ... # type: QgsExpression.ParserError.ParserErrorType

        errorMsg = ... # type: str|None
        errorType = ... # type: 'QgsExpression.ParserError.ParserErrorType'
        firstColumn = ... # type: int
        firstLine = ... # type: int
        lastColumn = ... # type: int
        lastLine = ... # type: int

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsExpression.ParserError') -> None: ...

    @typing.overload
    def __init__(self, expr: str|None) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsExpression') -> None: ...
    @typing.overload
    def __init__(self) -> None: ...

    def __ne__(self, other: object): ...
    def __repr__(self) -> typing.Any: ...
    @staticmethod
    def attemptReduceToInClause(expressions: collections.abc.Iterable[str|None]) -> typing.Tuple[bool, str]: ...
    @staticmethod
    def isFieldEqualityExpression(expression: str|None) -> typing.Tuple[bool, str, typing.Any]: ...
    @typing.overload
    @staticmethod
    def createFieldEqualityExpression(fieldName: str|None, value: typing.Any, fieldType: QtCore.QMetaType.Type = ...) -> str: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def createFieldEqualityExpression(fieldName: str|None, value: typing.Any, fieldType: typing.Any) -> str: ...
    @staticmethod
    def formatPreviewString(value: typing.Any, htmlOutput: bool = ..., maximumPreviewLength: int = ...) -> str: ...
    @staticmethod
    def group(group: str|None) -> str: ...
    @staticmethod
    def formatVariableHelp(description: str|None, showValue: bool = ..., value: typing.Any = ...) -> str: ...
    @staticmethod
    def variableHelpText(variableName: str|None) -> str: ...
    @staticmethod
    def addVariableHelpText(name: str|None, description: str|None) -> bool: ...
    @staticmethod
    def tags(name: str|None) -> list[str]: ...
    @staticmethod
    def helpText(name: str|None) -> str: ...
    @typing.overload
    @staticmethod
    def quotedValue(value: typing.Any) -> str: ...
    @typing.overload
    @staticmethod
    def quotedValue(value: typing.Any, type: QtCore.QMetaType.Type) -> str: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def quotedValue(value: typing.Any, type: typing.Any) -> str: ...
    @staticmethod
    def quotedString(text: str|None) -> str: ...
    @staticmethod
    def quotedColumnRef(name: str|None) -> str: ...
    @staticmethod
    def functionCount() -> int: ...
    @staticmethod
    def functionIndex(name: str|None) -> int: ...
    @staticmethod
    def isFunctionName(name: str|None) -> bool: ...
    @staticmethod
    def cleanRegisteredFunctions() -> None: ...
    @staticmethod
    def unregisterFunction(name: str|None) -> bool: ...
    @staticmethod
    def registerFunction(function: QgsExpressionFunction|None, transferOwnership: bool = ...) -> bool: ...
    @staticmethod
    def BuiltinFunctions() -> list[str]: ...
    @staticmethod
    def Functions() -> list[QgsExpressionFunction]: ...
    @staticmethod
    def evaluateToDouble(text: str|None, fallbackValue: float) -> float: ...
    @staticmethod
    def replaceExpressionText(action: str|None, context: QgsExpressionContext|None, distanceArea: QgsDistanceArea|None = ...) -> str: ...
    def setAreaUnits(self, unit: Qgis.AreaUnit) -> None: ...
    def areaUnits(self) -> Qgis.AreaUnit: ...
    def setDistanceUnits(self, unit: Qgis.DistanceUnit) -> None: ...
    def distanceUnits(self) -> Qgis.DistanceUnit: ...
    def setGeomCalculator(self, calc: QgsDistanceArea|None) -> None: ...
    def geomCalculator(self) -> QgsDistanceArea|None: ...
    def dump(self) -> str: ...
    def expression(self) -> str: ...
    def setExpression(self, expression: str|None) -> None: ...
    @staticmethod
    def checkExpression(text: str|None, context: QgsExpressionContext|None) -> typing.Tuple[bool, str]: ...
    @staticmethod
    def quoteFieldExpression(expression: str|None, layer: QgsVectorLayer|None) -> str: ...
    @staticmethod
    def expressionToLayerFieldIndex(expression: str|None, layer: QgsVectorLayer|None) -> int: ...
    def isField(self) -> bool: ...
    def setEvalErrorString(self, str: str|None) -> None: ...
    def evalErrorString(self) -> str: ...
    def hasEvalError(self) -> bool: ...
    @typing.overload
    def evaluate(self) -> typing.Any: ...
    @typing.overload
    def evaluate(self, context: QgsExpressionContext|None) -> typing.Any: ...
    def needsGeometry(self) -> bool: ...
    def referencedAttributeIndexes(self, fields: QgsFields) -> typing.Any: ...
    def referencedFunctions(self) -> set[str]: ...
    @typing.overload
    def referencedVariables(self) -> set[str]: ...
    @typing.overload
    @staticmethod
    def referencedVariables(text: str|None) -> set[str]: ...
    def referencedColumns(self) -> set[str]: ...
    def prepare(self, context: QgsExpressionContext|None) -> bool: ...
    def rootNode(self) -> 'QgsExpressionNode|None': ...
    def parserErrors(self) -> list['QgsExpression.ParserError']: ...
    def parserErrorString(self) -> str: ...
    def hasParserError(self) -> bool: ...
    def isValid(self) -> bool: ...
    def __eq__(self, other: object): ...


class QgsExpressionContextUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsExpressionContextUtils') -> None: ...

    @staticmethod
    def meshExpressionScope(elementType: 'QgsMesh.ElementType') -> QgsExpressionContextScope|None: ...
    @staticmethod
    def registerContextFunctions() -> None: ...
    @staticmethod
    def notificationScope(message: str|None = ...) -> QgsExpressionContextScope|None: ...
    @staticmethod
    def processingModelAlgorithmScope(model: 'QgsProcessingModelAlgorithm|None', parameters: dict[str|None, typing.Any], context: 'QgsProcessingContext') -> QgsExpressionContextScope|None: ...
    @staticmethod
    def processingAlgorithmScope(algorithm: 'QgsProcessingAlgorithm|None', parameters: dict[str|None, typing.Any], context: 'QgsProcessingContext') -> QgsExpressionContextScope|None: ...
    @staticmethod
    def createFeatureBasedContext(feature: QgsFeature, fields: QgsFields) -> QgsExpressionContext: ...
    @staticmethod
    def setLayoutMultiFrameVariables(frame: 'QgsLayoutMultiFrame|None', variables: dict[str|None, typing.Any]) -> None: ...
    @staticmethod
    def setLayoutMultiFrameVariable(frame: 'QgsLayoutMultiFrame|None', name: str|None, value: typing.Any) -> None: ...
    @staticmethod
    def multiFrameScope(frame: 'QgsLayoutMultiFrame|None') -> QgsExpressionContextScope|None: ...
    @staticmethod
    def setLayoutItemVariables(item: 'QgsLayoutItem|None', variables: dict[str|None, typing.Any]) -> None: ...
    @staticmethod
    def setLayoutItemVariable(item: 'QgsLayoutItem|None', name: str|None, value: typing.Any) -> None: ...
    @staticmethod
    def layoutItemScope(item: 'QgsLayoutItem|None') -> QgsExpressionContextScope|None: ...
    @staticmethod
    def atlasScope(atlas: 'QgsLayoutAtlas|None') -> QgsExpressionContextScope|None: ...
    @staticmethod
    def setLayoutVariables(layout: 'QgsLayout|None', variables: dict[str|None, typing.Any]) -> None: ...
    @staticmethod
    def setLayoutVariable(layout: 'QgsLayout|None', name: str|None, value: typing.Any) -> None: ...
    @staticmethod
    def layoutScope(layout: 'QgsLayout|None') -> QgsExpressionContextScope|None: ...
    @staticmethod
    def updateSymbolScope(symbol: 'QgsSymbol|None', symbolScope: QgsExpressionContextScope|None = ...) -> QgsExpressionContextScope|None: ...
    @staticmethod
    def mapLayerPositionScope(position: QgsPointXY) -> QgsExpressionContextScope|None: ...
    @staticmethod
    def mapToolCaptureScope(matches: collections.abc.Iterable[QgsPointLocator.Match]) -> QgsExpressionContextScope|None: ...
    @staticmethod
    def mapSettingsScope(mapSettings: QgsMapSettings) -> QgsExpressionContextScope|None: ...
    @staticmethod
    def setLayerVariables(layer: QgsMapLayer|None, variables: dict[str|None, typing.Any]) -> None: ...
    @staticmethod
    def setLayerVariable(layer: QgsMapLayer|None, name: str|None, value: typing.Any) -> None: ...
    @staticmethod
    def globalProjectLayerScopes(layer: QgsMapLayer|None) -> list[QgsExpressionContextScope]: ...
    @staticmethod
    def layerScope(layer: QgsMapLayer|None) -> QgsExpressionContextScope|None: ...
    @staticmethod
    def removeProjectVariable(project: 'QgsProject|None', name: str|None) -> None: ...
    @staticmethod
    def setProjectVariables(project: 'QgsProject|None', variables: dict[str|None, typing.Any]) -> None: ...
    @staticmethod
    def setProjectVariable(project: 'QgsProject|None', name: str|None, value: typing.Any) -> None: ...
    @staticmethod
    def projectScope(project: 'QgsProject|None') -> QgsExpressionContextScope|None: ...
    @staticmethod
    def removeGlobalVariable(name: str|None) -> None: ...
    @staticmethod
    def setGlobalVariables(variables: dict[str|None, typing.Any]) -> None: ...
    @staticmethod
    def setGlobalVariable(name: str|None, value: typing.Any) -> None: ...
    @staticmethod
    def parentFormScope(formFeature: QgsFeature = ..., formMode: str|None = ...) -> QgsExpressionContextScope|None: ...
    @staticmethod
    def formScope(formFeature: QgsFeature = ..., formMode: str|None = ...) -> QgsExpressionContextScope|None: ...
    @staticmethod
    def globalScope() -> QgsExpressionContextScope|None: ...


class QgsExpressionNode(PyQt6.sip.wrapper):

    class NodeType(enum.IntEnum):
        ntUnaryOperator = ... # type: QgsExpressionNode.NodeType
        ntBinaryOperator = ... # type: QgsExpressionNode.NodeType
        ntInOperator = ... # type: QgsExpressionNode.NodeType
        ntFunction = ... # type: QgsExpressionNode.NodeType
        ntLiteral = ... # type: QgsExpressionNode.NodeType
        ntColumnRef = ... # type: QgsExpressionNode.NodeType
        ntCondition = ... # type: QgsExpressionNode.NodeType
        ntIndexOperator = ... # type: QgsExpressionNode.NodeType
        ntBetweenOperator = ... # type: QgsExpressionNode.NodeType

    class NamedNode(PyQt6.sip.wrapper):

        name = ... # type: str|None
        node = ... # type: 'QgsExpressionNode'

        @typing.overload
        def __init__(self, name: str|None, node: 'QgsExpressionNode|None') -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsExpressionNode.NamedNode') -> None: ...

    class NodeList(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsExpressionNode.NodeList') -> None: ...

        def dump(self) -> str: ...
        def clone(self) -> 'QgsExpressionNode.NodeList|None': ...
        def names(self) -> list[str]: ...
        def at(self, i: int) -> 'QgsExpressionNode|None': ...
        def list(self) -> list['QgsExpressionNode']: ...
        def hasNamedNodes(self) -> bool: ...
        def reserve(self, size: int) -> None: ...
        def count(self) -> int: ...
        @typing.overload
        def append(self, node: 'QgsExpressionNode|None') -> None: ...
        @typing.overload
        def append(self, node: 'QgsExpressionNode.NamedNode|None') -> None: ...

    parserFirstColumn = ... # type: int
    parserFirstLine = ... # type: int
    parserLastColumn = ... # type: int
    parserLastLine = ... # type: int

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsExpressionNode') -> None: ...

    def effectiveNode(self) -> 'QgsExpressionNode|None': ...
    def cachedStaticValue(self) -> typing.Any: ...
    def hasCachedStaticValue(self) -> bool: ...
    def prepare(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def isStatic(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def needsGeometry(self) -> bool: ...
    def referencedFunctions(self) -> set[str]: ...
    def referencedVariables(self) -> set[str]: ...
    def referencedColumns(self) -> set[str]: ...
    def clone(self) -> 'QgsExpressionNode|None': ...
    def eval(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> typing.Any: ...
    def dump(self) -> str: ...
    def nodeType(self) -> 'QgsExpressionNode.NodeType': ...


class QgsExpressionNodeUnaryOperator(QgsExpressionNode):

    class UnaryOperator(enum.IntEnum):
        uoNot = ... # type: QgsExpressionNodeUnaryOperator.UnaryOperator
        uoMinus = ... # type: QgsExpressionNodeUnaryOperator.UnaryOperator

    def __init__(self, op: 'QgsExpressionNodeUnaryOperator.UnaryOperator', operand: QgsExpressionNode|None) -> None: ...

    def text(self) -> str: ...
    def isStatic(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def clone(self) -> QgsExpressionNode|None: ...
    def referencedFunctions(self) -> set[str]: ...
    def referencedVariables(self) -> set[str]: ...
    def referencedColumns(self) -> set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def operand(self) -> QgsExpressionNode|None: ...
    def op(self) -> 'QgsExpressionNodeUnaryOperator.UnaryOperator': ...
    def __repr__(self) -> typing.Any: ...


class QgsExpressionNodeBinaryOperator(QgsExpressionNode):

    class BinaryOperator(enum.IntEnum):
        boOr = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boAnd = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boEQ = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boNE = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boLE = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boGE = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boLT = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boGT = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boRegexp = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boLike = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boNotLike = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boILike = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boNotILike = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boIs = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boIsNot = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boPlus = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boMinus = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boMul = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boDiv = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boIntDiv = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boMod = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boPow = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator
        boConcat = ... # type: QgsExpressionNodeBinaryOperator.BinaryOperator

    def __init__(self, op: 'QgsExpressionNodeBinaryOperator.BinaryOperator', opLeft: QgsExpressionNode|None, opRight: QgsExpressionNode|None) -> None: ...

    def text(self) -> str: ...
    def leftAssociative(self) -> bool: ...
    def precedence(self) -> int: ...
    def isStatic(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def clone(self) -> QgsExpressionNode|None: ...
    def needsGeometry(self) -> bool: ...
    def referencedFunctions(self) -> set[str]: ...
    def referencedVariables(self) -> set[str]: ...
    def referencedColumns(self) -> set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def opRight(self) -> QgsExpressionNode|None: ...
    def opLeft(self) -> QgsExpressionNode|None: ...
    def op(self) -> 'QgsExpressionNodeBinaryOperator.BinaryOperator': ...
    def __repr__(self) -> typing.Any: ...


class QgsExpressionNodeIndexOperator(QgsExpressionNode):

    def __init__(self, container: QgsExpressionNode|None, index: QgsExpressionNode|None) -> None: ...

    def isStatic(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def clone(self) -> QgsExpressionNode|None: ...
    def needsGeometry(self) -> bool: ...
    def referencedFunctions(self) -> set[str]: ...
    def referencedVariables(self) -> set[str]: ...
    def referencedColumns(self) -> set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def index(self) -> QgsExpressionNode|None: ...
    def container(self) -> QgsExpressionNode|None: ...


class QgsExpressionNodeBetweenOperator(QgsExpressionNode):

    def __init__(self, node: QgsExpressionNode|None, nodeLowerBound: QgsExpressionNode|None, nodeHigherBound: QgsExpressionNode|None, negate: bool = ...) -> None: ...

    def negate(self) -> bool: ...
    def higherBound(self) -> QgsExpressionNode|None: ...
    def lowerBound(self) -> QgsExpressionNode|None: ...
    def isStatic(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def clone(self) -> QgsExpressionNode|None: ...
    def referencedFunctions(self) -> set[str]: ...
    def referencedVariables(self) -> set[str]: ...
    def referencedColumns(self) -> set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def node(self) -> QgsExpressionNode|None: ...


class QgsExpressionNodeInOperator(QgsExpressionNode):

    def __init__(self, node: QgsExpressionNode|None, list: QgsExpressionNode.NodeList|None, notin: bool = ...) -> None: ...

    def isStatic(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def clone(self) -> QgsExpressionNode|None: ...
    def referencedFunctions(self) -> set[str]: ...
    def referencedVariables(self) -> set[str]: ...
    def referencedColumns(self) -> set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def list(self) -> QgsExpressionNode.NodeList|None: ...
    def isNotIn(self) -> bool: ...
    def node(self) -> QgsExpressionNode|None: ...


class QgsExpressionNodeFunction(QgsExpressionNode):

    def __init__(self, fnIndex: int, args: QgsExpressionNode.NodeList|None) -> None: ...

    @staticmethod
    def validateParams(fnIndex: int, args: QgsExpressionNode.NodeList|None, error: str|None) -> bool: ...
    def isStatic(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def clone(self) -> QgsExpressionNode|None: ...
    def referencedFunctions(self) -> set[str]: ...
    def referencedVariables(self) -> set[str]: ...
    def referencedColumns(self) -> set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def args(self) -> QgsExpressionNode.NodeList|None: ...
    def fnIndex(self) -> int: ...
    def __repr__(self) -> typing.Any: ...


class QgsExpressionNodeLiteral(QgsExpressionNode):

    @typing.overload
    def __init__(self, value: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsExpressionNodeLiteral') -> None: ...

    def valueAsString(self) -> str: ...
    def isStatic(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def clone(self) -> QgsExpressionNode|None: ...
    def referencedFunctions(self) -> set[str]: ...
    def referencedVariables(self) -> set[str]: ...
    def referencedColumns(self) -> set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def value(self) -> typing.Any: ...
    def __repr__(self) -> typing.Any: ...


class QgsExpressionNodeColumnRef(QgsExpressionNode):

    @typing.overload
    def __init__(self, name: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsExpressionNodeColumnRef') -> None: ...

    def isStatic(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def clone(self) -> QgsExpressionNode|None: ...
    def needsGeometry(self) -> bool: ...
    def referencedFunctions(self) -> set[str]: ...
    def referencedVariables(self) -> set[str]: ...
    def referencedColumns(self) -> set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def name(self) -> str: ...
    def __repr__(self) -> typing.Any: ...


class QgsExpressionNodeCondition(QgsExpressionNode):

    class WhenThen(PyQt6.sip.wrapper):

        def __init__(self, whenExp: QgsExpressionNode|None, thenExp: QgsExpressionNode|None) -> None: ...

        def thenExp(self) -> QgsExpressionNode|None: ...
        def whenExp(self) -> QgsExpressionNode|None: ...
        def clone(self) -> 'QgsExpressionNodeCondition.WhenThen|None': ...

    def __init__(self, conditions: collections.abc.Iterable['QgsExpressionNodeCondition.WhenThen'], elseExp: QgsExpressionNode|None = ...) -> None: ...

    def isStatic(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def clone(self) -> QgsExpressionNode|None: ...
    def needsGeometry(self) -> bool: ...
    def referencedFunctions(self) -> set[str]: ...
    def referencedVariables(self) -> set[str]: ...
    def referencedColumns(self) -> set[str]: ...
    def elseExp(self) -> QgsExpressionNode|None: ...
    def conditions(self) -> list['QgsExpressionNodeCondition.WhenThen']: ...
    def dump(self) -> str: ...
    def prepareNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> bool: ...
    def evalNode(self, parent: QgsExpression|None, context: QgsExpressionContext|None) -> typing.Any: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...


class QgsCheckBoxFieldFormatter(QgsFieldFormatter):

    class TextDisplayMethod(enum.IntEnum):
        ShowTrueFalse = ... # type: QgsCheckBoxFieldFormatter.TextDisplayMethod
        ShowStoredValues = ... # type: QgsCheckBoxFieldFormatter.TextDisplayMethod

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCheckBoxFieldFormatter') -> None: ...

    def representValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsDateTimeFieldFormatter(QgsFieldFormatter):

    DATETIME_DISPLAY_FORMAT = ... # type: str|None
    DATETIME_FORMAT = ... # type: str|None
    DATE_DISPLAY_FORMAT = ... # type: str|None
    DATE_FORMAT = ... # type: str|None
    DISPLAY_FOR_ISO_FORMAT = ... # type: str|None
    QT_ISO_FORMAT = ... # type: str|None
    TIME_FORMAT = ... # type: str|None

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDateTimeFieldFormatter') -> None: ...

    @typing.overload
    @staticmethod
    def defaultDisplayFormat(type: QtCore.QMetaType.Type) -> str: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def defaultDisplayFormat(type: typing.Any) -> str: ...
    @typing.overload
    @staticmethod
    def defaultFormat(type: QtCore.QMetaType.Type) -> str: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def defaultFormat(type: typing.Any) -> str: ...
    def representValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsFallbackFieldFormatter(QgsFieldFormatter):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFallbackFieldFormatter') -> None: ...

    def id(self) -> str: ...


class QgsKeyValueFieldFormatter(QgsFieldFormatter):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsKeyValueFieldFormatter') -> None: ...

    def representValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsListFieldFormatter(QgsFieldFormatter):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsListFieldFormatter') -> None: ...

    def representValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsRangeFieldFormatter(QgsFieldFormatter):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRangeFieldFormatter') -> None: ...

    def representValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsRelationReferenceFieldFormatter(QgsFieldFormatter):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRelationReferenceFieldFormatter') -> None: ...

    def availableValues(self, config: dict[str|None, typing.Any], countLimit: int, context: QgsFieldFormatterContext) -> list[typing.Any]: ...
    def createCache(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any]) -> typing.Any: ...
    def sortValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> typing.Any: ...
    def representValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsValueMapFieldFormatter(QgsFieldFormatter):

    NULL_VALUE = ... # type: str|None

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsValueMapFieldFormatter') -> None: ...

    def availableValues(self, config: dict[str|None, typing.Any], countLimit: int, context: QgsFieldFormatterContext) -> list[typing.Any]: ...
    def sortValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> typing.Any: ...
    def representValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsValueRelationFieldFormatter(QgsFieldFormatter):

    class ValueRelationItem(PyQt6.sip.wrapper):

        description = ... # type: str|None
        group = ... # type: typing.Any
        key = ... # type: typing.Any
        value = ... # type: str|None

        @typing.overload
        def __init__(self, key: typing.Any, value: str|None, description: str|None = ..., group: typing.Any = ...) -> None: ...
        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsValueRelationFieldFormatter.ValueRelationItem') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsValueRelationFieldFormatter') -> None: ...

    def availableValues(self, config: dict[str|None, typing.Any], countLimit: int, context: QgsFieldFormatterContext) -> list[typing.Any]: ...
    @staticmethod
    def resolveLayer(config: dict[str|None, typing.Any], project: 'QgsProject|None') -> QgsVectorLayer|None: ...
    @staticmethod
    def expressionIsUsable(expression: str|None, feature: QgsFeature, parentFeature: QgsFeature = ...) -> bool: ...
    @staticmethod
    def expressionParentFormVariables(expression: str|None) -> set[str]: ...
    @staticmethod
    def expressionParentFormAttributes(expression: str|None) -> set[str]: ...
    @staticmethod
    def expressionRequiresParentFormScope(expression: str|None) -> bool: ...
    @staticmethod
    def expressionFormVariables(expression: str|None) -> set[str]: ...
    @staticmethod
    def expressionFormAttributes(expression: str|None) -> set[str]: ...
    @staticmethod
    def expressionRequiresFormScope(expression: str|None) -> bool: ...
    @staticmethod
    def valueToStringList(value: typing.Any) -> list[str]: ...
    @typing.overload
    def createCache(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any]) -> typing.Any: ...
    @typing.overload
    @staticmethod
    def createCache(config: dict[str|None, typing.Any], formFeature: QgsFeature = ..., parentFormFeature: QgsFeature = ...) -> list['QgsValueRelationFieldFormatter.ValueRelationItem']: ...
    def sortValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> typing.Any: ...
    def representValue(self, layer: QgsVectorLayer|None, fieldIndex: int, config: dict[str|None, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsLocatorFilter(QtCore.QObject):

    class Flag(enum.IntEnum):
        FlagFast = ... # type: QgsLocatorFilter.Flag

    class Priority(enum.IntEnum):
        Highest = ... # type: QgsLocatorFilter.Priority
        High = ... # type: QgsLocatorFilter.Priority
        Medium = ... # type: QgsLocatorFilter.Priority
        Low = ... # type: QgsLocatorFilter.Priority
        Lowest = ... # type: QgsLocatorFilter.Priority

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    resultFetched: typing.ClassVar[QtCore.pyqtSignal]
    finished: typing.ClassVar[QtCore.pyqtSignal]
    def setFetchResultsDelay(self, delay: int) -> None: ...
    def fetchResultsDelay(self) -> int: ...
    def logMessage(self, message: str|None, level: Qgis.MessageLevel = ...) -> None: ...
    def openConfigWidget(self, parent: QtWidgets.QWidget|None = ...) -> None: ...
    def hasConfigWidget(self) -> bool: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    @staticmethod
    def fuzzyScore(candidate: str|None, search: str|None) -> float: ...
    @staticmethod
    def stringMatches(candidate: str|None, search: str|None) -> bool: ...
    def activePrefix(self) -> str: ...
    def setUseWithoutPrefix(self, useWithoutPrefix: bool) -> None: ...
    def useWithoutPrefix(self) -> bool: ...
    def clearPreviousResults(self) -> None: ...
    def triggerResultFromAction(self, result: 'QgsLocatorResult', actionId: int) -> None: ...
    def resultDeselected(self, result: 'QgsLocatorResult') -> None: ...
    def resultSelected(self, result: 'QgsLocatorResult') -> None: ...
    def triggerResult(self, result: 'QgsLocatorResult') -> None: ...
    def fetchResults(self, string: str|None, context: 'QgsLocatorContext', feedback: QgsFeedback|None) -> None: ...
    def prepare(self, string: str|None, context: 'QgsLocatorContext') -> list[str]: ...
    def prefix(self) -> str: ...
    def priority(self) -> 'QgsLocatorFilter.Priority': ...
    def flags(self) -> 'QgsLocatorFilter.Flag': ...
    def description(self) -> str: ...
    def displayName(self) -> str: ...
    def name(self) -> str: ...
    def clone(self) -> 'QgsLocatorFilter|None': ...


class QgsAbstractGeocoderLocatorFilter(QgsLocatorFilter):

    def __init__(self, name: str|None, displayName: str|None, prefix: str|None, geocoder: 'QgsGeocoderInterface|None', boundingBox: 'QgsRectangle' = ...) -> None: ...

    def geocoderResultToLocatorResult(self, result: 'QgsGeocoderResult') -> 'QgsLocatorResult': ...
    def locatorResultToGeocoderResult(self, result: 'QgsLocatorResult') -> 'QgsGeocoderResult': ...
    def boundingBox(self) -> 'QgsRectangle': ...
    def geocoder(self) -> 'QgsGeocoderInterface|None': ...
    def triggerResult(self, result: 'QgsLocatorResult') -> None: ...
    def fetchResults(self, string: str|None, context: 'QgsLocatorContext', feedback: QgsFeedback|None) -> None: ...
    def prefix(self) -> str: ...
    def displayName(self) -> str: ...
    def name(self) -> str: ...


class QgsGeocoderInterface(PyQt6.sip.wrapper):

    class Flag(enum.Enum):
        GeocodesStrings = ... # type: QgsGeocoderInterface.Flag
        GeocodesFeatures = ... # type: QgsGeocoderInterface.Flag

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeocoderInterface') -> None: ...

    def geocodeString(self, string: str|None, context: 'QgsGeocoderContext', feedback: QgsFeedback|None = ...) -> list['QgsGeocoderResult']: ...
    def wkbType(self) -> Qgis.WkbType: ...
    def appendedFields(self) -> QgsFields: ...
    def geocodeFeature(self, feature: QgsFeature, context: 'QgsGeocoderContext', feedback: QgsFeedback|None = ...) -> list['QgsGeocoderResult']: ...
    def flags(self) -> 'QgsGeocoderInterface.Flag': ...


class QgsGeocoderContext(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, transformContext: 'QgsCoordinateTransformContext') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeocoderContext') -> None: ...

    def setAreaOfInterestCrs(self, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    def areaOfInterestCrs(self) -> 'QgsCoordinateReferenceSystem': ...
    def setAreaOfInterest(self, area: 'QgsGeometry') -> None: ...
    def areaOfInterest(self) -> 'QgsGeometry': ...
    def setTransformContext(self, context: 'QgsCoordinateTransformContext') -> None: ...
    def transformContext(self) -> 'QgsCoordinateTransformContext': ...


class QgsGeocoderResult(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, identifier: str|None, geometry: 'QgsGeometry', crs: 'QgsCoordinateReferenceSystem') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeocoderResult') -> None: ...

    def setDescription(self, description: str|None) -> None: ...
    def description(self) -> str: ...
    def setGroup(self, group: str|None) -> None: ...
    def group(self) -> str: ...
    def setAdditionalAttributes(self, attributes: dict[str|None, typing.Any]) -> None: ...
    def additionalAttributes(self) -> dict[str, typing.Any]: ...
    def setViewport(self, viewport: 'QgsRectangle') -> None: ...
    def viewport(self) -> 'QgsRectangle': ...
    def setCrs(self, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...
    def setGeometry(self, geometry: 'QgsGeometry') -> None: ...
    def geometry(self) -> 'QgsGeometry': ...
    def identifier(self) -> str: ...
    def error(self) -> str: ...
    def isValid(self) -> bool: ...
    @staticmethod
    def errorResult(errorMessage: str|None) -> 'QgsGeocoderResult': ...


class QgsNominatimGeocoder(QgsGeocoderInterface):

    @typing.overload
    def __init__(self, countryCodes: str|None = ..., endpoint: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsNominatimGeocoder') -> None: ...

    def setCountryCodes(self, countryCodes: str|None) -> None: ...
    def countryCodes(self) -> str: ...
    def setRequestsPerSecond(self, number: float) -> None: ...
    def requestsPerSecond(self) -> float: ...
    def setEndpoint(self, endpoint: str|None) -> None: ...
    def endpoint(self) -> str: ...
    def jsonToResult(self, json: dict[str|None, typing.Any]) -> QgsGeocoderResult: ...
    def requestUrl(self, address: str|None, bounds: 'QgsRectangle' = ...) -> QtCore.QUrl: ...
    def geocodeString(self, string: str|None, context: QgsGeocoderContext, feedback: QgsFeedback|None = ...) -> list[QgsGeocoderResult]: ...
    def wkbType(self) -> Qgis.WkbType: ...
    def appendedFields(self) -> QgsFields: ...
    def flags(self) -> QgsGeocoderInterface.Flag: ...


class QgsGoogleMapsGeocoder(QgsGeocoderInterface):

    @typing.overload
    def __init__(self, apiKey: str|None, regionBias: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGoogleMapsGeocoder') -> None: ...

    def setRegion(self, region: str|None) -> None: ...
    def region(self) -> str: ...
    def setApiKey(self, key: str|None) -> None: ...
    def apiKey(self) -> str: ...
    def setEndpoint(self, endpoint: str|None) -> None: ...
    def jsonToResult(self, json: dict[str|None, typing.Any]) -> QgsGeocoderResult: ...
    def requestUrl(self, address: str|None, bounds: 'QgsRectangle' = ...) -> QtCore.QUrl: ...
    def geocodeString(self, string: str|None, context: QgsGeocoderContext, feedback: QgsFeedback|None = ...) -> list[QgsGeocoderResult]: ...
    def wkbType(self) -> Qgis.WkbType: ...
    def appendedFields(self) -> QgsFields: ...
    def flags(self) -> QgsGeocoderInterface.Flag: ...


class QgsAbstractGeometry(PyQt6.sip.wrapper):

    class WkbFlag(enum.IntEnum):
        FlagExportTrianglesAsPolygons = ... # type: QgsAbstractGeometry.WkbFlag
        FlagExportNanAsDoubleMin = ... # type: QgsAbstractGeometry.WkbFlag

    class AxisOrder(enum.IntEnum):
        XY = ... # type: QgsAbstractGeometry.AxisOrder
        YX = ... # type: QgsAbstractGeometry.AxisOrder

    class SegmentationToleranceType(enum.IntEnum):
        MaximumAngle = ... # type: QgsAbstractGeometry.SegmentationToleranceType
        MaximumDifference = ... # type: QgsAbstractGeometry.SegmentationToleranceType

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, geom: 'QgsAbstractGeometry') -> None: ...

    def clearCache(self) -> None: ...
    def calculateBoundingBox3D(self) -> 'QgsBox3D': ...
    def calculateBoundingBox(self) -> 'QgsRectangle': ...
    def setZMTypeFromSubGeometry(self, subggeom: 'QgsAbstractGeometry|None', baseGeomType: Qgis.WkbType) -> None: ...
    def childPoint(self, index: int) -> 'QgsPoint': ...
    def childGeometry(self, index: int) -> 'QgsAbstractGeometry|None': ...
    def childCount(self) -> int: ...
    def hasChildGeometries(self) -> bool: ...
    def compareToSameClass(self, other: 'QgsAbstractGeometry|None') -> int: ...
    def sortIndex(self) -> int: ...
    def createEmptyWithSameType(self) -> 'QgsAbstractGeometry|None': ...
    def vertices(self) -> 'QgsVertexIterator': ...
    def parts(self) -> 'QgsGeometryPartIterator': ...
    def isValid(self, flags: Qgis.GeometryValidityFlag = ...) -> typing.Tuple[bool, str]: ...
    def simplifiedTypeRef(self) -> 'QgsAbstractGeometry|None': ...
    def convertTo(self, type: Qgis.WkbType) -> bool: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def partCount(self) -> int: ...
    def ringCount(self, part: int = ...) -> int: ...
    def vertexCount(self, part: int = ..., ring: int = ...) -> int: ...
    def vertexAngle(self, vertex: 'QgsVertexId') -> float: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def simplifyByDistance(self, tolerance: float) -> 'QgsAbstractGeometry|None': ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ..., removeRedundantPoints: bool = ...) -> 'QgsAbstractGeometry|None': ...
    def toCurveType(self) -> 'QgsAbstractGeometry|None': ...
    def segmentize(self, tolerance: float = ..., toleranceType: 'QgsAbstractGeometry.SegmentationToleranceType' = ...) -> 'QgsAbstractGeometry|None': ...
    @typing.overload
    def boundingBoxIntersects(self, rectangle: 'QgsRectangle') -> bool: ...
    @typing.overload
    def boundingBoxIntersects(self, box3d: 'QgsBox3D') -> bool: ...
    def hasCurvedSegments(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def centroid(self) -> 'QgsPoint': ...
    def segmentLength(self, startVertex: 'QgsVertexId') -> float: ...
    def area3D(self) -> float: ...
    def area(self) -> float: ...
    def perimeter(self) -> float: ...
    def length(self) -> float: ...
    def deleteVertex(self, position: 'QgsVertexId') -> bool: ...
    def moveVertex(self, position: 'QgsVertexId', newPos: 'QgsPoint') -> bool: ...
    def insertVertex(self, position: 'QgsVertexId', vertex: 'QgsPoint') -> bool: ...
    def closestSegment(self, pt: 'QgsPoint', epsilon: float = ...) -> typing.Tuple[float, 'QgsPoint', 'QgsVertexId', int]: ...
    def vertexAt(self, id: 'QgsVertexId') -> 'QgsPoint': ...
    def nCoordinates(self) -> int: ...
    def coordinateSequence(self) -> typing.Any: ...
    def adjacentVertices(self, vertex: 'QgsVertexId') -> typing.Tuple['QgsVertexId', 'QgsVertexId']: ...
    def nextVertex(self, id: 'QgsVertexId') -> typing.Tuple[bool, 'QgsPoint']: ...
    def vertexNumberFromVertexId(self, id: 'QgsVertexId') -> int: ...
    def asQPainterPath(self) -> QtGui.QPainterPath: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    @typing.overload
    def transform(self, ct: 'QgsCoordinateTransform', d: Qgis.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @typing.overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @typing.overload
    def transform(self, transformer: 'QgsAbstractGeometryTransformer|None', feedback: QgsFeedback|None = ...) -> bool: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asJson(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: 'QgsAbstractGeometry.AxisOrder' = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: 'QgsAbstractGeometry.AxisOrder' = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: 'QgsAbstractGeometry.WkbFlag' = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: 'QgsAbstractGeometry.WkbFlag' = ...) -> int: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def fromWkb(self, wkb: 'QgsConstWkbPtr') -> bool: ...
    def normalize(self) -> None: ...
    def boundary(self) -> 'QgsAbstractGeometry|None': ...
    def isMeasure(self) -> bool: ...
    def is3D(self) -> bool: ...
    def wktTypeStr(self) -> str: ...
    def wkbType(self) -> Qgis.WkbType: ...
    def geometryType(self) -> str: ...
    def dimension(self) -> int: ...
    def boundingBox3D(self) -> 'QgsBox3D': ...
    def boundingBox(self) -> 'QgsRectangle': ...
    def clear(self) -> None: ...
    def compareTo(self, other: 'QgsAbstractGeometry|None') -> int: ...
    def clone(self) -> 'QgsAbstractGeometry|None': ...
    def fuzzyDistanceEqual(self, other: 'QgsAbstractGeometry', epsilon: float = ...) -> bool: ...
    def fuzzyEqual(self, other: 'QgsAbstractGeometry', epsilon: float = ...) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsVertexIterator(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, geometry: QgsAbstractGeometry|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVertexIterator') -> None: ...

    def __next__(self) -> 'QgsPoint': ...
    def __iter__(self) -> 'QgsVertexIterator|None': ...
    def next(self) -> 'QgsPoint': ...
    def hasNext(self) -> bool: ...


class QgsGeometryPartIterator(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, geometry: QgsAbstractGeometry|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryPartIterator') -> None: ...

    def __next__(self) -> QgsAbstractGeometry: ...
    def __iter__(self) -> 'QgsGeometryPartIterator|None': ...
    def next(self) -> QgsAbstractGeometry|None: ...
    def hasNext(self) -> bool: ...


class QgsGeometryConstPartIterator(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, geometry: QgsAbstractGeometry|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryConstPartIterator') -> None: ...

    def __next__(self) -> QgsAbstractGeometry: ...
    def __iter__(self) -> 'QgsGeometryConstPartIterator|None': ...
    def next(self) -> QgsAbstractGeometry|None: ...
    def hasNext(self) -> bool: ...


class QgsBox3D(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, x: 'QgsPoint'|QgsVector3D|'QgsRectangle'|float|None = ..., y: typing.Optional['QgsPoint', QgsVector3D, float] = ..., z: bool|float|None = ..., x2: bool|float|None = ..., y2: float|None = ..., z2: float|None = ..., n: bool|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsBox3D') -> None: ...

    def __ne__(self, other: object): ...
    def __repr__(self) -> typing.Any: ...
    def __iadd__(self, v: QgsVector3D) -> 'QgsBox3D': ...
    def __isub__(self, v: QgsVector3D) -> 'QgsBox3D': ...
    def __add__(self, v: QgsVector3D) -> 'QgsBox3D': ...
    def __sub__(self, v: QgsVector3D) -> 'QgsBox3D': ...
    def corners(self) -> list[QgsVector3D]: ...
    def toString(self, precision: int = ...) -> str: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def grow(self, delta: float) -> None: ...
    @typing.overload
    def scale(self, scaleFactor: float, center: 'QgsPoint' = ...) -> None: ...
    @typing.overload
    def scale(self, scaleFactor: float, centerX: float, centerY: float, centerZ: float) -> None: ...
    def __eq__(self, other: object): ...
    @typing.overload
    @deprecated("""""")
    def distanceTo(self, point: QtGui.QVector3D) -> float: ...
    @typing.overload
    def distanceTo(self, point: QgsVector3D) -> float: ...
    def toRectangle(self) -> 'QgsRectangle': ...
    @typing.overload
    def combineWith(self, box: 'QgsBox3D') -> None: ...
    @typing.overload
    def combineWith(self, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def contains(self, other: 'QgsBox3D') -> bool: ...
    @typing.overload
    def contains(self, point: 'QgsPoint') -> bool: ...
    @typing.overload
    def contains(self, x: float, y: float, z: float) -> bool: ...
    def intersects(self, other: 'QgsBox3D') -> bool: ...
    def is3D(self) -> bool: ...
    def is2d(self) -> bool: ...
    def intersect(self, other: 'QgsBox3D') -> 'QgsBox3D': ...
    def volume(self) -> float: ...
    def area(self) -> float: ...
    def center(self) -> QgsVector3D: ...
    def depth(self) -> float: ...
    def height(self) -> float: ...
    def width(self) -> float: ...
    def normalize(self) -> None: ...
    def setNull(self) -> None: ...
    def zMaximum(self) -> float: ...
    def zMinimum(self) -> float: ...
    def setZMaximum(self, z: float) -> None: ...
    def setZMinimum(self, z: float) -> None: ...
    def yMaximum(self) -> float: ...
    def yMinimum(self) -> float: ...
    def setYMaximum(self, y: float) -> None: ...
    def setYMinimum(self, y: float) -> None: ...
    def xMaximum(self) -> float: ...
    def xMinimum(self) -> float: ...
    def setXMaximum(self, x: float) -> None: ...
    def setXMinimum(self, x: float) -> None: ...
    def set(self, xMin: float, yMin: float, zMin: float, xMax: float, yMax: float, zMax: float, normalize: bool = ...) -> None: ...


class QgsEllipse(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, center: 'QgsPoint', semiMajorAxis: float, semiMinorAxis: float, azimuth: float = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsEllipse') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def toString(self, pointPrecision: int = ..., axisPrecision: int = ..., azimuthPrecision: int = ...) -> str: ...
    def boundingBox(self) -> 'QgsRectangle': ...
    def orientedBoundingBox(self) -> 'QgsPolygon|None': ...
    def toLineString(self, segments: int = ...) -> 'QgsLineString|None': ...
    def toPolygon(self, segments: int = ...) -> 'QgsPolygon|None': ...
    def points(self, segments: int = ...) -> list['QgsPoint']: ...
    def quadrant(self) -> list['QgsPoint']: ...
    def perimeter(self) -> float: ...
    def area(self) -> float: ...
    def eccentricity(self) -> float: ...
    def foci(self) -> list['QgsPoint']: ...
    def focusDistance(self) -> float: ...
    def setAzimuth(self, azimuth: float) -> None: ...
    def setSemiMinorAxis(self, semiMinorAxis: float) -> None: ...
    def setSemiMajorAxis(self, semiMajorAxis: float) -> None: ...
    def setCenter(self, center: 'QgsPoint') -> None: ...
    def azimuth(self) -> float: ...
    def semiMinorAxis(self) -> float: ...
    def semiMajorAxis(self) -> float: ...
    def center(self) -> 'QgsPoint': ...
    def isEmpty(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    @staticmethod
    def fromCenter2Points(ptc: 'QgsPoint', pt1: 'QgsPoint', pt2: 'QgsPoint') -> 'QgsEllipse': ...
    @staticmethod
    def fromCenterPoint(ptc: 'QgsPoint', pt1: 'QgsPoint') -> 'QgsEllipse': ...
    @staticmethod
    def fromExtent(pt1: 'QgsPoint', pt2: 'QgsPoint') -> 'QgsEllipse': ...
    @staticmethod
    def fromFoci(pt1: 'QgsPoint', pt2: 'QgsPoint', pt3: 'QgsPoint') -> 'QgsEllipse': ...


class QgsCircle(QgsEllipse):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, center: 'QgsPoint', radius: float, azimuth: float = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCircle') -> None: ...

    def __repr__(self) -> typing.Any: ...
    @staticmethod
    def calculateSegments(radius: float, parameter: float, minSegments: int, method: Qgis.SegmentCalculationMethod) -> int: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def toString(self, pointPrecision: int = ..., radiusPrecision: int = ..., azimuthPrecision: int = ...) -> str: ...
    def boundingBox(self) -> 'QgsRectangle': ...
    def contains(self, point: 'QgsPoint', epsilon: float = ...) -> bool: ...
    def toCircularString(self, oriented: bool = ...) -> 'QgsCircularString|None': ...
    def northQuadrant(self) -> list['QgsPoint']: ...
    def setRadius(self, radius: float) -> None: ...
    def radius(self) -> float: ...
    def setSemiMinorAxis(self, semiMinorAxis: float) -> None: ...
    def setSemiMajorAxis(self, semiMajorAxis: float) -> None: ...
    def perimeter(self) -> float: ...
    def area(self) -> float: ...
    def innerTangents(self, other: 'QgsCircle') -> typing.Tuple[int, QgsPointXY, QgsPointXY, QgsPointXY, QgsPointXY]: ...
    def outerTangents(self, other: 'QgsCircle') -> typing.Tuple[int, QgsPointXY, QgsPointXY, QgsPointXY, QgsPointXY]: ...
    def tangentToPoint(self, p: QgsPointXY) -> typing.Tuple[bool, QgsPointXY, QgsPointXY]: ...
    def intersections(self, other: 'QgsCircle', useZ: bool = ...) -> typing.Tuple[int, 'QgsPoint', 'QgsPoint']: ...
    @staticmethod
    def minimalCircleFrom3Points(pt1: 'QgsPoint', pt2: 'QgsPoint', pt3: 'QgsPoint', epsilon: float = ...) -> 'QgsCircle': ...
    @staticmethod
    def fromExtent(pt1: 'QgsPoint', pt2: 'QgsPoint') -> 'QgsCircle': ...
    @staticmethod
    def from3TangentsMulti(pt1_tg1: 'QgsPoint', pt2_tg1: 'QgsPoint', pt1_tg2: 'QgsPoint', pt2_tg2: 'QgsPoint', pt1_tg3: 'QgsPoint', pt2_tg3: 'QgsPoint', epsilon: float = ..., pos: 'QgsPoint' = ...) -> list['QgsCircle']: ...
    @staticmethod
    def from3Tangents(pt1_tg1: 'QgsPoint', pt2_tg1: 'QgsPoint', pt1_tg2: 'QgsPoint', pt2_tg2: 'QgsPoint', pt1_tg3: 'QgsPoint', pt2_tg3: 'QgsPoint', epsilon: float = ..., pos: 'QgsPoint' = ...) -> 'QgsCircle': ...
    @staticmethod
    def fromCenterPoint(center: 'QgsPoint', pt1: 'QgsPoint') -> 'QgsCircle': ...
    @staticmethod
    def fromCenterDiameter(center: 'QgsPoint', diameter: float, azimuth: float = ...) -> 'QgsCircle': ...
    @staticmethod
    def from3Points(pt1: 'QgsPoint', pt2: 'QgsPoint', pt3: 'QgsPoint', epsilon: float = ...) -> 'QgsCircle': ...
    @staticmethod
    def from2Points(pt1: 'QgsPoint', pt2: 'QgsPoint') -> 'QgsCircle': ...


class QgsCurve(QgsAbstractGeometry):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCurve') -> None: ...

    def childPoint(self, index: int) -> 'QgsPoint': ...
    def childCount(self) -> int: ...
    def clearCache(self) -> None: ...
    def distanceBetweenVertices(self, fromVertex: 'QgsVertexId', toVertex: 'QgsVertexId') -> float: ...
    def scroll(self, firstVertexIndex: int) -> None: ...
    def orientation(self) -> Qgis.AngularDirection: ...
    def sinuosity(self) -> float: ...
    def straightDistance2d(self) -> float: ...
    def curveSubstring(self, startDistance: float, endDistance: float) -> 'QgsCurve|None': ...
    def interpolatePoint(self, distance: float) -> 'QgsPoint|None': ...
    def asQPolygonF(self) -> QtGui.QPolygonF: ...
    def mAt(self, index: int) -> float: ...
    def zAt(self, index: int) -> float: ...
    def yAt(self, index: int) -> float: ...
    def xAt(self, index: int) -> float: ...
    def isValid(self, flags: Qgis.GeometryValidityFlag = ...) -> typing.Tuple[bool, str]: ...
    def boundingBox3D(self) -> QgsBox3D: ...
    def normalize(self) -> None: ...
    def toCurveType(self) -> 'QgsCurve|None': ...
    def vertexAt(self, id: 'QgsVertexId') -> 'QgsPoint': ...
    def partCount(self) -> int: ...
    def ringCount(self, part: int = ...) -> int: ...
    def vertexCount(self, part: int = ..., ring: int = ...) -> int: ...
    def segmentize(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> 'QgsCurve|None': ...
    def asKml(self, precision: int = ...) -> str: ...
    def boundary(self) -> QgsAbstractGeometry|None: ...
    def reversed(self) -> 'QgsCurve|None': ...
    def indexOf(self, point: 'QgsPoint') -> int: ...
    def pointAt(self, node: int) -> typing.Tuple[bool, 'QgsPoint', Qgis.VertexType]: ...
    def vertexNumberFromVertexId(self, id: 'QgsVertexId') -> int: ...
    def adjacentVertices(self, vertex: 'QgsVertexId') -> typing.Tuple['QgsVertexId', 'QgsVertexId']: ...
    def nextVertex(self, id: 'QgsVertexId') -> typing.Tuple[bool, 'QgsPoint']: ...
    def coordinateSequence(self) -> typing.Any: ...
    def sumUpArea3D(self) -> float: ...
    def sumUpArea(self) -> float: ...
    def __bool__(self) -> int: ...
    def __len__(self) -> int: ...
    def numPoints(self) -> int: ...
    def points(self) -> list['QgsPoint']: ...
    def drawAsPolygon(self, p: QtGui.QPainter) -> None: ...
    def asQPainterPath(self) -> QtGui.QPainterPath: ...
    def addToPainterPath(self, path: QtGui.QPainterPath) -> None: ...
    def curveToLine(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> 'QgsLineString|None': ...
    def isRing(self) -> bool: ...
    def isClosed2D(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def endPoint(self) -> 'QgsPoint': ...
    def startPoint(self) -> 'QgsPoint': ...
    def clone(self) -> 'QgsCurve|None': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def equals(self, other: 'QgsCurve') -> bool: ...


class QgsCircularString(QgsCurve):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, p1: 'QgsPoint', p2: 'QgsPoint', p3: 'QgsPoint') -> None: ...
    @typing.overload
    def __init__(self, x: collections.abc.Iterable[float], y: collections.abc.Iterable[float], z: collections.abc.Iterable[float] = ..., m: collections.abc.Iterable[float] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCircularString') -> None: ...

    def calculateBoundingBox3D(self) -> QgsBox3D: ...
    def compareToSameClass(self, other: QgsAbstractGeometry|None) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> 'QgsCircularString|None': ...
    def scroll(self, firstVertexIndex: int) -> None: ...
    def mAt(self, index: int) -> float: ...
    def zAt(self, index: int) -> float: ...
    def yAt(self, index: int) -> float: ...
    def xAt(self, index: int) -> float: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def curveSubstring(self, startDistance: float, endDistance: float) -> 'QgsCircularString|None': ...
    def interpolatePoint(self, distance: float) -> 'QgsPoint|None': ...
    def reversed(self) -> 'QgsCircularString|None': ...
    def distanceBetweenVertices(self, fromVertex: 'QgsVertexId', toVertex: 'QgsVertexId') -> float: ...
    def segmentLength(self, startVertex: 'QgsVertexId') -> float: ...
    def vertexAngle(self, vertex: 'QgsVertexId') -> float: ...
    def hasCurvedSegments(self) -> bool: ...
    def sumUpArea3D(self) -> float: ...
    def sumUpArea(self) -> float: ...
    def pointAt(self, node: int, point: 'QgsPoint') -> typing.Tuple[bool, Qgis.VertexType]: ...
    def closestSegment(self, pt: 'QgsPoint', epsilon: float = ...) -> typing.Tuple[float, 'QgsPoint', 'QgsVertexId', int]: ...
    def deleteVertex(self, position: 'QgsVertexId') -> bool: ...
    def moveVertex(self, position: 'QgsVertexId', newPos: 'QgsPoint') -> bool: ...
    def insertVertex(self, position: 'QgsVertexId', vertex: 'QgsPoint') -> bool: ...
    def drawAsPolygon(self, p: QtGui.QPainter) -> None: ...
    def addToPainterPath(self, path: QtGui.QPainterPath) -> None: ...
    @typing.overload
    def transform(self, ct: 'QgsCoordinateTransform', d: Qgis.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @typing.overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @typing.overload
    def transform(self, transformer: 'QgsAbstractGeometryTransformer|None', feedback: QgsFeedback|None = ...) -> bool: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def simplifyByDistance(self, tolerance: float) -> QgsAbstractGeometry|None: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ..., removeRedundantPoints: bool = ...) -> 'QgsCircularString|None': ...
    def curveToLine(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> 'QgsLineString|None': ...
    def endPoint(self) -> 'QgsPoint': ...
    def startPoint(self) -> 'QgsPoint': ...
    def length(self) -> float: ...
    def append(self, string: 'QgsCircularString|None') -> None: ...
    def setPoints(self, points: collections.abc.Iterable['QgsPoint']) -> None: ...
    def points(self) -> list['QgsPoint']: ...
    def pointN(self, i: int) -> 'QgsPoint': ...
    def indexOf(self, point: 'QgsPoint') -> int: ...
    def numPoints(self) -> int: ...
    def isValid(self, flags: Qgis.GeometryValidityFlag = ...) -> typing.Tuple[bool, str]: ...
    def isEmpty(self) -> bool: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> int: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def fromWkb(self, wkb: 'QgsConstWkbPtr') -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> 'QgsCircularString|None': ...
    def dimension(self) -> int: ...
    def geometryType(self) -> str: ...
    def equals(self, other: QgsCurve) -> bool: ...
    def fuzzyDistanceEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    def fuzzyEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    @staticmethod
    def fromTwoPointsAndCenter(p1: 'QgsPoint', p2: 'QgsPoint', center: 'QgsPoint', useShortestArc: bool = ...) -> 'QgsCircularString': ...


class QgsCompoundCurve(QgsCurve):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, curve: 'QgsCompoundCurve') -> None: ...

    def calculateBoundingBox3D(self) -> QgsBox3D: ...
    def compareToSameClass(self, other: QgsAbstractGeometry|None) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> 'QgsCompoundCurve|None': ...
    def scroll(self, firstVertexIndex: int) -> None: ...
    def mAt(self, index: int) -> float: ...
    def zAt(self, index: int) -> float: ...
    def yAt(self, index: int) -> float: ...
    def xAt(self, index: int) -> float: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def curveSubstring(self, startDistance: float, endDistance: float) -> 'QgsCompoundCurve|None': ...
    def interpolatePoint(self, distance: float) -> 'QgsPoint|None': ...
    def reversed(self) -> 'QgsCompoundCurve|None': ...
    def distanceBetweenVertices(self, fromVertex: 'QgsVertexId', toVertex: 'QgsVertexId') -> float: ...
    def segmentLength(self, startVertex: 'QgsVertexId') -> float: ...
    def vertexAngle(self, vertex: 'QgsVertexId') -> float: ...
    def hasCurvedSegments(self) -> bool: ...
    def close(self) -> None: ...
    def sumUpArea3D(self) -> float: ...
    def sumUpArea(self) -> float: ...
    def pointAt(self, node: int, point: 'QgsPoint') -> typing.Tuple[bool, Qgis.VertexType]: ...
    def closestSegment(self, pt: 'QgsPoint', epsilon: float = ...) -> typing.Tuple[float, 'QgsPoint', 'QgsVertexId', int]: ...
    def deleteVertex(self, position: 'QgsVertexId') -> bool: ...
    def moveVertex(self, position: 'QgsVertexId', newPos: 'QgsPoint') -> bool: ...
    def insertVertex(self, position: 'QgsVertexId', vertex: 'QgsPoint') -> bool: ...
    def drawAsPolygon(self, p: QtGui.QPainter) -> None: ...
    def addToPainterPath(self, path: QtGui.QPainterPath) -> None: ...
    @typing.overload
    def transform(self, ct: 'QgsCoordinateTransform', d: Qgis.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @typing.overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @typing.overload
    def transform(self, transformer: 'QgsAbstractGeometryTransformer|None', feedback: QgsFeedback|None = ...) -> bool: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def toggleCircularAtVertex(self, position: 'QgsVertexId') -> bool: ...
    def condenseCurves(self) -> None: ...
    def addVertex(self, pt: 'QgsPoint') -> None: ...
    def removeCurve(self, i: int) -> None: ...
    def addCurve(self, c: QgsCurve|None, extendPrevious: bool = ...) -> None: ...
    def curveAt(self, i: int) -> QgsCurve|None: ...
    def nCurves(self) -> int: ...
    def simplifiedTypeRef(self) -> QgsAbstractGeometry|None: ...
    def boundingBoxIntersects(self, box3d: QgsBox3D) -> bool: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def simplifyByDistance(self, tolerance: float) -> QgsAbstractGeometry|None: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ..., removeRedundantPoints: bool = ...) -> 'QgsCompoundCurve|None': ...
    def curveToLine(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> 'QgsLineString|None': ...
    def indexOf(self, point: 'QgsPoint') -> int: ...
    def isValid(self, flags: Qgis.GeometryValidityFlag = ...) -> typing.Tuple[bool, str]: ...
    def isEmpty(self) -> bool: ...
    def numPoints(self) -> int: ...
    def points(self) -> list['QgsPoint']: ...
    def endPoint(self) -> 'QgsPoint': ...
    def startPoint(self) -> 'QgsPoint': ...
    def length(self) -> float: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> int: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def fromWkb(self, wkb: 'QgsConstWkbPtr') -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> 'QgsCompoundCurve|None': ...
    def dimension(self) -> int: ...
    def geometryType(self) -> str: ...
    def equals(self, other: QgsCurve) -> bool: ...
    def fuzzyDistanceEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    def fuzzyEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...


class QgsSurface(QgsAbstractGeometry):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSurface') -> None: ...

    def clearCache(self) -> None: ...
    def isValid(self, flags: Qgis.GeometryValidityFlag = ...) -> typing.Tuple[bool, str]: ...
    def boundingBox3D(self) -> QgsBox3D: ...


class QgsCurvePolygon(QgsSurface):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, p: 'QgsCurvePolygon') -> None: ...

    def calculateBoundingBox3D(self) -> QgsBox3D: ...
    def compareToSameClass(self, other: QgsAbstractGeometry|None) -> int: ...
    def childGeometry(self, index: int) -> QgsAbstractGeometry|None: ...
    def childCount(self) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> 'QgsCurvePolygon|None': ...
    def toCurveType(self) -> 'QgsCurvePolygon|None': ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def segmentLength(self, startVertex: 'QgsVertexId') -> float: ...
    def vertexAt(self, id: 'QgsVertexId') -> 'QgsPoint': ...
    def partCount(self) -> int: ...
    def ringCount(self, part: int = ...) -> int: ...
    def vertexCount(self, part: int = ..., ring: int = ...) -> int: ...
    def vertexAngle(self, vertex: 'QgsVertexId') -> float: ...
    def segmentize(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsAbstractGeometry|None: ...
    def hasCurvedSegments(self) -> bool: ...
    def adjacentVertices(self, vertex: 'QgsVertexId') -> typing.Tuple['QgsVertexId', 'QgsVertexId']: ...
    def nextVertex(self, id: 'QgsVertexId') -> typing.Tuple[bool, 'QgsPoint']: ...
    def closestSegment(self, pt: 'QgsPoint', epsilon: float = ...) -> typing.Tuple[float, 'QgsPoint', 'QgsVertexId', int]: ...
    def isEmpty(self) -> bool: ...
    def vertexNumberFromVertexId(self, id: 'QgsVertexId') -> int: ...
    def nCoordinates(self) -> int: ...
    def coordinateSequence(self) -> typing.Any: ...
    def deleteVertex(self, position: 'QgsVertexId') -> bool: ...
    def moveVertex(self, position: 'QgsVertexId', newPos: 'QgsPoint') -> bool: ...
    def insertVertex(self, position: 'QgsVertexId', vertex: 'QgsPoint') -> bool: ...
    @typing.overload
    def transform(self, ct: 'QgsCoordinateTransform', d: Qgis.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @typing.overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @typing.overload
    def transform(self, transformer: 'QgsAbstractGeometryTransformer|None', feedback: QgsFeedback|None = ...) -> bool: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def asQPainterPath(self) -> QtGui.QPainterPath: ...
    def forceCounterClockwise(self) -> None: ...
    def forceClockwise(self) -> None: ...
    def forceRHR(self) -> None: ...
    def removeInvalidRings(self) -> None: ...
    def removeInteriorRings(self, minimumAllowedArea: float = ...) -> None: ...
    def removeInteriorRing(self, i: int) -> bool: ...
    def addInteriorRing(self, ring: QgsCurve|None) -> None: ...
    def setInteriorRings(self, rings: collections.abc.Iterable[QgsCurve]) -> None: ...
    def setExteriorRing(self, ring: QgsCurve|None) -> None: ...
    def toPolygon(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> 'QgsPolygon|None': ...
    def interiorRing(self, i: int) -> QgsCurve: ...
    def exteriorRing(self) -> QgsCurve|None: ...
    def numInteriorRings(self) -> int: ...
    def roundness(self) -> float: ...
    @typing.overload
    def boundingBoxIntersects(self, box3d: QgsBox3D) -> bool: ...
    @typing.overload
    def boundingBoxIntersects(self, box: 'QgsRectangle') -> bool: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def simplifyByDistance(self, tolerance: float) -> 'QgsCurvePolygon|None': ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ..., removeRedundantPoints: bool = ...) -> 'QgsCurvePolygon|None': ...
    def boundary(self) -> QgsAbstractGeometry|None: ...
    def perimeter(self) -> float: ...
    def area3D(self) -> float: ...
    def area(self) -> float: ...
    def surfaceToPolygon(self) -> 'QgsPolygon|None': ...
    def normalize(self) -> None: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> int: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def fromWkb(self, wkb: 'QgsConstWkbPtr') -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> 'QgsCurvePolygon|None': ...
    def dimension(self) -> int: ...
    def geometryType(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def fuzzyDistanceEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    def fuzzyEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...


class QgsGeometryParameters(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryParameters') -> None: ...

    def setGridSize(self, size: float) -> None: ...
    def gridSize(self) -> float: ...


class QgsGeometry(PyQt6.sip.wrapper):

    class Error(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, m: str|None) -> None: ...
        @typing.overload
        def __init__(self, m: str|None, p: QgsPointXY) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsGeometry.Error') -> None: ...

        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def __repr__(self) -> typing.Any: ...
        def hasWhere(self) -> bool: ...
        def where(self) -> QgsPointXY: ...
        def what(self) -> str: ...

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometry') -> None: ...
    @typing.overload
    def __init__(self, geom: QgsAbstractGeometry|None) -> None: ...

    @typing.overload
    def chamfer(self, vertexIndex: int, distance1: float, distance2: float = ...) -> 'QgsGeometry': ...
    @typing.overload
    @staticmethod
    def chamfer(segment1Start: 'QgsPoint', segment1End: 'QgsPoint', segment2Start: 'QgsPoint', segment2End: 'QgsPoint', distance1: float, distance2: float = ...) -> 'QgsGeometry': ...
    @typing.overload
    def fillet(self, vertexIndex: int, radius: float, segments: int = ...) -> 'QgsGeometry': ...
    @typing.overload
    @staticmethod
    def fillet(segment1Start: 'QgsPoint', segment1End: 'QgsPoint', segment2Start: 'QgsPoint', segment2End: 'QgsPoint', radius: float, segments: int = ...) -> 'QgsGeometry': ...
    @typing.overload
    @staticmethod
    def convertPointList(input: collections.abc.Iterable[QgsPointXY], output: collections.abc.Iterable['QgsPoint']) -> None: ...
    @typing.overload
    @staticmethod
    def convertPointList(input: collections.abc.Iterable['QgsPoint'], output: collections.abc.Iterable[QgsPointXY]) -> None: ...
    @staticmethod
    def createGeometryEngine(geometry: QgsAbstractGeometry|None, precision: float = ..., flags: Qgis.GeosCreationFlag = ...) -> 'QgsGeometryEngine|None': ...
    def smooth(self, iterations: int = ..., offset: float = ..., minimumDistance: float = ..., maxAngle: float = ...) -> 'QgsGeometry': ...
    @staticmethod
    def compare(obj1: typing.Any, obj2: typing.Any, epsilon: float = ...) -> bool: ...
    @staticmethod
    @deprecated("""""")
    def createPolygonFromQPolygonF(polygon: QtGui.QPolygonF) -> typing.Any: ...
    @staticmethod
    @deprecated("""""")
    def createPolylineFromQPolygonF(polygon: QtGui.QPolygonF) -> list[QgsPointXY]: ...
    @staticmethod
    def fromQPolygonF(polygon: QtGui.QPolygonF) -> 'QgsGeometry': ...
    @staticmethod
    def fromQPointF(point: QtCore.QPointF) -> 'QgsGeometry': ...
    def lastError(self) -> str: ...
    def vertexNrFromVertexId(self, id: 'QgsVertexId') -> int: ...
    def vertexIdFromVertexNr(self, number: int) -> typing.Tuple[bool, 'QgsVertexId']: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def mapToPixel(self, mtp: QgsMapToPixel) -> None: ...
    def requiresConversionToStraightSegments(self) -> bool: ...
    def convertToStraightSegment(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> None: ...
    @staticmethod
    def polygonize(geometries: collections.abc.Iterable['QgsGeometry']) -> 'QgsGeometry': ...
    @staticmethod
    def unaryUnion(geometries: collections.abc.Iterable['QgsGeometry'], parameters: QgsGeometryParameters = ...) -> 'QgsGeometry': ...
    def normalize(self) -> None: ...
    def validateGeometry(self, method: Qgis.GeometryValidationEngine = ..., flags: Qgis.GeometryValidityFlag = ...) -> list['QgsGeometry.Error']: ...
    def forcePolygonCounterClockwise(self) -> 'QgsGeometry': ...
    def forcePolygonClockwise(self) -> 'QgsGeometry': ...
    def forceRHR(self) -> 'QgsGeometry': ...
    def isPolygonClockwise(self) -> bool: ...
    def isPolygonCounterClockwise(self) -> bool: ...
    def polygonOrientation(self) -> Qgis.AngularDirection: ...
    def makeValid(self, method: Qgis.MakeValidMethod = ..., keepCollapsed: bool = ...) -> 'QgsGeometry': ...
    def avoidIntersectionsV2(self, avoidIntersectionsLayers: collections.abc.Iterable[QgsVectorLayer]) -> Qgis.GeometryOperationResult: ...
    @deprecated("""""")
    def avoidIntersections(self, avoidIntersectionsLayers: collections.abc.Iterable[QgsVectorLayer]) -> int: ...
    def convertGeometryCollectionToSubclass(self, geomType: Qgis.GeometryType) -> bool: ...
    def convertToSingleType(self) -> bool: ...
    def convertToCurvedMultiType(self) -> bool: ...
    def convertToMultiType(self) -> bool: ...
    def deletePart(self, partNum: int) -> bool: ...
    def deleteRing(self, ringNum: int, partNum: int = ...) -> bool: ...
    def asQPolygonF(self) -> QtGui.QPolygonF: ...
    def asQPointF(self) -> QtCore.QPointF: ...
    def asGeometryCollection(self) -> list['QgsGeometry']: ...
    def asMultiPolygon(self) -> QgsMultiPolygonXY: ...
    def asMultiPolyline(self) -> QgsMultiPolylineXY: ...
    def asMultiPoint(self) -> QgsMultiPointXY: ...
    def asPolygon(self) -> QgsPolygonXY: ...
    def asPolyline(self) -> QgsPolylineXY: ...
    def asPoint(self) -> QgsPointXY: ...
    def convertToType(self, destType: Qgis.GeometryType, destMultipart: bool = ...) -> 'QgsGeometry': ...
    def coerceToType(self, type: Qgis.WkbType, defaultZ: float = ..., defaultM: float = ..., avoidDuplicates: bool = ...) -> list['QgsGeometry']: ...
    def asJson(self, precision: int = ...) -> str: ...
    def __repr__(self) -> typing.Any: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> int: ...
    def randomPointsInPolygon(self, count: int, seed: int = ...) -> QgsPolylineXY: ...
    def extrude(self, x: float, y: float) -> 'QgsGeometry': ...
    def symDifference(self, geometry: 'QgsGeometry', parameters: QgsGeometryParameters = ...) -> 'QgsGeometry': ...
    def difference(self, geometry: 'QgsGeometry', parameters: QgsGeometryParameters = ...) -> 'QgsGeometry': ...
    def mergeLines(self, parameters: QgsGeometryParameters = ...) -> 'QgsGeometry': ...
    def combine(self, geometry: 'QgsGeometry', parameters: QgsGeometryParameters = ...) -> 'QgsGeometry': ...
    def clipped(self, rectangle: 'QgsRectangle') -> 'QgsGeometry': ...
    def intersection(self, geometry: 'QgsGeometry', parameters: QgsGeometryParameters = ...) -> 'QgsGeometry': ...
    def interpolateAngle(self, distance: float) -> float: ...
    def lineLocatePoint(self, point: 'QgsGeometry') -> float: ...
    def interpolate(self, distance: float) -> 'QgsGeometry': ...
    def subdivide(self, maxNodes: int = ..., parameters: QgsGeometryParameters = ...) -> 'QgsGeometry': ...
    def sharedPaths(self, other: 'QgsGeometry') -> 'QgsGeometry': ...
    def node(self) -> 'QgsGeometry': ...
    def unionCoverage(self) -> 'QgsGeometry': ...
    def simplifyCoverageVW(self, tolerance: float, preserveBoundary: bool) -> 'QgsGeometry': ...
    def validateCoverage(self, gapWidth: float) -> typing.Tuple[Qgis.CoverageValidityResult, 'QgsGeometry|None']: ...
    def constrainedDelaunayTriangulation(self) -> 'QgsGeometry': ...
    def delaunayTriangulation(self, tolerance: float = ..., edgesOnly: bool = ...) -> 'QgsGeometry': ...
    def voronoiDiagram(self, extent: 'QgsGeometry' = ..., tolerance: float = ..., edgesOnly: bool = ...) -> 'QgsGeometry': ...
    def concaveHull(self, targetPercent: float, allowHoles: bool = ...) -> 'QgsGeometry': ...
    def convexHull(self) -> 'QgsGeometry': ...
    def minimumClearanceLine(self) -> 'QgsGeometry': ...
    def minimumClearance(self) -> float: ...
    def minimumWidth(self) -> 'QgsGeometry': ...
    def largestEmptyCircle(self, tolerance: float, boundary: 'QgsGeometry' = ...) -> 'QgsGeometry': ...
    def poleOfInaccessibility(self, precision: float) -> typing.Tuple['QgsGeometry', float]: ...
    def pointOnSurface(self) -> 'QgsGeometry': ...
    def centroid(self) -> 'QgsGeometry': ...
    def convertToCurves(self, distanceTolerance: float = ..., angleTolerance: float = ...) -> 'QgsGeometry': ...
    def densifyByDistance(self, distance: float) -> 'QgsGeometry': ...
    def densifyByCount(self, extraNodesPerSegment: int) -> 'QgsGeometry': ...
    def simplify(self, tolerance: float) -> 'QgsGeometry': ...
    def extendLine(self, startDistance: float, endDistance: float) -> 'QgsGeometry': ...
    def variableWidthBufferByM(self, segments: int) -> 'QgsGeometry': ...
    def taperedBuffer(self, startWidth: float, endWidth: float, segments: int) -> 'QgsGeometry': ...
    def singleSidedBuffer(self, distance: float, segments: int, side: Qgis.BufferSide, joinStyle: Qgis.JoinStyle = ..., miterLimit: float = ...) -> 'QgsGeometry': ...
    def offsetCurve(self, distance: float, segments: int, joinStyle: Qgis.JoinStyle, miterLimit: float) -> 'QgsGeometry': ...
    @typing.overload
    def buffer(self, distance: float, segments: int) -> 'QgsGeometry': ...
    @typing.overload
    def buffer(self, distance: float, segments: int, endCapStyle: Qgis.EndCapStyle, joinStyle: Qgis.JoinStyle, miterLimit: float) -> 'QgsGeometry': ...
    def crosses(self, geometry: 'QgsGeometry') -> bool: ...
    def within(self, geometry: 'QgsGeometry') -> bool: ...
    def overlaps(self, geometry: 'QgsGeometry') -> bool: ...
    def touches(self, geometry: 'QgsGeometry') -> bool: ...
    def disjoint(self, geometry: 'QgsGeometry') -> bool: ...
    @typing.overload
    def contains(self, p: QgsPointXY|None) -> bool: ...
    @typing.overload
    def contains(self, x: float, y: float) -> bool: ...
    @typing.overload
    def contains(self, geometry: 'QgsGeometry') -> bool: ...
    @typing.overload
    def boundingBoxIntersects(self, rectangle: 'QgsRectangle') -> bool: ...
    @typing.overload
    def boundingBoxIntersects(self, geometry: 'QgsGeometry') -> bool: ...
    @typing.overload
    def intersects(self, rectangle: 'QgsRectangle') -> bool: ...
    @typing.overload
    def intersects(self, geometry: 'QgsGeometry') -> bool: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ...) -> 'QgsGeometry': ...
    def applyDashPattern(self, pattern: collections.abc.Iterable[float], startRule: Qgis.DashPatternLineEndingRule = ..., endRule: Qgis.DashPatternLineEndingRule = ..., adjustment: Qgis.DashPatternSizeAdjustment = ..., patternOffset: float = ...) -> 'QgsGeometry': ...
    def roundWavesRandomized(self, minimumWavelength: float, maximumWavelength: float, minimumAmplitude: float, maximumAmplitude: float, seed: int = ...) -> 'QgsGeometry': ...
    def roundWaves(self, wavelength: float, amplitude: float, strictWavelength: bool = ...) -> 'QgsGeometry': ...
    def squareWavesRandomized(self, minimumWavelength: float, maximumWavelength: float, minimumAmplitude: float, maximumAmplitude: float, seed: int = ...) -> 'QgsGeometry': ...
    def squareWaves(self, wavelength: float, amplitude: float, strictWavelength: bool = ...) -> 'QgsGeometry': ...
    def triangularWavesRandomized(self, minimumWavelength: float, maximumWavelength: float, minimumAmplitude: float, maximumAmplitude: float, seed: int = ...) -> 'QgsGeometry': ...
    def triangularWaves(self, wavelength: float, amplitude: float, strictWavelength: bool = ...) -> 'QgsGeometry': ...
    def orthogonalize(self, tolerance: float = ..., maxIterations: int = ..., angleThreshold: float = ...) -> 'QgsGeometry': ...
    def minimalEnclosingCircle(self, segments: int = ...) -> typing.Tuple['QgsGeometry', QgsPointXY, float]: ...
    def orientedMinimumBoundingBox(self) -> typing.Tuple['QgsGeometry', float, float, float, float]: ...
    def boundingBox3D(self) -> QgsBox3D: ...
    def boundingBox(self) -> 'QgsRectangle': ...
    def makeDifference(self, other: 'QgsGeometry') -> 'QgsGeometry': ...
    def reshapeGeometry(self, reshapeLineString: 'QgsLineString') -> Qgis.GeometryOperationResult: ...
    @typing.overload
    def splitGeometry(self, splitLine: list['QgsPoint'|QgsPointXY], topological: bool, splitFeature: bool = ...) -> tuple[Qgis.GeometryOperationResult, list['QgsPoint']|list[QgsPointXY], list['QgsPoint']|list[QgsPointXY]]: ...
    @typing.overload
    def splitGeometry(self, curve: QgsCurve|None, preserveCircular: bool, topological: bool, splitFeature: bool = ...) -> typing.Tuple[Qgis.GeometryOperationResult, list['QgsGeometry'], list['QgsPoint']]: ...
    def rotate(self, rotation: float, center: QgsPointXY) -> Qgis.GeometryOperationResult: ...
    @typing.overload
    def transform(self, ct: 'QgsCoordinateTransform', direction: Qgis.TransformDirection = ..., transformZ: bool = ...) -> Qgis.GeometryOperationResult: ...
    @typing.overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> Qgis.GeometryOperationResult: ...
    def translate(self, dx: float, dy: float, dz: float = ..., dm: float = ...) -> Qgis.GeometryOperationResult: ...
    def removeInteriorRings(self, minimumAllowedArea: float = ...) -> 'QgsGeometry': ...
    def addPartGeometry(self, newPart: 'QgsGeometry') -> Qgis.GeometryOperationResult: ...
    def addPartV2(self, part: QgsAbstractGeometry|None, wkbType: Qgis.WkbType = ...) -> Qgis.GeometryOperationResult: ...
    @deprecated("""""")
    def addPart(self, part: QgsAbstractGeometry|None, geomType: Qgis.GeometryType = ...) -> Qgis.GeometryOperationResult: ...
    def addPointsV2(self, points: collections.abc.Iterable['QgsPoint'], wkbType: Qgis.WkbType = ...) -> Qgis.GeometryOperationResult: ...
    @deprecated("""""")
    def addPoints(self, points: collections.abc.Iterable['QgsPoint'], geomType: Qgis.GeometryType = ...) -> Qgis.GeometryOperationResult: ...
    def addPointsXYV2(self, points: collections.abc.Iterable[QgsPointXY], wkbType: Qgis.WkbType = ...) -> Qgis.GeometryOperationResult: ...
    @deprecated("""""")
    def addPointsXY(self, points: collections.abc.Iterable[QgsPointXY], geomType: Qgis.GeometryType = ...) -> Qgis.GeometryOperationResult: ...
    @typing.overload
    def addRing(self, ring: collections.abc.Iterable[QgsPointXY]) -> Qgis.GeometryOperationResult: ...
    @typing.overload
    def addRing(self, ring: QgsCurve|None) -> Qgis.GeometryOperationResult: ...
    def closestSegmentWithContext(self, point: QgsPointXY, epsilon: float = ...) -> typing.Tuple[float, QgsPointXY, int, int]: ...
    def closestVertexWithContext(self, point: QgsPointXY) -> typing.Tuple[float, int]: ...
    def shortestLine(self, other: 'QgsGeometry') -> 'QgsGeometry': ...
    def nearestPoint(self, other: 'QgsGeometry') -> 'QgsGeometry': ...
    def sqrDistToVertexAt(self, point: QgsPointXY, atVertex: int) -> float: ...
    def vertexAt(self, atVertex: int) -> 'QgsPoint': ...
    def toggleCircularAtVertex(self, atVertex: int) -> bool: ...
    def deleteVertex(self, atVertex: int) -> bool: ...
    @typing.overload
    def moveVertex(self, x: float, y: float, atVertex: int) -> bool: ...
    @typing.overload
    def moveVertex(self, p: 'QgsPoint', atVertex: int) -> bool: ...
    def addTopologicalPoint(self, point: 'QgsPoint', snappingTolerance: float = ..., segmentSearchEpsilon: float = ...) -> bool: ...
    @typing.overload
    def insertVertex(self, x: float, y: float, beforeVertex: int) -> bool: ...
    @typing.overload
    def insertVertex(self, point: 'QgsPoint', beforeVertex: int) -> bool: ...
    def adjacentVertices(self, atVertex: int) -> typing.Tuple[int, int]: ...
    def angleAtVertex(self, vertex: int) -> float: ...
    def distanceToVertex(self, vertex: int) -> float: ...
    def closestVertex(self, point: QgsPointXY) -> typing.Tuple[QgsPointXY, int, int, int, float]: ...
    def frechetDistanceDensify(self, geom: 'QgsGeometry', densifyFraction: float) -> float: ...
    def frechetDistance(self, geom: 'QgsGeometry') -> float: ...
    def hausdorffDistanceDensify(self, geom: 'QgsGeometry', densifyFraction: float) -> float: ...
    def hausdorffDistance(self, geom: 'QgsGeometry') -> float: ...
    def constParts(self) -> QgsGeometryConstPartIterator: ...
    def parts(self) -> QgsGeometryPartIterator: ...
    def vertices(self) -> QgsVertexIterator: ...
    def distance(self, geom: 'QgsGeometry') -> float: ...
    def length(self) -> float: ...
    def area3D(self) -> float: ...
    def area(self) -> float: ...
    def isAxisParallelRectangle(self, maximumDeviation: float, simpleRectanglesOnly: bool = ...) -> bool: ...
    def isSimple(self) -> bool: ...
    def isGeosValid(self, flags: Qgis.GeometryValidityFlag = ...) -> bool: ...
    def isGeosEqual(self, a0: 'QgsGeometry') -> bool: ...
    def equals(self, geometry: 'QgsGeometry') -> bool: ...
    def isMultipart(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def type(self) -> Qgis.GeometryType: ...
    def wkbType(self) -> Qgis.WkbType: ...
    def fromWkb(self, wkb: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    @staticmethod
    def createWedgeBufferFromAngles(center: 'QgsPoint', startAngle: float, endAngle: float, outerRadius: float, innerRadius: float = ...) -> 'QgsGeometry': ...
    @staticmethod
    def createWedgeBuffer(center: 'QgsPoint', azimuth: float, angularWidth: float, outerRadius: float, innerRadius: float = ...) -> 'QgsGeometry': ...
    @staticmethod
    def collectTinPatches(geometries: collections.abc.Iterable['QgsGeometry']) -> 'QgsGeometry': ...
    @staticmethod
    def collectGeometry(geometries: collections.abc.Iterable['QgsGeometry']) -> 'QgsGeometry': ...
    @staticmethod
    def fromBox3D(box: QgsBox3D) -> 'QgsGeometry': ...
    @staticmethod
    def fromRect(rect: 'QgsRectangle') -> 'QgsGeometry': ...
    @staticmethod
    def fromMultiPolygonXY(multipoly: typing.Any) -> 'QgsGeometry': ...
    @staticmethod
    def fromPolygonXY(polygon: typing.Any) -> 'QgsGeometry': ...
    @staticmethod
    def fromMultiPolylineXY(multiline: typing.Any) -> 'QgsGeometry': ...
    @staticmethod
    def fromPolyline(polyline: collections.abc.Iterable['QgsPoint']) -> 'QgsGeometry': ...
    @staticmethod
    def fromPolylineXY(polyline: collections.abc.Iterable[QgsPointXY]) -> 'QgsGeometry': ...
    @staticmethod
    def fromMultiPointXY(multipoint: collections.abc.Iterable[QgsPointXY]) -> 'QgsGeometry': ...
    @staticmethod
    def fromPoint(point: 'QgsPoint') -> 'QgsGeometry': ...
    @staticmethod
    def fromPointXY(point: QgsPointXY) -> 'QgsGeometry': ...
    @staticmethod
    def fromWkt(wkt: str|None) -> 'QgsGeometry': ...
    def isNull(self) -> bool: ...
    @deprecated("""""")
    def set(self, geometry: QgsAbstractGeometry|None) -> None: ...
    def get(self) -> QgsAbstractGeometry|None: ...
    def constGet(self) -> QgsAbstractGeometry|None: ...


class QgsGeometryCollection(QgsAbstractGeometry):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, c: 'QgsGeometryCollection') -> None: ...

    def clearCache(self) -> None: ...
    def calculateBoundingBox3D(self) -> QgsBox3D: ...
    def wktOmitChildType(self) -> bool: ...
    def compareToSameClass(self, other: QgsAbstractGeometry|None) -> int: ...
    def childGeometry(self, index: int) -> QgsAbstractGeometry|None: ...
    def childCount(self) -> int: ...
    def createEmptyWithSameType(self) -> 'QgsGeometryCollection|None': ...
    def extractPartsByType(self, type: Qgis.WkbType, useFlatType: bool = ...) -> 'QgsGeometryCollection|None': ...
    def __iter__(self) -> QgsGeometryPartIterator: ...
    def __delitem__(self, index: int) -> None: ...
    def __getitem__(self, index: int) -> QgsAbstractGeometry: ...
    def simplifyByDistance(self, tolerance: float) -> 'QgsGeometryCollection|None': ...
    def simplifiedTypeRef(self) -> QgsAbstractGeometry|None: ...
    def toCurveType(self) -> 'QgsGeometryCollection|None': ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def isValid(self, flags: Qgis.GeometryValidityFlag = ...) -> typing.Tuple[bool, str]: ...
    def vertexAt(self, id: 'QgsVertexId') -> 'QgsPoint': ...
    def partCount(self) -> int: ...
    def ringCount(self, part: int = ...) -> int: ...
    def vertexCount(self, part: int = ..., ring: int = ...) -> int: ...
    def segmentLength(self, startVertex: 'QgsVertexId') -> float: ...
    def vertexAngle(self, vertex: 'QgsVertexId') -> float: ...
    def segmentize(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsAbstractGeometry|None: ...
    def hasCurvedSegments(self) -> bool: ...
    def perimeter(self) -> float: ...
    def area3D(self) -> float: ...
    def area(self) -> float: ...
    def length(self) -> float: ...
    def deleteVertex(self, position: 'QgsVertexId') -> bool: ...
    def moveVertex(self, position: 'QgsVertexId', newPos: 'QgsPoint') -> bool: ...
    def insertVertex(self, position: 'QgsVertexId', vertex: 'QgsPoint') -> bool: ...
    def nextVertex(self, id: 'QgsVertexId') -> typing.Tuple[bool, 'QgsPoint']: ...
    def closestSegment(self, pt: 'QgsPoint', epsilon: float = ...) -> typing.Tuple[float, 'QgsPoint', 'QgsVertexId', int]: ...
    def nCoordinates(self) -> int: ...
    def coordinateSequence(self) -> typing.Any: ...
    def boundingBox3D(self) -> QgsBox3D: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> int: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def fromWkb(self, wkb: 'QgsConstWkbPtr') -> bool: ...
    def asQPainterPath(self) -> QtGui.QPainterPath: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    @typing.overload
    def transform(self, ct: 'QgsCoordinateTransform', d: Qgis.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @typing.overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @typing.overload
    def transform(self, transformer: 'QgsAbstractGeometryTransformer|None', feedback: QgsFeedback|None = ...) -> bool: ...
    def normalize(self) -> None: ...
    def takeGeometries(self) -> list[QgsAbstractGeometry]: ...
    def removeGeometry(self, nr: int) -> bool: ...
    def insertGeometry(self, g: QgsAbstractGeometry|None, index: int) -> bool: ...
    def addGeometries(self, geometries: collections.abc.Iterable[QgsAbstractGeometry]) -> bool: ...
    def addGeometry(self, g: QgsAbstractGeometry|None) -> bool: ...
    def reserve(self, size: int) -> None: ...
    def boundingBoxIntersects(self, box3d: QgsBox3D) -> bool: ...
    def vertexNumberFromVertexId(self, id: 'QgsVertexId') -> int: ...
    def adjacentVertices(self, vertex: 'QgsVertexId') -> typing.Tuple['QgsVertexId', 'QgsVertexId']: ...
    def boundary(self) -> QgsAbstractGeometry|None: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ..., removeRedundantPoints: bool = ...) -> 'QgsGeometryCollection|None': ...
    def clear(self) -> None: ...
    def geometryType(self) -> str: ...
    def dimension(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def geometryN(self, n: int) -> QgsAbstractGeometry: ...
    def __bool__(self) -> int: ...
    def __len__(self) -> int: ...
    def numGeometries(self) -> int: ...
    def clone(self) -> 'QgsGeometryCollection|None': ...
    def fuzzyDistanceEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    def fuzzyEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsGeometryEngine(PyQt6.sip.wrapper):

    class EngineOperationResult(enum.IntEnum):
        Success = ... # type: QgsGeometryEngine.EngineOperationResult
        NothingHappened = ... # type: QgsGeometryEngine.EngineOperationResult
        MethodNotImplemented = ... # type: QgsGeometryEngine.EngineOperationResult
        EngineError = ... # type: QgsGeometryEngine.EngineOperationResult
        NodedGeometryError = ... # type: QgsGeometryEngine.EngineOperationResult
        InvalidBaseGeometry = ... # type: QgsGeometryEngine.EngineOperationResult
        InvalidInput = ... # type: QgsGeometryEngine.EngineOperationResult
        SplitCannotSplitPoint = ... # type: QgsGeometryEngine.EngineOperationResult

    @typing.overload
    def __init__(self, geometry: QgsAbstractGeometry|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryEngine') -> None: ...

    def logError(self, engineName: str|None, message: str|None) -> None: ...
    def setLogErrors(self, enabled: bool) -> None: ...
    def offsetCurve(self, distance: float, segments: int, joinStyle: Qgis.JoinStyle, miterLimit: float, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    def splitGeometry(self, splitLine: 'QgsLineString', topological: bool, topologyTestPoints: collections.abc.Iterable['QgsPoint'], errorMsg: str|None = ..., skipIntersectionCheck: bool = ...) -> typing.Tuple['QgsGeometryEngine.EngineOperationResult', list[QgsGeometry]]: ...
    def isSimple(self, errorMsg: str|None = ...) -> bool: ...
    def isEmpty(self, errorMsg: str|None) -> bool: ...
    def isEqual(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def isValid(self, errorMsg: str|None = ..., allowSelfTouchingHoles: bool = ..., errorLoc: QgsGeometry|None = ...) -> bool: ...
    def length(self, errorMsg: str|None = ...) -> float: ...
    def area(self, errorMsg: str|None = ...) -> float: ...
    def relatePattern(self, geom: QgsAbstractGeometry|None, pattern: str|None, errorMsg: str|None = ...) -> bool: ...
    def relate(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> str: ...
    def disjoint(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def contains(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def overlaps(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def within(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def crosses(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def touches(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def intersects(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def distanceWithin(self, geom: QgsAbstractGeometry|None, maxdistance: float, errorMsg: str|None = ...) -> bool: ...
    def distance(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> float: ...
    def convexHull(self, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    def pointOnSurface(self, errorMsg: str|None = ...) -> 'QgsPoint|None': ...
    def centroid(self, errorMsg: str|None = ...) -> 'QgsPoint|None': ...
    def envelope(self, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    def interpolate(self, distance: float, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    def simplify(self, tolerance: float, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    @typing.overload
    def buffer(self, distance: float, segments: int, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    @typing.overload
    def buffer(self, distance: float, segments: int, endCapStyle: Qgis.EndCapStyle, joinStyle: Qgis.JoinStyle, miterLimit: float, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    def symDifference(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ..., parameters: QgsGeometryParameters = ...) -> QgsAbstractGeometry|None: ...
    @typing.overload
    def combine(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ..., parameters: QgsGeometryParameters = ...) -> QgsAbstractGeometry|None: ...
    @typing.overload
    def combine(self, geomList: collections.abc.Iterable[QgsAbstractGeometry], errorMsg: str|None, parameters: QgsGeometryParameters = ...) -> QgsAbstractGeometry|None: ...
    @typing.overload
    def combine(self, geometries: collections.abc.Iterable[QgsGeometry], errorMsg: str|None = ..., parameters: QgsGeometryParameters = ...) -> QgsAbstractGeometry|None: ...
    def difference(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ..., parameters: QgsGeometryParameters = ...) -> QgsAbstractGeometry|None: ...
    def intersection(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ..., parameters: QgsGeometryParameters = ...) -> QgsAbstractGeometry|None: ...
    def prepareGeometry(self) -> None: ...
    def geometryChanged(self) -> None: ...


class QgsAbstractGeometryTransformer(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractGeometryTransformer') -> None: ...

    def transformPoint(self, x: float, y: float, z: float, m: float) -> typing.Tuple[bool, float, float, float, float]: ...


class QgsGeometryUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryUtils') -> None: ...

    @staticmethod
    def interpolateZ(a: 'QgsPoint', b: 'QgsPoint', c: 'QgsPoint', x: float, y: float) -> float: ...
    @staticmethod
    def checkWeaklyFor3DPlane(geom: QgsAbstractGeometry|None, epsilon: float = ...) -> typing.Tuple[bool, 'QgsPoint', 'QgsPoint', 'QgsPoint']: ...
    @staticmethod
    def filletVertex(curve: QgsCurve|None, vertexIndex: int, radius: float, segments: int) -> QgsAbstractGeometry|None: ...
    @staticmethod
    def chamferVertex(curve: QgsCurve|None, vertexIndex: int, distance1: float, distance2: float) -> QgsAbstractGeometry|None: ...
    @staticmethod
    def maxFilletRadius(segment1Start: 'QgsPoint', segment1End: 'QgsPoint', segment2Start: 'QgsPoint', segment2End: 'QgsPoint', epsilon: float = ...) -> float: ...
    @staticmethod
    def createFilletGeometry(segment1Start: 'QgsPoint', segment1End: 'QgsPoint', segment2Start: 'QgsPoint', segment2End: 'QgsPoint', radius: float, segments: int) -> QgsAbstractGeometry|None: ...
    @staticmethod
    def createChamferGeometry(segment1Start: 'QgsPoint', segment1End: 'QgsPoint', segment2Start: 'QgsPoint', segment2End: 'QgsPoint', distance1: float, distance2: float) -> 'QgsLineString'|None: ...
    @staticmethod
    def createFillet(segment1Start: 'QgsPoint', segment1End: 'QgsPoint', segment2Start: 'QgsPoint', segment2End: 'QgsPoint', radius: float, epsilon: float = ...) -> typing.Tuple[bool, 'QgsPoint', 'QgsPoint', 'QgsPoint']: ...
    @staticmethod
    def createChamfer(segment1Start: 'QgsPoint', segment1End: 'QgsPoint', segment2Start: 'QgsPoint', segment2End: 'QgsPoint', distance1: float, distance2: float, epsilon: float = ...) -> typing.Tuple[bool, 'QgsPoint', 'QgsPoint']: ...
    @staticmethod
    def interpolatePointOnSegment(x: float, y: float, segmentStart: 'QgsPoint', segmentEnd: 'QgsPoint') -> 'QgsPoint': ...
    @staticmethod
    def createPointWithMatchingDimensions(x: float, y: float, reference: 'QgsPoint') -> 'QgsPoint': ...
    @staticmethod
    def segmentIntersection(p1: 'QgsPoint', p2: 'QgsPoint', q1: 'QgsPoint', q2: 'QgsPoint', tolerance: float = ..., acceptImproperIntersection: bool = ...) -> typing.Tuple[bool, 'QgsPoint', bool]: ...
    @staticmethod
    def intersectionPointOfLinesByBearing(pt1: 'QgsPoint', bearing1: float, pt2: 'QgsPoint', bearing2: float) -> typing.Tuple[bool, 'QgsPoint']: ...
    @staticmethod
    def lineIntersection(p1: 'QgsPoint', v1: QgsVector, p2: 'QgsPoint', v2: QgsVector) -> typing.Tuple[bool, 'QgsPoint']: ...
    @staticmethod
    def circleCenterRadius(pt1: 'QgsPoint', pt2: 'QgsPoint', pt3: 'QgsPoint') -> typing.Tuple[float, float, float]: ...
    @staticmethod
    def bisector(aX: float, aY: float, bX: float, bY: float, cX: float, cY: float) -> typing.Tuple[bool, float, float]: ...
    @staticmethod
    def angleBisector(aX: float, aY: float, bX: float, bY: float, cX: float, cY: float, dX: float, dY: float) -> typing.Tuple[bool, float, float, float]: ...
    @typing.overload
    @staticmethod
    def pointsAreCollinear(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, epsilon: float) -> bool: ...
    @typing.overload
    @staticmethod
    def pointsAreCollinear(pt1: 'QgsPoint', pt2: 'QgsPoint', pt3: 'QgsPoint', epsilon: float) -> bool: ...
    @staticmethod
    def weightedPointInTriangle(aX: float, aY: float, bX: float, bY: float, cX: float, cY: float, weightB: float, weightC: float) -> typing.Tuple[float, float]: ...
    @staticmethod
    def pointFractionAlongLine(x1: float, y1: float, x2: float, y2: float, px: float, py: float) -> float: ...
    @staticmethod
    @deprecated("""""")
    def triangleArea(aX: float, aY: float, bX: float, bY: float, cX: float, cY: float) -> float: ...
    @staticmethod
    def linesIntersection3D(La1: QgsVector3D, La2: QgsVector3D, Lb1: QgsVector3D, Lb2: QgsVector3D) -> typing.Tuple[bool, QgsVector3D]: ...
    @staticmethod
    def skewLinesProjection(P1: QgsVector3D, P12: QgsVector3D, P2: QgsVector3D, P22: QgsVector3D, epsilon: float = ...) -> typing.Tuple[bool, QgsVector3D]: ...
    @staticmethod
    @deprecated("""""")
    def skewLinesDistance(P1: QgsVector3D, P12: QgsVector3D, P2: QgsVector3D, P22: QgsVector3D) -> float: ...
    @staticmethod
    def perpendicularCenterSegment(centerPointX: float, centerPointY: float, segmentPoint1x: float, segmentPoint1y: float, segmentPoint2x: float, segmentPoint2y: float, segmentLength: float = ...) -> typing.Tuple[float, float, float, float]: ...
    @staticmethod
    def closestSideOfRectangle(right: float, bottom: float, left: float, top: float, x: float, y: float) -> int: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def averageAngle(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> float: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def averageAngle(a1: float, a2: float) -> float: ...
    @staticmethod
    @deprecated("""""")
    def linePerpendicularAngle(x1: float, y1: float, x2: float, y2: float) -> float: ...
    @staticmethod
    @deprecated("""""")
    def angleBetweenThreePoints(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> float: ...
    @staticmethod
    @deprecated("""""")
    def lineAngle(x1: float, y1: float, x2: float, y2: float) -> float: ...
    @staticmethod
    @deprecated("""""")
    def normalizedAngle(angle: float) -> float: ...
    @staticmethod
    @deprecated("""""")
    def interpolateArcValue(angle: float, a1: float, a2: float, a3: float, zm1: float, zm2: float, zm3: float) -> float: ...
    @staticmethod
    @deprecated("""""")
    def sweepAngle(centerX: float, centerY: float, x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> float: ...
    @staticmethod
    @deprecated("""""")
    def circleLength(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> float: ...
    @staticmethod
    @deprecated("""""")
    def angleOnCircle(angle: float, angle1: float, angle2: float, angle3: float) -> bool: ...
    @staticmethod
    @deprecated("""""")
    def circleAngleBetween(angle: float, angle1: float, angle2: float, clockwise: bool) -> bool: ...
    @staticmethod
    @deprecated("""""")
    def circleClockwise(angle1: float, angle2: float, angle3: float) -> bool: ...
    @staticmethod
    @deprecated("""""")
    def ccwAngle(dy: float, dx: float) -> float: ...
    @staticmethod
    def perpendicularOffsetPointAlongSegment(x1: float, y1: float, x2: float, y2: float, proportion: float, offset: float) -> typing.Tuple[float, float]: ...
    @staticmethod
    @deprecated("""""")
    def sqrDistToLine(ptX: float, ptY: float, x1: float, y1: float, x2: float, y2: float, epsilon: float) -> typing.Tuple[float, float, float]: ...
    @staticmethod
    def distance3D(pt1: 'QgsPoint', pt2: 'QgsPoint') -> float: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def distance2D(x1: float, y1: float, x2: float, y2: float) -> float: ...
    @typing.overload
    @staticmethod
    def distance2D(pt1: 'QgsPoint', pt2: 'QgsPoint') -> float: ...
    @staticmethod
    def sqrDistance3D(pt1: 'QgsPoint', pt2: 'QgsPoint') -> float: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def sqrDistance2D(x1: float, y1: float, x2: float, y2: float) -> float: ...
    @typing.overload
    @staticmethod
    def sqrDistance2D(pt1: 'QgsPoint', pt2: 'QgsPoint') -> float: ...
    @typing.overload
    @staticmethod
    def transferFirstZOrMValueToPoint(points: collections.abc.Iterable['QgsPoint'], point: 'QgsPoint') -> bool: ...
    @typing.overload
    @staticmethod
    def transferFirstZOrMValueToPoint(geom: QgsGeometry, point: 'QgsPoint') -> bool: ...
    @staticmethod
    def transferFirstMValueToPoint(points: collections.abc.Iterable['QgsPoint'], point: 'QgsPoint') -> bool: ...
    @staticmethod
    def transferFirstZValueToPoint(points: collections.abc.Iterable['QgsPoint'], point: 'QgsPoint') -> bool: ...
    @staticmethod
    @deprecated("""""")
    def setZValueFromPoints(points: collections.abc.Iterable['QgsPoint'], point: 'QgsPoint') -> bool: ...
    @staticmethod
    def perpendicularSegment(p: 'QgsPoint', s1: 'QgsPoint', s2: 'QgsPoint') -> 'QgsLineString': ...
    @staticmethod
    def coefficients(pt1: 'QgsPoint', pt2: 'QgsPoint') -> typing.Tuple[float, float, float]: ...
    @staticmethod
    def gradient(pt1: 'QgsPoint', pt2: 'QgsPoint') -> float: ...
    @staticmethod
    def interpolatePointOnLineByValue(x1: float, y1: float, v1: float, x2: float, y2: float, v2: float, value: float) -> QgsPointXY: ...
    @typing.overload
    @staticmethod
    def interpolatePointOnLine(x1: float, y1: float, x2: float, y2: float, fraction: float) -> QgsPointXY: ...
    @typing.overload
    @staticmethod
    def interpolatePointOnLine(p1: 'QgsPoint', p2: 'QgsPoint', fraction: float) -> 'QgsPoint': ...
    @staticmethod
    def midpoint(pt1: 'QgsPoint', pt2: 'QgsPoint') -> 'QgsPoint': ...
    @staticmethod
    def segmentSide(pt1: 'QgsPoint', pt3: 'QgsPoint', pt2: 'QgsPoint') -> int: ...
    @staticmethod
    def pointContinuesArc(a1: 'QgsPoint', a2: 'QgsPoint', a3: 'QgsPoint', b: 'QgsPoint', distanceTolerance: float, pointSpacingAngleTolerance: float) -> bool: ...
    @staticmethod
    def segmentizeArc(p1: 'QgsPoint', p2: 'QgsPoint', p3: 'QgsPoint', tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ..., hasZ: bool = ..., hasM: bool = ...) -> list['QgsPoint']: ...
    @staticmethod
    def circleTangentDirection(tangentPoint: 'QgsPoint', cp1: 'QgsPoint', cp2: 'QgsPoint', cp3: 'QgsPoint') -> float: ...
    @staticmethod
    def segmentMidPointFromCenter(p1: 'QgsPoint', p2: 'QgsPoint', center: 'QgsPoint', useShortestArc: bool = ...) -> 'QgsPoint': ...
    @staticmethod
    def segmentMidPoint(p1: 'QgsPoint', p2: 'QgsPoint', radius: float, mousePos: 'QgsPoint') -> typing.Tuple[bool, 'QgsPoint']: ...
    @staticmethod
    def interpolatePointOnCubicBezier(p0: 'QgsPoint', p1: 'QgsPoint', p2: 'QgsPoint', p3: 'QgsPoint', t: float) -> 'QgsPoint': ...
    @staticmethod
    def interpolatePointOnArc(pt1: 'QgsPoint', pt2: 'QgsPoint', pt3: 'QgsPoint', distance: float) -> 'QgsPoint': ...
    @staticmethod
    def pointOnLineWithDistance(startPoint: 'QgsPoint', directionPoint: 'QgsPoint', distance: float) -> 'QgsPoint': ...
    @typing.overload
    @staticmethod
    def leftOfLine(point: 'QgsPoint', p1: 'QgsPoint', p2: 'QgsPoint') -> int: ...
    @typing.overload
    @staticmethod
    @deprecated("""""")
    def leftOfLine(x: float, y: float, x1: float, y1: float, x2: float, y2: float) -> int: ...
    @staticmethod
    def projectPointOnSegment(p: 'QgsPoint', s1: 'QgsPoint', s2: 'QgsPoint') -> 'QgsPoint': ...
    @staticmethod
    def circleCircleInnerTangents(center1: QgsPointXY, radius1: float, center2: QgsPointXY, radius2: float) -> typing.Tuple[int, QgsPointXY, QgsPointXY, QgsPointXY, QgsPointXY]: ...
    @staticmethod
    def circleCircleOuterTangents(center1: QgsPointXY, radius1: float, center2: QgsPointXY, radius2: float) -> typing.Tuple[int, QgsPointXY, QgsPointXY, QgsPointXY, QgsPointXY]: ...
    @staticmethod
    def tangentPointAndCircle(center: QgsPointXY, radius: float, p: QgsPointXY) -> typing.Tuple[bool, QgsPointXY, QgsPointXY]: ...
    @staticmethod
    def circleCircleIntersections(center1: QgsPointXY, radius1: float, center2: QgsPointXY, radius2: float) -> typing.Tuple[int, QgsPointXY, QgsPointXY]: ...
    @staticmethod
    def lineCircleIntersection(center: QgsPointXY, radius: float, linePoint1: QgsPointXY, linePoint2: QgsPointXY, intersection: QgsPointXY) -> typing.Tuple[bool, QgsPointXY]: ...
    @staticmethod
    def distToInfiniteLine(point: 'QgsPoint', linePoint1: 'QgsPoint', linePoint2: 'QgsPoint', epsilon: float = ...) -> float: ...
    @staticmethod
    def verticesAtDistance(geometry: QgsAbstractGeometry, distance: float) -> typing.Tuple[bool, 'QgsVertexId', 'QgsVertexId']: ...
    @staticmethod
    def distanceToVertex(geom: QgsAbstractGeometry, id: 'QgsVertexId') -> float: ...
    @staticmethod
    def closestPoint(geometry: QgsAbstractGeometry, point: 'QgsPoint') -> 'QgsPoint': ...
    @staticmethod
    def closestVertex(geom: QgsAbstractGeometry, pt: 'QgsPoint') -> typing.Tuple['QgsPoint', 'QgsVertexId']: ...
    @staticmethod
    def extractLineStrings(geom: QgsAbstractGeometry|None) -> list['QgsLineString']: ...


class QgsGeometryUtilsBase(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryUtilsBase') -> None: ...

    @staticmethod
    def azimuth(x1: float, y1: float, x2: float, y2: float) -> float: ...
    @staticmethod
    def project(aX: float, aY: float, aZ: float, distance: float, azimuth: float, inclination: float) -> typing.Tuple[float, float, float]: ...
    @staticmethod
    def segmentIntersection(p1x: float, p1y: float, p2x: float, p2y: float, q1x: float, q1y: float, q2x: float, q2y: float, tolerance: float = ..., acceptImproperIntersection: bool = ...) -> typing.Tuple[bool, float, float, bool]: ...
    @staticmethod
    def intersectionPointOfLinesByBearing(x1: float, y1: float, bearing1: float, x2: float, y2: float, bearing2: float) -> typing.Tuple[bool, float, float]: ...
    @staticmethod
    def lineIntersection(p1x: float, p1y: float, v1: QgsVector, p2x: float, p2y: float, v2: QgsVector) -> typing.Tuple[bool, float, float]: ...
    @staticmethod
    def bisector(aX: float, aY: float, bX: float, bY: float, cX: float, cY: float) -> typing.Tuple[bool, float, float]: ...
    @staticmethod
    def angleBisector(aX: float, aY: float, bX: float, bY: float, cX: float, cY: float, dX: float, dY: float) -> typing.Tuple[bool, float, float, float]: ...
    @staticmethod
    def points3DAreCollinear(x1: float, y1: float, z1: float, x2: float, y2: float, z2: float, x3: float, y3: float, z3: float, epsilon: float) -> bool: ...
    @staticmethod
    def pointsAreCollinear(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, epsilon: float) -> bool: ...
    @staticmethod
    def weightedPointInTriangle(aX: float, aY: float, bX: float, bY: float, cX: float, cY: float, weightB: float, weightC: float) -> typing.Tuple[float, float]: ...
    @staticmethod
    def pointFractionAlongLine(x1: float, y1: float, x2: float, y2: float, px: float, py: float) -> float: ...
    @staticmethod
    def triangleArea(aX: float, aY: float, bX: float, bY: float, cX: float, cY: float) -> float: ...
    @staticmethod
    def linesIntersection3D(La1: QgsVector3D, La2: QgsVector3D, Lb1: QgsVector3D, Lb2: QgsVector3D) -> typing.Tuple[bool, QgsVector3D]: ...
    @staticmethod
    def skewLinesProjection(P1: QgsVector3D, P12: QgsVector3D, P2: QgsVector3D, P22: QgsVector3D, epsilon: float = ...) -> typing.Tuple[bool, QgsVector3D]: ...
    @staticmethod
    def skewLinesDistance(P1: QgsVector3D, P12: QgsVector3D, P2: QgsVector3D, P22: QgsVector3D) -> float: ...
    @staticmethod
    def perpendicularCenterSegment(centerPointX: float, centerPointY: float, segmentPoint1x: float, segmentPoint1y: float, segmentPoint2x: float, segmentPoint2y: float, segmentLength: float = ...) -> typing.Tuple[float, float, float, float]: ...
    @staticmethod
    def closestSideOfRectangle(right: float, bottom: float, left: float, top: float, x: float, y: float) -> int: ...
    @typing.overload
    @staticmethod
    def averageAngle(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> float: ...
    @typing.overload
    @staticmethod
    def averageAngle(a1: float, a2: float) -> float: ...
    @staticmethod
    def linePerpendicularAngle(x1: float, y1: float, x2: float, y2: float) -> float: ...
    @staticmethod
    def angleBetweenThreePoints(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> float: ...
    @staticmethod
    def lineAngle(x1: float, y1: float, x2: float, y2: float) -> float: ...
    @staticmethod
    def normalizedAngle(angle: float) -> float: ...
    @staticmethod
    def interpolateArcValue(angle: float, a1: float, a2: float, a3: float, zm1: float, zm2: float, zm3: float) -> float: ...
    @staticmethod
    def sweepAngle(centerX: float, centerY: float, x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> float: ...
    @staticmethod
    def calculateArcLength(centerX: float, centerY: float, radius: float, x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, fromVertex: int, toVertex: int) -> float: ...
    @staticmethod
    def circleLength(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> float: ...
    @staticmethod
    def angleOnCircle(angle: float, angle1: float, angle2: float, angle3: float) -> bool: ...
    @staticmethod
    def circleAngleBetween(angle: float, angle1: float, angle2: float, clockwise: bool) -> bool: ...
    @staticmethod
    def circleClockwise(angle1: float, angle2: float, angle3: float) -> bool: ...
    @staticmethod
    def circleCenterRadius(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> typing.Tuple[float, float, float]: ...
    @staticmethod
    def ccwAngle(dy: float, dx: float) -> float: ...
    @staticmethod
    def perpendicularOffsetPointAlongSegment(x1: float, y1: float, x2: float, y2: float, proportion: float, offset: float) -> typing.Tuple[float, float]: ...
    @staticmethod
    def leftOfLine(x: float, y: float, x1: float, y1: float, x2: float, y2: float) -> int: ...
    @staticmethod
    def sqrDistToLine(ptX: float, ptY: float, x1: float, y1: float, x2: float, y2: float, epsilon: float) -> typing.Tuple[float, float, float]: ...
    @typing.overload
    @staticmethod
    def distance2D(x1: float, y1: float, x2: float, y2: float) -> float: ...
    @typing.overload
    @staticmethod
    def distance2D(point1: QtCore.QPointF, point2: QtCore.QPointF) -> float: ...
    @typing.overload
    @staticmethod
    def sqrDistance2D(x1: float, y1: float, x2: float, y2: float) -> float: ...
    @typing.overload
    @staticmethod
    def sqrDistance2D(point1: QtCore.QPointF, point2: QtCore.QPointF) -> float: ...
    @staticmethod
    def distance3D(x1: float, y1: float, z1: float, x2: float, y2: float, z2: float) -> float: ...
    @staticmethod
    def sqrDistance3D(x1: float, y1: float, z1: float, x2: float, y2: float, z2: float) -> float: ...


class QgsGeos(QgsGeometryEngine):

    def __init__(self, geometry: QgsAbstractGeometry|None, precision: float = ..., flags: Qgis.GeosCreationFlag = ...) -> None: ...

    def unionCoverage(self) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def simplifyCoverageVW(self, tolerance: float, preserveBoundary: bool) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def concaveHull(self, targetPercent: float, allowHoles: bool = ...) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def constrainedDelaunayTriangulation(self) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def delaunayTriangulation(self, tolerance: float = ..., edgesOnly: bool = ...) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def voronoiDiagram(self, extent: QgsAbstractGeometry|None = ..., tolerance: float = ..., edgesOnly: bool = ...) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    @typing.overload
    def lineLocatePoint(self, point: 'QgsPoint') -> typing.Tuple[float, str]: ...
    @typing.overload
    def lineLocatePoint(self, x: float, y: float) -> typing.Tuple[float, str]: ...
    @typing.overload
    def shortestLine(self, other: QgsGeometry) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    @typing.overload
    def shortestLine(self, other: QgsAbstractGeometry|None) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def closestPoint(self, other: QgsGeometry) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def mergeLines(self, parameters: QgsGeometryParameters = ...) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def sharedPaths(self, other: QgsAbstractGeometry|None) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def node(self) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def minimumClearanceLine(self) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def minimumClearance(self) -> typing.Tuple[float, str]: ...
    def minimumWidth(self) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def largestEmptyCircle(self, tolerance: float, boundary: QgsAbstractGeometry|None = ...) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def maximumInscribedCircle(self, tolerance: float) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def singleSidedBuffer(self, distance: float, segments: int, side: Qgis.BufferSide, joinStyle: Qgis.JoinStyle, miterLimit: float) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def offsetCurve(self, distance: float, segments: int, joinStyle: Qgis.JoinStyle, miterLimit: float, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    def splitGeometry(self, splitLine: 'QgsLineString', newGeometries: collections.abc.Iterable[QgsGeometry], topological: bool, topologyTestPoints: collections.abc.Iterable['QgsPoint'], errorMsg: str|None = ..., skipIntersectionCheck: bool = ...) -> QgsGeometryEngine.EngineOperationResult: ...
    def isSimple(self, errorMsg: str|None = ...) -> bool: ...
    def isEmpty(self, errorMsg: str|None = ...) -> bool: ...
    def isEqual(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def isValid(self, errorMsg: str|None = ..., allowSelfTouchingHoles: bool = ..., errorLoc: QgsGeometry|None = ...) -> bool: ...
    def length(self, errorMsg: str|None = ...) -> float: ...
    def area(self, errorMsg: str|None = ...) -> float: ...
    def relatePattern(self, geom: QgsAbstractGeometry|None, pattern: str|None, errorMsg: str|None = ...) -> bool: ...
    def relate(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> str: ...
    def disjoint(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def overlaps(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def within(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def crosses(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def touches(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def intersects(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def frechetDistanceDensify(self, geometry: QgsAbstractGeometry|None, densifyFraction: float) -> typing.Tuple[float, str]: ...
    def frechetDistance(self, geometry: QgsAbstractGeometry|None) -> typing.Tuple[float, str]: ...
    def hausdorffDistanceDensify(self, geometry: QgsAbstractGeometry|None, densifyFraction: float) -> typing.Tuple[float, str]: ...
    def hausdorffDistance(self, geometry: QgsAbstractGeometry|None) -> typing.Tuple[float, str]: ...
    @typing.overload
    def contains(self, x: float, y: float) -> typing.Tuple[bool, str]: ...
    @typing.overload
    def contains(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> bool: ...
    def distanceWithin(self, geom: QgsAbstractGeometry|None, maxdistance: float, errorMsg: str|None = ...) -> bool: ...
    @typing.overload
    def distance(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ...) -> float: ...
    @typing.overload
    def distance(self, x: float, y: float) -> typing.Tuple[float, str]: ...
    def convexHull(self, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    def pointOnSurface(self, errorMsg: str|None = ...) -> 'QgsPoint|None': ...
    def centroid(self, errorMsg: str|None = ...) -> 'QgsPoint|None': ...
    def envelope(self, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    def interpolate(self, distance: float, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    def simplify(self, tolerance: float, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    @typing.overload
    def buffer(self, distance: float, segments: int, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    @typing.overload
    def buffer(self, distance: float, segments: int, endCapStyle: Qgis.EndCapStyle, joinStyle: Qgis.JoinStyle, miterLimit: float, errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...
    def symDifference(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ..., parameters: QgsGeometryParameters = ...) -> QgsAbstractGeometry|None: ...
    @typing.overload
    def combine(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ..., parameters: QgsGeometryParameters = ...) -> QgsAbstractGeometry|None: ...
    @typing.overload
    def combine(self, geomList: collections.abc.Iterable[QgsAbstractGeometry], errorMsg: str|None, parameters: QgsGeometryParameters = ...) -> QgsAbstractGeometry|None: ...
    @typing.overload
    def combine(self, a0: collections.abc.Iterable[QgsGeometry], errorMsg: str|None = ..., parameters: QgsGeometryParameters = ...) -> QgsAbstractGeometry|None: ...
    def subdivide(self, maxNodes: int, parameters: QgsGeometryParameters = ...) -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def clip(self, rectangle: 'QgsRectangle') -> typing.Tuple[QgsAbstractGeometry|None, str]: ...
    def difference(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ..., parameters: QgsGeometryParameters = ...) -> QgsAbstractGeometry|None: ...
    def intersection(self, geom: QgsAbstractGeometry|None, errorMsg: str|None = ..., parameters: QgsGeometryParameters = ...) -> QgsAbstractGeometry|None: ...
    def prepareGeometry(self) -> None: ...
    def geometryChanged(self) -> None: ...
    def makeValid(self, method: Qgis.MakeValidMethod = ..., keepCollapsed: bool = ..., errorMsg: str|None = ...) -> QgsAbstractGeometry|None: ...


class QgsLineSegment2D(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, start: QgsPointXY, end: QgsPointXY) -> None: ...
    @typing.overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLineSegment2D') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def reverse(self) -> None: ...
    def pointLeftOfLine(self, point: QgsPointXY) -> int: ...
    def setEnd(self, end: QgsPointXY) -> None: ...
    def setStart(self, start: QgsPointXY) -> None: ...
    def setEndY(self, y: float) -> None: ...
    def setEndX(self, x: float) -> None: ...
    def setStartY(self, y: float) -> None: ...
    def setStartX(self, x: float) -> None: ...
    def end(self) -> QgsPointXY: ...
    def start(self) -> QgsPointXY: ...
    def endY(self) -> float: ...
    def endX(self) -> float: ...
    def startY(self) -> float: ...
    def startX(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...


class QgsLineString(QgsCurve):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, points: collections.abc.Sequence['QgsPoint'|QgsPointXY|collections.abc.Sequence[float]]) -> None: ...
    @typing.overload
    def __init__(self, segment: QgsLineSegment2D) -> None: ...
    @typing.overload
    def __init__(self, x: collections.abc.Iterable[float], y: collections.abc.Iterable[float], z: collections.abc.Iterable[float] = ..., m: collections.abc.Iterable[float] = ..., is25DType: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, p1: 'QgsPoint', p2: 'QgsPoint') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLineString') -> None: ...

    def compareToSameClass(self, other: QgsAbstractGeometry|None) -> int: ...
    def lineLocatePointByM(self, m: float, use3DDistance: bool = ...) -> typing.Tuple[bool, float, float, float, float]: ...
    def interpolateM(self, use3DDistance: bool = ...) -> 'QgsLineString'|None: ...
    def measuredLine(self, start: float, end: float) -> 'QgsLineString'|None: ...
    def calculateBoundingBox3D(self) -> QgsBox3D: ...
    @deprecated("""""")
    def calculateBoundingBox3d(self) -> QgsBox3D: ...
    def __delitem__(self, index: int) -> None: ...
    def __setitem__(self, index: int, point: 'QgsPoint') -> None: ...
    def __getitem__(self, index: int) -> 'QgsPoint': ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> 'QgsLineString|None': ...
    def scroll(self, firstVertexIndex: int) -> None: ...
    def convertTo(self, type: Qgis.WkbType) -> bool: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def distanceBetweenVertices(self, fromVertex: 'QgsVertexId', toVertex: 'QgsVertexId') -> float: ...
    def segmentLength(self, startVertex: 'QgsVertexId') -> float: ...
    def vertexAngle(self, vertex: 'QgsVertexId') -> float: ...
    def sumUpArea3D(self) -> float: ...
    def sumUpArea(self) -> float: ...
    def centroid(self) -> 'QgsPoint': ...
    def pointAt(self, node: int, point: 'QgsPoint') -> typing.Tuple[bool, Qgis.VertexType]: ...
    def closestSegment(self, pt: 'QgsPoint', epsilon: float = ...) -> typing.Tuple[float, 'QgsPoint', 'QgsVertexId', int]: ...
    def curveSubstring(self, startDistance: float, endDistance: float) -> 'QgsLineString|None': ...
    def interpolatePoint(self, distance: float) -> 'QgsPoint|None': ...
    def reversed(self) -> 'QgsLineString|None': ...
    def deleteVertex(self, position: 'QgsVertexId') -> bool: ...
    def moveVertex(self, position: 'QgsVertexId', newPos: 'QgsPoint') -> bool: ...
    def insertVertex(self, position: 'QgsVertexId', vertex: 'QgsPoint') -> bool: ...
    def drawAsPolygon(self, p: QtGui.QPainter) -> None: ...
    def addToPainterPath(self, path: QtGui.QPainterPath) -> None: ...
    @typing.overload
    def transform(self, ct: 'QgsCoordinateTransform', d: Qgis.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @typing.overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @typing.overload
    def transform(self, transformer: QgsAbstractGeometryTransformer|None, feedback: QgsFeedback|None = ...) -> bool: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def points(self) -> list['QgsPoint']: ...
    def nCoordinates(self) -> int: ...
    def numPoints(self) -> int: ...
    def curveToLine(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> 'QgsLineString|None': ...
    def endPoint(self) -> 'QgsPoint': ...
    def startPoint(self) -> 'QgsPoint': ...
    def length3D(self) -> float: ...
    def splitToDisjointXYParts(self) -> list['QgsLineString']: ...
    def length(self) -> float: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> int: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def fromWkb(self, wkb: 'QgsConstWkbPtr') -> bool: ...
    def simplifyByDistance(self, tolerance: float) -> 'QgsLineString|None': ...
    def asQPolygonF(self) -> QtGui.QPolygonF: ...
    def collectDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> list['QgsVertexId']: ...
    @typing.overload
    def boundingBoxIntersects(self, rectangle: 'QgsRectangle') -> bool: ...
    @typing.overload
    def boundingBoxIntersects(self, box3d: QgsBox3D) -> bool: ...
    def isClosed2D(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ..., removeRedundantPoints: bool = ...) -> 'QgsLineString|None': ...
    def isValid(self, flags: Qgis.GeometryValidityFlag = ...) -> typing.Tuple[bool, str]: ...
    def indexOf(self, point: 'QgsPoint') -> int: ...
    def isEmpty(self) -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> 'QgsLineString|None': ...
    def dimension(self) -> int: ...
    def geometryType(self) -> str: ...
    def extend(self, startDistance: float, endDistance: float) -> None: ...
    def toCurveType(self) -> QgsCompoundCurve|None: ...
    def close(self) -> None: ...
    def addVertex(self, pt: 'QgsPoint') -> None: ...
    def append(self, line: 'QgsLineString|None') -> None: ...
    def setPoints(self, points: collections.abc.Iterable['QgsPoint']) -> None: ...
    def setMAt(self, index: int, m: float) -> None: ...
    def setZAt(self, index: int, z: float) -> None: ...
    def setYAt(self, index: int, y: float) -> None: ...
    def setXAt(self, index: int, x: float) -> None: ...
    def mAt(self, index: int) -> float: ...
    def zAt(self, index: int) -> float: ...
    def yAt(self, index: int) -> float: ...
    def xAt(self, index: int) -> float: ...
    def pointN(self, i: int) -> 'QgsPoint': ...
    def equals(self, other: QgsCurve) -> bool: ...
    def fuzzyDistanceEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    def fuzzyEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    @staticmethod
    def fromQPolygonF(polygon: QtGui.QPolygonF) -> 'QgsLineString'|None: ...
    @staticmethod
    def fromBezierCurve(start: 'QgsPoint', controlPoint1: 'QgsPoint', controlPoint2: 'QgsPoint', end: 'QgsPoint', segments: int = ...) -> 'QgsLineString'|None: ...


class QgsMultiCurve(QgsGeometryCollection):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMultiCurve') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> 'QgsMultiCurve|None': ...
    def boundary(self) -> QgsAbstractGeometry|None: ...
    def reversed(self) -> 'QgsMultiCurve|None': ...
    def simplifyByDistance(self, tolerance: float) -> 'QgsMultiCurve|None': ...
    def insertGeometry(self, g: QgsAbstractGeometry|None, index: int) -> bool: ...
    def addGeometries(self, geometries: collections.abc.Iterable[QgsAbstractGeometry]) -> bool: ...
    def addGeometry(self, g: QgsAbstractGeometry|None) -> bool: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def toCurveType(self) -> 'QgsMultiCurve|None': ...
    def clear(self) -> None: ...
    def clone(self) -> 'QgsMultiCurve|None': ...
    def geometryType(self) -> str: ...
    def curveN(self, index: int) -> QgsCurve: ...


class QgsMultiLineString(QgsMultiCurve):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, linestrings: collections.abc.Iterable[QgsLineString]) -> None: ...
    @typing.overload
    def __init__(self, linestrings: collections.abc.Iterable[QgsLineString]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMultiLineString') -> None: ...

    def wktOmitChildType(self) -> bool: ...
    def measuredLine(self, start: float, end: float) -> 'QgsMultiLineString|None': ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> 'QgsMultiLineString|None': ...
    def toCurveType(self) -> QgsMultiCurve|None: ...
    def simplifyByDistance(self, tolerance: float) -> 'QgsMultiLineString|None': ...
    def insertGeometry(self, g: QgsAbstractGeometry|None, index: int) -> bool: ...
    def addGeometries(self, geometries: collections.abc.Iterable[QgsAbstractGeometry]) -> bool: ...
    def addGeometry(self, g: QgsAbstractGeometry|None) -> bool: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> 'QgsMultiLineString|None': ...
    def geometryType(self) -> str: ...
    def lineStringN(self, index: int) -> QgsLineString: ...


class QgsMultiPoint(QgsGeometryCollection):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, points: collections.abc.Sequence['QgsPoint'|QgsPointXY|collections.abc.Sequence[float]]) -> None: ...
    @typing.overload
    def __init__(self, x: collections.abc.Iterable[float], y: collections.abc.Iterable[float], z: collections.abc.Iterable[float] = ..., m: collections.abc.Iterable[float] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMultiPoint') -> None: ...

    def wktOmitChildType(self) -> bool: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> 'QgsMultiPoint|None': ...
    def simplifyByDistance(self, tolerance: float) -> 'QgsMultiPoint|None': ...
    def isValid(self, flags: Qgis.GeometryValidityFlag = ...) -> typing.Tuple[bool, str]: ...
    def segmentLength(self, startVertex: 'QgsVertexId') -> float: ...
    def vertexNumberFromVertexId(self, id: 'QgsVertexId') -> int: ...
    def boundary(self) -> QgsAbstractGeometry|None: ...
    def insertGeometry(self, g: QgsAbstractGeometry|None, index: int) -> bool: ...
    def addGeometries(self, geometries: collections.abc.Iterable[QgsAbstractGeometry]) -> bool: ...
    def addGeometry(self, g: QgsAbstractGeometry|None) -> bool: ...
    def nCoordinates(self) -> int: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def clear(self) -> None: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def toCurveType(self) -> 'QgsMultiPoint|None': ...
    def clone(self) -> 'QgsMultiPoint|None': ...
    def geometryType(self) -> str: ...
    def pointN(self, index: int) -> 'QgsPoint': ...


class QgsMultiSurface(QgsGeometryCollection):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMultiSurface') -> None: ...

    def createEmptyWithSameType(self) -> 'QgsMultiSurface|None': ...
    def simplifyByDistance(self, tolerance: float) -> 'QgsMultiSurface|None': ...
    def boundary(self) -> QgsAbstractGeometry|None: ...
    def insertGeometry(self, g: QgsAbstractGeometry|None, index: int) -> bool: ...
    def addGeometries(self, geometries: collections.abc.Iterable[QgsAbstractGeometry]) -> bool: ...
    def addGeometry(self, g: QgsAbstractGeometry|None) -> bool: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def toCurveType(self) -> 'QgsMultiSurface|None': ...
    def clone(self) -> 'QgsMultiSurface|None': ...
    def clear(self) -> None: ...
    def geometryType(self) -> str: ...
    def surfaceN(self, index: int) -> QgsSurface: ...


class QgsMultiPolygon(QgsMultiSurface):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, polygons: collections.abc.Iterable['QgsPolygon']) -> None: ...
    @typing.overload
    def __init__(self, polygons: collections.abc.Iterable['QgsPolygon']) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMultiPolygon') -> None: ...

    def wktOmitChildType(self) -> bool: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> 'QgsMultiPolygon|None': ...
    def boundary(self) -> QgsAbstractGeometry|None: ...
    def toCurveType(self) -> QgsMultiSurface|None: ...
    def simplifyByDistance(self, tolerance: float) -> 'QgsMultiPolygon|None': ...
    def insertGeometry(self, g: QgsAbstractGeometry|None, index: int) -> bool: ...
    def addGeometries(self, geometries: collections.abc.Iterable[QgsAbstractGeometry]) -> bool: ...
    def addGeometry(self, g: QgsAbstractGeometry|None) -> bool: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def clone(self) -> 'QgsMultiPolygon|None': ...
    def clear(self) -> None: ...
    def geometryType(self) -> str: ...
    def polygonN(self, index: int) -> 'QgsPolygon': ...


class QgsNurbsCurve(QgsCurve):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, controlPoints: collections.abc.Iterable['QgsPoint'], degree: int, knots: collections.abc.Iterable[float], weights: collections.abc.Iterable[float]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsNurbsCurve') -> None: ...

    def calculateBoundingBox3D(self) -> QgsBox3D: ...
    def compareToSameClass(self, other: QgsAbstractGeometry|None) -> int: ...
    def clearCache(self) -> None: ...
    def isAnchorVertex(self, localIndex: int) -> bool: ...
    @staticmethod
    def generateKnotsForBezierConversion(nAnchors: int, degree: int = ...) -> list[float]: ...
    @staticmethod
    def generateUniformKnots(numControlPoints: int, degree: int) -> list[float]: ...
    def setWeight(self, index: int, weight: float) -> None: ...
    def weight(self, index: int) -> float: ...
    def setWeights(self, weights: collections.abc.Iterable[float]) -> None: ...
    def weights(self) -> list[float]: ...
    def setKnots(self, knots: collections.abc.Iterable[float]) -> None: ...
    def knots(self) -> list[float]: ...
    def setControlPoints(self, points: collections.abc.Iterable['QgsPoint']) -> None: ...
    def controlPoints(self) -> list['QgsPoint']: ...
    def setDegree(self, degree: int) -> None: ...
    def degree(self) -> int: ...
    def isValid(self, flags: Qgis.GeometryValidityFlag = ...) -> typing.Tuple[bool, str]: ...
    def vertexNumberFromVertexId(self, id: 'QgsVertexId') -> int: ...
    def vertexCount(self, part: int = ..., ring: int = ...) -> int: ...
    def vertexAt(self, id: 'QgsVertexId') -> 'QgsPoint': ...
    def toCurveType(self) -> QgsCurve|None: ...
    def partCount(self) -> int: ...
    def hasCurvedSegments(self) -> bool: ...
    def geometryType(self) -> str: ...
    def fuzzyDistanceEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    def fuzzyEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def fromWkb(self, wkb: 'QgsConstWkbPtr') -> bool: ...
    def deleteVertex(self, position: 'QgsVertexId') -> bool: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def centroid(self) -> 'QgsPoint': ...
    @typing.overload
    def boundingBoxIntersects(self, rectangle: 'QgsRectangle') -> bool: ...
    @typing.overload
    def boundingBoxIntersects(self, box3d: QgsBox3D) -> bool: ...
    def clear(self) -> None: ...
    def isEmpty(self) -> bool: ...
    def dimension(self) -> int: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> int: ...
    def insertVertex(self, position: 'QgsVertexId', vertex: 'QgsPoint') -> bool: ...
    def moveVertex(self, position: 'QgsVertexId', newPos: 'QgsPoint') -> bool: ...
    def boundingBox3D(self) -> QgsBox3D: ...
    def boundingBox(self) -> 'QgsRectangle': ...
    def closestSegment(self, pt: 'QgsPoint', epsilon: float = ...) -> typing.Tuple[float, 'QgsPoint', 'QgsVertexId', int]: ...
    def createEmptyWithSameType(self) -> QgsAbstractGeometry|None: ...
    @typing.overload
    def transform(self, transformer: QgsAbstractGeometryTransformer|None, feedback: QgsFeedback|None = ...) -> bool: ...
    @typing.overload
    def transform(self, ct: 'QgsCoordinateTransform', d: Qgis.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @typing.overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    def swapXy(self) -> None: ...
    def vertexAngle(self, vertex: 'QgsVertexId') -> float: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def simplifyByDistance(self, tolerance: float) -> QgsAbstractGeometry|None: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ..., removeRedundantPoints: bool = ...) -> QgsAbstractGeometry|None: ...
    def distanceBetweenVertices(self, fromVertex: 'QgsVertexId', toVertex: 'QgsVertexId') -> float: ...
    def segmentLength(self, startVertex: 'QgsVertexId') -> float: ...
    def length(self) -> float: ...
    def curveSubstring(self, startDistance: float, endDistance: float) -> QgsCurve|None: ...
    def addToPainterPath(self, path: QtGui.QPainterPath) -> None: ...
    def asQPolygonF(self) -> QtGui.QPolygonF: ...
    def mAt(self, index: int) -> float: ...
    def zAt(self, index: int) -> float: ...
    def yAt(self, index: int) -> float: ...
    def xAt(self, index: int) -> float: ...
    def sumUpArea3D(self) -> float: ...
    def sumUpArea(self) -> float: ...
    def startPoint(self) -> 'QgsPoint': ...
    def scroll(self, firstVertexIndex: int) -> None: ...
    def reversed(self) -> QgsCurve|None: ...
    def points(self) -> list['QgsPoint']: ...
    def pointAt(self, node: int) -> typing.Tuple[bool, 'QgsPoint', Qgis.VertexType]: ...
    def numPoints(self) -> int: ...
    def interpolatePoint(self, distance: float) -> 'QgsPoint|None': ...
    def indexOf(self, point: 'QgsPoint') -> int: ...
    def equals(self, other: QgsCurve) -> bool: ...
    def endPoint(self) -> 'QgsPoint': ...
    def drawAsPolygon(self, p: QtGui.QPainter) -> None: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def curveToLine(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsLineString|None: ...
    def isClosed2D(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def isPolyBezier(self) -> bool: ...
    def isRational(self) -> bool: ...
    def isBSpline(self) -> bool: ...
    def isBezier(self) -> bool: ...
    def evaluate(self, t: float) -> 'QgsPoint': ...
    def clone(self) -> 'QgsNurbsCurve|None': ...


class QgsNurbsUtils(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsNurbsUtils') -> None: ...

    @staticmethod
    def findNurbsCurveForVertex(geom: QgsAbstractGeometry|None, vid: 'QgsVertexId') -> typing.Tuple[QgsNurbsCurve|None, int]: ...
    @staticmethod
    def extractNurbsCurve(geom: QgsAbstractGeometry|None) -> QgsNurbsCurve|None: ...
    @staticmethod
    def containsNurbsCurve(geom: QgsAbstractGeometry|None) -> bool: ...


class QgsOrientedBox3D(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, center: collections.abc.Iterable[float], halfAxes: collections.abc.Iterable[float]) -> None: ...
    @typing.overload
    def __init__(self, center: QgsVector3D, halfAxes: collections.abc.Iterable[QgsVector3D]) -> None: ...
    @typing.overload
    def __init__(self, center: QgsVector3D, halfSizes: QgsVector3D, quaternion: QtGui.QQuaternion) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsOrientedBox3D') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def intersects(self, other: 'QgsOrientedBox3D') -> bool: ...
    def transformed(self, transform: QgsMatrix4x4) -> 'QgsOrientedBox3D': ...
    def reprojectedExtent(self, ct: 'QgsCoordinateTransform') -> QgsBox3D: ...
    def longestSide(self) -> float: ...
    def size(self) -> QgsVector3D: ...
    def corners(self) -> list[QgsVector3D]: ...
    def extent(self) -> QgsBox3D: ...
    def halfAxes(self) -> list[float]: ...
    def center(self) -> QgsVector3D: ...
    def centerZ(self) -> float: ...
    def centerY(self) -> float: ...
    def centerX(self) -> float: ...
    def isNull(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    @staticmethod
    def fromBox3D(box: QgsBox3D) -> 'QgsOrientedBox3D': ...


class QgsPoint(QgsAbstractGeometry):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, x: 'QgsPoint'|QtCore.QPointF|float|None = ..., y: float|None = ..., z: float|None = ..., m: float|None = ..., wkbType: int|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPoint') -> None: ...

    def childPoint(self, index: int) -> 'QgsPoint': ...
    def childCount(self) -> int: ...
    def compareToSameClass(self, other: QgsAbstractGeometry|None) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> 'QgsPoint|None': ...
    def convertTo(self, type: Qgis.WkbType) -> bool: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    @typing.overload
    def boundingBoxIntersects(self, rectangle: 'QgsRectangle') -> bool: ...
    @typing.overload
    def boundingBoxIntersects(self, box3d: QgsBox3D) -> bool: ...
    def segmentLength(self, startVertex: 'QgsVertexId') -> float: ...
    def toCurveType(self) -> 'QgsPoint|None': ...
    def vertexAt(self, a0: 'QgsVertexId') -> 'QgsPoint': ...
    def partCount(self) -> int: ...
    def ringCount(self, a0: int = ...) -> int: ...
    def vertexCount(self, a0: int = ..., a1: int = ...) -> int: ...
    def vertexAngle(self, vertex: 'QgsVertexId') -> float: ...
    def adjacentVertices(self, vertex: 'QgsVertexId') -> typing.Tuple['QgsVertexId', 'QgsVertexId']: ...
    def nextVertex(self, id: 'QgsVertexId') -> typing.Tuple[bool, 'QgsPoint']: ...
    def closestSegment(self, pt: 'QgsPoint', epsilon: float = ...) -> typing.Tuple[float, 'QgsPoint', 'QgsVertexId', int]: ...
    def deleteVertex(self, position: 'QgsVertexId') -> bool: ...
    def moveVertex(self, position: 'QgsVertexId', newPos: 'QgsPoint') -> bool: ...
    def insertVertex(self, position: 'QgsVertexId', vertex: 'QgsPoint') -> bool: ...
    def isValid(self, flags: Qgis.GeometryValidityFlag = ...) -> typing.Tuple[bool, str]: ...
    def boundary(self) -> QgsAbstractGeometry|None: ...
    def vertexNumberFromVertexId(self, id: 'QgsVertexId') -> int: ...
    def nCoordinates(self) -> int: ...
    def coordinateSequence(self) -> typing.Any: ...
    @typing.overload
    def transform(self, ct: 'QgsCoordinateTransform', d: Qgis.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @typing.overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @typing.overload
    def transform(self, transformer: QgsAbstractGeometryTransformer|None, feedback: QgsFeedback|None = ...) -> bool: ...
    def asQPainterPath(self) -> QtGui.QPainterPath: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, a0: QgsAbstractGeometry.WkbFlag = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> int: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def fromWkb(self, wkb: 'QgsConstWkbPtr') -> bool: ...
    def clear(self) -> None: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def simplifyByDistance(self, tolerance: float) -> 'QgsPoint|None': ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ..., removeRedundantPoints: bool = ...) -> 'QgsPoint|None': ...
    def clone(self) -> 'QgsPoint|None': ...
    def dimension(self) -> int: ...
    def geometryType(self) -> str: ...
    def boundingBox3D(self) -> QgsBox3D: ...
    def isEmpty(self) -> bool: ...
    def normalize(self) -> None: ...
    def __add__(self, v: QgsVector) -> 'QgsPoint': ...
    def __isub__(self, v: QgsVector) -> 'QgsPoint': ...
    def __iadd__(self, v: QgsVector) -> 'QgsPoint': ...
    @typing.overload
    def __sub__(self, p: 'QgsPoint') -> QgsVector: ...
    @typing.overload
    def __sub__(self, v: QgsVector) -> 'QgsPoint': ...
    def project(self, distance: float, azimuth: float, inclination: float = ...) -> 'QgsPoint': ...
    def inclination(self, other: 'QgsPoint') -> float: ...
    def azimuth(self, other: 'QgsPoint') -> float: ...
    @typing.overload
    def distanceSquared3D(self, x: float, y: float, z: float) -> float: ...
    @typing.overload
    def distanceSquared3D(self, other: 'QgsPoint') -> float: ...
    @typing.overload
    def distance3D(self, x: float, y: float, z: float) -> float: ...
    @typing.overload
    def distance3D(self, other: 'QgsPoint') -> float: ...
    @typing.overload
    def distanceSquared(self, x: float, y: float) -> float: ...
    @typing.overload
    def distanceSquared(self, other: 'QgsPoint') -> float: ...
    @typing.overload
    def distance(self, x: float, y: float) -> float: ...
    @typing.overload
    def distance(self, other: 'QgsPoint') -> float: ...
    def toQgsVector3D(self) -> QgsVector3D: ...
    def toVector4D(self) -> QtGui.QVector4D: ...
    def toVector3D(self) -> QtGui.QVector3D: ...
    def toQPointF(self) -> QtCore.QPointF: ...
    def setM(self, m: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setX(self, x: float) -> None: ...
    def m(self) -> float: ...
    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def fuzzyDistanceEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    def fuzzyEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...


class QgsPolygon(QgsCurvePolygon):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, exterior: QgsLineString|None, rings: collections.abc.Iterable[QgsLineString] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPolygon') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> 'QgsPolygon|None': ...
    def pointDistanceToBoundary(self, x: float, y: float) -> float: ...
    def boundary(self) -> QgsAbstractGeometry|None: ...
    def setExteriorRing(self, ring: QgsCurve|None) -> None: ...
    def addInteriorRing(self, ring: QgsCurve|None) -> None: ...
    def toCurveType(self) -> QgsCurvePolygon|None: ...
    def surfaceToPolygon(self) -> 'QgsPolygon|None': ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> int: ...
    def fromWkb(self, wkb: 'QgsConstWkbPtr') -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> 'QgsPolygon|None': ...
    def geometryType(self) -> str: ...


class QgsPolyhedralSurface(QgsSurface):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, p: 'QgsPolyhedralSurface') -> None: ...
    @typing.overload
    def __init__(self, multiPolygon: QgsMultiPolygon|None) -> None: ...

    def calculateBoundingBox3D(self) -> QgsBox3D: ...
    def compareToSameClass(self, other: QgsAbstractGeometry|None) -> int: ...
    def childGeometry(self, index: int) -> QgsAbstractGeometry|None: ...
    def childCount(self) -> int: ...
    def __getitem__(self, index: int) -> QgsPolygon: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> 'QgsPolyhedralSurface|None': ...
    def toMultiPolygon(self) -> QgsMultiPolygon|None: ...
    def toCurveType(self) -> QgsMultiSurface|None: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def segmentLength(self, startVertex: 'QgsVertexId') -> float: ...
    def vertexAt(self, id: 'QgsVertexId') -> QgsPoint: ...
    def partCount(self) -> int: ...
    def ringCount(self, part: int = ...) -> int: ...
    def vertexCount(self, part: int = ..., ring: int = ...) -> int: ...
    def vertexAngle(self, vertex: 'QgsVertexId') -> float: ...
    def segmentize(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsAbstractGeometry|None: ...
    def hasCurvedSegments(self) -> bool: ...
    def adjacentVertices(self, vertex: 'QgsVertexId') -> typing.Tuple['QgsVertexId', 'QgsVertexId']: ...
    def nextVertex(self, id: 'QgsVertexId') -> typing.Tuple[bool, QgsPoint]: ...
    def closestSegment(self, pt: QgsPoint, epsilon: float = ...) -> typing.Tuple[float, QgsPoint, 'QgsVertexId', int]: ...
    def isEmpty(self) -> bool: ...
    def vertexNumberFromVertexId(self, id: 'QgsVertexId') -> int: ...
    def nCoordinates(self) -> int: ...
    def coordinateSequence(self) -> typing.Any: ...
    def deleteVertex(self, position: 'QgsVertexId') -> bool: ...
    def moveVertex(self, position: 'QgsVertexId', newPos: QgsPoint) -> bool: ...
    def insertVertex(self, position: 'QgsVertexId', vertex: QgsPoint) -> bool: ...
    @typing.overload
    def transform(self, ct: 'QgsCoordinateTransform', d: Qgis.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @typing.overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @typing.overload
    def transform(self, transformer: QgsAbstractGeometryTransformer|None, feedback: QgsFeedback|None = ...) -> bool: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def asQPainterPath(self) -> QtGui.QPainterPath: ...
    def removePatch(self, ringIndex: int) -> bool: ...
    def addPatch(self, patch: QgsPolygon|None) -> None: ...
    def setPatches(self, patches: collections.abc.Iterable[QgsPolygon]) -> None: ...
    def patchN(self, i: int) -> QgsPolygon: ...
    def numPatches(self) -> int: ...
    def boundingBoxIntersects(self, box3d: QgsBox3D) -> bool: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def simplifyByDistance(self, tolerance: float) -> 'QgsPolyhedralSurface|None': ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ..., removeRedundantPoints: bool = ...) -> 'QgsPolyhedralSurface|None': ...
    def boundary(self) -> QgsAbstractGeometry|None: ...
    def perimeter(self) -> float: ...
    def area3D(self) -> float: ...
    def area(self) -> float: ...
    def normalize(self) -> None: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: QgsAbstractGeometry.WkbFlag = ...) -> int: ...
    def isValid(self, flags: Qgis.GeometryValidityFlag = ...) -> typing.Tuple[bool, str]: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def fromWkb(self, wkb: 'QgsConstWkbPtr') -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> 'QgsPolyhedralSurface|None': ...
    def dimension(self) -> int: ...
    def geometryType(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def fuzzyDistanceEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    def fuzzyEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...


class QgsQuadrilateral(PyQt6.sip.wrapper):

    class Point(enum.IntEnum):
        Point1 = ... # type: QgsQuadrilateral.Point
        Point2 = ... # type: QgsQuadrilateral.Point
        Point3 = ... # type: QgsQuadrilateral.Point
        Point4 = ... # type: QgsQuadrilateral.Point

    class ConstructionOption(enum.IntEnum):
        Distance = ... # type: QgsQuadrilateral.ConstructionOption
        Projected = ... # type: QgsQuadrilateral.ConstructionOption

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, p1: QgsPoint, p2: QgsPoint, p3: QgsPoint, p4: QgsPoint) -> None: ...
    @typing.overload
    def __init__(self, p1: QgsPointXY, p2: QgsPointXY, p3: QgsPointXY, p4: QgsPointXY) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsQuadrilateral') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def perimeter(self) -> float: ...
    def area(self) -> float: ...
    def toString(self, pointPrecision: int = ...) -> str: ...
    def toLineString(self, force2D: bool = ...) -> QgsLineString|None: ...
    def toPolygon(self, force2D: bool = ...) -> QgsPolygon|None: ...
    def points(self) -> list[QgsPoint]: ...
    def setPoints(self, p1: QgsPoint, p2: QgsPoint, p3: QgsPoint, p4: QgsPoint) -> bool: ...
    def setPoint(self, newPoint: QgsPoint, index: 'QgsQuadrilateral.Point') -> bool: ...
    def isValid(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def equals(self, other: 'QgsQuadrilateral', epsilon: float = ...) -> bool: ...
    @staticmethod
    def fromRectangle(rectangle: 'QgsRectangle') -> 'QgsQuadrilateral': ...
    @staticmethod
    def rectangleFromCenterPoint(center: QgsPoint, point: QgsPoint) -> 'QgsQuadrilateral': ...
    @staticmethod
    def squareFromDiagonal(p1: QgsPoint, p2: QgsPoint) -> 'QgsQuadrilateral': ...
    @staticmethod
    def rectangleFromExtent(p1: QgsPoint, p2: QgsPoint) -> 'QgsQuadrilateral': ...
    @staticmethod
    def rectangleFrom3Points(p1: QgsPoint, p2: QgsPoint, p3: QgsPoint, mode: 'QgsQuadrilateral.ConstructionOption') -> 'QgsQuadrilateral': ...


class QgsRectangle(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, xMin: float, yMin: float = ..., xMax: float = ..., yMax: float = ..., normalize: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, p1: QgsPointXY, p2: QgsPointXY, normalize: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, qRectF: QtCore.QRectF) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsRectangle') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def snappedToGrid(self, spacing: float) -> 'QgsRectangle': ...
    def toBox3d(self, zMin: float, zMax: float) -> QgsBox3D: ...
    def invert(self) -> None: ...
    def isFinite(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def asPolygon(self) -> str: ...
    def toString(self, precision: int = ...) -> str: ...
    def toRectF(self) -> QtCore.QRectF: ...
    def asWktPolygon(self) -> str: ...
    def asWktCoordinates(self) -> str: ...
    def isMaximal(self) -> bool: ...
    def isValid(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def __iadd__(self, v: QgsVector) -> 'QgsRectangle': ...
    def __isub__(self, v: QgsVector) -> 'QgsRectangle': ...
    def __add__(self, v: QgsVector) -> 'QgsRectangle': ...
    def __sub__(self, v: QgsVector) -> 'QgsRectangle': ...
    def distance(self, point: QgsPointXY) -> float: ...
    @typing.overload
    def combineExtentWith(self, rect: 'QgsRectangle') -> None: ...
    @typing.overload
    def combineExtentWith(self, x: float, y: float) -> None: ...
    @typing.overload
    def combineExtentWith(self, point: QgsPointXY) -> None: ...
    @typing.overload
    def contains(self, rect: 'QgsRectangle') -> bool: ...
    @typing.overload
    def contains(self, p: QgsPointXY) -> bool: ...
    @typing.overload
    def contains(self, x: float, y: float) -> bool: ...
    def intersects(self, rect: 'QgsRectangle') -> bool: ...
    def intersect(self, rect: 'QgsRectangle') -> 'QgsRectangle': ...
    def buffered(self, width: float) -> 'QgsRectangle': ...
    def include(self, p: QgsPointXY) -> None: ...
    def grow(self, delta: float) -> None: ...
    def scaled(self, scaleFactor: float, center: QgsPointXY|None = ...) -> 'QgsRectangle': ...
    @typing.overload
    def scale(self, scaleFactor: float, c: QgsPointXY|None = ...) -> None: ...
    @typing.overload
    def scale(self, scaleFactor: float, centerX: float, centerY: float) -> None: ...
    def center(self) -> QgsPointXY: ...
    def perimeter(self) -> float: ...
    def area(self) -> float: ...
    def height(self) -> float: ...
    def width(self) -> float: ...
    def normalize(self) -> None: ...
    def yMinimum(self) -> float: ...
    def yMaximum(self) -> float: ...
    def xMinimum(self) -> float: ...
    def xMaximum(self) -> float: ...
    @deprecated("""""")
    def setMinimal(self) -> None: ...
    def setNull(self) -> None: ...
    def setYMaximum(self, y: float) -> None: ...
    def setYMinimum(self, y: float) -> None: ...
    def setXMaximum(self, x: float) -> None: ...
    def setXMinimum(self, x: float) -> None: ...
    @typing.overload
    def set(self, p1: QgsPointXY, p2: QgsPointXY, normalize: bool = ...) -> None: ...
    @typing.overload
    def set(self, xMin: float, yMin: float, xMax: float, yMax: float, normalize: bool = ...) -> None: ...
    @staticmethod
    def fromCenterAndSize(center: QgsPointXY, width: float, height: float) -> 'QgsRectangle': ...
    @staticmethod
    def fromWkt(wkt: str|None) -> 'QgsRectangle': ...


class QgsReferencedGeometryBase(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, crs: 'QgsCoordinateReferenceSystem' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsReferencedGeometryBase') -> None: ...

    def setCrs(self, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    def crs(self) -> 'QgsCoordinateReferenceSystem': ...


class QgsReferencedRectangle(QgsRectangle, QgsReferencedGeometryBase):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, rectangle: QgsRectangle, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsReferencedRectangle') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsReferencedPointXY(QgsPointXY, QgsReferencedGeometryBase):

    @typing.overload
    def __init__(self, point: QgsPointXY, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsReferencedPointXY') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsReferencedGeometry(QgsGeometry, QgsReferencedGeometryBase):

    @typing.overload
    def __init__(self, geometry: QgsGeometry, crs: 'QgsCoordinateReferenceSystem') -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsReferencedGeometry') -> None: ...

    def __repr__(self) -> typing.Any: ...
    @staticmethod
    def fromReferencedRect(rectangle: QgsReferencedRectangle) -> 'QgsReferencedGeometry': ...
    @staticmethod
    def fromReferencedPointXY(point: QgsReferencedPointXY) -> 'QgsReferencedGeometry': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsRegularPolygon(PyQt6.sip.wrapper):

    class ConstructionOption(enum.IntEnum):
        InscribedCircle = ... # type: QgsRegularPolygon.ConstructionOption
        CircumscribedCircle = ... # type: QgsRegularPolygon.ConstructionOption

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, center: QgsPoint, radius: float, azimuth: float, numberSides: int, circle: 'QgsRegularPolygon.ConstructionOption') -> None: ...
    @typing.overload
    def __init__(self, center: QgsPoint, pt1: QgsPoint, numberSides: int, circle: 'QgsRegularPolygon.ConstructionOption') -> None: ...
    @typing.overload
    def __init__(self, pt1: QgsPoint, pt2: QgsPoint, numberSides: int) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRegularPolygon') -> None: ...

    def length(self) -> float: ...
    def perimeter(self) -> float: ...
    def area(self) -> float: ...
    def centralAngle(self) -> float: ...
    def interiorAngle(self) -> float: ...
    def toString(self, pointPrecision: int = ..., radiusPrecision: int = ..., anglePrecision: int = ...) -> str: ...
    def circumscribedCircle(self) -> QgsCircle: ...
    def inscribedCircle(self) -> QgsCircle: ...
    def triangulate(self) -> list['QgsTriangle']: ...
    def toTriangle(self) -> 'QgsTriangle': ...
    def toLineString(self) -> QgsLineString|None: ...
    def toPolygon(self) -> QgsPolygon|None: ...
    def points(self) -> list[QgsPoint]: ...
    def setNumberSides(self, numberSides: int) -> None: ...
    def setFirstVertex(self, firstVertex: QgsPoint) -> None: ...
    def setRadius(self, radius: float) -> None: ...
    def setCenter(self, center: QgsPoint) -> None: ...
    def numberSides(self) -> int: ...
    def apothem(self) -> float: ...
    def firstVertex(self) -> QgsPoint: ...
    def radius(self) -> float: ...
    def center(self) -> QgsPoint: ...
    def isEmpty(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsSphere(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, z: float, radius: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSphere') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def boundingBox(self) -> QgsBox3D: ...
    def toCircle(self) -> QgsCircle: ...
    def surfaceArea(self) -> float: ...
    def volume(self) -> float: ...
    def diameter(self) -> float: ...
    def setRadius(self, radius: float) -> None: ...
    def radius(self) -> float: ...
    @typing.overload
    def setCenter(self, center: QgsPoint) -> None: ...
    @typing.overload
    def setCenter(self, x: float, y: float, z: float) -> None: ...
    def centerZ(self) -> float: ...
    def centerY(self) -> float: ...
    def centerX(self) -> float: ...
    def centerVector(self) -> QgsVector3D: ...
    def center(self) -> QgsPoint: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsTriangle(QgsPolygon):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, p1: QgsPoint, p2: QgsPoint, p3: QgsPoint) -> None: ...
    @typing.overload
    def __init__(self, p1: QgsPointXY, p2: QgsPointXY, p3: QgsPointXY) -> None: ...
    @typing.overload
    def __init__(self, p1: QtCore.QPointF, p2: QtCore.QPointF, p3: QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTriangle') -> None: ...

    def createEmptyWithSameType(self) -> 'QgsTriangle|None': ...
    def inscribedCircle(self) -> QgsCircle: ...
    def inscribedRadius(self) -> float: ...
    def inscribedCenter(self) -> QgsPoint: ...
    def circumscribedCircle(self) -> QgsCircle: ...
    def circumscribedRadius(self) -> float: ...
    def circumscribedCenter(self) -> QgsPoint: ...
    def orthocenter(self, lengthTolerance: float = ...) -> QgsPoint: ...
    def medial(self) -> 'QgsTriangle': ...
    def bisectors(self, lengthTolerance: float = ...) -> list[QgsLineString]: ...
    def medians(self) -> list[QgsLineString]: ...
    def altitudes(self) -> list[QgsLineString]: ...
    def isScalene(self, lengthTolerance: float = ...) -> bool: ...
    def isRight(self, angleTolerance: float = ...) -> bool: ...
    def isEquilateral(self, lengthTolerance: float = ...) -> bool: ...
    def isIsocele(self, lengthTolerance: float = ...) -> bool: ...
    def isDegenerate(self) -> bool: ...
    def angles(self) -> list[float]: ...
    def lengths(self) -> list[float]: ...
    @typing.overload
    def vertexAt(self, id: 'QgsVertexId') -> QgsPoint: ...
    @typing.overload
    def vertexAt(self, atVertex: int) -> QgsPoint: ...
    def boundary(self) -> QgsCurve|None: ...
    def setExteriorRing(self, ring: QgsCurve|None) -> None: ...
    def moveVertex(self, vId: 'QgsVertexId', newPos: QgsPoint) -> bool: ...
    def insertVertex(self, position: 'QgsVertexId', vertex: QgsPoint) -> bool: ...
    def deleteVertex(self, position: 'QgsVertexId') -> bool: ...
    def addInteriorRing(self, ring: QgsCurve|None) -> None: ...
    def toCurveType(self) -> QgsCurvePolygon|None: ...
    def surfaceToPolygon(self) -> QgsPolygon|None: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def fromWkb(self, wkbPtr: 'QgsConstWkbPtr') -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> 'QgsTriangle|None': ...
    def geometryType(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QgsTriangulatedSurface(QgsPolyhedralSurface):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, p: 'QgsTriangulatedSurface') -> None: ...

    def compareToSameClass(self, other: QgsAbstractGeometry|None) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> 'QgsTriangulatedSurface|None': ...
    def triangleN(self, index: int) -> QgsPolygon: ...
    def addTriangle(self, triangle: QgsTriangle|None) -> None: ...
    def addPatch(self, patch: QgsPolygon|None) -> None: ...
    def setTriangles(self, triangles: collections.abc.Iterable[QgsTriangle]) -> None: ...
    def deleteVertex(self, position: 'QgsVertexId') -> bool: ...
    def insertVertex(self, position: 'QgsVertexId', vertex: QgsPoint) -> bool: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ..., removeRedundantPoints: bool = ...) -> 'QgsTriangulatedSurface|None': ...
    def normalize(self) -> None: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str|None = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def fromWkt(self, wkt: str|None) -> bool: ...
    def fromWkb(self, wkb: 'QgsConstWkbPtr') -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> 'QgsTriangulatedSurface|None': ...
    def geometryType(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def fuzzyDistanceEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...
    def fuzzyEqual(self, other: QgsAbstractGeometry, epsilon: float = ...) -> bool: ...


class QgsVertexId(PyQt6.sip.wrapper):

    part = ... # type: int
    ring = ... # type: int
    type = ... # type: Qgis.VertexType
    vertex = ... # type: int

    @typing.overload
    def __init__(self, _part: int = ..., _ring: int = ..., _vertex: int = ..., _type: Qgis.VertexType = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVertexId') -> None: ...

    def __repr__(self) -> typing.Any: ...
    def vertexEqual(self, o: 'QgsVertexId') -> bool: ...
    def ringEqual(self, o: 'QgsVertexId') -> bool: ...
    def partEqual(self, o: 'QgsVertexId') -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    @typing.overload
    def isValid(self) -> bool: ...
    @typing.overload
    def isValid(self, geom: QgsAbstractGeometry|None) -> bool: ...


class QgsWkbPtr(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, p: PyQt6.sip.array[bytes]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsWkbPtr') -> None: ...


class QgsConstWkbPtr(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, p: PyQt6.sip.array[bytes]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsConstWkbPtr') -> None: ...


class QgsWkbTypes(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsWkbTypes') -> None: ...

    @staticmethod
    def to25D(type: Qgis.WkbType) -> Qgis.WkbType: ...
    @staticmethod
    def dropM(type: Qgis.WkbType) -> Qgis.WkbType: ...
    @staticmethod
    def dropZ(type: Qgis.WkbType) -> Qgis.WkbType: ...
    @staticmethod
    def addM(type: Qgis.WkbType) -> Qgis.WkbType: ...
    @staticmethod
    def addZ(type: Qgis.WkbType) -> Qgis.WkbType: ...
    @staticmethod
    def hasM(type: Qgis.WkbType) -> bool: ...
    @staticmethod
    def hasZ(type: Qgis.WkbType) -> bool: ...
    @staticmethod
    def geometryDisplayString(type: Qgis.GeometryType) -> str: ...
    @staticmethod
    def translatedDisplayString(type: Qgis.WkbType) -> str: ...
    @staticmethod
    def displayString(type: Qgis.WkbType) -> str: ...
    @staticmethod
    def geometryType(type: Qgis.WkbType) -> Qgis.GeometryType: ...
    @staticmethod
    def coordDimensions(type: Qgis.WkbType) -> int: ...
    @staticmethod
    def wkbDimensions(type: Qgis.WkbType) -> int: ...
    @staticmethod
    def isNurbsType(type: Qgis.WkbType) -> bool: ...
    @staticmethod
    def isCurvedType(type: Qgis.WkbType) -> bool: ...
    @staticmethod
    def isMultiType(type: Qgis.WkbType) -> bool: ...
    @staticmethod
    def isSingleType(type: Qgis.WkbType) -> bool: ...
    @staticmethod
    def parseType(wktStr: str|None) -> Qgis.WkbType: ...
    @staticmethod
    def zmType(type: Qgis.WkbType, hasZ: bool, hasM: bool) -> Qgis.WkbType: ...
    @staticmethod
    def flatType(type: Qgis.WkbType) -> Qgis.WkbType: ...
    @staticmethod
    def linearType(type: Qgis.WkbType) -> Qgis.WkbType: ...
    @staticmethod
    def curveType(type: Qgis.WkbType) -> Qgis.WkbType: ...
    @staticmethod
    def promoteNonPointTypesToMulti(type: Qgis.WkbType) -> Qgis.WkbType: ...
    @staticmethod
    def multiType(type: Qgis.WkbType) -> Qgis.WkbType: ...
    @staticmethod
    def singleType(type: Qgis.WkbType) -> Qgis.WkbType: ...


class QgsRay3D(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, origin: QtGui.QVector3D, direction: QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRay3D') -> None: ...

    def point(self, distance: float) -> QtGui.QVector3D: ...
    def angleToPoint(self, point: QtGui.QVector3D) -> float: ...
    def isInFront(self, point: QtGui.QVector3D) -> bool: ...
    def projectedDistance(self, point: QtGui.QVector3D) -> float: ...
    def projectedPoint(self, point: QtGui.QVector3D) -> QtGui.QVector3D: ...
    def setDirection(self, direction: QtGui.QVector3D) -> None: ...
    def setOrigin(self, origin: QtGui.QVector3D) -> None: ...
    def directionInversed(self) -> QtGui.QVector3D: ...
    def direction(self) -> QtGui.QVector3D: ...
    def origin(self) -> QtGui.QVector3D: ...


class QgsAbstractBabelFormat(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, name: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractBabelFormat') -> None: ...

    @staticmethod
    def featureTypeToArgument(type: Qgis.GpsFeatureType) -> str: ...
    def exportCommand(self, babel: str|None, featureType: Qgis.GpsFeatureType, input: str|None, output: str|None, flags: Qgis.BabelCommandFlag = ...) -> list[str]: ...
    def importCommand(self, babel: str|None, featureType: Qgis.GpsFeatureType, input: str|None, output: str|None, flags: Qgis.BabelCommandFlag = ...) -> list[str]: ...
    def capabilities(self) -> Qgis.BabelFormatCapability: ...
    def name(self) -> str: ...


class QgsBabelSimpleImportFormat(QgsAbstractBabelFormat):

    @typing.overload
    def __init__(self, format: str|None, description: str|None, capabilities: Qgis.BabelFormatCapability, extensions: collections.abc.Iterable[str|None] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsBabelSimpleImportFormat') -> None: ...

    def importCommand(self, babel: str|None, featureType: Qgis.GpsFeatureType, input: str|None, output: str|None, flags: Qgis.BabelCommandFlag = ...) -> list[str]: ...
    def extensions(self) -> list[str]: ...
    def description(self) -> str: ...


class QgsBabelFormatRegistry(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def reloadFromSettings(self) -> None: ...
    def devices(self) -> typing.Any: ...
    def deviceFormat(self, name: str|None) -> 'QgsBabelGpsDeviceFormat|None': ...
    def deviceNames(self) -> list[str]: ...
    def importFileFilter(self) -> str: ...
    def importFormatByDescription(self, description: str|None) -> QgsBabelSimpleImportFormat|None: ...
    def importFormat(self, name: str|None) -> QgsBabelSimpleImportFormat|None: ...
    def importFormatNames(self) -> list[str]: ...


class QgsBabelGpsDeviceFormat(QgsAbstractBabelFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, waypointDownloadCommand: str|None, waypointUploadCommand: str|None, routeDownloadCommand: str|None, routeUploadCommand: str|None, trackDownloadCommand: str|None, trackUploadCommand: str|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsBabelGpsDeviceFormat') -> None: ...

    def exportCommand(self, babel: str|None, type: Qgis.GpsFeatureType, in_: str|None, out: str|None, flags: Qgis.BabelCommandFlag = ...) -> list[str]: ...
    def importCommand(self, babel: str|None, type: Qgis.GpsFeatureType, in_: str|None, out: str|None, flags: Qgis.BabelCommandFlag = ...) -> list[str]: ...


class QgsNmeaConnection(QgsGpsConnection):

    def __init__(self, device: QtCore.QIODevice|None) -> None: ...

    def processHchdgSentence(self, data: str, len: int) -> None: ...
    def processHdtSentence(self, data: str, len: int) -> None: ...
    def processGstSentence(self, data: str, len: int) -> None: ...
    def processGsaSentence(self, data: str, len: int) -> None: ...
    def processVtgSentence(self, data: str, len: int) -> None: ...
    def processGsvSentence(self, data: str, len: int) -> None: ...
    def processRmcSentence(self, data: str, len: int) -> None: ...
    def processGgaSentence(self, data: str, len: int) -> None: ...
    def processStringBuffer(self) -> None: ...
    def parseData(self) -> None: ...


class QgsGpsdConnection(QgsNmeaConnection):

    def __init__(self, host: str|None, port: int, device: str|None) -> None: ...


class QgsGpsDetector(QtCore.QObject):

    def __init__(self, portName: str|None = ..., useUnsafeSignals: bool = ...) -> None: ...

    detectionFailed: typing.ClassVar[QtCore.pyqtSignal]
    connectionDetected: typing.ClassVar[QtCore.pyqtSignal]
    def connDestroyed(self, a0: QtCore.QObject|None) -> None: ...
    detected: typing.ClassVar[QtCore.pyqtSignal]
    def advance(self) -> None: ...
    @staticmethod
    def availablePorts() -> list[tuple[str, str]]: ...
    def takeConnection(self) -> QgsGpsConnection|None: ...


class QgsGpsInformation(PyQt6.sip.wrapper):

    direction = ... # type: float
    elevation = ... # type: float
    elevation_diff = ... # type: float
    fixMode = ... # type: QtCore.QChar
    fixType = ... # type: int
    hacc = ... # type: float
    hdop = ... # type: float
    hvacc = ... # type: float
    latitude = ... # type: float
    longitude = ... # type: float
    pdop = ... # type: float
    quality = ... # type: int
    qualityIndicator = ... # type: Qgis.GpsQualityIndicator
    satInfoComplete = ... # type: bool
    satPrn = ... # type: collections.abc.Iterable[int]
    satellitesInView = ... # type: collections.abc.Iterable['QgsSatelliteInfo']
    satellitesUsed = ... # type: int
    speed = ... # type: float
    status = ... # type: QtCore.QChar
    utcDateTime = ... # type: QtCore.QDateTime|datetime.datetime
    utcTime = ... # type: QtCore.QTime|datetime.time
    vacc = ... # type: float
    vdop = ... # type: float

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGpsInformation') -> None: ...

    def componentValue(self, component: Qgis.GpsInformationComponent) -> typing.Any: ...
    def qualityDescription(self) -> str: ...
    @deprecated("""""")
    def fixStatus(self) -> Qgis.GpsFixStatus: ...
    def isValid(self) -> bool: ...
    def setNavigationStatus(self, status: Qgis.GpsNavigationStatus) -> None: ...
    def navigationStatus(self) -> Qgis.GpsNavigationStatus: ...
    def bestFixStatus(self) -> typing.Tuple[Qgis.GpsFixStatus, Qgis.GnssConstellation]: ...
    def constellationFixStatus(self) -> dict[Qgis.GnssConstellation, Qgis.GpsFixStatus]: ...


class QgsGpsLogger(QtCore.QObject):

    def __init__(self, connection: QgsGpsConnection|None, parent: QtCore.QObject|None = ...) -> None: ...

    def addTrackVertex(self) -> None: ...
    distanceAreaChanged: typing.ClassVar[QtCore.pyqtSignal]
    stateChanged: typing.ClassVar[QtCore.pyqtSignal]
    trackVertexAdded: typing.ClassVar[QtCore.pyqtSignal]
    trackReset: typing.ClassVar[QtCore.pyqtSignal]
    trackIsEmptyChanged: typing.ClassVar[QtCore.pyqtSignal]
    def componentValue(self, component: Qgis.GpsInformationComponent) -> typing.Any: ...
    def trackDistanceFromStart(self) -> float: ...
    def totalTrackLength(self) -> float: ...
    def updateGpsSettings(self) -> None: ...
    def setAutomaticallyAddTrackVertices(self, enabled: bool) -> None: ...
    def automaticallyAddTrackVertices(self) -> bool: ...
    def resetTrack(self) -> None: ...
    def lastMValue(self) -> float: ...
    def lastElevation(self) -> float: ...
    def trackStartTime(self) -> QtCore.QDateTime: ...
    def lastTimestamp(self) -> QtCore.QDateTime: ...
    def lastPosition(self) -> QgsPointXY: ...
    def currentGeometry(self, type: Qgis.WkbType) -> typing.Tuple[QgsGeometry, str]: ...
    def currentTrack(self) -> list[QgsPoint]: ...
    def distanceArea(self) -> QgsDistanceArea: ...
    def transformContext(self) -> 'QgsCoordinateTransformContext': ...
    def setTransformContext(self, context: 'QgsCoordinateTransformContext') -> None: ...
    def setEllipsoid(self, ellipsoid: str|None) -> None: ...
    def setConnection(self, connection: QgsGpsConnection|None) -> None: ...
    def connection(self) -> QgsGpsConnection|None: ...


class QgsGpsConnectionRegistry(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def connectionList(self) -> list[QgsGpsConnection]: ...
    def unregisterConnection(self, c: QgsGpsConnection|None) -> None: ...
    def registerConnection(self, c: QgsGpsConnection|None) -> None: ...


class QgsSatelliteInfo(PyQt6.sip.wrapper):

    azimuth = ... # type: float
    elevation = ... # type: float
    id = ... # type: int
    inUse = ... # type: bool
    satType = ... # type: QtCore.QChar
    signal = ... # type: int

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSatelliteInfo') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def constellation(self) -> Qgis.GnssConstellation: ...


class QgsVectorLayerGpsLogger(QgsGpsLogger):

    def __init__(self, connection: QgsGpsConnection|None, parent: QtCore.QObject|None = ...) -> None: ...

    def endCurrentTrack(self) -> None: ...
    def setTransformContext(self, context: 'QgsCoordinateTransformContext') -> None: ...
    def destinationField(self, component: Qgis.GpsInformationComponent) -> str: ...
    def setDestinationField(self, component: Qgis.GpsInformationComponent, field: str|None) -> None: ...
    def tracksLayer(self) -> QgsVectorLayer|None: ...
    def pointsLayer(self) -> QgsVectorLayer|None: ...
    def setTracksLayer(self, layer: QgsVectorLayer|None) -> None: ...
    def setPointsLayer(self, layer: QgsVectorLayer|None) -> None: ...
    def setWriteToEditBuffer(self, buffer: bool) -> None: ...
    def writeToEditBuffer(self) -> bool: ...


class QgsCalloutPosition(PyQt6.sip.wrapper):

    featureId = ... # type: int
    layerID = ... # type: str|None
    providerID = ... # type: str|None

    @typing.overload
    def __init__(self, id: int, layer: str|None, providerId: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsCalloutPosition') -> None: ...

    def setDestinationIsPinned(self, pinned: bool) -> None: ...
    def destinationIsPinned(self) -> bool: ...
    def setOriginIsPinned(self, pinned: bool) -> None: ...
    def originIsPinned(self) -> bool: ...
    def setDestination(self, destination: QtCore.QPointF) -> None: ...
    def destination(self) -> QtCore.QPointF: ...
    def setOrigin(self, origin: QtCore.QPointF) -> None: ...
    def origin(self) -> QtCore.QPointF: ...


class QgsLabeling(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLabeling') -> None: ...


class QgsLabelCandidate(PyQt6.sip.wrapper):

    cost = ... # type: float
    rect = ... # type: QtCore.QRectF

    @typing.overload
    def __init__(self, r: QtCore.QRectF, c: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLabelCandidate') -> None: ...


class QgsLabelingEngineSettings(PyQt6.sip.wrapper):

    class Search(enum.IntEnum):
        Chain = ... # type: QgsLabelingEngineSettings.Search
        Popmusic_Tabu = ... # type: QgsLabelingEngineSettings.Search
        Popmusic_Chain = ... # type: QgsLabelingEngineSettings.Search
        Popmusic_Tabu_Chain = ... # type: QgsLabelingEngineSettings.Search
        Falp = ... # type: QgsLabelingEngineSettings.Search

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsLabelingEngineSettings') -> None: ...

    def setRules(self, rules: collections.abc.Iterable['QgsAbstractLabelingEngineRule']) -> None: ...
    def addRule(self, rule: 'QgsAbstractLabelingEngineRule|None') -> None: ...
    def rules(self) -> list['QgsAbstractLabelingEngineRule']: ...
    def setPlacementVersion(self, version: Qgis.LabelPlacementEngineVersion) -> None: ...
    def placementVersion(self) -> Qgis.LabelPlacementEngineVersion: ...
    def setUnplacedLabelColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def unplacedLabelColor(self) -> QtGui.QColor: ...
    def setDefaultTextRenderFormat(self, format: Qgis.TextRenderFormat) -> None: ...
    def defaultTextRenderFormat(self) -> Qgis.TextRenderFormat: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeSettingsToProject(self, project: 'QgsProject|None') -> None: ...
    def readSettingsFromProject(self, project: 'QgsProject|None') -> None: ...
    @deprecated("""""")
    def searchMethod(self) -> 'QgsLabelingEngineSettings.Search': ...
    @deprecated("""""")
    def setSearchMethod(self, s: 'QgsLabelingEngineSettings.Search') -> None: ...
    @deprecated("""""")
    def setNumCandidatePositions(self, candPoint: int, candLine: int, candPolygon: int) -> None: ...
    @deprecated("""""")
    def numCandidatePositions(self) -> typing.Tuple[int, int, int]: ...
    def setMaximumPolygonCandidatesPerCmSquared(self, candidates: float) -> None: ...
    def maximumPolygonCandidatesPerCmSquared(self) -> float: ...
    def setMaximumLineCandidatesPerCm(self, candidates: float) -> None: ...
    def maximumLineCandidatesPerCm(self) -> float: ...
    def setFlag(self, f: Qgis.LabelingFlag, enabled: bool = ...) -> None: ...
    def testFlag(self, f: Qgis.LabelingFlag) -> bool: ...
    def flags(self) -> Qgis.LabelingFlag: ...
    def setFlags(self, flags: Qgis.LabelingFlag) -> None: ...
    def clear(self) -> None: ...


class QgsLabelingResults(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def setMapSettings(self, settings: QgsMapSettings) -> None: ...
    def calloutsWithinRectangle(self, rectangle: QgsRectangle) -> list[QgsCalloutPosition]: ...
    def groupedLabelPositions(self, groupId: int) -> list['QgsLabelPosition']: ...
    def labelsWithinRect(self, r: QgsRectangle) -> list['QgsLabelPosition']: ...
    def labelsAtPosition(self, p: QgsPointXY) -> list['QgsLabelPosition']: ...
    def allLabels(self) -> list['QgsLabelPosition']: ...


class QgsLabelLineSettings(PyQt6.sip.wrapper):

    class AnchorTextPoint(enum.IntEnum):
        StartOfText = ... # type: QgsLabelLineSettings.AnchorTextPoint
        CenterOfText = ... # type: QgsLabelLineSettings.AnchorTextPoint
        EndOfText = ... # type: QgsLabelLineSettings.AnchorTextPoint
        FollowPlacement = ... # type: QgsLabelLineSettings.AnchorTextPoint

    class AnchorClipping(enum.IntEnum):
        UseVisiblePartsOfLine = ... # type: QgsLabelLineSettings.AnchorClipping
        UseEntireLine = ... # type: QgsLabelLineSettings.AnchorClipping

    class AnchorType(enum.IntEnum):
        HintOnly = ... # type: QgsLabelLineSettings.AnchorType
        Strict = ... # type: QgsLabelLineSettings.AnchorType

    class DirectionSymbolPlacement(enum.IntEnum):
        SymbolLeftRight = ... # type: QgsLabelLineSettings.DirectionSymbolPlacement
        SymbolAbove = ... # type: QgsLabelLineSettings.DirectionSymbolPlacement
        SymbolBelow = ... # type: QgsLabelLineSettings.DirectionSymbolPlacement

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLabelLineSettings') -> None: ...

    def setCurvedLabelMode(self, mode: Qgis.CurvedLabelMode) -> None: ...
    def curvedLabelMode(self) -> Qgis.CurvedLabelMode: ...
    def setAnchorTextPoint(self, point: 'QgsLabelLineSettings.AnchorTextPoint') -> None: ...
    def anchorTextPoint(self) -> 'QgsLabelLineSettings.AnchorTextPoint': ...
    def setAnchorClipping(self, clipping: 'QgsLabelLineSettings.AnchorClipping') -> None: ...
    def anchorClipping(self) -> 'QgsLabelLineSettings.AnchorClipping': ...
    def setAnchorType(self, type: 'QgsLabelLineSettings.AnchorType') -> None: ...
    def anchorType(self) -> 'QgsLabelLineSettings.AnchorType': ...
    def setLineAnchorPercent(self, percent: float) -> None: ...
    def lineAnchorPercent(self) -> float: ...
    def setOverrunDistanceMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def overrunDistanceMapUnitScale(self) -> QgsMapUnitScale: ...
    def setOverrunDistanceUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def overrunDistanceUnit(self) -> Qgis.RenderUnit: ...
    def setOverrunDistance(self, distance: float) -> None: ...
    def overrunDistance(self) -> float: ...
    def setDirectionSymbolPlacement(self, placement: 'QgsLabelLineSettings.DirectionSymbolPlacement') -> None: ...
    def directionSymbolPlacement(self) -> 'QgsLabelLineSettings.DirectionSymbolPlacement': ...
    def setReverseDirectionSymbol(self, reversed: bool) -> None: ...
    def reverseDirectionSymbol(self) -> bool: ...
    def setRightDirectionSymbol(self, symbol: str|None) -> None: ...
    def rightDirectionSymbol(self) -> str: ...
    def setLeftDirectionSymbol(self, symbol: str|None) -> None: ...
    def leftDirectionSymbol(self) -> str: ...
    def setAddDirectionSymbol(self, enabled: bool) -> None: ...
    def addDirectionSymbol(self) -> bool: ...
    def updateDataDefinedProperties(self, properties: QgsPropertyCollection, context: QgsExpressionContext) -> None: ...
    def setMergeLines(self, merge: bool) -> None: ...
    def mergeLines(self) -> bool: ...
    def setPlacementFlags(self, flags: Qgis.LabelLinePlacementFlag) -> None: ...
    def placementFlags(self) -> Qgis.LabelLinePlacementFlag: ...


class QgsLabelObstacleSettings(PyQt6.sip.wrapper):

    class ObstacleType(enum.IntEnum):
        PolygonInterior = ... # type: QgsLabelObstacleSettings.ObstacleType
        PolygonBoundary = ... # type: QgsLabelObstacleSettings.ObstacleType
        PolygonWhole = ... # type: QgsLabelObstacleSettings.ObstacleType

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLabelObstacleSettings') -> None: ...

    def updateDataDefinedProperties(self, properties: QgsPropertyCollection, context: QgsExpressionContext) -> None: ...
    def obstacleGeometry(self) -> QgsGeometry: ...
    def setObstacleGeometry(self, obstacleGeom: QgsGeometry) -> None: ...
    def setType(self, type: 'QgsLabelObstacleSettings.ObstacleType') -> None: ...
    def type(self) -> 'QgsLabelObstacleSettings.ObstacleType': ...
    def setFactor(self, factor: float) -> None: ...
    def factor(self) -> float: ...
    def setIsObstacle(self, isObstacle: bool) -> None: ...
    def isObstacle(self) -> bool: ...


class QgsLabelPlacementSettings(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLabelPlacementSettings') -> None: ...

    def updateDataDefinedProperties(self, properties: QgsPropertyCollection, context: QgsExpressionContext) -> None: ...
    def setWhitespaceCollisionHandling(self, handling: Qgis.LabelWhitespaceCollisionHandling) -> None: ...
    def whitespaceCollisionHandling(self) -> Qgis.LabelWhitespaceCollisionHandling: ...
    def setMultiPartBehavior(self, behavior: Qgis.MultiPartLabelingBehavior) -> None: ...
    def multiPartBehavior(self) -> Qgis.MultiPartLabelingBehavior: ...
    def setPrioritization(self, prioritization: Qgis.LabelPrioritization) -> None: ...
    def prioritization(self) -> Qgis.LabelPrioritization: ...
    def setAllowDegradedPlacement(self, allow: bool) -> None: ...
    def allowDegradedPlacement(self) -> bool: ...
    def setOverlapHandling(self, handling: Qgis.LabelOverlapHandling) -> None: ...
    def overlapHandling(self) -> Qgis.LabelOverlapHandling: ...


class QgsLabelPointSettings(PyQt6.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLabelPointSettings') -> None: ...

    def setMaximumDistanceMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def maximumDistanceMapUnitScale(self) -> QgsMapUnitScale: ...
    def setMaximumDistanceUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def maximumDistanceUnit(self) -> Qgis.RenderUnit: ...
    def setMaximumDistance(self, distance: float) -> None: ...
    def maximumDistance(self) -> float: ...
    def setPredefinedPositionOrder(self, order: collections.abc.Iterable[Qgis.LabelPredefinedPointPosition]) -> None: ...
    def predefinedPositionOrder(self) -> list[Qgis.LabelPredefinedPointPosition]: ...
    def setQuadrant(self, quadrant: Qgis.LabelQuadrantPosition) -> None: ...
    def quadrant(self) -> Qgis.LabelQuadrantPosition: ...
    def updateDataDefinedProperties(self, properties: QgsPropertyCollection, context: QgsExpressionContext) -> None: ...


class QgsLabelPosition(PyQt6.sip.wrapper):

    cornerPoints = ... # type: collections.abc.Iterable[QgsPointXY]
    featureId = ... # type: int
    groupedLabelId = ... # type: int
    height = ... # type: float
    isDiagram = ... # type: bool
    isPinned = ... # type: bool
    isUnplaced = ... # type: bool
    labelFont = ... # type: QtGui.QFont
    labelGeometry = ... # type: QgsGeometry
    labelRect = ... # type: QgsRectangle
    labelText = ... # type: str|None
    layerID = ... # type: str|None
    providerID = ... # type: str|None
    rotation = ... # type: float
    upsideDown = ... # type: bool
    width = ... # type: float

    @typing.overload
    def __init__(self, id: int, r: float, corners: collections.abc.Iterable[QgsPointXY], rect: QgsRectangle, w: float, h: float, layer: str|None, labeltext: str|None, labelfont: QtGui.QFont, upside_down: bool, diagram: bool = ..., pinned: bool = ..., providerId: str|None = ..., labelGeometry: QgsGeometry = ..., isUnplaced: bool = ...) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLabelPosition') -> None: ...

    def __repr__(self) -> typing.Any: ...


class QgsLabelSearchTree(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def setMapSettings(self, settings: QgsMapSettings) -> None: ...
    def calloutsInRectangle(self, rectangle: QgsRectangle) -> list[QgsCalloutPosition]: ...
    def allLabels(self) -> list[QgsLabelPosition]: ...
    @deprecated("""""")
    def clear(self) -> None: ...


class QgsLabelThinningSettings(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsLabelThinningSettings') -> None: ...

    def updateDataDefinedProperties(self, properties: QgsPropertyCollection, context: QgsExpressionContext) -> None: ...
    def setAllowDuplicateRemoval(self, allow: bool) -> None: ...
    def allowDuplicateRemoval(self) -> bool: ...
    def minimumDistanceToDuplicateMapUnitScale(self) -> QgsMapUnitScale: ...
    def setMinimumDistanceToDuplicateMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def minimumDistanceToDuplicateUnit(self) -> Qgis.RenderUnit: ...
    def setMinimumDistanceToDuplicateUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setMinimumDistanceToDuplicate(self, distance: float) -> None: ...
    def minimumDistanceToDuplicate(self) -> float: ...
    def labelMarginDistanceMapUnitScale(self) -> QgsMapUnitScale: ...
    def setLabelMarginDistanceMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def labelMarginDistanceUnit(self) -> Qgis.RenderUnit: ...
    def setLabelMarginDistanceUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def setLabelMarginDistance(self, distance: float) -> None: ...
    def labelMarginDistance(self) -> float: ...
    def setMinimumFeatureSize(self, size: float) -> None: ...
    def minimumFeatureSize(self) -> float: ...
    def setMaximumNumberLabels(self, number: int) -> None: ...
    def maximumNumberLabels(self) -> int: ...
    def setLimitNumberLabelsEnabled(self, enabled: bool) -> None: ...
    def limitNumberOfLabelsEnabled(self) -> bool: ...


class QgsPalLayerSettings(PyQt6.sip.wrapper):

    class Property(enum.IntEnum):
        Size = ... # type: QgsPalLayerSettings.Property
        Bold = ... # type: QgsPalLayerSettings.Property
        Italic = ... # type: QgsPalLayerSettings.Property
        Underline = ... # type: QgsPalLayerSettings.Property
        Color = ... # type: QgsPalLayerSettings.Property
        Strikeout = ... # type: QgsPalLayerSettings.Property
        Family = ... # type: QgsPalLayerSettings.Property
        FontStyle = ... # type: QgsPalLayerSettings.Property
        FontSizeUnit = ... # type: QgsPalLayerSettings.Property
        FontTransp = ... # type: QgsPalLayerSettings.Property
        FontOpacity = ... # type: QgsPalLayerSettings.Property
        FontCase = ... # type: QgsPalLayerSettings.Property
        FontLetterSpacing = ... # type: QgsPalLayerSettings.Property
        FontWordSpacing = ... # type: QgsPalLayerSettings.Property
        FontBlendMode = ... # type: QgsPalLayerSettings.Property
        FontStretchFactor = ... # type: QgsPalLayerSettings.Property
        MultiLineWrapChar = ... # type: QgsPalLayerSettings.Property
        AutoWrapLength = ... # type: QgsPalLayerSettings.Property
        MultiLineHeight = ... # type: QgsPalLayerSettings.Property
        MultiLineAlignment = ... # type: QgsPalLayerSettings.Property
        TextOrientation = ... # type: QgsPalLayerSettings.Property
        TabStopDistance = ... # type: QgsPalLayerSettings.Property
        DirSymbDraw = ... # type: QgsPalLayerSettings.Property
        DirSymbLeft = ... # type: QgsPalLayerSettings.Property
        DirSymbRight = ... # type: QgsPalLayerSettings.Property
        DirSymbPlacement = ... # type: QgsPalLayerSettings.Property
        DirSymbReverse = ... # type: QgsPalLayerSettings.Property
        NumFormat = ... # type: QgsPalLayerSettings.Property
        NumDecimals = ... # type: QgsPalLayerSettings.Property
        NumPlusSign = ... # type: QgsPalLayerSettings.Property
        BufferDraw = ... # type: QgsPalLayerSettings.Property
        BufferSize = ... # type: QgsPalLayerSettings.Property
        BufferUnit = ... # type: QgsPalLayerSettings.Property
        BufferColor = ... # type: QgsPalLayerSettings.Property
        BufferTransp = ... # type: QgsPalLayerSettings.Property
        BufferOpacity = ... # type: QgsPalLayerSettings.Property
        BufferJoinStyle = ... # type: QgsPalLayerSettings.Property
        BufferBlendMode = ... # type: QgsPalLayerSettings.Property
        MaskEnabled = ... # type: QgsPalLayerSettings.Property
        MaskBufferSize = ... # type: QgsPalLayerSettings.Property
        MaskBufferUnit = ... # type: QgsPalLayerSettings.Property
        MaskOpacity = ... # type: QgsPalLayerSettings.Property
        MaskJoinStyle = ... # type: QgsPalLayerSettings.Property
        ShapeDraw = ... # type: QgsPalLayerSettings.Property
        ShapeKind = ... # type: QgsPalLayerSettings.Property
        ShapeSVGFile = ... # type: QgsPalLayerSettings.Property
        ShapeSizeType = ... # type: QgsPalLayerSettings.Property
        ShapeSizeX = ... # type: QgsPalLayerSettings.Property
        ShapeSizeY = ... # type: QgsPalLayerSettings.Property
        ShapeSizeUnits = ... # type: QgsPalLayerSettings.Property
        ShapeRotationType = ... # type: QgsPalLayerSettings.Property
        ShapeRotation = ... # type: QgsPalLayerSettings.Property
        ShapeOffset = ... # type: QgsPalLayerSettings.Property
        ShapeOffsetUnits = ... # type: QgsPalLayerSettings.Property
        ShapeRadii = ... # type: QgsPalLayerSettings.Property
        ShapeRadiiUnits = ... # type: QgsPalLayerSettings.Property
        ShapeTransparency = ... # type: QgsPalLayerSettings.Property
        ShapeOpacity = ... # type: QgsPalLayerSettings.Property
        ShapeBlendMode = ... # type: QgsPalLayerSettings.Property
        ShapeFillColor = ... # type: QgsPalLayerSettings.Property
        ShapeStrokeColor = ... # type: QgsPalLayerSettings.Property
        ShapeStrokeWidth = ... # type: QgsPalLayerSettings.Property
        ShapeStrokeWidthUnits = ... # type: QgsPalLayerSettings.Property
        ShapeJoinStyle = ... # type: QgsPalLayerSettings.Property
        ShadowDraw = ... # type: QgsPalLayerSettings.Property
        ShadowUnder = ... # type: QgsPalLayerSettings.Property
        ShadowOffsetAngle = ... # type: QgsPalLayerSettings.Property
        ShadowOffsetDist = ... # type: QgsPalLayerSettings.Property
        ShadowOffsetUnits = ... # type: QgsPalLayerSettings.Property
        ShadowRadius = ... # type: QgsPalLayerSettings.Property
        ShadowRadiusUnits = ... # type: QgsPalLayerSettings.Property
        ShadowTransparency = ... # type: QgsPalLayerSettings.Property
        ShadowOpacity = ... # type: QgsPalLayerSettings.Property
        ShadowScale = ... # type: QgsPalLayerSettings.Property
        ShadowColor = ... # type: QgsPalLayerSettings.Property
        ShadowBlendMode = ... # type: QgsPalLayerSettings.Property
        CentroidWhole = ... # type: QgsPalLayerSettings.Property
        OffsetQuad = ... # type: QgsPalLayerSettings.Property
        OffsetXY = ... # type: QgsPalLayerSettings.Property
        OffsetUnits = ... # type: QgsPalLayerSettings.Property
        LabelDistance = ... # type: QgsPalLayerSettings.Property
        MaximumDistance = ... # type: QgsPalLayerSettings.Property
        DistanceUnits = ... # type: QgsPalLayerSettings.Property
        OffsetRotation = ... # type: QgsPalLayerSettings.Property
        CurvedCharAngleInOut = ... # type: QgsPalLayerSettings.Property
        PositionX = ... # type: QgsPalLayerSettings.Property
        PositionY = ... # type: QgsPalLayerSettings.Property
        PositionPoint = ... # type: QgsPalLayerSettings.Property
        Hali = ... # type: QgsPalLayerSettings.Property
        Vali = ... # type: QgsPalLayerSettings.Property
        Rotation = ... # type: QgsPalLayerSettings.Property
        LabelRotation = ... # type: QgsPalLayerSettings.Property
        RepeatDistance = ... # type: QgsPalLayerSettings.Property
        RepeatDistanceUnit = ... # type: QgsPalLayerSettings.Property
        Priority = ... # type: QgsPalLayerSettings.Property
        PredefinedPositionOrder = ... # type: QgsPalLayerSettings.Property
        LinePlacementOptions = ... # type: QgsPalLayerSettings.Property
        OverrunDistance = ... # type: QgsPalLayerSettings.Property
        LabelAllParts = ... # type: QgsPalLayerSettings.Property
        PolygonLabelOutside = ... # type: QgsPalLayerSettings.Property
        LineAnchorPercent = ... # type: QgsPalLayerSettings.Property
        LineAnchorClipping = ... # type: QgsPalLayerSettings.Property
        LineAnchorType = ... # type: QgsPalLayerSettings.Property
        LineAnchorTextPoint = ... # type: QgsPalLayerSettings.Property
        CurvedLabelMode = ... # type: QgsPalLayerSettings.Property
        ScaleVisibility = ... # type: QgsPalLayerSettings.Property
        MinScale = ... # type: QgsPalLayerSettings.Property
        MinimumScale = ... # type: QgsPalLayerSettings.Property
        MaxScale = ... # type: QgsPalLayerSettings.Property
        MaximumScale = ... # type: QgsPalLayerSettings.Property
        FontLimitPixel = ... # type: QgsPalLayerSettings.Property
        FontMinPixel = ... # type: QgsPalLayerSettings.Property
        FontMaxPixel = ... # type: QgsPalLayerSettings.Property
        IsObstacle = ... # type: QgsPalLayerSettings.Property
        ObstacleFactor = ... # type: QgsPalLayerSettings.Property
        ZIndex = ... # type: QgsPalLayerSettings.Property
        CalloutDraw = ... # type: QgsPalLayerSettings.Property
        AllowDegradedPlacement = ... # type: QgsPalLayerSettings.Property
        OverlapHandling = ... # type: QgsPalLayerSettings.Property
        WhitespaceCollisionHandling = ... # type: QgsPalLayerSettings.Property
        LabelMarginDistance = ... # type: QgsPalLayerSettings.Property
        RemoveDuplicateLabels = ... # type: QgsPalLayerSettings.Property
        RemoveDuplicateLabelDistance = ... # type: QgsPalLayerSettings.Property
        Show = ... # type: QgsPalLayerSettings.Property
        AlwaysShow = ... # type: QgsPalLayerSettings.Property

    angleOffset = ... # type: float
    autoWrapLength = ... # type: int
    centroidInside = ... # type: bool
    centroidWhole = ... # type: bool
    ct = ... # type: 'QgsCoordinateTransform'
    decimals = ... # type: int
    dist = ... # type: float
    distMapUnitScale = ... # type: QgsMapUnitScale
    distUnits = ... # type: Qgis.RenderUnit
    drawLabels = ... # type: bool
    extentGeom = ... # type: QgsGeometry
    fieldIndex = ... # type: int
    fieldName = ... # type: str|None
    fitInPolygonOnly = ... # type: bool
    fontLimitPixelSize = ... # type: bool
    fontMaxPixelSize = ... # type: int
    fontMinPixelSize = ... # type: int
    formatNumbers = ... # type: bool
    geometryGenerator = ... # type: str|None
    geometryGeneratorEnabled = ... # type: bool
    geometryGeneratorType = ... # type: Qgis.GeometryType
    isExpression = ... # type: bool
    labelOffsetMapUnitScale = ... # type: QgsMapUnitScale
    layerType = ... # type: Qgis.GeometryType
    mCurFeat = ... # type: QgsFeature
    mCurFields = ... # type: QgsFields
    mFeatsRegPal = ... # type: int
    mFeatsSendingToPal = ... # type: int
    mFeaturesToLabel = ... # type: int
    maxCurvedCharAngleIn = ... # type: float
    maxCurvedCharAngleOut = ... # type: float
    maximumScale = ... # type: float
    minimumScale = ... # type: float
    multilineAlign = ... # type: Qgis.LabelMultiLineAlignment
    offsetType = ... # type: Qgis.LabelOffsetType
    offsetUnits = ... # type: Qgis.RenderUnit
    placement = ... # type: Qgis.LabelPlacement
    plusSign = ... # type: bool
    preserveRotation = ... # type: bool
    previewBkgrdColor = ... # type: QtGui.QColor|QtCore.Qt.GlobalColor|int
    priority = ... # type: int
    ptOne = ... # type: QgsPointXY
    ptZero = ... # type: QgsPointXY
    repeatDistance = ... # type: float
    repeatDistanceMapUnitScale = ... # type: QgsMapUnitScale
    repeatDistanceUnit = ... # type: Qgis.RenderUnit
    scaleVisibility = ... # type: bool
    substitutions = ... # type: QgsStringReplacementCollection
    upsidedownLabels = ... # type: Qgis.UpsideDownLabelHandling
    useMaxLineLengthForAutoWrap = ... # type: bool
    useSubstitutions = ... # type: bool
    wrapChar = ... # type: str|None
    xOffset = ... # type: float
    xform = ... # type: QgsMapToPixel
    yOffset = ... # type: float
    zIndex = ... # type: float

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, s: 'QgsPalLayerSettings') -> None: ...

    @staticmethod
    def fromMimeData(data: QtCore.QMimeData|None) -> typing.Tuple['QgsPalLayerSettings', bool]: ...
    def toMimeData(self) -> QtCore.QMimeData|None: ...
    def setUnplacedVisibility(self, visibility: Qgis.UnplacedLabelVisibility) -> None: ...
    def unplacedVisibility(self) -> Qgis.UnplacedLabelVisibility: ...
    @staticmethod
    def labelSettingsPreviewPixmap(settings: 'QgsPalLayerSettings', size: QtCore.QSize, previewText: str|None = ..., padding: int = ..., screen: QgsScreenProperties = ...) -> QtGui.QPixmap: ...
    def setPlacementSettings(self, settings: QgsLabelPlacementSettings) -> None: ...
    def placementSettings(self) -> QgsLabelPlacementSettings: ...
    def setThinningSettings(self, settings: QgsLabelThinningSettings) -> None: ...
    def thinningSettings(self) -> QgsLabelThinningSettings: ...
    def setObstacleSettings(self, settings: QgsLabelObstacleSettings) -> None: ...
    def obstacleSettings(self) -> QgsLabelObstacleSettings: ...
    def setPointSettings(self, settings: QgsLabelPointSettings) -> None: ...
    def pointSettings(self) -> QgsLabelPointSettings: ...
    def setLineSettings(self, settings: QgsLabelLineSettings) -> None: ...
    def lineSettings(self) -> QgsLabelLineSettings: ...
    def setCallout(self, callout: QgsCallout|None) -> None: ...
    def callout(self) -> QgsCallout|None: ...
    def setFormat(self, format: 'QgsTextFormat') -> None: ...
    def format(self) -> 'QgsTextFormat': ...
    def setDataDefinedProperties(self, collection: QgsPropertyCollection) -> None: ...
    def dataDefinedProperties(self) -> QgsPropertyCollection: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def registerFeature(self, f: QgsFeature, context: QgsRenderContext) -> None: ...
    @deprecated("""""")
    def calculateLabelSize(self, fm: QtGui.QFontMetricsF|None, text: str|None, f: QgsFeature|None = ..., context: QgsRenderContext|None = ...) -> typing.Tuple[float, float, float, float]: ...
    def legendString(self) -> str: ...
    def setLegendString(self, legendString: str|None) -> None: ...
    def setRotationUnit(self, angleUnit: Qgis.AngleUnit) -> None: ...
    def rotationUnit(self) -> Qgis.AngleUnit: ...
    def setPolygonPlacementFlags(self, flags: Qgis.LabelPolygonPlacementFlag) -> None: ...
    def polygonPlacementFlags(self) -> Qgis.LabelPolygonPlacementFlag: ...
    def getLabelExpression(self) -> QgsExpression|None: ...
    @staticmethod
    def propertyDefinitions() -> dict[int, QgsPropertyDefinition]: ...
    def containsAdvancedEffects(self) -> bool: ...
    def stopRender(self, context: QgsRenderContext) -> None: ...
    def startRender(self, context: QgsRenderContext) -> None: ...
    def referencedFields(self, context: QgsRenderContext) -> set[str]: ...
    def prepare(self, context: QgsRenderContext, attributeNames: collections.abc.Iterable[str|None], fields: QgsFields, mapSettings: QgsMapSettings, crs: 'QgsCoordinateReferenceSystem') -> typing.Tuple[bool, set[str]]: ...


class QgsPalLabeling(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsPalLabeling') -> None: ...

    @staticmethod
    def splitToGraphemes(text: str|None) -> list[str]: ...
    @staticmethod
    def splitToLines(text: str|None, wrapCharacter: str|None, autoWrapLength: int = ..., useMaxLineLengthWhenAutoWrapping: bool = ...) -> list[str]: ...
    @staticmethod
    def geometryRequiresPreparation(geometry: QgsGeometry, context: QgsRenderContext, ct: 'QgsCoordinateTransform', clipGeometry: QgsGeometry = ..., mergeLines: bool = ...) -> bool: ...
    @staticmethod
    def prepareGeometry(geometry: QgsGeometry, context: QgsRenderContext, ct: 'QgsCoordinateTransform', clipGeometry: QgsGeometry = ..., mergeLines: bool = ...) -> QgsGeometry: ...
    @staticmethod
    def staticWillUseLayer(layer: QgsMapLayer|None) -> bool: ...


class QgsAbstractVectorLayerLabeling(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    @typing.overload
    @deprecated("""""")
    def writeTextSymbolizer(self, parent: QtXml.QDomNode, settings: QgsPalLayerSettings, props: dict[str|None, typing.Any]) -> None: ...
    @typing.overload
    def writeTextSymbolizer(self, parent: QtXml.QDomNode, settings: QgsPalLayerSettings, context: QgsSldExportContext) -> bool: ...
    @staticmethod
    def defaultSettingsForLayer(layer: QgsVectorLayer|None) -> QgsPalLayerSettings: ...
    def accept(self, visitor: 'QgsStyleEntityVisitorInterface|None') -> bool: ...
    @typing.overload
    @deprecated("""""")
    def toSld(self, parent: QtXml.QDomNode, props: dict[str|None, typing.Any]) -> None: ...
    @typing.overload
    def toSld(self, parent: QtXml.QDomNode, context: QgsSldExportContext) -> bool: ...
    @staticmethod
    def create(element: QtXml.QDomElement, context: QgsReadWriteContext) -> 'QgsAbstractVectorLayerLabeling|None': ...
    def multiplyOpacity(self, opacityFactor: float) -> None: ...
    def hasNonDefaultCompositionMode(self) -> bool: ...
    def requiresAdvancedEffects(self) -> bool: ...
    def setSettings(self, settings: QgsPalLayerSettings|None, providerId: str|None = ...) -> None: ...
    def settings(self, providerId: str|None = ...) -> QgsPalLayerSettings: ...
    def subProviders(self) -> list[str]: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def clone(self) -> 'QgsAbstractVectorLayerLabeling|None': ...
    def type(self) -> str: ...


class QgsRuleBasedLabeling(QgsAbstractVectorLayerLabeling):

    class Rule(PyQt6.sip.wrapper):

        class RegisterResult(enum.IntEnum):
            Filtered = ... # type: QgsRuleBasedLabeling.Rule.RegisterResult
            Inactive = ... # type: QgsRuleBasedLabeling.Rule.RegisterResult
            Registered = ... # type: QgsRuleBasedLabeling.Rule.RegisterResult

        def __init__(self, settings: QgsPalLayerSettings|None, maximumScale: float = ..., minimumScale: float = ..., filterExp: str|None = ..., description: str|None = ..., elseRule: bool = ...) -> None: ...

        def accept(self, visitor: 'QgsStyleEntityVisitorInterface|None') -> bool: ...
        def hasNonDefaultCompositionMode(self) -> bool: ...
        def requiresAdvancedEffects(self) -> bool: ...
        def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
        @staticmethod
        def create(ruleElem: QtXml.QDomElement, context: QgsReadWriteContext, reuseId: bool = ...) -> 'QgsRuleBasedLabeling.Rule|None': ...
        def clone(self, resetRuleKey: bool = ...) -> 'QgsRuleBasedLabeling.Rule|None': ...
        def findRuleByKey(self, key: str|None) -> 'QgsRuleBasedLabeling.Rule|None': ...
        def removeChildAt(self, i: int) -> None: ...
        def insertChild(self, i: int, rule: 'QgsRuleBasedLabeling.Rule|None') -> None: ...
        def appendChild(self, rule: 'QgsRuleBasedLabeling.Rule|None') -> None: ...
        def parent(self) -> 'QgsRuleBasedLabeling.Rule|None': ...
        def descendants(self) -> list['QgsRuleBasedLabeling.Rule']: ...
        def children(self) -> list['QgsRuleBasedLabeling.Rule']: ...
        def setRuleKey(self, key: str|None) -> None: ...
        def setIsElse(self, iselse: bool) -> None: ...
        def setActive(self, state: bool) -> None: ...
        def setDescription(self, description: str|None) -> None: ...
        def setFilterExpression(self, filterExp: str|None) -> None: ...
        def setMaximumScale(self, scale: float) -> None: ...
        def setMinimumScale(self, scale: float) -> None: ...
        def setSettings(self, settings: QgsPalLayerSettings|None) -> None: ...
        def ruleKey(self) -> str: ...
        def isElse(self) -> bool: ...
        def active(self) -> bool: ...
        def description(self) -> str: ...
        def filterExpression(self) -> str: ...
        def minimumScale(self) -> float: ...
        def maximumScale(self) -> float: ...
        def dependsOnScale(self) -> bool: ...
        def settings(self) -> QgsPalLayerSettings|None: ...

    def __init__(self, root: 'QgsRuleBasedLabeling.Rule|None') -> None: ...

    def multiplyOpacity(self, opacityFactor: float) -> None: ...
    @typing.overload
    @deprecated("""""")
    def toSld(self, parent: QtXml.QDomNode, properties: dict[str|None, typing.Any]) -> None: ...
    @typing.overload
    def toSld(self, parent: QtXml.QDomNode, context: QgsSldExportContext) -> bool: ...
    def hasNonDefaultCompositionMode(self) -> bool: ...
    def requiresAdvancedEffects(self) -> bool: ...
    def setSettings(self, settings: QgsPalLayerSettings|None, providerId: str|None = ...) -> None: ...
    def accept(self, visitor: 'QgsStyleEntityVisitorInterface|None') -> bool: ...
    def settings(self, providerId: str|None = ...) -> QgsPalLayerSettings: ...
    def subProviders(self) -> list[str]: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def clone(self) -> 'QgsRuleBasedLabeling|None': ...
    def type(self) -> str: ...
    @staticmethod
    def create(element: QtXml.QDomElement, context: QgsReadWriteContext) -> 'QgsRuleBasedLabeling|None': ...
    def rootRule(self) -> 'QgsRuleBasedLabeling.Rule|None': ...


class QgsVectorLayerSimpleLabeling(QgsAbstractVectorLayerLabeling):

    def __init__(self, settings: QgsPalLayerSettings) -> None: ...

    @staticmethod
    def create(element: QtXml.QDomElement, context: QgsReadWriteContext) -> 'QgsVectorLayerSimpleLabeling|None': ...
    def multiplyOpacity(self, opacityFactor: float) -> None: ...
    @typing.overload
    @deprecated("""""")
    def toSld(self, parent: QtXml.QDomNode, props: dict[str|None, typing.Any]) -> None: ...
    @typing.overload
    def toSld(self, parent: QtXml.QDomNode, context: QgsSldExportContext) -> bool: ...
    def hasNonDefaultCompositionMode(self) -> bool: ...
    def requiresAdvancedEffects(self) -> bool: ...
    def setSettings(self, settings: QgsPalLayerSettings|None, providerId: str|None = ...) -> None: ...
    def accept(self, visitor: 'QgsStyleEntityVisitorInterface|None') -> bool: ...
    def settings(self, providerId: str|None = ...) -> QgsPalLayerSettings: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def clone(self) -> QgsAbstractVectorLayerLabeling|None: ...
    def type(self) -> str: ...


class QgsLabelingEngineContext(PyQt6.sip.wrapper):

    def __init__(self, renderContext: QgsRenderContext) -> None: ...

    def setMapBoundaryGeometry(self, geometry: QgsGeometry) -> None: ...
    def mapBoundaryGeometry(self) -> QgsGeometry: ...
    def setExtent(self, extent: QgsRectangle) -> None: ...
    def extent(self) -> QgsRectangle: ...
    def renderContext(self) -> QgsRenderContext: ...


class QgsAbstractLabelingEngineRule(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAbstractLabelingEngineRule') -> None: ...

    def copyCommonProperties(self, other: 'QgsAbstractLabelingEngineRule|None') -> None: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def prepare(self, context: QgsRenderContext) -> bool: ...
    def setActive(self, active: bool) -> None: ...
    def active(self) -> bool: ...
    def setName(self, name: str|None) -> None: ...
    def name(self) -> str: ...
    def description(self) -> str: ...
    def isAvailable(self) -> bool: ...
    def displayType(self) -> str: ...
    def id(self) -> str: ...
    def clone(self) -> 'QgsAbstractLabelingEngineRule|None': ...


class QgsAbstractLabelingEngineRuleDistanceFromFeature(QgsAbstractLabelingEngineRule):

    def __init__(self) -> None: ...

    def copyCommonProperties(self, other: QgsAbstractLabelingEngineRule|None) -> None: ...
    def setCost(self, cost: float) -> None: ...
    def cost(self) -> float: ...
    def setDistanceUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def distanceUnitScale(self) -> QgsMapUnitScale: ...
    def setDistanceUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def distanceUnit(self) -> Qgis.RenderUnit: ...
    def setDistance(self, distance: float) -> None: ...
    def distance(self) -> float: ...
    def setTargetLayer(self, layer: QgsVectorLayer|None) -> None: ...
    def targetLayer(self) -> QgsVectorLayer|None: ...
    def setLabeledLayer(self, layer: QgsMapLayer|None) -> None: ...
    def labeledLayer(self) -> QgsMapLayer|None: ...
    def isAvailable(self) -> bool: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def prepare(self, context: QgsRenderContext) -> bool: ...


class QgsLabelingEngineRuleMinimumDistanceLabelToFeature(QgsAbstractLabelingEngineRuleDistanceFromFeature):

    def __init__(self) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def description(self) -> str: ...
    def displayType(self) -> str: ...
    def id(self) -> str: ...
    def clone(self) -> 'QgsLabelingEngineRuleMinimumDistanceLabelToFeature|None': ...


class QgsLabelingEngineRuleMaximumDistanceLabelToFeature(QgsAbstractLabelingEngineRuleDistanceFromFeature):

    def __init__(self) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def description(self) -> str: ...
    def displayType(self) -> str: ...
    def id(self) -> str: ...
    def clone(self) -> 'QgsLabelingEngineRuleMaximumDistanceLabelToFeature|None': ...


class QgsLabelingEngineRuleMinimumDistanceLabelToLabel(QgsAbstractLabelingEngineRule):

    def __init__(self) -> None: ...

    def setDistanceUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def distanceUnitScale(self) -> QgsMapUnitScale: ...
    def setDistanceUnit(self, unit: Qgis.RenderUnit) -> None: ...
    def distanceUnit(self) -> Qgis.RenderUnit: ...
    def setDistance(self, distance: float) -> None: ...
    def distance(self) -> float: ...
    def setTargetLayer(self, layer: QgsMapLayer|None) -> None: ...
    def targetLayer(self) -> QgsMapLayer|None: ...
    def setLabeledLayer(self, layer: QgsMapLayer|None) -> None: ...
    def labeledLayer(self) -> QgsMapLayer|None: ...
    def __repr__(self) -> typing.Any: ...
    def prepare(self, context: QgsRenderContext) -> bool: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def isAvailable(self) -> bool: ...
    def description(self) -> str: ...
    def displayType(self) -> str: ...
    def id(self) -> str: ...
    def clone(self) -> 'QgsLabelingEngineRuleMinimumDistanceLabelToLabel|None': ...


class QgsLabelingEngineRuleAvoidLabelOverlapWithFeature(QgsAbstractLabelingEngineRule):

    def __init__(self) -> None: ...

    def setTargetLayer(self, layer: QgsVectorLayer|None) -> None: ...
    def targetLayer(self) -> QgsVectorLayer|None: ...
    def setLabeledLayer(self, layer: QgsMapLayer|None) -> None: ...
    def labeledLayer(self) -> QgsMapLayer|None: ...
    def __repr__(self) -> typing.Any: ...
    def resolveReferences(self, project: 'QgsProject|None') -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def prepare(self, context: QgsRenderContext) -> bool: ...
    def description(self) -> str: ...
    def displayType(self) -> str: ...
    def id(self) -> str: ...
    def clone(self) -> 'QgsLabelingEngineRuleAvoidLabelOverlapWithFeature|None': ...


class QgsLabelingEngineRuleRegistry(PyQt6.sip.wrapper):

    def __init__(self) -> None: ...

    def removeRule(self, id: str|None) -> None: ...
    def addRule(self, rule: QgsAbstractLabelingEngineRule|None) -> bool: ...
    def create(self, id: str|None) -> QgsAbstractLabelingEngineRule|None: ...
    def isAvailable(self, id: str|None) -> bool: ...
    def displayType(self, id: str|None) -> str: ...
    def ruleIds(self) -> list[str]: ...


class QgsLayerTreeModelLegendNode(QtCore.QObject):

    class NodeTypes(enum.IntEnum):
        SimpleLegend = ... # type: QgsLayerTreeModelLegendNode.NodeTypes
        SymbolLegend = ... # type: QgsLayerTreeModelLegendNode.NodeTypes
        RasterSymbolLegend = ... # type: QgsLayerTreeModelLegendNode.NodeTypes
        ImageLegend = ... # type: QgsLayerTreeModelLegendNode.NodeTypes
        WmsLegend = ... # type: QgsLayerTreeModelLegendNode.NodeTypes
        DataDefinedSizeLegend = ... # type: QgsLayerTreeModelLegendNode.NodeTypes
        EmbeddedWidget = ... # type: QgsLayerTreeModelLegendNode.NodeTypes
        ColorRampLegend = ... # type: QgsLayerTreeModelLegendNode.NodeTypes

    class CustomRole(enum.IntEnum):
        RuleKey = ... # type: QgsLayerTreeModelLegendNode.CustomRole
        ParentRuleKey = ... # type: QgsLayerTreeModelLegendNode.CustomRole
        NodeType = ... # type: QgsLayerTreeModelLegendNode.CustomRole
        IsDataDefinedSize = ... # type: QgsLayerTreeModelLegendNode.CustomRole

    class ItemContext(PyQt6.sip.wrapper):

        columnLeft = ... # type: float
        columnRight = ... # type: float
        context = ... # type: QgsRenderContext
        labelXOffset = ... # type: float
        maxSiblingSymbolWidth = ... # type: float
        painter = ... # type: QtGui.QPainter
        patchShape = ... # type: 'QgsLegendPatchShape'
        patchSize = ... # type: QtCore.QSizeF
        point = ... # type: QtCore.QPointF
        screenProperties = ... # type: QgsScreenProperties
        textDocument = ... # type: 'QgsTextDocument'
        textDocumentMetrics = ... # type: 'QgsTextDocumentMetrics'
        top = ... # type: float

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsLayerTreeModelLegendNode.ItemContext') -> None: ...

    class ItemMetrics(PyQt6.sip.wrapper):

        labelSize = ... # type: QtCore.QSizeF
        symbolSize = ... # type: QtCore.QSizeF

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsLayerTreeModelLegendNode.ItemMetrics') -> None: ...

    def __init__(self, nodeL: 'QgsLayerTreeLayer|None', parent: QtCore.QObject|None = ...) -> None: ...

    def createTemporaryRenderContext(self) -> QgsRenderContext|None: ...
    sizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataChanged: typing.ClassVar[QtCore.pyqtSignal]
    def toggleAllItems(self) -> None: ...
    def uncheckAllItems(self) -> None: ...
    def checkAllItems(self) -> None: ...
    def __repr__(self) -> typing.Any: ...
    def drawSymbolText(self, settings: QgsLegendSettings, ctx: 'QgsLayerTreeModelLegendNode.ItemContext|None', symbolSize: QtCore.QSizeF) -> QtCore.QSizeF: ...
    def exportSymbolToJson(self, settings: QgsLegendSettings, context: QgsRenderContext) -> dict[str, QtCore.QJsonValue]: ...
    def drawSymbol(self, settings: QgsLegendSettings, ctx: 'QgsLayerTreeModelLegendNode.ItemContext|None', itemHeight: float) -> QtCore.QSizeF: ...
    def exportToJson(self, settings: QgsLegendSettings, context: QgsRenderContext) -> dict[str, QtCore.QJsonValue]: ...
    def draw(self, settings: QgsLegendSettings, ctx: 'QgsLayerTreeModelLegendNode.ItemContext') -> 'QgsLayerTreeModelLegendNode.ItemMetrics': ...
    def invalidateMapBasedData(self) -> None: ...
    def isScaleOK(self, scale: float) -> bool: ...
    def columnBreak(self) -> bool: ...
    def setColumnBreak(self, breakBeforeNode: bool) -> None: ...
    def setUserPatchSize(self, size: QtCore.QSizeF) -> None: ...
    def userPatchSize(self) -> QtCore.QSizeF: ...
    def setUserLabel(self, userLabel: str|None) -> None: ...
    def userLabel(self) -> str: ...
    def setEmbeddedInParent(self, embedded: bool) -> None: ...
    def isEmbeddedInParent(self) -> bool: ...
    def setData(self, value: typing.Any, role: int) -> bool: ...
    def data(self, role: int) -> typing.Any: ...
    def flags(self) -> QtCore.Qt.ItemFlag: ...
    def model(self) -> 'QgsLayerTreeModel|None': ...
    def layerNode(self) -> 'QgsLayerTreeLayer|None': ...


class QgsColorRampLegendNode(QgsLayerTreeModelLegendNode):

    @typing.overload
    def __init__(self, nodeLayer: 'QgsLayerTreeLayer|None', ramp: QgsColorRamp|None, minimumLabel: str|None, maximumLabel: str|None, parent: QtCore.QObject|None = ..., key: str|None = ..., parentKey: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, nodeLayer: 'QgsLayerTreeLayer|None', ramp: QgsColorRamp|None, settings: 'QgsColorRampLegendNodeSettings', minimumValue: float, maximumValue: float, parent: QtCore.QObject|None = ..., key: str|None = ..., parentKey: str|None = ...) -> None: ...

    def maximum(self) -> float: ...
    def minimum(self) -> float: ...
    def setMaximum(self, maximum: float) -> None: ...
    def setMinimum(self, minimum: float) -> None: ...
    def setSettings(self, settings: 'QgsColorRampLegendNodeSettings') -> None: ...
    def settings(self) -> 'QgsColorRampLegendNodeSettings': ...
    def ramp(self) -> QgsColorRamp|None: ...
    def iconSize(self) -> QtCore.QSize: ...
    def setIconSize(self, size: QtCore.QSize) -> None: ...
    def exportSymbolToJson(self, settings: QgsLegendSettings, context: QgsRenderContext) -> dict[str, QtCore.QJsonValue]: ...
    def drawSymbolText(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext|None, symbolSize: QtCore.QSizeF) -> QtCore.QSizeF: ...
    def drawSymbol(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext|None, itemHeight: float) -> QtCore.QSizeF: ...
    def data(self, role: int) -> typing.Any: ...


class QgsColorRampLegendNodeSettings(PyQt6.sip.wrapper):

    class Direction(enum.IntEnum):
        MinimumToMaximum = ... # type: QgsColorRampLegendNodeSettings.Direction
        MaximumToMinimum = ... # type: QgsColorRampLegendNodeSettings.Direction

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsColorRampLegendNodeSettings') -> None: ...

    def setUseContinuousLegend(self, useContinuousLegend: bool) -> None: ...
    def useContinuousLegend(self) -> bool: ...
    def setOrientation(self, orientation: QtCore.Qt.Orientation) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setTextFormat(self, format: 'QgsTextFormat') -> None: ...
    def textFormat(self) -> 'QgsTextFormat': ...
    def setSuffix(self, suffix: str|None) -> None: ...
    def suffix(self) -> str: ...
    def setPrefix(self, prefix: str|None) -> None: ...
    def prefix(self) -> str: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def setNumericFormat(self, format: 'QgsNumericFormat|None') -> None: ...
    def numericFormat(self) -> 'QgsNumericFormat|None': ...
    def setMaximumLabel(self, label: str|None) -> None: ...
    def maximumLabel(self) -> str: ...
    def setMinimumLabel(self, label: str|None) -> None: ...
    def minimumLabel(self) -> str: ...
    def setDirection(self, direction: 'QgsColorRampLegendNodeSettings.Direction') -> None: ...
    def direction(self) -> 'QgsColorRampLegendNodeSettings.Direction': ...


class QgsLayerTreeNode(QtCore.QObject):

    class NodeType(enum.IntEnum):
        NodeGroup = ... # type: QgsLayerTreeNode.NodeType
        NodeLayer = ... # type: QgsLayerTreeNode.NodeType
        NodeCustom = ... # type: QgsLayerTreeNode.NodeType

    @typing.overload
    def __init__(self, t: 'QgsLayerTreeNode.NodeType', checked: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsLayerTreeNode') -> None: ...

    def removeChildrenPrivate(self, from_: int, count: int, destroy: bool = ...) -> None: ...
    def insertChildrenPrivate(self, index: int, nodes: collections.abc.Iterable['QgsLayerTreeNode']) -> None: ...
    def writeCommonXml(self, element: QtXml.QDomElement) -> None: ...
    def readCommonXml(self, element: QtXml.QDomElement) -> None: ...
    nameChanged: typing.ClassVar[QtCore.pyqtSignal]
    expandedChanged: typing.ClassVar[QtCore.pyqtSignal]
    customPropertyChanged: typing.ClassVar[QtCore.pyqtSignal]
    visibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    removedChildren: typing.ClassVar[QtCore.pyqtSignal]
    willRemoveChildren: typing.ClassVar[QtCore.pyqtSignal]
    addedChildren: typing.ClassVar[QtCore.pyqtSignal]
    willAddChildren: typing.ClassVar[QtCore.pyqtSignal]
    def takeChild(self, node: 'QgsLayerTreeNode|None') -> bool: ...
    def customProperties(self) -> list[str]: ...
    def removeCustomProperty(self, key: str|None) -> None: ...
    def customProperty(self, key: str|None, defaultValue: typing.Any = ...) -> typing.Any: ...
    def setCustomProperty(self, key: str|None, value: typing.Any) -> None: ...
    def setExpanded(self, expanded: bool) -> None: ...
    def isExpanded(self) -> bool: ...
    def depth(self) -> int: ...
    def checkedLayers(self) -> list[QgsMapLayer]: ...
    def isItemVisibilityUncheckedRecursive(self) -> bool: ...
    def isItemVisibilityCheckedRecursive(self) -> bool: ...
    def setItemVisibilityCheckedParentRecursive(self, checked: bool) -> None: ...
    def setItemVisibilityCheckedRecursive(self, checked: bool) -> None: ...
    def setItemVisibilityChecked(self, checked: bool) -> None: ...
    def itemVisibilityChecked(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def resolveReferences(self, project: 'QgsProject|None', looseMatching: bool = ...) -> None: ...
    def clone(self) -> 'QgsLayerTreeNode|None': ...
    def dump(self) -> str: ...
    def writeXml(self, parentElement: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    @typing.overload
    @staticmethod
    def readXml(element: QtXml.QDomElement, context: QgsReadWriteContext) -> 'QgsLayerTreeNode|None': ...
    @typing.overload
    @staticmethod
    def readXml(element: QtXml.QDomElement, project: 'QgsProject|None') -> 'QgsLayerTreeNode|None': ...
    def setName(self, name: str|None) -> None: ...
    def name(self) -> str: ...
    def children(self) -> list['QgsLayerTreeNode']: ...
    def parent(self) -> 'QgsLayerTreeNode|None': ...
    def nodeType(self) -> 'QgsLayerTreeNode.NodeType': ...
    def __getitem__(self, index: int) -> 'QgsLayerTreeNode': ...
    def __len__(self) -> int: ...
    def __repr__(self) -> typing.Any: ...


class QgsLayerTreeGroup(QgsLayerTreeNode):

    def __init__(self, name: str|None = ..., checked: bool = ...) -> None: ...

    def updateChildVisibilityMutuallyExclusive(self) -> None: ...
    def nodeVisibilityChanged(self, node: QgsLayerTreeNode|None) -> None: ...
    def hasWmsTimeDimension(self) -> bool: ...
    def setHasWmsTimeDimension(self, hasWmsTimeDimension: bool) -> None: ...
    def serverProperties(self) -> QgsMapLayerServerProperties|None: ...
    def convertToGroupLayer(self, options: QgsGroupLayer.LayerOptions) -> QgsGroupLayer|None: ...
    def setGroupLayer(self, layer: QgsGroupLayer|None) -> None: ...
    def groupLayer(self) -> QgsGroupLayer|None: ...
    def setIsMutuallyExclusive(self, enabled: bool, initialChildIndex: int = ...) -> None: ...
    def isMutuallyExclusive(self) -> bool: ...
    def setItemVisibilityCheckedRecursive(self, checked: bool) -> None: ...
    def resolveReferences(self, project: 'QgsProject|None', looseMatching: bool = ...) -> None: ...
    def clone(self) -> 'QgsLayerTreeGroup|None': ...
    def dump(self) -> str: ...
    def readChildrenFromXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, parentElement: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    @typing.overload
    @staticmethod
    def readXml(element: QtXml.QDomElement, context: QgsReadWriteContext) -> 'QgsLayerTreeGroup|None': ...
    @typing.overload
    @staticmethod
    def readXml(element: QtXml.QDomElement, project: 'QgsProject|None', context: QgsReadWriteContext) -> 'QgsLayerTreeGroup|None': ...
    def findGroups(self, recursive: bool = ...) -> list['QgsLayerTreeGroup']: ...
    def findGroup(self, name: str|None) -> 'QgsLayerTreeGroup|None': ...
    def findCustomNodeIds(self) -> list[str]: ...
    def findLayerIds(self) -> list[str]: ...
    def reorderGroupLayersAndCustomNodes(self, order: collections.abc.Iterable[QgsLayerTreeNode]) -> None: ...
    def reorderGroupLayers(self, order: collections.abc.Iterable[QgsMapLayer]) -> None: ...
    def findLayersAndCustomNodes(self) -> list[QgsLayerTreeNode]: ...
    def findCustomNode(self, id: str|None) -> 'QgsLayerTreeCustomNode|None': ...
    def findLayers(self) -> list['QgsLayerTreeLayer']: ...
    @typing.overload
    def findLayer(self, layer: QgsMapLayer|None) -> 'QgsLayerTreeLayer|None': ...
    @typing.overload
    def findLayer(self, layerId: str|None) -> 'QgsLayerTreeLayer|None': ...
    def removeAllChildren(self) -> None: ...
    def removeChildrenGroupWithoutLayers(self) -> None: ...
    def removeChildren(self, from_: int, count: int) -> None: ...
    def removeCustomNode(self, id: str|None) -> None: ...
    def removeLayer(self, layer: QgsMapLayer|None) -> None: ...
    def removeChildNode(self, node: QgsLayerTreeNode|None) -> None: ...
    def addChildNode(self, node: QgsLayerTreeNode|None) -> None: ...
    def insertChildNode(self, index: int, node: QgsLayerTreeNode|None) -> None: ...
    def insertChildNodes(self, index: int, nodes: collections.abc.Iterable[QgsLayerTreeNode]) -> None: ...
    def addCustomNode(self, id: str|None, name: str|None = ...) -> 'QgsLayerTreeCustomNode|None': ...
    @typing.overload
    def insertCustomNode(self, index: int, id: str|None, name: str|None = ...) -> 'QgsLayerTreeCustomNode|None': ...
    @typing.overload
    def insertCustomNode(self, index: int, node: 'QgsLayerTreeCustomNode|None') -> 'QgsLayerTreeCustomNode|None': ...
    def addLayer(self, layer: QgsMapLayer|None) -> 'QgsLayerTreeLayer|None': ...
    def insertLayer(self, index: int, layer: QgsMapLayer|None) -> 'QgsLayerTreeLayer|None': ...
    def addGroup(self, name: str|None) -> 'QgsLayerTreeGroup|None': ...
    def insertGroup(self, index: int, name: str|None) -> 'QgsLayerTreeGroup|None': ...
    def setName(self, n: str|None) -> None: ...
    def name(self) -> str: ...
    def __repr__(self) -> typing.Any: ...


class QgsLayerTree(QgsLayerTreeGroup):

    def __init__(self) -> None: ...

    hasCustomLayerOrderChanged: typing.ClassVar[QtCore.pyqtSignal]
    layerOrderChanged: typing.ClassVar[QtCore.pyqtSignal]
    customLayerOrderChanged: typing.ClassVar[QtCore.pyqtSignal]
    def clear(self) -> None: ...
    def clone(self) -> 'QgsLayerTree|None': ...
    def writeXml(self, parentElement: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def readLayerOrderFromXml(self, doc: QtXml.QDomElement) -> None: ...
    @staticmethod
    def readXml(element: QtXml.QDomElement, context: QgsReadWriteContext) -> 'QgsLayerTree'|None: ...
    def layerAndCustomNodeOrder(self) -> list[QgsLayerTreeNode]: ...
    def setHasCustomLayerOrder(self, hasCustomLayerOrder: bool) -> None: ...
    def hasCustomLayerOrder(self) -> bool: ...
    def layerOrder(self) -> list[QgsMapLayer]: ...
    def setCustomLayerOrderByIds(self, customLayerOrder: collections.abc.Iterable[str|None]) -> None: ...
    def setCustomLayerOrder(self, customLayerOrder: collections