/***************************************************************************
  qgsactionwidgetwrapper.h - QgsActionWidgetWrapper

 ---------------------
 begin                : 14.8.2021
 copyright            : (C) 2021 by Alessandro Pasotti
 email                : elpaso at itopen dot it
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef QGSACTIONWIDGETWRAPPER_H
#define QGSACTIONWIDGETWRAPPER_H

#include "qgis_gui.h"
#include "qgis_sip.h"
#include "qgsaction.h"
#include "qgswidgetwrapper.h"

#include <QPushButton>

class QgsMessageBar;

/**
 * \ingroup gui
 * \brief Wraps a button widget to launch a layer action.
 * \since QGIS 3.22
 */
class GUI_EXPORT QgsActionWidgetWrapper : public QgsWidgetWrapper
{
    Q_OBJECT

  public:
    /**
     * Create an action widget wrapper
     *
     * \param layer      The layer on which the feature is.
     * \param editor     An editor widget. Can be NULLPTR if one should be autogenerated.
     * \param parent     A parent widget.
     * \param messageBar A message bar used to provide feedback.
     */
    QgsActionWidgetWrapper( QgsVectorLayer *layer, QWidget *editor, QWidget *parent, QgsMessageBar *messageBar = nullptr );

  public:
    /**
     * Sets the \a action.
     */
    void setAction( const QgsAction &action );

    // QgsWidgetWrapper interface
    bool valid() const override;
    QWidget *createWidget( QWidget *parent ) override;
    void initWidget( QWidget *editor ) override;

  public slots:

    void setFeature( const QgsFeature &feature ) override;
    void setEnabled( bool enabled ) override;

  private:
    QgsMessageBar *mMessageBar = nullptr;
    QPushButton *mActionButton = nullptr;
    QgsAction mAction;
    QgsFeature mFeature;
};

#endif // QGSACTIONWIDGETWRAPPER_H
